import{s as lt,o as pt,n as dt}from"../chunks/scheduler.888833de.js";import{S as ct,i as mt,e as i,s as a,c as m,h as ft,a as r,d as n,b as s,f as re,g as f,j as p,k as ae,l as b,m as o,n as u,t as h,o as g,p as _}from"../chunks/index.128ce987.js";import{D as ze}from"../chunks/Docstring.23ed6b62.js";import{C as se}from"../chunks/CodeBlock.37df032e.js";import{E as ut}from"../chunks/ExampleCodeBlock.6d7ae280.js";import{H as Ge,E as ht}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function gt(le){let d,Z="Examples:",M,T,y;return T=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTGF0dGVQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTBBJTBBJTIzJTIwWW91JTIwY2FuJTIwcmVwbGFjZSUyMHRoZSUyMGNoZWNrcG9pbnQlMjBpZCUyMHdpdGglMjAlMjJtYXhpbi1jbiUyRkxhdHRlLTElMjIlMjB0b28uJTBBcGlwZSUyMCUzRCUyMExhdHRlUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMm1heGluLWNuJTJGTGF0dGUtMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMjMlMjBFbmFibGUlMjBtZW1vcnklMjBvcHRpbWl6YXRpb25zLiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwc21hbGwlMjBjYWN0dXMlMjB3aXRoJTIwYSUyMGhhcHB5JTIwZmFjZSUyMGluJTIwdGhlJTIwU2FoYXJhJTIwZGVzZXJ0LiUyMiUwQXZpZGVvcyUyMCUzRCUyMHBpcGUocHJvbXB0KS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZih2aWRlb3MlMkMlMjAlMjJsYXR0ZS5naWYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LattePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can replace the checkpoint id with &quot;maxin-cn/Latte-1&quot; too.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LattePipeline.from_pretrained(<span class="hljs-string">&quot;maxin-cn/Latte-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable memory optimizations.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A small cactus with a happy face in the Sahara desert.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>videos = pipe(prompt).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(videos, <span class="hljs-string">&quot;latte.gif&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=Z,M=a(),m(T.$$.fragment)},l(l){d=r(l,"P",{"data-svelte-h":!0}),p(d)!=="svelte-kvfsh7"&&(d.textContent=Z),M=s(l),f(T.$$.fragment,l)},m(l,w){o(l,d,w),o(l,M,w),u(T,l,w),y=!0},p:dt,i(l){y||(h(T.$$.fragment,l),y=!0)},o(l){g(T.$$.fragment,l),y=!1},d(l){l&&(n(d),n(M)),_(T,l)}}}function _t(le){let d,Z,M,T,y,l,w,He='<img src="https://github.com/Vchitect/Latte/blob/52bc0029899babbd6e9250384c83d8ed2670ff7a/visuals/latte.gif?raw=true" alt="latte text-to-video"/>',pe,j,Ve='<a href="https://huggingface.co/papers/2401.03048" rel="nofollow">Latte: Latent Diffusion Transformer for Video Generation</a> from Monash University, Shanghai AI Lab, Nanjing University, and Nanyang Technological University.',de,k,qe="The abstract from the paper is:",ce,$,Ee="<em>We propose a novel Latent Diffusion Transformer, namely Latte, for video generation. Latte first extracts spatio-temporal tokens from input videos and then adopts a series of Transformer blocks to model video distribution in the latent space. In order to model a substantial number of tokens extracted from videos, four efficient variants are introduced from the perspective of decomposing the spatial and temporal dimensions of input videos. To improve the quality of generated videos, we determine the best practices of Latte through rigorous experimental analysis, including video clip patch embedding, model variants, timestep-class information injection, temporal positional embedding, and learning strategies. Our comprehensive evaluation demonstrates that Latte achieves state-of-the-art performance across four standard video generation datasets, i.e., FaceForensics, SkyTimelapse, UCF101, and Taichi-HD. In addition, we extend Latte to text-to-video generation (T2V) task, where Latte achieves comparable results compared to recent T2V models. We strongly believe that Latte provides valuable insights for future research on incorporating Transformers into diffusion models for video generation.</em>",me,I,Ye='<strong>Highlights</strong>: Latte is a latent diffusion transformer proposed as a backbone for modeling different modalities (trained for text-to-video generation here). It achieves state-of-the-art performance across four standard video benchmarks - <a href="https://huggingface.co/papers/1803.09179" rel="nofollow">FaceForensics</a>, <a href="https://huggingface.co/papers/1709.07592" rel="nofollow">SkyTimelapse</a>, <a href="https://huggingface.co/papers/1212.0402" rel="nofollow">UCF101</a> and <a href="https://huggingface.co/papers/2003.00196" rel="nofollow">Taichi-HD</a>. To prepare and download the datasets for evaluation, please refer to <a href="https://github.com/Vchitect/Latte/blob/main/docs/datasets_evaluation.md" rel="nofollow">this https URL</a>.',fe,B,Se='This pipeline was contributed by <a href="https://github.com/maxin-cn" rel="nofollow">maxin-cn</a>. The original codebase can be found <a href="https://github.com/Vchitect/Latte" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/maxin-cn" rel="nofollow">hf.co/maxin-cn</a>.',ue,x,De='<p>Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.</p>',he,C,ge,G,Ae='Use <a href="https://huggingface.co/docs/diffusers/main/en/tutorials/fast_diffusion#torchcompile" rel="nofollow"><code>torch.compile</code></a> to reduce the inference latency.',_e,W,Ke="First, load the pipeline:",be,P,ve,X,Oe="Then change the memory layout of the pipelines <code>transformer</code> and <code>vae</code> components to <code>torch.channels-last</code>:",Te,F,ye,N,et="Finally, compile the components and run inference:",we,R,Me,Q,tt='The <a href="https://gist.github.com/a-r-r-o-w/4e1694ca46374793c0361d740a99ff19" rel="nofollow">benchmark</a> results on an 80GB A100 machine are:',Je,z,xe,H,Le,V,nt="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",Ue,q,ot='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/latte#diffusers.LattePipeline">LattePipeline</a> for inference with bitsandbytes.',Ze,E,je,Y,ke,c,S,We,O,at="Pipeline for text-to-video generation using Latte.",Pe,ee,st=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Xe,J,D,Fe,te,it="Function invoked when calling the pipeline for generation.",Ne,L,Re,U,A,Qe,ne,rt="Encodes the prompt into text encoder hidden states.",$e,K,Ie,ie,Be;return y=new Ge({props:{title:"Latte",local:"latte",headingTag:"h1"}}),C=new Ge({props:{title:"Inference",local:"inference",headingTag:"h3"}}),P=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTGF0dGVQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwTGF0dGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTA5JTIybWF4aW4tY24lMkZMYXR0ZS0xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LattePipeline

pipeline = LattePipeline.from_pretrained(
	<span class="hljs-string">&quot;maxin-cn/Latte-1&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),F=new se({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBcGlwZWxpbmUudmFlLnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KQ==",highlighted:`pipeline.transformer.to(memory_format=torch.channels_last)
pipeline.vae.to(memory_format=torch.channels_last)`,wrap:!1}}),R=new se({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGVsaW5lLnRyYW5zZm9ybWVyKSUwQXBpcGVsaW5lLnZhZS5kZWNvZGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGVsaW5lLnZhZS5kZWNvZGUpJTBBJTBBdmlkZW8lMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0QlMjJBJTIwZG9nJTIwd2VhcmluZyUyMHN1bmdsYXNzZXMlMjBmbG9hdGluZyUyMGluJTIwc3BhY2UlMkMlMjBzdXJyZWFsJTJDJTIwbmVidWxhZSUyMGluJTIwYmFja2dyb3VuZCUyMikuZnJhbWVzJTVCMCU1RA==",highlighted:`pipeline.transformer = torch.<span class="hljs-built_in">compile</span>(pipeline.transformer)
pipeline.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipeline.vae.decode)

video = pipeline(prompt=<span class="hljs-string">&quot;A dog wearing sunglasses floating in space, surreal, nebulae in background&quot;</span>).frames[<span class="hljs-number">0</span>]`,wrap:!1}}),z=new se({props:{code:"V2l0aG91dCUyMHRvcmNoLmNvbXBpbGUoKSUzQSUyMEF2ZXJhZ2UlMjBpbmZlcmVuY2UlMjB0aW1lJTNBJTIwMTYuMjQ2JTIwc2Vjb25kcy4lMEFXaXRoJTIwdG9yY2guY29tcGlsZSgpJTNBJTIwQXZlcmFnZSUyMGluZmVyZW5jZSUyMHRpbWUlM0ElMjAxNC41NzMlMjBzZWNvbmRzLg==",highlighted:`<span class="hljs-attribute">Without</span> torch.compile(): Average inference time: <span class="hljs-number">16</span>.<span class="hljs-number">246</span> seconds.
<span class="hljs-attribute">With</span> torch.compile(): Average inference time: <span class="hljs-number">14</span>.<span class="hljs-number">573</span> seconds.`,wrap:!1}}),H=new Ge({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),E=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBMYXR0ZVRyYW5zZm9ybWVyM0RNb2RlbCUyQyUyMExhdHRlUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX2dpZiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMjBhcyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyQyUyMFQ1RW5jb2Rlck1vZGVsJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdGV4dF9lbmNvZGVyXzhiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWF4aW4tY24lMkZMYXR0ZS0xJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSklMEF0cmFuc2Zvcm1lcl84Yml0JTIwJTNEJTIwTGF0dGVUcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1heGluLWNuJTJGTGF0dGUtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMExhdHRlUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1heGluLWNuJTJGTGF0dGUtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2Rlcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTJDJTBBKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBzbWFsbCUyMGNhY3R1cyUyMHdpdGglMjBhJTIwaGFwcHklMjBmYWNlJTIwaW4lMjB0aGUlMjBTYWhhcmElMjBkZXNlcnQuJTIyJTBBdmlkZW8lMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKHZpZGVvJTJDJTIwJTIybGF0dGUuZ2lmJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, LatteTransformer3DModel, LattePipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;maxin-cn/Latte-1&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = LatteTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;maxin-cn/Latte-1&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = LattePipeline.from_pretrained(
    <span class="hljs-string">&quot;maxin-cn/Latte-1&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;A small cactus with a happy face in the Sahara desert.&quot;</span>
video = pipeline(prompt).frames[<span class="hljs-number">0</span>]
export_to_gif(video, <span class="hljs-string">&quot;latte.gif&quot;</span>)`,wrap:!1}}),Y=new Ge({props:{title:"LattePipeline",local:"diffusers.LattePipeline",headingTag:"h2"}}),S=new ze({props:{name:"class diffusers.LattePipeline",anchor:"diffusers.LattePipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKL"},{name:"transformer",val:": LatteTransformer3DModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.LattePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.LattePipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Latte uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LattePipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LattePipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/latte_transformer3d#diffusers.LatteTransformer3DModel">LatteTransformer3DModel</a>) &#x2014;
A text conditioned <code>LatteTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.LattePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/latte/pipeline_latte.py#L145"}}),D=new ze({props:{name:"__call__",anchor:"diffusers.LattePipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"num_images_per_prompt",val:": int = 1"},{name:"video_length",val:": int = 16"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"clean_caption",val:": bool = True"},{name:"mask_feature",val:": bool = True"},{name:"enable_temporal_attentions",val:": bool = True"},{name:"decode_chunk_size",val:": int = 14"}],parametersDescription:[{anchor:"diffusers.LattePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the video generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.LattePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the video generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LattePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.LattePipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps are used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.LattePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate videos that are closely linked to
the text <code>prompt</code>, usually at the expense of lower video quality.`,name:"guidance_scale"},{anchor:"diffusers.LattePipeline.__call__.video_length",description:`<strong>video_length</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds`,name:"video_length"},{anchor:"diffusers.LattePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.LattePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.LattePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.LattePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">https://huggingface.co/papers/2010.02502</a>. Only
applies to <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.LattePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LattePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.LattePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LattePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For Latte this negative prompt should be &quot;&quot;. If not provided,
negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LattePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate video. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LattePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LattePipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable[[int, int, Dict], None]</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A callback function or a list of callback functions to be called at the end of each denoising step.`,name:"callback_on_step_end"},{anchor:"diffusers.LattePipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of tensor inputs that should be passed to the callback function. If not defined, all tensor
inputs will be passed.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.LattePipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.LattePipeline.__call__.mask_feature",description:"<strong>mask_feature</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014; If set to <code>True</code>, the text embeddings will be masked.",name:"mask_feature"},{anchor:"diffusers.LattePipeline.__call__.enable_temporal_attentions",description:"<strong>enable_temporal_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to enable temporal attentions",name:"enable_temporal_attentions"},{anchor:"diffusers.LattePipeline.__call__.decode_chunk_size",description:`<strong>decode_chunk_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of frames to decode at a time. Higher chunk size leads to better temporal consistency at the
expense of more memory usage. By default, the decoder decodes all frames at once for maximal quality.
For lower memory usage, reduce <code>decode_chunk_size</code>.`,name:"decode_chunk_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/latte/pipeline_latte.py#L613",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>LattePipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>LattePipelineOutput</code> or <code>tuple</code></p>
`}}),L=new ut({props:{anchor:"diffusers.LattePipeline.__call__.example",$$slots:{default:[gt]},$$scope:{ctx:le}}}),A=new ze({props:{name:"encode_prompt",anchor:"diffusers.LattePipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"mask_feature",val:": bool = True"},{name:"dtype",val:" = None"}],parametersDescription:[{anchor:"diffusers.LattePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.LattePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the video generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
Latte, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.LattePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.LattePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of video that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.LattePipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.LattePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LattePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For Latte, it&#x2019;s should be the embeddings of the &quot;&quot; string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LattePipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (bool, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.LattePipeline.encode_prompt.mask_feature",description:`<strong>mask_feature</strong> &#x2014; (bool, defaults to <code>True</code>):
If <code>True</code>, the function will mask the text embeddings.`,name:"mask_feature"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/latte/pipeline_latte.py#L206"}}),K=new ht({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/latte.md"}}),{c(){d=i("meta"),Z=a(),M=i("p"),T=a(),m(y.$$.fragment),l=a(),w=i("p"),w.innerHTML=He,pe=a(),j=i("p"),j.innerHTML=Ve,de=a(),k=i("p"),k.textContent=qe,ce=a(),$=i("p"),$.innerHTML=Ee,me=a(),I=i("p"),I.innerHTML=Ye,fe=a(),B=i("p"),B.innerHTML=Se,ue=a(),x=i("blockquote"),x.innerHTML=De,he=a(),m(C.$$.fragment),ge=a(),G=i("p"),G.innerHTML=Ae,_e=a(),W=i("p"),W.textContent=Ke,be=a(),m(P.$$.fragment),ve=a(),X=i("p"),X.innerHTML=Oe,Te=a(),m(F.$$.fragment),ye=a(),N=i("p"),N.textContent=et,we=a(),m(R.$$.fragment),Me=a(),Q=i("p"),Q.innerHTML=tt,Je=a(),m(z.$$.fragment),xe=a(),m(H.$$.fragment),Le=a(),V=i("p"),V.textContent=nt,Ue=a(),q=i("p"),q.innerHTML=ot,Ze=a(),m(E.$$.fragment),je=a(),m(Y.$$.fragment),ke=a(),c=i("div"),m(S.$$.fragment),We=a(),O=i("p"),O.textContent=at,Pe=a(),ee=i("p"),ee.innerHTML=st,Xe=a(),J=i("div"),m(D.$$.fragment),Fe=a(),te=i("p"),te.textContent=it,Ne=a(),m(L.$$.fragment),Re=a(),U=i("div"),m(A.$$.fragment),Qe=a(),ne=i("p"),ne.textContent=rt,$e=a(),m(K.$$.fragment),Ie=a(),ie=i("p"),this.h()},l(e){const t=ft("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(n),Z=s(e),M=r(e,"P",{}),re(M).forEach(n),T=s(e),f(y.$$.fragment,e),l=s(e),w=r(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1bd7mp4"&&(w.innerHTML=He),pe=s(e),j=r(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-qqql9f"&&(j.innerHTML=Ve),de=s(e),k=r(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1cwsb16"&&(k.textContent=qe),ce=s(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-12ap5po"&&($.innerHTML=Ee),me=s(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1grsw2n"&&(I.innerHTML=Ye),fe=s(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-66m9gt"&&(B.innerHTML=Se),ue=s(e),x=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(x)!=="svelte-r1jcqf"&&(x.innerHTML=De),he=s(e),f(C.$$.fragment,e),ge=s(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-iekg51"&&(G.innerHTML=Ae),_e=s(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-jub7f1"&&(W.textContent=Ke),be=s(e),f(P.$$.fragment,e),ve=s(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-4294wb"&&(X.innerHTML=Oe),Te=s(e),f(F.$$.fragment,e),ye=s(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-9i4prs"&&(N.textContent=et),we=s(e),f(R.$$.fragment,e),Me=s(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-xadg5n"&&(Q.innerHTML=tt),Je=s(e),f(z.$$.fragment,e),xe=s(e),f(H.$$.fragment,e),Le=s(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ou2pxc"&&(V.textContent=nt),Ue=s(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-o3gwi6"&&(q.innerHTML=ot),Ze=s(e),f(E.$$.fragment,e),je=s(e),f(Y.$$.fragment,e),ke=s(e),c=r(e,"DIV",{class:!0});var v=re(c);f(S.$$.fragment,v),We=s(v),O=r(v,"P",{"data-svelte-h":!0}),p(O)!=="svelte-5dgzru"&&(O.textContent=at),Pe=s(v),ee=r(v,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-wu1jmh"&&(ee.innerHTML=st),Xe=s(v),J=r(v,"DIV",{class:!0});var oe=re(J);f(D.$$.fragment,oe),Fe=s(oe),te=r(oe,"P",{"data-svelte-h":!0}),p(te)!=="svelte-v78lg8"&&(te.textContent=it),Ne=s(oe),f(L.$$.fragment,oe),oe.forEach(n),Re=s(v),U=r(v,"DIV",{class:!0});var Ce=re(U);f(A.$$.fragment,Ce),Qe=s(Ce),ne=r(Ce,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-16q0ax1"&&(ne.textContent=rt),Ce.forEach(n),v.forEach(n),$e=s(e),f(K.$$.fragment,e),Ie=s(e),ie=r(e,"P",{}),re(ie).forEach(n),this.h()},h(){ae(d,"name","hf:doc:metadata"),ae(d,"content",bt),ae(x,"class","tip"),ae(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ae(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ae(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){b(document.head,d),o(e,Z,t),o(e,M,t),o(e,T,t),u(y,e,t),o(e,l,t),o(e,w,t),o(e,pe,t),o(e,j,t),o(e,de,t),o(e,k,t),o(e,ce,t),o(e,$,t),o(e,me,t),o(e,I,t),o(e,fe,t),o(e,B,t),o(e,ue,t),o(e,x,t),o(e,he,t),u(C,e,t),o(e,ge,t),o(e,G,t),o(e,_e,t),o(e,W,t),o(e,be,t),u(P,e,t),o(e,ve,t),o(e,X,t),o(e,Te,t),u(F,e,t),o(e,ye,t),o(e,N,t),o(e,we,t),u(R,e,t),o(e,Me,t),o(e,Q,t),o(e,Je,t),u(z,e,t),o(e,xe,t),u(H,e,t),o(e,Le,t),o(e,V,t),o(e,Ue,t),o(e,q,t),o(e,Ze,t),u(E,e,t),o(e,je,t),u(Y,e,t),o(e,ke,t),o(e,c,t),u(S,c,null),b(c,We),b(c,O),b(c,Pe),b(c,ee),b(c,Xe),b(c,J),u(D,J,null),b(J,Fe),b(J,te),b(J,Ne),u(L,J,null),b(c,Re),b(c,U),u(A,U,null),b(U,Qe),b(U,ne),o(e,$e,t),u(K,e,t),o(e,Ie,t),o(e,ie,t),Be=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),L.$set(v)},i(e){Be||(h(y.$$.fragment,e),h(C.$$.fragment,e),h(P.$$.fragment,e),h(F.$$.fragment,e),h(R.$$.fragment,e),h(z.$$.fragment,e),h(H.$$.fragment,e),h(E.$$.fragment,e),h(Y.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),Be=!0)},o(e){g(y.$$.fragment,e),g(C.$$.fragment,e),g(P.$$.fragment,e),g(F.$$.fragment,e),g(R.$$.fragment,e),g(z.$$.fragment,e),g(H.$$.fragment,e),g(E.$$.fragment,e),g(Y.$$.fragment,e),g(S.$$.fragment,e),g(D.$$.fragment,e),g(L.$$.fragment,e),g(A.$$.fragment,e),g(K.$$.fragment,e),Be=!1},d(e){e&&(n(Z),n(M),n(T),n(l),n(w),n(pe),n(j),n(de),n(k),n(ce),n($),n(me),n(I),n(fe),n(B),n(ue),n(x),n(he),n(ge),n(G),n(_e),n(W),n(be),n(ve),n(X),n(Te),n(ye),n(N),n(we),n(Me),n(Q),n(Je),n(xe),n(Le),n(V),n(Ue),n(q),n(Ze),n(je),n(ke),n(c),n($e),n(Ie),n(ie)),n(d),_(y,e),_(C,e),_(P,e),_(F,e),_(R,e),_(z,e),_(H,e),_(E,e),_(Y,e),_(S),_(D),_(L),_(A),_(K,e)}}}const bt='{"title":"Latte","local":"latte","sections":[{"title":"Inference","local":"inference","sections":[],"depth":3},{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"LattePipeline","local":"diffusers.LattePipeline","sections":[],"depth":2}],"depth":1}';function vt(le){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends ct{constructor(d){super(),mt(this,d,vt,_t,lt,{})}}export{Lt as component};
