import{s as Hs,o as Ws,n as we}from"../chunks/scheduler.888833de.js";import{S as Ss,i as Vs,e as s,s as n,c as h,h as Ns,a,d as r,b as i,f as T,g,j as d,k as M,l as t,m as u,n as b,t as _,o as v,p as y}from"../chunks/index.128ce987.js";import{D as k}from"../chunks/Docstring.23ed6b62.js";import{C as $e}from"../chunks/CodeBlock.37df032e.js";import{E as xe}from"../chunks/ExampleCodeBlock.6d7ae280.js";import{H as Oo,E as Fs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function Bs(U){let l,C="Examples:",w,c,x;return c=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBaW1nMmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMpJTBBaW5wYWludCUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){l=s("p"),l.textContent=C,w=n(),h(c.$$.fragment)},l(o){l=a(o,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=C),w=i(o),g(c.$$.fragment,o)},m(o,$){u(o,l,$),u(o,w,$),b(c,o,$),x=!0},p:we,i(o){x||(_(c.$$.fragment,o),x=!0)},o(o){v(c.$$.fragment,o),x=!1},d(o){o&&(r(l),r(w)),y(c,o)}}}function Xs(U){let l,C="Examples:",w,c,x;return c=new $e({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=s("p"),l.textContent=C,w=n(),h(c.$$.fragment)},l(o){l=a(o,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=C),w=i(o),g(c.$$.fragment,o)},m(o,$){u(o,l,$),u(o,w,$),b(c,o,$),x=!0},p:we,i(o){x||(_(c.$$.fragment,o),x=!0)},o(o){v(c.$$.fragment,o),x=!1},d(o){o&&(r(l),r(w)),y(c,o)}}}function Rs(U){let l,C="Example:",w,c,x;return c=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEElMEFwaXBlLmVuYWJsZV9ncm91cF9vZmZsb2FkKCUwQSUyMCUyMCUyMCUyMG9ubG9hZF9kZXZpY2UlM0R0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMkMlMEElMjAlMjAlMjAlMjBvZmZsb2FkX2RldmljZSUzRHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwb2ZmbG9hZF90eXBlJTNEJTIybGVhZl9sZXZlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zdHJlYW0lM0RUcnVlJTJDJTBBKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMjJhJTIwYmVhdXRpZnVsJTIwc3Vuc2V0JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_group_offload(
<span class="hljs-meta">... </span>    onload_device=torch.device(<span class="hljs-string">&quot;cuda&quot;</span>),
<span class="hljs-meta">... </span>    offload_device=torch.device(<span class="hljs-string">&quot;cpu&quot;</span>),
<span class="hljs-meta">... </span>    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
<span class="hljs-meta">... </span>    use_stream=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(<span class="hljs-string">&quot;a beautiful sunset&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=s("p"),l.textContent=C,w=n(),h(c.$$.fragment)},l(o){l=a(o,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=C),w=i(o),g(c.$$.fragment,o)},m(o,$){u(o,l,$),u(o,w,$),b(c,o,$),x=!0},p:we,i(o){x||(_(c.$$.fragment,o),x=!0)},o(o){v(c.$$.fragment,o),x=!1},d(o){o&&(r(l),r(w)),y(c,o)}}}function Es(U){let l,C="Examples:",w,c,x;return c=new $e({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){l=s("p"),l.textContent=C,w=n(),h(c.$$.fragment)},l(o){l=a(o,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=C),w=i(o),g(c.$$.fragment,o)},m(o,$){u(o,l,$),u(o,w,$),b(c,o,$),x=!0},p:we,i(o){x||(_(c.$$.fragment,o),x=!0)},o(o){v(c.$$.fragment,o),x=!1},d(o){o&&(r(l),r(w)),y(c,o)}}}function zs(U){let l,C="Examples:",w,c,x;return c=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFuZXdfcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblNBR1BpcGVsaW5lLmZyb21fcGlwZShwaXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionSAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>new_pipe = StableDiffusionSAGPipeline.from_pipe(pipe)`,wrap:!1}}),{c(){l=s("p"),l.textContent=C,w=n(),h(c.$$.fragment)},l(o){l=a(o,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=C),w=i(o),g(c.$$.fragment,o)},m(o,$){u(o,l,$),u(o,w,$),b(c,o,$),x=!0},p:we,i(o){x||(_(c.$$.fragment,o),x=!0)},o(o){v(c.$$.fragment,o),x=!1},d(o){o&&(r(l),r(w)),y(c,o)}}}function qs(U){let l,C="If you get the error message below, you need to finetune the weights for your downstream task:",w,c,x;return c=new $e({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQSUwQS0lMjBjb252X2luLndlaWdodCUzQSUyMGZvdW5kJTIwc2hhcGUlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDQlMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMGNoZWNrcG9pbnQlMjBhbmQlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDklMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMG1vZGVsJTIwaW5zdGFudGlhdGVkJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint <span class="hljs-built_in">at</span> stable-<span class="hljs-keyword">diffusion-v1-5/stable-diffusion-v1-5 </span><span class="hljs-keyword">and </span>are newly initialized <span class="hljs-keyword">because </span>the <span class="hljs-keyword">shapes </span><span class="hljs-keyword">did </span>not match:
- conv_in.weight: found <span class="hljs-keyword">shape </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the checkpoint <span class="hljs-keyword">and </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the model <span class="hljs-keyword">instantiated
</span>You <span class="hljs-keyword">should </span>probably TRAIN this model on a down-stream task to <span class="hljs-keyword">be </span>able to use it for predictions <span class="hljs-keyword">and </span>inference.`,wrap:!1}}),{c(){l=s("p"),l.textContent=C,w=n(),h(c.$$.fragment)},l(o){l=a(o,"P",{"data-svelte-h":!0}),d(l)!=="svelte-xueb0m"&&(l.textContent=C),w=i(o),g(c.$$.fragment,o)},m(o,$){u(o,l,$),u(o,w,$),b(c,o,$),x=!0},p:we,i(o){x||(_(c.$$.fragment,o),x=!0)},o(o){v(c.$$.fragment,o),x=!1},d(o){o&&(r(l),r(w)),y(c,o)}}}function Ys(U){let l,C="Examples:",w,c,x;return c=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUwQSUyMyUyMFVzZSUyMGElMjBkaWZmZXJlbnQlMjBzY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTE1TRGlzY3JldGVTY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMHNjaGVkdWxlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){l=s("p"),l.textContent=C,w=n(),h(c.$$.fragment)},l(o){l=a(o,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=C),w=i(o),g(c.$$.fragment,o)},m(o,$){u(o,l,$),u(o,w,$),b(c,o,$),x=!0},p:we,i(o){x||(_(c.$$.fragment,o),x=!0)},o(o){v(c.$$.fragment,o),x=!1},d(o){o&&(r(l),r(w)),y(c,o)}}}function As(U){let l,C="Examples:",w,c,x;return c=new $e({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){l=s("p"),l.textContent=C,w=n(),h(c.$$.fragment)},l(o){l=a(o,"P",{"data-svelte-h":!0}),d(l)!=="svelte-kvfsh7"&&(l.textContent=C),w=i(o),g(c.$$.fragment,o)},m(o,$){u(o,l,$),u(o,w,$),b(c,o,$),x=!0},p:we,i(o){x||(_(c.$$.fragment,o),x=!0)},o(o){v(c.$$.fragment,o),x=!1},d(o){o&&(r(l),r(w)),y(c,o)}}}function Qs(U){let l,C,w,c,x,o,$,Di="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",To,Me,Zi='All pipelines are built from the base <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',ko,K,ji='<p>You shouldn’t use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.</p> <br/> <p>Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!</p>',Co,Te,Ii="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",Uo,ke,Ji='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="amused">aMUSEd</a></td> <td>text2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="auraflow">AuraFlow</a></td> <td>text2image</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="bria_3_2">Bria 3.2</a></td> <td>text2image</td></tr> <tr><td><a href="cogvideox">CogVideoX</a></td> <td>text2video</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_flux">ControlNet with Flux.1</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_hunyuandit">ControlNet with Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sd3">ControlNet with Stable Diffusion 3</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="flux">Flux</a></td> <td>text2image</td></tr> <tr><td><a href="hunyuandit">Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="i2vgenxl">I2VGen-XL</a></td> <td>image2video</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="kolors">Kolors</a></td> <td>text2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="latte">Latte</a></td> <td>text2image</td></tr> <tr><td><a href="ledits_pp">LEDITS++</a></td> <td>image editing</td></tr> <tr><td><a href="lumina">Lumina-T2X</a></td> <td>text2image</td></tr> <tr><td><a href="marigold">Marigold</a></td> <td>depth-estimation, normals-estimation, intrinsic-decomposition</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="pag">PAG</a></td> <td>text2image</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="pia">PIA</a></td> <td>image2video</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pixart_sigma">PixArt-Σ</a></td> <td>text2image</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="stable_audio">Stable Audio</a></td> <td>text2audio</td></tr> <tr><td><a href="stable_cascade">Stable Cascade</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr> <tr><td><a href="visualcloze">VisualCloze</a></td> <td>text2image, image2image, subject driven generation, inpainting, style transfer, image restoration, image editing, [depth,normal,edge,pose]2image, [depth,normal,edge,pose]-estimation, virtual try-on, image relighting</td></tr></tbody>',Po,Ce,Do,p,Ue,Ko,ht,Gi="Base class for all pipelines.",en,gt,Li=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,tn,bt,Hi="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",on,_t,Wi="Class attributes:",nn,vt,Si=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,sn,ee,Pe,an,yt,Vi="Call self as a function.",rn,xt,De,ln,Z,Ze,dn,wt,Ni=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,cn,je,Fi=`<p>&gt; If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is.
Otherwise, &gt; the returned pipeline is a copy of self with the desired torch.dtype and torch.device.</p>`,fn,$t,Bi="Here are the ways to call <code>to</code>:",pn,Mt,Xi=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,un,G,Ie,mn,Tt,Ri=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,hn,kt,Ei=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,gn,te,bn,oe,Je,_n,Ct,zi=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,vn,ne,Ge,yn,Ut,qi='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',xn,q,Le,wn,Pt,Yi="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",$n,He,Ai='<p>&gt; To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in\nwith `hf &gt; auth login</p>',Mn,L,We,Tn,Dt,Qi=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,kn,Se,Oi=`<p>&gt; ⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA)
from PyTorch &gt; 2.0 or xFormers. These attention computations are already very memory efficient so you won’t
need to enable &gt; this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious
slow downs!</p>`,Cn,ie,Un,P,Ve,Pn,Zt,Ki=`Applies group offloading to the internal layers of a torch.nn.Module. To understand what group offloading is,
and where it is beneficial, we need to first provide some context on how other supported offloading methods
work.`,Dn,jt,es="Typically, offloading is done at two levels:",Zn,It,ts=`<li>Module-level: In Diffusers, this can be enabled using the <code>ModelMixin::enable_model_cpu_offload()</code> method. It
works by offloading each component of a pipeline to the CPU for storage, and onloading to the accelerator
device when needed for computation. This method is more memory-efficient than keeping all components on the
accelerator, but the memory requirements are still quite high. For this method to work, one needs memory
equivalent to size of the model in runtime dtype + size of largest intermediate activation tensors to be able
to complete the forward pass.</li> <li>Leaf-level: In Diffusers, this can be enabled using the <code>ModelMixin::enable_sequential_cpu_offload()</code> method.
It
works by offloading the lowest leaf-level parameters of the computation graph to the CPU for storage, and
onloading only the leafs to the accelerator device for computation. This uses the lowest amount of accelerator
memory, but can be slower due to the excessive number of device synchronizations.</li>`,jn,Jt,os=`Group offloading is a middle ground between the two methods. It works by offloading groups of internal layers,
(either <code>torch.nn.ModuleList</code> or <code>torch.nn.Sequential</code>). This method uses lower memory than module-level
offloading. It is also faster than leaf-level/sequential offloading, as the number of device synchronizations
is reduced.`,In,Gt,ns=`Another supported feature (for CUDA devices with support for asynchronous data transfer streams) is the ability
to overlap data transfer and computation to reduce the overall execution time compared to sequential
offloading. This is enabled using layer prefetching with streams, i.e., the layer that is to be executed next
starts onloading to the accelerator device while the current layer is being executed - this increases the
memory requirements slightly. Note that this implementation also supports leaf-level offloading but can be made
much faster when using streams.`,Jn,se,Gn,ae,Ne,Ln,Lt,is=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the accelerator when its
<code>forward</code> method is called, and the model remains in accelerator until the next model runs. Memory savings are
lower than with <code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution
of the <code>unet</code>.`,Hn,re,Fe,Wn,Ht,ss=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to accelerator only when their specific submodule has its
<code>forward</code> method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,Sn,H,Be,Vn,Wt,as=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Nn,Xe,rs=`<p>&gt; ⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient
attention takes &gt; precedent.</p>`,Fn,le,Bn,Y,Re,Xn,St,ls=`Create a new pipeline from a given pipeline. This method is useful to create a new pipeline from the existing
pipeline components without reallocating additional memory.`,Rn,de,En,D,Ee,zn,Vt,ds="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",qn,Nt,cs="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",Yn,ce,An,ze,fs=`<p>&gt; To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in
with <code>hf &gt; auth login</code>.</p>`,Qn,fe,On,W,qe,Kn,Ft,ps="Method that performs the following:",ei,Bt,us=`<li>Offloads all components.</li> <li>Removes all model hooks that were added when using <code>enable_model_cpu_offload</code>, and then applies them again.
In case the model has not been offloaded, this function is a no-op.</li> <li>Resets stateful diffusers hooks of denoiser components if they were added with
<code>register_hook()</code>.</li>`,ti,Xt,ms=`Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it functions
correctly when applying <code>enable_model_cpu_offload</code>.`,oi,pe,Ye,ni,Rt,hs="Convert a NumPy image or a batch of images to a PIL image.",ii,ue,Ae,si,Et,gs="Removes all hooks that were added when using <code>enable_sequential_cpu_offload</code> or <code>enable_model_cpu_offload</code>.",ai,me,Qe,ri,zt,bs="Resets the device maps (if any) to None.",li,he,Oe,di,qt,_s=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,Zo,I,Ke,ci,Yt,vs='Enables the FreeU mechanism as in <a href="https://huggingface.co/papers/2309.11497" rel="nofollow">https://huggingface.co/papers/2309.11497</a>.',fi,At,ys="The suffixes after the scaling factors represent the stages where they are being applied.",pi,Qt,xs=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,jo,Q,et,ui,Ot,ws="Disables the FreeU mechanism if enabled.",Io,tt,Jo,V,ot,mi,Kt,$s="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",hi,A,nt,gi,eo,Ms="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",bi,ge,Go,it,Lo,N,st,_i,to,Ts=`Base class for all the official callbacks used in a pipeline. This class provides a structure for implementing
custom callbacks and ensures that all callbacks have a consistent interface.`,vi,oo,ks=`Please implement the following:
<code>tensor_inputs</code>: This should return a list of tensor inputs specific to your callback. You will only be able to
include
variables listed in the <code>._callback_tensor_inputs</code> attribute of your pipeline class.
<code>callback_fn</code>: This method defines the core functionality of your callback.`,Ho,F,at,yi,no,Cs=`Callback function for Stable Diffusion Pipelines. After certain number of steps (set by <code>cutoff_step_ratio</code> or
<code>cutoff_step_index</code>), this callback will disable the CFG.`,xi,io,Us="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",Wo,B,rt,wi,so,Ps=`Callback function for the base Stable Diffusion XL Pipelines. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will disable the CFG.`,$i,ao,Ds="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",So,X,lt,Mi,ro,Zs=`Callback function for the Controlnet Stable Diffusion XL Pipelines. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will disable the CFG.`,Ti,lo,js="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",Vo,R,dt,ki,co,Is=`Callback function for any pipeline that inherits <code>IPAdapterMixin</code>. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will set the IP Adapter scale to <code>0.0</code>.`,Ci,fo,Js="Note: This callback mutates the IP Adapter attention processors by setting the scale to 0.0 after the cutoff step.",No,E,ct,Ui,po,Gs=`Callback function for Stable Diffusion 3 Pipelines. After certain number of steps (set by <code>cutoff_step_ratio</code> or
<code>cutoff_step_index</code>), this callback will disable the CFG.`,Pi,uo,Ls="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",Fo,ft,Bo,$o,Xo;return x=new Oo({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),Ce=new Oo({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),Ue=new k({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L181"}}),Pe=new k({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),De=new k({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),Ze=new k({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L370",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),Ie=new k({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1857"}}),te=new xe({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[Bs]},$$scope:{ctx:U}}}),Je=new k({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2015"}}),Ge=new k({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1952"}}),Le=new k({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<blockquote class="warning">
<p>&gt; &#x1F9EA; This is an experimental feature and may change in the future.</p>
</blockquote>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified DDUF file.`,name:"dduf_file(str,"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1473",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),We=new k({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1978"}}),ie=new xe({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[Xs]},$$scope:{ctx:U}}}),Ve=new k({props:{name:"enable_group_offload",anchor:"diffusers.DiffusionPipeline.enable_group_offload",parameters:[{name:"onload_device",val:": device"},{name:"offload_device",val:": device = device(type='cpu')"},{name:"offload_type",val:": str = 'block_level'"},{name:"num_blocks_per_group",val:": typing.Optional[int] = None"},{name:"non_blocking",val:": bool = False"},{name:"use_stream",val:": bool = False"},{name:"record_stream",val:": bool = False"},{name:"low_cpu_mem_usage",val:" = False"},{name:"offload_to_disk_path",val:": typing.Optional[str] = None"},{name:"exclude_modules",val:": typing.Union[str, typing.List[str], NoneType] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_group_offload.onload_device",description:`<strong>onload_device</strong> (<code>torch.device</code>) &#x2014;
The device to which the group of modules are onloaded.`,name:"onload_device"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.offload_device",description:`<strong>offload_device</strong> (<code>torch.device</code>, defaults to <code>torch.device(&quot;cpu&quot;)</code>) &#x2014;
The device to which the group of modules are offloaded. This should typically be the CPU. Default is
CPU.`,name:"offload_device"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.offload_type",description:`<strong>offload_type</strong> (<code>str</code> or <code>GroupOffloadingType</code>, defaults to &#x201C;block_level&#x201D;) &#x2014;
The type of offloading to be applied. Can be one of &#x201C;block_level&#x201D; or &#x201C;leaf_level&#x201D;. Default is
&#x201C;block_level&#x201D;.`,name:"offload_type"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.offload_to_disk_path",description:`<strong>offload_to_disk_path</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The path to the directory where parameters will be offloaded. Setting this option can be useful in
limited RAM environment settings where a reasonable speed-memory trade-off is desired.`,name:"offload_to_disk_path"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.num_blocks_per_group",description:`<strong>num_blocks_per_group</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of blocks per group when using offload_type=&#x201C;block_level&#x201D;. This is required when using
offload_type=&#x201C;block_level&#x201D;.`,name:"num_blocks_per_group"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.non_blocking",description:`<strong>non_blocking</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If True, offloading and onloading is done with non-blocking data transfer.`,name:"non_blocking"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.use_stream",description:`<strong>use_stream</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If True, offloading and onloading is done asynchronously using a CUDA stream. This can be useful for
overlapping computation and data transfer.`,name:"use_stream"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.record_stream",description:`<strong>record_stream</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014; When enabled with <code>use_stream</code>, it marks the current tensor
as having been used by this stream. It is faster at the expense of slightly more memory usage. Refer to
the <a href="https://pytorch.org/docs/stable/generated/torch.Tensor.record_stream.html" rel="nofollow">PyTorch official docs</a>
more details.`,name:"record_stream"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If True, the CPU memory usage is minimized by pinning tensors on-the-fly instead of pre-pinning them.
This option only matters when using streamed CPU offloading (i.e. <code>use_stream=True</code>). This can be
useful when the CPU memory is a bottleneck but may counteract the benefits of using streams.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.exclude_modules",description:"<strong>exclude_modules</strong> (<code>Union[str, List[str]]</code>, defaults to <code>None</code>) &#x2014; List of modules to exclude from offloading.",name:"exclude_modules"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1333"}}),se=new xe({props:{anchor:"diffusers.DiffusionPipeline.enable_group_offload.example",$$slots:{default:[Rs]},$$scope:{ctx:U}}}),Ne=new k({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1150"}}),Fe=new k({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1266"}}),Be=new k({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1921"}}),le=new xe({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Es]},$$scope:{ctx:U}}}),Re=new k({props:{name:"from_pipe",anchor:"diffusers.DiffusionPipeline.from_pipe",parameters:[{name:"pipeline",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pipe.pipeline",description:`<strong>pipeline</strong> (<code>DiffusionPipeline</code>) &#x2014;
The pipeline from which to create a new pipeline.`,name:"pipeline"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2031",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A new pipeline with the same weights and configurations as <code>pipeline</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>DiffusionPipeline</code></p>
`}}),de=new xe({props:{anchor:"diffusers.DiffusionPipeline.from_pipe.example",$$slots:{default:[zs]},$$scope:{ctx:U}}}),Ee=new k({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing a dduf file</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>torch.dtype</code> or <code>dict[str, Union[str, torch.dtype]]</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. To load submodels with
different dtype pass a <code>dict</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;vae&apos;: torch.float16}</code>).
Set the default dtype for unspecified components with <code>default</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;default&apos;: torch.float16}</code>). If a component is not specified and no default is set,
<code>torch.float32</code> is used.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<blockquote class="warning">
<p>&gt; &#x1F9EA; This is an experimental feature and may change in the future.</p>
</blockquote>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. Defaults to the latest stable &#x1F917; Diffusers
version.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Strategy that dictates how the different components of a pipeline should be placed on available
devices. Currently, only &#x201C;balanced&#x201D; <code>device_map</code> is supported. Check out
<a href="https://huggingface.co/docs/diffusers/main/en/tutorials/inference_with_big_models#device-placement" rel="nofollow">this</a>
to know more.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified dduf file.`,name:"dduf_file(str,"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L592"}}),ce=new xe({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[qs]},$$scope:{ctx:U}}}),fe=new xe({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[Ys]},$$scope:{ctx:U}}}),qe=new k({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1243"}}),Ye=new k({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1895"}}),Ae=new k({props:{name:"remove_all_hooks",anchor:"diffusers.DiffusionPipeline.remove_all_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1141"}}),Qe=new k({props:{name:"reset_device_map",anchor:"diffusers.DiffusionPipeline.reset_device_map",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1460"}}),Oe=new k({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"max_shard_size",val:": typing.Union[int, str, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, defaults to <code>None</code>) &#x2014;
The maximum size for a checkpoint before being sharded. Checkpoints shard will then be each of size
lower than this size. If expressed as a string, needs to be digits followed by a unit (like <code>&quot;5GB&quot;</code>).
If expressed as an integer, the unit is bytes. Note that this limit will be decreased after a certain
period of time (starting from Oct 2024) to allow users to upgrade to the latest version of <code>diffusers</code>.
This is to establish a common default size for this argument across different libraries in the Hugging
Face ecosystem (<code>transformers</code>, and <code>accelerate</code>, for example).`,name:"max_shard_size"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L237"}}),Ke=new k({props:{name:"diffusers.StableDiffusionMixin.enable_freeu",anchor:"diffusers.StableDiffusionMixin.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2233"}}),et=new k({props:{name:"diffusers.StableDiffusionMixin.disable_freeu",anchor:"diffusers.StableDiffusionMixin.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2255"}}),tt=new Oo({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),ot=new k({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L464"}}),nt=new k({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"subfolder",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the
organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running <code>hf auth login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L499"}}),ge=new xe({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[As]},$$scope:{ctx:U}}}),it=new Oo({props:{title:"Callbacks",local:"diffusers.callbacks.PipelineCallback",headingTag:"h2"}}),st=new k({props:{name:"class diffusers.callbacks.PipelineCallback",anchor:"diffusers.callbacks.PipelineCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L7"}}),at=new k({props:{name:"class diffusers.callbacks.SDCFGCutoffCallback",anchor:"diffusers.callbacks.SDCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L69"}}),rt=new k({props:{name:"class diffusers.callbacks.SDXLCFGCutoffCallback",anchor:"diffusers.callbacks.SDXLCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L98"}}),lt=new k({props:{name:"class diffusers.callbacks.SDXLControlnetCFGCutoffCallback",anchor:"diffusers.callbacks.SDXLControlnetCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L140"}}),dt=new k({props:{name:"class diffusers.callbacks.IPAdapterScaleCutoffCallback",anchor:"diffusers.callbacks.IPAdapterScaleCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L188"}}),ct=new k({props:{name:"class diffusers.callbacks.SD3CFGCutoffCallback",anchor:"diffusers.callbacks.SD3CFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L212"}}),ft=new Fs({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/overview.md"}}),{c(){l=s("meta"),C=n(),w=s("p"),c=n(),h(x.$$.fragment),o=n(),$=s("p"),$.textContent=Di,To=n(),Me=s("p"),Me.innerHTML=Zi,ko=n(),K=s("blockquote"),K.innerHTML=ji,Co=n(),Te=s("p"),Te.textContent=Ii,Uo=n(),ke=s("table"),ke.innerHTML=Ji,Po=n(),h(Ce.$$.fragment),Do=n(),p=s("div"),h(Ue.$$.fragment),Ko=n(),ht=s("p"),ht.textContent=Gi,en=n(),gt=s("p"),gt.innerHTML=Li,tn=n(),bt=s("ul"),bt.innerHTML=Hi,on=n(),_t=s("p"),_t.textContent=Wi,nn=n(),vt=s("ul"),vt.innerHTML=Si,sn=n(),ee=s("div"),h(Pe.$$.fragment),an=n(),yt=s("p"),yt.textContent=Vi,rn=n(),xt=s("div"),h(De.$$.fragment),ln=n(),Z=s("div"),h(Ze.$$.fragment),dn=n(),wt=s("p"),wt.innerHTML=Ni,cn=n(),je=s("blockquote"),je.innerHTML=Fi,fn=n(),$t=s("p"),$t.innerHTML=Bi,pn=n(),Mt=s("ul"),Mt.innerHTML=Xi,un=n(),G=s("div"),h(Ie.$$.fragment),mn=n(),Tt=s("p"),Tt.innerHTML=Ri,hn=n(),kt=s("p"),kt.innerHTML=Ei,gn=n(),h(te.$$.fragment),bn=n(),oe=s("div"),h(Je.$$.fragment),_n=n(),Ct=s("p"),Ct.innerHTML=zi,vn=n(),ne=s("div"),h(Ge.$$.fragment),yn=n(),Ut=s("p"),Ut.innerHTML=qi,xn=n(),q=s("div"),h(Le.$$.fragment),wn=n(),Pt=s("p"),Pt.textContent=Yi,$n=n(),He=s("blockquote"),He.innerHTML=Ai,Mn=n(),L=s("div"),h(We.$$.fragment),Tn=n(),Dt=s("p"),Dt.textContent=Qi,kn=n(),Se=s("blockquote"),Se.innerHTML=Oi,Cn=n(),h(ie.$$.fragment),Un=n(),P=s("div"),h(Ve.$$.fragment),Pn=n(),Zt=s("p"),Zt.textContent=Ki,Dn=n(),jt=s("p"),jt.textContent=es,Zn=n(),It=s("ul"),It.innerHTML=ts,jn=n(),Jt=s("p"),Jt.innerHTML=os,In=n(),Gt=s("p"),Gt.textContent=ns,Jn=n(),h(se.$$.fragment),Gn=n(),ae=s("div"),h(Ne.$$.fragment),Ln=n(),Lt=s("p"),Lt.innerHTML=is,Hn=n(),re=s("div"),h(Fe.$$.fragment),Wn=n(),Ht=s("p"),Ht.innerHTML=ss,Sn=n(),H=s("div"),h(Be.$$.fragment),Vn=n(),Wt=s("p"),Wt.innerHTML=as,Nn=n(),Xe=s("blockquote"),Xe.innerHTML=rs,Fn=n(),h(le.$$.fragment),Bn=n(),Y=s("div"),h(Re.$$.fragment),Xn=n(),St=s("p"),St.textContent=ls,Rn=n(),h(de.$$.fragment),En=n(),D=s("div"),h(Ee.$$.fragment),zn=n(),Vt=s("p"),Vt.textContent=ds,qn=n(),Nt=s("p"),Nt.innerHTML=cs,Yn=n(),h(ce.$$.fragment),An=n(),ze=s("blockquote"),ze.innerHTML=fs,Qn=n(),h(fe.$$.fragment),On=n(),W=s("div"),h(qe.$$.fragment),Kn=n(),Ft=s("p"),Ft.textContent=ps,ei=n(),Bt=s("ul"),Bt.innerHTML=us,ti=n(),Xt=s("p"),Xt.innerHTML=ms,oi=n(),pe=s("div"),h(Ye.$$.fragment),ni=n(),Rt=s("p"),Rt.textContent=hs,ii=n(),ue=s("div"),h(Ae.$$.fragment),si=n(),Et=s("p"),Et.innerHTML=gs,ai=n(),me=s("div"),h(Qe.$$.fragment),ri=n(),zt=s("p"),zt.textContent=bs,li=n(),he=s("div"),h(Oe.$$.fragment),di=n(),qt=s("p"),qt.innerHTML=_s,Zo=n(),I=s("div"),h(Ke.$$.fragment),ci=n(),Yt=s("p"),Yt.innerHTML=vs,fi=n(),At=s("p"),At.textContent=ys,pi=n(),Qt=s("p"),Qt.innerHTML=xs,jo=n(),Q=s("div"),h(et.$$.fragment),ui=n(),Ot=s("p"),Ot.textContent=ws,Io=n(),h(tt.$$.fragment),Jo=n(),V=s("div"),h(ot.$$.fragment),mi=n(),Kt=s("p"),Kt.textContent=$s,hi=n(),A=s("div"),h(nt.$$.fragment),gi=n(),eo=s("p"),eo.textContent=Ms,bi=n(),h(ge.$$.fragment),Go=n(),h(it.$$.fragment),Lo=n(),N=s("div"),h(st.$$.fragment),_i=n(),to=s("p"),to.textContent=Ts,vi=n(),oo=s("p"),oo.innerHTML=ks,Ho=n(),F=s("div"),h(at.$$.fragment),yi=n(),no=s("p"),no.innerHTML=Cs,xi=n(),io=s("p"),io.innerHTML=Us,Wo=n(),B=s("div"),h(rt.$$.fragment),wi=n(),so=s("p"),so.innerHTML=Ps,$i=n(),ao=s("p"),ao.innerHTML=Ds,So=n(),X=s("div"),h(lt.$$.fragment),Mi=n(),ro=s("p"),ro.innerHTML=Zs,Ti=n(),lo=s("p"),lo.innerHTML=js,Vo=n(),R=s("div"),h(dt.$$.fragment),ki=n(),co=s("p"),co.innerHTML=Is,Ci=n(),fo=s("p"),fo.textContent=Js,No=n(),E=s("div"),h(ct.$$.fragment),Ui=n(),po=s("p"),po.innerHTML=Gs,Pi=n(),uo=s("p"),uo.innerHTML=Ls,Fo=n(),h(ft.$$.fragment),Bo=n(),$o=s("p"),this.h()},l(e){const f=Ns("svelte-u9bgzb",document.head);l=a(f,"META",{name:!0,content:!0}),f.forEach(r),C=i(e),w=a(e,"P",{}),T(w).forEach(r),c=i(e),g(x.$$.fragment,e),o=i(e),$=a(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-eejdx6"&&($.textContent=Di),To=i(e),Me=a(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1d3b6kb"&&(Me.innerHTML=Zi),ko=i(e),K=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(K)!=="svelte-pz0gm9"&&(K.innerHTML=ji),Co=i(e),Te=a(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-2xd39c"&&(Te.textContent=Ii),Uo=i(e),ke=a(e,"TABLE",{"data-svelte-h":!0}),d(ke)!=="svelte-16ga3pv"&&(ke.innerHTML=Ji),Po=i(e),g(Ce.$$.fragment,e),Do=i(e),p=a(e,"DIV",{class:!0});var m=T(p);g(Ue.$$.fragment,m),Ko=i(m),ht=a(m,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1neg3rw"&&(ht.textContent=Gi),en=i(m),gt=a(m,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1kbb8l4"&&(gt.innerHTML=Li),tn=i(m),bt=a(m,"UL",{"data-svelte-h":!0}),d(bt)!=="svelte-2a5chx"&&(bt.innerHTML=Hi),on=i(m),_t=a(m,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-wz8va1"&&(_t.textContent=Wi),nn=i(m),vt=a(m,"UL",{"data-svelte-h":!0}),d(vt)!=="svelte-1ilr6sx"&&(vt.innerHTML=Si),sn=i(m),ee=a(m,"DIV",{class:!0});var pt=T(ee);g(Pe.$$.fragment,pt),an=i(pt),yt=a(pt,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1eed40t"&&(yt.textContent=Vi),pt.forEach(r),rn=i(m),xt=a(m,"DIV",{class:!0});var Mo=T(xt);g(De.$$.fragment,Mo),Mo.forEach(r),ln=i(m),Z=a(m,"DIV",{class:!0});var J=T(Z);g(Ze.$$.fragment,J),dn=i(J),wt=a(J,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1vbhnip"&&(wt.innerHTML=Ni),cn=i(J),je=a(J,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(je)!=="svelte-ja1ewp"&&(je.innerHTML=Fi),fn=i(J),$t=a(J,"P",{"data-svelte-h":!0}),d($t)!=="svelte-5ul9n2"&&($t.innerHTML=Bi),pn=i(J),Mt=a(J,"UL",{"data-svelte-h":!0}),d(Mt)!=="svelte-1icy6l9"&&(Mt.innerHTML=Xi),J.forEach(r),un=i(m),G=a(m,"DIV",{class:!0});var z=T(G);g(Ie.$$.fragment,z),mn=i(z),Tt=a(z,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-had4mb"&&(Tt.innerHTML=Ri),hn=i(z),kt=a(z,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-19k67ce"&&(kt.innerHTML=Ei),gn=i(z),g(te.$$.fragment,z),z.forEach(r),bn=i(m),oe=a(m,"DIV",{class:!0});var ut=T(oe);g(Je.$$.fragment,ut),_n=i(ut),Ct=a(ut,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-1lh0nh5"&&(Ct.innerHTML=zi),ut.forEach(r),vn=i(m),ne=a(m,"DIV",{class:!0});var mt=T(ne);g(Ge.$$.fragment,mt),yn=i(mt),Ut=a(mt,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1vfte1e"&&(Ut.innerHTML=qi),mt.forEach(r),xn=i(m),q=a(m,"DIV",{class:!0});var O=T(q);g(Le.$$.fragment,O),wn=i(O),Pt=a(O,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1mfctah"&&(Pt.textContent=Yi),$n=i(O),He=a(O,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(He)!=="svelte-n1m6lp"&&(He.innerHTML=Ai),O.forEach(r),Mn=i(m),L=a(m,"DIV",{class:!0});var be=T(L);g(We.$$.fragment,be),Tn=i(be),Dt=a(be,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-10jaql7"&&(Dt.textContent=Qi),kn=i(be),Se=a(be,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(Se)!=="svelte-zc9fvp"&&(Se.innerHTML=Oi),Cn=i(be),g(ie.$$.fragment,be),be.forEach(r),Un=i(m),P=a(m,"DIV",{class:!0});var j=T(P);g(Ve.$$.fragment,j),Pn=i(j),Zt=a(j,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-1umao2b"&&(Zt.textContent=Ki),Dn=i(j),jt=a(j,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-1b92jfk"&&(jt.textContent=es),Zn=i(j),It=a(j,"UL",{"data-svelte-h":!0}),d(It)!=="svelte-1n0e5q1"&&(It.innerHTML=ts),jn=i(j),Jt=a(j,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1yl7dpl"&&(Jt.innerHTML=os),In=i(j),Gt=a(j,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-v0d0nn"&&(Gt.textContent=ns),Jn=i(j),g(se.$$.fragment,j),j.forEach(r),Gn=i(m),ae=a(m,"DIV",{class:!0});var Ro=T(ae);g(Ne.$$.fragment,Ro),Ln=i(Ro),Lt=a(Ro,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-9hgqai"&&(Lt.innerHTML=is),Ro.forEach(r),Hn=i(m),re=a(m,"DIV",{class:!0});var Eo=T(re);g(Fe.$$.fragment,Eo),Wn=i(Eo),Ht=a(Eo,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-1bs0ixe"&&(Ht.innerHTML=ss),Eo.forEach(r),Sn=i(m),H=a(m,"DIV",{class:!0});var _e=T(H);g(Be.$$.fragment,_e),Vn=i(_e),Wt=a(_e,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-e03q3e"&&(Wt.innerHTML=as),Nn=i(_e),Xe=a(_e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(Xe)!=="svelte-3y0te0"&&(Xe.innerHTML=rs),Fn=i(_e),g(le.$$.fragment,_e),_e.forEach(r),Bn=i(m),Y=a(m,"DIV",{class:!0});var mo=T(Y);g(Re.$$.fragment,mo),Xn=i(mo),St=a(mo,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1jx3icn"&&(St.textContent=ls),Rn=i(mo),g(de.$$.fragment,mo),mo.forEach(r),En=i(m),D=a(m,"DIV",{class:!0});var S=T(D);g(Ee.$$.fragment,S),zn=i(S),Vt=a(S,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-ccbjek"&&(Vt.textContent=ds),qn=i(S),Nt=a(S,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-1p5vgmd"&&(Nt.innerHTML=cs),Yn=i(S),g(ce.$$.fragment,S),An=i(S),ze=a(S,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(ze)!=="svelte-zg8xkk"&&(ze.innerHTML=fs),Qn=i(S),g(fe.$$.fragment,S),S.forEach(r),On=i(m),W=a(m,"DIV",{class:!0});var ve=T(W);g(qe.$$.fragment,ve),Kn=i(ve),Ft=a(ve,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-z79kjq"&&(Ft.textContent=ps),ei=i(ve),Bt=a(ve,"UL",{"data-svelte-h":!0}),d(Bt)!=="svelte-1ju7puc"&&(Bt.innerHTML=us),ti=i(ve),Xt=a(ve,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1pqppti"&&(Xt.innerHTML=ms),ve.forEach(r),oi=i(m),pe=a(m,"DIV",{class:!0});var zo=T(pe);g(Ye.$$.fragment,zo),ni=i(zo),Rt=a(zo,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-1gut907"&&(Rt.textContent=hs),zo.forEach(r),ii=i(m),ue=a(m,"DIV",{class:!0});var qo=T(ue);g(Ae.$$.fragment,qo),si=i(qo),Et=a(qo,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-8kophh"&&(Et.innerHTML=gs),qo.forEach(r),ai=i(m),me=a(m,"DIV",{class:!0});var Yo=T(me);g(Qe.$$.fragment,Yo),ri=i(Yo),zt=a(Yo,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-6tjysh"&&(zt.textContent=bs),Yo.forEach(r),li=i(m),he=a(m,"DIV",{class:!0});var Ao=T(he);g(Oe.$$.fragment,Ao),di=i(Ao),qt=a(Ao,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-1jcmq84"&&(qt.innerHTML=_s),Ao.forEach(r),m.forEach(r),Zo=i(e),I=a(e,"DIV",{class:!0});var ye=T(I);g(Ke.$$.fragment,ye),ci=i(ye),Yt=a(ye,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-192jnkh"&&(Yt.innerHTML=vs),fi=i(ye),At=a(ye,"P",{"data-svelte-h":!0}),d(At)!=="svelte-xjijlp"&&(At.textContent=ys),pi=i(ye),Qt=a(ye,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-hy0nzs"&&(Qt.innerHTML=xs),ye.forEach(r),jo=i(e),Q=a(e,"DIV",{class:!0});var Qo=T(Q);g(et.$$.fragment,Qo),ui=i(Qo),Ot=a(Qo,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-psupw6"&&(Ot.textContent=ws),Qo.forEach(r),Io=i(e),g(tt.$$.fragment,e),Jo=i(e),V=a(e,"DIV",{class:!0});var ho=T(V);g(ot.$$.fragment,ho),mi=i(ho),Kt=a(ho,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-7y8zei"&&(Kt.textContent=$s),hi=i(ho),A=a(ho,"DIV",{class:!0});var go=T(A);g(nt.$$.fragment,go),gi=i(go),eo=a(go,"P",{"data-svelte-h":!0}),d(eo)!=="svelte-5nfhmh"&&(eo.textContent=Ms),bi=i(go),g(ge.$$.fragment,go),go.forEach(r),ho.forEach(r),Go=i(e),g(it.$$.fragment,e),Lo=i(e),N=a(e,"DIV",{class:!0});var bo=T(N);g(st.$$.fragment,bo),_i=i(bo),to=a(bo,"P",{"data-svelte-h":!0}),d(to)!=="svelte-2ua579"&&(to.textContent=Ts),vi=i(bo),oo=a(bo,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-qrped9"&&(oo.innerHTML=ks),bo.forEach(r),Ho=i(e),F=a(e,"DIV",{class:!0});var _o=T(F);g(at.$$.fragment,_o),yi=i(_o),no=a(_o,"P",{"data-svelte-h":!0}),d(no)!=="svelte-1lxhnsk"&&(no.innerHTML=Cs),xi=i(_o),io=a(_o,"P",{"data-svelte-h":!0}),d(io)!=="svelte-twxvjk"&&(io.innerHTML=Us),_o.forEach(r),Wo=i(e),B=a(e,"DIV",{class:!0});var vo=T(B);g(rt.$$.fragment,vo),wi=i(vo),so=a(vo,"P",{"data-svelte-h":!0}),d(so)!=="svelte-1pnjwf0"&&(so.innerHTML=Ps),$i=i(vo),ao=a(vo,"P",{"data-svelte-h":!0}),d(ao)!=="svelte-twxvjk"&&(ao.innerHTML=Ds),vo.forEach(r),So=i(e),X=a(e,"DIV",{class:!0});var yo=T(X);g(lt.$$.fragment,yo),Mi=i(yo),ro=a(yo,"P",{"data-svelte-h":!0}),d(ro)!=="svelte-wsvz4z"&&(ro.innerHTML=Zs),Ti=i(yo),lo=a(yo,"P",{"data-svelte-h":!0}),d(lo)!=="svelte-twxvjk"&&(lo.innerHTML=js),yo.forEach(r),Vo=i(e),R=a(e,"DIV",{class:!0});var xo=T(R);g(dt.$$.fragment,xo),ki=i(xo),co=a(xo,"P",{"data-svelte-h":!0}),d(co)!=="svelte-1pf8icy"&&(co.innerHTML=Is),Ci=i(xo),fo=a(xo,"P",{"data-svelte-h":!0}),d(fo)!=="svelte-1kg1eq5"&&(fo.textContent=Js),xo.forEach(r),No=i(e),E=a(e,"DIV",{class:!0});var wo=T(E);g(ct.$$.fragment,wo),Ui=i(wo),po=a(wo,"P",{"data-svelte-h":!0}),d(po)!=="svelte-461fyb"&&(po.innerHTML=Gs),Pi=i(wo),uo=a(wo,"P",{"data-svelte-h":!0}),d(uo)!=="svelte-twxvjk"&&(uo.innerHTML=Ls),wo.forEach(r),Fo=i(e),g(ft.$$.fragment,e),Bo=i(e),$o=a(e,"P",{}),T($o).forEach(r),this.h()},h(){M(l,"name","hf:doc:metadata"),M(l,"content",Os),M(K,"class","warning"),M(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","tip"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(He,"class","tip"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","warning"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","warning"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","tip"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){t(document.head,l),u(e,C,f),u(e,w,f),u(e,c,f),b(x,e,f),u(e,o,f),u(e,$,f),u(e,To,f),u(e,Me,f),u(e,ko,f),u(e,K,f),u(e,Co,f),u(e,Te,f),u(e,Uo,f),u(e,ke,f),u(e,Po,f),b(Ce,e,f),u(e,Do,f),u(e,p,f),b(Ue,p,null),t(p,Ko),t(p,ht),t(p,en),t(p,gt),t(p,tn),t(p,bt),t(p,on),t(p,_t),t(p,nn),t(p,vt),t(p,sn),t(p,ee),b(Pe,ee,null),t(ee,an),t(ee,yt),t(p,rn),t(p,xt),b(De,xt,null),t(p,ln),t(p,Z),b(Ze,Z,null),t(Z,dn),t(Z,wt),t(Z,cn),t(Z,je),t(Z,fn),t(Z,$t),t(Z,pn),t(Z,Mt),t(p,un),t(p,G),b(Ie,G,null),t(G,mn),t(G,Tt),t(G,hn),t(G,kt),t(G,gn),b(te,G,null),t(p,bn),t(p,oe),b(Je,oe,null),t(oe,_n),t(oe,Ct),t(p,vn),t(p,ne),b(Ge,ne,null),t(ne,yn),t(ne,Ut),t(p,xn),t(p,q),b(Le,q,null),t(q,wn),t(q,Pt),t(q,$n),t(q,He),t(p,Mn),t(p,L),b(We,L,null),t(L,Tn),t(L,Dt),t(L,kn),t(L,Se),t(L,Cn),b(ie,L,null),t(p,Un),t(p,P),b(Ve,P,null),t(P,Pn),t(P,Zt),t(P,Dn),t(P,jt),t(P,Zn),t(P,It),t(P,jn),t(P,Jt),t(P,In),t(P,Gt),t(P,Jn),b(se,P,null),t(p,Gn),t(p,ae),b(Ne,ae,null),t(ae,Ln),t(ae,Lt),t(p,Hn),t(p,re),b(Fe,re,null),t(re,Wn),t(re,Ht),t(p,Sn),t(p,H),b(Be,H,null),t(H,Vn),t(H,Wt),t(H,Nn),t(H,Xe),t(H,Fn),b(le,H,null),t(p,Bn),t(p,Y),b(Re,Y,null),t(Y,Xn),t(Y,St),t(Y,Rn),b(de,Y,null),t(p,En),t(p,D),b(Ee,D,null),t(D,zn),t(D,Vt),t(D,qn),t(D,Nt),t(D,Yn),b(ce,D,null),t(D,An),t(D,ze),t(D,Qn),b(fe,D,null),t(p,On),t(p,W),b(qe,W,null),t(W,Kn),t(W,Ft),t(W,ei),t(W,Bt),t(W,ti),t(W,Xt),t(p,oi),t(p,pe),b(Ye,pe,null),t(pe,ni),t(pe,Rt),t(p,ii),t(p,ue),b(Ae,ue,null),t(ue,si),t(ue,Et),t(p,ai),t(p,me),b(Qe,me,null),t(me,ri),t(me,zt),t(p,li),t(p,he),b(Oe,he,null),t(he,di),t(he,qt),u(e,Zo,f),u(e,I,f),b(Ke,I,null),t(I,ci),t(I,Yt),t(I,fi),t(I,At),t(I,pi),t(I,Qt),u(e,jo,f),u(e,Q,f),b(et,Q,null),t(Q,ui),t(Q,Ot),u(e,Io,f),b(tt,e,f),u(e,Jo,f),u(e,V,f),b(ot,V,null),t(V,mi),t(V,Kt),t(V,hi),t(V,A),b(nt,A,null),t(A,gi),t(A,eo),t(A,bi),b(ge,A,null),u(e,Go,f),b(it,e,f),u(e,Lo,f),u(e,N,f),b(st,N,null),t(N,_i),t(N,to),t(N,vi),t(N,oo),u(e,Ho,f),u(e,F,f),b(at,F,null),t(F,yi),t(F,no),t(F,xi),t(F,io),u(e,Wo,f),u(e,B,f),b(rt,B,null),t(B,wi),t(B,so),t(B,$i),t(B,ao),u(e,So,f),u(e,X,f),b(lt,X,null),t(X,Mi),t(X,ro),t(X,Ti),t(X,lo),u(e,Vo,f),u(e,R,f),b(dt,R,null),t(R,ki),t(R,co),t(R,Ci),t(R,fo),u(e,No,f),u(e,E,f),b(ct,E,null),t(E,Ui),t(E,po),t(E,Pi),t(E,uo),u(e,Fo,f),b(ft,e,f),u(e,Bo,f),u(e,$o,f),Xo=!0},p(e,[f]){const m={};f&2&&(m.$$scope={dirty:f,ctx:e}),te.$set(m);const pt={};f&2&&(pt.$$scope={dirty:f,ctx:e}),ie.$set(pt);const Mo={};f&2&&(Mo.$$scope={dirty:f,ctx:e}),se.$set(Mo);const J={};f&2&&(J.$$scope={dirty:f,ctx:e}),le.$set(J);const z={};f&2&&(z.$$scope={dirty:f,ctx:e}),de.$set(z);const ut={};f&2&&(ut.$$scope={dirty:f,ctx:e}),ce.$set(ut);const mt={};f&2&&(mt.$$scope={dirty:f,ctx:e}),fe.$set(mt);const O={};f&2&&(O.$$scope={dirty:f,ctx:e}),ge.$set(O)},i(e){Xo||(_(x.$$.fragment,e),_(Ce.$$.fragment,e),_(Ue.$$.fragment,e),_(Pe.$$.fragment,e),_(De.$$.fragment,e),_(Ze.$$.fragment,e),_(Ie.$$.fragment,e),_(te.$$.fragment,e),_(Je.$$.fragment,e),_(Ge.$$.fragment,e),_(Le.$$.fragment,e),_(We.$$.fragment,e),_(ie.$$.fragment,e),_(Ve.$$.fragment,e),_(se.$$.fragment,e),_(Ne.$$.fragment,e),_(Fe.$$.fragment,e),_(Be.$$.fragment,e),_(le.$$.fragment,e),_(Re.$$.fragment,e),_(de.$$.fragment,e),_(Ee.$$.fragment,e),_(ce.$$.fragment,e),_(fe.$$.fragment,e),_(qe.$$.fragment,e),_(Ye.$$.fragment,e),_(Ae.$$.fragment,e),_(Qe.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),_(nt.$$.fragment,e),_(ge.$$.fragment,e),_(it.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(ct.$$.fragment,e),_(ft.$$.fragment,e),Xo=!0)},o(e){v(x.$$.fragment,e),v(Ce.$$.fragment,e),v(Ue.$$.fragment,e),v(Pe.$$.fragment,e),v(De.$$.fragment,e),v(Ze.$$.fragment,e),v(Ie.$$.fragment,e),v(te.$$.fragment,e),v(Je.$$.fragment,e),v(Ge.$$.fragment,e),v(Le.$$.fragment,e),v(We.$$.fragment,e),v(ie.$$.fragment,e),v(Ve.$$.fragment,e),v(se.$$.fragment,e),v(Ne.$$.fragment,e),v(Fe.$$.fragment,e),v(Be.$$.fragment,e),v(le.$$.fragment,e),v(Re.$$.fragment,e),v(de.$$.fragment,e),v(Ee.$$.fragment,e),v(ce.$$.fragment,e),v(fe.$$.fragment,e),v(qe.$$.fragment,e),v(Ye.$$.fragment,e),v(Ae.$$.fragment,e),v(Qe.$$.fragment,e),v(Oe.$$.fragment,e),v(Ke.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(ot.$$.fragment,e),v(nt.$$.fragment,e),v(ge.$$.fragment,e),v(it.$$.fragment,e),v(st.$$.fragment,e),v(at.$$.fragment,e),v(rt.$$.fragment,e),v(lt.$$.fragment,e),v(dt.$$.fragment,e),v(ct.$$.fragment,e),v(ft.$$.fragment,e),Xo=!1},d(e){e&&(r(C),r(w),r(c),r(o),r($),r(To),r(Me),r(ko),r(K),r(Co),r(Te),r(Uo),r(ke),r(Po),r(Do),r(p),r(Zo),r(I),r(jo),r(Q),r(Io),r(Jo),r(V),r(Go),r(Lo),r(N),r(Ho),r(F),r(Wo),r(B),r(So),r(X),r(Vo),r(R),r(No),r(E),r(Fo),r(Bo),r($o)),r(l),y(x,e),y(Ce,e),y(Ue),y(Pe),y(De),y(Ze),y(Ie),y(te),y(Je),y(Ge),y(Le),y(We),y(ie),y(Ve),y(se),y(Ne),y(Fe),y(Be),y(le),y(Re),y(de),y(Ee),y(ce),y(fe),y(qe),y(Ye),y(Ae),y(Qe),y(Oe),y(Ke),y(et),y(tt,e),y(ot),y(nt),y(ge),y(it,e),y(st),y(at),y(rt),y(lt),y(dt),y(ct),y(ft,e)}}}const Os='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2},{"title":"Callbacks","local":"diffusers.callbacks.PipelineCallback","sections":[],"depth":2}],"depth":1}';function Ks(U){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class aa extends Ss{constructor(l){super(),Vs(this,l,Ks,Qs,Hs,{})}}export{aa as component};
