import{s as Ui,o as Mi,n as Et}from"../chunks/scheduler.888833de.js";import{S as xi,i as Ci,e as o,s,c as g,h as Pi,a,d as l,b as i,f as P,g as f,j as d,k as x,l as t,m,n as u,t as h,o as _,p as b}from"../chunks/index.128ce987.js";import{D as $}from"../chunks/Docstring.23ed6b62.js";import{C as R}from"../chunks/CodeBlock.37df032e.js";import{E as Vt}from"../chunks/ExampleCodeBlock.6d7ae280.js";import{H as nt,E as Ti}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function $i(Z){let p,T="Examples:",v,c,y;return c=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZ1c2luZyUyRnN0YWJsZS11bmNsaXAtMi0xLWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTIwJTIwJTIzJTIwVE9ETyUyMHVwZGF0ZSUyMG1vZGVsJTIwcGF0aCUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlMEFpbWFnZXMlNUIwJTVELnNhdmUoJTIyYXN0cm9uYXV0X2hvcnNlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fusing/stable-unclip-2-1-l&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># TODO update model path</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_horse.png&quot;</span>)`,wrap:!1}}),{c(){p=o("p"),p.textContent=T,v=s(),g(c.$$.fragment)},l(n){p=a(n,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=T),v=i(n),f(c.$$.fragment,n)},m(n,U){m(n,p,U),m(n,v,U),u(c,n,U),y=!0},p:Et,i(n){y||(h(c.$$.fragment,n),y=!0)},o(n){_(c.$$.fragment,n),y=!1},d(n){n&&(l(p),l(v)),b(c,n)}}}function Li(Z){let p,T="Examples:",v,c,y;return c=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=o("p"),p.textContent=T,v=s(),g(c.$$.fragment)},l(n){p=a(n,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=T),v=i(n),f(c.$$.fragment,n)},m(n,U){m(n,p,U),m(n,v,U),u(c,n,U),y=!0},p:Et,i(n){y||(h(c.$$.fragment,n),y=!0)},o(n){_(c.$$.fragment,n),y=!1},d(n){n&&(l(p),l(v)),b(c,n)}}}function Ji(Z){let p,T="Examples:",v,c,y;return c=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){p=o("p"),p.textContent=T,v=s(),g(c.$$.fragment)},l(n){p=a(n,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=T),v=i(n),f(c.$$.fragment,n)},m(n,U){m(n,p,U),m(n,v,U),u(c,n,U),y=!0},p:Et,i(n){y||(h(c.$$.fragment,n),y=!0)},o(n){_(c.$$.fragment,n),y=!1},d(n){n&&(l(p),l(v)),b(c,n)}}}function Zi(Z){let p,T="Examples:",v,c,y;return c=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS11bmNsaXAtc21hbGwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDc2OCUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoaW5pdF9pbWFnZSUyQyUyMHByb21wdCkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip-small&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(init_image, prompt).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),{c(){p=o("p"),p.textContent=T,v=s(),g(c.$$.fragment)},l(n){p=a(n,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=T),v=i(n),f(c.$$.fragment,n)},m(n,U){m(n,p,U),m(n,v,U),u(c,n,U),y=!0},p:Et,i(n){y||(h(c.$$.fragment,n),y=!0)},o(n){_(c.$$.fragment,n),y=!1},d(n){n&&(l(p),l(v)),b(c,n)}}}function ki(Z){let p,T="Examples:",v,c,y;return c=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=o("p"),p.textContent=T,v=s(),g(c.$$.fragment)},l(n){p=a(n,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=T),v=i(n),f(c.$$.fragment,n)},m(n,U){m(n,p,U),m(n,v,U),u(c,n,U),y=!0},p:Et,i(n){y||(h(c.$$.fragment,n),y=!0)},o(n){_(c.$$.fragment,n),y=!1},d(n){n&&(l(p),l(v)),b(c,n)}}}function ji(Z){let p,T="Examples:",v,c,y;return c=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){p=o("p"),p.textContent=T,v=s(),g(c.$$.fragment)},l(n){p=a(n,"P",{"data-svelte-h":!0}),d(p)!=="svelte-kvfsh7"&&(p.textContent=T),v=i(n),f(c.$$.fragment,n)},m(n,U){m(n,p,U),m(n,v,U),u(c,n,U),y=!0},p:Et,i(n){y||(h(c.$$.fragment,n),y=!0)},o(n){_(c.$$.fragment,n),y=!1},d(n){n&&(l(p),l(v)),b(c,n)}}}function Si(Z){let p,T,v,c,y,n,U,$s='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Xt,me,Ls=`Stable unCLIP checkpoints are finetuned from <a href="./stable_diffusion/stable_diffusion_2">Stable Diffusion 2.1</a> checkpoints to condition on CLIP image embeddings.
Stable unCLIP still conditions on text embeddings. Given the two separate conditionings, stable unCLIP can be used
for text guided image variation. When combined with an unCLIP prior, it can also be used for full text to image generation.`,zt,ge,Js="The abstract from the paper is:",Rt,fe,Zs="<em>Contrastive models like CLIP have been shown to learn robust representations of images that capture both semantics and style. To leverage these representations for image generation, we propose a two-stage model: a prior that generates a CLIP image embedding given a text caption, and a decoder that generates an image conditioned on the image embedding. We show that explicitly generating image representations improves image diversity with minimal loss in photorealism and caption similarity. Our decoders conditioned on image representations can also produce variations of an image that preserve both its semantics and style, while varying the non-essential details absent from the image representation. Moreover, the joint embedding space of CLIP enables language-guided image manipulations in a zero-shot fashion. We use diffusion models for the decoder and experiment with both autoregressive and diffusion models for the prior, finding that the latter are computationally more efficient and produce higher-quality samples.</em>",Ht,ue,Ft,he,ks="Stable unCLIP takes  <code>noise_level</code> as input during inference which determines how much noise is added to the image embeddings. A higher <code>noise_level</code> increases variation in the final un-noised images. By default, we do not add any additional noise to the image embeddings (<code>noise_level = 0</code>).",Yt,_e,Qt,be,js='Stable unCLIP can be leveraged for text-to-image generation by pipelining it with the prior model of KakaoBrain’s open source DALL-E 2 replication <a href="https://huggingface.co/kakaobrain/karlo-v1-alpha" rel="nofollow">Karlo</a>:',Dt,ye,qt,H,Ss='<p>For text-to-image we use <code>stabilityai/stable-diffusion-2-1-unclip-small</code> as it was trained on CLIP ViT-L/14 embedding, the same as the Karlo model prior. <a href="https://hf.co/stabilityai/stable-diffusion-2-1-unclip" rel="nofollow">stabilityai/stable-diffusion-2-1-unclip</a> was trained on OpenCLIP ViT-H, so we don’t recommend its use.</p>',At,ve,Ot,Ie,Kt,we,Ws="Optionally, you can also pass a prompt to <code>pipe</code> such as:",en,Ue,tn,F,Gs='<p>Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.</p>',nn,Me,sn,I,xe,vn,st,Bs="Pipeline for text-to-image generation using stable unCLIP.",In,it,Vs=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,wn,ot,Es="The pipeline also inherits the following loading methods:",Un,at,Ns='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Mn,E,Ce,xn,lt,Xs="The call function to the pipeline for generation.",Cn,Y,Pn,k,Pe,Tn,rt,zs=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,$n,Te,Rs=`<p>&gt; ⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA)
from PyTorch &gt; 2.0 or xFormers. These attention computations are already very memory efficient so you won’t
need to enable &gt; this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious
slow downs!</p>`,Ln,Q,Jn,D,$e,Zn,pt,Hs=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,kn,q,Le,jn,dt,Fs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Sn,A,Je,Wn,ct,Ys=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Gn,j,Ze,Bn,mt,Qs=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Vn,ke,Ds=`<p>&gt; ⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient
attention takes &gt; precedent.</p>`,En,O,Nn,K,je,Xn,gt,qs='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',zn,ee,Se,Rn,ft,As="Encodes the prompt into text encoder hidden states.",Hn,L,We,Fn,ut,Os=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,Yn,ht,Ks="The noise is applied in two ways:",Qn,_t,ei="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",Dn,bt,ti="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",qn,yt,ni="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",on,Ge,an,w,Be,An,vt,si="Pipeline for text-guided image-to-image generation using stable unCLIP.",On,It,ii=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Kn,wt,oi="The pipeline also inherits the following loading methods:",es,Ut,ai='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',ts,N,Ve,ns,Mt,li="The call function to the pipeline for generation.",ss,te,is,S,Ee,os,xt,ri=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,as,Ne,pi=`<p>&gt; ⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA)
from PyTorch &gt; 2.0 or xFormers. These attention computations are already very memory efficient so you won’t
need to enable &gt; this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious
slow downs!</p>`,ls,ne,rs,se,Xe,ps,Ct,di=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,ds,ie,ze,cs,Pt,ci=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ms,oe,Re,gs,Tt,mi=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,fs,W,He,us,$t,gi=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,hs,Fe,fi=`<p>&gt; ⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient
attention takes &gt; precedent.</p>`,_s,ae,bs,le,Ye,ys,Lt,ui='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',vs,re,Qe,Is,Jt,hi="Encodes the prompt into text encoder hidden states.",ws,J,De,Us,Zt,_i=`Add noise to the image embeddings. The amount of noise is controlled by a <code>noise_level</code> input. A higher
<code>noise_level</code> increases the variance in the final un-noised images.`,Ms,kt,bi="The noise is applied in two ways:",xs,jt,yi="<li>A noise schedule is applied directly to the embeddings.</li> <li>A vector of sinusoidal time embeddings are appended to the output.</li>",Cs,St,vi="In both cases, the amount of noise is controlled by the same <code>noise_level</code>.",Ps,Wt,Ii="The embeddings are normalized before the noise is applied and un-normalized after the noise is applied.",ln,qe,rn,X,Ae,Ts,Gt,wi="Output class for image pipelines.",pn,Oe,dn,Nt,cn;return y=new nt({props:{title:"Stable unCLIP",local:"stable-unclip",headingTag:"h1"}}),ue=new nt({props:{title:"Tips",local:"tips",headingTag:"h2"}}),_e=new nt({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h3"}}),ye=new R({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UnCLIPScheduler, DDPMScheduler, StableUnCLIPPipeline
<span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> PriorTransformer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTokenizer, CLIPTextModelWithProjection

prior_model_id = <span class="hljs-string">&quot;kakaobrain/karlo-v1-alpha&quot;</span>
data_type = torch.float16
prior = PriorTransformer.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior&quot;</span>, torch_dtype=data_type)

prior_text_model_id = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
prior_tokenizer = CLIPTokenizer.from_pretrained(prior_text_model_id)
prior_text_model = CLIPTextModelWithProjection.from_pretrained(prior_text_model_id, torch_dtype=data_type)
prior_scheduler = UnCLIPScheduler.from_pretrained(prior_model_id, subfolder=<span class="hljs-string">&quot;prior_scheduler&quot;</span>)
prior_scheduler = DDPMScheduler.from_config(prior_scheduler.config)

stable_unclip_model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip-small&quot;</span>

pipe = StableUnCLIPPipeline.from_pretrained(
    stable_unclip_model_id,
    torch_dtype=data_type,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    prior_tokenizer=prior_tokenizer,
    prior_text_encoder=prior_text_model,
    prior=prior,
    prior_scheduler=prior_scheduler,
)

pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
wave_prompt = <span class="hljs-string">&quot;dramatic wave, the Oceans roar, Strong wave spiral across the oceans as the waves unfurl into roaring crests; perfect wave form; perfect wave shape; dramatic wave shape; wave shape unbelievable; wave; wave shape spectacular&quot;</span>

image = pipe(prompt=wave_prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ve=new nt({props:{title:"Text guided Image-to-Image Variation",local:"text-guided-image-to-image-variation",headingTag:"h3"}}),Ie=new R({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZVVuQ0xJUEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlVW5DTElQSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xLXVuY2xpcCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhdGlvbiUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3RhYmxlX3VuY2xpcCUyRnRhcnNpbGFfZG9fYW1hcmFsLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKGluaXRfaW1hZ2UpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJ2YXJpYXRpb25faW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableUnCLIPImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipe = StableUnCLIPImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-unclip&quot;</span>, torch_dtype=torch.float16, variation=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/stable_unclip/tarsila_do_amaral.png&quot;</span>
init_image = load_image(url)

images = pipe(init_image).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;variation_image.png&quot;</span>)`,wrap:!1}}),Ue=new R({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShpbml0X2ltYWdlJTJDJTIwcHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

image = pipe(init_image, prompt=prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Me=new nt({props:{title:"StableUnCLIPPipeline",local:"diffusers.StableUnCLIPPipeline",headingTag:"h2"}}),xe=new $({props:{name:"class diffusers.StableUnCLIPPipeline",anchor:"diffusers.StableUnCLIPPipeline",parameters:[{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior",val:": PriorTransformer"},{name:"prior_scheduler",val:": KarrasDiffusionSchedulers"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"prior_tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen <code>CLIPTextModelWithProjection</code> text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.StableUnCLIPPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Scheduler used in the prior denoising process.`,name:"prior_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <code>CLIPTokenizer</code>.`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen <code>CLIPTextModel</code> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L70"}}),Ce=new $({props:{name:"__call__",anchor:"diffusers.StableUnCLIPPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"noise_level",val:": int = 0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_latents",val:": typing.Optional[torch.Tensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 25) &#x2014;
The number of denoising steps in the prior denoising process. More denoising steps usually lead to a
higher quality image at the expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"prior_guidance_scale"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.prior_latents",description:`<strong>prior_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
embedding generation in the prior denoising process. Can be used to tweak the same generation with
different prompts. If not provided, a latents tensor is generated by sampling using the supplied random
<code>generator</code>.`,name:"prior_latents"},{anchor:"diffusers.StableUnCLIPPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L645",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Y=new Vt({props:{anchor:"diffusers.StableUnCLIPPipeline.__call__.example",$$slots:{default:[$i]},$$scope:{ctx:Z}}}),Pe=new $({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1978"}}),Q=new Vt({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_attention_slicing.example",$$slots:{default:[Li]},$$scope:{ctx:Z}}}),$e=new $({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2015"}}),Le=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2180"}}),Je=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2193"}}),Ze=new $({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1921"}}),O=new Vt({props:{anchor:"diffusers.StableUnCLIPPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Ji]},$$scope:{ctx:Z}}}),je=new $({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1952"}}),Se=new $({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L297"}}),We=new $({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip.py#L599"}}),Ge=new nt({props:{title:"StableUnCLIPImg2ImgPipeline",local:"diffusers.StableUnCLIPImg2ImgPipeline",headingTag:"h2"}}),Be=new $({props:{name:"class diffusers.StableUnCLIPImg2ImgPipeline",anchor:"diffusers.StableUnCLIPImg2ImgPipeline",parameters:[{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_normalizer",val:": StableUnCLIPImageNormalizer"},{name:"image_noising_scheduler",val:": KarrasDiffusionSchedulers"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vae",val:": AutoencoderKL"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
Feature extractor for image pre-processing before being encoded.`,name:"feature_extractor"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
CLIP vision model for encoding images.`,name:"image_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_normalizer",description:`<strong>image_normalizer</strong> (<code>StableUnCLIPImageNormalizer</code>) &#x2014;
Used to normalize the predicted image embeddings before the noise is applied and un-normalize the image
embeddings after the noise has been applied.`,name:"image_normalizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.image_noising_scheduler",description:`<strong>image_noising_scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
Noise schedule for adding noise to the predicted image embeddings. The amount of noise to add is determined
by the <code>noise_level</code>.`,name:"image_noising_scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>~transformers.CLIPTokenizer</code>) &#x2014;
A [<code>~transformers.CLIPTokenizer</code>)].`,name:"tokenizer"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> text-encoder.`,name:"text_encoder"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<code>KarrasDiffusionSchedulers</code>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L81"}}),Ve=new $({props:{name:"__call__",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__",parameters:[{name:"image",val:": typing.Union[torch.Tensor, PIL.Image.Image] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 20"},{name:"guidance_scale",val:": float = 10"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Optional[typing.Callable[[int, int, torch.Tensor], NoneType]] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"noise_level",val:": int = 0"},{name:"image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, either <code>prompt_embeds</code> will be
used or prompt is initialized to <code>&quot;&quot;</code>.`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code> or <code>PIL.Image.Image</code>) &#x2014;
<code>Image</code> or tensor representing an image batch. The image is encoded to its CLIP embedding which the
<code>unet</code> is conditioned on. The image is <em>not</em> encoded by the <code>vae</code> and then used as the latents in the
denoising process like it is in the standard Stable Diffusion text-guided image variation process.`,name:"image"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 10.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.noise_level",description:`<strong>noise_level</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The amount of noise to add to the image embeddings. A higher <code>noise_level</code> increases the variance in
the final un-noised images. See <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.noise_image_embeddings">StableUnCLIPPipeline.noise_image_embeddings()</a> for more details.`,name:"noise_level"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated CLIP embeddings to condition the <code>unet</code> on. These latents are not used in the denoising
process. If you want to provide pre-generated latents, pass them to <code>__call__</code> as <code>latents</code>.`,name:"image_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L624",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~ pipeline_utils.ImagePipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning
a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),te=new Vt({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.__call__.example",$$slots:{default:[Zi]},$$scope:{ctx:Z}}}),Ee=new $({props:{name:"enable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1978"}}),ne=new Vt({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[ki]},$$scope:{ctx:Z}}}),Xe=new $({props:{name:"disable_attention_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2015"}}),ze=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2180"}}),Re=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2193"}}),He=new $({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1921"}}),ae=new Vt({props:{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ji]},$$scope:{ctx:Z}}}),Ye=new $({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1952"}}),Qe=new $({props:{name:"encode_prompt",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableUnCLIPImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L259"}}),De=new $({props:{name:"noise_image_embeddings",anchor:"diffusers.StableUnCLIPImg2ImgPipeline.noise_image_embeddings",parameters:[{name:"image_embeds",val:": Tensor"},{name:"noise_level",val:": int"},{name:"noise",val:": typing.Optional[torch.Tensor] = None"},{name:"generator",val:": typing.Optional[torch._C.Generator] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_unclip_img2img.py#L578"}}),qe=new nt({props:{title:"ImagePipelineOutput",local:"diffusers.ImagePipelineOutput",headingTag:"h2"}}),Ae=new $({props:{name:"class diffusers.ImagePipelineOutput",anchor:"diffusers.ImagePipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.ImagePipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L118"}}),Oe=new Ti({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_unclip.md"}}),{c(){p=o("meta"),T=s(),v=o("p"),c=s(),g(y.$$.fragment),n=s(),U=o("div"),U.innerHTML=$s,Xt=s(),me=o("p"),me.innerHTML=Ls,zt=s(),ge=o("p"),ge.textContent=Js,Rt=s(),fe=o("p"),fe.innerHTML=Zs,Ht=s(),g(ue.$$.fragment),Ft=s(),he=o("p"),he.innerHTML=ks,Yt=s(),g(_e.$$.fragment),Qt=s(),be=o("p"),be.innerHTML=js,Dt=s(),g(ye.$$.fragment),qt=s(),H=o("blockquote"),H.innerHTML=Ss,At=s(),g(ve.$$.fragment),Ot=s(),g(Ie.$$.fragment),Kt=s(),we=o("p"),we.innerHTML=Ws,en=s(),g(Ue.$$.fragment),tn=s(),F=o("blockquote"),F.innerHTML=Gs,nn=s(),g(Me.$$.fragment),sn=s(),I=o("div"),g(xe.$$.fragment),vn=s(),st=o("p"),st.textContent=Bs,In=s(),it=o("p"),it.innerHTML=Vs,wn=s(),ot=o("p"),ot.textContent=Es,Un=s(),at=o("ul"),at.innerHTML=Ns,Mn=s(),E=o("div"),g(Ce.$$.fragment),xn=s(),lt=o("p"),lt.textContent=Xs,Cn=s(),g(Y.$$.fragment),Pn=s(),k=o("div"),g(Pe.$$.fragment),Tn=s(),rt=o("p"),rt.textContent=zs,$n=s(),Te=o("blockquote"),Te.innerHTML=Rs,Ln=s(),g(Q.$$.fragment),Jn=s(),D=o("div"),g($e.$$.fragment),Zn=s(),pt=o("p"),pt.innerHTML=Hs,kn=s(),q=o("div"),g(Le.$$.fragment),jn=s(),dt=o("p"),dt.textContent=Fs,Sn=s(),A=o("div"),g(Je.$$.fragment),Wn=s(),ct=o("p"),ct.innerHTML=Ys,Gn=s(),j=o("div"),g(Ze.$$.fragment),Bn=s(),mt=o("p"),mt.innerHTML=Qs,Vn=s(),ke=o("blockquote"),ke.innerHTML=Ds,En=s(),g(O.$$.fragment),Nn=s(),K=o("div"),g(je.$$.fragment),Xn=s(),gt=o("p"),gt.innerHTML=qs,zn=s(),ee=o("div"),g(Se.$$.fragment),Rn=s(),ft=o("p"),ft.textContent=As,Hn=s(),L=o("div"),g(We.$$.fragment),Fn=s(),ut=o("p"),ut.innerHTML=Os,Yn=s(),ht=o("p"),ht.textContent=Ks,Qn=s(),_t=o("ol"),_t.innerHTML=ei,Dn=s(),bt=o("p"),bt.innerHTML=ti,qn=s(),yt=o("p"),yt.textContent=ni,on=s(),g(Ge.$$.fragment),an=s(),w=o("div"),g(Be.$$.fragment),An=s(),vt=o("p"),vt.textContent=si,On=s(),It=o("p"),It.innerHTML=ii,Kn=s(),wt=o("p"),wt.textContent=oi,es=s(),Ut=o("ul"),Ut.innerHTML=ai,ts=s(),N=o("div"),g(Ve.$$.fragment),ns=s(),Mt=o("p"),Mt.textContent=li,ss=s(),g(te.$$.fragment),is=s(),S=o("div"),g(Ee.$$.fragment),os=s(),xt=o("p"),xt.textContent=ri,as=s(),Ne=o("blockquote"),Ne.innerHTML=pi,ls=s(),g(ne.$$.fragment),rs=s(),se=o("div"),g(Xe.$$.fragment),ps=s(),Ct=o("p"),Ct.innerHTML=di,ds=s(),ie=o("div"),g(ze.$$.fragment),cs=s(),Pt=o("p"),Pt.textContent=ci,ms=s(),oe=o("div"),g(Re.$$.fragment),gs=s(),Tt=o("p"),Tt.innerHTML=mi,fs=s(),W=o("div"),g(He.$$.fragment),us=s(),$t=o("p"),$t.innerHTML=gi,hs=s(),Fe=o("blockquote"),Fe.innerHTML=fi,_s=s(),g(ae.$$.fragment),bs=s(),le=o("div"),g(Ye.$$.fragment),ys=s(),Lt=o("p"),Lt.innerHTML=ui,vs=s(),re=o("div"),g(Qe.$$.fragment),Is=s(),Jt=o("p"),Jt.textContent=hi,ws=s(),J=o("div"),g(De.$$.fragment),Us=s(),Zt=o("p"),Zt.innerHTML=_i,Ms=s(),kt=o("p"),kt.textContent=bi,xs=s(),jt=o("ol"),jt.innerHTML=yi,Cs=s(),St=o("p"),St.innerHTML=vi,Ps=s(),Wt=o("p"),Wt.textContent=Ii,ln=s(),g(qe.$$.fragment),rn=s(),X=o("div"),g(Ae.$$.fragment),Ts=s(),Gt=o("p"),Gt.textContent=wi,pn=s(),g(Oe.$$.fragment),dn=s(),Nt=o("p"),this.h()},l(e){const r=Pi("svelte-u9bgzb",document.head);p=a(r,"META",{name:!0,content:!0}),r.forEach(l),T=i(e),v=a(e,"P",{}),P(v).forEach(l),c=i(e),f(y.$$.fragment,e),n=i(e),U=a(e,"DIV",{class:!0,"data-svelte-h":!0}),d(U)!=="svelte-si9ct8"&&(U.innerHTML=$s),Xt=i(e),me=a(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-bd6hsa"&&(me.innerHTML=Ls),zt=i(e),ge=a(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1cwsb16"&&(ge.textContent=Js),Rt=i(e),fe=a(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-ha34c8"&&(fe.innerHTML=Zs),Ht=i(e),f(ue.$$.fragment,e),Ft=i(e),he=a(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-ozodyw"&&(he.innerHTML=ks),Yt=i(e),f(_e.$$.fragment,e),Qt=i(e),be=a(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1sz02mh"&&(be.innerHTML=js),Dt=i(e),f(ye.$$.fragment,e),qt=i(e),H=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(H)!=="svelte-1sxyju0"&&(H.innerHTML=Ss),At=i(e),f(ve.$$.fragment,e),Ot=i(e),f(Ie.$$.fragment,e),Kt=i(e),we=a(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1mvqeru"&&(we.innerHTML=Ws),en=i(e),f(Ue.$$.fragment,e),tn=i(e),F=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(F)!=="svelte-r1jcqf"&&(F.innerHTML=Gs),nn=i(e),f(Me.$$.fragment,e),sn=i(e),I=a(e,"DIV",{class:!0});var M=P(I);f(xe.$$.fragment,M),vn=i(M),st=a(M,"P",{"data-svelte-h":!0}),d(st)!=="svelte-2c89j6"&&(st.textContent=Bs),In=i(M),it=a(M,"P",{"data-svelte-h":!0}),d(it)!=="svelte-496sm0"&&(it.innerHTML=Vs),wn=i(M),ot=a(M,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-14s6m4u"&&(ot.textContent=Es),Un=i(M),at=a(M,"UL",{"data-svelte-h":!0}),d(at)!=="svelte-txtwv6"&&(at.innerHTML=Ns),Mn=i(M),E=a(M,"DIV",{class:!0});var z=P(E);f(Ce.$$.fragment,z),xn=i(z),lt=a(z,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-50j04k"&&(lt.textContent=Xs),Cn=i(z),f(Y.$$.fragment,z),z.forEach(l),Pn=i(M),k=a(M,"DIV",{class:!0});var V=P(k);f(Pe.$$.fragment,V),Tn=i(V),rt=a(V,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-10jaql7"&&(rt.textContent=zs),$n=i(V),Te=a(V,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(Te)!=="svelte-zc9fvp"&&(Te.innerHTML=Rs),Ln=i(V),f(Q.$$.fragment,V),V.forEach(l),Jn=i(M),D=a(M,"DIV",{class:!0});var Ke=P(D);f($e.$$.fragment,Ke),Zn=i(Ke),pt=a(Ke,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1lh0nh5"&&(pt.innerHTML=Hs),Ke.forEach(l),kn=i(M),q=a(M,"DIV",{class:!0});var et=P(q);f(Le.$$.fragment,et),jn=i(et),dt=a(et,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-14bnrb6"&&(dt.textContent=Fs),et.forEach(l),Sn=i(M),A=a(M,"DIV",{class:!0});var tt=P(A);f(Je.$$.fragment,tt),Wn=i(tt),ct=a(tt,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1s3c06i"&&(ct.innerHTML=Ys),tt.forEach(l),Gn=i(M),j=a(M,"DIV",{class:!0});var pe=P(j);f(Ze.$$.fragment,pe),Bn=i(pe),mt=a(pe,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-e03q3e"&&(mt.innerHTML=Qs),Vn=i(pe),ke=a(pe,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(ke)!=="svelte-3y0te0"&&(ke.innerHTML=Ds),En=i(pe),f(O.$$.fragment,pe),pe.forEach(l),Nn=i(M),K=a(M,"DIV",{class:!0});var mn=P(K);f(je.$$.fragment,mn),Xn=i(mn),gt=a(mn,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1vfte1e"&&(gt.innerHTML=qs),mn.forEach(l),zn=i(M),ee=a(M,"DIV",{class:!0});var gn=P(ee);f(Se.$$.fragment,gn),Rn=i(gn),ft=a(gn,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-16q0ax1"&&(ft.textContent=As),gn.forEach(l),Hn=i(M),L=a(M,"DIV",{class:!0});var G=P(L);f(We.$$.fragment,G),Fn=i(G),ut=a(G,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1e71opl"&&(ut.innerHTML=Os),Yn=i(G),ht=a(G,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-acyrt"&&(ht.textContent=Ks),Qn=i(G),_t=a(G,"OL",{"data-svelte-h":!0}),d(_t)!=="svelte-114uhci"&&(_t.innerHTML=ei),Dn=i(G),bt=a(G,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-46dthp"&&(bt.innerHTML=ti),qn=i(G),yt=a(G,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-4ngutd"&&(yt.textContent=ni),G.forEach(l),M.forEach(l),on=i(e),f(Ge.$$.fragment,e),an=i(e),w=a(e,"DIV",{class:!0});var C=P(w);f(Be.$$.fragment,C),An=i(C),vt=a(C,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-y15i80"&&(vt.textContent=si),On=i(C),It=a(C,"P",{"data-svelte-h":!0}),d(It)!=="svelte-496sm0"&&(It.innerHTML=ii),Kn=i(C),wt=a(C,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-14s6m4u"&&(wt.textContent=oi),es=i(C),Ut=a(C,"UL",{"data-svelte-h":!0}),d(Ut)!=="svelte-txtwv6"&&(Ut.innerHTML=ai),ts=i(C),N=a(C,"DIV",{class:!0});var Bt=P(N);f(Ve.$$.fragment,Bt),ns=i(Bt),Mt=a(Bt,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-50j04k"&&(Mt.textContent=li),ss=i(Bt),f(te.$$.fragment,Bt),Bt.forEach(l),is=i(C),S=a(C,"DIV",{class:!0});var de=P(S);f(Ee.$$.fragment,de),os=i(de),xt=a(de,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-10jaql7"&&(xt.textContent=ri),as=i(de),Ne=a(de,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(Ne)!=="svelte-zc9fvp"&&(Ne.innerHTML=pi),ls=i(de),f(ne.$$.fragment,de),de.forEach(l),rs=i(C),se=a(C,"DIV",{class:!0});var fn=P(se);f(Xe.$$.fragment,fn),ps=i(fn),Ct=a(fn,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-1lh0nh5"&&(Ct.innerHTML=di),fn.forEach(l),ds=i(C),ie=a(C,"DIV",{class:!0});var un=P(ie);f(ze.$$.fragment,un),cs=i(un),Pt=a(un,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-14bnrb6"&&(Pt.textContent=ci),un.forEach(l),ms=i(C),oe=a(C,"DIV",{class:!0});var hn=P(oe);f(Re.$$.fragment,hn),gs=i(hn),Tt=a(hn,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1s3c06i"&&(Tt.innerHTML=mi),hn.forEach(l),fs=i(C),W=a(C,"DIV",{class:!0});var ce=P(W);f(He.$$.fragment,ce),us=i(ce),$t=a(ce,"P",{"data-svelte-h":!0}),d($t)!=="svelte-e03q3e"&&($t.innerHTML=gi),hs=i(ce),Fe=a(ce,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(Fe)!=="svelte-3y0te0"&&(Fe.innerHTML=fi),_s=i(ce),f(ae.$$.fragment,ce),ce.forEach(l),bs=i(C),le=a(C,"DIV",{class:!0});var _n=P(le);f(Ye.$$.fragment,_n),ys=i(_n),Lt=a(_n,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1vfte1e"&&(Lt.innerHTML=ui),_n.forEach(l),vs=i(C),re=a(C,"DIV",{class:!0});var bn=P(re);f(Qe.$$.fragment,bn),Is=i(bn),Jt=a(bn,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-16q0ax1"&&(Jt.textContent=hi),bn.forEach(l),ws=i(C),J=a(C,"DIV",{class:!0});var B=P(J);f(De.$$.fragment,B),Us=i(B),Zt=a(B,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-1e71opl"&&(Zt.innerHTML=_i),Ms=i(B),kt=a(B,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-acyrt"&&(kt.textContent=bi),xs=i(B),jt=a(B,"OL",{"data-svelte-h":!0}),d(jt)!=="svelte-114uhci"&&(jt.innerHTML=yi),Cs=i(B),St=a(B,"P",{"data-svelte-h":!0}),d(St)!=="svelte-46dthp"&&(St.innerHTML=vi),Ps=i(B),Wt=a(B,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-4ngutd"&&(Wt.textContent=Ii),B.forEach(l),C.forEach(l),ln=i(e),f(qe.$$.fragment,e),rn=i(e),X=a(e,"DIV",{class:!0});var yn=P(X);f(Ae.$$.fragment,yn),Ts=i(yn),Gt=a(yn,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-19wetgi"&&(Gt.textContent=wi),yn.forEach(l),pn=i(e),f(Oe.$$.fragment,e),dn=i(e),Nt=a(e,"P",{}),P(Nt).forEach(l),this.h()},h(){x(p,"name","hf:doc:metadata"),x(p,"content",Wi),x(U,"class","flex flex-wrap space-x-1"),x(H,"class","warning"),x(F,"class","tip"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Te,"class","warning"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ke,"class","warning"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ne,"class","warning"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Fe,"class","warning"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,p),m(e,T,r),m(e,v,r),m(e,c,r),u(y,e,r),m(e,n,r),m(e,U,r),m(e,Xt,r),m(e,me,r),m(e,zt,r),m(e,ge,r),m(e,Rt,r),m(e,fe,r),m(e,Ht,r),u(ue,e,r),m(e,Ft,r),m(e,he,r),m(e,Yt,r),u(_e,e,r),m(e,Qt,r),m(e,be,r),m(e,Dt,r),u(ye,e,r),m(e,qt,r),m(e,H,r),m(e,At,r),u(ve,e,r),m(e,Ot,r),u(Ie,e,r),m(e,Kt,r),m(e,we,r),m(e,en,r),u(Ue,e,r),m(e,tn,r),m(e,F,r),m(e,nn,r),u(Me,e,r),m(e,sn,r),m(e,I,r),u(xe,I,null),t(I,vn),t(I,st),t(I,In),t(I,it),t(I,wn),t(I,ot),t(I,Un),t(I,at),t(I,Mn),t(I,E),u(Ce,E,null),t(E,xn),t(E,lt),t(E,Cn),u(Y,E,null),t(I,Pn),t(I,k),u(Pe,k,null),t(k,Tn),t(k,rt),t(k,$n),t(k,Te),t(k,Ln),u(Q,k,null),t(I,Jn),t(I,D),u($e,D,null),t(D,Zn),t(D,pt),t(I,kn),t(I,q),u(Le,q,null),t(q,jn),t(q,dt),t(I,Sn),t(I,A),u(Je,A,null),t(A,Wn),t(A,ct),t(I,Gn),t(I,j),u(Ze,j,null),t(j,Bn),t(j,mt),t(j,Vn),t(j,ke),t(j,En),u(O,j,null),t(I,Nn),t(I,K),u(je,K,null),t(K,Xn),t(K,gt),t(I,zn),t(I,ee),u(Se,ee,null),t(ee,Rn),t(ee,ft),t(I,Hn),t(I,L),u(We,L,null),t(L,Fn),t(L,ut),t(L,Yn),t(L,ht),t(L,Qn),t(L,_t),t(L,Dn),t(L,bt),t(L,qn),t(L,yt),m(e,on,r),u(Ge,e,r),m(e,an,r),m(e,w,r),u(Be,w,null),t(w,An),t(w,vt),t(w,On),t(w,It),t(w,Kn),t(w,wt),t(w,es),t(w,Ut),t(w,ts),t(w,N),u(Ve,N,null),t(N,ns),t(N,Mt),t(N,ss),u(te,N,null),t(w,is),t(w,S),u(Ee,S,null),t(S,os),t(S,xt),t(S,as),t(S,Ne),t(S,ls),u(ne,S,null),t(w,rs),t(w,se),u(Xe,se,null),t(se,ps),t(se,Ct),t(w,ds),t(w,ie),u(ze,ie,null),t(ie,cs),t(ie,Pt),t(w,ms),t(w,oe),u(Re,oe,null),t(oe,gs),t(oe,Tt),t(w,fs),t(w,W),u(He,W,null),t(W,us),t(W,$t),t(W,hs),t(W,Fe),t(W,_s),u(ae,W,null),t(w,bs),t(w,le),u(Ye,le,null),t(le,ys),t(le,Lt),t(w,vs),t(w,re),u(Qe,re,null),t(re,Is),t(re,Jt),t(w,ws),t(w,J),u(De,J,null),t(J,Us),t(J,Zt),t(J,Ms),t(J,kt),t(J,xs),t(J,jt),t(J,Cs),t(J,St),t(J,Ps),t(J,Wt),m(e,ln,r),u(qe,e,r),m(e,rn,r),m(e,X,r),u(Ae,X,null),t(X,Ts),t(X,Gt),m(e,pn,r),u(Oe,e,r),m(e,dn,r),m(e,Nt,r),cn=!0},p(e,[r]){const M={};r&2&&(M.$$scope={dirty:r,ctx:e}),Y.$set(M);const z={};r&2&&(z.$$scope={dirty:r,ctx:e}),Q.$set(z);const V={};r&2&&(V.$$scope={dirty:r,ctx:e}),O.$set(V);const Ke={};r&2&&(Ke.$$scope={dirty:r,ctx:e}),te.$set(Ke);const et={};r&2&&(et.$$scope={dirty:r,ctx:e}),ne.$set(et);const tt={};r&2&&(tt.$$scope={dirty:r,ctx:e}),ae.$set(tt)},i(e){cn||(h(y.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(ve.$$.fragment,e),h(Ie.$$.fragment,e),h(Ue.$$.fragment,e),h(Me.$$.fragment,e),h(xe.$$.fragment,e),h(Ce.$$.fragment,e),h(Y.$$.fragment,e),h(Pe.$$.fragment,e),h(Q.$$.fragment,e),h($e.$$.fragment,e),h(Le.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h(O.$$.fragment,e),h(je.$$.fragment,e),h(Se.$$.fragment,e),h(We.$$.fragment,e),h(Ge.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(te.$$.fragment,e),h(Ee.$$.fragment,e),h(ne.$$.fragment,e),h(Xe.$$.fragment,e),h(ze.$$.fragment,e),h(Re.$$.fragment,e),h(He.$$.fragment,e),h(ae.$$.fragment,e),h(Ye.$$.fragment,e),h(Qe.$$.fragment,e),h(De.$$.fragment,e),h(qe.$$.fragment,e),h(Ae.$$.fragment,e),h(Oe.$$.fragment,e),cn=!0)},o(e){_(y.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(Ie.$$.fragment,e),_(Ue.$$.fragment,e),_(Me.$$.fragment,e),_(xe.$$.fragment,e),_(Ce.$$.fragment,e),_(Y.$$.fragment,e),_(Pe.$$.fragment,e),_(Q.$$.fragment,e),_($e.$$.fragment,e),_(Le.$$.fragment,e),_(Je.$$.fragment,e),_(Ze.$$.fragment,e),_(O.$$.fragment,e),_(je.$$.fragment,e),_(Se.$$.fragment,e),_(We.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(Ve.$$.fragment,e),_(te.$$.fragment,e),_(Ee.$$.fragment,e),_(ne.$$.fragment,e),_(Xe.$$.fragment,e),_(ze.$$.fragment,e),_(Re.$$.fragment,e),_(He.$$.fragment,e),_(ae.$$.fragment,e),_(Ye.$$.fragment,e),_(Qe.$$.fragment,e),_(De.$$.fragment,e),_(qe.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),cn=!1},d(e){e&&(l(T),l(v),l(c),l(n),l(U),l(Xt),l(me),l(zt),l(ge),l(Rt),l(fe),l(Ht),l(Ft),l(he),l(Yt),l(Qt),l(be),l(Dt),l(qt),l(H),l(At),l(Ot),l(Kt),l(we),l(en),l(tn),l(F),l(nn),l(sn),l(I),l(on),l(an),l(w),l(ln),l(rn),l(X),l(pn),l(dn),l(Nt)),l(p),b(y,e),b(ue,e),b(_e,e),b(ye,e),b(ve,e),b(Ie,e),b(Ue,e),b(Me,e),b(xe),b(Ce),b(Y),b(Pe),b(Q),b($e),b(Le),b(Je),b(Ze),b(O),b(je),b(Se),b(We),b(Ge,e),b(Be),b(Ve),b(te),b(Ee),b(ne),b(Xe),b(ze),b(Re),b(He),b(ae),b(Ye),b(Qe),b(De),b(qe,e),b(Ae),b(Oe,e)}}}const Wi='{"title":"Stable unCLIP","local":"stable-unclip","sections":[{"title":"Tips","local":"tips","sections":[{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":3},{"title":"Text guided Image-to-Image Variation","local":"text-guided-image-to-image-variation","sections":[],"depth":3}],"depth":2},{"title":"StableUnCLIPPipeline","local":"diffusers.StableUnCLIPPipeline","sections":[],"depth":2},{"title":"StableUnCLIPImg2ImgPipeline","local":"diffusers.StableUnCLIPImg2ImgPipeline","sections":[],"depth":2},{"title":"ImagePipelineOutput","local":"diffusers.ImagePipelineOutput","sections":[],"depth":2}],"depth":1}';function Gi(Z){return Mi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ri extends xi{constructor(p){super(),Ci(this,p,Gi,Si,Ui,{})}}export{Ri as component};
