import{s as Pa,o as Za,n as La}from"../chunks/scheduler.888833de.js";import{S as Ga,i as Ra,e as o,s as l,c as u,h as Aa,a,d as i,b as n,f as vi,g as p,j as r,k as P,l as $,m as s,n as f,t as d,o as h,p as m}from"../chunks/index.128ce987.js";import{C as b}from"../chunks/CodeBlock.37df032e.js";import{H as w,E as Ba}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";import{H as Wa,a as ja}from"../chunks/HfOption.79a0a3f5.js";function qa(C){let c,T='Share your GitHub pipeline by opening a pull request on the Diffusers <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> and add the one_step_unet.py file to the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> subfolder.';return{c(){c=o("p"),c.innerHTML=T},l(y){c=a(y,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1o65hru"&&(c.innerHTML=T)},m(y,M){s(y,c,M)},p:La,d(y){y&&i(c)}}}function Va(C){let c,T="Share your Hub pipeline by creating a model repository on the Hub and uploading the one_step_unet.py file to it.";return{c(){c=o("p"),c.textContent=T},l(y){c=a(y,"P",{"data-svelte-h":!0}),r(c)!=="svelte-b63tr0"&&(c.textContent=T)},m(y,M){s(y,c,M)},p:La,d(y){y&&i(c)}}}function Xa(C){let c,T,y,M;return c=new ja({props:{id:"pipeline type",option:"GitHub pipeline",$$slots:{default:[qa]},$$scope:{ctx:C}}}),y=new ja({props:{id:"pipeline type",option:"Hub pipeline",$$slots:{default:[Va]},$$scope:{ctx:C}}}),{c(){u(c.$$.fragment),T=l(),u(y.$$.fragment)},l(g){p(c.$$.fragment,g),T=n(g),p(y.$$.fragment,g)},m(g,v){f(c,g,v),s(g,T,v),f(y,g,v),M=!0},p(g,v){const x={};v&2&&(x.$$scope={dirty:v,ctx:g}),c.$set(x);const Ci={};v&2&&(Ci.$$scope={dirty:v,ctx:g}),y.$set(Ci)},i(g){M||(d(c.$$.fragment,g),d(y.$$.fragment,g),M=!0)},o(g){h(c.$$.fragment,g),h(y.$$.fragment,g),M=!1},d(g){g&&i(T),m(c,g),m(y,g)}}}function Na(C){let c,T,y,M,g,v,x,Ci="We ❤️ contributions from the open-source community! Everyone is welcome, and all types of participation –not just code– are valued and appreciated. Answering questions, helping others, reaching out, and improving the documentation are all immensely valuable to the community, so don’t be afraid and get involved if you’re up for it!",Hi,Z,Jn='Everyone is encouraged to start by saying 👋 in our public Discord channel. We discuss the latest trends in diffusion models, ask questions, show off personal projects, help each other with contributions, or just hang out ☕. <a href="https://Discord.gg/G7tWnz98XR"><img alt="Join us on Discord" src="https://img.shields.io/discord/823813159592001537?color=5865F2&amp;logo=discord&amp;logoColor=white"/></a>',_i,G,Hn='Whichever way you choose to contribute, we strive to be part of an open, welcoming, and kind community. Please, read our <a href="https://github.com/huggingface/diffusers/blob/main/CODE_OF_CONDUCT.md" rel="nofollow">code of conduct</a> and be mindful to respect it during your interactions. We also recommend you become familiar with the <a href="https://huggingface.co/docs/diffusers/conceptual/ethical_guidelines" rel="nofollow">ethical guidelines</a> that guide our project and ask you to adhere to the same principles of transparency and responsibility.',Ui,R,_n="We enormously value feedback from the community, so please do not be afraid to speak up if you believe you have valuable feedback that can help improve the library - every message, comment, issue, and pull request (PR) is read and considered.",ji,A,Li,B,Un="You can contribute in many ways ranging from answering questions on issues and discussions to adding new diffusion models to the core library.",Pi,W,jn="In the following, we give an overview of different ways to contribute, ranked by difficulty in ascending order. All of them are valuable to the community.",Zi,q,Ln='<li><ol><li>Asking and answering questions on <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers" rel="nofollow">the Diffusers discussion forum</a> or on <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.</li></ol></li> <li><ol start="2"><li>Opening new issues on <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">the GitHub Issues tab</a> or new discussions on <a href="https://github.com/huggingface/diffusers/discussions/new/choose" rel="nofollow">the GitHub Discussions tab</a>.</li></ol></li> <li><ol start="3"><li>Answering issues on <a href="https://github.com/huggingface/diffusers/issues" rel="nofollow">the GitHub Issues tab</a> or discussions on <a href="https://github.com/huggingface/diffusers/discussions" rel="nofollow">the GitHub Discussions tab</a>.</li></ol></li> <li><ol start="4"><li>Fix a simple issue, marked by the “Good first issue” label, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">here</a>.</li></ol></li> <li><ol start="5"><li>Contribute to the <a href="https://github.com/huggingface/diffusers/tree/main/docs/source" rel="nofollow">documentation</a>.</li></ol></li> <li><ol start="6"><li>Contribute a <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3Acommunity-examples" rel="nofollow">Community Pipeline</a>.</li></ol></li> <li><ol start="7"><li>Contribute to the <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a>.</li></ol></li> <li><ol start="8"><li>Fix a more difficult issue, marked by the “Good second issue” label, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+second+issue%22" rel="nofollow">here</a>.</li></ol></li> <li><ol start="9"><li>Add a new pipeline, model, or scheduler, see <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+pipeline%2Fmodel%22" rel="nofollow">“New Pipeline/Model”</a> and <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+scheduler%22" rel="nofollow">“New scheduler”</a> issues. For this contribution, please have a look at <a href="https://github.com/huggingface/diffusers/blob/main/PHILOSOPHY.md" rel="nofollow">Design Philosophy</a>.</li></ol></li>',Gi,V,Pn=`As said before, <strong>all contributions are valuable to the community</strong>.
In the following, we will explain each contribution a bit more in detail.`,Ri,X,Zn='For all contributions 4 - 9, you will need to open a PR. It is explained in detail how to do so in <a href="#how-to-open-a-pr">Opening a pull request</a>.',Ai,N,Bi,D,Gn='Any question or comment related to the Diffusers library can be asked on the <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/" rel="nofollow">discussion forum</a> or on <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>. Such questions and comments include (but are not limited to):',Wi,S,Rn="<li>Reports of training or inference experiments in an attempt to share knowledge</li> <li>Presentation of personal projects</li> <li>Questions to non-official training examples</li> <li>Project proposals</li> <li>General feedback</li> <li>Paper summaries</li> <li>Asking for help on personal projects that build on top of the Diffusers library</li> <li>General questions</li> <li>Ethical questions regarding diffusion models</li> <li>…</li>",qi,F,An=`Every question that is asked on the forum or on Discord actively encourages the community to publicly
share knowledge and might very well help a beginner in the future who has the same question you’re
having. Please do pose any questions you might have.
In the same spirit, you are of immense help to the community by answering such questions because this way you are publicly documenting knowledge for everybody to learn from.`,Vi,Y,Bn=`<strong>Please</strong> keep in mind that the more effort you put into asking or answering a question, the higher
the quality of the publicly documented knowledge. In the same way, well-posed and well-answered questions create a high-quality knowledge database accessible to everybody, while badly posed questions or answers reduce the overall quality of the public knowledge database.
In short, a high quality question or answer is <em>precise</em>, <em>concise</em>, <em>relevant</em>, <em>easy-to-understand</em>, <em>accessible</em>, and <em>well-formatted/well-posed</em>. For more information, please have a look through the <a href="#how-to-write-a-good-issue">How to write a good issue</a> section.`,Xi,z,Wn=`<strong>NOTE about channels</strong>:
<a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow"><em>The forum</em></a> is much better indexed by search engines, such as Google. Posts are ranked by popularity rather than chronologically. Hence, it’s easier to look up questions and answers that we posted some time ago.
In addition, questions and answers posted in the forum can easily be linked to.
In contrast, <em>Discord</em> has a chat-like format that invites fast back-and-forth communication.
While it will most likely take less time for you to get an answer to your question on Discord, your
question won’t be visible anymore over time. Also, it’s much harder to find information that was posted a while back on Discord. We therefore strongly recommend using the forum for high-quality questions and answers in an attempt to create long-lasting knowledge for the community. If discussions on Discord lead to very interesting answers and conclusions, we recommend posting the results on the forum to make the information more available for future readers.`,Ni,E,Di,Q,qn=`The 🧨 Diffusers library is robust and reliable thanks to the users who notify us of
the problems they encounter. So thank you for reporting an issue.`,Si,O,Vn="Remember, GitHub issues are reserved for technical questions directly related to the Diffusers library, bug reports, feature requests, or feedback on the library design.",Fi,K,Xn='In a nutshell, this means that everything that is <strong>not</strong> related to the <strong>code of the Diffusers library</strong> (including the documentation) should <strong>not</strong> be asked on GitHub, but rather on either the <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow">forum</a> or <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.',Yi,ee,Nn="<strong>Please consider the following guidelines when opening a new issue</strong>:",zi,te,Dn=`<li>Make sure you have searched whether your issue has already been asked before (use the search bar on GitHub under Issues).</li> <li>Please never report a new issue on another (related) issue. If another issue is highly related, please
open a new issue nevertheless and link to the related issue.</li> <li>Make sure your issue is written in English. Please use one of the great, free online translation services, such as <a href="https://www.deepl.com/translator" rel="nofollow">DeepL</a> to translate from your native language to English if you are not comfortable in English.</li> <li>Check whether your issue might be solved by updating to the newest Diffusers version. Before posting your issue, please make sure that <code>python -c &quot;import diffusers; print(diffusers.__version__)&quot;</code> is higher or matches the latest Diffusers version.</li> <li>Remember that the more effort you put into opening a new issue, the higher the quality of your answer will be and the better the overall quality of the Diffusers issues.</li>`,Ei,ie,Sn="New issues usually include the following.",Qi,se,Oi,le,Fn=`A bug report should always have a reproducible code snippet and be as minimal and concise as possible.
This means in more detail:`,Ki,ne,Yn='<li>Narrow the bug down as much as you can, <strong>do not just dump your whole code file</strong>.</li> <li>Format your code.</li> <li>Do not include any external libraries except for Diffusers depending on them.</li> <li><strong>Always</strong> provide all necessary information about your environment; for this, you can run: <code>diffusers-cli env</code> in your shell and copy-paste the displayed information to the issue.</li> <li>Explain the issue. If the reader doesn’t know what the issue is and why it is an issue, (s)he cannot solve it.</li> <li><strong>Always</strong> make sure the reader can reproduce your issue with as little effort as possible. If your code snippet cannot be run because of missing libraries or undefined variables, the reader cannot help you. Make sure your reproducible code snippet is as minimal as possible and can be copy-pasted into a simple Python shell.</li> <li>If in order to reproduce your issue a model and/or dataset is required, make sure the reader has access to that model or dataset. You can always upload your model or dataset to the <a href="https://huggingface.co" rel="nofollow">Hub</a> to make it easily downloadable. Try to keep your model and dataset as small as possible, to make the reproduction of your issue as effortless as possible.</li>',es,oe,zn='For more information, please have a look through the <a href="#how-to-write-a-good-issue">How to write a good issue</a> section.',ts,ae,En='You can open a bug report <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=bug&amp;projects=&amp;template=bug-report.yml" rel="nofollow">here</a>.',is,re,ss,ue,Qn="A world-class feature request addresses the following points:",ls,pe,On="<li>Motivation first:</li>",ns,fe,Kn=`<li>Is it related to a problem/frustration with the library? If so, please explain
why. Providing a code snippet that demonstrates the problem is best.</li> <li>Is it related to something you would need for a project? We’d love to hear
about it!</li> <li>Is it something you worked on and think could benefit the community?
Awesome! Tell us what problem it solved for you.</li>`,os,J,eo="<li>Write a <em>full paragraph</em> describing the feature;</li> <li>Provide a <strong>code snippet</strong> that demonstrates its future use;</li> <li>In case this is related to a paper, please attach a link;</li> <li>Attach any additional information (drawings, screenshots, etc.) you think may help.</li>",as,de,to='You can open a feature request <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feature_request.md&amp;title=" rel="nofollow">here</a>.',rs,he,us,me,io=`Feedback about the library design and why it is good or not good helps the core maintainers immensely to build a user-friendly library. To understand the philosophy behind the current design philosophy, please have a look <a href="https://huggingface.co/docs/diffusers/conceptual/philosophy" rel="nofollow">here</a>. If you feel like a certain design choice does not fit with the current design philosophy, please explain why and how it should be changed. If a certain design choice follows the design philosophy too much, hence restricting use cases, explain why and how it should be changed.
If a certain design choice is very useful for you, please also leave a note as this is great feedback for future design decisions.`,ps,ce,so='You can open an issue about feedback <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">here</a>.',fs,ge,ds,ye,lo=`Technical questions are mainly about why certain code of the library was written in a certain way, or what a certain part of the code does. Please make sure to link to the code in question and please provide details on
why this part of the code is difficult to understand.`,hs,we,no='You can open an issue about a technical question <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=bug&amp;template=bug-report.yml" rel="nofollow">here</a>.',ms,be,cs,Te,oo="If the diffusion model community released a new model, pipeline, or scheduler that you would like to see in the Diffusers library, please provide the following information:",gs,Me,ao="<li>Short description of the diffusion pipeline, model, or scheduler and link to the paper or public release.</li> <li>Link to any of its open-source implementation(s).</li> <li>Link to the model weights if they are available.</li>",ys,ve,ro=`If you are willing to contribute to the model yourself, let us know so we can best guide you. Also, don’t forget
to tag the original author of the component (model, scheduler, pipeline, etc.) by GitHub handle if you can find it.`,ws,$e,uo='You can open a request for a model/pipeline/scheduler <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=New+model%2Fpipeline%2Fscheduler&amp;template=new-model-addition.yml" rel="nofollow">here</a>.',bs,xe,Ts,Ie,po=`Answering issues on GitHub might require some technical knowledge of Diffusers, but we encourage everybody to give it a try even if you are not 100% certain that your answer is correct.
Some tips to give a high-quality answer to an issue:`,Ms,ke,fo="<li>Be as concise and minimal as possible.</li> <li>Stay on topic. An answer to the issue should concern the issue and only the issue.</li> <li>Provide links to code, papers, or other sources that prove or encourage your point.</li> <li>Answer in code. If a simple code snippet is the answer to the issue or shows how the issue can be solved, please provide a fully reproducible code snippet.</li>",vs,Ce,ho=`Also, many issues tend to be simply off-topic, duplicates of other issues, or irrelevant. It is of great
help to the maintainers if you can answer such issues, encouraging the author of the issue to be
more precise, provide the link to a duplicated issue or redirect them to <a href="https://discuss.huggingface.co/c/discussion-related-to-httpsgithubcomhuggingfacediffusers/63" rel="nofollow">the forum</a> or <a href="https://discord.gg/G7tWnz98XR" rel="nofollow">Discord</a>.`,$s,Je,mo=`If you have verified that the issued bug report is correct and requires a correction in the source code,
please have a look at the next sections.`,xs,He,co='For all of the following contributions, you will need to open a PR. It is explained in detail how to do so in the <a href="#how-to-open-a-pr">Opening a pull request</a> section.',Is,_e,ks,Ue,go=`<em>Good first issues</em> are marked by the <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">Good first issue</a> label. Usually, the issue already
explains how a potential solution should look so that it is easier to fix.
If the issue hasn’t been closed and you would like to try to fix this issue, you can just leave a message “I would like to try this issue.”. There are usually three scenarios:`,Cs,je,yo="<li>a.) The issue description already proposes a fix. In this case and if the solution makes sense to you, you can open a PR or draft PR to fix it.</li> <li>b.) The issue description does not propose a fix. In this case, you can ask what a proposed fix could look like and someone from the Diffusers team should answer shortly. If you have a good idea of how to fix it, feel free to directly open a PR.</li> <li>c.) There is already an open PR to fix the issue, but the issue hasn’t been closed yet. If the PR has gone stale, you can simply open a new PR and link to the stale PR. PRs often go stale if the original contributor who wanted to fix the issue suddenly cannot find the time anymore to proceed. This often happens in open-source and is very normal. In this case, the community will be very happy if you give it a new try and leverage the knowledge of the existing PR. If there is already a PR and it is active, you can help the author by giving suggestions, reviewing the PR or even asking whether you can contribute to the PR.</li>",Js,Le,Hs,Pe,wo=`A good library <strong>always</strong> has good documentation! The official documentation is often one of the first points of contact for new users of the library, and therefore contributing to the documentation is a <strong>highly
valuable contribution</strong>.`,_s,Ze,bo="Contributing to the library can have many forms:",Us,Ge,To="<li>Correcting spelling or grammatical errors.</li> <li>Correct incorrect formatting of the docstring. If you see that the official documentation is weirdly displayed or a link is broken, we would be very happy if you take some time to correct it.</li> <li>Correct the shape or dimensions of a docstring input or output tensor.</li> <li>Clarify documentation that is hard to understand or incorrect.</li> <li>Update outdated code examples.</li> <li>Translating the documentation to another language.</li>",js,Re,Mo='Anything displayed on <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">the official Diffusers doc page</a> is part of the official documentation and can be corrected, adjusted in the respective <a href="https://github.com/huggingface/diffusers/tree/main/docs/source" rel="nofollow">documentation source</a>.',Ls,Ae,vo='Please have a look at <a href="https://github.com/huggingface/diffusers/tree/main/docs" rel="nofollow">this page</a> on how to verify changes made to the documentation locally.',Ps,Be,Zs,H,$o='<p>Read the <a href="../using-diffusers/custom_pipeline_overview#community-pipelines">Community pipelines</a> guide to learn more about the difference between a GitHub and Hugging Face Hub community pipeline. If you’re interested in why we have community pipelines, take a look at GitHub Issue <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">#841</a> (basically, we can’t maintain all the possible ways diffusion models can be used for inference but we also don’t want to prevent the community from building them).</p>',Gs,We,xo='Contributing a community pipeline is a great way to share your creativity and work with the community. It lets you build on top of the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> so that anyone can load and use it by setting the <code>custom_pipeline</code> parameter. This section will walk you through how to create a simple pipeline where the UNet only does a single forward pass and calls the scheduler once (a “one-step” pipeline).',Rs,qe,Io='<li><p>Create a one_step_unet.py file for your community pipeline. This file can contain whatever package you want to use as long as it’s installed by the user. Make sure you only have one pipeline class that inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to load model weights and the scheduler configuration from the Hub. Add a UNet and scheduler to the <code>__init__</code> function.</p> <p>You should also add the <code>register_modules</code> function to ensure your pipeline and its components can be saved with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</p></li>',As,Ve,Bs,Xe,ko="<li>In the forward pass (which we recommend defining as <code>__call__</code>), you can add any feature you’d like. For the “one-step” pipeline, create a random image and call the UNet and scheduler once by setting <code>timestep=1</code>.</li>",Ws,Ne,qs,De,Co="Now you can run the pipeline by passing a UNet and scheduler to it or load pretrained weights if the pipeline structure is identical.",Vs,Se,Xs,Fe,Jo="You can either share your pipeline as a GitHub community pipeline or Hub community pipeline.",Ns,_,Ds,Ye,Ss,ze,Ho='Diffusers examples are a collection of training scripts that reside in <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a>.',Fs,Ee,_o="We support two types of training examples:",Ys,Qe,Uo="<li>Official training examples</li> <li>Research training examples</li>",zs,Oe,jo=`Research training examples are located in <a href="https://github.com/huggingface/diffusers/tree/main/examples/research_projects" rel="nofollow">examples/research_projects</a> whereas official training examples include all folders under <a href="https://github.com/huggingface/diffusers/tree/main/examples" rel="nofollow">examples</a> except the <code>research_projects</code> and <code>community</code> folders.
The official training examples are maintained by the Diffusers’ core maintainers whereas the research training examples are maintained by the community.
This is because of the same reasons put forward in <a href="#6-contribute-a-community-pipeline">6. Contribute a community pipeline</a> for official pipelines vs. community pipelines: It is not feasible for the core maintainers to maintain all possible training methods for diffusion models.
If the Diffusers core maintainers and the community consider a certain training paradigm to be too experimental or not popular enough, the corresponding training code should be put in the <code>research_projects</code> folder and maintained by the author.`,Es,Ke,Lo=`Both official training and research examples consist of a directory that contains one or more training scripts, a <code>requirements.txt</code> file, and a <code>README.md</code> file. In order for the user to make use of the
training examples, it is required to clone the repository:`,Qs,et,Os,tt,Po="as well as to install all additional dependencies required for training:",Ks,it,el,st,Zo='Therefore when adding an example, the <code>requirements.txt</code> file shall define all pip dependencies required for your training example so that once all those are installed, the user can run the example’s training script. See, for example, the <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/requirements.txt" rel="nofollow">DreamBooth <code>requirements.txt</code> file</a>.',tl,lt,Go="Training examples of the Diffusers library should adhere to the following philosophy:",il,nt,Ro="<li>All the code necessary to run the examples should be found in a single Python file.</li> <li>One should be able to run the example from the command line with <code>python &lt;your-example&gt;.py --args</code>.</li> <li>Examples should be kept simple and serve as <strong>an example</strong> on how to use Diffusers for training. The purpose of example scripts is <strong>not</strong> to create state-of-the-art diffusion models, but rather to reproduce known training schemes without adding too much custom logic. As a byproduct of this point, our examples also strive to serve as good educational materials.</li>",sl,ot,Ao=`To contribute an example, it is highly recommended to look at already existing examples such as <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/train_dreambooth.py" rel="nofollow">dreambooth</a> to get an idea of how they should look like.
We strongly advise contributors to make use of the <a href="https://github.com/huggingface/accelerate" rel="nofollow">Accelerate library</a> as it’s tightly integrated
with Diffusers.
Once an example script works, please make sure to add a comprehensive <code>README.md</code> that states how to use the example exactly. This README should include:`,ll,at,Bo='<li>An example command on how to run the example script as shown <a href="https://github.com/huggingface/diffusers/tree/main/examples/dreambooth#running-locally-with-pytorch" rel="nofollow">here</a>.</li> <li>A link to some training results (logs, models, etc.) that show what the user can expect as shown <a href="https://api.wandb.ai/report/patrickvonplaten/xm6cd5q5" rel="nofollow">here</a>.</li> <li>If you are adding a non-official/research training example, <strong>please don’t forget</strong> to add a sentence that you are maintaining this training example which includes your git handle as shown <a href="https://github.com/huggingface/diffusers/tree/main/examples/research_projects/intel_opts#diffusers-examples-with-intel-optimizations" rel="nofollow">here</a>.</li>',nl,rt,Wo='If you are contributing to the official training examples, please also make sure to add a test to its folder such as <a href="https://github.com/huggingface/diffusers/blob/main/examples/dreambooth/test_dreambooth.py" rel="nofollow">examples/dreambooth/test_dreambooth.py</a>. This is not necessary for non-official training examples.',ol,ut,al,pt,qo=`<em>Good second issues</em> are marked by the <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+second+issue%22" rel="nofollow">Good second issue</a> label. Good second issues are
usually more complicated to solve than <a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22" rel="nofollow">Good first issues</a>.
The issue description usually gives less guidance on how to fix the issue and requires
a decent understanding of the library by the interested contributor.
If you are interested in tackling a good second issue, feel free to open a PR to fix it and link the PR to the issue. If you see that a PR has already been opened for this issue but did not get merged, have a look to understand why it wasn’t merged and try to open an improved PR.
Good second issues are usually more difficult to get merged compared to good first issues, so don’t hesitate to ask for help from the core maintainers. If your PR is almost finished the core maintainers can also jump into your PR and commit to it in order to get it merged.`,rl,ft,ul,dt,Vo=`Pipelines, models, and schedulers are the most important pieces of the Diffusers library.
They provide easy access to state-of-the-art diffusion technologies and thus allow the community to
build powerful generative AI applications.`,pl,ht,Xo="By adding a new model, pipeline, or scheduler you might enable a new powerful use case for any of the user interfaces relying on Diffusers which can be of immense value for the whole generative AI ecosystem.",fl,mt,No=`Diffusers has a couple of open feature requests for all three components - feel free to gloss over them
if you don’t know yet what specific component you would like to add:`,dl,ct,Do='<li><a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+pipeline%2Fmodel%22" rel="nofollow">Model or pipeline</a></li> <li><a href="https://github.com/huggingface/diffusers/issues?q=is%3Aopen+is%3Aissue+label%3A%22New+scheduler%22" rel="nofollow">Scheduler</a></li>',hl,gt,So=`Before adding any of the three components, it is strongly recommended that you give the <a href="philosophy">Philosophy guide</a> a read to better understand the design of any of the three components. Please be aware that we cannot merge model, scheduler, or pipeline additions that strongly diverge from our design philosophy
as it will lead to API inconsistencies. If you fundamentally disagree with a design choice, please open a <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">Feedback issue</a> instead so that it can be discussed whether a certain design pattern/design choice shall be changed everywhere in the library and whether we shall update our design philosophy. Consistency across the library is very important for us.`,ml,yt,Fo="Please make sure to add links to the original codebase/paper to the PR and ideally also ping the original author directly on the PR so that they can follow the progress and potentially help with questions.",cl,wt,Yo="If you are unsure or stuck in the PR, don’t hesitate to leave a message to ask for a first review or help.",gl,bt,yl,Tt,zo="A unique and important feature to understand when adding any pipeline, model or scheduler code is the <code># Copied from</code> mechanism. You’ll see this all over the Diffusers codebase, and the reason we use it is to keep the codebase easy to understand and maintain. Marking code with the <code># Copied from</code> mechanism forces the marked code to be identical to the code it was copied from. This makes it easy to update and propagate changes across many files whenever you run <code>make fix-copies</code>.",wl,Mt,Eo='For example, in the code example below, <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> is the original code and <code>AltDiffusionPipelineOutput</code> uses the <code># Copied from</code> mechanism to copy it. The only difference is changing the class prefix from <code>Stable</code> to <code>Alt</code>.',bl,vt,Tl,$t,Qo='To learn more, read this section of the <a href="https://huggingface.co/blog/transformers-design-philosophy#4-machine-learning-models-are-static" rel="nofollow">~Don’t~ Repeat Yourself*</a> blog post.',Ml,xt,vl,It,Oo="<strong>The better your issue is written, the higher the chances that it will be quickly resolved.</strong>",$l,kt,Ko='<li>Make sure that you’ve used the correct template for your issue. You can pick between <em>Bug Report</em>, <em>Feature Request</em>, <em>Feedback about API Design</em>, <em>New model/pipeline/scheduler addition</em>, <em>Forum</em>, or a blank issue. Make sure to pick the correct one when opening <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">a new issue</a>.</li> <li><strong>Be precise</strong>: Give your issue a fitting title. Try to formulate your issue description as simple as possible. The more precise you are when submitting an issue, the less time it takes to understand the issue and potentially solve it. Make sure to open an issue for one issue only and not for multiple issues. If you found multiple issues, simply open multiple issues. If your issue is a bug, try to be as precise as possible about what bug it is - you should not just write “Error in diffusers”.</li> <li><strong>Reproducibility</strong>: No reproducible code snippet == no solution. If you encounter a bug, maintainers <strong>have to be able to reproduce</strong> it. Make sure that you include a code snippet that can be copy-pasted into a Python interpreter to reproduce the issue. Make sure that your code snippet works, <em>i.e.</em> that there are no missing imports or missing links to images, … Your issue should contain an error message <strong>and</strong> a code snippet that can be copy-pasted without any changes to reproduce the exact same error message. If your issue is using local model weights or local data that cannot be accessed by the reader, the issue cannot be solved. If you cannot share your data or model, try to make a dummy model or dummy data.</li> <li><strong>Minimalistic</strong>: Try to help the reader as much as you can to understand the issue as quickly as possible by staying as concise as possible. Remove all code / all information that is irrelevant to the issue. If you have found a bug, try to create the easiest code example you can to demonstrate your issue, do not just dump your whole workflow into the issue as soon as you have found a bug. E.g., if you train a model and get an error at some point during the training, you should first try to understand what part of the training code is responsible for the error and try to reproduce it with a couple of lines. Try to use dummy data instead of full datasets.</li> <li>Add links. If you are referring to a certain naming, method, or model make sure to provide a link so that the reader can better understand what you mean. If you are referring to a specific PR or issue, make sure to link it to your issue. Do not assume that the reader knows what you are talking about. The more links you add to your issue the better.</li> <li>Formatting. Make sure to nicely format your issue by formatting code into Python code syntax, and error messages into normal code syntax. See the <a href="https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax" rel="nofollow">official GitHub formatting docs</a> for more information.</li> <li>Think of your issue not as a ticket to be solved, but rather as a beautiful entry to a well-written encyclopedia. Every added issue is a contribution to publicly available knowledge. By adding a nicely written issue you not only make it easier for maintainers to solve your issue, but you are helping the whole community to better understand a certain aspect of the library.</li>',xl,Ct,Il,Jt,ea=`<li>Be a chameleon. Understand existing design patterns and syntax and make sure your code additions flow seamlessly into the existing code base. Pull requests that significantly diverge from existing design patterns or user interfaces will not be merged.</li> <li>Be laser focused. A pull request should solve one problem and one problem only. Make sure to not fall into the trap of “also fixing another problem while we’re adding it”. It is much more difficult to review pull requests that solve multiple, unrelated problems at once.</li> <li>If helpful, try to add a code snippet that displays an example of how your addition can be used.</li> <li>The title of your pull request should be a summary of its contribution.</li> <li>If your pull request addresses an issue, please mention the issue number in
the pull request description to make sure they are linked (and people
consulting the issue know you are working on it);</li> <li>To indicate a work in progress please prefix the title with <code>[WIP]</code>. These
are useful to avoid duplicated work, and to differentiate it from PRs ready
to be merged;</li> <li>Try to formulate and format your text as explained in <a href="#how-to-write-a-good-issue">How to write a good issue</a>.</li> <li>Make sure existing tests pass;</li> <li>Add high-coverage tests. No quality testing = no merge.</li>`,kl,Ht,ta=`<li>If you are adding new <code>@slow</code> tests, make sure they pass using
<code>RUN_SLOW=1 python -m pytest tests/test_my_new_model.py</code>.
CircleCI does not run the slow tests, but GitHub Actions does every night!</li>`,Cl,U,ia=`<li>All public methods must have informative docstrings that work nicely with markdown. See <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/latent_diffusion/pipeline_latent_diffusion.py" rel="nofollow"><code>pipeline_latent_diffusion.py</code></a> for an example.</li> <li>Due to the rapidly growing repository, it is important to make sure that no files that would significantly weigh down the repository are added. This includes images, videos, and other non-text files. We prefer to leverage a hf.co hosted <code>dataset</code> like
<a href="https://huggingface.co/hf-internal-testing" rel="nofollow"><code>hf-internal-testing</code></a> or <a href="https://huggingface.co/datasets/huggingface/documentation-images" rel="nofollow">huggingface/documentation-images</a> to place these files.
If an external contribution, feel free to add the images to your PR and ask a Hugging Face member to migrate your images
to this dataset.</li>`,Jl,_t,Hl,Ut,sa=`Before writing code, we strongly advise you to search through the existing PRs or
issues to make sure that nobody is already working on the same thing. If you are
unsure, it is always a good idea to open an issue to get some feedback.`,_l,jt,la=`You will need basic <code>git</code> proficiency to be able to contribute to
🧨 Diffusers. <code>git</code> is not the easiest tool to use but it has the greatest
manual. Type <code>git --help</code> in a shell and enjoy. If you prefer books, <a href="https://git-scm.com/book/en/v2" rel="nofollow">Pro
Git</a> is a very good reference.`,Ul,Lt,na='Follow these steps to start contributing (<a href="https://github.com/huggingface/diffusers/blob/83bc6c94eaeb6f7704a2a428931cf2d9ad973ae9/setup.py#L270" rel="nofollow">supported Python versions</a>):',jl,I,$i,oa=`<p>Fork the <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> by
clicking on the ‘Fork’ button on the repository’s page. This creates a copy of the code
under your GitHub user account.</p>`,$n,Pt,xi,aa="Clone your fork to your local disk, and add the base repository as a remote:",xn,Zt,In,Gt,Ii,ra="Create a new branch to hold your development changes:",kn,Rt,Ll,At,ua="<strong>Do not</strong> work on the <code>main</code> branch.",Pl,Bt,Wt,ki,pa="Set up a development environment by running the following command in a virtual environment:",Cn,qt,Zl,Vt,fa=`If you have already cloned the repo, you might need to <code>git pull</code> to get the most recent changes in the
library.`,Gl,j,da="<li>Develop the features on your branch.</li>",Rl,Xt,ha=`As you work on the features, you should make sure that the test suite
passes. You should run the tests impacted by your changes like this:`,Al,Nt,Bl,Dt,ma=`Before you run the tests, please make sure you install the dependencies required for testing. You can do so
with this command:`,Wl,St,ql,Ft,ca=`You can also run the full test suite with the following command, but it takes
a beefy machine to produce a result in a decent amount of time now that
Diffusers has grown a lot. Here is the command for it:`,Vl,Yt,Xl,zt,ga=`🧨 Diffusers relies on <code>black</code> and <code>isort</code> to format its source code
consistently. After you make changes, apply automatic style corrections and code verifications
that can’t be automated in one go with:`,Nl,Et,Dl,Qt,ya=`🧨 Diffusers also uses <code>ruff</code> and a few custom scripts to check for coding mistakes. Quality
control runs in CI, however, you can also run the same checks with:`,Sl,Ot,Fl,Kt,wa=`Once you’re happy with your changes, add changed files using <code>git add</code> and
make a commit with <code>git commit</code> to record your changes locally:`,Yl,ei,zl,ti,ba=`It is a good idea to sync your copy of the code with the original
repository regularly. This way you can quickly account for changes:`,El,ii,Ql,si,Ta="Push the changes to your account using:",Ol,li,Kl,L,Ma=`<li><p>Once you are satisfied, go to the
webpage of your fork on GitHub. Click on ‘Pull request’ to send your changes
to the project maintainers for review.</p></li> <li><p>It’s OK if maintainers ask you for changes. It happens to core contributors
too! So everyone can see the changes in the Pull request, work in your local
branch and push the changes to your fork. They will automatically appear in
the pull request.</p></li>`,en,ni,tn,oi,va=`An extensive test suite is included to test the library behavior and several examples. Library tests can be found in
the <a href="https://github.com/huggingface/diffusers/tree/main/tests" rel="nofollow">tests folder</a>.`,sn,ai,$a=`We like <code>pytest</code> and <code>pytest-xdist</code> because it’s faster. From the root of the
repository, here’s how to run tests with <code>pytest</code> for the library:`,ln,ri,nn,ui,xa="In fact, that’s how <code>make test</code> is implemented!",on,pi,Ia=`You can specify a smaller set of tests in order to test only the feature
you’re working on.`,an,fi,ka=`By default, slow tests are skipped. Set the <code>RUN_SLOW</code> environment variable to
<code>yes</code> to run them. This will download many gigabytes of models — make sure you
have enough disk space and a good Internet connection, or a lot of patience!`,rn,di,un,hi,Ca="<code>unittest</code> is fully supported, here’s how to run tests with it:",pn,mi,fn,ci,dn,gi,Ja=`To avoid pinging the upstream repository which adds reference notes to each upstream PR and sends unnecessary notifications to the developers involved in these PRs,
when syncing the main branch of a forked repository, please, follow these steps:`,hn,yi,Ha="<li>When possible, avoid syncing with the upstream using a branch and PR on the forked repository. Instead, merge directly into the forked main.</li> <li>If a PR is absolutely necessary, use the following steps after checking out your branch:</li>",mn,wi,cn,bi,gn,Ti,_a='For documentation strings, 🧨 Diffusers follows the <a href="https://google.github.io/styleguide/pyguide.html" rel="nofollow">Google style</a>.',yn,Mi,wn,Ji,bn;return g=new w({props:{title:"How to contribute to Diffusers 🧨",local:"how-to-contribute-to-diffusers-",headingTag:"h1"}}),A=new w({props:{title:"Overview",local:"overview",headingTag:"h2"}}),N=new w({props:{title:"1. Asking and answering questions on the Diffusers discussion forum or on the Diffusers Discord",local:"1-asking-and-answering-questions-on-the-diffusers-discussion-forum-or-on-the-diffusers-discord",headingTag:"h3"}}),E=new w({props:{title:"2. Opening new issues on the GitHub issues tab",local:"2-opening-new-issues-on-the-github-issues-tab",headingTag:"h3"}}),se=new w({props:{title:"2.1. Reproducible, minimal bug reports",local:"21-reproducible-minimal-bug-reports",headingTag:"h4"}}),re=new w({props:{title:"2.2. Feature requests",local:"22-feature-requests",headingTag:"h4"}}),he=new w({props:{title:"2.3 Feedback",local:"23-feedback",headingTag:"h4"}}),ge=new w({props:{title:"2.4 Technical questions",local:"24-technical-questions",headingTag:"h4"}}),be=new w({props:{title:"2.5 Proposal to add a new model, scheduler, or pipeline",local:"25-proposal-to-add-a-new-model-scheduler-or-pipeline",headingTag:"h4"}}),xe=new w({props:{title:"3. Answering issues on the GitHub issues tab",local:"3-answering-issues-on-the-github-issues-tab",headingTag:"h3"}}),_e=new w({props:{title:"4. Fixing a “Good first issue”",local:"4-fixing-a-good-first-issue",headingTag:"h3"}}),Le=new w({props:{title:"5. Contribute to the documentation",local:"5-contribute-to-the-documentation",headingTag:"h3"}}),Be=new w({props:{title:"6. Contribute a community pipeline",local:"6-contribute-a-community-pipeline",headingTag:"h3"}}),Ve=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">class</span> <span class="hljs-title class_">UnetSchedulerOneForwardPipeline</span>(<span class="hljs-title class_ inherited__">DiffusionPipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, unet, scheduler</span>):
        <span class="hljs-built_in">super</span>().__init__()

        self.register_modules(unet=unet, scheduler=scheduler)`,wrap:!1}}),Ne=new b({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0b3JjaC5yYW5kbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoMSUyQyUyMHNlbGYudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBzZWxmLnVuZXQuY29uZmlnLnNhbXBsZV9zaXplJTJDJTIwc2VsZi51bmV0LmNvbmZpZy5zYW1wbGVfc2l6ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZXN0ZXAlMjAlM0QlMjAxJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfb3V0cHV0JTIwJTNEJTIwc2VsZi51bmV0KGltYWdlJTJDJTIwdGltZXN0ZXApLnNhbXBsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlcl9vdXRwdXQlMjAlM0QlMjBzZWxmLnNjaGVkdWxlci5zdGVwKG1vZGVsX291dHB1dCUyQyUyMHRpbWVzdGVwJTJDJTIwaW1hZ2UpLnByZXZfc2FtcGxlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NoZWR1bGVyX291dHB1dA==",highlighted:`  <span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
  <span class="hljs-keyword">import</span> torch

  <span class="hljs-keyword">class</span> <span class="hljs-title class_">UnetSchedulerOneForwardPipeline</span>(<span class="hljs-title class_ inherited__">DiffusionPipeline</span>):
      <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, unet, scheduler</span>):
          <span class="hljs-built_in">super</span>().__init__()

          self.register_modules(unet=unet, scheduler=scheduler)

      <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self</span>):
          image = torch.randn(
              (<span class="hljs-number">1</span>, self.unet.config.in_channels, self.unet.config.sample_size, self.unet.config.sample_size),
          )
          timestep = <span class="hljs-number">1</span>

          model_output = self.unet(image, timestep).sample
          scheduler_output = self.scheduler.step(model_output, timestep, image).prev_sample

          <span class="hljs-keyword">return</span> scheduler_output`,wrap:!1}}),Se=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIoKSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRNb2RlbCgpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCklMEElMjMlMjBsb2FkJTIwcHJldHJhaW5lZCUyMHdlaWdodHMlMEFwaXBlbGluZSUyMCUzRCUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZWxpbmUoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

scheduler = DDPMScheduler()
unet = UNet2DModel()

pipeline = UnetSchedulerOneForwardPipeline(unet=unet, scheduler=scheduler)
output = pipeline()
<span class="hljs-comment"># load pretrained weights</span>
pipeline = UnetSchedulerOneForwardPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
output = pipeline()`,wrap:!1}}),_=new Wa({props:{id:"pipeline type",options:["GitHub pipeline","Hub pipeline"],$$slots:{default:[Xa]},$$scope:{ctx:C}}}),Ye=new w({props:{title:"7. Contribute to training examples",local:"7-contribute-to-training-examples",headingTag:"h3"}}),et=new b({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2Vycw==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers',wrap:!1}}),it=new b({props:{code:"Y2QlMjBkaWZmdXNlcnMlMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjBleGFtcGxlcyUyRiUzQ3lvdXItZXhhbXBsZS1mb2xkZXIlM0UlMkZyZXF1aXJlbWVudHMudHh0",highlighted:`<span class="hljs-built_in">cd</span> diffusers
pip install -r examples/&lt;your-example-folder&gt;/requirements.txt`,wrap:!1}}),ut=new w({props:{title:"8. Fixing a “Good second issue”",local:"8-fixing-a-good-second-issue",headingTag:"h3"}}),ft=new w({props:{title:"9. Adding pipelines, models, schedulers",local:"9-adding-pipelines-models-schedulers",headingTag:"h3"}}),bt=new w({props:{title:"Copied from mechanism",local:"copied-from-mechanism",headingTag:"h4"}}),vt=new b({props:{code:"JTIzJTIwQ29waWVkJTIwZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbi5waXBlbGluZV9vdXRwdXQuU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmVPdXRwdXQlMjB3aXRoJTIwU3RhYmxlLSUzRUFsdCUwQWNsYXNzJTIwQWx0RGlmZnVzaW9uUGlwZWxpbmVPdXRwdXQoQmFzZU91dHB1dCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBPdXRwdXQlMjBjbGFzcyUyMGZvciUyMEFsdCUyMERpZmZ1c2lvbiUyMHBpcGVsaW5lcy4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2VzJTIwKCU2MExpc3QlNUJQSUwuSW1hZ2UuSW1hZ2UlNUQlNjAlMjBvciUyMCU2MG5wLm5kYXJyYXklNjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTGlzdCUyMG9mJTIwZGVub2lzZWQlMjBQSUwlMjBpbWFnZXMlMjBvZiUyMGxlbmd0aCUyMCU2MGJhdGNoX3NpemUlNjAlMjBvciUyME51bVB5JTIwYXJyYXklMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9jaGFubmVscyklNjAuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnNmd19jb250ZW50X2RldGVjdGVkJTIwKCU2MExpc3QlNUJib29sJTVEJTYwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExpc3QlMjBpbmRpY2F0aW5nJTIwd2hldGhlciUyMHRoZSUyMGNvcnJlc3BvbmRpbmclMjBnZW5lcmF0ZWQlMjBpbWFnZSUyMGNvbnRhaW5zJTIwJTIybm90LXNhZmUtZm9yLXdvcmslMjIlMjAobnNmdyklMjBjb250ZW50JTIwb3IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNjBOb25lJTYwJTIwaWYlMjBzYWZldHklMjBjaGVja2luZyUyMGNvdWxkJTIwbm90JTIwYmUlMjBwZXJmb3JtZWQuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIy",highlighted:'<span class="hljs-comment"># Copied from diffusers.pipelines.stable_diffusion.pipeline_output.StableDiffusionPipelineOutput with Stable-&gt;Alt</span>\n<span class="hljs-keyword">class</span> <span class="hljs-title class_">AltDiffusionPipelineOutput</span>(<span class="hljs-title class_ inherited__">BaseOutput</span>):\n    <span class="hljs-string">&quot;&quot;&quot;\n    Output class for Alt Diffusion pipelines.\n\n    Args:\n        images (`List[PIL.Image.Image]` or `np.ndarray`)\n            List of denoised PIL images of length `batch_size` or NumPy array of shape `(batch_size, height, width,\n            num_channels)`.\n        nsfw_content_detected (`List[bool]`)\n            List indicating whether the corresponding generated image contains &quot;not-safe-for-work&quot; (nsfw) content or\n            `None` if safety checking could not be performed.\n    &quot;&quot;&quot;</span>',wrap:!1}}),xt=new w({props:{title:"How to write a good issue",local:"how-to-write-a-good-issue",headingTag:"h2"}}),Ct=new w({props:{title:"How to write a good PR",local:"how-to-write-a-good-pr",headingTag:"h2"}}),_t=new w({props:{title:"How to open a PR",local:"how-to-open-a-pr",headingTag:"h2"}}),Zt=new b({props:{code:"JTI0JTIwZ2l0JTIwY2xvbmUlMjBnaXQlNDBnaXRodWIuY29tJTNBJTNDeW91ciUyMEdpdEh1YiUyMGhhbmRsZSUzRSUyRmRpZmZ1c2Vycy5naXQlMEElMjQlMjBjZCUyMGRpZmZ1c2VycyUwQSUyNCUyMGdpdCUyMHJlbW90ZSUyMGFkZCUyMHVwc3RyZWFtJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMuZ2l0",highlighted:`$ git <span class="hljs-built_in">clone</span> git@github.com:&lt;your GitHub handle&gt;/diffusers.git
$ <span class="hljs-built_in">cd</span> diffusers
$ git remote add upstream https://github.com/huggingface/diffusers.git`,wrap:!1}}),Rt=new b({props:{code:"JTI0JTIwZ2l0JTIwY2hlY2tvdXQlMjAtYiUyMGEtZGVzY3JpcHRpdmUtbmFtZS1mb3ItbXktY2hhbmdlcw==",highlighted:"$ git checkout -b a-descriptive-name-for-my-changes",wrap:!1}}),qt=new b({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QmRldiU1RCUyMg==",highlighted:'$ pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>',wrap:!1}}),Nt=new b({props:{code:"JTI0JTIwcHl0ZXN0JTIwdGVzdHMlMkYlM0NURVNUX1RPX1JVTiUzRS5weQ==",highlighted:"$ pytest tests/&lt;TEST_TO_RUN&gt;.py",wrap:!1}}),St=new b({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QnRlc3QlNUQlMjI=",highlighted:'$ pip install -e <span class="hljs-string">&quot;.[test]&quot;</span>',wrap:!1}}),Yt=new b({props:{code:"JTI0JTIwbWFrZSUyMHRlc3Q=",highlighted:'$ make <span class="hljs-built_in">test</span>',wrap:!1}}),Et=new b({props:{code:"JTI0JTIwbWFrZSUyMHN0eWxl",highlighted:"$ make style",wrap:!1}}),Ot=new b({props:{code:"JTI0JTIwbWFrZSUyMHF1YWxpdHk=",highlighted:"$ make quality",wrap:!1}}),ei=new b({props:{code:"JTI0JTIwZ2l0JTIwYWRkJTIwbW9kaWZpZWRfZmlsZS5weSUwQSUyNCUyMGdpdCUyMGNvbW1pdCUyMC1tJTIwJTIyQSUyMGRlc2NyaXB0aXZlJTIwbWVzc2FnZSUyMGFib3V0JTIweW91ciUyMGNoYW5nZXMuJTIy",highlighted:`$ git add modified_file.py
$ git commit -m <span class="hljs-string">&quot;A descriptive message about your changes.&quot;</span>`,wrap:!1}}),ii=new b({props:{code:"JTI0JTIwZ2l0JTIwcHVsbCUyMHVwc3RyZWFtJTIwbWFpbg==",highlighted:"$ git pull upstream main",wrap:!1}}),li=new b({props:{code:"JTI0JTIwZ2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"$ git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),ni=new w({props:{title:"Tests",local:"tests",headingTag:"h3"}}),ri=new b({props:{code:"JTI0JTIwcHl0aG9uJTIwLW0lMjBweXRlc3QlMjAtbiUyMGF1dG8lMjAtLWRpc3QlM0Rsb2FkZmlsZSUyMC1zJTIwLXYlMjAuJTJGdGVzdHMlMkY=",highlighted:"$ python -m pytest -n auto --dist=loadfile -s -v ./tests/",wrap:!1}}),di=new b({props:{code:"JTI0JTIwUlVOX1NMT1clM0R5ZXMlMjBweXRob24lMjAtbSUyMHB5dGVzdCUyMC1uJTIwYXV0byUyMC0tZGlzdCUzRGxvYWRmaWxlJTIwLXMlMjAtdiUyMC4lMkZ0ZXN0cyUyRg==",highlighted:'$ RUN_SLOW=<span class="hljs-built_in">yes</span> python -m pytest -n auto --dist=loadfile -s -v ./tests/',wrap:!1}}),mi=new b({props:{code:"JTI0JTIwcHl0aG9uJTIwLW0lMjB1bml0dGVzdCUyMGRpc2NvdmVyJTIwLXMlMjB0ZXN0cyUyMC10JTIwLiUyMC12JTBBJTI0JTIwcHl0aG9uJTIwLW0lMjB1bml0dGVzdCUyMGRpc2NvdmVyJTIwLXMlMjBleGFtcGxlcyUyMC10JTIwZXhhbXBsZXMlMjAtdg==",highlighted:`$ python -m unittest discover -s tests -t . -v
$ python -m unittest discover -s examples -t examples -v`,wrap:!1}}),ci=new w({props:{title:"Syncing forked main with upstream (HuggingFace) main",local:"syncing-forked-main-with-upstream-huggingface-main",headingTag:"h3"}}),wi=new b({props:{code:"JTI0JTIwZ2l0JTIwY2hlY2tvdXQlMjAtYiUyMHlvdXItYnJhbmNoLWZvci1zeW5jaW5nJTBBJTI0JTIwZ2l0JTIwcHVsbCUyMC0tc3F1YXNoJTIwLS1uby1jb21taXQlMjB1cHN0cmVhbSUyMG1haW4lMEElMjQlMjBnaXQlMjBjb21taXQlMjAtbSUyMCclM0N5b3VyJTIwbWVzc2FnZSUyMHdpdGhvdXQlMjBHaXRIdWIlMjByZWZlcmVuY2VzJTNFJyUwQSUyNCUyMGdpdCUyMHB1c2glMjAtLXNldC11cHN0cmVhbSUyMG9yaWdpbiUyMHlvdXItYnJhbmNoLWZvci1zeW5jaW5n",highlighted:`$ git checkout -b your-branch-for-syncing
$ git pull --squash --no-commit upstream main
$ git commit -m <span class="hljs-string">&#x27;&lt;your message without GitHub references&gt;&#x27;</span>
$ git push --set-upstream origin your-branch-for-syncing`,wrap:!1}}),bi=new w({props:{title:"Style guide",local:"style-guide",headingTag:"h3"}}),Mi=new Ba({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/conceptual/contribution.md"}}),{c(){c=o("meta"),T=l(),y=o("p"),M=l(),u(g.$$.fragment),v=l(),x=o("p"),x.textContent=Ci,Hi=l(),Z=o("p"),Z.innerHTML=Jn,_i=l(),G=o("p"),G.innerHTML=Hn,Ui=l(),R=o("p"),R.textContent=_n,ji=l(),u(A.$$.fragment),Li=l(),B=o("p"),B.textContent=Un,Pi=l(),W=o("p"),W.textContent=jn,Zi=l(),q=o("ul"),q.innerHTML=Ln,Gi=l(),V=o("p"),V.innerHTML=Pn,Ri=l(),X=o("p"),X.innerHTML=Zn,Ai=l(),u(N.$$.fragment),Bi=l(),D=o("p"),D.innerHTML=Gn,Wi=l(),S=o("ul"),S.innerHTML=Rn,qi=l(),F=o("p"),F.textContent=An,Vi=l(),Y=o("p"),Y.innerHTML=Bn,Xi=l(),z=o("p"),z.innerHTML=Wn,Ni=l(),u(E.$$.fragment),Di=l(),Q=o("p"),Q.textContent=qn,Si=l(),O=o("p"),O.textContent=Vn,Fi=l(),K=o("p"),K.innerHTML=Xn,Yi=l(),ee=o("p"),ee.innerHTML=Nn,zi=l(),te=o("ul"),te.innerHTML=Dn,Ei=l(),ie=o("p"),ie.textContent=Sn,Qi=l(),u(se.$$.fragment),Oi=l(),le=o("p"),le.textContent=Fn,Ki=l(),ne=o("ul"),ne.innerHTML=Yn,es=l(),oe=o("p"),oe.innerHTML=zn,ts=l(),ae=o("p"),ae.innerHTML=En,is=l(),u(re.$$.fragment),ss=l(),ue=o("p"),ue.textContent=Qn,ls=l(),pe=o("ol"),pe.innerHTML=On,ns=l(),fe=o("ul"),fe.innerHTML=Kn,os=l(),J=o("ol"),J.innerHTML=eo,as=l(),de=o("p"),de.innerHTML=to,rs=l(),u(he.$$.fragment),us=l(),me=o("p"),me.innerHTML=io,ps=l(),ce=o("p"),ce.innerHTML=so,fs=l(),u(ge.$$.fragment),ds=l(),ye=o("p"),ye.textContent=lo,hs=l(),we=o("p"),we.innerHTML=no,ms=l(),u(be.$$.fragment),cs=l(),Te=o("p"),Te.textContent=oo,gs=l(),Me=o("ul"),Me.innerHTML=ao,ys=l(),ve=o("p"),ve.textContent=ro,ws=l(),$e=o("p"),$e.innerHTML=uo,bs=l(),u(xe.$$.fragment),Ts=l(),Ie=o("p"),Ie.textContent=po,Ms=l(),ke=o("ul"),ke.innerHTML=fo,vs=l(),Ce=o("p"),Ce.innerHTML=ho,$s=l(),Je=o("p"),Je.textContent=mo,xs=l(),He=o("p"),He.innerHTML=co,Is=l(),u(_e.$$.fragment),ks=l(),Ue=o("p"),Ue.innerHTML=go,Cs=l(),je=o("ul"),je.innerHTML=yo,Js=l(),u(Le.$$.fragment),Hs=l(),Pe=o("p"),Pe.innerHTML=wo,_s=l(),Ze=o("p"),Ze.textContent=bo,Us=l(),Ge=o("ul"),Ge.innerHTML=To,js=l(),Re=o("p"),Re.innerHTML=Mo,Ls=l(),Ae=o("p"),Ae.innerHTML=vo,Ps=l(),u(Be.$$.fragment),Zs=l(),H=o("blockquote"),H.innerHTML=$o,Gs=l(),We=o("p"),We.innerHTML=xo,Rs=l(),qe=o("ol"),qe.innerHTML=Io,As=l(),u(Ve.$$.fragment),Bs=l(),Xe=o("ol"),Xe.innerHTML=ko,Ws=l(),u(Ne.$$.fragment),qs=l(),De=o("p"),De.textContent=Co,Vs=l(),u(Se.$$.fragment),Xs=l(),Fe=o("p"),Fe.textContent=Jo,Ns=l(),u(_.$$.fragment),Ds=l(),u(Ye.$$.fragment),Ss=l(),ze=o("p"),ze.innerHTML=Ho,Fs=l(),Ee=o("p"),Ee.textContent=_o,Ys=l(),Qe=o("ul"),Qe.innerHTML=Uo,zs=l(),Oe=o("p"),Oe.innerHTML=jo,Es=l(),Ke=o("p"),Ke.innerHTML=Lo,Qs=l(),u(et.$$.fragment),Os=l(),tt=o("p"),tt.textContent=Po,Ks=l(),u(it.$$.fragment),el=l(),st=o("p"),st.innerHTML=Zo,tl=l(),lt=o("p"),lt.textContent=Go,il=l(),nt=o("ul"),nt.innerHTML=Ro,sl=l(),ot=o("p"),ot.innerHTML=Ao,ll=l(),at=o("ul"),at.innerHTML=Bo,nl=l(),rt=o("p"),rt.innerHTML=Wo,ol=l(),u(ut.$$.fragment),al=l(),pt=o("p"),pt.innerHTML=qo,rl=l(),u(ft.$$.fragment),ul=l(),dt=o("p"),dt.textContent=Vo,pl=l(),ht=o("p"),ht.textContent=Xo,fl=l(),mt=o("p"),mt.textContent=No,dl=l(),ct=o("ul"),ct.innerHTML=Do,hl=l(),gt=o("p"),gt.innerHTML=So,ml=l(),yt=o("p"),yt.textContent=Fo,cl=l(),wt=o("p"),wt.textContent=Yo,gl=l(),u(bt.$$.fragment),yl=l(),Tt=o("p"),Tt.innerHTML=zo,wl=l(),Mt=o("p"),Mt.innerHTML=Eo,bl=l(),u(vt.$$.fragment),Tl=l(),$t=o("p"),$t.innerHTML=Qo,Ml=l(),u(xt.$$.fragment),vl=l(),It=o("p"),It.innerHTML=Oo,$l=l(),kt=o("ol"),kt.innerHTML=Ko,xl=l(),u(Ct.$$.fragment),Il=l(),Jt=o("ol"),Jt.innerHTML=ea,kl=l(),Ht=o("ul"),Ht.innerHTML=ta,Cl=l(),U=o("ol"),U.innerHTML=ia,Jl=l(),u(_t.$$.fragment),Hl=l(),Ut=o("p"),Ut.textContent=sa,_l=l(),jt=o("p"),jt.innerHTML=la,Ul=l(),Lt=o("p"),Lt.innerHTML=na,jl=l(),I=o("ol"),$i=o("li"),$i.innerHTML=oa,$n=l(),Pt=o("li"),xi=o("p"),xi.textContent=aa,xn=l(),u(Zt.$$.fragment),In=l(),Gt=o("li"),Ii=o("p"),Ii.textContent=ra,kn=l(),u(Rt.$$.fragment),Ll=l(),At=o("p"),At.innerHTML=ua,Pl=l(),Bt=o("ol"),Wt=o("li"),ki=o("p"),ki.textContent=pa,Cn=l(),u(qt.$$.fragment),Zl=l(),Vt=o("p"),Vt.innerHTML=fa,Gl=l(),j=o("ol"),j.innerHTML=da,Rl=l(),Xt=o("p"),Xt.textContent=ha,Al=l(),u(Nt.$$.fragment),Bl=l(),Dt=o("p"),Dt.textContent=ma,Wl=l(),u(St.$$.fragment),ql=l(),Ft=o("p"),Ft.textContent=ca,Vl=l(),u(Yt.$$.fragment),Xl=l(),zt=o("p"),zt.innerHTML=ga,Nl=l(),u(Et.$$.fragment),Dl=l(),Qt=o("p"),Qt.innerHTML=ya,Sl=l(),u(Ot.$$.fragment),Fl=l(),Kt=o("p"),Kt.innerHTML=wa,Yl=l(),u(ei.$$.fragment),zl=l(),ti=o("p"),ti.textContent=ba,El=l(),u(ii.$$.fragment),Ql=l(),si=o("p"),si.textContent=Ta,Ol=l(),u(li.$$.fragment),Kl=l(),L=o("ol"),L.innerHTML=Ma,en=l(),u(ni.$$.fragment),tn=l(),oi=o("p"),oi.innerHTML=va,sn=l(),ai=o("p"),ai.innerHTML=$a,ln=l(),u(ri.$$.fragment),nn=l(),ui=o("p"),ui.innerHTML=xa,on=l(),pi=o("p"),pi.textContent=Ia,an=l(),fi=o("p"),fi.innerHTML=ka,rn=l(),u(di.$$.fragment),un=l(),hi=o("p"),hi.innerHTML=Ca,pn=l(),u(mi.$$.fragment),fn=l(),u(ci.$$.fragment),dn=l(),gi=o("p"),gi.textContent=Ja,hn=l(),yi=o("ol"),yi.innerHTML=Ha,mn=l(),u(wi.$$.fragment),cn=l(),u(bi.$$.fragment),gn=l(),Ti=o("p"),Ti.innerHTML=_a,yn=l(),u(Mi.$$.fragment),wn=l(),Ji=o("p"),this.h()},l(e){const t=Aa("svelte-u9bgzb",document.head);c=a(t,"META",{name:!0,content:!0}),t.forEach(i),T=n(e),y=a(e,"P",{}),vi(y).forEach(i),M=n(e),p(g.$$.fragment,e),v=n(e),x=a(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-5law2j"&&(x.textContent=Ci),Hi=n(e),Z=a(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-rf5fv0"&&(Z.innerHTML=Jn),_i=n(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-7yk1qu"&&(G.innerHTML=Hn),Ui=n(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-19e4jq9"&&(R.textContent=_n),ji=n(e),p(A.$$.fragment,e),Li=n(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1pen9i3"&&(B.textContent=Un),Pi=n(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-vste1h"&&(W.textContent=jn),Zi=n(e),q=a(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1xn76m2"&&(q.innerHTML=Ln),Gi=n(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1a17ouk"&&(V.innerHTML=Pn),Ri=n(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1carl1x"&&(X.innerHTML=Zn),Ai=n(e),p(N.$$.fragment,e),Bi=n(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-eooydc"&&(D.innerHTML=Gn),Wi=n(e),S=a(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1pzwmv0"&&(S.innerHTML=Rn),qi=n(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1gi90ut"&&(F.textContent=An),Vi=n(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-l08yk4"&&(Y.innerHTML=Bn),Xi=n(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-14aelba"&&(z.innerHTML=Wn),Ni=n(e),p(E.$$.fragment,e),Di=n(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1xkk71m"&&(Q.textContent=qn),Si=n(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1kqqlyc"&&(O.textContent=Vn),Fi=n(e),K=a(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-180qij7"&&(K.innerHTML=Xn),Yi=n(e),ee=a(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1fjofc5"&&(ee.innerHTML=Nn),zi=n(e),te=a(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-pzymlv"&&(te.innerHTML=Dn),Ei=n(e),ie=a(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1gfbuxb"&&(ie.textContent=Sn),Qi=n(e),p(se.$$.fragment,e),Oi=n(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1ipsy1e"&&(le.textContent=Fn),Ki=n(e),ne=a(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-h3kzdf"&&(ne.innerHTML=Yn),es=n(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-b221ai"&&(oe.innerHTML=zn),ts=n(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1vpz9iu"&&(ae.innerHTML=En),is=n(e),p(re.$$.fragment,e),ss=n(e),ue=a(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1s92zhu"&&(ue.textContent=Qn),ls=n(e),pe=a(e,"OL",{"data-svelte-h":!0}),r(pe)!=="svelte-1meaa0h"&&(pe.innerHTML=On),ns=n(e),fe=a(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-1m6et35"&&(fe.innerHTML=Kn),os=n(e),J=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(J)!=="svelte-1353nnk"&&(J.innerHTML=eo),as=n(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1fbsnox"&&(de.innerHTML=to),rs=n(e),p(he.$$.fragment,e),us=n(e),me=a(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-14r8j00"&&(me.innerHTML=io),ps=n(e),ce=a(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-19nmi90"&&(ce.innerHTML=so),fs=n(e),p(ge.$$.fragment,e),ds=n(e),ye=a(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-w10b99"&&(ye.textContent=lo),hs=n(e),we=a(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-117d5cx"&&(we.innerHTML=no),ms=n(e),p(be.$$.fragment,e),cs=n(e),Te=a(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-10axoet"&&(Te.textContent=oo),gs=n(e),Me=a(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-djw2fh"&&(Me.innerHTML=ao),ys=n(e),ve=a(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1g4ps0b"&&(ve.textContent=ro),ws=n(e),$e=a(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-sc0vav"&&($e.innerHTML=uo),bs=n(e),p(xe.$$.fragment,e),Ts=n(e),Ie=a(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-15u5nyq"&&(Ie.textContent=po),Ms=n(e),ke=a(e,"UL",{"data-svelte-h":!0}),r(ke)!=="svelte-1utx7xe"&&(ke.innerHTML=fo),vs=n(e),Ce=a(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1h98g7p"&&(Ce.innerHTML=ho),$s=n(e),Je=a(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1n38hfq"&&(Je.textContent=mo),xs=n(e),He=a(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1aq6j4g"&&(He.innerHTML=co),Is=n(e),p(_e.$$.fragment,e),ks=n(e),Ue=a(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-17d5j91"&&(Ue.innerHTML=go),Cs=n(e),je=a(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-csw3jn"&&(je.innerHTML=yo),Js=n(e),p(Le.$$.fragment,e),Hs=n(e),Pe=a(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-p135hl"&&(Pe.innerHTML=wo),_s=n(e),Ze=a(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-dmhl9b"&&(Ze.textContent=bo),Us=n(e),Ge=a(e,"UL",{"data-svelte-h":!0}),r(Ge)!=="svelte-1vfa69p"&&(Ge.innerHTML=To),js=n(e),Re=a(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1fszx"&&(Re.innerHTML=Mo),Ls=n(e),Ae=a(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-6of141"&&(Ae.innerHTML=vo),Ps=n(e),p(Be.$$.fragment,e),Zs=n(e),H=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(H)!=="svelte-ohak4h"&&(H.innerHTML=$o),Gs=n(e),We=a(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1ailit"&&(We.innerHTML=xo),Rs=n(e),qe=a(e,"OL",{"data-svelte-h":!0}),r(qe)!=="svelte-15eiart"&&(qe.innerHTML=Io),As=n(e),p(Ve.$$.fragment,e),Bs=n(e),Xe=a(e,"OL",{"data-svelte-h":!0}),r(Xe)!=="svelte-16wphgq"&&(Xe.innerHTML=ko),Ws=n(e),p(Ne.$$.fragment,e),qs=n(e),De=a(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-kiwzsg"&&(De.textContent=Co),Vs=n(e),p(Se.$$.fragment,e),Xs=n(e),Fe=a(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-17fzb10"&&(Fe.textContent=Jo),Ns=n(e),p(_.$$.fragment,e),Ds=n(e),p(Ye.$$.fragment,e),Ss=n(e),ze=a(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1695xih"&&(ze.innerHTML=Ho),Fs=n(e),Ee=a(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-dlx7ai"&&(Ee.textContent=_o),Ys=n(e),Qe=a(e,"UL",{"data-svelte-h":!0}),r(Qe)!=="svelte-15twepo"&&(Qe.innerHTML=Uo),zs=n(e),Oe=a(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1ao1iff"&&(Oe.innerHTML=jo),Es=n(e),Ke=a(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1gukmah"&&(Ke.innerHTML=Lo),Qs=n(e),p(et.$$.fragment,e),Os=n(e),tt=a(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-idor3x"&&(tt.textContent=Po),Ks=n(e),p(it.$$.fragment,e),el=n(e),st=a(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1951zcj"&&(st.innerHTML=Zo),tl=n(e),lt=a(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1m6im41"&&(lt.textContent=Go),il=n(e),nt=a(e,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-1xy9lh5"&&(nt.innerHTML=Ro),sl=n(e),ot=a(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-68kw4k"&&(ot.innerHTML=Ao),ll=n(e),at=a(e,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-df85hq"&&(at.innerHTML=Bo),nl=n(e),rt=a(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-c5qj5g"&&(rt.innerHTML=Wo),ol=n(e),p(ut.$$.fragment,e),al=n(e),pt=a(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-hbgtxz"&&(pt.innerHTML=qo),rl=n(e),p(ft.$$.fragment,e),ul=n(e),dt=a(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-if0791"&&(dt.textContent=Vo),pl=n(e),ht=a(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-9zs46y"&&(ht.textContent=Xo),fl=n(e),mt=a(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-ktahrm"&&(mt.textContent=No),dl=n(e),ct=a(e,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-1frr5y8"&&(ct.innerHTML=Do),hl=n(e),gt=a(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1nju92b"&&(gt.innerHTML=So),ml=n(e),yt=a(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1575xev"&&(yt.textContent=Fo),cl=n(e),wt=a(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-15y7ezq"&&(wt.textContent=Yo),gl=n(e),p(bt.$$.fragment,e),yl=n(e),Tt=a(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-vqa3gp"&&(Tt.innerHTML=zo),wl=n(e),Mt=a(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1hsoem"&&(Mt.innerHTML=Eo),bl=n(e),p(vt.$$.fragment,e),Tl=n(e),$t=a(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-bmf593"&&($t.innerHTML=Qo),Ml=n(e),p(xt.$$.fragment,e),vl=n(e),It=a(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-160saia"&&(It.innerHTML=Oo),$l=n(e),kt=a(e,"OL",{"data-svelte-h":!0}),r(kt)!=="svelte-147evhz"&&(kt.innerHTML=Ko),xl=n(e),p(Ct.$$.fragment,e),Il=n(e),Jt=a(e,"OL",{"data-svelte-h":!0}),r(Jt)!=="svelte-1dyfapb"&&(Jt.innerHTML=ea),kl=n(e),Ht=a(e,"UL",{"data-svelte-h":!0}),r(Ht)!=="svelte-bfdf0l"&&(Ht.innerHTML=ta),Cl=n(e),U=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(U)!=="svelte-9teity"&&(U.innerHTML=ia),Jl=n(e),p(_t.$$.fragment,e),Hl=n(e),Ut=a(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-18wldn4"&&(Ut.textContent=sa),_l=n(e),jt=a(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-ha1e2a"&&(jt.innerHTML=la),Ul=n(e),Lt=a(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-sqcxna"&&(Lt.innerHTML=na),jl=n(e),I=a(e,"OL",{});var k=vi(I);$i=a(k,"LI",{"data-svelte-h":!0}),r($i)!=="svelte-1051ijo"&&($i.innerHTML=oa),$n=n(k),Pt=a(k,"LI",{});var Tn=vi(Pt);xi=a(Tn,"P",{"data-svelte-h":!0}),r(xi)!=="svelte-clge5v"&&(xi.textContent=aa),xn=n(Tn),p(Zt.$$.fragment,Tn),Tn.forEach(i),In=n(k),Gt=a(k,"LI",{});var Mn=vi(Gt);Ii=a(Mn,"P",{"data-svelte-h":!0}),r(Ii)!=="svelte-imt6wq"&&(Ii.textContent=ra),kn=n(Mn),p(Rt.$$.fragment,Mn),Mn.forEach(i),k.forEach(i),Ll=n(e),At=a(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-12bf6z0"&&(At.innerHTML=ua),Pl=n(e),Bt=a(e,"OL",{start:!0});var Ua=vi(Bt);Wt=a(Ua,"LI",{});var vn=vi(Wt);ki=a(vn,"P",{"data-svelte-h":!0}),r(ki)!=="svelte-1sxg1ux"&&(ki.textContent=pa),Cn=n(vn),p(qt.$$.fragment,vn),vn.forEach(i),Ua.forEach(i),Zl=n(e),Vt=a(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-baqsq9"&&(Vt.innerHTML=fa),Gl=n(e),j=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-1ug4u82"&&(j.innerHTML=da),Rl=n(e),Xt=a(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-6e1eyz"&&(Xt.textContent=ha),Al=n(e),p(Nt.$$.fragment,e),Bl=n(e),Dt=a(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-zb2pxr"&&(Dt.textContent=ma),Wl=n(e),p(St.$$.fragment,e),ql=n(e),Ft=a(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1xnez06"&&(Ft.textContent=ca),Vl=n(e),p(Yt.$$.fragment,e),Xl=n(e),zt=a(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1ee1sp3"&&(zt.innerHTML=ga),Nl=n(e),p(Et.$$.fragment,e),Dl=n(e),Qt=a(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1fsb6ew"&&(Qt.innerHTML=ya),Sl=n(e),p(Ot.$$.fragment,e),Fl=n(e),Kt=a(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1h0d1ob"&&(Kt.innerHTML=wa),Yl=n(e),p(ei.$$.fragment,e),zl=n(e),ti=a(e,"P",{"data-svelte-h":!0}),r(ti)!=="svelte-b5s72j"&&(ti.textContent=ba),El=n(e),p(ii.$$.fragment,e),Ql=n(e),si=a(e,"P",{"data-svelte-h":!0}),r(si)!=="svelte-1adm7yl"&&(si.textContent=Ta),Ol=n(e),p(li.$$.fragment,e),Kl=n(e),L=a(e,"OL",{start:!0,"data-svelte-h":!0}),r(L)!=="svelte-vcjscl"&&(L.innerHTML=Ma),en=n(e),p(ni.$$.fragment,e),tn=n(e),oi=a(e,"P",{"data-svelte-h":!0}),r(oi)!=="svelte-109saxj"&&(oi.innerHTML=va),sn=n(e),ai=a(e,"P",{"data-svelte-h":!0}),r(ai)!=="svelte-1w3mw7o"&&(ai.innerHTML=$a),ln=n(e),p(ri.$$.fragment,e),nn=n(e),ui=a(e,"P",{"data-svelte-h":!0}),r(ui)!=="svelte-1df4miy"&&(ui.innerHTML=xa),on=n(e),pi=a(e,"P",{"data-svelte-h":!0}),r(pi)!=="svelte-12n8jzj"&&(pi.textContent=Ia),an=n(e),fi=a(e,"P",{"data-svelte-h":!0}),r(fi)!=="svelte-kna9l3"&&(fi.innerHTML=ka),rn=n(e),p(di.$$.fragment,e),un=n(e),hi=a(e,"P",{"data-svelte-h":!0}),r(hi)!=="svelte-6tihfz"&&(hi.innerHTML=Ca),pn=n(e),p(mi.$$.fragment,e),fn=n(e),p(ci.$$.fragment,e),dn=n(e),gi=a(e,"P",{"data-svelte-h":!0}),r(gi)!=="svelte-ciarbw"&&(gi.textContent=Ja),hn=n(e),yi=a(e,"OL",{"data-svelte-h":!0}),r(yi)!=="svelte-ff502d"&&(yi.innerHTML=Ha),mn=n(e),p(wi.$$.fragment,e),cn=n(e),p(bi.$$.fragment,e),gn=n(e),Ti=a(e,"P",{"data-svelte-h":!0}),r(Ti)!=="svelte-1w7izlk"&&(Ti.innerHTML=_a),yn=n(e),p(Mi.$$.fragment,e),wn=n(e),Ji=a(e,"P",{}),vi(Ji).forEach(i),this.h()},h(){P(c,"name","hf:doc:metadata"),P(c,"content",Da),P(J,"start","2"),P(H,"class","tip"),P(U,"start","10"),P(Bt,"start","4"),P(j,"start","5"),P(L,"start","6")},m(e,t){$(document.head,c),s(e,T,t),s(e,y,t),s(e,M,t),f(g,e,t),s(e,v,t),s(e,x,t),s(e,Hi,t),s(e,Z,t),s(e,_i,t),s(e,G,t),s(e,Ui,t),s(e,R,t),s(e,ji,t),f(A,e,t),s(e,Li,t),s(e,B,t),s(e,Pi,t),s(e,W,t),s(e,Zi,t),s(e,q,t),s(e,Gi,t),s(e,V,t),s(e,Ri,t),s(e,X,t),s(e,Ai,t),f(N,e,t),s(e,Bi,t),s(e,D,t),s(e,Wi,t),s(e,S,t),s(e,qi,t),s(e,F,t),s(e,Vi,t),s(e,Y,t),s(e,Xi,t),s(e,z,t),s(e,Ni,t),f(E,e,t),s(e,Di,t),s(e,Q,t),s(e,Si,t),s(e,O,t),s(e,Fi,t),s(e,K,t),s(e,Yi,t),s(e,ee,t),s(e,zi,t),s(e,te,t),s(e,Ei,t),s(e,ie,t),s(e,Qi,t),f(se,e,t),s(e,Oi,t),s(e,le,t),s(e,Ki,t),s(e,ne,t),s(e,es,t),s(e,oe,t),s(e,ts,t),s(e,ae,t),s(e,is,t),f(re,e,t),s(e,ss,t),s(e,ue,t),s(e,ls,t),s(e,pe,t),s(e,ns,t),s(e,fe,t),s(e,os,t),s(e,J,t),s(e,as,t),s(e,de,t),s(e,rs,t),f(he,e,t),s(e,us,t),s(e,me,t),s(e,ps,t),s(e,ce,t),s(e,fs,t),f(ge,e,t),s(e,ds,t),s(e,ye,t),s(e,hs,t),s(e,we,t),s(e,ms,t),f(be,e,t),s(e,cs,t),s(e,Te,t),s(e,gs,t),s(e,Me,t),s(e,ys,t),s(e,ve,t),s(e,ws,t),s(e,$e,t),s(e,bs,t),f(xe,e,t),s(e,Ts,t),s(e,Ie,t),s(e,Ms,t),s(e,ke,t),s(e,vs,t),s(e,Ce,t),s(e,$s,t),s(e,Je,t),s(e,xs,t),s(e,He,t),s(e,Is,t),f(_e,e,t),s(e,ks,t),s(e,Ue,t),s(e,Cs,t),s(e,je,t),s(e,Js,t),f(Le,e,t),s(e,Hs,t),s(e,Pe,t),s(e,_s,t),s(e,Ze,t),s(e,Us,t),s(e,Ge,t),s(e,js,t),s(e,Re,t),s(e,Ls,t),s(e,Ae,t),s(e,Ps,t),f(Be,e,t),s(e,Zs,t),s(e,H,t),s(e,Gs,t),s(e,We,t),s(e,Rs,t),s(e,qe,t),s(e,As,t),f(Ve,e,t),s(e,Bs,t),s(e,Xe,t),s(e,Ws,t),f(Ne,e,t),s(e,qs,t),s(e,De,t),s(e,Vs,t),f(Se,e,t),s(e,Xs,t),s(e,Fe,t),s(e,Ns,t),f(_,e,t),s(e,Ds,t),f(Ye,e,t),s(e,Ss,t),s(e,ze,t),s(e,Fs,t),s(e,Ee,t),s(e,Ys,t),s(e,Qe,t),s(e,zs,t),s(e,Oe,t),s(e,Es,t),s(e,Ke,t),s(e,Qs,t),f(et,e,t),s(e,Os,t),s(e,tt,t),s(e,Ks,t),f(it,e,t),s(e,el,t),s(e,st,t),s(e,tl,t),s(e,lt,t),s(e,il,t),s(e,nt,t),s(e,sl,t),s(e,ot,t),s(e,ll,t),s(e,at,t),s(e,nl,t),s(e,rt,t),s(e,ol,t),f(ut,e,t),s(e,al,t),s(e,pt,t),s(e,rl,t),f(ft,e,t),s(e,ul,t),s(e,dt,t),s(e,pl,t),s(e,ht,t),s(e,fl,t),s(e,mt,t),s(e,dl,t),s(e,ct,t),s(e,hl,t),s(e,gt,t),s(e,ml,t),s(e,yt,t),s(e,cl,t),s(e,wt,t),s(e,gl,t),f(bt,e,t),s(e,yl,t),s(e,Tt,t),s(e,wl,t),s(e,Mt,t),s(e,bl,t),f(vt,e,t),s(e,Tl,t),s(e,$t,t),s(e,Ml,t),f(xt,e,t),s(e,vl,t),s(e,It,t),s(e,$l,t),s(e,kt,t),s(e,xl,t),f(Ct,e,t),s(e,Il,t),s(e,Jt,t),s(e,kl,t),s(e,Ht,t),s(e,Cl,t),s(e,U,t),s(e,Jl,t),f(_t,e,t),s(e,Hl,t),s(e,Ut,t),s(e,_l,t),s(e,jt,t),s(e,Ul,t),s(e,Lt,t),s(e,jl,t),s(e,I,t),$(I,$i),$(I,$n),$(I,Pt),$(Pt,xi),$(Pt,xn),f(Zt,Pt,null),$(I,In),$(I,Gt),$(Gt,Ii),$(Gt,kn),f(Rt,Gt,null),s(e,Ll,t),s(e,At,t),s(e,Pl,t),s(e,Bt,t),$(Bt,Wt),$(Wt,ki),$(Wt,Cn),f(qt,Wt,null),s(e,Zl,t),s(e,Vt,t),s(e,Gl,t),s(e,j,t),s(e,Rl,t),s(e,Xt,t),s(e,Al,t),f(Nt,e,t),s(e,Bl,t),s(e,Dt,t),s(e,Wl,t),f(St,e,t),s(e,ql,t),s(e,Ft,t),s(e,Vl,t),f(Yt,e,t),s(e,Xl,t),s(e,zt,t),s(e,Nl,t),f(Et,e,t),s(e,Dl,t),s(e,Qt,t),s(e,Sl,t),f(Ot,e,t),s(e,Fl,t),s(e,Kt,t),s(e,Yl,t),f(ei,e,t),s(e,zl,t),s(e,ti,t),s(e,El,t),f(ii,e,t),s(e,Ql,t),s(e,si,t),s(e,Ol,t),f(li,e,t),s(e,Kl,t),s(e,L,t),s(e,en,t),f(ni,e,t),s(e,tn,t),s(e,oi,t),s(e,sn,t),s(e,ai,t),s(e,ln,t),f(ri,e,t),s(e,nn,t),s(e,ui,t),s(e,on,t),s(e,pi,t),s(e,an,t),s(e,fi,t),s(e,rn,t),f(di,e,t),s(e,un,t),s(e,hi,t),s(e,pn,t),f(mi,e,t),s(e,fn,t),f(ci,e,t),s(e,dn,t),s(e,gi,t),s(e,hn,t),s(e,yi,t),s(e,mn,t),f(wi,e,t),s(e,cn,t),f(bi,e,t),s(e,gn,t),s(e,Ti,t),s(e,yn,t),f(Mi,e,t),s(e,wn,t),s(e,Ji,t),bn=!0},p(e,[t]){const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),_.$set(k)},i(e){bn||(d(g.$$.fragment,e),d(A.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(he.$$.fragment,e),d(ge.$$.fragment,e),d(be.$$.fragment,e),d(xe.$$.fragment,e),d(_e.$$.fragment,e),d(Le.$$.fragment,e),d(Be.$$.fragment,e),d(Ve.$$.fragment,e),d(Ne.$$.fragment,e),d(Se.$$.fragment,e),d(_.$$.fragment,e),d(Ye.$$.fragment,e),d(et.$$.fragment,e),d(it.$$.fragment,e),d(ut.$$.fragment,e),d(ft.$$.fragment,e),d(bt.$$.fragment,e),d(vt.$$.fragment,e),d(xt.$$.fragment,e),d(Ct.$$.fragment,e),d(_t.$$.fragment,e),d(Zt.$$.fragment,e),d(Rt.$$.fragment,e),d(qt.$$.fragment,e),d(Nt.$$.fragment,e),d(St.$$.fragment,e),d(Yt.$$.fragment,e),d(Et.$$.fragment,e),d(Ot.$$.fragment,e),d(ei.$$.fragment,e),d(ii.$$.fragment,e),d(li.$$.fragment,e),d(ni.$$.fragment,e),d(ri.$$.fragment,e),d(di.$$.fragment,e),d(mi.$$.fragment,e),d(ci.$$.fragment,e),d(wi.$$.fragment,e),d(bi.$$.fragment,e),d(Mi.$$.fragment,e),bn=!0)},o(e){h(g.$$.fragment,e),h(A.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(xe.$$.fragment,e),h(_e.$$.fragment,e),h(Le.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),h(Se.$$.fragment,e),h(_.$$.fragment,e),h(Ye.$$.fragment,e),h(et.$$.fragment,e),h(it.$$.fragment,e),h(ut.$$.fragment,e),h(ft.$$.fragment,e),h(bt.$$.fragment,e),h(vt.$$.fragment,e),h(xt.$$.fragment,e),h(Ct.$$.fragment,e),h(_t.$$.fragment,e),h(Zt.$$.fragment,e),h(Rt.$$.fragment,e),h(qt.$$.fragment,e),h(Nt.$$.fragment,e),h(St.$$.fragment,e),h(Yt.$$.fragment,e),h(Et.$$.fragment,e),h(Ot.$$.fragment,e),h(ei.$$.fragment,e),h(ii.$$.fragment,e),h(li.$$.fragment,e),h(ni.$$.fragment,e),h(ri.$$.fragment,e),h(di.$$.fragment,e),h(mi.$$.fragment,e),h(ci.$$.fragment,e),h(wi.$$.fragment,e),h(bi.$$.fragment,e),h(Mi.$$.fragment,e),bn=!1},d(e){e&&(i(T),i(y),i(M),i(v),i(x),i(Hi),i(Z),i(_i),i(G),i(Ui),i(R),i(ji),i(Li),i(B),i(Pi),i(W),i(Zi),i(q),i(Gi),i(V),i(Ri),i(X),i(Ai),i(Bi),i(D),i(Wi),i(S),i(qi),i(F),i(Vi),i(Y),i(Xi),i(z),i(Ni),i(Di),i(Q),i(Si),i(O),i(Fi),i(K),i(Yi),i(ee),i(zi),i(te),i(Ei),i(ie),i(Qi),i(Oi),i(le),i(Ki),i(ne),i(es),i(oe),i(ts),i(ae),i(is),i(ss),i(ue),i(ls),i(pe),i(ns),i(fe),i(os),i(J),i(as),i(de),i(rs),i(us),i(me),i(ps),i(ce),i(fs),i(ds),i(ye),i(hs),i(we),i(ms),i(cs),i(Te),i(gs),i(Me),i(ys),i(ve),i(ws),i($e),i(bs),i(Ts),i(Ie),i(Ms),i(ke),i(vs),i(Ce),i($s),i(Je),i(xs),i(He),i(Is),i(ks),i(Ue),i(Cs),i(je),i(Js),i(Hs),i(Pe),i(_s),i(Ze),i(Us),i(Ge),i(js),i(Re),i(Ls),i(Ae),i(Ps),i(Zs),i(H),i(Gs),i(We),i(Rs),i(qe),i(As),i(Bs),i(Xe),i(Ws),i(qs),i(De),i(Vs),i(Xs),i(Fe),i(Ns),i(Ds),i(Ss),i(ze),i(Fs),i(Ee),i(Ys),i(Qe),i(zs),i(Oe),i(Es),i(Ke),i(Qs),i(Os),i(tt),i(Ks),i(el),i(st),i(tl),i(lt),i(il),i(nt),i(sl),i(ot),i(ll),i(at),i(nl),i(rt),i(ol),i(al),i(pt),i(rl),i(ul),i(dt),i(pl),i(ht),i(fl),i(mt),i(dl),i(ct),i(hl),i(gt),i(ml),i(yt),i(cl),i(wt),i(gl),i(yl),i(Tt),i(wl),i(Mt),i(bl),i(Tl),i($t),i(Ml),i(vl),i(It),i($l),i(kt),i(xl),i(Il),i(Jt),i(kl),i(Ht),i(Cl),i(U),i(Jl),i(Hl),i(Ut),i(_l),i(jt),i(Ul),i(Lt),i(jl),i(I),i(Ll),i(At),i(Pl),i(Bt),i(Zl),i(Vt),i(Gl),i(j),i(Rl),i(Xt),i(Al),i(Bl),i(Dt),i(Wl),i(ql),i(Ft),i(Vl),i(Xl),i(zt),i(Nl),i(Dl),i(Qt),i(Sl),i(Fl),i(Kt),i(Yl),i(zl),i(ti),i(El),i(Ql),i(si),i(Ol),i(Kl),i(L),i(en),i(tn),i(oi),i(sn),i(ai),i(ln),i(nn),i(ui),i(on),i(pi),i(an),i(fi),i(rn),i(un),i(hi),i(pn),i(fn),i(dn),i(gi),i(hn),i(yi),i(mn),i(cn),i(gn),i(Ti),i(yn),i(wn),i(Ji)),i(c),m(g,e),m(A,e),m(N,e),m(E,e),m(se,e),m(re,e),m(he,e),m(ge,e),m(be,e),m(xe,e),m(_e,e),m(Le,e),m(Be,e),m(Ve,e),m(Ne,e),m(Se,e),m(_,e),m(Ye,e),m(et,e),m(it,e),m(ut,e),m(ft,e),m(bt,e),m(vt,e),m(xt,e),m(Ct,e),m(_t,e),m(Zt),m(Rt),m(qt),m(Nt,e),m(St,e),m(Yt,e),m(Et,e),m(Ot,e),m(ei,e),m(ii,e),m(li,e),m(ni,e),m(ri,e),m(di,e),m(mi,e),m(ci,e),m(wi,e),m(bi,e),m(Mi,e)}}}const Da='{"title":"How to contribute to Diffusers 🧨","local":"how-to-contribute-to-diffusers-","sections":[{"title":"Overview","local":"overview","sections":[{"title":"1. Asking and answering questions on the Diffusers discussion forum or on the Diffusers Discord","local":"1-asking-and-answering-questions-on-the-diffusers-discussion-forum-or-on-the-diffusers-discord","sections":[],"depth":3},{"title":"2. Opening new issues on the GitHub issues tab","local":"2-opening-new-issues-on-the-github-issues-tab","sections":[{"title":"2.1. Reproducible, minimal bug reports","local":"21-reproducible-minimal-bug-reports","sections":[],"depth":4},{"title":"2.2. Feature requests","local":"22-feature-requests","sections":[],"depth":4},{"title":"2.3 Feedback","local":"23-feedback","sections":[],"depth":4},{"title":"2.4 Technical questions","local":"24-technical-questions","sections":[],"depth":4},{"title":"2.5 Proposal to add a new model, scheduler, or pipeline","local":"25-proposal-to-add-a-new-model-scheduler-or-pipeline","sections":[],"depth":4}],"depth":3},{"title":"3. Answering issues on the GitHub issues tab","local":"3-answering-issues-on-the-github-issues-tab","sections":[],"depth":3},{"title":"4. Fixing a “Good first issue”","local":"4-fixing-a-good-first-issue","sections":[],"depth":3},{"title":"5. Contribute to the documentation","local":"5-contribute-to-the-documentation","sections":[],"depth":3},{"title":"6. Contribute a community pipeline","local":"6-contribute-a-community-pipeline","sections":[],"depth":3},{"title":"7. Contribute to training examples","local":"7-contribute-to-training-examples","sections":[],"depth":3},{"title":"8. Fixing a “Good second issue”","local":"8-fixing-a-good-second-issue","sections":[],"depth":3},{"title":"9. Adding pipelines, models, schedulers","local":"9-adding-pipelines-models-schedulers","sections":[{"title":"Copied from mechanism","local":"copied-from-mechanism","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"How to write a good issue","local":"how-to-write-a-good-issue","sections":[],"depth":2},{"title":"How to write a good PR","local":"how-to-write-a-good-pr","sections":[],"depth":2},{"title":"How to open a PR","local":"how-to-open-a-pr","sections":[{"title":"Tests","local":"tests","sections":[],"depth":3},{"title":"Syncing forked main with upstream (HuggingFace) main","local":"syncing-forked-main-with-upstream-huggingface-main","sections":[],"depth":3},{"title":"Style guide","local":"style-guide","sections":[],"depth":3}],"depth":2}],"depth":1}';function Sa(C){return Za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oa extends Ga{constructor(c){super(),Ra(this,c,Sa,Na,Pa,{})}}export{Oa as component};
