import{s as xt,o as Lt,n as Ct}from"../chunks/scheduler.888833de.js";import{S as St,i as Dt,e as m,s as a,c as M,h as Pt,a as f,d as l,b as i,f as Ht,g as c,j as u,k as te,l as Kt,m as s,n as y,t as b,o as J,p as h}from"../chunks/index.128ce987.js";import{C as V}from"../chunks/CodeBlock.37df032e.js";import{H as O,E as Ot}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";import{H as Yt,a as jt}from"../chunks/HfOption.79a0a3f5.js";function el(I){let o,w="Quantizing a model in 8-bit halves the memory-usage:",d,T,r=`bitsandbytes is supported in both Transformers and Diffusers, so you can quantize both the
<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,U,Z,q="For Ada and higher-series GPUs. we recommend changing <code>torch_dtype</code> to <code>torch.bfloat16</code>.",Q,j,le='<p>The <code>CLIPTextModel</code> and <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> aren’t quantized because they’re already small in size and because <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> only has a few <code>torch.nn.Linear</code> layers.</p>',W,C,L,B,N="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",S,_,z,X,ee="Let’s generate an image using our quantized models.",E,v,H=`Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the
CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.`,D,R,k,g,F='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/8bit.png"/>',P,G,Y='When there is enough memory, you can also directly move the pipeline to the GPU with <code>.to(&quot;cuda&quot;)</code> and apply <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to optimize GPU memory usage.',K,$,x='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 8-bit models locally with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',A;return C=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUlMkMpJTBBJTBBdGV4dF9lbmNvZGVyXzJfOGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUlMkMpJTBBJTBBdHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

text_encoder_2_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>,)

transformer_8bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),_=new V({props:{code:"dHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTJCJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKQ==",highlighted:`transformer_8bit = AutoModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),R=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXJfOGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNEdGV4dF9lbmNvZGVyXzJfOGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKSUwQSUwQXBpcGVfa3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmhlaWdodCUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJ3aWR0aCUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJndWlkYW5jZV9zY2FsZSUyMiUzQSUyMDMuNSUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV9pbmZlcmVuY2Vfc3RlcHMlMjIlM0ElMjA1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF9zZXF1ZW5jZV9sZW5ndGglMjIlM0ElMjA1MTIlMkMlMEElN0QlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoKipwaXBlX2t3YXJncyUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApJTJDKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_8bit,
    text_encoder_2=text_encoder_2_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=m("p"),o.textContent=w,d=a(),T=m("p"),T.innerHTML=r,U=a(),Z=m("p"),Z.innerHTML=q,Q=a(),j=m("blockquote"),j.innerHTML=le,W=a(),M(C.$$.fragment),L=a(),B=m("p"),B.innerHTML=N,S=a(),M(_.$$.fragment),z=a(),X=m("p"),X.textContent=ee,E=a(),v=m("p"),v.innerHTML=H,D=a(),M(R.$$.fragment),k=a(),g=m("div"),g.innerHTML=F,P=a(),G=m("p"),G.innerHTML=Y,K=a(),$=m("p"),$.innerHTML=x,this.h()},l(t){o=f(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-4djpqq"&&(o.textContent=w),d=i(t),T=f(t,"P",{"data-svelte-h":!0}),u(T)!=="svelte-8t0085"&&(T.innerHTML=r),U=i(t),Z=f(t,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-mdqrzc"&&(Z.innerHTML=q),Q=i(t),j=f(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(j)!=="svelte-1iq05of"&&(j.innerHTML=le),W=i(t),c(C.$$.fragment,t),L=i(t),B=f(t,"P",{"data-svelte-h":!0}),u(B)!=="svelte-1qozsrk"&&(B.innerHTML=N),S=i(t),c(_.$$.fragment,t),z=i(t),X=f(t,"P",{"data-svelte-h":!0}),u(X)!=="svelte-2bde4h"&&(X.textContent=ee),E=i(t),v=f(t,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1eyrcy7"&&(v.innerHTML=H),D=i(t),c(R.$$.fragment,t),k=i(t),g=f(t,"DIV",{class:!0,"data-svelte-h":!0}),u(g)!=="svelte-14afenp"&&(g.innerHTML=F),P=i(t),G=f(t,"P",{"data-svelte-h":!0}),u(G)!=="svelte-uz8m1k"&&(G.innerHTML=Y),K=i(t),$=f(t,"P",{"data-svelte-h":!0}),u($)!=="svelte-13z5cfr"&&($.innerHTML=x),this.h()},h(){te(j,"class","tip"),te(g,"class","flex justify-center")},m(t,p){s(t,o,p),s(t,d,p),s(t,T,p),s(t,U,p),s(t,Z,p),s(t,Q,p),s(t,j,p),s(t,W,p),y(C,t,p),s(t,L,p),s(t,B,p),s(t,S,p),y(_,t,p),s(t,z,p),s(t,X,p),s(t,E,p),s(t,v,p),s(t,D,p),y(R,t,p),s(t,k,p),s(t,g,p),s(t,P,p),s(t,G,p),s(t,K,p),s(t,$,p),A=!0},p:Ct,i(t){A||(b(C.$$.fragment,t),b(_.$$.fragment,t),b(R.$$.fragment,t),A=!0)},o(t){J(C.$$.fragment,t),J(_.$$.fragment,t),J(R.$$.fragment,t),A=!1},d(t){t&&(l(o),l(d),l(T),l(U),l(Z),l(Q),l(j),l(W),l(L),l(B),l(S),l(z),l(X),l(E),l(v),l(D),l(k),l(g),l(P),l(G),l(K),l($)),h(C,t),h(_,t),h(R,t)}}}function tl(I){let o,w="Quantizing a model in 4-bit reduces your memory-usage by 4x:",d,T,r=`bitsandbytes is supported in both Transformers and Diffusers, so you can can quantize both the
<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,U,Z,q="For Ada and higher-series GPUs. we recommend changing <code>torch_dtype</code> to <code>torch.bfloat16</code>.",Q,j,le='<p>The <code>CLIPTextModel</code> and <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> aren’t quantized because they’re already small in size and because <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a> only has a few <code>torch.nn.Linear</code> layers.</p>',W,C,L,B,N="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",S,_,z,X,ee="Let’s generate an image using our quantized models.",E,v,H="Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.",D,R,k,g,F='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/4bit.png"/>',P,G,Y='When there is enough memory, you can also directly move the pipeline to the GPU with <code>.to(&quot;cuda&quot;)</code> and apply <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> to optimize GPU memory usage.',K,$,x='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 4-bit models locally with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',A;return C=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>,)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),_=new V({props:{code:"dHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTJCJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTBBKQ==",highlighted:`transformer_4bit = AutoModel.from_pretrained(
    &quot;black-forest-labs/FLUX.1-dev&quot;,
    subfolder=&quot;transformer&quot;,
    quantization_config=quant_config,
<span class="hljs-addition">+   torch_dtype=torch.float32,</span>
)`,wrap:!1}}),R=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXJfNGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNEdGV4dF9lbmNvZGVyXzJfNGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKSUwQSUwQXBpcGVfa3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmhlaWdodCUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJ3aWR0aCUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjJndWlkYW5jZV9zY2FsZSUyMiUzQSUyMDMuNSUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV9pbmZlcmVuY2Vfc3RlcHMlMjIlM0ElMjA1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF9zZXF1ZW5jZV9sZW5ndGglMjIlM0ElMjA1MTIlMkMlMEElN0QlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoKipwaXBlX2t3YXJncyUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApJTJDKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_4bit,
    text_encoder_2=text_encoder_2_4bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(**pipe_kwargs, generator=torch.manual_seed(<span class="hljs-number">0</span>),).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=m("p"),o.textContent=w,d=a(),T=m("p"),T.innerHTML=r,U=a(),Z=m("p"),Z.innerHTML=q,Q=a(),j=m("blockquote"),j.innerHTML=le,W=a(),M(C.$$.fragment),L=a(),B=m("p"),B.innerHTML=N,S=a(),M(_.$$.fragment),z=a(),X=m("p"),X.textContent=ee,E=a(),v=m("p"),v.innerHTML=H,D=a(),M(R.$$.fragment),k=a(),g=m("div"),g.innerHTML=F,P=a(),G=m("p"),G.innerHTML=Y,K=a(),$=m("p"),$.innerHTML=x,this.h()},l(t){o=f(t,"P",{"data-svelte-h":!0}),u(o)!=="svelte-i07c71"&&(o.textContent=w),d=i(t),T=f(t,"P",{"data-svelte-h":!0}),u(T)!=="svelte-q3mf8r"&&(T.innerHTML=r),U=i(t),Z=f(t,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-mdqrzc"&&(Z.innerHTML=q),Q=i(t),j=f(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(j)!=="svelte-1iq05of"&&(j.innerHTML=le),W=i(t),c(C.$$.fragment,t),L=i(t),B=f(t,"P",{"data-svelte-h":!0}),u(B)!=="svelte-1qozsrk"&&(B.innerHTML=N),S=i(t),c(_.$$.fragment,t),z=i(t),X=f(t,"P",{"data-svelte-h":!0}),u(X)!=="svelte-2bde4h"&&(X.textContent=ee),E=i(t),v=f(t,"P",{"data-svelte-h":!0}),u(v)!=="svelte-6ilppp"&&(v.innerHTML=H),D=i(t),c(R.$$.fragment,t),k=i(t),g=f(t,"DIV",{class:!0,"data-svelte-h":!0}),u(g)!=="svelte-qev6y1"&&(g.innerHTML=F),P=i(t),G=f(t,"P",{"data-svelte-h":!0}),u(G)!=="svelte-uz8m1k"&&(G.innerHTML=Y),K=i(t),$=f(t,"P",{"data-svelte-h":!0}),u($)!=="svelte-1wxqg1v"&&($.innerHTML=x),this.h()},h(){te(j,"class","tip"),te(g,"class","flex justify-center")},m(t,p){s(t,o,p),s(t,d,p),s(t,T,p),s(t,U,p),s(t,Z,p),s(t,Q,p),s(t,j,p),s(t,W,p),y(C,t,p),s(t,L,p),s(t,B,p),s(t,S,p),y(_,t,p),s(t,z,p),s(t,X,p),s(t,E,p),s(t,v,p),s(t,D,p),y(R,t,p),s(t,k,p),s(t,g,p),s(t,P,p),s(t,G,p),s(t,K,p),s(t,$,p),A=!0},p:Ct,i(t){A||(b(C.$$.fragment,t),b(_.$$.fragment,t),b(R.$$.fragment,t),A=!0)},o(t){J(C.$$.fragment,t),J(_.$$.fragment,t),J(R.$$.fragment,t),A=!1},d(t){t&&(l(o),l(d),l(T),l(U),l(Z),l(Q),l(j),l(W),l(L),l(B),l(S),l(z),l(X),l(E),l(v),l(D),l(k),l(g),l(P),l(G),l(K),l($)),h(C,t),h(_,t),h(R,t)}}}function ll(I){let o,w,d,T;return o=new jt({props:{id:"bnb",option:"8-bit",$$slots:{default:[el]},$$scope:{ctx:I}}}),d=new jt({props:{id:"bnb",option:"4-bit",$$slots:{default:[tl]},$$scope:{ctx:I}}}),{c(){M(o.$$.fragment),w=a(),M(d.$$.fragment)},l(r){c(o.$$.fragment,r),w=i(r),c(d.$$.fragment,r)},m(r,U){y(o,r,U),s(r,w,U),y(d,r,U),T=!0},p(r,U){const Z={};U&2&&(Z.$$scope={dirty:U,ctx:r}),o.$set(Z);const q={};U&2&&(q.$$scope={dirty:U,ctx:r}),d.$set(q)},i(r){T||(b(o.$$.fragment,r),b(d.$$.fragment,r),T=!0)},o(r){J(o.$$.fragment,r),J(d.$$.fragment,r),T=!1},d(r){r&&l(w),h(o,r),h(d,r)}}}function sl(I){let o,w;return o=new V({props:{code:"dG9yY2guX2R5bmFtby5jb25maWcuY2FwdHVyZV9keW5hbWljX291dHB1dF9zaGFwZV9vcHMlMjAlM0QlMjBUcnVlJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXRyYW5zZm9ybWVyXzRiaXQuY29tcGlsZShmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:`torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)
transformer_4bit.<span class="hljs-built_in">compile</span>(fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){M(o.$$.fragment)},l(d){c(o.$$.fragment,d)},m(d,T){y(o,d,T),w=!0},p:Ct,i(d){w||(b(o.$$.fragment,d),w=!0)},o(d){J(o.$$.fragment,d),w=!1},d(d){h(o,d)}}}function nl(I){let o,w;return o=new V({props:{code:"cXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXRyYW5zZm9ybWVyXzRiaXQuY29tcGlsZShmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:`quant_config = DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)
transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)
transformer_4bit.<span class="hljs-built_in">compile</span>(fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){M(o.$$.fragment)},l(d){c(o.$$.fragment,d)},m(d,T){y(o,d,T),w=!0},p:Ct,i(d){w||(b(o.$$.fragment,d),w=!0)},o(d){J(o.$$.fragment,d),w=!1},d(d){h(o,d)}}}function al(I){let o,w,d,T;return o=new jt({props:{id:"bnb",option:"8-bit",$$slots:{default:[sl]},$$scope:{ctx:I}}}),d=new jt({props:{id:"bnb",option:"4-bit",$$slots:{default:[nl]},$$scope:{ctx:I}}}),{c(){M(o.$$.fragment),w=a(),M(d.$$.fragment)},l(r){c(o.$$.fragment,r),w=i(r),c(d.$$.fragment,r)},m(r,U){y(o,r,U),s(r,w,U),y(d,r,U),T=!0},p(r,U){const Z={};U&2&&(Z.$$scope={dirty:U,ctx:r}),o.$set(Z);const q={};U&2&&(q.$$scope={dirty:U,ctx:r}),d.$set(q)},i(r){T||(b(o.$$.fragment,r),b(d.$$.fragment,r),T=!0)},o(r){J(o.$$.fragment,r),J(d.$$.fragment,r),T=!1},d(r){r&&l(w),h(o,r),h(d,r)}}}function il(I){let o,w,d,T,r,U,Z,q='<a href="https://huggingface.co/docs/bitsandbytes/index" rel="nofollow">bitsandbytes</a> is the easiest option for quantizing a model to 8 and 4-bit. 8-bit quantization multiplies outliers in fp16 with non-outliers in int8, converts the non-outlier values back to fp16, and then adds them together to return the weights in fp16. This reduces the degradative effect outlier values have on a model’s performance.',Q,j,le='4-bit quantization compresses a model even further, and it is commonly used with <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> to finetune quantized LLMs.',W,C,L=`This guide demonstrates how quantization can enable running
<a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a>
on less than 16GB of VRAM and even on a free Google
Colab instance.`,B,N,S='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/comparison.png" alt="comparison image"/>',_,z,X="To use bitsandbytes, make sure you have the following libraries installed:",ee,E,v,H,D='Now you can quantize a model by passing a <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a> to <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>. This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',R,k,g,F,P="<p>Training with 8-bit and 4-bit weights are only supported for training <em>extra</em> parameters.</p>",G,Y,K="Check your memory footprint with the <code>get_memory_footprint</code> method:",$,x,A,t,p="Note that this only tells you the memory footprint of the model params and does <em>not</em> estimate the inference memory requirements.",Qe,ie,gt='Quantized models can be loaded from the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method without needing to specify the <code>quantization_config</code> parameters:',We,oe,Fe,re,Ae,se,Bt='<p>Learn more about the details of 8-bit quantization in this <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a>!</p>',Ne,pe,_t="This section explores some of the specific features of 8-bit models, such as outlier thresholds and skipping module conversion.",He,de,Ye,me,vt="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",xe,fe,Rt='To find the best threshold for your model, we recommend experimenting with the <code>llm_int8_threshold</code> parameter in <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Le,ue,Se,Me,De,ce,Gt='For some models, you don’t need to quantize every module to 8-bit which can actually cause instability. For example, for diffusion models like <a href="../api/pipelines/stable_diffusion/stable_diffusion_3">Stable Diffusion 3</a>, the <code>proj_out</code> module can be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Pe,ye,Ke,be,Oe,ne,$t='<p>Learn more about its details in this <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">blog post</a>.</p>',et,Je,Xt="This section explores some of the specific features of 4-bit models, such as changing the compute data type, using the Normal Float 4 (NF4) data type, and using nested quantization.",tt,he,lt,Te,kt='To speedup computation, you can change the data type from float32 (the default value) to bf16 using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',st,Ue,nt,we,at,Ze,zt='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models. This can be configured with the <code>bnb_4bit_quant_type</code> parameter in the <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',it,je,ot,Ce,Et="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",rt,ge,pt,Be,Vt="Nested quantization is a technique that can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an additional 0.4 bits/parameter.",dt,_e,mt,ve,ft,Re,It="Once quantized, you can dequantize a model to its original precision, but this might result in a small loss of quality. Make sure you have enough GPU RAM to fit the dequantized model.",ut,Ge,Mt,$e,ct,Xe,qt='Speed up inference with <code>torch.compile</code>. Make sure you have the latest <code>bitsandbytes</code> installed and we also recommend installing <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch nightly</a>.',yt,ae,bt,ke,Qt="On an RTX 4090 with compilation, 4-bit Flux generation completed in 25.809 seconds versus 32.570 seconds without.",Jt,ze,Wt='Check out the <a href="https://gist.github.com/sayakpaul/0db9d8eeeb3d2a0e5ed7cf0d9ca19b7d" rel="nofollow">benchmarking script</a> for more details.',ht,Ee,Tt,Ve,Ft='<li><a href="https://gist.github.com/sayakpaul/c76bd845b48759e11687ac550b99d8b4" rel="nofollow">End-to-end notebook showing Flux.1 Dev inference in a free-tier Colab</a></li> <li><a href="https://github.com/huggingface/diffusers/blob/8c661ea586bf11cb2440da740dd3c4cf84679b85/examples/dreambooth/README_hidream.md#using-quantization" rel="nofollow">Training</a></li>',Ut,Ie,wt,qe,Zt;return r=new O({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),E=new V({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMjAtVQ==",highlighted:"pip install diffusers transformers accelerate bitsandbytes -U",wrap:!1}}),k=new Yt({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[ll]},$$scope:{ctx:I}}}),x=new V({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),oe=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSklMEElMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZmx1eC4xLWRldi1uZjQtcGtnJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;hf-internal-testing/flux.1-dev-nf4-pkg&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>
)`,wrap:!1}}),re=new O({props:{title:"8-bit (LLM.int8() algorithm)",local:"8-bit-llmint8-algorithm",headingTag:"h2"}}),de=new O({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h3"}}),ue=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3RocmVzaG9sZCUzRDEwJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),Me=new O({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h3"}}),ye=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3NraXBfbW9kdWxlcyUzRCU1QiUyMnByb2pfb3V0JTIyJTVEJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_skip_modules=[<span class="hljs-string">&quot;proj_out&quot;</span>],
)

model_8bit = SD3Transformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),be=new O({props:{title:"4-bit (QLoRA algorithm)",local:"4-bit-qlora-algorithm",headingTag:"h2"}}),he=new O({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h3"}}),Ue=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),we=new O({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h3"}}),je=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),ge=new O({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h3"}}),_e=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),ve=new O({props:{title:"Dequantizing bitsandbytes models",local:"dequantizing-bitsandbytes-models",headingTag:"h2"}}),Ge=new V({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdC5kZXF1YW50aXplKCklMEF0cmFuc2Zvcm1lcl80Yml0LmRlcXVhbnRpemUoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

text_encoder_2_4bit.dequantize()
transformer_4bit.dequantize()`,wrap:!1}}),$e=new O({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),ae=new Yt({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[al]},$$scope:{ctx:I}}}),Ee=new O({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ie=new Ot({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/bitsandbytes.md"}}),{c(){o=m("meta"),w=a(),d=m("p"),T=a(),M(r.$$.fragment),U=a(),Z=m("p"),Z.innerHTML=q,Q=a(),j=m("p"),j.innerHTML=le,W=a(),C=m("p"),C.innerHTML=L,B=a(),N=m("p"),N.innerHTML=S,_=a(),z=m("p"),z.textContent=X,ee=a(),M(E.$$.fragment),v=a(),H=m("p"),H.innerHTML=D,R=a(),M(k.$$.fragment),g=a(),F=m("blockquote"),F.innerHTML=P,G=a(),Y=m("p"),Y.innerHTML=K,$=a(),M(x.$$.fragment),A=a(),t=m("p"),t.innerHTML=p,Qe=a(),ie=m("p"),ie.innerHTML=gt,We=a(),M(oe.$$.fragment),Fe=a(),M(re.$$.fragment),Ae=a(),se=m("blockquote"),se.innerHTML=Bt,Ne=a(),pe=m("p"),pe.textContent=_t,He=a(),M(de.$$.fragment),Ye=a(),me=m("p"),me.textContent=vt,xe=a(),fe=m("p"),fe.innerHTML=Rt,Le=a(),M(ue.$$.fragment),Se=a(),M(Me.$$.fragment),De=a(),ce=m("p"),ce.innerHTML=Gt,Pe=a(),M(ye.$$.fragment),Ke=a(),M(be.$$.fragment),Oe=a(),ne=m("blockquote"),ne.innerHTML=$t,et=a(),Je=m("p"),Je.textContent=Xt,tt=a(),M(he.$$.fragment),lt=a(),Te=m("p"),Te.innerHTML=kt,st=a(),M(Ue.$$.fragment),nt=a(),M(we.$$.fragment),at=a(),Ze=m("p"),Ze.innerHTML=zt,it=a(),M(je.$$.fragment),ot=a(),Ce=m("p"),Ce.innerHTML=Et,rt=a(),M(ge.$$.fragment),pt=a(),Be=m("p"),Be.textContent=Vt,dt=a(),M(_e.$$.fragment),mt=a(),M(ve.$$.fragment),ft=a(),Re=m("p"),Re.textContent=It,ut=a(),M(Ge.$$.fragment),Mt=a(),M($e.$$.fragment),ct=a(),Xe=m("p"),Xe.innerHTML=qt,yt=a(),M(ae.$$.fragment),bt=a(),ke=m("p"),ke.textContent=Qt,Jt=a(),ze=m("p"),ze.innerHTML=Wt,ht=a(),M(Ee.$$.fragment),Tt=a(),Ve=m("ul"),Ve.innerHTML=Ft,Ut=a(),M(Ie.$$.fragment),wt=a(),qe=m("p"),this.h()},l(e){const n=Pt("svelte-u9bgzb",document.head);o=f(n,"META",{name:!0,content:!0}),n.forEach(l),w=i(e),d=f(e,"P",{}),Ht(d).forEach(l),T=i(e),c(r.$$.fragment,e),U=i(e),Z=f(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1m50ob7"&&(Z.innerHTML=q),Q=i(e),j=f(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-11pyf03"&&(j.innerHTML=le),W=i(e),C=f(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1erhi5i"&&(C.innerHTML=L),B=i(e),N=f(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-ryfe7d"&&(N.innerHTML=S),_=i(e),z=f(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-gf36q7"&&(z.textContent=X),ee=i(e),c(E.$$.fragment,e),v=i(e),H=f(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-17fqaf"&&(H.innerHTML=D),R=i(e),c(k.$$.fragment,e),g=i(e),F=f(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(F)!=="svelte-jq136m"&&(F.innerHTML=P),G=i(e),Y=f(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-139tok6"&&(Y.innerHTML=K),$=i(e),c(x.$$.fragment,e),A=i(e),t=f(e,"P",{"data-svelte-h":!0}),u(t)!=="svelte-18sn6ad"&&(t.innerHTML=p),Qe=i(e),ie=f(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-10wvd51"&&(ie.innerHTML=gt),We=i(e),c(oe.$$.fragment,e),Fe=i(e),c(re.$$.fragment,e),Ae=i(e),se=f(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(se)!=="svelte-b7nvcq"&&(se.innerHTML=Bt),Ne=i(e),pe=f(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1myadau"&&(pe.textContent=_t),He=i(e),c(de.$$.fragment,e),Ye=i(e),me=f(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-ur5rgd"&&(me.textContent=vt),xe=i(e),fe=f(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1pta66b"&&(fe.innerHTML=Rt),Le=i(e),c(ue.$$.fragment,e),Se=i(e),c(Me.$$.fragment,e),De=i(e),ce=f(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-1rff4ou"&&(ce.innerHTML=Gt),Pe=i(e),c(ye.$$.fragment,e),Ke=i(e),c(be.$$.fragment,e),Oe=i(e),ne=f(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(ne)!=="svelte-1ighp1z"&&(ne.innerHTML=$t),et=i(e),Je=f(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-7ob7j"&&(Je.textContent=Xt),tt=i(e),c(he.$$.fragment,e),lt=i(e),Te=f(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-19knmj2"&&(Te.innerHTML=kt),st=i(e),c(Ue.$$.fragment,e),nt=i(e),c(we.$$.fragment,e),at=i(e),Ze=f(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-6pxdrm"&&(Ze.innerHTML=zt),it=i(e),c(je.$$.fragment,e),ot=i(e),Ce=f(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1qoc2ct"&&(Ce.innerHTML=Et),rt=i(e),c(ge.$$.fragment,e),pt=i(e),Be=f(e,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-ep1hhf"&&(Be.textContent=Vt),dt=i(e),c(_e.$$.fragment,e),mt=i(e),c(ve.$$.fragment,e),ft=i(e),Re=f(e,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-lubruw"&&(Re.textContent=It),ut=i(e),c(Ge.$$.fragment,e),Mt=i(e),c($e.$$.fragment,e),ct=i(e),Xe=f(e,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-7ubrrr"&&(Xe.innerHTML=qt),yt=i(e),c(ae.$$.fragment,e),bt=i(e),ke=f(e,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-7dnnek"&&(ke.textContent=Qt),Jt=i(e),ze=f(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-j15c34"&&(ze.innerHTML=Wt),ht=i(e),c(Ee.$$.fragment,e),Tt=i(e),Ve=f(e,"UL",{"data-svelte-h":!0}),u(Ve)!=="svelte-1pkgul5"&&(Ve.innerHTML=Ft),Ut=i(e),c(Ie.$$.fragment,e),wt=i(e),qe=f(e,"P",{}),Ht(qe).forEach(l),this.h()},h(){te(o,"name","hf:doc:metadata"),te(o,"content",ol),te(F,"class","warning"),te(se,"class","tip"),te(ne,"class","tip")},m(e,n){Kt(document.head,o),s(e,w,n),s(e,d,n),s(e,T,n),y(r,e,n),s(e,U,n),s(e,Z,n),s(e,Q,n),s(e,j,n),s(e,W,n),s(e,C,n),s(e,B,n),s(e,N,n),s(e,_,n),s(e,z,n),s(e,ee,n),y(E,e,n),s(e,v,n),s(e,H,n),s(e,R,n),y(k,e,n),s(e,g,n),s(e,F,n),s(e,G,n),s(e,Y,n),s(e,$,n),y(x,e,n),s(e,A,n),s(e,t,n),s(e,Qe,n),s(e,ie,n),s(e,We,n),y(oe,e,n),s(e,Fe,n),y(re,e,n),s(e,Ae,n),s(e,se,n),s(e,Ne,n),s(e,pe,n),s(e,He,n),y(de,e,n),s(e,Ye,n),s(e,me,n),s(e,xe,n),s(e,fe,n),s(e,Le,n),y(ue,e,n),s(e,Se,n),y(Me,e,n),s(e,De,n),s(e,ce,n),s(e,Pe,n),y(ye,e,n),s(e,Ke,n),y(be,e,n),s(e,Oe,n),s(e,ne,n),s(e,et,n),s(e,Je,n),s(e,tt,n),y(he,e,n),s(e,lt,n),s(e,Te,n),s(e,st,n),y(Ue,e,n),s(e,nt,n),y(we,e,n),s(e,at,n),s(e,Ze,n),s(e,it,n),y(je,e,n),s(e,ot,n),s(e,Ce,n),s(e,rt,n),y(ge,e,n),s(e,pt,n),s(e,Be,n),s(e,dt,n),y(_e,e,n),s(e,mt,n),y(ve,e,n),s(e,ft,n),s(e,Re,n),s(e,ut,n),y(Ge,e,n),s(e,Mt,n),y($e,e,n),s(e,ct,n),s(e,Xe,n),s(e,yt,n),y(ae,e,n),s(e,bt,n),s(e,ke,n),s(e,Jt,n),s(e,ze,n),s(e,ht,n),y(Ee,e,n),s(e,Tt,n),s(e,Ve,n),s(e,Ut,n),y(Ie,e,n),s(e,wt,n),s(e,qe,n),Zt=!0},p(e,[n]){const At={};n&2&&(At.$$scope={dirty:n,ctx:e}),k.$set(At);const Nt={};n&2&&(Nt.$$scope={dirty:n,ctx:e}),ae.$set(Nt)},i(e){Zt||(b(r.$$.fragment,e),b(E.$$.fragment,e),b(k.$$.fragment,e),b(x.$$.fragment,e),b(oe.$$.fragment,e),b(re.$$.fragment,e),b(de.$$.fragment,e),b(ue.$$.fragment,e),b(Me.$$.fragment,e),b(ye.$$.fragment,e),b(be.$$.fragment,e),b(he.$$.fragment,e),b(Ue.$$.fragment,e),b(we.$$.fragment,e),b(je.$$.fragment,e),b(ge.$$.fragment,e),b(_e.$$.fragment,e),b(ve.$$.fragment,e),b(Ge.$$.fragment,e),b($e.$$.fragment,e),b(ae.$$.fragment,e),b(Ee.$$.fragment,e),b(Ie.$$.fragment,e),Zt=!0)},o(e){J(r.$$.fragment,e),J(E.$$.fragment,e),J(k.$$.fragment,e),J(x.$$.fragment,e),J(oe.$$.fragment,e),J(re.$$.fragment,e),J(de.$$.fragment,e),J(ue.$$.fragment,e),J(Me.$$.fragment,e),J(ye.$$.fragment,e),J(be.$$.fragment,e),J(he.$$.fragment,e),J(Ue.$$.fragment,e),J(we.$$.fragment,e),J(je.$$.fragment,e),J(ge.$$.fragment,e),J(_e.$$.fragment,e),J(ve.$$.fragment,e),J(Ge.$$.fragment,e),J($e.$$.fragment,e),J(ae.$$.fragment,e),J(Ee.$$.fragment,e),J(Ie.$$.fragment,e),Zt=!1},d(e){e&&(l(w),l(d),l(T),l(U),l(Z),l(Q),l(j),l(W),l(C),l(B),l(N),l(_),l(z),l(ee),l(v),l(H),l(R),l(g),l(F),l(G),l(Y),l($),l(A),l(t),l(Qe),l(ie),l(We),l(Fe),l(Ae),l(se),l(Ne),l(pe),l(He),l(Ye),l(me),l(xe),l(fe),l(Le),l(Se),l(De),l(ce),l(Pe),l(Ke),l(Oe),l(ne),l(et),l(Je),l(tt),l(lt),l(Te),l(st),l(nt),l(at),l(Ze),l(it),l(ot),l(Ce),l(rt),l(pt),l(Be),l(dt),l(mt),l(ft),l(Re),l(ut),l(Mt),l(ct),l(Xe),l(yt),l(bt),l(ke),l(Jt),l(ze),l(ht),l(Tt),l(Ve),l(Ut),l(wt),l(qe)),l(o),h(r,e),h(E,e),h(k,e),h(x,e),h(oe,e),h(re,e),h(de,e),h(ue,e),h(Me,e),h(ye,e),h(be,e),h(he,e),h(Ue,e),h(we,e),h(je,e),h(ge,e),h(_e,e),h(ve,e),h(Ge,e),h($e,e),h(ae,e),h(Ee,e),h(Ie,e)}}}const ol='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"8-bit (LLM.int8() algorithm)","local":"8-bit-llmint8-algorithm","sections":[{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":3},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":3}],"depth":2},{"title":"4-bit (QLoRA algorithm)","local":"4-bit-qlora-algorithm","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":3},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":3},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":3}],"depth":2},{"title":"Dequantizing bitsandbytes models","local":"dequantizing-bitsandbytes-models","sections":[],"depth":2},{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function rl(I){return Lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ml extends St{constructor(o){super(),Dt(this,o,rl,il,xt,{})}}export{Ml as component};
