import{s as et,n as lt,o as tt}from"../chunks/scheduler.888833de.js";import{S as st,i as at,e as i,s as a,c as r,h as nt,a as p,d as t,b as n,f as Ol,g as c,j as o,k as bl,l as it,m as s,n as m,t as d,o as M,p as J}from"../chunks/index.128ce987.js";import{C as y}from"../chunks/CodeBlock.37df032e.js";import{H as ue,E as pt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function ot(jl){let u,Te,we,fe,T,be,f,Ul="Distributed inference splits the workload across multiple GPUs. It a useful technique for fitting larger models in memory and can process multiple prompts for higher throughput.",je,b,Il='This guide will show you how to use <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a> for distributed inference.',Ue,j,Ie,U,Zl="Accelerate is a library designed to simplify inference and training on multiple accelerators by handling the setup, allowing users to focus on their PyTorch code.",Ze,I,gl="Install Accelerate with the following command.",ge,Z,Ce,g,Cl='Initialize a <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> class in a Python file to create a distributed environment. The <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> class manages process management, device control and distribution, and process coordination.',Be,C,Bl='Move the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>accelerate.PartialState.device</code> to assign a GPU to each process.',Ge,B,ke,G,Gl='Use the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState.split_between_processes" rel="nofollow">split_between_processes</a> utility as a context manager to automatically distribute the prompts between the number of processes.',ve,k,We,v,kl="Call <code>accelerate launch</code> to run the script and use the <code>--num_processes</code> argument to set the number of GPUs to use.",_e,W,Xe,w,vl='<p>Refer to this minimal example <a href="https://gist.github.com/sayakpaul/cfaebd221820d7b43fae638b4dfa01ba" rel="nofollow">script</a> for running inference across multiple GPUs. To learn more, take a look at the <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">Distributed Inference with 🤗 Accelerate</a> guide.</p>',$e,_,Ee,X,Wl='PyTorch <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel</a> enables <a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook?section=data_parallelism" rel="nofollow">data parallelism</a>, which replicates the same model on each device, to process different batches of data in parallel.',Ne,$,_l="Import <code>torch.distributed</code> and <code>torch.multiprocessing</code> into a Python file to set up the distributed process group and to spawn the processes for inference on each GPU.",Re,E,Ve,N,Xl='Create a function for inference with <a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow">init_process_group</a>. This method creates a distributed environment with the backend type, the <code>rank</code> of the current process, and the <code>world_size</code> or number of processes participating (for example, 2 GPUs would be <code>world_size=2</code>).',xe,R,$l="Move the pipeline to <code>rank</code> and use <code>get_rank</code> to assign a GPU to each process. Each process handles a different prompt.",He,V,Ye,x,El='Use <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow">mp.spawn</a> to create the number of processes defined in <code>world_size</code>.',Ae,H,Qe,Y,Nl="Call <code>torchrun</code> to run the inference script and use the <code>--nproc_per_node</code> argument to set the number of GPUs to use.",Fe,A,ze,Q,Se,F,Rl="The <code>device_map</code> argument enables distributed inference by automatically placing model components on separate GPUs. This is especially useful when a model doesn’t fit on a single GPU. You can use <code>device_map</code> to selectively load and unload the required model components at a given stage as shown in the example below (assumes two GPUs are available).",qe,z,Vl="Set <code>device_map=&quot;balanced&quot;</code> to evenly distributes the text encoders on all available GPUs. You can use the <code>max_memory</code> argument to allocate a maximum amount of memory for each text encoder. Don’t load any other pipeline components to avoid memory usage.",Pe,S,Le,q,xl="After the text embeddings are computed, remove them from the GPU to make space for the diffusion transformer.",De,P,Ke,L,Hl="Set <code>device_map=&quot;auto&quot;</code> to automatically distribute the model on the two GPUs. This strategy places a model on the fastest device first before placing a model on a slower device like a CPU or hard drive if needed. The trade-off of storing model parameters on slower devices is slower inference latency.",Oe,D,el,h,Yl="<p>Run <code>pipeline.hf_device_map</code> to see how the various models are distributed across devices. This is useful for tracking model device placement. You can also call <code>hf_device_map</code> on the transformer model to see how it is distributed.</p>",ll,K,Al="Add the transformer model to the pipeline and set the <code>output_type=&quot;latent&quot;</code> to generate the latents.",tl,O,sl,ee,Ql="Remove the pipeline and transformer from memory and load a VAE to decode the latents. The VAE is typically small enough to be loaded on a single device.",al,le,nl,te,Fl="By selectively loading and unloading the models you need at a given stage and sharding the largest models across multiple GPUs, it is possible to run inference with large models on consumer GPUs.",il,se,pl,ae,zl='<a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook?section=context_parallelism" rel="nofollow">Context parallelism</a> splits input sequences across multiple GPUs to reduce memory usage. Each GPU processes its own slice of the sequence.',ol,ne,Sl='Use <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.set_attention_backend">set_attention_backend()</a> to switch to a more optimized attention backend. Refer to this <a href="../optimization/attention_backends#available-backends">table</a> for a complete list of available backends.',rl,ie,cl,pe,ql='Key (K) and value (V) representations communicate between devices using <a href="https://huggingface.co/papers/2310.01889" rel="nofollow">Ring Attention</a>. This ensures each split sees every other token’s K/V. Each GPU computes attention for its local K/V and passes it to the next GPU in the ring. No single GPU holds the full sequence, which reduces communication latency.',ml,oe,Pl='Pass a <a href="/docs/diffusers/main/en/api/parallel#diffusers.ContextParallelConfig">ContextParallelConfig</a> to the <code>parallel_config</code> argument of the transformer model. The config supports the <code>ring_degree</code> argument that determines how many devices to use for Ring Attention.',dl,re,Ml,ce,Jl,me,Ll='<a href="https://huggingface.co/papers/2309.14509" rel="nofollow">Ulysses Attention</a> splits a sequence across GPUs and performs an <em>all-to-all</em> communication (every device sends/receives data to every other device). Each GPU ends up with all tokens for only a subset of attention heads. Each GPU computes attention locally on all tokens for its head, then performs another all-to-all to regroup results by tokens for the next layer.',yl,de,Dl='<a href="/docs/diffusers/main/en/api/parallel#diffusers.ContextParallelConfig">ContextParallelConfig</a> supports Ulysses Attention through the <code>ulysses_degree</code> argument. This determines how many devices to use for Ulysses Attention.',ul,Me,Kl='Pass the <a href="/docs/diffusers/main/en/api/parallel#diffusers.ContextParallelConfig">ContextParallelConfig</a> to <code>enable_parallelism()</code>.',wl,Je,hl,ye,Tl,he,fl;return T=new ue({props:{title:"Distributed inference",local:"distributed-inference",headingTag:"h1"}}),j=new ue({props:{title:"Accelerate",local:"accelerate",headingTag:"h2"}}),Z=new y({props:{code:"dXYlMjBwaXAlMjBpbnN0YWxsJTIwYWNjZWxlcmF0ZQ==",highlighted:"uv pip install accelerate",wrap:!1}}),B=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQWRpc3RyaWJ1dGVkX3N0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEFwaXBlbGluZS50byhkaXN0cmlidXRlZF9zdGF0ZS5kZXZpY2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.float16
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)`,wrap:!1}}),k=new y({props:{code:"d2l0aCUyMGRpc3RyaWJ1dGVkX3N0YXRlLnNwbGl0X2JldHdlZW5fcHJvY2Vzc2VzKCU1QiUyMmElMjBkb2clMjIlMkMlMjAlMjJhJTIwY2F0JTIyJTVEKSUyMGFzJTIwcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmVzdWx0LnNhdmUoZiUyMnJlc3VsdF8lN0JkaXN0cmlidXRlZF9zdGF0ZS5wcm9jZXNzX2luZGV4JTdELnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),W=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2",wrap:!1}}),_=new ue({props:{title:"PyTorch Distributed",local:"pytorch-distributed",headingTag:"h2"}}),E=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.float16,
)`,wrap:!1}}),V=new y({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBwaXBlbGluZS50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    pipeline.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`,wrap:!1}}),H=new y({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),A=new y({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2",wrap:!1}}),Q=new ue({props:{title:"device_map",local:"devicemap",headingTag:"h2"}}),S=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEElMEFwaXBlbGluZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9tZW1vcnklM0QlN0IwJTNBJTIwJTIyMTZHQiUyMiUyQyUyMDElM0ElMjAlMjIxNkdCJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyRW5jb2RpbmclMjBwcm9tcHRzLiUyMiklMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcG9vbGVkX3Byb21wdF9lbWJlZHMlMkMlMjB0ZXh0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwcHJvbXB0XzIlM0ROb25lJTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline
<span class="hljs-keyword">import</span> torch

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>

pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>},
    torch_dtype=torch.bfloat16
)
<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Encoding prompts.&quot;</span>)
    prompt_embeds, pooled_prompt_embeds, text_ids = pipeline.encode_prompt(
        prompt=prompt, prompt_2=<span class="hljs-literal">None</span>, max_sequence_length=<span class="hljs-number">512</span>
    )`,wrap:!1}}),P=new y({props:{code:"aW1wb3J0JTIwZ2MlMjAlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9tYXhfbWVtb3J5X2FsbG9jYXRlZCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9wZWFrX21lbW9yeV9zdGF0cygpJTBBJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyXzIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXJfMiUwQWRlbCUyMHBpcGVsaW5lJTBBJTBBZmx1c2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gc 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()
    torch.cuda.reset_max_memory_allocated()
    torch.cuda.reset_peak_memory_stats()

<span class="hljs-keyword">del</span> pipeline.text_encoder
<span class="hljs-keyword">del</span> pipeline.text_encoder_2
<span class="hljs-keyword">del</span> pipeline.tokenizer
<span class="hljs-keyword">del</span> pipeline.tokenizer_2
<span class="hljs-keyword">del</span> pipeline

flush()`,wrap:!1}}),D=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTIwJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">import</span> torch 

transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)`,wrap:!1}}),O=new y({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyXzIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQXByaW50KCUyMlJ1bm5pbmclMjBkZW5vaXNpbmcuJTIyKSUwQWhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwNzY4JTJDJTIwMTM2MCUwQWxhdGVudHMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMHBvb2xlZF9wcm9tcHRfZW1iZWRzJTNEcG9vbGVkX3Byb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMuNSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRGhlaWdodCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEd2lkdGglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2Vz",highlighted:`pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    text_encoder_2=<span class="hljs-literal">None</span>,
    tokenizer=<span class="hljs-literal">None</span>,
    tokenizer_2=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running denoising.&quot;</span>)
height, width = <span class="hljs-number">768</span>, <span class="hljs-number">1360</span>
latents = pipeline(
    prompt_embeds=prompt_embeds,
    pooled_prompt_embeds=pooled_prompt_embeds,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=<span class="hljs-number">3.5</span>,
    height=height,
    width=width,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images`,wrap:!1}}),le=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUwQWZyb20lMjBkaWZmdXNlcnMuaW1hZ2VfcHJvY2Vzc29yJTIwaW1wb3J0JTIwVmFlSW1hZ2VQcm9jZXNzb3IlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZChja3B0X2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydmFlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEF2YWVfc2NhbGVfZmFjdG9yJTIwJTNEJTIwMiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBWYWVJbWFnZVByb2Nlc3Nvcih2YWVfc2NhbGVfZmFjdG9yJTNEdmFlX3NjYWxlX2ZhY3RvciklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyUnVubmluZyUyMGRlY29kaW5nLiUyMiklMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwRmx1eFBpcGVsaW5lLl91bnBhY2tfbGF0ZW50cyhsYXRlbnRzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGglMkMlMjB2YWVfc2NhbGVfZmFjdG9yKSUwQSUyMCUyMCUyMCUyMGxhdGVudHMlMjAlM0QlMjAobGF0ZW50cyUyMCUyRiUyMHZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IpJTIwJTJCJTIwdmFlLmNvbmZpZy5zaGlmdF9mYWN0b3IlMEElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHZhZS5kZWNvZGUobGF0ZW50cyUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlNUIwJTVELnNhdmUoJTIyc3BsaXRfdHJhbnNmb3JtZXIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> VaeImageProcessor

vae = AutoencoderKL.from_pretrained(ckpt_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
vae_scale_factor = <span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>)
image_processor = VaeImageProcessor(vae_scale_factor=vae_scale_factor)

<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running decoding.&quot;</span>)
    latents = FluxPipeline._unpack_latents(latents, height, width, vae_scale_factor)
    latents = (latents / vae.config.scaling_factor) + vae.config.shift_factor

    image = vae.decode(latents, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
    image = image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)
    image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;split_transformer.png&quot;</span>)`,wrap:!1}}),se=new ue({props:{title:"Context parallelism",local:"context-parallelism",headingTag:"h2"}}),ie=new ue({props:{title:"Ring Attention",local:"ring-attention",headingTag:"h3"}}),re=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, QwenImagePipeline, ContextParallelConfig

<span class="hljs-keyword">try</span>:
    torch.distributed.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>)
    rank = torch.distributed.get_rank()
    device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>, rank % torch.cuda.device_count())
    torch.cuda.set_device(device)
    
    transformer = AutoModel.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16, parallel_config=ContextParallelConfig(ring_degree=<span class="hljs-number">2</span>))
    pipeline = QwenImagePipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, transformer=transformer, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)
    pipeline.transformer.set_attention_backend(<span class="hljs-string">&quot;flash&quot;</span>)

    prompt = <span class="hljs-string">&quot;&quot;&quot;
    cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
    highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Must specify generator so all ranks start with same latents (or pass your own)</span>
    generator = torch.Generator().manual_seed(<span class="hljs-number">42</span>)
    image = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=generator).images[<span class="hljs-number">0</span>]
    
    <span class="hljs-keyword">if</span> rank == <span class="hljs-number">0</span>:
        image.save(<span class="hljs-string">&quot;output.png&quot;</span>)

<span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;An error occurred: <span class="hljs-subst">{e}</span>&quot;</span>)
    torch.distributed.<span class="hljs-built_in">breakpoint</span>()
    <span class="hljs-keyword">raise</span>

<span class="hljs-keyword">finally</span>:
    <span class="hljs-keyword">if</span> torch.distributed.is_initialized():
        torch.distributed.destroy_process_group()`,wrap:!1}}),ce=new ue({props:{title:"Ulysses Attention",local:"ulysses-attention",headingTag:"h3"}}),Je=new y({props:{code:"cGlwZWxpbmUudHJhbnNmb3JtZXIuZW5hYmxlX3BhcmFsbGVsaXNtKGNvbmZpZyUzRENvbnRleHRQYXJhbGxlbENvbmZpZyh1bHlzc2VzX2RlZ3JlZSUzRDIpKQ==",highlighted:'pipeline.transformer.enable_parallelism(config=ContextParallelConfig(ulysses_degree=<span class="hljs-number">2</span>))',wrap:!1}}),ye=new pt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/distributed_inference.md"}}),{c(){u=i("meta"),Te=a(),we=i("p"),fe=a(),r(T.$$.fragment),be=a(),f=i("p"),f.textContent=Ul,je=a(),b=i("p"),b.innerHTML=Il,Ue=a(),r(j.$$.fragment),Ie=a(),U=i("p"),U.textContent=Zl,Ze=a(),I=i("p"),I.textContent=gl,ge=a(),r(Z.$$.fragment),Ce=a(),g=i("p"),g.innerHTML=Cl,Be=a(),C=i("p"),C.innerHTML=Bl,Ge=a(),r(B.$$.fragment),ke=a(),G=i("p"),G.innerHTML=Gl,ve=a(),r(k.$$.fragment),We=a(),v=i("p"),v.innerHTML=kl,_e=a(),r(W.$$.fragment),Xe=a(),w=i("blockquote"),w.innerHTML=vl,$e=a(),r(_.$$.fragment),Ee=a(),X=i("p"),X.innerHTML=Wl,Ne=a(),$=i("p"),$.innerHTML=_l,Re=a(),r(E.$$.fragment),Ve=a(),N=i("p"),N.innerHTML=Xl,xe=a(),R=i("p"),R.innerHTML=$l,He=a(),r(V.$$.fragment),Ye=a(),x=i("p"),x.innerHTML=El,Ae=a(),r(H.$$.fragment),Qe=a(),Y=i("p"),Y.innerHTML=Nl,Fe=a(),r(A.$$.fragment),ze=a(),r(Q.$$.fragment),Se=a(),F=i("p"),F.innerHTML=Rl,qe=a(),z=i("p"),z.innerHTML=Vl,Pe=a(),r(S.$$.fragment),Le=a(),q=i("p"),q.textContent=xl,De=a(),r(P.$$.fragment),Ke=a(),L=i("p"),L.innerHTML=Hl,Oe=a(),r(D.$$.fragment),el=a(),h=i("blockquote"),h.innerHTML=Yl,ll=a(),K=i("p"),K.innerHTML=Al,tl=a(),r(O.$$.fragment),sl=a(),ee=i("p"),ee.textContent=Ql,al=a(),r(le.$$.fragment),nl=a(),te=i("p"),te.textContent=Fl,il=a(),r(se.$$.fragment),pl=a(),ae=i("p"),ae.innerHTML=zl,ol=a(),ne=i("p"),ne.innerHTML=Sl,rl=a(),r(ie.$$.fragment),cl=a(),pe=i("p"),pe.innerHTML=ql,ml=a(),oe=i("p"),oe.innerHTML=Pl,dl=a(),r(re.$$.fragment),Ml=a(),r(ce.$$.fragment),Jl=a(),me=i("p"),me.innerHTML=Ll,yl=a(),de=i("p"),de.innerHTML=Dl,ul=a(),Me=i("p"),Me.innerHTML=Kl,wl=a(),r(Je.$$.fragment),hl=a(),r(ye.$$.fragment),Tl=a(),he=i("p"),this.h()},l(e){const l=nt("svelte-u9bgzb",document.head);u=p(l,"META",{name:!0,content:!0}),l.forEach(t),Te=n(e),we=p(e,"P",{}),Ol(we).forEach(t),fe=n(e),c(T.$$.fragment,e),be=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-eljq9f"&&(f.textContent=Ul),je=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-og4l62"&&(b.innerHTML=Il),Ue=n(e),c(j.$$.fragment,e),Ie=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-nz1tds"&&(U.textContent=Zl),Ze=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1st21a7"&&(I.textContent=gl),ge=n(e),c(Z.$$.fragment,e),Ce=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-s7f0yp"&&(g.innerHTML=Cl),Be=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1ibki3b"&&(C.innerHTML=Bl),Ge=n(e),c(B.$$.fragment,e),ke=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-dxnfoj"&&(G.innerHTML=Gl),ve=n(e),c(k.$$.fragment,e),We=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-xu0wll"&&(v.innerHTML=kl),_e=n(e),c(W.$$.fragment,e),Xe=n(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-djm11n"&&(w.innerHTML=vl),$e=n(e),c(_.$$.fragment,e),Ee=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-nym58p"&&(X.innerHTML=Wl),Ne=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1q3d069"&&($.innerHTML=_l),Re=n(e),c(E.$$.fragment,e),Ve=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1vva4uo"&&(N.innerHTML=Xl),xe=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1329uwh"&&(R.innerHTML=$l),He=n(e),c(V.$$.fragment,e),Ye=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-84sp40"&&(x.innerHTML=El),Ae=n(e),c(H.$$.fragment,e),Qe=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-17g6264"&&(Y.innerHTML=Nl),Fe=n(e),c(A.$$.fragment,e),ze=n(e),c(Q.$$.fragment,e),Se=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-19ricyq"&&(F.innerHTML=Rl),qe=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-uepizv"&&(z.innerHTML=Vl),Pe=n(e),c(S.$$.fragment,e),Le=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-m088j3"&&(q.textContent=xl),De=n(e),c(P.$$.fragment,e),Ke=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-18jqegg"&&(L.innerHTML=Hl),Oe=n(e),c(D.$$.fragment,e),el=n(e),h=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(h)!=="svelte-eiyj9h"&&(h.innerHTML=Yl),ll=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-128ts8i"&&(K.innerHTML=Al),tl=n(e),c(O.$$.fragment,e),sl=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-jp9jpz"&&(ee.textContent=Ql),al=n(e),c(le.$$.fragment,e),nl=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-3tqui3"&&(te.textContent=Fl),il=n(e),c(se.$$.fragment,e),pl=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1bsyx0k"&&(ae.innerHTML=zl),ol=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-rgekxt"&&(ne.innerHTML=Sl),rl=n(e),c(ie.$$.fragment,e),cl=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-wnvqc8"&&(pe.innerHTML=ql),ml=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1kqjh5x"&&(oe.innerHTML=Pl),dl=n(e),c(re.$$.fragment,e),Ml=n(e),c(ce.$$.fragment,e),Jl=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1b28cdv"&&(me.innerHTML=Ll),yl=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1i9x1om"&&(de.innerHTML=Dl),ul=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-9gv0zf"&&(Me.innerHTML=Kl),wl=n(e),c(Je.$$.fragment,e),hl=n(e),c(ye.$$.fragment,e),Tl=n(e),he=p(e,"P",{}),Ol(he).forEach(t),this.h()},h(){bl(u,"name","hf:doc:metadata"),bl(u,"content",rt),bl(w,"class","tip"),bl(h,"class","tip")},m(e,l){it(document.head,u),s(e,Te,l),s(e,we,l),s(e,fe,l),m(T,e,l),s(e,be,l),s(e,f,l),s(e,je,l),s(e,b,l),s(e,Ue,l),m(j,e,l),s(e,Ie,l),s(e,U,l),s(e,Ze,l),s(e,I,l),s(e,ge,l),m(Z,e,l),s(e,Ce,l),s(e,g,l),s(e,Be,l),s(e,C,l),s(e,Ge,l),m(B,e,l),s(e,ke,l),s(e,G,l),s(e,ve,l),m(k,e,l),s(e,We,l),s(e,v,l),s(e,_e,l),m(W,e,l),s(e,Xe,l),s(e,w,l),s(e,$e,l),m(_,e,l),s(e,Ee,l),s(e,X,l),s(e,Ne,l),s(e,$,l),s(e,Re,l),m(E,e,l),s(e,Ve,l),s(e,N,l),s(e,xe,l),s(e,R,l),s(e,He,l),m(V,e,l),s(e,Ye,l),s(e,x,l),s(e,Ae,l),m(H,e,l),s(e,Qe,l),s(e,Y,l),s(e,Fe,l),m(A,e,l),s(e,ze,l),m(Q,e,l),s(e,Se,l),s(e,F,l),s(e,qe,l),s(e,z,l),s(e,Pe,l),m(S,e,l),s(e,Le,l),s(e,q,l),s(e,De,l),m(P,e,l),s(e,Ke,l),s(e,L,l),s(e,Oe,l),m(D,e,l),s(e,el,l),s(e,h,l),s(e,ll,l),s(e,K,l),s(e,tl,l),m(O,e,l),s(e,sl,l),s(e,ee,l),s(e,al,l),m(le,e,l),s(e,nl,l),s(e,te,l),s(e,il,l),m(se,e,l),s(e,pl,l),s(e,ae,l),s(e,ol,l),s(e,ne,l),s(e,rl,l),m(ie,e,l),s(e,cl,l),s(e,pe,l),s(e,ml,l),s(e,oe,l),s(e,dl,l),m(re,e,l),s(e,Ml,l),m(ce,e,l),s(e,Jl,l),s(e,me,l),s(e,yl,l),s(e,de,l),s(e,ul,l),s(e,Me,l),s(e,wl,l),m(Je,e,l),s(e,hl,l),m(ye,e,l),s(e,Tl,l),s(e,he,l),fl=!0},p:lt,i(e){fl||(d(T.$$.fragment,e),d(j.$$.fragment,e),d(Z.$$.fragment,e),d(B.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(_.$$.fragment,e),d(E.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(A.$$.fragment,e),d(Q.$$.fragment,e),d(S.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(Je.$$.fragment,e),d(ye.$$.fragment,e),fl=!0)},o(e){M(T.$$.fragment,e),M(j.$$.fragment,e),M(Z.$$.fragment,e),M(B.$$.fragment,e),M(k.$$.fragment,e),M(W.$$.fragment,e),M(_.$$.fragment,e),M(E.$$.fragment,e),M(V.$$.fragment,e),M(H.$$.fragment,e),M(A.$$.fragment,e),M(Q.$$.fragment,e),M(S.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(Je.$$.fragment,e),M(ye.$$.fragment,e),fl=!1},d(e){e&&(t(Te),t(we),t(fe),t(be),t(f),t(je),t(b),t(Ue),t(Ie),t(U),t(Ze),t(I),t(ge),t(Ce),t(g),t(Be),t(C),t(Ge),t(ke),t(G),t(ve),t(We),t(v),t(_e),t(Xe),t(w),t($e),t(Ee),t(X),t(Ne),t($),t(Re),t(Ve),t(N),t(xe),t(R),t(He),t(Ye),t(x),t(Ae),t(Qe),t(Y),t(Fe),t(ze),t(Se),t(F),t(qe),t(z),t(Pe),t(Le),t(q),t(De),t(Ke),t(L),t(Oe),t(el),t(h),t(ll),t(K),t(tl),t(sl),t(ee),t(al),t(nl),t(te),t(il),t(pl),t(ae),t(ol),t(ne),t(rl),t(cl),t(pe),t(ml),t(oe),t(dl),t(Ml),t(Jl),t(me),t(yl),t(de),t(ul),t(Me),t(wl),t(hl),t(Tl),t(he)),t(u),J(T,e),J(j,e),J(Z,e),J(B,e),J(k,e),J(W,e),J(_,e),J(E,e),J(V,e),J(H,e),J(A,e),J(Q,e),J(S,e),J(P,e),J(D,e),J(O,e),J(le,e),J(se,e),J(ie,e),J(re,e),J(ce,e),J(Je,e),J(ye,e)}}}const rt='{"title":"Distributed inference","local":"distributed-inference","sections":[{"title":"Accelerate","local":"accelerate","sections":[],"depth":2},{"title":"PyTorch Distributed","local":"pytorch-distributed","sections":[],"depth":2},{"title":"device_map","local":"devicemap","sections":[],"depth":2},{"title":"Context parallelism","local":"context-parallelism","sections":[{"title":"Ring Attention","local":"ring-attention","sections":[],"depth":3},{"title":"Ulysses Attention","local":"ulysses-attention","sections":[],"depth":3}],"depth":2}],"depth":1}';function ct(jl){return tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends st{constructor(u){super(),at(this,u,ct,ot,et,{})}}export{yt as component};
