import{s as il,n as nl,o as al}from"../chunks/scheduler.888833de.js";import{S as sl,i as pl,e as s,s as n,c as o,h as rl,a as p,d as l,b as a,f as ll,g as c,j as r,k as we,l as ol,m as i,n as d,t as m,o as u,p as M}from"../chunks/index.128ce987.js";import{C as h}from"../chunks/CodeBlock.37df032e.js";import{H as fe,E as cl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function dl(Jt){let f,ge,ye,Te,g,Je,T,_t='<a href="https://hf.co/papers/2211.09800" rel="nofollow">InstructPix2Pix</a> is a Stable Diffusion model trained to edit images from human-provided instructions. For example, your prompt can be “turn the clouds rainy” and the model will edit the input image accordingly. This model is conditioned on the text prompt (or editing instruction) and the input image.',_e,J,Ut='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix.py" rel="nofollow">train_instruct_pix2pix.py</a> training script to help you become familiar with it, and how you can adapt it for your own use case.',Ue,_,jt="Before running the script, make sure you install the library from source:",je,U,xe,j,xt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",Ze,x,We,y,Zt='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',Ce,Z,Wt="Initialize an 🤗 Accelerate environment:",Xe,W,Ie,C,Ct="To setup a default 🤗 Accelerate environment without choosing any configurations:",ve,X,$e,I,Xt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",ke,v,Be,$,It='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Ge,b,vt='<p>The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.</p>',Ne,k,Re,B,$t='The training script has many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L65" rel="nofollow"><code>parse_args()</code></a> function. Default values are provided for most parameters that work pretty well, but you can also set your own values in the training command if you’d like.',Ve,G,kt="For example, to increase the resolution of the input image:",Fe,N,Ye,R,Bt='Many of the basic and important parameters are described in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so this guide just focuses on the relevant parameters for InstructPix2Pix:',Le,V,Gt="<li><code>--original_image_column</code>: the original image before the edits are made</li> <li><code>--edited_image_column</code>: the image after the edits are made</li> <li><code>--edit_prompt_column</code>: the instructions to edit the image</li> <li><code>--conditioning_dropout_prob</code>: the dropout probability for the edited image and edit prompts during training which enables classifier-free guidance (CFG) for one or both conditioning inputs</li>",Ae,F,He,Y,Nt='The dataset preprocessing code and training loop are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L374" rel="nofollow"><code>main()</code></a> function. This is where you’ll make your changes to the training script to adapt it for your own use-case.',Qe,L,Rt='As with the script parameters, a walkthrough of the training script is provided in the <a href="text2image#training-script">Text-to-image</a> training guide. Instead, this guide takes a look at the InstructPix2Pix relevant parts of the script.',Se,A,Vt='The script begins by modifying the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L445" rel="nofollow">number of input channels</a> in the first convolutional layer of the UNet to account for InstructPix2Pix’s additional conditioning image:',Ee,H,ze,Q,Ft='These UNet parameters are <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L545C1-L551C6" rel="nofollow">updated</a> by the optimizer:',Pe,S,De,E,Yt='Next, the edited images and edit instructions are <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L624" rel="nofollow">preprocessed</a> and <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L610C24-L610C24" rel="nofollow">tokenized</a>. It is important the same image transformations are applied to the original and edited images.',qe,z,Ke,P,Lt='Finally, in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L730" rel="nofollow">training loop</a>, it starts by encoding the edited images into latent space:',Oe,D,et,q,At="Then, the script applies dropout to the original image and edit instruction embeddings to support CFG. This is what enables the model to modulate the influence of the edit instruction and original image on the edited image.",tt,K,lt,O,Ht='That’s pretty much it! Aside from the differences described here, the rest of the script is very similar to the <a href="text2image#training-script">Text-to-image</a> training script, so feel free to check it out for more details. If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',it,ee,nt,te,Qt="Once you’re happy with the changes to your script or if you’re okay with the default configuration, you’re ready to launch the training script! 🚀",at,le,St='This guide uses the <a href="https://huggingface.co/datasets/fusing/instructpix2pix-1000-samples" rel="nofollow">fusing/instructpix2pix-1000-samples</a> dataset, which is a smaller version of the <a href="https://huggingface.co/datasets/timbrooks/instructpix2pix-clip-filtered" rel="nofollow">original dataset</a>. You can also create and use your own dataset if you’d like (see the <a href="create_dataset">Create a dataset for training</a> guide).',st,ie,Et="Set the <code>MODEL_NAME</code> environment variable to the name of the model (can be a model id on the Hub or a path to a local model), and the <code>DATASET_ID</code> to the name of the dataset on the Hub. The script creates and saves all the components (feature extractor, scheduler, text encoder, UNet, etc.) to a subfolder in your repository.",pt,w,zt="<p>For better results, try longer training runs with a larger dataset. We’ve only tested this training script on a smaller-scale dataset.</p> <br/> <p>To monitor training progress with Weights and Biases, add the <code>--report_to=wandb</code> parameter to the training command and specify a validation image with <code>--val_image_url</code> and a validation prompt with <code>--validation_prompt</code>. This can be really useful for debugging the model.</p>",rt,ne,Pt="If you’re training on more than one GPU, add the <code>--multi_gpu</code> parameter to the <code>accelerate launch</code> command.",ot,ae,ct,se,Dt="After training is finished, you can use your new InstructPix2Pix for inference:",dt,pe,mt,re,qt="You should experiment with different <code>num_inference_steps</code>, <code>image_guidance_scale</code>, and <code>guidance_scale</code> values to see how they affect inference speed and quality. The guidance scale parameters are especially impactful because they control how much the original image and edit instructions affect the edited image.",ut,oe,Mt,ce,Kt='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix_sdxl.py" rel="nofollow"><code>train_instruct_pix2pix_sdxl.py</code></a> script to train a SDXL model to follow image editing instructions.',ht,de,Ot='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',ft,me,yt,ue,el="Congratulations on training your own InstructPix2Pix model! 🥳 To learn more about the model, it may be helpful to:",bt,Me,tl='<li>Read the <a href="https://huggingface.co/blog/instruction-tuning-sd" rel="nofollow">Instruction-tuning Stable Diffusion with InstructPix2Pix</a> blog post to learn more about some experiments we’ve done with InstructPix2Pix, dataset preparation, and results for different instructions.</li>',wt,he,gt,be,Tt;return g=new fe({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),U=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),x=new h({props:{code:"Y2QlMjBleGFtcGxlcyUyRmluc3RydWN0X3BpeDJwaXglMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHMudHh0",highlighted:`<span class="hljs-built_in">cd</span> examples/instruct_pix2pix
pip install -r requirements.txt`,wrap:!1}}),W=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),X=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),v=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),k=new fe({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),N=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUM=",highlighted:`accelerate launch train_instruct_pix2pix.py \\
  --resolution=512 \\`,wrap:!1}}),F=new fe({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),H=new h({props:{code:"aW5fY2hhbm5lbHMlMjAlM0QlMjA4JTBBb3V0X2NoYW5uZWxzJTIwJTNEJTIwdW5ldC5jb252X2luLm91dF9jaGFubmVscyUwQXVuZXQucmVnaXN0ZXJfdG9fY29uZmlnKGluX2NoYW5uZWxzJTNEaW5fY2hhbm5lbHMpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG5ld19jb252X2luJTIwJTNEJTIwbm4uQ29udjJkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5uZWxzJTJDJTIwb3V0X2NoYW5uZWxzJTJDJTIwdW5ldC5jb252X2luLmtlcm5lbF9zaXplJTJDJTIwdW5ldC5jb252X2luLnN0cmlkZSUyQyUyMHVuZXQuY29udl9pbi5wYWRkaW5nJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMG5ld19jb252X2luLndlaWdodC56ZXJvXygpJTBBJTIwJTIwJTIwJTIwbmV3X2NvbnZfaW4ud2VpZ2h0JTVCJTNBJTJDJTIwJTNBNCUyQyUyMCUzQSUyQyUyMCUzQSU1RC5jb3B5Xyh1bmV0LmNvbnZfaW4ud2VpZ2h0KSUwQSUyMCUyMCUyMCUyMHVuZXQuY29udl9pbiUyMCUzRCUyMG5ld19jb252X2lu",highlighted:`in_channels = <span class="hljs-number">8</span>
out_channels = unet.conv_in.out_channels
unet.register_to_config(in_channels=in_channels)

<span class="hljs-keyword">with</span> torch.no_grad():
    new_conv_in = nn.Conv2d(
        in_channels, out_channels, unet.conv_in.kernel_size, unet.conv_in.stride, unet.conv_in.padding
    )
    new_conv_in.weight.zero_()
    new_conv_in.weight[:, :<span class="hljs-number">4</span>, :, :].copy_(unet.conv_in.weight)
    unet.conv_in = new_conv_in`,wrap:!1}}),S=new h({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NscyglMEElMjAlMjAlMjAlMjB1bmV0LnBhcmFtZXRlcnMoKSUyQyUwQSUyMCUyMCUyMCUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwYmV0YXMlM0QoYXJncy5hZGFtX2JldGExJTJDJTIwYXJncy5hZGFtX2JldGEyKSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRGFyZ3MuYWRhbV93ZWlnaHRfZGVjYXklMkMlMEElMjAlMjAlMjAlMjBlcHMlM0RhcmdzLmFkYW1fZXBzaWxvbiUyQyUwQSk=",highlighted:`optimizer = optimizer_cls(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),z=new h({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBwcmVwcm9jZXNzZWRfaW1hZ2VzJTIwJTNEJTIwcHJlcHJvY2Vzc19pbWFnZXMoZXhhbXBsZXMpJTBBJTBBJTIwJTIwJTIwJTIwb3JpZ2luYWxfaW1hZ2VzJTJDJTIwZWRpdGVkX2ltYWdlcyUyMCUzRCUyMHByZXByb2Nlc3NlZF9pbWFnZXMuY2h1bmsoMiklMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZXMlMjAlM0QlMjBvcmlnaW5hbF9pbWFnZXMucmVzaGFwZSgtMSUyQyUyMDMlMkMlMjBhcmdzLnJlc29sdXRpb24lMkMlMjBhcmdzLnJlc29sdXRpb24pJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlcyUyMCUzRCUyMGVkaXRlZF9pbWFnZXMucmVzaGFwZSgtMSUyQyUyMDMlMkMlMjBhcmdzLnJlc29sdXRpb24lMkMlMjBhcmdzLnJlc29sdXRpb24pJTBBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJvcmlnaW5hbF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjBvcmlnaW5hbF9pbWFnZXMlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmVkaXRlZF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjBlZGl0ZWRfaW1hZ2VzJTBBJTBBJTIwJTIwJTIwJTIwY2FwdGlvbnMlMjAlM0QlMjBsaXN0KGV4YW1wbGVzJTVCZWRpdF9wcm9tcHRfY29sdW1uJTVEKSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVfY2FwdGlvbnMoY2FwdGlvbnMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    preprocessed_images = preprocess_images(examples)

    original_images, edited_images = preprocessed_images.chunk(<span class="hljs-number">2</span>)
    original_images = original_images.reshape(-<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, args.resolution, args.resolution)
    edited_images = edited_images.reshape(-<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, args.resolution, args.resolution)

    examples[<span class="hljs-string">&quot;original_pixel_values&quot;</span>] = original_images
    examples[<span class="hljs-string">&quot;edited_pixel_values&quot;</span>] = edited_images

    captions = <span class="hljs-built_in">list</span>(examples[edit_prompt_column])
    examples[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenize_captions(captions)
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),D=new h({props:{code:"bGF0ZW50cyUyMCUzRCUyMHZhZS5lbmNvZGUoYmF0Y2glNUIlMjJlZGl0ZWRfcGl4ZWxfdmFsdWVzJTIyJTVELnRvKHdlaWdodF9kdHlwZSkpLmxhdGVudF9kaXN0LnNhbXBsZSgpJTBBbGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwdmFlLmNvbmZpZy5zY2FsaW5nX2ZhY3Rvcg==",highlighted:`latents = vae.encode(batch[<span class="hljs-string">&quot;edited_pixel_values&quot;</span>].to(weight_dtype)).latent_dist.sample()
latents = latents * vae.config.scaling_factor`,wrap:!1}}),K=new h({props:{code:"ZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKGJhdGNoJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSU1QjAlNUQlMEFvcmlnaW5hbF9pbWFnZV9lbWJlZHMlMjAlM0QlMjB2YWUuZW5jb2RlKGJhdGNoJTVCJTIyb3JpZ2luYWxfcGl4ZWxfdmFsdWVzJTIyJTVELnRvKHdlaWdodF9kdHlwZSkpLmxhdGVudF9kaXN0Lm1vZGUoKSUwQSUwQWlmJTIwYXJncy5jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwcmFuZG9tX3AlMjAlM0QlMjB0b3JjaC5yYW5kKGJzeiUyQyUyMGRldmljZSUzRGxhdGVudHMuZGV2aWNlJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKSUwQSUyMCUyMCUyMCUyMHByb21wdF9tYXNrJTIwJTNEJTIwcmFuZG9tX3AlMjAlM0MlMjAyJTIwKiUyMGFyZ3MuY29uZGl0aW9uaW5nX2Ryb3BvdXRfcHJvYiUwQSUyMCUyMCUyMCUyMHByb21wdF9tYXNrJTIwJTNEJTIwcHJvbXB0X21hc2sucmVzaGFwZShic3olMkMlMjAxJTJDJTIwMSklMEElMjAlMjAlMjAlMjBudWxsX2NvbmRpdGlvbmluZyUyMCUzRCUyMHRleHRfZW5jb2Rlcih0b2tlbml6ZV9jYXB0aW9ucyglNUIlMjIlMjIlNUQpLnRvKGFjY2VsZXJhdG9yLmRldmljZSkpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHRvcmNoLndoZXJlKHByb21wdF9tYXNrJTJDJTIwbnVsbF9jb25kaXRpb25pbmclMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTBBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfbWFza19kdHlwZSUyMCUzRCUyMG9yaWdpbmFsX2ltYWdlX2VtYmVkcy5kdHlwZSUwQSUyMCUyMCUyMCUyMGltYWdlX21hc2slMjAlM0QlMjAxJTIwLSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAocmFuZG9tX3AlMjAlM0UlM0QlMjBhcmdzLmNvbmRpdGlvbmluZ19kcm9wb3V0X3Byb2IpLnRvKGltYWdlX21hc2tfZHR5cGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKiUyMChyYW5kb21fcCUyMCUzQyUyMDMlMjAqJTIwYXJncy5jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iKS50byhpbWFnZV9tYXNrX2R0eXBlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpbWFnZV9tYXNrJTIwJTNEJTIwaW1hZ2VfbWFzay5yZXNoYXBlKGJzeiUyQyUyMDElMkMlMjAxJTJDJTIwMSklMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZV9lbWJlZHMlMjAlM0QlMjBpbWFnZV9tYXNrJTIwKiUyMG9yaWdpbmFsX2ltYWdlX2VtYmVkcw==",highlighted:`encoder_hidden_states = text_encoder(batch[<span class="hljs-string">&quot;input_ids&quot;</span>])[<span class="hljs-number">0</span>]
original_image_embeds = vae.encode(batch[<span class="hljs-string">&quot;original_pixel_values&quot;</span>].to(weight_dtype)).latent_dist.mode()

<span class="hljs-keyword">if</span> args.conditioning_dropout_prob <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    random_p = torch.rand(bsz, device=latents.device, generator=generator)
    prompt_mask = random_p &lt; <span class="hljs-number">2</span> * args.conditioning_dropout_prob
    prompt_mask = prompt_mask.reshape(bsz, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
    null_conditioning = text_encoder(tokenize_captions([<span class="hljs-string">&quot;&quot;</span>]).to(accelerator.device))[<span class="hljs-number">0</span>]
    encoder_hidden_states = torch.where(prompt_mask, null_conditioning, encoder_hidden_states)

    image_mask_dtype = original_image_embeds.dtype
    image_mask = <span class="hljs-number">1</span> - (
        (random_p &gt;= args.conditioning_dropout_prob).to(image_mask_dtype)
        * (random_p &lt; <span class="hljs-number">3</span> * args.conditioning_dropout_prob).to(image_mask_dtype)
    )
    image_mask = image_mask.reshape(bsz, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
    original_image_embeds = image_mask * original_image_embeds`,wrap:!1}}),ee=new fe({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),ae=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTNEJTI0REFUQVNFVF9JRCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXNvbHV0aW9uJTNEMjU2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yYW5kb21fZmxpcCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNENTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY2hlY2twb2ludHNfdG90YWxfbGltaXQlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENWUtMDUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9ncmFkX25vcm0lM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTNEMC4wNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEZnAxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VlZCUzRDQyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> train_instruct_pix2pix.py \\
    --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
    --dataset_name=<span class="hljs-variable">$DATASET_ID</span> \\
    --enable_xformers_memory_efficient_attention \\
    --resolution=256 \\
    --random_flip \\
    --train_batch_size=4 \\
    --gradient_accumulation_steps=4 \\
    --gradient_checkpointing \\
    --max_train_steps=15000 \\
    --checkpointing_steps=5000 \\
    --checkpoints_total_limit=1 \\
    --learning_rate=5e-05 \\
    --max_grad_norm=1 \\
    --lr_warmup_steps=0 \\
    --conditioning_dropout_prob=0.05 \\
    --mixed_precision=fp16 \\
    --seed=42 \\
    --push_to_hub`,wrap:!1}}),pe=new h({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyeW91cl9jb29sX21vZGVsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnRlc3RfcGl4MnBpeF80LnBuZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhZGQlMjBzb21lJTIwZHVja3MlMjB0byUyMHRoZSUyMGxha2UlMjIlMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMjAlMEFpbWFnZV9ndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDEuNSUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwMTAlMEElMEFlZGl0ZWRfaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRG51bV9pbmZlcmVuY2Vfc3RlcHMlMkMlMEElMjAlMjAlMjBpbWFnZV9ndWlkYW5jZV9zY2FsZSUzRGltYWdlX2d1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWVkaXRlZF9pbWFnZS5zYXZlKCUyMmVkaXRlZF9pbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionInstructPix2PixPipeline.from_pretrained(<span class="hljs-string">&quot;your_cool_model&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/test_pix2pix_4.png&quot;</span>)
prompt = <span class="hljs-string">&quot;add some ducks to the lake&quot;</span>
num_inference_steps = <span class="hljs-number">20</span>
image_guidance_scale = <span class="hljs-number">1.5</span>
guidance_scale = <span class="hljs-number">10</span>

edited_image = pipeline(
   prompt,
   image=image,
   num_inference_steps=num_inference_steps,
   image_guidance_scale=image_guidance_scale,
   guidance_scale=guidance_scale,
   generator=generator,
).images[<span class="hljs-number">0</span>]
edited_image.save(<span class="hljs-string">&quot;edited_image.png&quot;</span>)`,wrap:!1}}),oe=new fe({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),me=new fe({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),he=new cl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/instructpix2pix.md"}}),{c(){f=s("meta"),ge=n(),ye=s("p"),Te=n(),o(g.$$.fragment),Je=n(),T=s("p"),T.innerHTML=_t,_e=n(),J=s("p"),J.innerHTML=Ut,Ue=n(),_=s("p"),_.textContent=jt,je=n(),o(U.$$.fragment),xe=n(),j=s("p"),j.textContent=xt,Ze=n(),o(x.$$.fragment),We=n(),y=s("blockquote"),y.innerHTML=Zt,Ce=n(),Z=s("p"),Z.textContent=Wt,Xe=n(),o(W.$$.fragment),Ie=n(),C=s("p"),C.textContent=Ct,ve=n(),o(X.$$.fragment),$e=n(),I=s("p"),I.textContent=Xt,ke=n(),o(v.$$.fragment),Be=n(),$=s("p"),$.innerHTML=It,Ge=n(),b=s("blockquote"),b.innerHTML=vt,Ne=n(),o(k.$$.fragment),Re=n(),B=s("p"),B.innerHTML=$t,Ve=n(),G=s("p"),G.textContent=kt,Fe=n(),o(N.$$.fragment),Ye=n(),R=s("p"),R.innerHTML=Bt,Le=n(),V=s("ul"),V.innerHTML=Gt,Ae=n(),o(F.$$.fragment),He=n(),Y=s("p"),Y.innerHTML=Nt,Qe=n(),L=s("p"),L.innerHTML=Rt,Se=n(),A=s("p"),A.innerHTML=Vt,Ee=n(),o(H.$$.fragment),ze=n(),Q=s("p"),Q.innerHTML=Ft,Pe=n(),o(S.$$.fragment),De=n(),E=s("p"),E.innerHTML=Yt,qe=n(),o(z.$$.fragment),Ke=n(),P=s("p"),P.innerHTML=Lt,Oe=n(),o(D.$$.fragment),et=n(),q=s("p"),q.textContent=At,tt=n(),o(K.$$.fragment),lt=n(),O=s("p"),O.innerHTML=Ht,it=n(),o(ee.$$.fragment),nt=n(),te=s("p"),te.textContent=Qt,at=n(),le=s("p"),le.innerHTML=St,st=n(),ie=s("p"),ie.innerHTML=Et,pt=n(),w=s("blockquote"),w.innerHTML=zt,rt=n(),ne=s("p"),ne.innerHTML=Pt,ot=n(),o(ae.$$.fragment),ct=n(),se=s("p"),se.textContent=Dt,dt=n(),o(pe.$$.fragment),mt=n(),re=s("p"),re.innerHTML=qt,ut=n(),o(oe.$$.fragment),Mt=n(),ce=s("p"),ce.innerHTML=Kt,ht=n(),de=s("p"),de.innerHTML=Ot,ft=n(),o(me.$$.fragment),yt=n(),ue=s("p"),ue.textContent=el,bt=n(),Me=s("ul"),Me.innerHTML=tl,wt=n(),o(he.$$.fragment),gt=n(),be=s("p"),this.h()},l(e){const t=rl("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(l),ge=a(e),ye=p(e,"P",{}),ll(ye).forEach(l),Te=a(e),c(g.$$.fragment,e),Je=a(e),T=p(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1wbq6mw"&&(T.innerHTML=_t),_e=a(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-5rcc6r"&&(J.innerHTML=Ut),Ue=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-l7dm2q"&&(_.textContent=jt),je=a(e),c(U.$$.fragment,e),xe=a(e),j=p(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-z4z0b9"&&(j.textContent=xt),Ze=a(e),c(x.$$.fragment,e),We=a(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1in84qc"&&(y.innerHTML=Zt),Ce=a(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-60q53m"&&(Z.textContent=Wt),Xe=a(e),c(W.$$.fragment,e),Ie=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-di6juu"&&(C.textContent=Ct),ve=a(e),c(X.$$.fragment,e),$e=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-tsz4qp"&&(I.textContent=Xt),ke=a(e),c(v.$$.fragment,e),Be=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1fkfdql"&&($.innerHTML=It),Ge=a(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-s3rfs5"&&(b.innerHTML=vt),Ne=a(e),c(k.$$.fragment,e),Re=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ouxjve"&&(B.innerHTML=$t),Ve=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-10dyj7s"&&(G.textContent=kt),Fe=a(e),c(N.$$.fragment,e),Ye=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-4ua73s"&&(R.innerHTML=Bt),Le=a(e),V=p(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-xkub9r"&&(V.innerHTML=Gt),Ae=a(e),c(F.$$.fragment,e),He=a(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1opaho7"&&(Y.innerHTML=Nt),Qe=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1urxowy"&&(L.innerHTML=Rt),Se=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-8vjj60"&&(A.innerHTML=Vt),Ee=a(e),c(H.$$.fragment,e),ze=a(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1nq4njr"&&(Q.innerHTML=Ft),Pe=a(e),c(S.$$.fragment,e),De=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1mob6kq"&&(E.innerHTML=Yt),qe=a(e),c(z.$$.fragment,e),Ke=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-15k4bki"&&(P.innerHTML=Lt),Oe=a(e),c(D.$$.fragment,e),et=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1f46pf0"&&(q.textContent=At),tt=a(e),c(K.$$.fragment,e),lt=a(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-rm72af"&&(O.innerHTML=Ht),it=a(e),c(ee.$$.fragment,e),nt=a(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-191xcj8"&&(te.textContent=Qt),at=a(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1jl92wm"&&(le.innerHTML=St),st=a(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1pi9kmf"&&(ie.innerHTML=Et),pt=a(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-dv5kk9"&&(w.innerHTML=zt),rt=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-mj0rx7"&&(ne.innerHTML=Pt),ot=a(e),c(ae.$$.fragment,e),ct=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-aiofgl"&&(se.textContent=Dt),dt=a(e),c(pe.$$.fragment,e),mt=a(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-3mecu5"&&(re.innerHTML=qt),ut=a(e),c(oe.$$.fragment,e),Mt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-tzsz20"&&(ce.innerHTML=Kt),ht=a(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-6dxtva"&&(de.innerHTML=Ot),ft=a(e),c(me.$$.fragment,e),yt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-ldm0c5"&&(ue.textContent=el),bt=a(e),Me=p(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-eqz35e"&&(Me.innerHTML=tl),wt=a(e),c(he.$$.fragment,e),gt=a(e),be=p(e,"P",{}),ll(be).forEach(l),this.h()},h(){we(f,"name","hf:doc:metadata"),we(f,"content",ml),we(y,"class","tip"),we(b,"class","tip"),we(w,"class","tip")},m(e,t){ol(document.head,f),i(e,ge,t),i(e,ye,t),i(e,Te,t),d(g,e,t),i(e,Je,t),i(e,T,t),i(e,_e,t),i(e,J,t),i(e,Ue,t),i(e,_,t),i(e,je,t),d(U,e,t),i(e,xe,t),i(e,j,t),i(e,Ze,t),d(x,e,t),i(e,We,t),i(e,y,t),i(e,Ce,t),i(e,Z,t),i(e,Xe,t),d(W,e,t),i(e,Ie,t),i(e,C,t),i(e,ve,t),d(X,e,t),i(e,$e,t),i(e,I,t),i(e,ke,t),d(v,e,t),i(e,Be,t),i(e,$,t),i(e,Ge,t),i(e,b,t),i(e,Ne,t),d(k,e,t),i(e,Re,t),i(e,B,t),i(e,Ve,t),i(e,G,t),i(e,Fe,t),d(N,e,t),i(e,Ye,t),i(e,R,t),i(e,Le,t),i(e,V,t),i(e,Ae,t),d(F,e,t),i(e,He,t),i(e,Y,t),i(e,Qe,t),i(e,L,t),i(e,Se,t),i(e,A,t),i(e,Ee,t),d(H,e,t),i(e,ze,t),i(e,Q,t),i(e,Pe,t),d(S,e,t),i(e,De,t),i(e,E,t),i(e,qe,t),d(z,e,t),i(e,Ke,t),i(e,P,t),i(e,Oe,t),d(D,e,t),i(e,et,t),i(e,q,t),i(e,tt,t),d(K,e,t),i(e,lt,t),i(e,O,t),i(e,it,t),d(ee,e,t),i(e,nt,t),i(e,te,t),i(e,at,t),i(e,le,t),i(e,st,t),i(e,ie,t),i(e,pt,t),i(e,w,t),i(e,rt,t),i(e,ne,t),i(e,ot,t),d(ae,e,t),i(e,ct,t),i(e,se,t),i(e,dt,t),d(pe,e,t),i(e,mt,t),i(e,re,t),i(e,ut,t),d(oe,e,t),i(e,Mt,t),i(e,ce,t),i(e,ht,t),i(e,de,t),i(e,ft,t),d(me,e,t),i(e,yt,t),i(e,ue,t),i(e,bt,t),i(e,Me,t),i(e,wt,t),d(he,e,t),i(e,gt,t),i(e,be,t),Tt=!0},p:nl,i(e){Tt||(m(g.$$.fragment,e),m(U.$$.fragment,e),m(x.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(v.$$.fragment,e),m(k.$$.fragment,e),m(N.$$.fragment,e),m(F.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(oe.$$.fragment,e),m(me.$$.fragment,e),m(he.$$.fragment,e),Tt=!0)},o(e){u(g.$$.fragment,e),u(U.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(H.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),Tt=!1},d(e){e&&(l(ge),l(ye),l(Te),l(Je),l(T),l(_e),l(J),l(Ue),l(_),l(je),l(xe),l(j),l(Ze),l(We),l(y),l(Ce),l(Z),l(Xe),l(Ie),l(C),l(ve),l($e),l(I),l(ke),l(Be),l($),l(Ge),l(b),l(Ne),l(Re),l(B),l(Ve),l(G),l(Fe),l(Ye),l(R),l(Le),l(V),l(Ae),l(He),l(Y),l(Qe),l(L),l(Se),l(A),l(Ee),l(ze),l(Q),l(Pe),l(De),l(E),l(qe),l(Ke),l(P),l(Oe),l(et),l(q),l(tt),l(lt),l(O),l(it),l(nt),l(te),l(at),l(le),l(st),l(ie),l(pt),l(w),l(rt),l(ne),l(ot),l(ct),l(se),l(dt),l(mt),l(re),l(ut),l(Mt),l(ce),l(ht),l(de),l(ft),l(yt),l(ue),l(bt),l(Me),l(wt),l(gt),l(be)),l(f),M(g,e),M(U,e),M(x,e),M(W,e),M(X,e),M(v,e),M(k,e),M(N,e),M(F,e),M(H,e),M(S,e),M(z,e),M(D,e),M(K,e),M(ee,e),M(ae,e),M(pe,e),M(oe,e),M(me,e),M(he,e)}}}const ml='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ul(Jt){return al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends sl{constructor(f){super(),pl(this,f,ul,dl,il,{})}}export{bl as component};
