import{s as xt,o as Gt,n as je}from"../chunks/scheduler.888833de.js";import{S as It,i as Vt,e as M,s as o,c as g,h as Ht,a as h,d as t,b as r,f as vt,g as _,j as b,k as Je,l as Xt,m as l,n as w,t as U,o as J,p as T}from"../chunks/index.128ce987.js";import{C as R}from"../chunks/CodeBlock.37df032e.js";import{H as Te,E as Bt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";import{H as pt,a as $e}from"../chunks/HfOption.79a0a3f5.js";function Nt(W){let i,d='The <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/kandinsky2_2/text_to_image/train_text_to_image_prior.py#L441" rel="nofollow"><code>main()</code></a> function contains the code for preparing the dataset and training the model.',s,f,a='One of the main differences you’ll notice right away is that the training script also loads a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> - in addition to a scheduler and tokenizer - for preprocessing images and a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a> model for encoding the images:',p,y,u,$,X='Kandinsky uses a <a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a> to generate the image embeddings, so you’ll want to setup the optimizer to learn the prior mode’s parameters.',N,k,G,v,F='Next, the input captions are tokenized, and images are <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/kandinsky2_2/text_to_image/train_text_to_image_prior.py#L632" rel="nofollow">preprocessed</a> by the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>:',I,x,Q,C,B='Finally, the <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/kandinsky2_2/text_to_image/train_text_to_image_prior.py#L718" rel="nofollow">training loop</a> converts the input images into latents, adds noise to the image embeddings, and makes a prediction:',H,m,j,V,Ze='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',E;return y=new R({props:{code:"bm9pc2Vfc2NoZWR1bGVyJTIwJTNEJTIwRERQTVNjaGVkdWxlcihiZXRhX3NjaGVkdWxlJTNEJTIyc3F1YXJlZGNvc19jYXBfdjIlMjIlMkMlMjBwcmVkaWN0aW9uX3R5cGUlM0QlMjJzYW1wbGUlMjIpJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQ0xJUEltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBhcmdzLnByZXRyYWluZWRfcHJpb3JfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIyaW1hZ2VfcHJvY2Vzc29yJTIyJTBBKSUwQXRva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGFyZ3MucHJldHJhaW5lZF9wcmlvcl9tb2RlbF9uYW1lX29yX3BhdGglMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBJTBBd2l0aCUyMENvbnRleHRNYW5hZ2VycyhkZWVwc3BlZWRfemVyb19pbml0X2Rpc2FibGVkX2NvbnRleHRfbWFuYWdlcigpKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncy5wcmV0cmFpbmVkX3ByaW9yX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHN1YmZvbGRlciUzRCUyMmltYWdlX2VuY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHdlaWdodF9kdHlwZSUwQSUyMCUyMCUyMCUyMCkuZXZhbCgpJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTIwJTNEJTIwQ0xJUFRleHRNb2RlbFdpdGhQcm9qZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmdzLnByZXRyYWluZWRfcHJpb3JfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R3ZWlnaHRfZHR5cGUlMEElMjAlMjAlMjAlMjApLmV2YWwoKQ==",highlighted:`noise_scheduler = DDPMScheduler(beta_schedule=<span class="hljs-string">&quot;squaredcos_cap_v2&quot;</span>, prediction_type=<span class="hljs-string">&quot;sample&quot;</span>)
image_processor = CLIPImageProcessor.from_pretrained(
    args.pretrained_prior_model_name_or_path, subfolder=<span class="hljs-string">&quot;image_processor&quot;</span>
)
tokenizer = CLIPTokenizer.from_pretrained(args.pretrained_prior_model_name_or_path, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)

<span class="hljs-keyword">with</span> ContextManagers(deepspeed_zero_init_disabled_context_manager()):
    image_encoder = CLIPVisionModelWithProjection.from_pretrained(
        args.pretrained_prior_model_name_or_path, subfolder=<span class="hljs-string">&quot;image_encoder&quot;</span>, torch_dtype=weight_dtype
    ).<span class="hljs-built_in">eval</span>()
    text_encoder = CLIPTextModelWithProjection.from_pretrained(
        args.pretrained_prior_model_name_or_path, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, torch_dtype=weight_dtype
    ).<span class="hljs-built_in">eval</span>()`,wrap:!1}}),k=new R({props:{code:"cHJpb3IlMjAlM0QlMjBQcmlvclRyYW5zZm9ybWVyLmZyb21fcHJldHJhaW5lZChhcmdzLnByZXRyYWluZWRfcHJpb3JfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIycHJpb3IlMjIpJTBBcHJpb3IudHJhaW4oKSUwQW9wdGltaXplciUyMCUzRCUyMG9wdGltaXplcl9jbHMoJTBBJTIwJTIwJTIwJTIwcHJpb3IucGFyYW1ldGVycygpJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUlMkMlMEElMjAlMjAlMjAlMjBiZXRhcyUzRChhcmdzLmFkYW1fYmV0YTElMkMlMjBhcmdzLmFkYW1fYmV0YTIpJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEYXJncy5hZGFtX3dlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGVwcyUzRGFyZ3MuYWRhbV9lcHNpbG9uJTJDJTBBKQ==",highlighted:`prior = PriorTransformer.from_pretrained(args.pretrained_prior_model_name_or_path, subfolder=<span class="hljs-string">&quot;prior&quot;</span>)
prior.train()
optimizer = optimizer_cls(
    prior.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),x=new R({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMiklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUJpbWFnZV9jb2x1bW4lNUQlNUQlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmNsaXBfcGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIydGV4dF9pbnB1dF9pZHMlMjIlNUQlMkMlMjBleGFtcGxlcyU1QiUyMnRleHRfbWFzayUyMiU1RCUyMCUzRCUyMHRva2VuaXplX2NhcHRpb25zKGV4YW1wbGVzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGVz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    images = [image.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[image_column]]
    examples[<span class="hljs-string">&quot;clip_pixel_values&quot;</span>] = image_processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
    examples[<span class="hljs-string">&quot;text_input_ids&quot;</span>], examples[<span class="hljs-string">&quot;text_mask&quot;</span>] = tokenize_captions(examples)
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),m=new R({props:{code:"bW9kZWxfcHJlZCUyMCUzRCUyMHByaW9yKCUwQSUyMCUyMCUyMCUyMG5vaXN5X2xhdGVudHMlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcCUzRHRpbWVzdGVwcyUyQyUwQSUyMCUyMCUyMCUyMHByb2pfZW1iZWRkaW5nJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUzRHRleHRfZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTJDJTBBJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0R0ZXh0X21hc2slMkMlMEEpLnByZWRpY3RlZF9pbWFnZV9lbWJlZGRpbmc=",highlighted:`model_pred = prior(
    noisy_latents,
    timestep=timesteps,
    proj_embedding=prompt_embeds,
    encoder_hidden_states=text_encoder_hidden_states,
    attention_mask=text_mask,
).predicted_image_embedding`,wrap:!1}}),{c(){i=M("p"),i.innerHTML=d,s=o(),f=M("p"),f.innerHTML=a,p=o(),g(y.$$.fragment),u=o(),$=M("p"),$.innerHTML=X,N=o(),g(k.$$.fragment),G=o(),v=M("p"),v.innerHTML=F,I=o(),g(x.$$.fragment),Q=o(),C=M("p"),C.innerHTML=B,H=o(),g(m.$$.fragment),j=o(),V=M("p"),V.innerHTML=Ze},l(c){i=h(c,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1vaqpft"&&(i.innerHTML=d),s=r(c),f=h(c,"P",{"data-svelte-h":!0}),b(f)!=="svelte-1q9rvn2"&&(f.innerHTML=a),p=r(c),_(y.$$.fragment,c),u=r(c),$=h(c,"P",{"data-svelte-h":!0}),b($)!=="svelte-f8cqiu"&&($.innerHTML=X),N=r(c),_(k.$$.fragment,c),G=r(c),v=h(c,"P",{"data-svelte-h":!0}),b(v)!=="svelte-1vfjyn1"&&(v.innerHTML=F),I=r(c),_(x.$$.fragment,c),Q=r(c),C=h(c,"P",{"data-svelte-h":!0}),b(C)!=="svelte-1t2oswx"&&(C.innerHTML=B),H=r(c),_(m.$$.fragment,c),j=r(c),V=h(c,"P",{"data-svelte-h":!0}),b(V)!=="svelte-6gmbd2"&&(V.innerHTML=Ze)},m(c,Z){l(c,i,Z),l(c,s,Z),l(c,f,Z),l(c,p,Z),w(y,c,Z),l(c,u,Z),l(c,$,Z),l(c,N,Z),w(k,c,Z),l(c,G,Z),l(c,v,Z),l(c,I,Z),w(x,c,Z),l(c,Q,Z),l(c,C,Z),l(c,H,Z),w(m,c,Z),l(c,j,Z),l(c,V,Z),E=!0},p:je,i(c){E||(U(y.$$.fragment,c),U(k.$$.fragment,c),U(x.$$.fragment,c),U(m.$$.fragment,c),E=!0)},o(c){J(y.$$.fragment,c),J(k.$$.fragment,c),J(x.$$.fragment,c),J(m.$$.fragment,c),E=!1},d(c){c&&(t(i),t(s),t(f),t(p),t(u),t($),t(N),t(G),t(v),t(I),t(Q),t(C),t(H),t(j),t(V)),T(y,c),T(k,c),T(x,c),T(m,c)}}}function Qt(W){let i,d='The <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/kandinsky2_2/text_to_image/train_text_to_image_decoder.py#L440" rel="nofollow"><code>main()</code></a> function contains the code for preparing the dataset and training the model.',s,f,a='Unlike the prior model, the decoder initializes a <a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a> to decode the latents into images and it uses a <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>:',p,y,u,$,X='Next, the script includes several image transforms and a <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/kandinsky2_2/text_to_image/train_text_to_image_decoder.py#L622" rel="nofollow">preprocessing</a> function for applying the transforms to the images and returning the pixel values:',N,k,G,v,F='Lastly, the <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/kandinsky2_2/text_to_image/train_text_to_image_decoder.py#L706" rel="nofollow">training loop</a> handles converting the images to latents, adding noise, and predicting the noise residual.',I,x,Q='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',C,B,H;return y=new R({props:{code:"d2l0aCUyMENvbnRleHRNYW5hZ2VycyhkZWVwc3BlZWRfemVyb19pbml0X2Rpc2FibGVkX2NvbnRleHRfbWFuYWdlcigpKSUzQSUwQSUyMCUyMCUyMCUyMHZhZSUyMCUzRCUyMFZRTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF9kZWNvZGVyX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHN1YmZvbGRlciUzRCUyMm1vdnElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHdlaWdodF9kdHlwZSUwQSUyMCUyMCUyMCUyMCkuZXZhbCgpJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW5jb2RlciUyMCUzRCUyMENMSVBWaXNpb25Nb2RlbFdpdGhQcm9qZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmdzLnByZXRyYWluZWRfcHJpb3JfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIyaW1hZ2VfZW5jb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEd2VpZ2h0X2R0eXBlJTBBJTIwJTIwJTIwJTIwKS5ldmFsKCklMEF1bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKGFyZ3MucHJldHJhaW5lZF9kZWNvZGVyX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIp",highlighted:`<span class="hljs-keyword">with</span> ContextManagers(deepspeed_zero_init_disabled_context_manager()):
    vae = VQModel.from_pretrained(
        args.pretrained_decoder_model_name_or_path, subfolder=<span class="hljs-string">&quot;movq&quot;</span>, torch_dtype=weight_dtype
    ).<span class="hljs-built_in">eval</span>()
    image_encoder = CLIPVisionModelWithProjection.from_pretrained(
        args.pretrained_prior_model_name_or_path, subfolder=<span class="hljs-string">&quot;image_encoder&quot;</span>, torch_dtype=weight_dtype
    ).<span class="hljs-built_in">eval</span>()
unet = UNet2DConditionModel.from_pretrained(args.pretrained_decoder_model_name_or_path, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),k=new R({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMiklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUJpbWFnZV9jb2x1bW4lNUQlNUQlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnRyYWluX3RyYW5zZm9ybXMoaW1hZ2UpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMGltYWdlcyU1RCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIyY2xpcF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    images = [image.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[image_column]]
    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
    examples[<span class="hljs-string">&quot;clip_pixel_values&quot;</span>] = image_processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),B=new R({props:{code:"bW9kZWxfcHJlZCUyMCUzRCUyMHVuZXQobm9pc3lfbGF0ZW50cyUyQyUyMHRpbWVzdGVwcyUyQyUyME5vbmUlMkMlMjBhZGRlZF9jb25kX2t3YXJncyUzRGFkZGVkX2NvbmRfa3dhcmdzKS5zYW1wbGUlNUIlM0ElMkMlMjAlM0E0JTVE",highlighted:'model_pred = unet(noisy_latents, timesteps, <span class="hljs-literal">None</span>, added_cond_kwargs=added_cond_kwargs).sample[:, :<span class="hljs-number">4</span>]',wrap:!1}}),{c(){i=M("p"),i.innerHTML=d,s=o(),f=M("p"),f.innerHTML=a,p=o(),g(y.$$.fragment),u=o(),$=M("p"),$.innerHTML=X,N=o(),g(k.$$.fragment),G=o(),v=M("p"),v.innerHTML=F,I=o(),x=M("p"),x.innerHTML=Q,C=o(),g(B.$$.fragment)},l(m){i=h(m,"P",{"data-svelte-h":!0}),b(i)!=="svelte-1d8rtu6"&&(i.innerHTML=d),s=r(m),f=h(m,"P",{"data-svelte-h":!0}),b(f)!=="svelte-81ryn1"&&(f.innerHTML=a),p=r(m),_(y.$$.fragment,m),u=r(m),$=h(m,"P",{"data-svelte-h":!0}),b($)!=="svelte-tuk4pl"&&($.innerHTML=X),N=r(m),_(k.$$.fragment,m),G=r(m),v=h(m,"P",{"data-svelte-h":!0}),b(v)!=="svelte-rweqyj"&&(v.innerHTML=F),I=r(m),x=h(m,"P",{"data-svelte-h":!0}),b(x)!=="svelte-6gmbd2"&&(x.innerHTML=Q),C=r(m),_(B.$$.fragment,m)},m(m,j){l(m,i,j),l(m,s,j),l(m,f,j),l(m,p,j),w(y,m,j),l(m,u,j),l(m,$,j),l(m,N,j),w(k,m,j),l(m,G,j),l(m,v,j),l(m,I,j),l(m,x,j),l(m,C,j),w(B,m,j),H=!0},p:je,i(m){H||(U(y.$$.fragment,m),U(k.$$.fragment,m),U(B.$$.fragment,m),H=!0)},o(m){J(y.$$.fragment,m),J(k.$$.fragment,m),J(B.$$.fragment,m),H=!1},d(m){m&&(t(i),t(s),t(f),t(p),t(u),t($),t(N),t(G),t(v),t(I),t(x),t(C)),T(y,m),T(k,m),T(B,m)}}}function Ft(W){let i,d,s,f;return i=new $e({props:{id:"script",option:"prior model",$$slots:{default:[Nt]},$$scope:{ctx:W}}}),s=new $e({props:{id:"script",option:"decoder model",$$slots:{default:[Qt]},$$scope:{ctx:W}}}),{c(){g(i.$$.fragment),d=o(),g(s.$$.fragment)},l(a){_(i.$$.fragment,a),d=r(a),_(s.$$.fragment,a)},m(a,p){w(i,a,p),l(a,d,p),w(s,a,p),f=!0},p(a,p){const y={};p&2&&(y.$$scope={dirty:p,ctx:a}),i.$set(y);const u={};p&2&&(u.$$scope={dirty:p,ctx:a}),s.$set(u)},i(a){f||(U(i.$$.fragment,a),U(s.$$.fragment,a),f=!0)},o(a){J(i.$$.fragment,a),J(s.$$.fragment,a),f=!1},d(a){a&&t(d),T(i,a),T(s,a)}}}function Et(W){let i,d;return i=new R({props:{code:"ZXhwb3J0JTIwREFUQVNFVF9OQU1FJTNEJTIybGFtYmRhbGFicyUyRm5hcnV0by1ibGlwLWNhcHRpb25zJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMCUyMHRyYWluX3RleHRfdG9faW1hZ2VfcHJpb3IucHklMjAlNUMlMEElMjAlMjAtLWRhdGFzZXRfbmFtZSUzRCUyNERBVEFTRVRfTkFNRSUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDc2OCUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtMDUlMjAlNUMlMEElMjAlMjAtLW1heF9ncmFkX25vcm0lM0QxJTIwJTVDJTBBJTIwJTIwLS1jaGVja3BvaW50c190b3RhbF9saW1pdCUzRDMlMjAlNUMlMEElMjAlMjAtLWxyX3NjaGVkdWxlciUzRCUyMmNvbnN0YW50JTIyJTIwJTVDJTBBJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwLS12YWxpZGF0aW9uX3Byb21wdHMlM0QlMjJBJTIwcm9ib3QlMjBuYXJ1dG8lMkMlMjA0ayUyMHBob3RvJTIyJTIwJTVDJTBBJTIwJTIwLS1yZXBvcnRfdG8lM0QlMjJ3YW5kYiUyMiUyMCU1QyUwQSUyMCUyMC0tcHVzaF90b19odWIlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlM0QlMjJrYW5kaTItcHJpb3ItbmFydXRvLW1vZGVsJTIy",highlighted:`<span class="hljs-built_in">export</span> DATASET_NAME=<span class="hljs-string">&quot;lambdalabs/naruto-blip-captions&quot;</span>

accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>  train_text_to_image_prior.py \\
  --dataset_name=<span class="hljs-variable">$DATASET_NAME</span> \\
  --resolution=768 \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --checkpoints_total_limit=3 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --validation_prompts=<span class="hljs-string">&quot;A robot naruto, 4k photo&quot;</span> \\
  --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
  --push_to_hub \\
  --output_dir=<span class="hljs-string">&quot;kandi2-prior-naruto-model&quot;</span>`,wrap:!1}}),{c(){g(i.$$.fragment)},l(s){_(i.$$.fragment,s)},m(s,f){w(i,s,f),d=!0},p:je,i(s){d||(U(i.$$.fragment,s),d=!0)},o(s){J(i.$$.fragment,s),d=!1},d(s){T(i,s)}}}function Yt(W){let i,d;return i=new R({props:{code:"ZXhwb3J0JTIwREFUQVNFVF9OQU1FJTNEJTIybGFtYmRhbGFicyUyRm5hcnV0by1ibGlwLWNhcHRpb25zJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMCUyMHRyYWluX3RleHRfdG9faW1hZ2VfZGVjb2Rlci5weSUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldF9uYW1lJTNEJTI0REFUQVNFVF9OQU1FJTIwJTVDJTBBJTIwJTIwLS1yZXNvbHV0aW9uJTNENzY4JTIwJTVDJTBBJTIwJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMSUyMCU1QyUwQSUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNENCUyMCU1QyUwQSUyMCUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMTUwMDAlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0QxZS0wNSUyMCU1QyUwQSUyMCUyMC0tbWF4X2dyYWRfbm9ybSUzRDElMjAlNUMlMEElMjAlMjAtLWNoZWNrcG9pbnRzX3RvdGFsX2xpbWl0JTNEMyUyMCU1QyUwQSUyMCUyMC0tbHJfc2NoZWR1bGVyJTNEJTIyY29uc3RhbnQlMjIlMjAlNUMlMEElMjAlMjAtLWxyX3dhcm11cF9zdGVwcyUzRDAlMjAlNUMlMEElMjAlMjAtLXZhbGlkYXRpb25fcHJvbXB0cyUzRCUyMkElMjByb2JvdCUyMG5hcnV0byUyQyUyMDRrJTIwcGhvdG8lMjIlMjAlNUMlMEElMjAlMjAtLXJlcG9ydF90byUzRCUyMndhbmRiJTIyJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1YiUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRCUyMmthbmRpMi1kZWNvZGVyLW5hcnV0by1tb2RlbCUyMg==",highlighted:`<span class="hljs-built_in">export</span> DATASET_NAME=<span class="hljs-string">&quot;lambdalabs/naruto-blip-captions&quot;</span>

accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>  train_text_to_image_decoder.py \\
  --dataset_name=<span class="hljs-variable">$DATASET_NAME</span> \\
  --resolution=768 \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --gradient_checkpointing \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --checkpoints_total_limit=3 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --validation_prompts=<span class="hljs-string">&quot;A robot naruto, 4k photo&quot;</span> \\
  --report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
  --push_to_hub \\
  --output_dir=<span class="hljs-string">&quot;kandi2-decoder-naruto-model&quot;</span>`,wrap:!1}}),{c(){g(i.$$.fragment)},l(s){_(i.$$.fragment,s)},m(s,f){w(i,s,f),d=!0},p:je,i(s){d||(U(i.$$.fragment,s),d=!0)},o(s){J(i.$$.fragment,s),d=!1},d(s){T(i,s)}}}function At(W){let i,d,s,f;return i=new $e({props:{id:"training-inference",option:"prior model",$$slots:{default:[Et]},$$scope:{ctx:W}}}),s=new $e({props:{id:"training-inference",option:"decoder model",$$slots:{default:[Yt]},$$scope:{ctx:W}}}),{c(){g(i.$$.fragment),d=o(),g(s.$$.fragment)},l(a){_(i.$$.fragment,a),d=r(a),_(s.$$.fragment,a)},m(a,p){w(i,a,p),l(a,d,p),w(s,a,p),f=!0},p(a,p){const y={};p&2&&(y.$$scope={dirty:p,ctx:a}),i.$set(y);const u={};p&2&&(u.$$scope={dirty:p,ctx:a}),s.$set(u)},i(a){f||(U(i.$$.fragment,a),U(s.$$.fragment,a),f=!0)},o(a){J(i.$$.fragment,a),J(s.$$.fragment,a),f=!1},d(a){a&&t(d),T(i,a),T(s,a)}}}function Lt(W){let i,d,s,f="<p>Feel free to replace <code>kandinsky-community/kandinsky-2-2-decoder</code> with your own trained decoder checkpoint!</p>",a;return i=new R({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBEaWZmdXNpb25QaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJpb3JfcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQob3V0cHV0X2RpciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwcmlvcl9jb21wb25lbnRzJTIwJTNEJTIwJTdCJTIycHJpb3JfJTIyJTIwJTJCJTIwayUzQSUyMHYlMjBmb3IlMjBrJTJDdiUyMGluJTIwcHJpb3JfcGlwZWxpbmUuY29tcG9uZW50cy5pdGVtcygpJTdEJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwKipwcmlvcl9jb21wb25lbnRzJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFwcm9tcHQlM0QlMjJBJTIwcm9ib3QlMjBuYXJ1dG8lMkMlMjA0ayUyMHBob3RvJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, DiffusionPipeline
<span class="hljs-keyword">import</span> torch

prior_pipeline = DiffusionPipeline.from_pretrained(output_dir, torch_dtype=torch.float16)
prior_components = {<span class="hljs-string">&quot;prior_&quot;</span> + k: v <span class="hljs-keyword">for</span> k,v <span class="hljs-keyword">in</span> prior_pipeline.components.items()}
pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, **prior_components, torch_dtype=torch.float16)

pipe.enable_model_cpu_offload()
prompt=<span class="hljs-string">&quot;A robot naruto, 4k photo&quot;</span>
image = pipeline(prompt=prompt, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){g(i.$$.fragment),d=o(),s=M("blockquote"),s.innerHTML=f,this.h()},l(p){_(i.$$.fragment,p),d=r(p),s=h(p,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(s)!=="svelte-a2nyya"&&(s.innerHTML=f),this.h()},h(){Je(s,"class","tip")},m(p,y){w(i,p,y),l(p,d,y),l(p,s,y),a=!0},p:je,i(p){a||(U(i.$$.fragment,p),a=!0)},o(p){J(i.$$.fragment,p),a=!1},d(p){p&&(t(d),t(s)),T(i,p)}}}function zt(W){let i,d,s,f="For the decoder model, you can also perform inference from a saved checkpoint which can be useful for viewing intermediate results. In this case, load the checkpoint into the UNet:",a,p,y;return i=new R({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGc2F2ZWQlMkZtb2RlbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUzRCUyMkElMjByb2JvdCUyMG5hcnV0byUyQyUyMDRrJTIwcGhvdG8lMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;path/to/saved/model&quot;</span>, torch_dtype=torch.float16)
pipeline.enable_model_cpu_offload()

prompt=<span class="hljs-string">&quot;A robot naruto, 4k photo&quot;</span>
image = pipeline(prompt=prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),p=new R({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGc2F2ZWQlMkZtb2RlbCUyMiUyMCUyQiUyMCUyMiUyRmNoZWNrcG9pbnQtJTNDTiUzRSUyRnVuZXQlMjIpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwdW5ldCUzRHVuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRCUyMkElMjByb2JvdCUyMG5hcnV0byUyQyUyMDRrJTIwcGhvdG8lMjIpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;path/to/saved/model&quot;</span> + <span class="hljs-string">&quot;/checkpoint-&lt;N&gt;/unet&quot;</span>)

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, unet=unet, torch_dtype=torch.float16)
pipeline.enable_model_cpu_offload()

image = pipeline(prompt=<span class="hljs-string">&quot;A robot naruto, 4k photo&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){g(i.$$.fragment),d=o(),s=M("p"),s.textContent=f,a=o(),g(p.$$.fragment)},l(u){_(i.$$.fragment,u),d=r(u),s=h(u,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1xieqd5"&&(s.textContent=f),a=r(u),_(p.$$.fragment,u)},m(u,$){w(i,u,$),l(u,d,$),l(u,s,$),l(u,a,$),w(p,u,$),y=!0},p:je,i(u){y||(U(i.$$.fragment,u),U(p.$$.fragment,u),y=!0)},o(u){J(i.$$.fragment,u),J(p.$$.fragment,u),y=!1},d(u){u&&(t(d),t(s),t(a)),T(i,u),T(p,u)}}}function qt(W){let i,d,s,f;return i=new $e({props:{id:"training-inference",option:"prior model",$$slots:{default:[Lt]},$$scope:{ctx:W}}}),s=new $e({props:{id:"training-inference",option:"decoder model",$$slots:{default:[zt]},$$scope:{ctx:W}}}),{c(){g(i.$$.fragment),d=o(),g(s.$$.fragment)},l(a){_(i.$$.fragment,a),d=r(a),_(s.$$.fragment,a)},m(a,p){w(i,a,p),l(a,d,p),w(s,a,p),f=!0},p(a,p){const y={};p&2&&(y.$$scope={dirty:p,ctx:a}),i.$set(y);const u={};p&2&&(u.$$scope={dirty:p,ctx:a}),s.$set(u)},i(a){f||(U(i.$$.fragment,a),U(s.$$.fragment,a),f=!0)},o(a){J(i.$$.fragment,a),J(s.$$.fragment,a),f=!1},d(a){a&&t(d),T(i,a),T(s,a)}}}function St(W){let i,d,s,f,a,p,y,u="<p>This script is experimental, and it’s easy to overfit and run into issues like catastrophic forgetting. Try exploring different hyperparameters to get the best results on your dataset.</p>",$,X,N="Kandinsky 2.2 is a multilingual text-to-image model capable of producing more photorealistic images. The model includes an image prior model for creating image embeddings from text prompts, and a decoder model that generates images based on the prior model’s embeddings. That’s why you’ll find two separate scripts in Diffusers for Kandinsky 2.2, one for training the prior model and one for training the decoder model. You can train both models separately, but to get the best results, you should train both the prior and decoder models.",k,G,v='Depending on your GPU, you may need to enable <code>gradient_checkpointing</code> (⚠️ not supported for the prior model!), <code>mixed_precision</code>, and <code>gradient_accumulation_steps</code> to help fit the model into memory and to speedup training. You can reduce your memory-usage even more by enabling memory-efficient attention with <a href="../optimization/xformers">xFormers</a> (version <a href="https://github.com/huggingface/diffusers/issues/2234#issuecomment-1416931212" rel="nofollow">v0.0.16</a> fails for training on some GPUs so you may need to install a development version instead).',F,I,x='This guide explores the <a href="https://github.com/huggingface/diffusers/blob/main/examples/kandinsky2_2/text_to_image/train_text_to_image_prior.py" rel="nofollow">train_text_to_image_prior.py</a> and the <a href="https://github.com/huggingface/diffusers/blob/main/examples/kandinsky2_2/text_to_image/train_text_to_image_decoder.py" rel="nofollow">train_text_to_image_decoder.py</a> scripts to help you become more familiar with it, and how you can adapt it for your own use-case.',Q,C,B="Before running the scripts, make sure you install the library from source:",H,m,j,V,Ze="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",E,c,Z,Y,ct='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',ke,P,mt="Initialize an 🤗 Accelerate environment:",Ce,D,Re,K,dt="To setup a default 🤗 Accelerate environment without choosing any configurations:",ve,O,xe,ee,ft="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Ge,te,Ie,le,ut='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Ve,A,yt="<p>The following sections highlight parts of the training scripts that are important for understanding how to modify it, but it doesn’t cover every aspect of the scripts in detail. If you’re interested in learning more, feel free to read through the scripts and let us know if you have any questions or concerns.</p>",He,ne,Xe,ae,Mt='The training scripts provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/6e68c71503682c8693cb5b06a4da4911dfd655ee/examples/kandinsky2_2/text_to_image/train_text_to_image_prior.py#L190" rel="nofollow"><code>parse_args()</code></a> function. The training scripts provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',Be,ie,ht="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",Ne,se,Qe,oe,bt='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so let’s get straight to a walkthrough of the Kandinsky training scripts!',Fe,re,Ee,pe,gt='The <a href="https://huggingface.co/papers/2303.09556" rel="nofollow">Min-SNR</a> weighting strategy can help with training by rebalancing the loss to achieve faster convergence. The training script supports predicting <code>epsilon</code> (noise) or <code>v_prediction</code>, but Min-SNR is compatible with both prediction types. This weighting strategy is only supported by PyTorch.',Ye,ce,_t="Add the <code>--snr_gamma</code> parameter and set it to the recommended value of 5.0:",Ae,me,Le,de,ze,fe,wt='The training script is also similar to the <a href="text2image#training-script">Text-to-image</a> training guide, but it’s been modified to support training the prior and decoder models. This guide focuses on the code that is unique to the Kandinsky 2.2 training scripts.',qe,L,Se,ue,Pe,ye,Ut="Once you’ve made all your changes or you’re okay with the default configuration, you’re ready to launch the training script! 🚀",De,Me,Jt='You’ll train on the <a href="https://huggingface.co/datasets/lambdalabs/naruto-blip-captions" rel="nofollow">Naruto BLIP captions</a> dataset to generate your own Naruto characters, but you can also create and train on your own dataset by following the <a href="create_dataset">Create a dataset for training</a> guide. Set the environment variable <code>DATASET_NAME</code> to the name of the dataset on the Hub or if you’re training on your own files, set the environment variable <code>TRAIN_DIR</code> to a path to your dataset.',Ke,he,Tt="If you’re training on more than one GPU, add the <code>--multi_gpu</code> parameter to the <code>accelerate launch</code> command.",Oe,z,$t="<p>To monitor training progress with Weights &amp; Biases, add the <code>--report_to=wandb</code> parameter to the training command. You’ll also need to add the <code>--validation_prompt</code> to the training command to keep track of results. This can be really useful for debugging the model and viewing intermediate results.</p>",et,q,tt,be,jt="Once training is finished, you can use your newly trained model for inference!",lt,S,nt,ge,at,_e,Zt="Congratulations on training a Kandinsky 2.2 model! To learn more about how to use your new model, the following guides may be helpful:",it,we,Wt='<li>Read the <a href="../using-diffusers/kandinsky">Kandinsky</a> guide to learn how to use it for a variety of different tasks (text-to-image, image-to-image, inpainting, interpolation), and how it can be combined with a ControlNet.</li> <li>Check out the <a href="dreambooth">DreamBooth</a> and <a href="lora">LoRA</a> training guides to learn how to train a personalized Kandinsky model with just a few example images. These two training techniques can even be combined!</li>',st,Ue,ot,We,rt;return a=new Te({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h1"}}),m=new R({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),c=new R({props:{code:"Y2QlMjBleGFtcGxlcyUyRmthbmRpbnNreTJfMiUyRnRleHRfdG9faW1hZ2UlMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHMudHh0",highlighted:`<span class="hljs-built_in">cd</span> examples/kandinsky2_2/text_to_image
pip install -r requirements.txt`,wrap:!1}}),D=new R({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),O=new R({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),te=new R({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),ne=new Te({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),se=new R({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3RleHRfdG9faW1hZ2VfcHJpb3IucHklMjAlNUMlMEElMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjI=",highlighted:`accelerate launch train_text_to_image_prior.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),re=new Te({props:{title:"Min-SNR weighting",local:"min-snr-weighting",headingTag:"h3"}}),me=new R({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3RleHRfdG9faW1hZ2VfcHJpb3IucHklMjAlNUMlMEElMjAlMjAtLXNucl9nYW1tYSUzRDUuMA==",highlighted:`accelerate launch train_text_to_image_prior.py \\
  --snr_gamma=5.0`,wrap:!1}}),de=new Te({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),L=new pt({props:{id:"script",options:["prior model","decoder model"],$$slots:{default:[Ft]},$$scope:{ctx:W}}}),ue=new Te({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),q=new pt({props:{id:"training-inference",options:["prior model","decoder model"],$$slots:{default:[At]},$$scope:{ctx:W}}}),S=new pt({props:{id:"training-inference",options:["prior model","decoder model"],$$slots:{default:[qt]},$$scope:{ctx:W}}}),ge=new Te({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Ue=new Bt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/kandinsky.md"}}),{c(){i=M("meta"),d=o(),s=M("p"),f=o(),g(a.$$.fragment),p=o(),y=M("blockquote"),y.innerHTML=u,$=o(),X=M("p"),X.textContent=N,k=o(),G=M("p"),G.innerHTML=v,F=o(),I=M("p"),I.innerHTML=x,Q=o(),C=M("p"),C.textContent=B,H=o(),g(m.$$.fragment),j=o(),V=M("p"),V.textContent=Ze,E=o(),g(c.$$.fragment),Z=o(),Y=M("blockquote"),Y.innerHTML=ct,ke=o(),P=M("p"),P.textContent=mt,Ce=o(),g(D.$$.fragment),Re=o(),K=M("p"),K.textContent=dt,ve=o(),g(O.$$.fragment),xe=o(),ee=M("p"),ee.textContent=ft,Ge=o(),g(te.$$.fragment),Ie=o(),le=M("p"),le.innerHTML=ut,Ve=o(),A=M("blockquote"),A.innerHTML=yt,He=o(),g(ne.$$.fragment),Xe=o(),ae=M("p"),ae.innerHTML=Mt,Be=o(),ie=M("p"),ie.innerHTML=ht,Ne=o(),g(se.$$.fragment),Qe=o(),oe=M("p"),oe.innerHTML=bt,Fe=o(),g(re.$$.fragment),Ee=o(),pe=M("p"),pe.innerHTML=gt,Ye=o(),ce=M("p"),ce.innerHTML=_t,Ae=o(),g(me.$$.fragment),Le=o(),g(de.$$.fragment),ze=o(),fe=M("p"),fe.innerHTML=wt,qe=o(),g(L.$$.fragment),Se=o(),g(ue.$$.fragment),Pe=o(),ye=M("p"),ye.textContent=Ut,De=o(),Me=M("p"),Me.innerHTML=Jt,Ke=o(),he=M("p"),he.innerHTML=Tt,Oe=o(),z=M("blockquote"),z.innerHTML=$t,et=o(),g(q.$$.fragment),tt=o(),be=M("p"),be.textContent=jt,lt=o(),g(S.$$.fragment),nt=o(),g(ge.$$.fragment),at=o(),_e=M("p"),_e.textContent=Zt,it=o(),we=M("ul"),we.innerHTML=Wt,st=o(),g(Ue.$$.fragment),ot=o(),We=M("p"),this.h()},l(e){const n=Ht("svelte-u9bgzb",document.head);i=h(n,"META",{name:!0,content:!0}),n.forEach(t),d=r(e),s=h(e,"P",{}),vt(s).forEach(t),f=r(e),_(a.$$.fragment,e),p=r(e),y=h(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(y)!=="svelte-b2kvo6"&&(y.innerHTML=u),$=r(e),X=h(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-6gxptx"&&(X.textContent=N),k=r(e),G=h(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-1qig94u"&&(G.innerHTML=v),F=r(e),I=h(e,"P",{"data-svelte-h":!0}),b(I)!=="svelte-1l8tmhd"&&(I.innerHTML=x),Q=r(e),C=h(e,"P",{"data-svelte-h":!0}),b(C)!=="svelte-if4ul"&&(C.textContent=B),H=r(e),_(m.$$.fragment,e),j=r(e),V=h(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-z4z0b9"&&(V.textContent=Ze),E=r(e),_(c.$$.fragment,e),Z=r(e),Y=h(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(Y)!=="svelte-1in84qc"&&(Y.innerHTML=ct),ke=r(e),P=h(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-60q53m"&&(P.textContent=mt),Ce=r(e),_(D.$$.fragment,e),Re=r(e),K=h(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-di6juu"&&(K.textContent=dt),ve=r(e),_(O.$$.fragment,e),xe=r(e),ee=h(e,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-tsz4qp"&&(ee.textContent=ft),Ge=r(e),_(te.$$.fragment,e),Ie=r(e),le=h(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-1fkfdql"&&(le.innerHTML=ut),Ve=r(e),A=h(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(A)!=="svelte-egugij"&&(A.innerHTML=yt),He=r(e),_(ne.$$.fragment,e),Xe=r(e),ae=h(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-r2qipu"&&(ae.innerHTML=Mt),Be=r(e),ie=h(e,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-1r0bv1x"&&(ie.innerHTML=ht),Ne=r(e),_(se.$$.fragment,e),Qe=r(e),oe=h(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-fx0sux"&&(oe.innerHTML=bt),Fe=r(e),_(re.$$.fragment,e),Ee=r(e),pe=h(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-1x34p4w"&&(pe.innerHTML=gt),Ye=r(e),ce=h(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-tp3kp"&&(ce.innerHTML=_t),Ae=r(e),_(me.$$.fragment,e),Le=r(e),_(de.$$.fragment,e),ze=r(e),fe=h(e,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-1c9upjb"&&(fe.innerHTML=wt),qe=r(e),_(L.$$.fragment,e),Se=r(e),_(ue.$$.fragment,e),Pe=r(e),ye=h(e,"P",{"data-svelte-h":!0}),b(ye)!=="svelte-9dei1q"&&(ye.textContent=Ut),De=r(e),Me=h(e,"P",{"data-svelte-h":!0}),b(Me)!=="svelte-1iz4o7j"&&(Me.innerHTML=Jt),Ke=r(e),he=h(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-mj0rx7"&&(he.innerHTML=Tt),Oe=r(e),z=h(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(z)!=="svelte-rxdmtb"&&(z.innerHTML=$t),et=r(e),_(q.$$.fragment,e),tt=r(e),be=h(e,"P",{"data-svelte-h":!0}),b(be)!=="svelte-5prdlk"&&(be.textContent=jt),lt=r(e),_(S.$$.fragment,e),nt=r(e),_(ge.$$.fragment,e),at=r(e),_e=h(e,"P",{"data-svelte-h":!0}),b(_e)!=="svelte-135a8e3"&&(_e.textContent=Zt),it=r(e),we=h(e,"UL",{"data-svelte-h":!0}),b(we)!=="svelte-1mj75la"&&(we.innerHTML=Wt),st=r(e),_(Ue.$$.fragment,e),ot=r(e),We=h(e,"P",{}),vt(We).forEach(t),this.h()},h(){Je(i,"name","hf:doc:metadata"),Je(i,"content",Pt),Je(y,"class","warning"),Je(Y,"class","tip"),Je(A,"class","tip"),Je(z,"class","tip")},m(e,n){Xt(document.head,i),l(e,d,n),l(e,s,n),l(e,f,n),w(a,e,n),l(e,p,n),l(e,y,n),l(e,$,n),l(e,X,n),l(e,k,n),l(e,G,n),l(e,F,n),l(e,I,n),l(e,Q,n),l(e,C,n),l(e,H,n),w(m,e,n),l(e,j,n),l(e,V,n),l(e,E,n),w(c,e,n),l(e,Z,n),l(e,Y,n),l(e,ke,n),l(e,P,n),l(e,Ce,n),w(D,e,n),l(e,Re,n),l(e,K,n),l(e,ve,n),w(O,e,n),l(e,xe,n),l(e,ee,n),l(e,Ge,n),w(te,e,n),l(e,Ie,n),l(e,le,n),l(e,Ve,n),l(e,A,n),l(e,He,n),w(ne,e,n),l(e,Xe,n),l(e,ae,n),l(e,Be,n),l(e,ie,n),l(e,Ne,n),w(se,e,n),l(e,Qe,n),l(e,oe,n),l(e,Fe,n),w(re,e,n),l(e,Ee,n),l(e,pe,n),l(e,Ye,n),l(e,ce,n),l(e,Ae,n),w(me,e,n),l(e,Le,n),w(de,e,n),l(e,ze,n),l(e,fe,n),l(e,qe,n),w(L,e,n),l(e,Se,n),w(ue,e,n),l(e,Pe,n),l(e,ye,n),l(e,De,n),l(e,Me,n),l(e,Ke,n),l(e,he,n),l(e,Oe,n),l(e,z,n),l(e,et,n),w(q,e,n),l(e,tt,n),l(e,be,n),l(e,lt,n),w(S,e,n),l(e,nt,n),w(ge,e,n),l(e,at,n),l(e,_e,n),l(e,it,n),l(e,we,n),l(e,st,n),w(Ue,e,n),l(e,ot,n),l(e,We,n),rt=!0},p(e,[n]){const kt={};n&2&&(kt.$$scope={dirty:n,ctx:e}),L.$set(kt);const Ct={};n&2&&(Ct.$$scope={dirty:n,ctx:e}),q.$set(Ct);const Rt={};n&2&&(Rt.$$scope={dirty:n,ctx:e}),S.$set(Rt)},i(e){rt||(U(a.$$.fragment,e),U(m.$$.fragment,e),U(c.$$.fragment,e),U(D.$$.fragment,e),U(O.$$.fragment,e),U(te.$$.fragment,e),U(ne.$$.fragment,e),U(se.$$.fragment,e),U(re.$$.fragment,e),U(me.$$.fragment,e),U(de.$$.fragment,e),U(L.$$.fragment,e),U(ue.$$.fragment,e),U(q.$$.fragment,e),U(S.$$.fragment,e),U(ge.$$.fragment,e),U(Ue.$$.fragment,e),rt=!0)},o(e){J(a.$$.fragment,e),J(m.$$.fragment,e),J(c.$$.fragment,e),J(D.$$.fragment,e),J(O.$$.fragment,e),J(te.$$.fragment,e),J(ne.$$.fragment,e),J(se.$$.fragment,e),J(re.$$.fragment,e),J(me.$$.fragment,e),J(de.$$.fragment,e),J(L.$$.fragment,e),J(ue.$$.fragment,e),J(q.$$.fragment,e),J(S.$$.fragment,e),J(ge.$$.fragment,e),J(Ue.$$.fragment,e),rt=!1},d(e){e&&(t(d),t(s),t(f),t(p),t(y),t($),t(X),t(k),t(G),t(F),t(I),t(Q),t(C),t(H),t(j),t(V),t(E),t(Z),t(Y),t(ke),t(P),t(Ce),t(Re),t(K),t(ve),t(xe),t(ee),t(Ge),t(Ie),t(le),t(Ve),t(A),t(He),t(Xe),t(ae),t(Be),t(ie),t(Ne),t(Qe),t(oe),t(Fe),t(Ee),t(pe),t(Ye),t(ce),t(Ae),t(Le),t(ze),t(fe),t(qe),t(Se),t(Pe),t(ye),t(De),t(Me),t(Ke),t(he),t(Oe),t(z),t(et),t(tt),t(be),t(lt),t(nt),t(at),t(_e),t(it),t(we),t(st),t(ot),t(We)),t(i),T(a,e),T(m,e),T(c,e),T(D,e),T(O,e),T(te,e),T(ne,e),T(se,e),T(re,e),T(me,e),T(de,e),T(L,e),T(ue,e),T(q,e),T(S,e),T(ge,e),T(Ue,e)}}}const Pt='{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[{"title":"Script parameters","local":"script-parameters","sections":[{"title":"Min-SNR weighting","local":"min-snr-weighting","sections":[],"depth":3}],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Dt(W){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nl extends It{constructor(i){super(),Vt(this,i,Dt,St,xt,{})}}export{nl as component};
