import{s as At,n as Ft,o as qt}from"../chunks/scheduler.888833de.js";import{S as Qt,i as Pt,e as s,s as n,c as p,h as Dt,a as o,d as a,b as i,f as St,g as m,j as r,k as de,l as Ot,m as l,n as c,t as d,o as u,p as f}from"../chunks/index.128ce987.js";import{C as h}from"../chunks/CodeBlock.37df032e.js";import{H as ue,E as Kt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function ea(ft){let g,ge,fe,ye,w,be,y,ht="<p>The text-to-image script is experimental, and it’s easy to overfit and run into issues like catastrophic forgetting. Try exploring different hyperparameters to get the best results on your dataset.</p>",Me,x,gt="Text-to-image models like Stable Diffusion are conditioned to generate images given a text prompt.",_e,U,yt='Training a model can be taxing on your hardware, but if you enable <code>gradient_checkpointing</code> and <code>mixed_precision</code>, it is possible to train a model on a single 24GB GPU. If you’re training with larger batch sizes or want to train faster, it’s better to use GPUs with more than 30GB of memory. You can reduce your memory footprint by enabling memory-efficient attention with <a href="../optimization/xformers">xFormers</a>.',we,$,bt='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/train_text_to_image.py" rel="nofollow">train_text_to_image.py</a> training script to help you become familiar with it, and how you can adapt it for your own use-case.',xe,T,Mt="Before running the script, make sure you install the library from source:",Ue,v,$e,Z,_t="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",Te,j,ve,b,wt='<p>🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.</p>',Ze,C,xt="Initialize an 🤗 Accelerate environment:",je,k,Ce,W,Ut="To setup a default 🤗 Accelerate environment without choosing any configurations:",ke,J,We,R,$t="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Je,G,Re,L,Tt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Ge,X,Le,M,vt='<p>The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/train_text_to_image.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.</p>',Xe,N,Zt='The training script provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/8959c5b9dec1c94d6ba482c94a58d2215c5fd026/examples/text_to_image/train_text_to_image.py#L193" rel="nofollow"><code>parse_args()</code></a> function. This function provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',Ne,H,jt="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",He,V,Ve,B,Ct="Some basic and important parameters include:",Be,Y,kt="<li><code>--pretrained_model_name_or_path</code>: the name of the model on the Hub or a local path to the pretrained model</li> <li><code>--dataset_name</code>: the name of the dataset on the Hub or a local path to the dataset to train on</li> <li><code>--image_column</code>: the name of the image column in the dataset to train on</li> <li><code>--caption_column</code>: the name of the text column in the dataset to train on</li> <li><code>--output_dir</code>: where to save the trained model</li> <li><code>--push_to_hub</code>: whether to push the trained model to the Hub</li> <li><code>--checkpointing_steps</code>: frequency of saving a checkpoint as the model trains; this is useful if for some reason training is interrupted, you can continue training from that checkpoint by adding <code>--resume_from_checkpoint</code> to your training command</li>",Ye,E,Ee,z,Wt='The <a href="https://huggingface.co/papers/2303.09556" rel="nofollow">Min-SNR</a> weighting strategy can help with training by rebalancing the loss to achieve faster convergence. The training script supports predicting <code>epsilon</code> (noise) or <code>v_prediction</code>, but Min-SNR is compatible with both prediction types. This weighting strategy is only supported by PyTorch.',ze,I,Jt="Add the <code>--snr_gamma</code> parameter and set it to the recommended value of 5.0:",Ie,S,Se,A,Rt='You can compare the loss surfaces for different <code>snr_gamma</code> values in this <a href="https://wandb.ai/sayakpaul/text2image-finetune-minsnr" rel="nofollow">Weights and Biases</a> report. For smaller datasets, the effects of Min-SNR may not be as obvious compared to larger datasets.',Ae,F,Fe,q,Gt='The dataset preprocessing code and training loop are found in the <a href="https://github.com/huggingface/diffusers/blob/8959c5b9dec1c94d6ba482c94a58d2215c5fd026/examples/text_to_image/train_text_to_image.py#L490" rel="nofollow"><code>main()</code></a> function. If you need to adapt the training script, this is where you’ll need to make your changes.',qe,Q,Lt='The <code>train_text_to_image</code> script starts by <a href="https://github.com/huggingface/diffusers/blob/8959c5b9dec1c94d6ba482c94a58d2215c5fd026/examples/text_to_image/train_text_to_image.py#L543" rel="nofollow">loading a scheduler</a> and tokenizer. You can choose to use a different scheduler here if you want:',Qe,P,Pe,D,Xt='Then the script <a href="https://github.com/huggingface/diffusers/blob/8959c5b9dec1c94d6ba482c94a58d2215c5fd026/examples/text_to_image/train_text_to_image.py#L619" rel="nofollow">loads the UNet</a> model:',De,O,Oe,K,Nt='Next, the text and image columns of the dataset need to be preprocessed. The <a href="https://github.com/huggingface/diffusers/blob/8959c5b9dec1c94d6ba482c94a58d2215c5fd026/examples/text_to_image/train_text_to_image.py#L724" rel="nofollow"><code>tokenize_captions</code></a> function handles tokenizing the inputs, and the <a href="https://github.com/huggingface/diffusers/blob/8959c5b9dec1c94d6ba482c94a58d2215c5fd026/examples/text_to_image/train_text_to_image.py#L742" rel="nofollow"><code>train_transforms</code></a> function specifies the type of transforms to apply to the image. Both of these functions are bundled into <code>preprocess_train</code>:',Ke,ee,et,te,Ht='Lastly, the <a href="https://github.com/huggingface/diffusers/blob/8959c5b9dec1c94d6ba482c94a58d2215c5fd026/examples/text_to_image/train_text_to_image.py#L878" rel="nofollow">training loop</a> handles everything else. It encodes images into latent space, adds noise to the latents, computes the text embeddings to condition on, updates the model parameters, and saves and pushes the model to the Hub. If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',tt,ae,at,le,Vt="Once you’ve made all your changes or you’re okay with the default configuration, you’re ready to launch the training script! 🚀",lt,ne,Bt='Let’s train on the <a href="https://huggingface.co/datasets/lambdalabs/naruto-blip-captions" rel="nofollow">Naruto BLIP captions</a> dataset to generate your own Naruto characters. Set the environment variables <code>MODEL_NAME</code> and <code>dataset_name</code> to the model and the dataset (either from the Hub or a local path). If you’re training on more than one GPU, add the <code>--multi_gpu</code> parameter to the <code>accelerate launch</code> command.',nt,_,Yt="<p>To train on a local dataset, set the <code>TRAIN_DIR</code> and <code>OUTPUT_DIR</code> environment variables to the path of the dataset and where to save the model to.</p>",it,ie,st,se,Et="Once training is complete, you can use your newly trained model for inference:",ot,oe,rt,re,pt,pe,zt="Congratulations on training your own text-to-image model! To learn more about how to use your new model, the following guides may be helpful:",mt,me,It='<li>Learn how to <a href="../using-diffusers/loading_adapters#LoRA">load LoRA weights</a> for inference if you trained your model with LoRA.</li> <li>Learn more about how certain parameters like guidance scale or techniques such as prompt weighting can help you control inference in the <a href="../using-diffusers/conditional_image_generation">Text-to-image</a> task guide.</li>',ct,ce,dt,he,ut;return w=new ue({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h1"}}),v=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),j=new h({props:{code:"Y2QlMjBleGFtcGxlcyUyRnRleHRfdG9faW1hZ2UlMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHMudHh0",highlighted:`<span class="hljs-built_in">cd</span> examples/text_to_image
pip install -r requirements.txt`,wrap:!1}}),k=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),J=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),G=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),X=new ue({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),V=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3RleHRfdG9faW1hZ2UucHklMjAlNUMlMEElMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjI=",highlighted:`accelerate launch train_text_to_image.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),E=new ue({props:{title:"Min-SNR weighting",local:"min-snr-weighting",headingTag:"h3"}}),S=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX3RleHRfdG9faW1hZ2UucHklMjAlNUMlMEElMjAlMjAtLXNucl9nYW1tYSUzRDUuMA==",highlighted:`accelerate launch train_text_to_image.py \\
  --snr_gamma=5.0`,wrap:!1}}),F=new ue({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),P=new h({props:{code:"bm9pc2Vfc2NoZWR1bGVyJTIwJTNEJTIwRERQTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoYXJncy5wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBDTElQVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBhcmdzLnByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTIwc3ViZm9sZGVyJTNEJTIydG9rZW5pemVyJTIyJTJDJTIwcmV2aXNpb24lM0RhcmdzLnJldmlzaW9uJTBBKQ==",highlighted:`noise_scheduler = DDPMScheduler.from_pretrained(args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
tokenizer = CLIPTokenizer.from_pretrained(
    args.pretrained_model_name_or_path, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>, revision=args.revision
)`,wrap:!1}}),O=new h({props:{code:"bG9hZF9tb2RlbCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChpbnB1dF9kaXIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyKSUwQW1vZGVsLnJlZ2lzdGVyX3RvX2NvbmZpZygqKmxvYWRfbW9kZWwuY29uZmlnKSUwQSUwQW1vZGVsLmxvYWRfc3RhdGVfZGljdChsb2FkX21vZGVsLnN0YXRlX2RpY3QoKSk=",highlighted:`load_model = UNet2DConditionModel.from_pretrained(input_dir, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)
model.register_to_config(**load_model.config)

model.load_state_dict(load_model.state_dict())`,wrap:!1}}),ee=new h({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMiklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUJpbWFnZV9jb2x1bW4lNUQlNUQlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnRyYWluX3RyYW5zZm9ybXMoaW1hZ2UpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMGltYWdlcyU1RCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVfY2FwdGlvbnMoZXhhbXBsZXMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    images = [image.convert(<span class="hljs-string">&quot;RGB&quot;</span>) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[image_column]]
    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
    examples[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenize_captions(examples)
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),ae=new ue({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),ie=new h({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWV4cG9ydCUyMGRhdGFzZXRfbmFtZSUzRCUyMmxhbWJkYWxhYnMlMkZuYXJ1dG8tYmxpcC1jYXB0aW9ucyUyMiUwQSUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjAtLW1peGVkX3ByZWNpc2lvbiUzRCUyMmZwMTYlMjIlMjAlMjB0cmFpbl90ZXh0X3RvX2ltYWdlLnB5JTIwJTVDJTBBJTIwJTIwLS1wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUzRCUyNE1PREVMX05BTUUlMjAlNUMlMEElMjAlMjAtLWRhdGFzZXRfbmFtZSUzRCUyNGRhdGFzZXRfbmFtZSUyMCU1QyUwQSUyMCUyMC0tdXNlX2VtYSUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMC0tY2VudGVyX2Nyb3AlMjAtLXJhbmRvbV9mbGlwJTIwJTVDJTBBJTIwJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMSUyMCU1QyUwQSUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNENCUyMCU1QyUwQSUyMCUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMTUwMDAlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0QxZS0wNSUyMCU1QyUwQSUyMCUyMC0tbWF4X2dyYWRfbm9ybSUzRDElMjAlNUMlMEElMjAlMjAtLWVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbiUyMCU1QyUwQSUyMCUyMC0tbHJfc2NoZWR1bGVyJTNEJTIyY29uc3RhbnQlMjIlMjAtLWxyX3dhcm11cF9zdGVwcyUzRDAlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlM0QlMjJzZC1uYXJ1dG8tbW9kZWwlMjIlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> dataset_name=<span class="hljs-string">&quot;lambdalabs/naruto-blip-captions&quot;</span>

accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>  train_text_to_image.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --dataset_name=<span class="hljs-variable">$dataset_name</span> \\
  --use_ema \\
  --resolution=512 --center_crop --random_flip \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --gradient_checkpointing \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --enable_xformers_memory_efficient_attention \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> --lr_warmup_steps=0 \\
  --output_dir=<span class="hljs-string">&quot;sd-naruto-model&quot;</span> \\
  --push_to_hub`,wrap:!1}}),oe=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlZF9tb2RlbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0QlMjJ5b2RhJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJ5b2RhLW5hcnV0by5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;path/to/saved_model&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipeline(prompt=<span class="hljs-string">&quot;yoda&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;yoda-naruto.png&quot;</span>)`,wrap:!1}}),re=new ue({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),ce=new Kt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/text2image.md"}}),{c(){g=s("meta"),ge=n(),fe=s("p"),ye=n(),p(w.$$.fragment),be=n(),y=s("blockquote"),y.innerHTML=ht,Me=n(),x=s("p"),x.textContent=gt,_e=n(),U=s("p"),U.innerHTML=yt,we=n(),$=s("p"),$.innerHTML=bt,xe=n(),T=s("p"),T.textContent=Mt,Ue=n(),p(v.$$.fragment),$e=n(),Z=s("p"),Z.textContent=_t,Te=n(),p(j.$$.fragment),ve=n(),b=s("blockquote"),b.innerHTML=wt,Ze=n(),C=s("p"),C.textContent=xt,je=n(),p(k.$$.fragment),Ce=n(),W=s("p"),W.textContent=Ut,ke=n(),p(J.$$.fragment),We=n(),R=s("p"),R.textContent=$t,Je=n(),p(G.$$.fragment),Re=n(),L=s("p"),L.innerHTML=Tt,Ge=n(),p(X.$$.fragment),Le=n(),M=s("blockquote"),M.innerHTML=vt,Xe=n(),N=s("p"),N.innerHTML=Zt,Ne=n(),H=s("p"),H.innerHTML=jt,He=n(),p(V.$$.fragment),Ve=n(),B=s("p"),B.textContent=Ct,Be=n(),Y=s("ul"),Y.innerHTML=kt,Ye=n(),p(E.$$.fragment),Ee=n(),z=s("p"),z.innerHTML=Wt,ze=n(),I=s("p"),I.innerHTML=Jt,Ie=n(),p(S.$$.fragment),Se=n(),A=s("p"),A.innerHTML=Rt,Ae=n(),p(F.$$.fragment),Fe=n(),q=s("p"),q.innerHTML=Gt,qe=n(),Q=s("p"),Q.innerHTML=Lt,Qe=n(),p(P.$$.fragment),Pe=n(),D=s("p"),D.innerHTML=Xt,De=n(),p(O.$$.fragment),Oe=n(),K=s("p"),K.innerHTML=Nt,Ke=n(),p(ee.$$.fragment),et=n(),te=s("p"),te.innerHTML=Ht,tt=n(),p(ae.$$.fragment),at=n(),le=s("p"),le.textContent=Vt,lt=n(),ne=s("p"),ne.innerHTML=Bt,nt=n(),_=s("blockquote"),_.innerHTML=Yt,it=n(),p(ie.$$.fragment),st=n(),se=s("p"),se.textContent=Et,ot=n(),p(oe.$$.fragment),rt=n(),p(re.$$.fragment),pt=n(),pe=s("p"),pe.textContent=zt,mt=n(),me=s("ul"),me.innerHTML=It,ct=n(),p(ce.$$.fragment),dt=n(),he=s("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(a),ge=i(e),fe=o(e,"P",{}),St(fe).forEach(a),ye=i(e),m(w.$$.fragment,e),be=i(e),y=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-ngwz2u"&&(y.innerHTML=ht),Me=i(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1y4tuwx"&&(x.textContent=gt),_e=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-118kckk"&&(U.innerHTML=yt),we=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1n3skb8"&&($.innerHTML=bt),xe=i(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-l7dm2q"&&(T.textContent=Mt),Ue=i(e),m(v.$$.fragment,e),$e=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-z4z0b9"&&(Z.textContent=_t),Te=i(e),m(j.$$.fragment,e),ve=i(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1in84qc"&&(b.innerHTML=wt),Ze=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-60q53m"&&(C.textContent=xt),je=i(e),m(k.$$.fragment,e),Ce=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-di6juu"&&(W.textContent=Ut),ke=i(e),m(J.$$.fragment,e),We=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-tsz4qp"&&(R.textContent=$t),Je=i(e),m(G.$$.fragment,e),Re=i(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1fkfdql"&&(L.innerHTML=Tt),Ge=i(e),m(X.$$.fragment,e),Le=i(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-lk7zez"&&(M.innerHTML=vt),Xe=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1rkoo94"&&(N.innerHTML=Zt),Ne=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1r0bv1x"&&(H.innerHTML=jt),He=i(e),m(V.$$.fragment,e),Ve=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1mzaa4h"&&(B.textContent=Ct),Be=i(e),Y=o(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-l4ycdy"&&(Y.innerHTML=kt),Ye=i(e),m(E.$$.fragment,e),Ee=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1x34p4w"&&(z.innerHTML=Wt),ze=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-tp3kp"&&(I.innerHTML=Jt),Ie=i(e),m(S.$$.fragment,e),Se=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1kq6d2e"&&(A.innerHTML=Rt),Ae=i(e),m(F.$$.fragment,e),Fe=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ibfk21"&&(q.innerHTML=Gt),qe=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1yog97t"&&(Q.innerHTML=Lt),Qe=i(e),m(P.$$.fragment,e),Pe=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1au88ib"&&(D.innerHTML=Xt),De=i(e),m(O.$$.fragment,e),Oe=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1e0707i"&&(K.innerHTML=Nt),Ke=i(e),m(ee.$$.fragment,e),et=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-13vuqhc"&&(te.innerHTML=Ht),tt=i(e),m(ae.$$.fragment,e),at=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-9dei1q"&&(le.textContent=Vt),lt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-9diks3"&&(ne.innerHTML=Bt),nt=i(e),_=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-n0lkki"&&(_.innerHTML=Yt),it=i(e),m(ie.$$.fragment,e),st=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1jtuc6"&&(se.textContent=Et),ot=i(e),m(oe.$$.fragment,e),rt=i(e),m(re.$$.fragment,e),pt=i(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-127gxsw"&&(pe.textContent=zt),mt=i(e),me=o(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-10nfhag"&&(me.innerHTML=It),ct=i(e),m(ce.$$.fragment,e),dt=i(e),he=o(e,"P",{}),St(he).forEach(a),this.h()},h(){de(g,"name","hf:doc:metadata"),de(g,"content",ta),de(y,"class","warning"),de(b,"class","tip"),de(M,"class","tip"),de(_,"class","tip")},m(e,t){Ot(document.head,g),l(e,ge,t),l(e,fe,t),l(e,ye,t),c(w,e,t),l(e,be,t),l(e,y,t),l(e,Me,t),l(e,x,t),l(e,_e,t),l(e,U,t),l(e,we,t),l(e,$,t),l(e,xe,t),l(e,T,t),l(e,Ue,t),c(v,e,t),l(e,$e,t),l(e,Z,t),l(e,Te,t),c(j,e,t),l(e,ve,t),l(e,b,t),l(e,Ze,t),l(e,C,t),l(e,je,t),c(k,e,t),l(e,Ce,t),l(e,W,t),l(e,ke,t),c(J,e,t),l(e,We,t),l(e,R,t),l(e,Je,t),c(G,e,t),l(e,Re,t),l(e,L,t),l(e,Ge,t),c(X,e,t),l(e,Le,t),l(e,M,t),l(e,Xe,t),l(e,N,t),l(e,Ne,t),l(e,H,t),l(e,He,t),c(V,e,t),l(e,Ve,t),l(e,B,t),l(e,Be,t),l(e,Y,t),l(e,Ye,t),c(E,e,t),l(e,Ee,t),l(e,z,t),l(e,ze,t),l(e,I,t),l(e,Ie,t),c(S,e,t),l(e,Se,t),l(e,A,t),l(e,Ae,t),c(F,e,t),l(e,Fe,t),l(e,q,t),l(e,qe,t),l(e,Q,t),l(e,Qe,t),c(P,e,t),l(e,Pe,t),l(e,D,t),l(e,De,t),c(O,e,t),l(e,Oe,t),l(e,K,t),l(e,Ke,t),c(ee,e,t),l(e,et,t),l(e,te,t),l(e,tt,t),c(ae,e,t),l(e,at,t),l(e,le,t),l(e,lt,t),l(e,ne,t),l(e,nt,t),l(e,_,t),l(e,it,t),c(ie,e,t),l(e,st,t),l(e,se,t),l(e,ot,t),c(oe,e,t),l(e,rt,t),c(re,e,t),l(e,pt,t),l(e,pe,t),l(e,mt,t),l(e,me,t),l(e,ct,t),c(ce,e,t),l(e,dt,t),l(e,he,t),ut=!0},p:Ft,i(e){ut||(d(w.$$.fragment,e),d(v.$$.fragment,e),d(j.$$.fragment,e),d(k.$$.fragment,e),d(J.$$.fragment,e),d(G.$$.fragment,e),d(X.$$.fragment,e),d(V.$$.fragment,e),d(E.$$.fragment,e),d(S.$$.fragment,e),d(F.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),ut=!0)},o(e){u(w.$$.fragment,e),u(v.$$.fragment,e),u(j.$$.fragment,e),u(k.$$.fragment,e),u(J.$$.fragment,e),u(G.$$.fragment,e),u(X.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),ut=!1},d(e){e&&(a(ge),a(fe),a(ye),a(be),a(y),a(Me),a(x),a(_e),a(U),a(we),a($),a(xe),a(T),a(Ue),a($e),a(Z),a(Te),a(ve),a(b),a(Ze),a(C),a(je),a(Ce),a(W),a(ke),a(We),a(R),a(Je),a(Re),a(L),a(Ge),a(Le),a(M),a(Xe),a(N),a(Ne),a(H),a(He),a(Ve),a(B),a(Be),a(Y),a(Ye),a(Ee),a(z),a(ze),a(I),a(Ie),a(Se),a(A),a(Ae),a(Fe),a(q),a(qe),a(Q),a(Qe),a(Pe),a(D),a(De),a(Oe),a(K),a(Ke),a(et),a(te),a(tt),a(at),a(le),a(lt),a(ne),a(nt),a(_),a(it),a(st),a(se),a(ot),a(rt),a(pt),a(pe),a(mt),a(me),a(ct),a(dt),a(he)),a(g),f(w,e),f(v,e),f(j,e),f(k,e),f(J,e),f(G,e),f(X,e),f(V,e),f(E,e),f(S,e),f(F,e),f(P,e),f(O,e),f(ee,e),f(ae,e),f(ie,e),f(oe,e),f(re,e),f(ce,e)}}}const ta='{"title":"Text-to-image","local":"text-to-image","sections":[{"title":"Script parameters","local":"script-parameters","sections":[{"title":"Min-SNR weighting","local":"min-snr-weighting","sections":[],"depth":3}],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function aa(ft){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends Qt{constructor(g){super(),Pt(this,g,aa,ea,At,{})}}export{oa as component};
