import{s as Ka,n as Oa,o as es}from"../chunks/scheduler.888833de.js";import{S as ls,i as ts,e as n,s,c as o,h as as,a as m,d as t,b as i,f as Pa,g as r,j as p,k as M,l as ss,m as a,n as c,t as d,o as g,p as y}from"../chunks/index.128ce987.js";import{C as u}from"../chunks/CodeBlock.37df032e.js";import{D as is}from"../chunks/DocNotebookDropdown.cbea0b77.js";import{H as b,E as ns}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function ms(Kt){let f,pl,nl,ol,X,rl,_,cl,k,Ot='Image-to-image is similar to <a href="conditional_image_generation">text-to-image</a>, but in addition to a prompt, you can also pass an initial image as a starting point for the diffusion process. The initial image is encoded to latent space and noise is added to it. Then the latent diffusion model takes a prompt and the noisy latent image, predicts the added noise, and removes the predicted noise from the initial latent image to get the new latent image. Lastly, a decoder decodes the new latent image back into an image.',dl,F,ea="With 🤗 Diffusers, this is as easy as 1-2-3:",gl,Q,la='<li>Load a checkpoint into the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> class; this pipeline automatically handles loading the correct pipeline class  based on the checkpoint:</li>',yl,R,ul,J,ta='<p>You’ll notice throughout the guide, we use <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> and <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a>, to save memory and increase inference speed. If you’re using PyTorch 2.0, then you don’t need to call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on your pipeline because it’ll already be using PyTorch 2.0’s native <a href="../optimization/fp16#scaled-dot-product-attention">scaled-dot product attention</a>.</p>',bl,h,aa="<li>Load an image to pass to the pipeline:</li>",Ml,C,fl,Z,sa="<li>Pass a prompt and image to the pipeline to generate an image:</li>",Jl,S,hl,w,ia='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Zl,Y,wl,$,na='The most popular image-to-image models are <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">Stable Diffusion v1.5</a>, <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">Stable Diffusion XL (SDXL)</a>, and <a href="https://huggingface.co/kandinsky-community/kandinsky-2-2-decoder" rel="nofollow">Kandinsky 2.2</a>. The results from the Stable Diffusion and Kandinsky models vary due to their architecture differences and training process; you can generally expect SDXL to produce higher quality images than Stable Diffusion v1.5. Let’s take a quick look at how to use each of these models and compare their results.',Ul,N,Tl,H,ma="Stable Diffusion v1.5 is a latent diffusion model initialized from an earlier checkpoint, and further finetuned for 595K steps on 512x512 images. To use this pipeline for image-to-image, you’ll need to prepare an initial image to pass to the pipeline. Then you can pass a prompt and the image to the pipeline to generate a new image:",Wl,z,Gl,U,pa='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdv1.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',jl,E,vl,q,oa='SDXL is a more powerful version of the Stable Diffusion model. It uses a larger base model, and an additional refiner model to increase the quality of the base model’s output. Read the <a href="sdxl">SDXL</a> guide for a more detailed walkthrough of how to use this model, and other techniques it uses to produce high quality images.',Il,L,Bl,T,ra='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Vl,D,xl,A,ca="The Kandinsky model is different from the Stable Diffusion models because it uses an image prior model to create image embeddings. The embeddings help create a better alignment between text and images, allowing the latent diffusion model to generate better images.",Xl,P,da="The simplest way to use Kandinsky 2.2 is:",_l,K,kl,W,ga='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-kandinsky.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Fl,O,Ql,ee,ya="There are several important parameters you can configure in the pipeline that’ll affect the image generation process and image quality. Let’s take a closer look at what these parameters do and how changing them affects the output.",Rl,le,Cl,te,ua="<code>strength</code> is one of the most important parameters to consider and it’ll have a huge impact on your generated image. It determines how much the generated image resembles the initial image. In other words:",Sl,ae,ba="<li>📈 a higher <code>strength</code> value gives the model more “creativity” to generate an image that’s different from the initial image; a <code>strength</code> value of 1.0 means the initial image is more or less ignored</li> <li>📉 a lower <code>strength</code> value means the generated image is more similar to the initial image</li>",Yl,se,Ma="The <code>strength</code> and <code>num_inference_steps</code> parameters are related because <code>strength</code> determines the number of noise steps to add. For example, if the <code>num_inference_steps</code> is 50 and <code>strength</code> is 0.8, then this means adding 40 (50 * 0.8) steps of noise to the initial image and then denoising for 40 steps to get the newly generated image.",$l,ie,Nl,G,fa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-0.4.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.4</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-0.6.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 0.6</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-strength-1.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">strength = 1.0</figcaption></div>',Hl,ne,zl,me,Ja="The <code>guidance_scale</code> parameter is used to control how closely aligned the generated image and text prompt are. A higher <code>guidance_scale</code> value means your generated image is more aligned with the prompt, while a lower <code>guidance_scale</code> value means your generated image has more space to deviate from the prompt.",El,pe,ha="You can combine <code>guidance_scale</code> with <code>strength</code> for even more precise control over how expressive the model is. For example, combine a high <code>strength + guidance_scale</code> for maximum creativity or use a combination of low <code>strength</code> and low <code>guidance_scale</code> to generate an image that resembles the initial image but is not as strictly bound to the prompt.",ql,oe,Ll,j,Za='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-0.1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 0.1</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-3.0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 5.0</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-guidance-7.5.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale = 10.0</figcaption></div>',Dl,re,Al,ce,wa="A negative prompt conditions the model to <em>not</em> include things in an image, and it can be used to improve image quality or modify an image. For example, you can improve image quality by including negative prompts like “poor details” or “blurry” to encourage the model to generate a higher quality image. Or you can modify an image by specifying things to exclude from an image.",Pl,de,Kl,v,Ua='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-negative-1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative_prompt = &quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-negative-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative_prompt = &quot;jungle&quot;</figcaption></div>',Ol,ge,et,ye,Ta="There are some other interesting ways you can use an image-to-image pipeline aside from just generating an image (although that is pretty cool too). You can take it a step further and chain it with other pipelines.",lt,ue,tt,be,Wa="Chaining a text-to-image and image-to-image pipeline allows you to generate an image from text and use the generated image as the initial image for the image-to-image pipeline. This is useful if you want to generate an image entirely from scratch. For example, let’s chain a Stable Diffusion and a Kandinsky model.",at,Me,Ga="Start by generating an image with the text-to-image pipeline:",st,fe,it,Je,ja="Now you can pass this generated image to the image-to-image pipeline:",nt,he,mt,Ze,pt,we,va="You can also chain multiple image-to-image pipelines together to create more interesting images. This can be useful for iteratively performing style transfer on an image, generating short GIFs, restoring color to an image, or restoring missing areas of an image.",ot,Ue,Ia="Start by generating an image:",rt,Te,ct,I,Ba="<p>It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in latent space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE.</p>",dt,We,Va='Pass the latent output from this pipeline to the next pipeline to generate an image in a <a href="https://huggingface.co/ogkalu/Comic-Diffusion" rel="nofollow">comic book art style</a>:',gt,Ge,yt,je,xa='Repeat one more time to generate the final image in a <a href="https://huggingface.co/kohbanye/pixel-art-style" rel="nofollow">pixel art style</a>:',ut,ve,bt,Ie,Mt,Be,Xa="Another way you can chain your image-to-image pipeline is with an upscaler and super-resolution pipeline to really increase the level of details in an image.",ft,Ve,_a="Start with an image-to-image pipeline:",Jt,xe,ht,B,ka="<p>It is important to specify <code>output_type=&quot;latent&quot;</code> in the pipeline to keep all the outputs in <em>latent</em> space to avoid an unnecessary decode-encode step. This only works if the chained pipelines are using the same VAE.</p>",Zt,Xe,Fa="Chain it to an upscaler pipeline to increase the image resolution:",wt,_e,Ut,ke,Qa="Finally, chain it to a super-resolution pipeline to further enhance the resolution:",Tt,Fe,Wt,Qe,Gt,Re,Ra="Trying to generate an image that looks exactly the way you want can be difficult, which is why controlled generation techniques and models are so useful. While you can use the <code>negative_prompt</code> to partially control image generation, there are more robust methods like prompt weighting and ControlNets.",jt,Ce,vt,Se,Ca='Prompt weighting allows you to scale the representation of each concept in a prompt. For example, in a prompt like “Astronaut in a jungle, cold color palette, muted colors, detailed, 8k”, you can choose to increase or decrease the embeddings of “astronaut” and “jungle”. The <a href="https://github.com/damian0815/compel" rel="nofollow">Compel</a> library provides a simple syntax for adjusting prompt weights and generating the embeddings. You can learn how to create the embeddings in the <a href="weighted_prompts">Prompt weighting</a> guide.',It,Ye,Sa='<a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a> has a <code>prompt_embeds</code> (and <code>negative_prompt_embeds</code> if you’re using a negative prompt) parameter where you can pass the embeddings which replaces the <code>prompt</code> parameter.',Bt,$e,Vt,Ne,xt,He,Ya="ControlNets provide a more flexible and accurate way to control image generation because you can use an additional conditioning image. The conditioning image can be a canny image, depth map, image segmentation, and even scribbles! Whatever type of conditioning image you choose, the ControlNet generates an image that preserves the information in it.",Xt,ze,$a="For example, let’s condition an image with a depth map to keep the spatial information in the image.",_t,Ee,kt,qe,Na='Load a ControlNet model conditioned on depth maps and the <a href="/docs/diffusers/main/en/api/pipelines/auto_pipeline#diffusers.AutoPipelineForImage2Image">AutoPipelineForImage2Image</a>:',Ft,Le,Qt,De,Ha="Now generate a new image conditioned on the depth map, initial image, and prompt:",Rt,Ae,Ct,V,za='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/lllyasviel/control_v11f1p_sd15_depth/resolve/main/images/control.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ControlNet image</figcaption></div>',St,Pe,Ea='Let’s apply a new <a href="https://huggingface.co/nitrosocke/elden-ring-diffusion" rel="nofollow">style</a> to the image generated from the ControlNet by chaining it with an image-to-image pipeline:',Yt,Ke,$t,x,qa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-elden-ring.png"/>',Nt,Oe,Ht,el,La='Running diffusion models is computationally expensive and intensive, but with a few optimization tricks, it is entirely possible to run them on consumer and free-tier GPUs. For example, you can use a more memory-efficient form of attention such as PyTorch 2.0’s <a href="../optimization/fp16#scaled-dot-product-attention">scaled-dot product attention</a> or <a href="../optimization/xformers">xFormers</a> (you can use one or the other, but there’s no need to use both). You can also offload the model to the GPU while the other pipeline components wait on the CPU.',zt,ll,Et,tl,Da='With <a href="../optimization/fp16#torchcompile"><code>torch.compile</code></a>, you can boost your inference speed even more by wrapping your UNet with it:',qt,al,Lt,sl,Aa='To learn more, take a look at the <a href="../optimization/memory">Reduce memory usage</a> and <a href="../optimization/fp16">Accelerate inference</a> guides.',Dt,il,At,ml,Pt;return X=new b({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h1"}}),_=new is({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/img2img.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/img2img.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/img2img.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/img2img.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/img2img.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/img2img.ipynb"}]}}),R=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),C=new u({props:{code:"aW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY2F0LnBuZyUyMik=",highlighted:'init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>)',wrap:!1}}),S=new u({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Y=new b({props:{title:"Popular models",local:"popular-models",headingTag:"h2"}}),N=new b({props:{title:"Stable Diffusion v1.5",local:"stable-diffusion-v15",headingTag:"h3"}}),z=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),E=new b({props:{title:"Stable Diffusion XL (SDXL)",local:"stable-diffusion-xl-sdxl",headingTag:"h3"}}),L=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctc2R4bC1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjUpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-sdxl-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),D=new b({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h3"}}),K=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTBBJTIzJTIwcGFzcyUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjBwaXBlbGluZSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),O=new b({props:{title:"Configure pipeline parameters",local:"configure-pipeline-parameters",headingTag:"h2"}}),le=new b({props:{title:"Strength",local:"strength",headingTag:"h3"}}),ie=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC44KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.8</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ne=new b({props:{title:"Guidance scale",local:"guidance-scale",headingTag:"h3"}}),oe=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, guidance_scale=<span class="hljs-number">8.0</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),re=new b({props:{title:"Negative prompt",local:"negative-prompt",headingTag:"h3"}}),de=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMnVnbHklMkMlMjBkZWZvcm1lZCUyQyUyMGRpc2ZpZ3VyZWQlMkMlMjBwb29yJTIwZGV0YWlscyUyQyUyMGJhZCUyMGFuYXRvbXklMjIlMEElMEElMjMlMjBwYXNzJTIwcHJvbXB0JTIwYW5kJTIwaW1hZ2UlMjB0byUyMHBpcGVsaW5lJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW5pdF9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
negative_prompt = <span class="hljs-string">&quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, negative_prompt=negative_prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),ge=new b({props:{title:"Chained image-to-image pipelines",local:"chained-image-to-image-pipelines",headingTag:"h2"}}),ue=new b({props:{title:"Text-to-image-to-image",local:"text-to-image-to-image",headingTag:"h3"}}),fe=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBdGV4dDJpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIpLmltYWdlcyU1QjAlNUQlMEF0ZXh0MmltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

text2image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>).images[<span class="hljs-number">0</span>]
text2image`,wrap:!1}}),he=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFpbWFnZTJpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMkMlMjBpbWFnZSUzRHRleHQyaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCdGV4dDJpbWFnZSUyQyUyMGltYWdlMmltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image2image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, image=text2image).images[<span class="hljs-number">0</span>]
make_image_grid([text2image, image2image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ze=new b({props:{title:"Image-to-image-to-image",local:"image-to-image-to-image",headingTag:"h3"}}),Te=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image = pipeline(prompt, image=init_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ge=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb2drYWx1JTJGQ29taWMtRGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwbmVlZCUyMHRvJTIwaW5jbHVkZSUyMHRoZSUyMHRva2VuJTIwJTIyY2hhcmxpZWJvJTIwYXJ0c3R5bGUlMjIlMjBpbiUyMHRoZSUyMHByb21wdCUyMHRvJTIwdXNlJTIwdGhpcyUyMGNoZWNrcG9pbnQlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNoYXJsaWVibyUyMGFydHN0eWxlJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZSUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;ogkalu/Comic-Diffusion&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># need to include the token &quot;charliebo artstyle&quot; in the prompt to use this checkpoint</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, charliebo artstyle&quot;</span>, image=image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ve=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya29oYmFueWUlMkZwaXhlbC1hcnQtc3R5bGUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEElMjMlMjBuZWVkJTIwdG8lMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJwaXhlbGFydHN0eWxlJTIyJTIwaW4lMjB0aGUlMjBwcm9tcHQlMjB0byUyMHVzZSUyMHRoaXMlMjBjaGVja3BvaW50JTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBwaXhlbGFydHN0eWxlJTIyJTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kohbanye/pixel-art-style&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># need to include the token &quot;pixelartstyle&quot; in the prompt to use this checkpoint</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, pixelartstyle&quot;</span>, image=image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Ie=new b({props:{title:"Image-to-upscaler-to-super-resolution",local:"image-to-upscaler-to-super-resolution",headingTag:"h3"}}),xe=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQSUyMyUyMHBhc3MlMjBwcm9tcHQlMjBhbmQlMjBpbWFnZSUyMHRvJTIwcGlwZWxpbmUlMEFpbWFnZV8xJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-comment"># pass prompt and image to pipeline</span>
image_1 = pipeline(prompt, image=init_image, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_e=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxhdGVudFVwc2NhbGVQaXBlbGluZSUwQSUwQXVwc2NhbGVyJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTGF0ZW50VXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnNkLXgyLWxhdGVudC11cHNjYWxlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdXBzY2FsZXIuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEF1cHNjYWxlci5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlXzIlMjAlM0QlMjB1cHNjYWxlcihwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlXzEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLatentUpscalePipeline

upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/sd-x2-latent-upscaler&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
upscaler.enable_model_cpu_offload()
upscaler.enable_xformers_memory_efficient_attention()

image_2 = upscaler(prompt, image=image_1).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Fe=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZSUwQSUwQXN1cGVyX3JlcyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblVwc2NhbGVQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXg0LXVwc2NhbGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXN1cGVyX3Jlcy5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXN1cGVyX3Jlcy5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlXzMlMjAlM0QlMjBzdXBlcl9yZXMocHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZV8yKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZV8zLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionUpscalePipeline

super_res = StableDiffusionUpscalePipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
super_res.enable_model_cpu_offload()
super_res.enable_xformers_memory_efficient_attention()

image_3 = super_res(prompt, image=image_2).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image_3.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Qe=new b({props:{title:"Control image generation",local:"control-image-generation",headingTag:"h2"}}),Ce=new b({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h3"}}),$e=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMjMlMjByZW1vdmUlMjBmb2xsb3dpbmclMjBsaW5lJTIwaWYlMjB4Rm9ybWVycyUyMGlzJTIwbm90JTIwaW5zdGFsbGVkJTIwb3IlMjB5b3UlMjBoYXZlJTIwUHlUb3JjaCUyMDIuMCUyMG9yJTIwaGlnaGVyJTIwaW5zdGFsbGVkJTBBcGlwZWxpbmUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTJDJTIwJTIzJTIwZ2VuZXJhdGVkJTIwZnJvbSUyMENvbXBlbCUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTJDJTIwJTIzJTIwZ2VuZXJhdGVkJTIwZnJvbSUyMENvbXBlbCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

image = pipeline(prompt_embeds=prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    negative_prompt_embeds=negative_prompt_embeds, <span class="hljs-comment"># generated from Compel</span>
    image=init_image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ne=new b({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),Ee=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbWcyaW1nLWluaXQucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoOTU4JTJDJTIwOTYwKSklMjAlMjMlMjByZXNpemUlMjB0byUyMGRlcHRoJTIwaW1hZ2UlMjBkaW1lbnNpb25zJTBBZGVwdGhfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyRnJlc29sdmUlMkZtYWluJTJGaW1hZ2VzJTJGY29udHJvbC5wbmclMjIpJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># prepare image</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>
init_image = load_image(url)
init_image = init_image.resize((<span class="hljs-number">958</span>, <span class="hljs-number">960</span>)) <span class="hljs-comment"># resize to depth image dimensions</span>
depth_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11f1p_sd15_depth/resolve/main/images/control.png&quot;</span>)
make_image_grid([init_image, depth_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Le=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUyMyUyMHJlbW92ZSUyMGZvbGxvd2luZyUyMGxpbmUlMjBpZiUyMHhGb3JtZXJzJTIwaXMlMjBub3QlMjBpbnN0YWxsZWQlMjBvciUyMHlvdSUyMGhhdmUlMjBQeVRvcmNoJTIwMi4wJTIwb3IlMjBoaWdoZXIlMjBpbnN0YWxsZWQlMEFwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()`,wrap:!1}}),Ae=new u({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlX2NvbnRyb2xfbmV0JTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGRlcHRoX2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSUyQyUyMGltYWdlX2NvbnRyb2xfbmV0JTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image_control_net = pipeline(prompt, image=init_image, control_image=depth_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, depth_image, image_control_net], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),Ke=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybml0cm9zb2NrZSUyRmVsZGVuLXJpbmctZGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZWxkZW4lMjByaW5nJTIwc3R5bGUlMjBhc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMjIlMjAlMjMlMjBpbmNsdWRlJTIwdGhlJTIwdG9rZW4lMjAlMjJlbGRlbiUyMHJpbmclMjBzdHlsZSUyMiUyMGluJTIwdGhlJTIwcHJvbXB0JTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIydWdseSUyQyUyMGRlZm9ybWVkJTJDJTIwZGlzZmlndXJlZCUyQyUyMHBvb3IlMjBkZXRhaWxzJTJDJTIwYmFkJTIwYW5hdG9teSUyMiUwQSUwQWltYWdlX2VsZGVuX3JpbmclMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlX2NvbnRyb2xfbmV0JTJDJTIwc3RyZW5ndGglM0QwLjQ1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMC41KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBkZXB0aF9pbWFnZSUyQyUyMGltYWdlX2NvbnRyb2xfbmV0JTJDJTIwaW1hZ2VfZWxkZW5fcmluZyU1RCUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDIp",highlighted:`pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;nitrosocke/elden-ring-diffusion&quot;</span>, torch_dtype=torch.float16,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

prompt = <span class="hljs-string">&quot;elden ring style astronaut in a jungle&quot;</span> <span class="hljs-comment"># include the token &quot;elden ring style&quot; in the prompt</span>
negative_prompt = <span class="hljs-string">&quot;ugly, deformed, disfigured, poor details, bad anatomy&quot;</span>

image_elden_ring = pipeline(prompt, negative_prompt=negative_prompt, image=image_control_net, strength=<span class="hljs-number">0.45</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, depth_image, image_control_net, image_elden_ring], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Oe=new b({props:{title:"Optimize",local:"optimize",headingTag:"h2"}}),ll=new u({props:{code:"JTJCJTIwcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-addition">+ pipeline.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipeline.enable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),al=new u({props:{code:"cGlwZWxpbmUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUocGlwZWxpbmUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:'pipeline.unet = torch.<span class="hljs-built_in">compile</span>(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),il=new ns({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/img2img.md"}}),{c(){f=n("meta"),pl=s(),nl=n("p"),ol=s(),o(X.$$.fragment),rl=s(),o(_.$$.fragment),cl=s(),k=n("p"),k.innerHTML=Ot,dl=s(),F=n("p"),F.textContent=ea,gl=s(),Q=n("ol"),Q.innerHTML=la,yl=s(),o(R.$$.fragment),ul=s(),J=n("blockquote"),J.innerHTML=ta,bl=s(),h=n("ol"),h.innerHTML=aa,Ml=s(),o(C.$$.fragment),fl=s(),Z=n("ol"),Z.innerHTML=sa,Jl=s(),o(S.$$.fragment),hl=s(),w=n("div"),w.innerHTML=ia,Zl=s(),o(Y.$$.fragment),wl=s(),$=n("p"),$.innerHTML=na,Ul=s(),o(N.$$.fragment),Tl=s(),H=n("p"),H.textContent=ma,Wl=s(),o(z.$$.fragment),Gl=s(),U=n("div"),U.innerHTML=pa,jl=s(),o(E.$$.fragment),vl=s(),q=n("p"),q.innerHTML=oa,Il=s(),o(L.$$.fragment),Bl=s(),T=n("div"),T.innerHTML=ra,Vl=s(),o(D.$$.fragment),xl=s(),A=n("p"),A.textContent=ca,Xl=s(),P=n("p"),P.textContent=da,_l=s(),o(K.$$.fragment),kl=s(),W=n("div"),W.innerHTML=ga,Fl=s(),o(O.$$.fragment),Ql=s(),ee=n("p"),ee.textContent=ya,Rl=s(),o(le.$$.fragment),Cl=s(),te=n("p"),te.innerHTML=ua,Sl=s(),ae=n("ul"),ae.innerHTML=ba,Yl=s(),se=n("p"),se.innerHTML=Ma,$l=s(),o(ie.$$.fragment),Nl=s(),G=n("div"),G.innerHTML=fa,Hl=s(),o(ne.$$.fragment),zl=s(),me=n("p"),me.innerHTML=Ja,El=s(),pe=n("p"),pe.innerHTML=ha,ql=s(),o(oe.$$.fragment),Ll=s(),j=n("div"),j.innerHTML=Za,Dl=s(),o(re.$$.fragment),Al=s(),ce=n("p"),ce.innerHTML=wa,Pl=s(),o(de.$$.fragment),Kl=s(),v=n("div"),v.innerHTML=Ua,Ol=s(),o(ge.$$.fragment),et=s(),ye=n("p"),ye.textContent=Ta,lt=s(),o(ue.$$.fragment),tt=s(),be=n("p"),be.textContent=Wa,at=s(),Me=n("p"),Me.textContent=Ga,st=s(),o(fe.$$.fragment),it=s(),Je=n("p"),Je.textContent=ja,nt=s(),o(he.$$.fragment),mt=s(),o(Ze.$$.fragment),pt=s(),we=n("p"),we.textContent=va,ot=s(),Ue=n("p"),Ue.textContent=Ia,rt=s(),o(Te.$$.fragment),ct=s(),I=n("blockquote"),I.innerHTML=Ba,dt=s(),We=n("p"),We.innerHTML=Va,gt=s(),o(Ge.$$.fragment),yt=s(),je=n("p"),je.innerHTML=xa,ut=s(),o(ve.$$.fragment),bt=s(),o(Ie.$$.fragment),Mt=s(),Be=n("p"),Be.textContent=Xa,ft=s(),Ve=n("p"),Ve.textContent=_a,Jt=s(),o(xe.$$.fragment),ht=s(),B=n("blockquote"),B.innerHTML=ka,Zt=s(),Xe=n("p"),Xe.textContent=Fa,wt=s(),o(_e.$$.fragment),Ut=s(),ke=n("p"),ke.textContent=Qa,Tt=s(),o(Fe.$$.fragment),Wt=s(),o(Qe.$$.fragment),Gt=s(),Re=n("p"),Re.innerHTML=Ra,jt=s(),o(Ce.$$.fragment),vt=s(),Se=n("p"),Se.innerHTML=Ca,It=s(),Ye=n("p"),Ye.innerHTML=Sa,Bt=s(),o($e.$$.fragment),Vt=s(),o(Ne.$$.fragment),xt=s(),He=n("p"),He.textContent=Ya,Xt=s(),ze=n("p"),ze.textContent=$a,_t=s(),o(Ee.$$.fragment),kt=s(),qe=n("p"),qe.innerHTML=Na,Ft=s(),o(Le.$$.fragment),Qt=s(),De=n("p"),De.textContent=Ha,Rt=s(),o(Ae.$$.fragment),Ct=s(),V=n("div"),V.innerHTML=za,St=s(),Pe=n("p"),Pe.innerHTML=Ea,Yt=s(),o(Ke.$$.fragment),$t=s(),x=n("div"),x.innerHTML=qa,Nt=s(),o(Oe.$$.fragment),Ht=s(),el=n("p"),el.innerHTML=La,zt=s(),o(ll.$$.fragment),Et=s(),tl=n("p"),tl.innerHTML=Da,qt=s(),o(al.$$.fragment),Lt=s(),sl=n("p"),sl.innerHTML=Aa,Dt=s(),o(il.$$.fragment),At=s(),ml=n("p"),this.h()},l(e){const l=as("svelte-u9bgzb",document.head);f=m(l,"META",{name:!0,content:!0}),l.forEach(t),pl=i(e),nl=m(e,"P",{}),Pa(nl).forEach(t),ol=i(e),r(X.$$.fragment,e),rl=i(e),r(_.$$.fragment,e),cl=i(e),k=m(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-190i437"&&(k.innerHTML=Ot),dl=i(e),F=m(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-18jurtu"&&(F.textContent=ea),gl=i(e),Q=m(e,"OL",{"data-svelte-h":!0}),p(Q)!=="svelte-1fqulv3"&&(Q.innerHTML=la),yl=i(e),r(R.$$.fragment,e),ul=i(e),J=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(J)!=="svelte-6k8ium"&&(J.innerHTML=ta),bl=i(e),h=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(h)!=="svelte-1yttwto"&&(h.innerHTML=aa),Ml=i(e),r(C.$$.fragment,e),fl=i(e),Z=m(e,"OL",{start:!0,"data-svelte-h":!0}),p(Z)!=="svelte-17g0twj"&&(Z.innerHTML=sa),Jl=i(e),r(S.$$.fragment,e),hl=i(e),w=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-192ix8m"&&(w.innerHTML=ia),Zl=i(e),r(Y.$$.fragment,e),wl=i(e),$=m(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-c2zerw"&&($.innerHTML=na),Ul=i(e),r(N.$$.fragment,e),Tl=i(e),H=m(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-23k6o9"&&(H.textContent=ma),Wl=i(e),r(z.$$.fragment,e),Gl=i(e),U=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-muzf0t"&&(U.innerHTML=pa),jl=i(e),r(E.$$.fragment,e),vl=i(e),q=m(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-x0iv90"&&(q.innerHTML=oa),Il=i(e),r(L.$$.fragment,e),Bl=i(e),T=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-1ki51a7"&&(T.innerHTML=ra),Vl=i(e),r(D.$$.fragment,e),xl=i(e),A=m(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-c3e484"&&(A.textContent=ca),Xl=i(e),P=m(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-tfl439"&&(P.textContent=da),_l=i(e),r(K.$$.fragment,e),kl=i(e),W=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-1tge0cq"&&(W.innerHTML=ga),Fl=i(e),r(O.$$.fragment,e),Ql=i(e),ee=m(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-j0fbzb"&&(ee.textContent=ya),Rl=i(e),r(le.$$.fragment,e),Cl=i(e),te=m(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1bx3wp7"&&(te.innerHTML=ua),Sl=i(e),ae=m(e,"UL",{"data-svelte-h":!0}),p(ae)!=="svelte-1oz5aud"&&(ae.innerHTML=ba),Yl=i(e),se=m(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-wy7ow0"&&(se.innerHTML=Ma),$l=i(e),r(ie.$$.fragment,e),Nl=i(e),G=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-1hvatx7"&&(G.innerHTML=fa),Hl=i(e),r(ne.$$.fragment,e),zl=i(e),me=m(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-mfa26b"&&(me.innerHTML=Ja),El=i(e),pe=m(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1629z5b"&&(pe.innerHTML=ha),ql=i(e),r(oe.$$.fragment,e),Ll=i(e),j=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-k63kz7"&&(j.innerHTML=Za),Dl=i(e),r(re.$$.fragment,e),Al=i(e),ce=m(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1qpoxoh"&&(ce.innerHTML=wa),Pl=i(e),r(de.$$.fragment,e),Kl=i(e),v=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-1fvp45w"&&(v.innerHTML=Ua),Ol=i(e),r(ge.$$.fragment,e),et=i(e),ye=m(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-bxn4p5"&&(ye.textContent=Ta),lt=i(e),r(ue.$$.fragment,e),tt=i(e),be=m(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-xxuxjq"&&(be.textContent=Wa),at=i(e),Me=m(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1edszux"&&(Me.textContent=Ga),st=i(e),r(fe.$$.fragment,e),it=i(e),Je=m(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-3cniud"&&(Je.textContent=ja),nt=i(e),r(he.$$.fragment,e),mt=i(e),r(Ze.$$.fragment,e),pt=i(e),we=m(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1r5hoyw"&&(we.textContent=va),ot=i(e),Ue=m(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-19cg56z"&&(Ue.textContent=Ia),rt=i(e),r(Te.$$.fragment,e),ct=i(e),I=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-1xahv4j"&&(I.innerHTML=Ba),dt=i(e),We=m(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-clpsz0"&&(We.innerHTML=Va),gt=i(e),r(Ge.$$.fragment,e),yt=i(e),je=m(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-w98xng"&&(je.innerHTML=xa),ut=i(e),r(ve.$$.fragment,e),bt=i(e),r(Ie.$$.fragment,e),Mt=i(e),Be=m(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1ojjd40"&&(Be.textContent=Xa),ft=i(e),Ve=m(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-18merz0"&&(Ve.textContent=_a),Jt=i(e),r(xe.$$.fragment,e),ht=i(e),B=m(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-1eyfdjm"&&(B.innerHTML=ka),Zt=i(e),Xe=m(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-cmxlpu"&&(Xe.textContent=Fa),wt=i(e),r(_e.$$.fragment,e),Ut=i(e),ke=m(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-vr292z"&&(ke.textContent=Qa),Tt=i(e),r(Fe.$$.fragment,e),Wt=i(e),r(Qe.$$.fragment,e),Gt=i(e),Re=m(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-14io5mk"&&(Re.innerHTML=Ra),jt=i(e),r(Ce.$$.fragment,e),vt=i(e),Se=m(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-10g432e"&&(Se.innerHTML=Ca),It=i(e),Ye=m(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1q40btg"&&(Ye.innerHTML=Sa),Bt=i(e),r($e.$$.fragment,e),Vt=i(e),r(Ne.$$.fragment,e),xt=i(e),He=m(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1enrnw9"&&(He.textContent=Ya),Xt=i(e),ze=m(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1dqw2pd"&&(ze.textContent=$a),_t=i(e),r(Ee.$$.fragment,e),kt=i(e),qe=m(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-aafidq"&&(qe.innerHTML=Na),Ft=i(e),r(Le.$$.fragment,e),Qt=i(e),De=m(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-kmdmdi"&&(De.textContent=Ha),Rt=i(e),r(Ae.$$.fragment,e),Ct=i(e),V=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-nm98y9"&&(V.innerHTML=za),St=i(e),Pe=m(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-77whwd"&&(Pe.innerHTML=Ea),Yt=i(e),r(Ke.$$.fragment,e),$t=i(e),x=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(x)!=="svelte-9lkq3b"&&(x.innerHTML=qa),Nt=i(e),r(Oe.$$.fragment,e),Ht=i(e),el=m(e,"P",{"data-svelte-h":!0}),p(el)!=="svelte-1vtgt6h"&&(el.innerHTML=La),zt=i(e),r(ll.$$.fragment,e),Et=i(e),tl=m(e,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-hnnorq"&&(tl.innerHTML=Da),qt=i(e),r(al.$$.fragment,e),Lt=i(e),sl=m(e,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-jwocdx"&&(sl.innerHTML=Aa),Dt=i(e),r(il.$$.fragment,e),At=i(e),ml=m(e,"P",{}),Pa(ml).forEach(t),this.h()},h(){M(f,"name","hf:doc:metadata"),M(f,"content",ps),M(J,"class","tip"),M(h,"start","2"),M(Z,"start","3"),M(w,"class","flex gap-4"),M(U,"class","flex gap-4"),M(T,"class","flex gap-4"),M(W,"class","flex gap-4"),M(G,"class","flex flex-row gap-4"),M(j,"class","flex flex-row gap-4"),M(v,"class","flex flex-row gap-4"),M(I,"class","tip"),M(B,"class","tip"),M(V,"class","flex flex-row gap-4"),M(x,"class","flex justify-center")},m(e,l){ss(document.head,f),a(e,pl,l),a(e,nl,l),a(e,ol,l),c(X,e,l),a(e,rl,l),c(_,e,l),a(e,cl,l),a(e,k,l),a(e,dl,l),a(e,F,l),a(e,gl,l),a(e,Q,l),a(e,yl,l),c(R,e,l),a(e,ul,l),a(e,J,l),a(e,bl,l),a(e,h,l),a(e,Ml,l),c(C,e,l),a(e,fl,l),a(e,Z,l),a(e,Jl,l),c(S,e,l),a(e,hl,l),a(e,w,l),a(e,Zl,l),c(Y,e,l),a(e,wl,l),a(e,$,l),a(e,Ul,l),c(N,e,l),a(e,Tl,l),a(e,H,l),a(e,Wl,l),c(z,e,l),a(e,Gl,l),a(e,U,l),a(e,jl,l),c(E,e,l),a(e,vl,l),a(e,q,l),a(e,Il,l),c(L,e,l),a(e,Bl,l),a(e,T,l),a(e,Vl,l),c(D,e,l),a(e,xl,l),a(e,A,l),a(e,Xl,l),a(e,P,l),a(e,_l,l),c(K,e,l),a(e,kl,l),a(e,W,l),a(e,Fl,l),c(O,e,l),a(e,Ql,l),a(e,ee,l),a(e,Rl,l),c(le,e,l),a(e,Cl,l),a(e,te,l),a(e,Sl,l),a(e,ae,l),a(e,Yl,l),a(e,se,l),a(e,$l,l),c(ie,e,l),a(e,Nl,l),a(e,G,l),a(e,Hl,l),c(ne,e,l),a(e,zl,l),a(e,me,l),a(e,El,l),a(e,pe,l),a(e,ql,l),c(oe,e,l),a(e,Ll,l),a(e,j,l),a(e,Dl,l),c(re,e,l),a(e,Al,l),a(e,ce,l),a(e,Pl,l),c(de,e,l),a(e,Kl,l),a(e,v,l),a(e,Ol,l),c(ge,e,l),a(e,et,l),a(e,ye,l),a(e,lt,l),c(ue,e,l),a(e,tt,l),a(e,be,l),a(e,at,l),a(e,Me,l),a(e,st,l),c(fe,e,l),a(e,it,l),a(e,Je,l),a(e,nt,l),c(he,e,l),a(e,mt,l),c(Ze,e,l),a(e,pt,l),a(e,we,l),a(e,ot,l),a(e,Ue,l),a(e,rt,l),c(Te,e,l),a(e,ct,l),a(e,I,l),a(e,dt,l),a(e,We,l),a(e,gt,l),c(Ge,e,l),a(e,yt,l),a(e,je,l),a(e,ut,l),c(ve,e,l),a(e,bt,l),c(Ie,e,l),a(e,Mt,l),a(e,Be,l),a(e,ft,l),a(e,Ve,l),a(e,Jt,l),c(xe,e,l),a(e,ht,l),a(e,B,l),a(e,Zt,l),a(e,Xe,l),a(e,wt,l),c(_e,e,l),a(e,Ut,l),a(e,ke,l),a(e,Tt,l),c(Fe,e,l),a(e,Wt,l),c(Qe,e,l),a(e,Gt,l),a(e,Re,l),a(e,jt,l),c(Ce,e,l),a(e,vt,l),a(e,Se,l),a(e,It,l),a(e,Ye,l),a(e,Bt,l),c($e,e,l),a(e,Vt,l),c(Ne,e,l),a(e,xt,l),a(e,He,l),a(e,Xt,l),a(e,ze,l),a(e,_t,l),c(Ee,e,l),a(e,kt,l),a(e,qe,l),a(e,Ft,l),c(Le,e,l),a(e,Qt,l),a(e,De,l),a(e,Rt,l),c(Ae,e,l),a(e,Ct,l),a(e,V,l),a(e,St,l),a(e,Pe,l),a(e,Yt,l),c(Ke,e,l),a(e,$t,l),a(e,x,l),a(e,Nt,l),c(Oe,e,l),a(e,Ht,l),a(e,el,l),a(e,zt,l),c(ll,e,l),a(e,Et,l),a(e,tl,l),a(e,qt,l),c(al,e,l),a(e,Lt,l),a(e,sl,l),a(e,Dt,l),c(il,e,l),a(e,At,l),a(e,ml,l),Pt=!0},p:Oa,i(e){Pt||(d(X.$$.fragment,e),d(_.$$.fragment,e),d(R.$$.fragment,e),d(C.$$.fragment,e),d(S.$$.fragment,e),d(Y.$$.fragment,e),d(N.$$.fragment,e),d(z.$$.fragment,e),d(E.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(ge.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),d(he.$$.fragment,e),d(Ze.$$.fragment,e),d(Te.$$.fragment,e),d(Ge.$$.fragment,e),d(ve.$$.fragment,e),d(Ie.$$.fragment,e),d(xe.$$.fragment,e),d(_e.$$.fragment,e),d(Fe.$$.fragment,e),d(Qe.$$.fragment,e),d(Ce.$$.fragment,e),d($e.$$.fragment,e),d(Ne.$$.fragment,e),d(Ee.$$.fragment,e),d(Le.$$.fragment,e),d(Ae.$$.fragment,e),d(Ke.$$.fragment,e),d(Oe.$$.fragment,e),d(ll.$$.fragment,e),d(al.$$.fragment,e),d(il.$$.fragment,e),Pt=!0)},o(e){g(X.$$.fragment,e),g(_.$$.fragment,e),g(R.$$.fragment,e),g(C.$$.fragment,e),g(S.$$.fragment,e),g(Y.$$.fragment,e),g(N.$$.fragment,e),g(z.$$.fragment,e),g(E.$$.fragment,e),g(L.$$.fragment,e),g(D.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(le.$$.fragment,e),g(ie.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(de.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(Ze.$$.fragment,e),g(Te.$$.fragment,e),g(Ge.$$.fragment,e),g(ve.$$.fragment,e),g(Ie.$$.fragment,e),g(xe.$$.fragment,e),g(_e.$$.fragment,e),g(Fe.$$.fragment,e),g(Qe.$$.fragment,e),g(Ce.$$.fragment,e),g($e.$$.fragment,e),g(Ne.$$.fragment,e),g(Ee.$$.fragment,e),g(Le.$$.fragment,e),g(Ae.$$.fragment,e),g(Ke.$$.fragment,e),g(Oe.$$.fragment,e),g(ll.$$.fragment,e),g(al.$$.fragment,e),g(il.$$.fragment,e),Pt=!1},d(e){e&&(t(pl),t(nl),t(ol),t(rl),t(cl),t(k),t(dl),t(F),t(gl),t(Q),t(yl),t(ul),t(J),t(bl),t(h),t(Ml),t(fl),t(Z),t(Jl),t(hl),t(w),t(Zl),t(wl),t($),t(Ul),t(Tl),t(H),t(Wl),t(Gl),t(U),t(jl),t(vl),t(q),t(Il),t(Bl),t(T),t(Vl),t(xl),t(A),t(Xl),t(P),t(_l),t(kl),t(W),t(Fl),t(Ql),t(ee),t(Rl),t(Cl),t(te),t(Sl),t(ae),t(Yl),t(se),t($l),t(Nl),t(G),t(Hl),t(zl),t(me),t(El),t(pe),t(ql),t(Ll),t(j),t(Dl),t(Al),t(ce),t(Pl),t(Kl),t(v),t(Ol),t(et),t(ye),t(lt),t(tt),t(be),t(at),t(Me),t(st),t(it),t(Je),t(nt),t(mt),t(pt),t(we),t(ot),t(Ue),t(rt),t(ct),t(I),t(dt),t(We),t(gt),t(yt),t(je),t(ut),t(bt),t(Mt),t(Be),t(ft),t(Ve),t(Jt),t(ht),t(B),t(Zt),t(Xe),t(wt),t(Ut),t(ke),t(Tt),t(Wt),t(Gt),t(Re),t(jt),t(vt),t(Se),t(It),t(Ye),t(Bt),t(Vt),t(xt),t(He),t(Xt),t(ze),t(_t),t(kt),t(qe),t(Ft),t(Qt),t(De),t(Rt),t(Ct),t(V),t(St),t(Pe),t(Yt),t($t),t(x),t(Nt),t(Ht),t(el),t(zt),t(Et),t(tl),t(qt),t(Lt),t(sl),t(Dt),t(At),t(ml)),t(f),y(X,e),y(_,e),y(R,e),y(C,e),y(S,e),y(Y,e),y(N,e),y(z,e),y(E,e),y(L,e),y(D,e),y(K,e),y(O,e),y(le,e),y(ie,e),y(ne,e),y(oe,e),y(re,e),y(de,e),y(ge,e),y(ue,e),y(fe,e),y(he,e),y(Ze,e),y(Te,e),y(Ge,e),y(ve,e),y(Ie,e),y(xe,e),y(_e,e),y(Fe,e),y(Qe,e),y(Ce,e),y($e,e),y(Ne,e),y(Ee,e),y(Le,e),y(Ae,e),y(Ke,e),y(Oe,e),y(ll,e),y(al,e),y(il,e)}}}const ps='{"title":"Image-to-image","local":"image-to-image","sections":[{"title":"Popular models","local":"popular-models","sections":[{"title":"Stable Diffusion v1.5","local":"stable-diffusion-v15","sections":[],"depth":3},{"title":"Stable Diffusion XL (SDXL)","local":"stable-diffusion-xl-sdxl","sections":[],"depth":3},{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[],"depth":3}],"depth":2},{"title":"Configure pipeline parameters","local":"configure-pipeline-parameters","sections":[{"title":"Strength","local":"strength","sections":[],"depth":3},{"title":"Guidance scale","local":"guidance-scale","sections":[],"depth":3},{"title":"Negative prompt","local":"negative-prompt","sections":[],"depth":3}],"depth":2},{"title":"Chained image-to-image pipelines","local":"chained-image-to-image-pipelines","sections":[{"title":"Text-to-image-to-image","local":"text-to-image-to-image","sections":[],"depth":3},{"title":"Image-to-image-to-image","local":"image-to-image-to-image","sections":[],"depth":3},{"title":"Image-to-upscaler-to-super-resolution","local":"image-to-upscaler-to-super-resolution","sections":[],"depth":3}],"depth":2},{"title":"Control image generation","local":"control-image-generation","sections":[{"title":"Prompt weighting","local":"prompt-weighting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3}],"depth":2},{"title":"Optimize","local":"optimize","sections":[],"depth":2}],"depth":1}';function os(Kt){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class us extends ls{constructor(f){super(),ts(this,f,os,ms,Ka,{})}}export{us as component};
