import{s as Fe,o as Ee,n as Ce}from"../chunks/scheduler.888833de.js";import{S as Qe,i as Ne,e as f,s as p,c as h,h as Se,a as g,d as l,b as o,f as Ae,g as J,j as G,k as Q,l as He,m as t,n as w,t as U,o as T,p as Z}from"../chunks/index.128ce987.js";import{C as k}from"../chunks/CodeBlock.37df032e.js";import{H as oe,E as ze}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";import{H as Pe,a as _e}from"../chunks/HfOption.79a0a3f5.js";function qe(E){let r,X,m,I='<p>The <code>pag_applied_layers</code> argument allows you to specify which layers PAG is applied to. Additionally, you can use <code>set_pag_applied_layers</code> method to update these layers after the pipeline has been created. Check out the <a href="#pag_applied_layers">pag_applied_layers</a> section to learn more about applying PAG to other layers.</p>',u,M,c='If you already have a pipeline created and loaded, you can enable PAG on it using the <code>from_pipe</code> API with the <code>enable_pag</code> flag. Internally, a PAG pipeline is created based on the pipeline and task you specified. In the example below, since we used <code>AutoPipelineForText2Image</code> and passed a <code>StableDiffusionXLPipeline</code>, a <code>StableDiffusionXLPAGPipeline</code> is created accordingly. Note that this does not require additional memory, and you will have both <code>StableDiffusionXLPipeline</code> and  <code>StableDiffusionXLPAGPipeline</code> loaded and ready to use. You can read more about the <code>from_pipe</code> API and how to reuse pipelines in diffuser <a href="https://huggingface.co/docs/diffusers/using-diffusers/loading#reuse-a-pipeline" rel="nofollow">here</a>.',d,j,W,y,x="To generate an image, you will also need to pass a <code>pag_scale</code>. When <code>pag_scale</code> increases, images gain more semantically coherent structures and exhibit fewer artifacts. However overly large guidance scale can lead to smoother textures and slight saturation in the images, similarly to CFG. <code>pag_scale=3.0</code> is used in the official demo and works well in most of the use cases, but feel free to experiment and select the appropriate value according to your needs! PAG is disabled when <code>pag_scale=0</code>.",_,B,v,b,Y='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_cfg_7.0_mid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_mid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',s;return r=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHBhZ19hcHBsaWVkX2xheWVycyUzRCU1QiUyMm1pZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=[<span class="hljs-string">&quot;mid&quot;</span>],
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),j=new k({props:{code:"cGlwZWxpbmVfc2R4bCUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3NkeGwlMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_sdxl = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForText2Image.from_pipe(pipeline_sdxl, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),B=new k({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbnNlY3QlMjByb2JvdCUyMHByZXBhcmluZyUyMGElMjBkZWxpY2lvdXMlMjBtZWFsJTJDJTIwYW5pbWUlMjBzdHlsZSUyMiUwQSUwQWZvciUyMHBhZ19zY2FsZSUyMGluJTIwJTVCMC4wJTJDJTIwMy4wJTVEJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ19zY2FsZSUzRHBhZ19zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCkuaW1hZ2Vz",highlighted:`prompt = <span class="hljs-string">&quot;an insect robot preparing a delicious meal, anime style&quot;</span>

<span class="hljs-keyword">for</span> pag_scale <span class="hljs-keyword">in</span> [<span class="hljs-number">0.0</span>, <span class="hljs-number">3.0</span>]:
    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
    images = pipeline(
        prompt=prompt,
        num_inference_steps=<span class="hljs-number">25</span>,
        guidance_scale=<span class="hljs-number">7.0</span>,
        generator=generator,
        pag_scale=pag_scale,
    ).images`,wrap:!1}}),{c(){h(r.$$.fragment),X=p(),m=f("blockquote"),m.innerHTML=I,u=p(),M=f("p"),M.innerHTML=c,d=p(),h(j.$$.fragment),W=p(),y=f("p"),y.innerHTML=x,_=p(),h(B.$$.fragment),v=p(),b=f("div"),b.innerHTML=Y,this.h()},l(a){J(r.$$.fragment,a),X=o(a),m=g(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),G(m)!=="svelte-1qub4u5"&&(m.innerHTML=I),u=o(a),M=g(a,"P",{"data-svelte-h":!0}),G(M)!=="svelte-ggenwh"&&(M.innerHTML=c),d=o(a),J(j.$$.fragment,a),W=o(a),y=g(a,"P",{"data-svelte-h":!0}),G(y)!=="svelte-43v4ib"&&(y.innerHTML=x),_=o(a),J(B.$$.fragment,a),v=o(a),b=g(a,"DIV",{class:!0,"data-svelte-h":!0}),G(b)!=="svelte-1ebso2i"&&(b.innerHTML=Y),this.h()},h(){Q(m,"class","tip"),Q(b,"class","flex flex-row gap-4")},m(a,$){w(r,a,$),t(a,X,$),t(a,m,$),t(a,u,$),t(a,M,$),t(a,d,$),w(j,a,$),t(a,W,$),t(a,y,$),t(a,_,$),w(B,a,$),t(a,v,$),t(a,b,$),s=!0},p:Ce,i(a){s||(U(r.$$.fragment,a),U(j.$$.fragment,a),U(B.$$.fragment,a),s=!0)},o(a){T(r.$$.fragment,a),T(j.$$.fragment,a),T(B.$$.fragment,a),s=!1},d(a){a&&(l(X),l(m),l(u),l(M),l(d),l(W),l(y),l(_),l(v),l(b)),Z(r,a),Z(j,a),Z(B,a)}}}function Le(E){let r,X="You can use PAG with image-to-image pipelines.",m,I,u,M,c="If you already have a image-to-image pipeline and would like enable PAG on it, you can run this",d,j,W,y,x="It is also very easy to directly switch from a text-to-image pipeline to PAG enabled image-to-image pipeline",_,B,v,b,Y="If you have a PAG enabled text-to-image pipeline, you can directly switch to a image-to-image pipeline with PAG still enabled",s,a,$,V,P="Now let’s generate an image!",R,A,F;return I=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuYWJsZV9wYWclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTVCJTIybWlkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=[<span class="hljs-string">&quot;mid&quot;</span>],
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),j=new k({props:{code:"cGlwZWxpbmVfdDJpJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90MmklMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_t2i = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),B=new k({props:{code:"cGlwZWxpbmVfcGFnJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9waXBlKHBpcGVsaW5lX3QyaSUyQyUyMGVuYWJsZV9wYWclM0RUcnVlKQ==",highlighted:`pipeline_pag = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),a=new k({props:{code:"cGlwZWxpbmVfcGFnJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwZW5hYmxlX3BhZyUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3BpcGUocGlwZWxpbmVfdDJpKQ==",highlighted:`pipeline_pag = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, enable_pag=<span class="hljs-literal">True</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_t2i)`,wrap:!1}}),A=new k({props:{code:"cGFnX3NjYWxlcyUyMCUzRCUyMCUyMDQuMCUwQWd1aWRhbmNlX3NjYWxlcyUyMCUzRCUyMDcuMCUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtdGV4dDJpbWcucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBjYXRjaGluZyUyMGElMjBmcmlzYmVlJTIwaW4lMjB0aGUlMjBqdW5nbGUlMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjglMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRGd1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX3NjYWxlJTNEcGFnX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVE",highlighted:`pag_scales =  <span class="hljs-number">4.0</span>
guidance_scales = <span class="hljs-number">7.0</span>

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
init_image = load_image(url)
prompt = <span class="hljs-string">&quot;a dog catching a frisbee in the jungle&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(
    prompt,
    image=init_image,
    strength=<span class="hljs-number">0.8</span>,
    guidance_scale=guidance_scale,
    pag_scale=pag_scale,
    generator=generator).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=f("p"),r.textContent=X,m=p(),h(I.$$.fragment),u=p(),M=f("p"),M.textContent=c,d=p(),h(j.$$.fragment),W=p(),y=f("p"),y.textContent=x,_=p(),h(B.$$.fragment),v=p(),b=f("p"),b.textContent=Y,s=p(),h(a.$$.fragment),$=p(),V=f("p"),V.textContent=P,R=p(),h(A.$$.fragment)},l(i){r=g(i,"P",{"data-svelte-h":!0}),G(r)!=="svelte-1xi6cwa"&&(r.textContent=X),m=o(i),J(I.$$.fragment,i),u=o(i),M=g(i,"P",{"data-svelte-h":!0}),G(M)!=="svelte-d1pkk8"&&(M.textContent=c),d=o(i),J(j.$$.fragment,i),W=o(i),y=g(i,"P",{"data-svelte-h":!0}),G(y)!=="svelte-11p19k6"&&(y.textContent=x),_=o(i),J(B.$$.fragment,i),v=o(i),b=g(i,"P",{"data-svelte-h":!0}),G(b)!=="svelte-nytx5w"&&(b.textContent=Y),s=o(i),J(a.$$.fragment,i),$=o(i),V=g(i,"P",{"data-svelte-h":!0}),G(V)!=="svelte-3irrs3"&&(V.textContent=P),R=o(i),J(A.$$.fragment,i)},m(i,C){t(i,r,C),t(i,m,C),w(I,i,C),t(i,u,C),t(i,M,C),t(i,d,C),w(j,i,C),t(i,W,C),t(i,y,C),t(i,_,C),w(B,i,C),t(i,v,C),t(i,b,C),t(i,s,C),w(a,i,C),t(i,$,C),t(i,V,C),t(i,R,C),w(A,i,C),F=!0},p:Ce,i(i){F||(U(I.$$.fragment,i),U(j.$$.fragment,i),U(B.$$.fragment,i),U(a.$$.fragment,i),U(A.$$.fragment,i),F=!0)},o(i){T(I.$$.fragment,i),T(j.$$.fragment,i),T(B.$$.fragment,i),T(a.$$.fragment,i),T(A.$$.fragment,i),F=!1},d(i){i&&(l(r),l(m),l(u),l(M),l(d),l(W),l(y),l(_),l(v),l(b),l(s),l($),l(V),l(R)),Z(I,i),Z(j,i),Z(B,i),Z(a,i),Z(A,i)}}}function De(E){let r,X,m,I="You can enable PAG on an existing inpainting pipeline like this",u,M,c,d,j="This still works when your pipeline has a different task:",W,y,x,_,B="Let’s generate an image!",v,b,Y;return r=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfcGFnJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    enable_pag=<span class="hljs-literal">True</span>,
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),M=new k({props:{code:"cGlwZWxpbmVfaW5wYWludCUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9waXBlKHBpcGVsaW5lX2lucGFpbnQlMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_inpaint = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForInpainting.from_pipe(pipeline_inpaint, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),y=new k({props:{code:"cGlwZWxpbmVfdDJpJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW5wYWl0aW5nLmZyb21fcGlwZShwaXBlbGluZV90MmklMkMlMjBlbmFibGVfcGFnJTNEVHJ1ZSk=",highlighted:`pipeline_t2i = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16)
pipeline = AutoPipelineForInpaiting.from_pipe(pipeline_t2i, enable_pag=<span class="hljs-literal">True</span>)`,wrap:!1}}),b=new k({props:{code:"aW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwdGlnZXIlMjBzaXR0aW5nJTIwb24lMjBhJTIwYmVuY2glMjIlMEElMEFwYWdfc2NhbGVzJTIwJTNEJTIwJTIwMy4wJTBBZ3VpZGFuY2Vfc2NhbGVzJTIwJTNEJTIwNy41JTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMSklMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHN0cmVuZ3RoJTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMHBhZ19zY2FsZSUzRHBhZ19zY2FsZSUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>

pag_scales =  <span class="hljs-number">3.0</span>
guidance_scales = <span class="hljs-number">7.5</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
images = pipeline(
    prompt=prompt,
    image=init_image,
    mask_image=mask_image,
    strength=<span class="hljs-number">0.8</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=guidance_scale,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){h(r.$$.fragment),X=p(),m=f("p"),m.textContent=I,u=p(),h(M.$$.fragment),c=p(),d=f("p"),d.textContent=j,W=p(),h(y.$$.fragment),x=p(),_=f("p"),_.textContent=B,v=p(),h(b.$$.fragment)},l(s){J(r.$$.fragment,s),X=o(s),m=g(s,"P",{"data-svelte-h":!0}),G(m)!=="svelte-azr2az"&&(m.textContent=I),u=o(s),J(M.$$.fragment,s),c=o(s),d=g(s,"P",{"data-svelte-h":!0}),G(d)!=="svelte-1e8wg3g"&&(d.textContent=j),W=o(s),J(y.$$.fragment,s),x=o(s),_=g(s,"P",{"data-svelte-h":!0}),G(_)!=="svelte-1yhhruz"&&(_.textContent=B),v=o(s),J(b.$$.fragment,s)},m(s,a){w(r,s,a),t(s,X,a),t(s,m,a),t(s,u,a),w(M,s,a),t(s,c,a),t(s,d,a),t(s,W,a),w(y,s,a),t(s,x,a),t(s,_,a),t(s,v,a),w(b,s,a),Y=!0},p:Ce,i(s){Y||(U(r.$$.fragment,s),U(M.$$.fragment,s),U(y.$$.fragment,s),U(b.$$.fragment,s),Y=!0)},o(s){T(r.$$.fragment,s),T(M.$$.fragment,s),T(y.$$.fragment,s),T(b.$$.fragment,s),Y=!1},d(s){s&&(l(X),l(m),l(u),l(c),l(d),l(W),l(x),l(_),l(v)),Z(r,s),Z(M,s),Z(y,s),Z(b,s)}}}function Ke(E){let r,X,m,I,u,M;return r=new _e({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[qe]},$$scope:{ctx:E}}}),m=new _e({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[Le]},$$scope:{ctx:E}}}),u=new _e({props:{id:"tasks",option:"Inpainting",$$slots:{default:[De]},$$scope:{ctx:E}}}),{c(){h(r.$$.fragment),X=p(),h(m.$$.fragment),I=p(),h(u.$$.fragment)},l(c){J(r.$$.fragment,c),X=o(c),J(m.$$.fragment,c),I=o(c),J(u.$$.fragment,c)},m(c,d){w(r,c,d),t(c,X,d),w(m,c,d),t(c,I,d),w(u,c,d),M=!0},p(c,d){const j={};d&2&&(j.$$scope={dirty:d,ctx:c}),r.$set(j);const W={};d&2&&(W.$$scope={dirty:d,ctx:c}),m.$set(W);const y={};d&2&&(y.$$scope={dirty:d,ctx:c}),u.$set(y)},i(c){M||(U(r.$$.fragment,c),U(m.$$.fragment,c),U(u.$$.fragment,c),M=!0)},o(c){T(r.$$.fragment,c),T(m.$$.fragment,c),T(u.$$.fragment,c),M=!1},d(c){c&&(l(X),l(I)),Z(r,c),Z(m,c),Z(u,c)}}}function Oe(E){let r,X,m,I,u,M,c,d='<a href="https://ku-cvlab.github.io/Perturbed-Attention-Guidance/" rel="nofollow">Perturbed-Attention Guidance (PAG)</a> is a new diffusion sampling guidance that improves sample quality across both unconditional and conditional settings, achieving this without requiring further training or the integration of external modules. PAG is designed to progressively enhance the structure of synthesized samples throughout the denoising process by considering the self-attention mechanisms’ ability to capture structural information. It involves generating intermediate samples with degraded structure by substituting selected self-attention maps in diffusion U-Net with an identity matrix, and guiding the denoising process away from these degraded samples.',j,W,y="This guide will show you how to use PAG for various tasks and use cases.",x,_,B,v,b='You can apply PAG to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks such as text-to-image, image-to-image, and inpainting. To enable PAG for a specific task, load the pipeline using the <a href="../api/pipelines/auto_pipeline">AutoPipeline</a> API with the <code>enable_pag=True</code> flag and the <code>pag_applied_layers</code> argument.',Y,s,a='<p>🤗 Diffusers currently only supports using PAG with selected SDXL pipelines and <a href="/docs/diffusers/main/en/api/pipelines/pag#diffusers.PixArtSigmaPAGPipeline">PixArtSigmaPAGPipeline</a>. But feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> if you want to add PAG support to a new pipeline!</p>',$,V,P,R,A,F,i="To use PAG with ControlNet, first create a <code>controlnet</code>. Then, pass the <code>controlnet</code> and other PAG arguments to the <code>from_pretrained</code> method of the AutoPipeline for the specified task.",C,q,re,N,Ie="<p>If you already have a controlnet pipeline and want to enable PAG, you can use the <code>from_pipe</code> API: <code>AutoPipelineForText2Image.from_pipe(pipeline_controlnet, enable_pag=True)</code></p>",me,L,Be="You can use the pipeline in the same way you normally use ControlNet pipelines, with the added option to specify a <code>pag_scale</code> parameter. Note that PAG works well for unconditional generation. In this example, we will generate an image without a prompt.",Me,D,de,S,$e='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_controlnet.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',ue,K,ye,O,Xe='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is a popular model that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. You can enable PAG on a pipeline with IP-Adapter loaded.',fe,ee,ge,le,ve="PAG reduces artifacts and improves the overall compposition.",be,H,Ve='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_0.0_ipa_0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image without PAG</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_5.0_ipa_0.8.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image with PAG</figcaption></div>',he,te,Je,ae,we,se,ke="The <code>pag_applied_layers</code> argument allows you to specify which layers PAG is applied to. By default, it applies only to the mid blocks. Changing this setting will significantly impact the output. You can use the <code>set_pag_applied_layers</code> method to adjust the PAG layers after the pipeline is created, helping you find the optimal layers for your model.",Ue,ne,xe="As an example, here is the images generated with <code>pag_layers = [&quot;down.block_2&quot;]</code> and <code>pag_layers = [&quot;down.block_2&quot;, &quot;up.block_1.attentions_0&quot;]</code>",Te,ie,Ze,z,Ye='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_down2_up1a0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">down.block_2 + up.block1.attentions_0</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_3.0_cfg_7.0_down2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">down.block_2</figcaption></div>',je,pe,Ge,ce,We;return u=new oe({props:{title:"Perturbed-Attention Guidance",local:"perturbed-attention-guidance",headingTag:"h1"}}),_=new oe({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),V=new Pe({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting"],$$slots:{default:[Ke]},$$scope:{ctx:E}}}),R=new oe({props:{title:"PAG with ControlNet",local:"pag-with-controlnet",headingTag:"h2"}}),q=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBDb250cm9sTmV0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyRmNvbnRyb2xuZXQtY2Fubnktc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMGVuYWJsZV9wYWclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGFnX2FwcGxpZWRfbGF5ZXJzJTNEJTIybWlkJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, ControlNetModel
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    enable_pag=<span class="hljs-literal">True</span>,
    pag_applied_layers=<span class="hljs-string">&quot;mid&quot;</span>,
    torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),D=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFjYW5ueV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBhZ19jb250cm9sX2lucHV0LnBuZyUyMiUwQSklMEElMEFmb3IlMjBwYWdfc2NhbGUlMjBpbiUyMCU1QjAuMCUyQyUyMDMuMCU1RCUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDEpJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0Rjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWdfc2NhbGUlM0RwYWdfc2NhbGUlMkMlMEElMjAlMjAlMjAlMjApLmltYWdlcyUwQSUyMCUyMCUyMCUyMGltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
canny_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/pag_control_input.png&quot;</span>
)

<span class="hljs-keyword">for</span> pag_scale <span class="hljs-keyword">in</span> [<span class="hljs-number">0.0</span>, <span class="hljs-number">3.0</span>]:
    generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
    images = pipeline(
        prompt=<span class="hljs-string">&quot;&quot;</span>,
        controlnet_conditioning_scale=controlnet_conditioning_scale,
        image=canny_image,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">0</span>,
        generator=generator,
        pag_scale=pag_scale,
    ).images
    images[<span class="hljs-number">0</span>]`,wrap:!1}}),K=new oe({props:{title:"PAG with IP-Adapter",local:"pag-with-ip-adapter",headingTag:"h2"}}),ee=new k({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">import</span> torch

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    image_encoder=image_encoder,
    enable_pag=<span class="hljs-literal">True</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.bin&quot;</span>)

pag_scales = <span class="hljs-number">5.0</span>
ip_adapter_scales = <span class="hljs-number">0.8</span>

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)

pipeline.set_ip_adapter_scale(ip_adapter_scale)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    guidance_scale=<span class="hljs-number">3.0</span>,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]
`,wrap:!1}}),te=new oe({props:{title:"Configure parameters",local:"configure-parameters",headingTag:"h2"}}),ae=new oe({props:{title:"pag_applied_layers",local:"pagappliedlayers",headingTag:"h3"}}),ie=new k({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbnNlY3QlMjByb2JvdCUyMHByZXBhcmluZyUyMGElMjBkZWxpY2lvdXMlMjBtZWFsJTJDJTIwYW5pbWUlMjBzdHlsZSUyMiUwQXBpcGVsaW5lLnNldF9wYWdfYXBwbGllZF9sYXllcnMocGFnX2xheWVycyklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEZ3VpZGFuY2Vfc2NhbGUlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBwYWdfc2NhbGUlM0RwYWdfc2NhbGUlMkMlMEEpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQ=",highlighted:`prompt = <span class="hljs-string">&quot;an insect robot preparing a delicious meal, anime style&quot;</span>
pipeline.set_pag_applied_layers(pag_layers)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">25</span>,
    guidance_scale=guidance_scale,
    generator=generator,
    pag_scale=pag_scale,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),pe=new ze({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/pag.md"}}),{c(){r=f("meta"),X=p(),m=f("p"),I=p(),h(u.$$.fragment),M=p(),c=f("p"),c.innerHTML=d,j=p(),W=f("p"),W.textContent=y,x=p(),h(_.$$.fragment),B=p(),v=f("p"),v.innerHTML=b,Y=p(),s=f("blockquote"),s.innerHTML=a,$=p(),h(V.$$.fragment),P=p(),h(R.$$.fragment),A=p(),F=f("p"),F.innerHTML=i,C=p(),h(q.$$.fragment),re=p(),N=f("blockquote"),N.innerHTML=Ie,me=p(),L=f("p"),L.innerHTML=Be,Me=p(),h(D.$$.fragment),de=p(),S=f("div"),S.innerHTML=$e,ue=p(),h(K.$$.fragment),ye=p(),O=f("p"),O.innerHTML=Xe,fe=p(),h(ee.$$.fragment),ge=p(),le=f("p"),le.textContent=ve,be=p(),H=f("div"),H.innerHTML=Ve,he=p(),h(te.$$.fragment),Je=p(),h(ae.$$.fragment),we=p(),se=f("p"),se.innerHTML=ke,Ue=p(),ne=f("p"),ne.innerHTML=xe,Te=p(),h(ie.$$.fragment),Ze=p(),z=f("div"),z.innerHTML=Ye,je=p(),h(pe.$$.fragment),Ge=p(),ce=f("p"),this.h()},l(e){const n=Se("svelte-u9bgzb",document.head);r=g(n,"META",{name:!0,content:!0}),n.forEach(l),X=o(e),m=g(e,"P",{}),Ae(m).forEach(l),I=o(e),J(u.$$.fragment,e),M=o(e),c=g(e,"P",{"data-svelte-h":!0}),G(c)!=="svelte-1w1c4u2"&&(c.innerHTML=d),j=o(e),W=g(e,"P",{"data-svelte-h":!0}),G(W)!=="svelte-11cdpcr"&&(W.textContent=y),x=o(e),J(_.$$.fragment,e),B=o(e),v=g(e,"P",{"data-svelte-h":!0}),G(v)!=="svelte-dt4tyz"&&(v.innerHTML=b),Y=o(e),s=g(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),G(s)!=="svelte-7eizy1"&&(s.innerHTML=a),$=o(e),J(V.$$.fragment,e),P=o(e),J(R.$$.fragment,e),A=o(e),F=g(e,"P",{"data-svelte-h":!0}),G(F)!=="svelte-4m1dma"&&(F.innerHTML=i),C=o(e),J(q.$$.fragment,e),re=o(e),N=g(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),G(N)!=="svelte-1s4f2l1"&&(N.innerHTML=Ie),me=o(e),L=g(e,"P",{"data-svelte-h":!0}),G(L)!=="svelte-112ukzn"&&(L.innerHTML=Be),Me=o(e),J(D.$$.fragment,e),de=o(e),S=g(e,"DIV",{class:!0,"data-svelte-h":!0}),G(S)!=="svelte-e2cxkg"&&(S.innerHTML=$e),ue=o(e),J(K.$$.fragment,e),ye=o(e),O=g(e,"P",{"data-svelte-h":!0}),G(O)!=="svelte-rjcwxp"&&(O.innerHTML=Xe),fe=o(e),J(ee.$$.fragment,e),ge=o(e),le=g(e,"P",{"data-svelte-h":!0}),G(le)!=="svelte-1n1gw76"&&(le.textContent=ve),be=o(e),H=g(e,"DIV",{class:!0,"data-svelte-h":!0}),G(H)!=="svelte-j0lguw"&&(H.innerHTML=Ve),he=o(e),J(te.$$.fragment,e),Je=o(e),J(ae.$$.fragment,e),we=o(e),se=g(e,"P",{"data-svelte-h":!0}),G(se)!=="svelte-1th38n0"&&(se.innerHTML=ke),Ue=o(e),ne=g(e,"P",{"data-svelte-h":!0}),G(ne)!=="svelte-1d06cik"&&(ne.innerHTML=xe),Te=o(e),J(ie.$$.fragment,e),Ze=o(e),z=g(e,"DIV",{class:!0,"data-svelte-h":!0}),G(z)!=="svelte-1srsjub"&&(z.innerHTML=Ye),je=o(e),J(pe.$$.fragment,e),Ge=o(e),ce=g(e,"P",{}),Ae(ce).forEach(l),this.h()},h(){Q(r,"name","hf:doc:metadata"),Q(r,"content",el),Q(s,"class","tip"),Q(N,"class","tip"),Q(S,"class","flex flex-row gap-4"),Q(H,"class","flex flex-row gap-4"),Q(z,"class","flex flex-row gap-4")},m(e,n){He(document.head,r),t(e,X,n),t(e,m,n),t(e,I,n),w(u,e,n),t(e,M,n),t(e,c,n),t(e,j,n),t(e,W,n),t(e,x,n),w(_,e,n),t(e,B,n),t(e,v,n),t(e,Y,n),t(e,s,n),t(e,$,n),w(V,e,n),t(e,P,n),w(R,e,n),t(e,A,n),t(e,F,n),t(e,C,n),w(q,e,n),t(e,re,n),t(e,N,n),t(e,me,n),t(e,L,n),t(e,Me,n),w(D,e,n),t(e,de,n),t(e,S,n),t(e,ue,n),w(K,e,n),t(e,ye,n),t(e,O,n),t(e,fe,n),w(ee,e,n),t(e,ge,n),t(e,le,n),t(e,be,n),t(e,H,n),t(e,he,n),w(te,e,n),t(e,Je,n),w(ae,e,n),t(e,we,n),t(e,se,n),t(e,Ue,n),t(e,ne,n),t(e,Te,n),w(ie,e,n),t(e,Ze,n),t(e,z,n),t(e,je,n),w(pe,e,n),t(e,Ge,n),t(e,ce,n),We=!0},p(e,[n]){const Re={};n&2&&(Re.$$scope={dirty:n,ctx:e}),V.$set(Re)},i(e){We||(U(u.$$.fragment,e),U(_.$$.fragment,e),U(V.$$.fragment,e),U(R.$$.fragment,e),U(q.$$.fragment,e),U(D.$$.fragment,e),U(K.$$.fragment,e),U(ee.$$.fragment,e),U(te.$$.fragment,e),U(ae.$$.fragment,e),U(ie.$$.fragment,e),U(pe.$$.fragment,e),We=!0)},o(e){T(u.$$.fragment,e),T(_.$$.fragment,e),T(V.$$.fragment,e),T(R.$$.fragment,e),T(q.$$.fragment,e),T(D.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(te.$$.fragment,e),T(ae.$$.fragment,e),T(ie.$$.fragment,e),T(pe.$$.fragment,e),We=!1},d(e){e&&(l(X),l(m),l(I),l(M),l(c),l(j),l(W),l(x),l(B),l(v),l(Y),l(s),l($),l(P),l(A),l(F),l(C),l(re),l(N),l(me),l(L),l(Me),l(de),l(S),l(ue),l(ye),l(O),l(fe),l(ge),l(le),l(be),l(H),l(he),l(Je),l(we),l(se),l(Ue),l(ne),l(Te),l(Ze),l(z),l(je),l(Ge),l(ce)),l(r),Z(u,e),Z(_,e),Z(V,e),Z(R,e),Z(q,e),Z(D,e),Z(K,e),Z(ee,e),Z(te,e),Z(ae,e),Z(ie,e),Z(pe,e)}}}const el='{"title":"Perturbed-Attention Guidance","local":"perturbed-attention-guidance","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"PAG with ControlNet","local":"pag-with-controlnet","sections":[],"depth":2},{"title":"PAG with IP-Adapter","local":"pag-with-ip-adapter","sections":[],"depth":2},{"title":"Configure parameters","local":"configure-parameters","sections":[{"title":"pag_applied_layers","local":"pagappliedlayers","sections":[],"depth":3}],"depth":2}],"depth":1}';function ll(E){return Ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pl extends Qe{constructor(r){super(),Ne(this,r,ll,Oe,Fe,{})}}export{pl as component};
