import{s as Ws,n as Gs,o as Is}from"../chunks/scheduler.888833de.js";import{S as vs,i as _s,e as n,s as a,c as r,h as Bs,a as o,d as l,b as i,f as _l,g as m,j as p,k as y,l as Bl,m as s,n as d,t as f,o as c,p as u}from"../chunks/index.128ce987.js";import{C as M}from"../chunks/CodeBlock.37df032e.js";import{D as ks}from"../chunks/DocNotebookDropdown.cbea0b77.js";import{H as b,E as Xs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function xs(kl){let h,Pe,De,Ke,X,Oe,x,et,C,Xl='<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> (SDXL) is a powerful text-to-image generation model that iterates on the previous Stable Diffusion models in three key ways:',tt,R,xl="<li>the UNet is 3x larger and SDXL combines a second text encoder (OpenCLIP ViT-bigG/14) with the original text encoder to significantly increase the number of parameters</li> <li>introduces size and crop-conditioning to preserve training data from being discarded and gain more control over how a generated image should be cropped</li> <li>introduces a two-stage model process; the <em>base</em> model (can also be run as a standalone model) generates an image as an input to the <em>refiner</em> model which adds additional high-quality details</li>",lt,$,Cl="This guide will show you how to use SDXL for text-to-image, image-to-image, and inpainting.",st,V,Rl="Before you begin, make sure you have the following libraries installed:",at,Y,it,g,qe,$l='We recommend installing the <a href="https://pypi.org/project/invisible-watermark/" rel="nofollow">invisible-watermark</a> library to help identify images that are generated. If the invisible-watermark library is installed, it is used by default. To disable the watermarker:',vl,S,nt,E,ot,N,Vl='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method:',pt,Q,rt,F,Yl='You can also use the <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> method to load a model checkpoint stored in a single file format (<code>.ckpt</code> or <code>.safetensors</code>) from the Hub or locally:',mt,L,dt,H,ft,z,Sl="For text-to-image, pass a text prompt. By default, SDXL generates a 1024x1024 image for the best results. You can try setting the <code>height</code> and <code>width</code> parameters to 768x768 or 512x512, but anything below 512x512 is not likely to work.",ct,q,ut,J,El='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="generated image of an astronaut in a jungle"/>',Mt,D,yt,A,Nl="For image-to-image, SDXL works especially well with image sizes between 768x768 and 1024x1024. Pass an initial image, and a text prompt to condition the image with:",bt,P,ht,T,Ql='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-img2img.png" alt="generated image of a dog catching a frisbee in a jungle"/>',gt,K,Jt,O,Fl="For inpainting, you’ll need the original image and a mask of what you want to replace in the original image. Create a prompt to describe what you want to replace the masked area with.",Tt,ee,wt,w,Ll='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint.png" alt="generated image of a deep sea diver in a jungle"/>',Zt,te,Ut,le,Hl='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> specialized in denoising low-noise stage images to generate higher-quality images from the base model. There are two ways to use the refiner:',jt,se,zl="<li>use the base and refiner models together to produce a refined image</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image (this is how SDXL was originally trained)</li>",Wt,ae,Gt,ie,ql='When you use the base and refiner model together to generate an image, this is known as an <a href="https://research.nvidia.com/labs/dir/eDiff-I/" rel="nofollow"><em>ensemble of expert denoisers</em></a>. The ensemble of expert denoisers approach requires fewer overall denoising steps versus passing the base model’s output to the refiner model, so it should be significantly faster to run. However, you won’t be able to inspect the base model’s output because it still contains a large amount of noise.',It,ne,Dl="As an ensemble of expert denoisers, the base model serves as the expert during the high-noise diffusion stage and the refiner model serves as the expert during the low-noise diffusion stage. Load the base and refiner model:",vt,oe,_t,pe,Al='To use this approach, you need to define the number of timesteps for each model to run through their respective stages. For the base model, this is controlled by the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline.__call__.denoising_end" rel="nofollow"><code>denoising_end</code></a> parameter and for the refiner model, it is controlled by the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline.__call__.denoising_start" rel="nofollow"><code>denoising_start</code></a> parameter.',Bt,Z,Pl="<p>The <code>denoising_end</code> and <code>denoising_start</code> parameters should be a float between 0 and 1. These parameters are represented as a proportion of discrete timesteps as defined by the scheduler. If you’re also using the <code>strength</code> parameter, it’ll be ignored because the number of denoising steps is determined by the discrete timesteps the model is trained on and the declared fractional cutoff.</p>",kt,re,Kl="Let’s set <code>denoising_end=0.8</code> so the base model performs the first 80% of denoising the <strong>high-noise</strong> timesteps and set <code>denoising_start=0.8</code> so the refiner model performs the last 20% of denoising the <strong>low-noise</strong> timesteps. The base model output should be in <strong>latent</strong> space instead of a PIL image.",Xt,me,xt,U,Ol='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lion_base.png" alt="generated image of a lion on a rock at night"/> <figcaption class="mt-2 text-center text-sm text-gray-500">default base model</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lion_refined.png" alt="generated image of a lion on a rock at night in higher quality"/> <figcaption class="mt-2 text-center text-sm text-gray-500">ensemble of expert denoisers</figcaption></div>',Ct,de,es='The refiner model can also be used for inpainting in the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline">StableDiffusionXLInpaintPipeline</a>:',Rt,fe,$t,ce,ts="This ensemble of expert denoisers method works well for all available schedulers!",Vt,ue,Yt,Me,ls="SDXL gets a boost in image quality by using the refiner model to add additional high-quality details to the fully-denoised image from the base model, in an image-to-image setting.",St,ye,ss="Load the base and refiner models:",Et,be,Nt,j,as='<p>You can use SDXL refiner with a different base model. For example, you can use the <a href="../../api/pipelines/hunyuandit">Hunyuan-DiT</a> or <a href="../../api/pipelines/pixart_sigma">PixArt-Sigma</a> pipelines to generate images with better prompt adherence. Once you have generated an image, you can pass it to the SDXL refiner model to enhance final generation quality.</p>',Qt,he,is="Generate an image from the base model, and set the model output to <strong>latent</strong> space:",Ft,ge,Lt,Je,ns="Pass the generated image to the refiner model:",Ht,Te,zt,W,os='<div><img class="rounded-xl" src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/sd_xl/init_image.png" alt="generated image of an astronaut riding a green horse on Mars"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base model</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/sd_xl/refined_image.png" alt="higher quality generated image of an astronaut riding a green horse on Mars"/> <figcaption class="mt-2 text-center text-sm text-gray-500">base model + refiner model</figcaption></div>',qt,we,ps='For inpainting, load the base and the refiner model in the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline">StableDiffusionXLInpaintPipeline</a>, remove the <code>denoising_end</code> and <code>denoising_start</code> parameters, and choose a smaller number of inference steps for the refiner.',Dt,Ze,At,Ue,rs="SDXL training involves several additional conditioning techniques, which are referred to as <em>micro-conditioning</em>. These include original image size, target image size, and cropping parameters. The micro-conditionings can be used at inference time to create high-quality, centered images.",Pt,G,ms='<p>You can use both micro-conditioning and negative micro-conditioning parameters thanks to classifier-free guidance. They are available in the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline">StableDiffusionXLImg2ImgPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLInpaintPipeline">StableDiffusionXLInpaintPipeline</a>, and <a href="/docs/diffusers/main/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>.</p>',Kt,je,Ot,We,ds="There are two types of size conditioning:",el,Ge,fs='<li><p><a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline.__call__.original_size" rel="nofollow"><code>original_size</code></a> conditioning comes from upscaled images in the training batch (because it would be wasteful to discard the smaller images which make up almost 40% of the total training data). This way, SDXL learns that upscaling artifacts are not supposed to be present in high-resolution images. During inference, you can use <code>original_size</code> to indicate the original image resolution. Using the default value of <code>(1024, 1024)</code> produces higher-quality images that resemble the 1024x1024 images in the dataset. If you choose to use a lower resolution, such as <code>(256, 256)</code>, the model still generates 1024x1024 images, but they’ll look like the low resolution images (simpler patterns, blurring) in the dataset.</p></li> <li><p><a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline.__call__.target_size" rel="nofollow"><code>target_size</code></a> conditioning comes from finetuning SDXL to support different image aspect ratios. During inference, if you use the default value of <code>(1024, 1024)</code>, you’ll get an image that resembles the composition of square images in the dataset. We recommend using the same value for <code>target_size</code> and <code>original_size</code>, but feel free to experiment with other options!</p></li>',tl,Ie,cs="🤗 Diffusers also lets you specify negative conditions about an image’s size to steer generation away from certain image resolutions:",ll,ve,sl,I,us='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/sd_xl/negative_conditions.png"/> <figcaption class="text-center">Images negatively conditioned on image resolutions of (128, 128), (256, 256), and (512, 512).</figcaption>',al,_e,il,Be,Ms="Images generated by previous Stable Diffusion models may sometimes appear to be cropped. This is because images are actually cropped during training so that all the images in a batch have the same size. By conditioning on crop coordinates, SDXL <em>learns</em> that no cropping - coordinates <code>(0, 0)</code> - usually correlates with centered subjects and complete faces (this is the default value in 🤗 Diffusers). You can experiment with different coordinates if you want to generate off-centered compositions!",nl,ke,ol,v,ys='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-cropped.png" alt="generated image of an astronaut in a jungle, slightly cropped"/>',pl,Xe,bs="You can also specify negative cropping coordinates to steer generation away from certain cropping parameters:",rl,xe,ml,Ce,dl,Re,hs='SDXL uses two text-encoders, so it is possible to pass a different prompt to each text-encoder, which can <a href="https://github.com/huggingface/diffusers/issues/4004#issuecomment-1627764201" rel="nofollow">improve quality</a>. Pass your original prompt to <code>prompt</code> and the second prompt to <code>prompt_2</code> (use <code>negative_prompt</code> and <code>negative_prompt_2</code> if you’re using negative prompts):',fl,$e,cl,_,gs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-double-prompt.png" alt="generated image of an astronaut in a jungle in the style of a van gogh painting"/>',ul,Ve,Js='The dual text-encoders also support textual inversion embeddings that need to be loaded separately as explained in the <a href="textual_inversion_inference#stable-diffusion-xl">SDXL textual inversion</a> section.',Ml,Ye,yl,Se,Ts="SDXL is a large model, and you may need to optimize memory to get it to run on your hardware. Here are some tips to save memory and speed up inference.",bl,Ee,ws='<li>Offload the model to the CPU with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> for out-of-memory errors:</li>',hl,Ne,gl,B,Zs="<li>Use <code>torch.compile</code> for ~20% speed-up (you need <code>torch&gt;=2.0</code>):</li>",Jl,Qe,Tl,k,Us='<li>Enable <a href="../optimization/xformers">xFormers</a> to run SDXL if <code>torch&lt;2.0</code>:</li>',wl,Fe,Zl,Le,Ul,He,js='If you’re interested in experimenting with a minimal version of the <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used in SDXL, take a look at the <a href="https://github.com/cloneofsimo/minSDXL" rel="nofollow">minSDXL</a> implementation which is written in PyTorch and directly compatible with 🤗 Diffusers.',jl,ze,Wl,Ae,Gl;return X=new b({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h1"}}),x=new ks({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl.ipynb"}]}}),Y=new M({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwaW52aXNpYmxlLXdhdGVybWFyayUzRSUzRDAuMi4w",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate invisible-watermark&gt;=0.2.0</span>`,wrap:!1}}),S=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBhZGRfd2F0ZXJtYXJrZXIlM0RGYWxzZSk=",highlighted:'pipeline = StableDiffusionXLPipeline.from_pretrained(..., add_watermarker=<span class="hljs-literal">False</span>)',wrap:!1}}),E=new b({props:{title:"Load model checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),Q=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcmVmaW5lciUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, StableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = StableDiffusionXLImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),L=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfYmFzZV8xLjAuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcmVmaW5lciUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyRmJsb2IlMkZtYWluJTJGc2RfeGxfcmVmaW5lcl8xLjAuc2FmZXRlbnNvcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, StableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_base_1.0.safetensors&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = StableDiffusionXLImg2ImgPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0/blob/main/sd_xl_refiner_1.0.safetensors&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),H=new b({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),q=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lX3RleHQyaW1hZ2UlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZShwcm9tcHQlM0Rwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2image = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipeline_text2image(prompt=prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),D=new b({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),P=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjB1c2UlMjBmcm9tX3BpcGUlMjB0byUyMGF2b2lkJTIwY29uc3VtaW5nJTIwYWRkaXRpb25hbCUyMG1lbW9yeSUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMGNoZWNrcG9pbnQlMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltYWdlKS50byglMjJjdWRhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtdGV4dDJpbWcucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBjYXRjaGluZyUyMGElMjBmcmlzYmVlJTIwaW4lMjB0aGUlMjBqdW5nbGUlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC44JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMC41KS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># use from_pipe to avoid consuming additional memory when loading a checkpoint</span>
pipeline = AutoPipelineForImage2Image.from_pipe(pipeline_text2image).to(<span class="hljs-string">&quot;cuda&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
init_image = load_image(url)
prompt = <span class="hljs-string">&quot;a dog catching a frisbee in the jungle&quot;</span>
image = pipeline(prompt, image=init_image, strength=<span class="hljs-number">0.8</span>, guidance_scale=<span class="hljs-number">10.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),K=new b({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),ee=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQSUyMyUyMHVzZSUyMGZyb21fcGlwZSUyMHRvJTIwYXZvaWQlMjBjb25zdW1pbmclMjBhZGRpdGlvbmFsJTIwbWVtb3J5JTIwd2hlbiUyMGxvYWRpbmclMjBhJTIwY2hlY2twb2ludCUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZy5mcm9tX3BpcGUocGlwZWxpbmVfdGV4dDJpbWFnZSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGc2R4bC10ZXh0MmltZy5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpJTBBbWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC44NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMTIuNSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># use from_pipe to avoid consuming additional memory when loading a checkpoint</span>
pipeline = AutoPipelineForInpainting.from_pipe(pipeline_text2image).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>

init_image = load_image(img_url)
mask_image = load_image(mask_url)

prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),te=new b({props:{title:"Refine image quality",local:"refine-image-quality",headingTag:"h2"}}),ae=new b({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h3"}}),oe=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFiYXNlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFyZWZpbmVyJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNEYmFzZS50ZXh0X2VuY29kZXJfMiUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRGJhc2UudmFlJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

base = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>,
    text_encoder_2=base.text_encoder_2,
    vae=base.vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),me=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQSUwQWltYWdlJTIwJTNEJTIwYmFzZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENDAlMkMlMEElMjAlMjAlMjAlMjBkZW5vaXNpbmdfZW5kJTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIlMkMlMEEpLmltYWdlcyUwQWltYWdlJTIwJTNEJTIwcmVmaW5lciglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENDAlMkMlMEElMjAlMjAlMjAlMjBkZW5vaXNpbmdfc3RhcnQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>

image = base(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images
image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),fe=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">import</span> torch

base = StableDiffusionXLInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = StableDiffusionXLInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>,
    text_encoder_2=base.text_encoder_2,
    vae=base.vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url)
mask_image = load_image(mask_url)

prompt = <span class="hljs-string">&quot;A majestic tiger sitting on a bench&quot;</span>
num_inference_steps = <span class="hljs-number">75</span>
high_noise_frac = <span class="hljs-number">0.7</span>

image = base(
    prompt=prompt,
    image=init_image,
    mask_image=mask_image,
    num_inference_steps=num_inference_steps,
    denoising_end=high_noise_frac,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images
image = refiner(
    prompt=prompt,
    image=image,
    mask_image=mask_image,
    num_inference_steps=num_inference_steps,
    denoising_start=high_noise_frac,
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),ue=new b({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h3"}}),be=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFiYXNlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFyZWZpbmVyJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNEYmFzZS50ZXh0X2VuY29kZXJfMiUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRGJhc2UudmFlJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

base = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

refiner = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>,
    text_encoder_2=base.text_encoder_2,
    vae=base.vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ge=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwYmFzZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RA==",highlighted:`prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Te=new M({props:{code:"aW1hZ2UlMjAlM0QlMjByZWZpbmVyKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UlNUJOb25lJTJDJTIwJTNBJTVEKS5pbWFnZXMlNUIwJTVE",highlighted:'image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]',wrap:!1}}),Ze=new b({props:{title:"Micro-conditioning",local:"micro-conditioning",headingTag:"h2"}}),je=new b({props:{title:"Size conditioning",local:"size-conditioning",headingTag:"h3"}}),ve=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9vcmlnaW5hbF9zaXplJTNEKDUxMiUyQyUyMDUxMiklMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV90YXJnZXRfc2l6ZSUzRCgxMDI0JTJDJTIwMTAyNCklMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(
    prompt=prompt,
    negative_original_size=(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>),
    negative_target_size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_e=new b({props:{title:"Crop conditioning",local:"crop-conditioning",headingTag:"h3"}}),ke=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGNyb3BzX2Nvb3Jkc190b3BfbGVmdCUzRCgyNTYlMkMlMjAwKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipeline(prompt=prompt, crops_coords_top_left=(<span class="hljs-number">256</span>, <span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),xe=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9vcmlnaW5hbF9zaXplJTNEKDUxMiUyQyUyMDUxMiklMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9jcm9wc19jb29yZHNfdG9wX2xlZnQlM0QoMCUyQyUyMDApJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfdGFyZ2V0X3NpemUlM0QoMTAyNCUyQyUyMDEwMjQpJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipe(
    prompt=prompt,
    negative_original_size=(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>),
    negative_crops_coords_top_left=(<span class="hljs-number">0</span>, <span class="hljs-number">0</span>),
    negative_target_size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ce=new b({props:{title:"Use a different prompt for each text-encoder",local:"use-a-different-prompt-for-each-text-encoder",headingTag:"h2"}}),$e=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHByb21wdCUyMGlzJTIwcGFzc2VkJTIwdG8lMjBPQUklMjBDTElQLVZpVCUyRkwtMTQlMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBJTIzJTIwcHJvbXB0XzIlMjBpcyUyMHBhc3NlZCUyMHRvJTIwT3BlbkNMSVAtVmlUJTJGYmlnRy0xNCUwQXByb21wdF8yJTIwJTNEJTIwJTIyVmFuJTIwR29naCUyMHBhaW50aW5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBwcm9tcHRfMiUzRHByb21wdF8yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># prompt is passed to OAI CLIP-ViT/L-14</span>
prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-comment"># prompt_2 is passed to OpenCLIP-ViT/bigG-14</span>
prompt_2 = <span class="hljs-string">&quot;Van Gogh painting&quot;</span>
image = pipeline(prompt=prompt, prompt_2=prompt_2).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ye=new b({props:{title:"Optimizations",local:"optimizations",headingTag:"h2"}}),Ne=new M({props:{code:"LSUyMGJhc2UudG8oJTIyY3VkYSUyMiklMEEtJTIwcmVmaW5lci50byglMjJjdWRhJTIyKSUwQSUyQiUyMGJhc2UuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjByZWZpbmVyLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-deletion">- base.to(&quot;cuda&quot;)</span>
<span class="hljs-deletion">- refiner.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ base.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ refiner.enable_model_cpu_offload()</span>`,wrap:!1}}),Qe=new M({props:{code:"JTJCJTIwYmFzZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShiYXNlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMkIlMjByZWZpbmVyLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKHJlZmluZXIudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:`<span class="hljs-addition">+ base.unet = torch.compile(base.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>
<span class="hljs-addition">+ refiner.unet = torch.compile(refiner.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),Fe=new M({props:{code:"JTJCJTIwYmFzZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUyQiUyMHJlZmluZXIuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCk=",highlighted:`<span class="hljs-addition">+ base.enable_xformers_memory_efficient_attention()</span>
<span class="hljs-addition">+ refiner.enable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),Le=new b({props:{title:"Other resources",local:"other-resources",headingTag:"h2"}}),ze=new Xs({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/sdxl.md"}}),{c(){h=n("meta"),Pe=a(),De=n("p"),Ke=a(),r(X.$$.fragment),Oe=a(),r(x.$$.fragment),et=a(),C=n("p"),C.innerHTML=Xl,tt=a(),R=n("ol"),R.innerHTML=xl,lt=a(),$=n("p"),$.textContent=Cl,st=a(),V=n("p"),V.textContent=Rl,at=a(),r(Y.$$.fragment),it=a(),g=n("blockquote"),qe=n("p"),qe.innerHTML=$l,vl=a(),r(S.$$.fragment),nt=a(),r(E.$$.fragment),ot=a(),N=n("p"),N.innerHTML=Vl,pt=a(),r(Q.$$.fragment),rt=a(),F=n("p"),F.innerHTML=Yl,mt=a(),r(L.$$.fragment),dt=a(),r(H.$$.fragment),ft=a(),z=n("p"),z.innerHTML=Sl,ct=a(),r(q.$$.fragment),ut=a(),J=n("div"),J.innerHTML=El,Mt=a(),r(D.$$.fragment),yt=a(),A=n("p"),A.textContent=Nl,bt=a(),r(P.$$.fragment),ht=a(),T=n("div"),T.innerHTML=Ql,gt=a(),r(K.$$.fragment),Jt=a(),O=n("p"),O.textContent=Fl,Tt=a(),r(ee.$$.fragment),wt=a(),w=n("div"),w.innerHTML=Ll,Zt=a(),r(te.$$.fragment),Ut=a(),le=n("p"),le.innerHTML=Hl,jt=a(),se=n("ol"),se.innerHTML=zl,Wt=a(),r(ae.$$.fragment),Gt=a(),ie=n("p"),ie.innerHTML=ql,It=a(),ne=n("p"),ne.textContent=Dl,vt=a(),r(oe.$$.fragment),_t=a(),pe=n("p"),pe.innerHTML=Al,Bt=a(),Z=n("blockquote"),Z.innerHTML=Pl,kt=a(),re=n("p"),re.innerHTML=Kl,Xt=a(),r(me.$$.fragment),xt=a(),U=n("div"),U.innerHTML=Ol,Ct=a(),de=n("p"),de.innerHTML=es,Rt=a(),r(fe.$$.fragment),$t=a(),ce=n("p"),ce.textContent=ts,Vt=a(),r(ue.$$.fragment),Yt=a(),Me=n("p"),Me.textContent=ls,St=a(),ye=n("p"),ye.textContent=ss,Et=a(),r(be.$$.fragment),Nt=a(),j=n("blockquote"),j.innerHTML=as,Qt=a(),he=n("p"),he.innerHTML=is,Ft=a(),r(ge.$$.fragment),Lt=a(),Je=n("p"),Je.textContent=ns,Ht=a(),r(Te.$$.fragment),zt=a(),W=n("div"),W.innerHTML=os,qt=a(),we=n("p"),we.innerHTML=ps,Dt=a(),r(Ze.$$.fragment),At=a(),Ue=n("p"),Ue.innerHTML=rs,Pt=a(),G=n("blockquote"),G.innerHTML=ms,Kt=a(),r(je.$$.fragment),Ot=a(),We=n("p"),We.textContent=ds,el=a(),Ge=n("ul"),Ge.innerHTML=fs,tl=a(),Ie=n("p"),Ie.textContent=cs,ll=a(),r(ve.$$.fragment),sl=a(),I=n("div"),I.innerHTML=us,al=a(),r(_e.$$.fragment),il=a(),Be=n("p"),Be.innerHTML=Ms,nl=a(),r(ke.$$.fragment),ol=a(),v=n("div"),v.innerHTML=ys,pl=a(),Xe=n("p"),Xe.textContent=bs,rl=a(),r(xe.$$.fragment),ml=a(),r(Ce.$$.fragment),dl=a(),Re=n("p"),Re.innerHTML=hs,fl=a(),r($e.$$.fragment),cl=a(),_=n("div"),_.innerHTML=gs,ul=a(),Ve=n("p"),Ve.innerHTML=Js,Ml=a(),r(Ye.$$.fragment),yl=a(),Se=n("p"),Se.textContent=Ts,bl=a(),Ee=n("ol"),Ee.innerHTML=ws,hl=a(),r(Ne.$$.fragment),gl=a(),B=n("ol"),B.innerHTML=Zs,Jl=a(),r(Qe.$$.fragment),Tl=a(),k=n("ol"),k.innerHTML=Us,wl=a(),r(Fe.$$.fragment),Zl=a(),r(Le.$$.fragment),Ul=a(),He=n("p"),He.innerHTML=js,jl=a(),r(ze.$$.fragment),Wl=a(),Ae=n("p"),this.h()},l(e){const t=Bs("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),Pe=i(e),De=o(e,"P",{}),_l(De).forEach(l),Ke=i(e),m(X.$$.fragment,e),Oe=i(e),m(x.$$.fragment,e),et=i(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-8e6ihk"&&(C.innerHTML=Xl),tt=i(e),R=o(e,"OL",{"data-svelte-h":!0}),p(R)!=="svelte-kzd5ve"&&(R.innerHTML=xl),lt=i(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1dmebl2"&&($.textContent=Cl),st=i(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-cwruts"&&(V.textContent=Rl),at=i(e),m(Y.$$.fragment,e),it=i(e),g=o(e,"BLOCKQUOTE",{class:!0});var Il=_l(g);qe=o(Il,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1pmihy9"&&(qe.innerHTML=$l),vl=i(Il),m(S.$$.fragment,Il),Il.forEach(l),nt=i(e),m(E.$$.fragment,e),ot=i(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-hva56b"&&(N.innerHTML=Vl),pt=i(e),m(Q.$$.fragment,e),rt=i(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1bnykxt"&&(F.innerHTML=Yl),mt=i(e),m(L.$$.fragment,e),dt=i(e),m(H.$$.fragment,e),ft=i(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-14g8zj2"&&(z.innerHTML=Sl),ct=i(e),m(q.$$.fragment,e),ut=i(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(J)!=="svelte-olxauf"&&(J.innerHTML=El),Mt=i(e),m(D.$$.fragment,e),yt=i(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1wfw5z2"&&(A.textContent=Nl),bt=i(e),m(P.$$.fragment,e),ht=i(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-qmwul6"&&(T.innerHTML=Ql),gt=i(e),m(K.$$.fragment,e),Jt=i(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-9ro4ak"&&(O.textContent=Fl),Tt=i(e),m(ee.$$.fragment,e),wt=i(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-oeht90"&&(w.innerHTML=Ll),Zt=i(e),m(te.$$.fragment,e),Ut=i(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-c9rvzh"&&(le.innerHTML=Hl),jt=i(e),se=o(e,"OL",{"data-svelte-h":!0}),p(se)!=="svelte-11dgpwz"&&(se.innerHTML=zl),Wt=i(e),m(ae.$$.fragment,e),Gt=i(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-13hawme"&&(ie.innerHTML=ql),It=i(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-ytk0zd"&&(ne.textContent=Dl),vt=i(e),m(oe.$$.fragment,e),_t=i(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-fh96ip"&&(pe.innerHTML=Al),Bt=i(e),Z=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-1rf1l30"&&(Z.innerHTML=Pl),kt=i(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-6bxxkd"&&(re.innerHTML=Kl),Xt=i(e),m(me.$$.fragment,e),xt=i(e),U=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-1nh65b"&&(U.innerHTML=Ol),Ct=i(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1fh5v19"&&(de.innerHTML=es),Rt=i(e),m(fe.$$.fragment,e),$t=i(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1x3hdt3"&&(ce.textContent=ts),Vt=i(e),m(ue.$$.fragment,e),Yt=i(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1t0l7j9"&&(Me.textContent=ls),St=i(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1ct6jhk"&&(ye.textContent=ss),Et=i(e),m(be.$$.fragment,e),Nt=i(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-12bhzcj"&&(j.innerHTML=as),Qt=i(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-10ioafw"&&(he.innerHTML=is),Ft=i(e),m(ge.$$.fragment,e),Lt=i(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-ht9d3m"&&(Je.textContent=ns),Ht=i(e),m(Te.$$.fragment,e),zt=i(e),W=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-1u8njyh"&&(W.innerHTML=os),qt=i(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1ikkntc"&&(we.innerHTML=ps),Dt=i(e),m(Ze.$$.fragment,e),At=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1jtnlpo"&&(Ue.innerHTML=rs),Pt=i(e),G=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-nifbmk"&&(G.innerHTML=ms),Kt=i(e),m(je.$$.fragment,e),Ot=i(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-h89lzu"&&(We.textContent=ds),el=i(e),Ge=o(e,"UL",{"data-svelte-h":!0}),p(Ge)!=="svelte-bqvi0g"&&(Ge.innerHTML=fs),tl=i(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-2b2q2"&&(Ie.textContent=cs),ll=i(e),m(ve.$$.fragment,e),sl=i(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-thc7vn"&&(I.innerHTML=us),al=i(e),m(_e.$$.fragment,e),il=i(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-14lnf5x"&&(Be.innerHTML=Ms),nl=i(e),m(ke.$$.fragment,e),ol=i(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-167e9h5"&&(v.innerHTML=ys),pl=i(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-f4u8tr"&&(Xe.textContent=bs),rl=i(e),m(xe.$$.fragment,e),ml=i(e),m(Ce.$$.fragment,e),dl=i(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-189in7b"&&(Re.innerHTML=hs),fl=i(e),m($e.$$.fragment,e),cl=i(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-1h8rgz0"&&(_.innerHTML=gs),ul=i(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-5rqyoz"&&(Ve.innerHTML=Js),Ml=i(e),m(Ye.$$.fragment,e),yl=i(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1a85yi5"&&(Se.textContent=Ts),bl=i(e),Ee=o(e,"OL",{"data-svelte-h":!0}),p(Ee)!=="svelte-1v77ccs"&&(Ee.innerHTML=ws),hl=i(e),m(Ne.$$.fragment,e),gl=i(e),B=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(B)!=="svelte-wmj8zo"&&(B.innerHTML=Zs),Jl=i(e),m(Qe.$$.fragment,e),Tl=i(e),k=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(k)!=="svelte-fvjjw8"&&(k.innerHTML=Us),wl=i(e),m(Fe.$$.fragment,e),Zl=i(e),m(Le.$$.fragment,e),Ul=i(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1stjah9"&&(He.innerHTML=js),jl=i(e),m(ze.$$.fragment,e),Wl=i(e),Ae=o(e,"P",{}),_l(Ae).forEach(l),this.h()},h(){y(h,"name","hf:doc:metadata"),y(h,"content",Cs),y(g,"class","warning"),y(J,"class","flex justify-center"),y(T,"class","flex justify-center"),y(w,"class","flex justify-center"),y(Z,"class","tip"),y(U,"class","flex gap-4"),y(j,"class","warning"),y(W,"class","flex gap-4"),y(G,"class","tip"),y(I,"class","flex flex-col justify-center"),y(v,"class","flex justify-center"),y(_,"class","flex justify-center"),y(B,"start","2"),y(k,"start","3")},m(e,t){Bl(document.head,h),s(e,Pe,t),s(e,De,t),s(e,Ke,t),d(X,e,t),s(e,Oe,t),d(x,e,t),s(e,et,t),s(e,C,t),s(e,tt,t),s(e,R,t),s(e,lt,t),s(e,$,t),s(e,st,t),s(e,V,t),s(e,at,t),d(Y,e,t),s(e,it,t),s(e,g,t),Bl(g,qe),Bl(g,vl),d(S,g,null),s(e,nt,t),d(E,e,t),s(e,ot,t),s(e,N,t),s(e,pt,t),d(Q,e,t),s(e,rt,t),s(e,F,t),s(e,mt,t),d(L,e,t),s(e,dt,t),d(H,e,t),s(e,ft,t),s(e,z,t),s(e,ct,t),d(q,e,t),s(e,ut,t),s(e,J,t),s(e,Mt,t),d(D,e,t),s(e,yt,t),s(e,A,t),s(e,bt,t),d(P,e,t),s(e,ht,t),s(e,T,t),s(e,gt,t),d(K,e,t),s(e,Jt,t),s(e,O,t),s(e,Tt,t),d(ee,e,t),s(e,wt,t),s(e,w,t),s(e,Zt,t),d(te,e,t),s(e,Ut,t),s(e,le,t),s(e,jt,t),s(e,se,t),s(e,Wt,t),d(ae,e,t),s(e,Gt,t),s(e,ie,t),s(e,It,t),s(e,ne,t),s(e,vt,t),d(oe,e,t),s(e,_t,t),s(e,pe,t),s(e,Bt,t),s(e,Z,t),s(e,kt,t),s(e,re,t),s(e,Xt,t),d(me,e,t),s(e,xt,t),s(e,U,t),s(e,Ct,t),s(e,de,t),s(e,Rt,t),d(fe,e,t),s(e,$t,t),s(e,ce,t),s(e,Vt,t),d(ue,e,t),s(e,Yt,t),s(e,Me,t),s(e,St,t),s(e,ye,t),s(e,Et,t),d(be,e,t),s(e,Nt,t),s(e,j,t),s(e,Qt,t),s(e,he,t),s(e,Ft,t),d(ge,e,t),s(e,Lt,t),s(e,Je,t),s(e,Ht,t),d(Te,e,t),s(e,zt,t),s(e,W,t),s(e,qt,t),s(e,we,t),s(e,Dt,t),d(Ze,e,t),s(e,At,t),s(e,Ue,t),s(e,Pt,t),s(e,G,t),s(e,Kt,t),d(je,e,t),s(e,Ot,t),s(e,We,t),s(e,el,t),s(e,Ge,t),s(e,tl,t),s(e,Ie,t),s(e,ll,t),d(ve,e,t),s(e,sl,t),s(e,I,t),s(e,al,t),d(_e,e,t),s(e,il,t),s(e,Be,t),s(e,nl,t),d(ke,e,t),s(e,ol,t),s(e,v,t),s(e,pl,t),s(e,Xe,t),s(e,rl,t),d(xe,e,t),s(e,ml,t),d(Ce,e,t),s(e,dl,t),s(e,Re,t),s(e,fl,t),d($e,e,t),s(e,cl,t),s(e,_,t),s(e,ul,t),s(e,Ve,t),s(e,Ml,t),d(Ye,e,t),s(e,yl,t),s(e,Se,t),s(e,bl,t),s(e,Ee,t),s(e,hl,t),d(Ne,e,t),s(e,gl,t),s(e,B,t),s(e,Jl,t),d(Qe,e,t),s(e,Tl,t),s(e,k,t),s(e,wl,t),d(Fe,e,t),s(e,Zl,t),d(Le,e,t),s(e,Ul,t),s(e,He,t),s(e,jl,t),d(ze,e,t),s(e,Wl,t),s(e,Ae,t),Gl=!0},p:Gs,i(e){Gl||(f(X.$$.fragment,e),f(x.$$.fragment,e),f(Y.$$.fragment,e),f(S.$$.fragment,e),f(E.$$.fragment,e),f(Q.$$.fragment,e),f(L.$$.fragment,e),f(H.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(be.$$.fragment,e),f(ge.$$.fragment,e),f(Te.$$.fragment,e),f(Ze.$$.fragment,e),f(je.$$.fragment,e),f(ve.$$.fragment,e),f(_e.$$.fragment,e),f(ke.$$.fragment,e),f(xe.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(Ye.$$.fragment,e),f(Ne.$$.fragment,e),f(Qe.$$.fragment,e),f(Fe.$$.fragment,e),f(Le.$$.fragment,e),f(ze.$$.fragment,e),Gl=!0)},o(e){c(X.$$.fragment,e),c(x.$$.fragment,e),c(Y.$$.fragment,e),c(S.$$.fragment,e),c(E.$$.fragment,e),c(Q.$$.fragment,e),c(L.$$.fragment,e),c(H.$$.fragment,e),c(q.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(me.$$.fragment,e),c(fe.$$.fragment,e),c(ue.$$.fragment,e),c(be.$$.fragment,e),c(ge.$$.fragment,e),c(Te.$$.fragment,e),c(Ze.$$.fragment,e),c(je.$$.fragment,e),c(ve.$$.fragment,e),c(_e.$$.fragment,e),c(ke.$$.fragment,e),c(xe.$$.fragment,e),c(Ce.$$.fragment,e),c($e.$$.fragment,e),c(Ye.$$.fragment,e),c(Ne.$$.fragment,e),c(Qe.$$.fragment,e),c(Fe.$$.fragment,e),c(Le.$$.fragment,e),c(ze.$$.fragment,e),Gl=!1},d(e){e&&(l(Pe),l(De),l(Ke),l(Oe),l(et),l(C),l(tt),l(R),l(lt),l($),l(st),l(V),l(at),l(it),l(g),l(nt),l(ot),l(N),l(pt),l(rt),l(F),l(mt),l(dt),l(ft),l(z),l(ct),l(ut),l(J),l(Mt),l(yt),l(A),l(bt),l(ht),l(T),l(gt),l(Jt),l(O),l(Tt),l(wt),l(w),l(Zt),l(Ut),l(le),l(jt),l(se),l(Wt),l(Gt),l(ie),l(It),l(ne),l(vt),l(_t),l(pe),l(Bt),l(Z),l(kt),l(re),l(Xt),l(xt),l(U),l(Ct),l(de),l(Rt),l($t),l(ce),l(Vt),l(Yt),l(Me),l(St),l(ye),l(Et),l(Nt),l(j),l(Qt),l(he),l(Ft),l(Lt),l(Je),l(Ht),l(zt),l(W),l(qt),l(we),l(Dt),l(At),l(Ue),l(Pt),l(G),l(Kt),l(Ot),l(We),l(el),l(Ge),l(tl),l(Ie),l(ll),l(sl),l(I),l(al),l(il),l(Be),l(nl),l(ol),l(v),l(pl),l(Xe),l(rl),l(ml),l(dl),l(Re),l(fl),l(cl),l(_),l(ul),l(Ve),l(Ml),l(yl),l(Se),l(bl),l(Ee),l(hl),l(gl),l(B),l(Jl),l(Tl),l(k),l(wl),l(Zl),l(Ul),l(He),l(jl),l(Wl),l(Ae)),l(h),u(X,e),u(x,e),u(Y,e),u(S),u(E,e),u(Q,e),u(L,e),u(H,e),u(q,e),u(D,e),u(P,e),u(K,e),u(ee,e),u(te,e),u(ae,e),u(oe,e),u(me,e),u(fe,e),u(ue,e),u(be,e),u(ge,e),u(Te,e),u(Ze,e),u(je,e),u(ve,e),u(_e,e),u(ke,e),u(xe,e),u(Ce,e),u($e,e),u(Ye,e),u(Ne,e),u(Qe,e),u(Fe,e),u(Le,e),u(ze,e)}}}const Cs='{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Load model checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"Refine image quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":3},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":3}],"depth":2},{"title":"Micro-conditioning","local":"micro-conditioning","sections":[{"title":"Size conditioning","local":"size-conditioning","sections":[],"depth":3},{"title":"Crop conditioning","local":"crop-conditioning","sections":[],"depth":3}],"depth":2},{"title":"Use a different prompt for each text-encoder","local":"use-a-different-prompt-for-each-text-encoder","sections":[],"depth":2},{"title":"Optimizations","local":"optimizations","sections":[],"depth":2},{"title":"Other resources","local":"other-resources","sections":[],"depth":2}],"depth":1}';function Rs(kl){return Is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends vs{constructor(h){super(),_s(this,h,Rs,xs,Ws,{})}}export{Ns as component};
