import{s as Ct,n as vt,o as Xt}from"../chunks/scheduler.888833de.js";import{S as Qt,i as _t,e as i,s as a,c as M,h as Vt,a as o,d as t,b as n,f as zl,g as y,j as p,k as J,l as El,m as s,n as r,t as d,o as c,p as m}from"../chunks/index.128ce987.js";import{C as u}from"../chunks/CodeBlock.37df032e.js";import{D as Rt}from"../chunks/DocNotebookDropdown.cbea0b77.js";import{H as Be,E as Yt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function Ht(Fl){let h,Ce,ke,ve,B,Xe,k,Qe,G,$l="Prompts are important because they describe what you want a diffusion model to generate. The best prompts are detailed, specific, and well-structured to help the model realize your vision. But crafting a great prompt takes time and effort and sometimes it may not be enough because language and words can be imprecise. This is where you need to boost your prompt with other techniques, such as prompt enhancing and prompt weighting, to get the results you want.",_e,C,Al="This guide will show you how you can use these prompt techniques to generate high-quality images with lower effort and adjust the weight of certain keywords in a prompt.",Ve,v,Re,b,Dl="<p>This is not an exhaustive guide on prompt engineering, but it will help you understand the necessary parts of a good prompt. We encourage you to continue experimenting with different prompts and combine them in new ways to see what works best. As you write more prompts, you’ll develop an intuition for what works and what doesn’t!</p>",Ye,X,Ll="New diffusion models do a pretty good job of generating high-quality images from a basic prompt, but it is still important to create a well-written prompt to get the best results. Here are a few tips for writing a good prompt:",He,Q,Pl="<li>What is the image <em>medium</em>? Is it a photo, a painting, a 3D illustration, or something else?</li> <li>What is the image <em>subject</em>? Is it a person, animal, object, or scene?</li> <li>What <em>details</em> would you like to see in the image? This is where you can get really creative and have a lot of fun experimenting with different words to bring your image to life. For example, what is the lighting like? What is the vibe and aesthetic? What kind of art or illustration style are you looking for? The more specific and precise words you use, the better the model will understand what you want to generate.</li>",xe,U,Kl='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/plain-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;A photo of a banana-shaped couch in a living room&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/detail-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;A vibrant yellow banana-shaped couch sits in a cozy living room, its curve cradling a pile of colorful cushions. on the wooden floor, a patterned rug adds a touch of eclectic charm, and a potted plant sits in the corner, reaching towards the sunlight filtering through the windows&quot;</figcaption></div>',qe,_,Se,V,Ol="Prompt enhancing is a technique for quickly improving prompt quality without spending too much effort constructing one. It uses a model like GPT2 pretrained on Stable Diffusion text prompts to automatically enrich a prompt with additional important keywords to generate high-quality images.",Ne,R,et="The technique works by curating a list of specific keywords and forcing the model to generate those words to enhance the original prompt. This way, your prompt can be “a cat” and GPT2 can enhance the prompt to “cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain quality sharp focus beautiful detailed intricate stunning amazing epic”.",ze,T,lt='<p>You should also use a <a href="https://www.crosslabs.org//blog/diffusion-with-offset-noise" rel="nofollow"><em>offset noise</em></a> LoRA to improve the contrast in bright and dark images and create better lighting overall. This <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_offset_example-lora_1.0.safetensors" rel="nofollow">LoRA</a> is available from <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>.</p>',Ee,Y,tt='Start by defining certain styles and a list of words (you can check out a more comprehensive list of <a href="https://hf.co/LykosAI/GPT-Prompt-Expansion-Fooocus-v2/blob/main/positive.txt" rel="nofollow">words</a> and <a href="https://github.com/lllyasviel/Fooocus/tree/main/sdxl_styles" rel="nofollow">styles</a> used by Fooocus) to enhance a prompt with.',Fe,H,$e,x,st="You may have noticed in the <code>words</code> list, there are certain words that can be paired together to create something more meaningful. For example, the words “high” and “quality” can be combined to create “high quality”. Let’s pair these words together and remove the words that can’t be paired.",Ae,q,De,S,at='Next, implement a custom <a href="https://huggingface.co/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor" rel="nofollow">LogitsProcessor</a> class that assigns tokens in the <code>words</code> list a value of 0 and assigns tokens not in the <code>words</code> list a negative value so they aren’t picked during generation. This way, generation is biased towards words in the <code>words</code> list. After a word from the list is used, it is also assigned a negative value so it isn’t picked again.',Le,N,Pe,z,nt="Combine the prompt and the <code>cinematic</code> style prompt defined in the <code>styles</code> dictionary earlier.",Ke,E,Oe,F,it='Load a GPT2 tokenizer and model from the <a href="https://huggingface.co/Gustavosta/MagicPrompt-Stable-Diffusion" rel="nofollow">Gustavosta/MagicPrompt-Stable-Diffusion</a> checkpoint (this specific checkpoint is trained to generate prompts) to enhance the prompt.',el,$,ll,A,ot="Then you can combine the input prompt and the generated prompt. Feel free to take a look at what the generated prompt (<code>generated_part</code>) is, the word pairs that were found (<code>pairs</code>), and the remaining words (<code>words</code>). This is all packed together in the <code>enhanced_prompt</code>.",tl,D,sl,L,pt="Finally, load a pipeline and the offset noise LoRA with a <em>low weight</em> to generate an image with the enhanced prompt.",al,P,nl,j,Mt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;a cat basking in the sun on a roof in Turkey&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/enhanced-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</figcaption></div>',il,K,ol,O,yt='Prompt weighting provides a way to emphasize or de-emphasize certain parts of a prompt, allowing for more control over the generated image. A prompt can include several concepts, which gets turned into contextualized text embeddings. The embeddings are used by the model to condition its cross-attention layers to generate an image (read the Stable Diffusion <a href="https://huggingface.co/blog/stable_diffusion" rel="nofollow">blog post</a> to learn more about how it works).',pl,ee,rt='Prompt weighting works by increasing or decreasing the scale of the text embedding vector that corresponds to its concept in the prompt because you may not necessarily want the model to focus on all concepts equally. The easiest way to prepare the prompt embeddings is to use <a href="https://github.com/xhinker/sd_embed" rel="nofollow">Stable Diffusion Long Prompt Weighted Embedding</a> (sd_embed). Once you have the prompt-weighted embeddings, you can pass them to any pipeline that has a <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.__call__.prompt_embeds" rel="nofollow">prompt_embeds</a> (and optionally <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds" rel="nofollow">negative_prompt_embeds</a>) parameter, such as <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>, and <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',Ml,f,dt='<p>If your favorite pipeline doesn’t have a <code>prompt_embeds</code> parameter, please open an <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">issue</a> so we can add it!</p>',yl,le,ct="This guide will show you how to weight your prompts with sd_embed.",rl,te,mt="Before you begin, make sure you have the latest version of sd_embed installed:",dl,se,cl,ae,ut='For this example, let’s use <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',ml,ne,ul,ie,Jt="To upweight or downweight a concept, surround the text with parentheses. More parentheses applies a heavier weight on the text. You can also append a numerical multiplier to the text to indicate how much you want to increase or decrease its weights by.",Jl,oe,ht="<thead><tr><th>format</th> <th>multiplier</th></tr></thead> <tbody><tr><td><code>(hippo)</code></td> <td>increase by 1.1x</td></tr> <tr><td><code>((hippo))</code></td> <td>increase by 1.21x</td></tr> <tr><td><code>(hippo:1.5)</code></td> <td>increase by 1.5x</td></tr> <tr><td><code>(hippo:0.5)</code></td> <td>decrease by 4x</td></tr></tbody>",hl,pe,wt="Create a prompt and use a combination of parentheses and numerical multipliers to upweight various text.",wl,Me,bl,ye,bt="Use the <code>get_weighted_text_embeddings_sdxl</code> function to generate the prompt embeddings and the negative prompt embeddings. It’ll also generated the pooled and negative pooled prompt embeddings since you’re using the SDXL model.",Ul,w,We,Ut="You can safely ignore the error message below about the token index length exceeding the models maximum sequence length. All your tokens will be used in the embedding process.",Nl,re,Tl,de,jl,g,Tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sd_embed_sdxl.png"/>',fl,I,jt='<p>Refer to the <a href="https://github.com/xhinker/sd_embed" rel="nofollow">sd_embed</a> repository for additional details about long prompt weighting for FLUX.1, Stable Cascade, and Stable Diffusion 1.5.</p>',gl,ce,Il,me,ft='<a href="../training/text_inversion">Textual inversion</a> is a technique for learning a specific concept from some images which you can use to generate new images conditioned on that concept.',Zl,ue,gt='Create a pipeline and use the <a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> function to load the textual inversion embeddings (feel free to browse the <a href="https://huggingface.co/spaces/sd-concepts-library/stable-diffusion-conceptualizer" rel="nofollow">Stable Diffusion Conceptualizer</a> for 100+ trained concepts):',Wl,Je,Bl,he,It="Add the <code>&lt;midjourney-style&gt;</code> text to the prompt to trigger the textual inversion.",kl,we,Gl,be,Zt="Use the <code>get_weighted_text_embeddings_sd15</code> function to generate the prompt embeddings and the negative prompt embeddings.",Cl,Ue,vl,Z,Wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sd_embed_textual_inversion.png"/>',Xl,Te,Ql,je,Bt='<a href="../training/dreambooth">DreamBooth</a> is a technique for generating contextualized images of a subject given just a few images of the subject to train on. It is similar to textual inversion, but DreamBooth trains the full model whereas textual inversion only fine-tunes the text embeddings. This means you should use <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load the DreamBooth model (feel free to browse the <a href="https://huggingface.co/sd-dreambooth-library" rel="nofollow">Stable Diffusion Dreambooth Concepts Library</a> for 100+ trained models):',_l,fe,Vl,ge,kt="Depending on the model you use, you’ll need to incorporate the model’s unique identifier into your prompt. For example, the <code>dndcoverart-v1</code> model uses the identifier <code>dndcoverart</code>:",Rl,Ie,Yl,W,Gt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sd_embed_dreambooth.png"/>',Hl,Ze,xl,Ge,ql;return B=new Be({props:{title:"Prompt techniques",local:"prompt-techniques",headingTag:"h1"}}),k=new Rt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/weighted_prompts.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/weighted_prompts.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/weighted_prompts.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/weighted_prompts.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/weighted_prompts.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/weighted_prompts.ipynb"}]}}),v=new Be({props:{title:"Prompt engineering",local:"prompt-engineering",headingTag:"h2"}}),_=new Be({props:{title:"Prompt enhancing with GPT2",local:"prompt-enhancing-with-gpt2",headingTag:"h2"}}),H=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig, GPT2LMHeadModel, GPT2Tokenizer, LogitsProcessor, LogitsProcessorList
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

styles = {
    <span class="hljs-string">&quot;cinematic&quot;</span>: <span class="hljs-string">&quot;cinematic film still of {prompt}, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>,
    <span class="hljs-string">&quot;anime&quot;</span>: <span class="hljs-string">&quot;anime artwork of {prompt}, anime style, key visual, vibrant, studio anime, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;photographic&quot;</span>: <span class="hljs-string">&quot;cinematic photo of {prompt}, 35mm photograph, film, professional, 4k, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;comic&quot;</span>: <span class="hljs-string">&quot;comic of {prompt}, graphic illustration, comic art, graphic novel art, vibrant, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;lineart&quot;</span>: <span class="hljs-string">&quot;line art drawing {prompt}, professional, sleek, modern, minimalist, graphic, line art, vector graphics&quot;</span>,
    <span class="hljs-string">&quot;pixelart&quot;</span>: <span class="hljs-string">&quot; pixel-art {prompt}, low-res, blocky, pixel art style, 8-bit graphics&quot;</span>,
}

words = [
    <span class="hljs-string">&quot;aesthetic&quot;</span>, <span class="hljs-string">&quot;astonishing&quot;</span>, <span class="hljs-string">&quot;beautiful&quot;</span>, <span class="hljs-string">&quot;breathtaking&quot;</span>, <span class="hljs-string">&quot;composition&quot;</span>, <span class="hljs-string">&quot;contrasted&quot;</span>, <span class="hljs-string">&quot;epic&quot;</span>, <span class="hljs-string">&quot;moody&quot;</span>, <span class="hljs-string">&quot;enhanced&quot;</span>,
    <span class="hljs-string">&quot;exceptional&quot;</span>, <span class="hljs-string">&quot;fascinating&quot;</span>, <span class="hljs-string">&quot;flawless&quot;</span>, <span class="hljs-string">&quot;glamorous&quot;</span>, <span class="hljs-string">&quot;glorious&quot;</span>, <span class="hljs-string">&quot;illumination&quot;</span>, <span class="hljs-string">&quot;impressive&quot;</span>, <span class="hljs-string">&quot;improved&quot;</span>,
    <span class="hljs-string">&quot;inspirational&quot;</span>, <span class="hljs-string">&quot;magnificent&quot;</span>, <span class="hljs-string">&quot;majestic&quot;</span>, <span class="hljs-string">&quot;hyperrealistic&quot;</span>, <span class="hljs-string">&quot;smooth&quot;</span>, <span class="hljs-string">&quot;sharp&quot;</span>, <span class="hljs-string">&quot;focus&quot;</span>, <span class="hljs-string">&quot;stunning&quot;</span>, <span class="hljs-string">&quot;detailed&quot;</span>,
    <span class="hljs-string">&quot;intricate&quot;</span>, <span class="hljs-string">&quot;dramatic&quot;</span>, <span class="hljs-string">&quot;high&quot;</span>, <span class="hljs-string">&quot;quality&quot;</span>, <span class="hljs-string">&quot;perfect&quot;</span>, <span class="hljs-string">&quot;light&quot;</span>, <span class="hljs-string">&quot;ultra&quot;</span>, <span class="hljs-string">&quot;highly&quot;</span>, <span class="hljs-string">&quot;radiant&quot;</span>, <span class="hljs-string">&quot;satisfying&quot;</span>,
    <span class="hljs-string">&quot;soothing&quot;</span>, <span class="hljs-string">&quot;sophisticated&quot;</span>, <span class="hljs-string">&quot;stylish&quot;</span>, <span class="hljs-string">&quot;sublime&quot;</span>, <span class="hljs-string">&quot;terrific&quot;</span>, <span class="hljs-string">&quot;touching&quot;</span>, <span class="hljs-string">&quot;timeless&quot;</span>, <span class="hljs-string">&quot;wonderful&quot;</span>, <span class="hljs-string">&quot;unbelievable&quot;</span>,
    <span class="hljs-string">&quot;elegant&quot;</span>, <span class="hljs-string">&quot;awesome&quot;</span>, <span class="hljs-string">&quot;amazing&quot;</span>, <span class="hljs-string">&quot;dynamic&quot;</span>, <span class="hljs-string">&quot;trendy&quot;</span>,
]`,wrap:!1}}),q=new u({props:{code:"d29yZF9wYWlycyUyMCUzRCUyMCU1QiUyMmhpZ2hseSUyMGRldGFpbGVkJTIyJTJDJTIwJTIyaGlnaCUyMHF1YWxpdHklMjIlMkMlMjAlMjJlbmhhbmNlZCUyMHF1YWxpdHklMjIlMkMlMjAlMjJwZXJmZWN0JTIwY29tcG9zaXRpb24lMjIlMkMlMjAlMjJkeW5hbWljJTIwbGlnaHQlMjIlNUQlMEElMEFkZWYlMjBmaW5kX2FuZF9vcmRlcl9wYWlycyhzJTJDJTIwcGFpcnMpJTNBJTBBJTIwJTIwJTIwJTIwd29yZHMlMjAlM0QlMjBzLnNwbGl0KCklMEElMjAlMjAlMjAlMjBmb3VuZF9wYWlycyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMjBpbiUyMHBhaXJzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpcl93b3JkcyUyMCUzRCUyMHBhaXIuc3BsaXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwcGFpcl93b3JkcyU1QjAlNUQlMjBpbiUyMHdvcmRzJTIwYW5kJTIwcGFpcl93b3JkcyU1QjElNUQlMjBpbiUyMHdvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm91bmRfcGFpcnMuYXBwZW5kKHBhaXIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZHMucmVtb3ZlKHBhaXJfd29yZHMlNUIwJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmRzLnJlbW92ZShwYWlyX3dvcmRzJTVCMSU1RCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkcyU1QiUzQSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMjBpbiUyMHBhaXJzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjB3b3JkJTIwaW4lMjBwYWlyLnNwbGl0KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3b3Jkcy5yZW1vdmUod29yZCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUyMCUyMCUyMCUyMG9yZGVyZWRfcGFpcnMlMjAlM0QlMjAlMjIlMkMlMjAlMjIuam9pbihmb3VuZF9wYWlycyklMEElMjAlMjAlMjAlMjByZW1haW5pbmdfcyUyMCUzRCUyMCUyMiUyQyUyMCUyMi5qb2luKHdvcmRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9yZGVyZWRfcGFpcnMlMkMlMjByZW1haW5pbmdfcw==",highlighted:`word_pairs = [<span class="hljs-string">&quot;highly detailed&quot;</span>, <span class="hljs-string">&quot;high quality&quot;</span>, <span class="hljs-string">&quot;enhanced quality&quot;</span>, <span class="hljs-string">&quot;perfect composition&quot;</span>, <span class="hljs-string">&quot;dynamic light&quot;</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">find_and_order_pairs</span>(<span class="hljs-params">s, pairs</span>):
    words = s.split()
    found_pairs = []
    <span class="hljs-keyword">for</span> pair <span class="hljs-keyword">in</span> pairs:
        pair_words = pair.split()
        <span class="hljs-keyword">if</span> pair_words[<span class="hljs-number">0</span>] <span class="hljs-keyword">in</span> words <span class="hljs-keyword">and</span> pair_words[<span class="hljs-number">1</span>] <span class="hljs-keyword">in</span> words:
            found_pairs.append(pair)
            words.remove(pair_words[<span class="hljs-number">0</span>])
            words.remove(pair_words[<span class="hljs-number">1</span>])

    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words[:]:
        <span class="hljs-keyword">for</span> pair <span class="hljs-keyword">in</span> pairs:
            <span class="hljs-keyword">if</span> word <span class="hljs-keyword">in</span> pair.split():
                words.remove(word)
                <span class="hljs-keyword">break</span>
    ordered_pairs = <span class="hljs-string">&quot;, &quot;</span>.join(found_pairs)
    remaining_s = <span class="hljs-string">&quot;, &quot;</span>.join(words)
    <span class="hljs-keyword">return</span> ordered_pairs, remaining_s`,wrap:!1}}),N=new u({props:{code:"Y2xhc3MlMjBDdXN0b21Mb2dpdHNQcm9jZXNzb3IoTG9naXRzUHJvY2Vzc29yKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBiaWFzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmlhcyUyMCUzRCUyMGJpYXMlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwaW5wdXRfaWRzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKGlucHV0X2lkcy5zaGFwZSklMjAlM0QlM0QlMjAyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFzdF90b2tlbl9pZCUyMCUzRCUyMGlucHV0X2lkcyU1QjAlMkMlMjAtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmlhcyU1Qmxhc3RfdG9rZW5faWQlNUQlMjAlM0QlMjAtMWUxMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNjb3JlcyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUwQXdvcmRfaWRzJTIwJTNEJTIwJTVCdG9rZW5pemVyLmVuY29kZSh3b3JkJTJDJTIwYWRkX3ByZWZpeF9zcGFjZSUzRFRydWUpJTVCMCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHdvcmRzJTVEJTBBYmlhcyUyMCUzRCUyMHRvcmNoLmZ1bGwoKHRva2VuaXplci52b2NhYl9zaXplJTJDKSUyQyUyMC1mbG9hdCglMjJJbmYlMjIpKS50byglMjJjdWRhJTIyKSUwQWJpYXMlNUJ3b3JkX2lkcyU1RCUyMCUzRCUyMDAlMEFwcm9jZXNzb3IlMjAlM0QlMjBDdXN0b21Mb2dpdHNQcm9jZXNzb3IoYmlhcyklMEFwcm9jZXNzb3JfbGlzdCUyMCUzRCUyMExvZ2l0c1Byb2Nlc3Nvckxpc3QoJTVCcHJvY2Vzc29yJTVEKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomLogitsProcessor</span>(<span class="hljs-title class_ inherited__">LogitsProcessor</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, bias</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.bias = bias

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, input_ids, scores</span>):
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(input_ids.shape) == <span class="hljs-number">2</span>:
            last_token_id = input_ids[<span class="hljs-number">0</span>, -<span class="hljs-number">1</span>]
            self.bias[last_token_id] = -<span class="hljs-number">1e10</span>
        <span class="hljs-keyword">return</span> scores + self.bias

word_ids = [tokenizer.encode(word, add_prefix_space=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words]
bias = torch.full((tokenizer.vocab_size,), -<span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;Inf&quot;</span>)).to(<span class="hljs-string">&quot;cuda&quot;</span>)
bias[word_ids] = <span class="hljs-number">0</span>
processor = CustomLogitsProcessor(bias)
processor_list = LogitsProcessorList([processor])`,wrap:!1}}),E=new u({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMGJhc2tpbmclMjBpbiUyMHRoZSUyMHN1biUyMG9uJTIwYSUyMHJvb2YlMjBpbiUyMFR1cmtleSUyMiUwQXN0eWxlJTIwJTNEJTIwJTIyY2luZW1hdGljJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwc3R5bGVzJTVCc3R5bGUlNUQuZm9ybWF0KHByb21wdCUzRHByb21wdCklMEFwcm9tcHQlMEElMjJjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBiYXNraW5nJTIwaW4lMjB0aGUlMjBzdW4lMjBvbiUyMGElMjByb29mJTIwaW4lMjBUdXJrZXklMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMjI=",highlighted:`prompt = <span class="hljs-string">&quot;a cat basking in the sun on a roof in Turkey&quot;</span>
style = <span class="hljs-string">&quot;cinematic&quot;</span>

prompt = styles[style].<span class="hljs-built_in">format</span>(prompt=prompt)
prompt
<span class="hljs-string">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>`,wrap:!1}}),$=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyR3VzdGF2b3N0YSUyRk1hZ2ljUHJvbXB0LVN0YWJsZS1EaWZmdXNpb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBHUFQyTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkd1c3Rhdm9zdGElMkZNYWdpY1Byb21wdC1TdGFibGUtRGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMEElMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTBBKSUwQW1vZGVsLmV2YWwoKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQXRva2VuX2NvdW50JTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUwQW1heF9uZXdfdG9rZW5zJTIwJTNEJTIwNTAlMjAtJTIwdG9rZW5fY291bnQlMEElMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcGVuYWx0eV9hbHBoYSUzRDAuNyUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUyQyUwQSUyMCUyMCUyMCUyMHBhZF90b2tlbiUzRG1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEbWF4X25ld190b2tlbnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2NvbmZpZyUzRGdlbmVyYXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzX3Byb2Nlc3NvciUzRHByb2NjZXNvcl9saXN0JTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;Gustavosta/MagicPrompt-Stable-Diffusion&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;Gustavosta/MagicPrompt-Stable-Diffusion&quot;</span>, torch_dtype=torch.float16).to(
    <span class="hljs-string">&quot;cuda&quot;</span>
)
model.<span class="hljs-built_in">eval</span>()

inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
token_count = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]
max_new_tokens = <span class="hljs-number">50</span> - token_count

generation_config = GenerationConfig(
    penalty_alpha=<span class="hljs-number">0.7</span>,
    top_k=<span class="hljs-number">50</span>,
    eos_token_id=model.config.eos_token_id,
    pad_token_id=model.config.eos_token_id,
    pad_token=model.config.pad_token_id,
    do_sample=<span class="hljs-literal">True</span>,
)

<span class="hljs-keyword">with</span> torch.no_grad():
    generated_ids = model.generate(
        input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
        attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
        max_new_tokens=max_new_tokens,
        generation_config=generation_config,
        logits_processor=proccesor_list,
    )`,wrap:!1}}),D=new u({props:{code:"b3V0cHV0X3Rva2VucyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUoZ2VuZXJhdGVkX2lkJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTIwZm9yJTIwZ2VuZXJhdGVkX2lkJTIwaW4lMjBnZW5lcmF0ZWRfaWRzJTVEJTBBaW5wdXRfcGFydCUyQyUyMGdlbmVyYXRlZF9wYXJ0JTIwJTNEJTIwb3V0cHV0X3Rva2VucyU1QjAlNUQlNUIlM0ElMjBsZW4ocHJvbXB0KSU1RCUyQyUyMG91dHB1dF90b2tlbnMlNUIwJTVEJTVCbGVuKHByb21wdCklMjAlM0ElNUQlMEFwYWlycyUyQyUyMHdvcmRzJTIwJTNEJTIwZmluZF9hbmRfb3JkZXJfcGFpcnMoZ2VuZXJhdGVkX3BhcnQlMkMlMjB3b3JkX3BhaXJzKSUwQWZvcm1hdHRlZF9nZW5lcmF0ZWRfcGFydCUyMCUzRCUyMHBhaXJzJTIwJTJCJTIwJTIyJTJDJTIwJTIyJTIwJTJCJTIwd29yZHMlMEFlbmhhbmNlZF9wcm9tcHQlMjAlM0QlMjBpbnB1dF9wYXJ0JTIwJTJCJTIwJTIyJTJDJTIwJTIyJTIwJTJCJTIwZm9ybWF0dGVkX2dlbmVyYXRlZF9wYXJ0JTBBZW5oYW5jZWRfcHJvbXB0JTBBJTVCJTIyY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwYmFza2luZyUyMGluJTIwdGhlJTIwc3VuJTIwb24lMjBhJTIwcm9vZiUyMGluJTIwVHVya2V5JTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTIwcXVhbGl0eSUyMHNoYXJwJTIwZm9jdXMlMjBiZWF1dGlmdWwlMjBkZXRhaWxlZCUyMGludHJpY2F0ZSUyMHN0dW5uaW5nJTIwYW1hemluZyUyMGVwaWMlMjIlNUQ=",highlighted:`output_tokens = [tokenizer.decode(generated_id, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> generated_id <span class="hljs-keyword">in</span> generated_ids]
input_part, generated_part = output_tokens[<span class="hljs-number">0</span>][: <span class="hljs-built_in">len</span>(prompt)], output_tokens[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(prompt) :]
pairs, words = find_and_order_pairs(generated_part, word_pairs)
formatted_generated_part = pairs + <span class="hljs-string">&quot;, &quot;</span> + words
enhanced_prompt = input_part + <span class="hljs-string">&quot;, &quot;</span> + formatted_generated_part
enhanced_prompt
[<span class="hljs-string">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain quality sharp focus beautiful detailed intricate stunning amazing epic&quot;</span>]`,wrap:!1}}),P=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJSdW5EaWZmdXNpb24lMkZKdWdnZXJuYXV0LVhMLXY5JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X25hbWUlM0QlMjJzZF94bF9vZmZzZXRfZXhhbXBsZS1sb3JhXzEuMC5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbmFtZSUzRCUyMm9mZnNldCUyMiUyQyUwQSklMEFwaXBlbGluZS5zZXRfYWRhcHRlcnMoJTVCJTIyb2Zmc2V0JTIyJTVEJTJDJTIwYWRhcHRlcl93ZWlnaHRzJTNEJTVCMC4yJTVEKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwZW5oYW5jZWRfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMTUyJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEODk2JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;RunDiffusion/Juggernaut-XL-v9&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_lora_weights(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    weight_name=<span class="hljs-string">&quot;sd_xl_offset_example-lora_1.0.safetensors&quot;</span>,
    adapter_name=<span class="hljs-string">&quot;offset&quot;</span>,
)
pipeline.set_adapters([<span class="hljs-string">&quot;offset&quot;</span>], adapter_weights=[<span class="hljs-number">0.2</span>])

image = pipeline(
    enhanced_prompt,
    width=<span class="hljs-number">1152</span>,
    height=<span class="hljs-number">896</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),K=new Be({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h2"}}),se=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRnhoaW5rZXIlMkZzZF9lbWJlZC5naXQlNDBtYWlu",highlighted:"pip install git+https://github.com/xhinker/sd_embed.git@main",wrap:!1}}),ne=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkx5a29uJTJGZHJlYW1zaGFwZXIteGwtMS0wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Lykon/dreamshaper-xl-1-0&quot;</span>, torch_dtype=torch.float16)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Me=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sd_embed.embedding_funcs <span class="hljs-keyword">import</span> get_weighted_text_embeddings_sdxl

prompt = <span class="hljs-string">&quot;&quot;&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus. 
This imaginative creature features the distinctive, bulky body of a hippo, 
but with a texture and appearance resembling a golden-brown, crispy waffle. 
The creature might have elements like waffle squares across its skin and a syrup-like sheen. 
It&#x27;s set in a surreal environment that playfully combines a natural water habitat of a hippo with elements of a breakfast table setting, 
possibly including oversized utensils or plates in the background. 
The image should evoke a sense of playful absurdity and culinary fantasy.
&quot;&quot;&quot;</span>

neg_prompt = <span class="hljs-string">&quot;&quot;&quot;\\
skin spots,acnes,skin blemishes,age spot,(ugly:1.2),(duplicate:1.2),(morbid:1.21),(mutilated:1.2),\\
(tranny:1.2),mutated hands,(poorly drawn hands:1.5),blurry,(bad anatomy:1.2),(bad proportions:1.3),\\
extra limbs,(disfigured:1.2),(missing arms:1.2),(extra legs:1.2),(fused fingers:1.5),\\
(too many fingers:1.5),(unclear eyes:1.2),lowers,bad hands,missing fingers,extra digit,\\
bad hands,missing fingers,(extra arms and legs),(worst quality:2),(low quality:2),\\
(normal quality:2),lowres,((monochrome)),((grayscale))
&quot;&quot;&quot;</span>`,wrap:!1}}),re=new u({props:{code:"VG9rZW4lMjBpbmRpY2VzJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBpcyUyMGxvbmdlciUyMHRoYW4lMjB0aGUlMjBzcGVjaWZpZWQlMjBtYXhpbXVtJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBmb3IlMjB0aGlzJTIwbW9kZWw=",highlighted:'Token <span class="hljs-built_in">indices</span> sequence <span class="hljs-built_in">length</span> <span class="hljs-built_in">is</span> longer than the specified maximum sequence <span class="hljs-built_in">length</span> <span class="hljs-keyword">for</span> this model',wrap:!1}}),de=new u({props:{code:"KCUyMCUwQSUyMCUyMHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjBwcm9tcHRfbmVnX2VtYmVkcyUyQyUwQSUyMCUyMHBvb2xlZF9wcm9tcHRfZW1iZWRzJTJDJTBBJTIwJTIwbmVnYXRpdmVfcG9vbGVkX3Byb21wdF9lbWJlZHMlMEEpJTIwJTNEJTIwZ2V0X3dlaWdodGVkX3RleHRfZW1iZWRkaW5nc19zZHhsKCUwQSUyMCUyMCUyMCUyMHBpcGUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdfcHJvbXB0JTNEbmVnX3Byb21wdCUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEcHJvbXB0X25lZ19lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBwb29sZWRfcHJvbXB0X2VtYmVkcyUzRHBvb2xlZF9wcm9tcHRfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcG9vbGVkX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9wb29sZWRfcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMjAlMkIlMjA1MTIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDQuMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgyKSUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`( 
  prompt_embeds,
  prompt_neg_embeds,
  pooled_prompt_embeds,
  negative_pooled_prompt_embeds
) = get_weighted_text_embeddings_sdxl(
    pipe,
    prompt=prompt,
    neg_prompt=neg_prompt
)

image = pipe(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=prompt_neg_embeds,
    pooled_prompt_embeds=pooled_prompt_embeds,
    negative_pooled_prompt_embeds=negative_pooled_prompt_embeds,
    num_inference_steps=<span class="hljs-number">30</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span> + <span class="hljs-number">512</span>,
    guidance_scale=<span class="hljs-number">4.0</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">2</span>)
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ce=new Be({props:{title:"Textual inversion",local:"textual-inversion",headingTag:"h3"}}),Je=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRm1pZGpvdXJuZXktc3R5bGUlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
  torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/midjourney-style&quot;</span>)`,wrap:!1}}),we=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sd_embed.embedding_funcs <span class="hljs-keyword">import</span> get_weighted_text_embeddings_sd15

prompt = <span class="hljs-string">&quot;&quot;&quot;&lt;midjourney-style&gt; A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus. 
This imaginative creature features the distinctive, bulky body of a hippo, 
but with a texture and appearance resembling a golden-brown, crispy waffle. 
The creature might have elements like waffle squares across its skin and a syrup-like sheen. 
It&#x27;s set in a surreal environment that playfully combines a natural water habitat of a hippo with elements of a breakfast table setting, 
possibly including oversized utensils or plates in the background. 
The image should evoke a sense of playful absurdity and culinary fantasy.
&quot;&quot;&quot;</span>

neg_prompt = <span class="hljs-string">&quot;&quot;&quot;\\
skin spots,acnes,skin blemishes,age spot,(ugly:1.2),(duplicate:1.2),(morbid:1.21),(mutilated:1.2),\\
(tranny:1.2),mutated hands,(poorly drawn hands:1.5),blurry,(bad anatomy:1.2),(bad proportions:1.3),\\
extra limbs,(disfigured:1.2),(missing arms:1.2),(extra legs:1.2),(fused fingers:1.5),\\
(too many fingers:1.5),(unclear eyes:1.2),lowers,bad hands,missing fingers,extra digit,\\
bad hands,missing fingers,(extra arms and legs),(worst quality:2),(low quality:2),\\
(normal quality:2),lowres,((monochrome)),((grayscale))
&quot;&quot;&quot;</span>`,wrap:!1}}),Ue=new u({props:{code:"KCUyMCUwQSUyMCUyMHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjBwcm9tcHRfbmVnX2VtYmVkcyUyQyUwQSklMjAlM0QlMjBnZXRfd2VpZ2h0ZWRfdGV4dF9lbWJlZGRpbmdzX3NkMTUoJTBBJTIwJTIwJTIwJTIwcGlwZSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ19wcm9tcHQlM0RuZWdfcHJvbXB0JTBBKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0Rwcm9tcHRfbmVnX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEODk2JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0LjAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMiklMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`( 
  prompt_embeds,
  prompt_neg_embeds,
) = get_weighted_text_embeddings_sd15(
    pipe,
    prompt=prompt,
    neg_prompt=neg_prompt
)

image = pipe(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=prompt_neg_embeds,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">896</span>,
    guidance_scale=<span class="hljs-number">4.0</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">2</span>)
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Te=new Be({props:{title:"DreamBooth",local:"dreambooth",headingTag:"h3"}}),fe=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc2QtZHJlYW1ib290aC1saWJyYXJ5JTJGZG5kY292ZXJhcnQtdjElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, UniPCMultistepScheduler

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd-dreambooth-library/dndcoverart-v1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)`,wrap:!1}}),Ie=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sd_embed.embedding_funcs <span class="hljs-keyword">import</span> get_weighted_text_embeddings_sd15

prompt = <span class="hljs-string">&quot;&quot;&quot;dndcoverart of A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus. 
This imaginative creature features the distinctive, bulky body of a hippo, 
but with a texture and appearance resembling a golden-brown, crispy waffle. 
The creature might have elements like waffle squares across its skin and a syrup-like sheen. 
It&#x27;s set in a surreal environment that playfully combines a natural water habitat of a hippo with elements of a breakfast table setting, 
possibly including oversized utensils or plates in the background. 
The image should evoke a sense of playful absurdity and culinary fantasy.
&quot;&quot;&quot;</span>

neg_prompt = <span class="hljs-string">&quot;&quot;&quot;\\
skin spots,acnes,skin blemishes,age spot,(ugly:1.2),(duplicate:1.2),(morbid:1.21),(mutilated:1.2),\\
(tranny:1.2),mutated hands,(poorly drawn hands:1.5),blurry,(bad anatomy:1.2),(bad proportions:1.3),\\
extra limbs,(disfigured:1.2),(missing arms:1.2),(extra legs:1.2),(fused fingers:1.5),\\
(too many fingers:1.5),(unclear eyes:1.2),lowers,bad hands,missing fingers,extra digit,\\
bad hands,missing fingers,(extra arms and legs),(worst quality:2),(low quality:2),\\
(normal quality:2),lowres,((monochrome)),((grayscale))
&quot;&quot;&quot;</span>

(
    prompt_embeds
    , prompt_neg_embeds
) = get_weighted_text_embeddings_sd15(
    pipe
    , prompt = prompt
    , neg_prompt = neg_prompt
)`,wrap:!1}}),Ze=new Yt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/weighted_prompts.md"}}),{c(){h=i("meta"),Ce=a(),ke=i("p"),ve=a(),M(B.$$.fragment),Xe=a(),M(k.$$.fragment),Qe=a(),G=i("p"),G.textContent=$l,_e=a(),C=i("p"),C.textContent=Al,Ve=a(),M(v.$$.fragment),Re=a(),b=i("blockquote"),b.innerHTML=Dl,Ye=a(),X=i("p"),X.textContent=Ll,He=a(),Q=i("ol"),Q.innerHTML=Pl,xe=a(),U=i("div"),U.innerHTML=Kl,qe=a(),M(_.$$.fragment),Se=a(),V=i("p"),V.textContent=Ol,Ne=a(),R=i("p"),R.textContent=et,ze=a(),T=i("blockquote"),T.innerHTML=lt,Ee=a(),Y=i("p"),Y.innerHTML=tt,Fe=a(),M(H.$$.fragment),$e=a(),x=i("p"),x.innerHTML=st,Ae=a(),M(q.$$.fragment),De=a(),S=i("p"),S.innerHTML=at,Le=a(),M(N.$$.fragment),Pe=a(),z=i("p"),z.innerHTML=nt,Ke=a(),M(E.$$.fragment),Oe=a(),F=i("p"),F.innerHTML=it,el=a(),M($.$$.fragment),ll=a(),A=i("p"),A.innerHTML=ot,tl=a(),M(D.$$.fragment),sl=a(),L=i("p"),L.innerHTML=pt,al=a(),M(P.$$.fragment),nl=a(),j=i("div"),j.innerHTML=Mt,il=a(),M(K.$$.fragment),ol=a(),O=i("p"),O.innerHTML=yt,pl=a(),ee=i("p"),ee.innerHTML=rt,Ml=a(),f=i("blockquote"),f.innerHTML=dt,yl=a(),le=i("p"),le.textContent=ct,rl=a(),te=i("p"),te.textContent=mt,dl=a(),M(se.$$.fragment),cl=a(),ae=i("p"),ae.innerHTML=ut,ml=a(),M(ne.$$.fragment),ul=a(),ie=i("p"),ie.textContent=Jt,Jl=a(),oe=i("table"),oe.innerHTML=ht,hl=a(),pe=i("p"),pe.textContent=wt,wl=a(),M(Me.$$.fragment),bl=a(),ye=i("p"),ye.innerHTML=bt,Ul=a(),w=i("blockquote"),We=i("p"),We.textContent=Ut,Nl=a(),M(re.$$.fragment),Tl=a(),M(de.$$.fragment),jl=a(),g=i("div"),g.innerHTML=Tt,fl=a(),I=i("blockquote"),I.innerHTML=jt,gl=a(),M(ce.$$.fragment),Il=a(),me=i("p"),me.innerHTML=ft,Zl=a(),ue=i("p"),ue.innerHTML=gt,Wl=a(),M(Je.$$.fragment),Bl=a(),he=i("p"),he.innerHTML=It,kl=a(),M(we.$$.fragment),Gl=a(),be=i("p"),be.innerHTML=Zt,Cl=a(),M(Ue.$$.fragment),vl=a(),Z=i("div"),Z.innerHTML=Wt,Xl=a(),M(Te.$$.fragment),Ql=a(),je=i("p"),je.innerHTML=Bt,_l=a(),M(fe.$$.fragment),Vl=a(),ge=i("p"),ge.innerHTML=kt,Rl=a(),M(Ie.$$.fragment),Yl=a(),W=i("div"),W.innerHTML=Gt,Hl=a(),M(Ze.$$.fragment),xl=a(),Ge=i("p"),this.h()},l(e){const l=Vt("svelte-u9bgzb",document.head);h=o(l,"META",{name:!0,content:!0}),l.forEach(t),Ce=n(e),ke=o(e,"P",{}),zl(ke).forEach(t),ve=n(e),y(B.$$.fragment,e),Xe=n(e),y(k.$$.fragment,e),Qe=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1kbqxv6"&&(G.textContent=$l),_e=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-6johch"&&(C.textContent=Al),Ve=n(e),y(v.$$.fragment,e),Re=n(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-xrp21u"&&(b.innerHTML=Dl),Ye=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1c7rxt1"&&(X.textContent=Ll),He=n(e),Q=o(e,"OL",{"data-svelte-h":!0}),p(Q)!=="svelte-1cs1rnw"&&(Q.innerHTML=Pl),xe=n(e),U=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-ahartp"&&(U.innerHTML=Kl),qe=n(e),y(_.$$.fragment,e),Se=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-dttsfg"&&(V.textContent=Ol),Ne=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-j8rp3s"&&(R.textContent=et),ze=n(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-80bucc"&&(T.innerHTML=lt),Ee=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-l7cdn9"&&(Y.innerHTML=tt),Fe=n(e),y(H.$$.fragment,e),$e=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-i0sn10"&&(x.innerHTML=st),Ae=n(e),y(q.$$.fragment,e),De=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-117it8a"&&(S.innerHTML=at),Le=n(e),y(N.$$.fragment,e),Pe=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-3e511v"&&(z.innerHTML=nt),Ke=n(e),y(E.$$.fragment,e),Oe=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1kowtsg"&&(F.innerHTML=it),el=n(e),y($.$$.fragment,e),ll=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-r4gy79"&&(A.innerHTML=ot),tl=n(e),y(D.$$.fragment,e),sl=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-14szpok"&&(L.innerHTML=pt),al=n(e),y(P.$$.fragment,e),nl=n(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-12k1k80"&&(j.innerHTML=Mt),il=n(e),y(K.$$.fragment,e),ol=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1tre73w"&&(O.innerHTML=yt),pl=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1kpogg0"&&(ee.innerHTML=rt),Ml=n(e),f=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-1yydabv"&&(f.innerHTML=dt),yl=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1n4phsm"&&(le.textContent=ct),rl=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-b0yvfd"&&(te.textContent=mt),dl=n(e),y(se.$$.fragment,e),cl=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-176kpz2"&&(ae.innerHTML=ut),ml=n(e),y(ne.$$.fragment,e),ul=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1jnedn0"&&(ie.textContent=Jt),Jl=n(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),p(oe)!=="svelte-sd8qlp"&&(oe.innerHTML=ht),hl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-wlhbsn"&&(pe.textContent=wt),wl=n(e),y(Me.$$.fragment,e),bl=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-khohuf"&&(ye.innerHTML=bt),Ul=n(e),w=o(e,"BLOCKQUOTE",{class:!0});var Sl=zl(w);We=o(Sl,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1f5pww5"&&(We.textContent=Ut),Nl=n(Sl),y(re.$$.fragment,Sl),Sl.forEach(t),Tl=n(e),y(de.$$.fragment,e),jl=n(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(g)!=="svelte-11udym8"&&(g.innerHTML=Tt),fl=n(e),I=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-135tjiu"&&(I.innerHTML=jt),gl=n(e),y(ce.$$.fragment,e),Il=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-lcas44"&&(me.innerHTML=ft),Zl=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1lpoeb9"&&(ue.innerHTML=gt),Wl=n(e),y(Je.$$.fragment,e),Bl=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-kl2pnr"&&(he.innerHTML=It),kl=n(e),y(we.$$.fragment,e),Gl=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-10qw7vk"&&(be.innerHTML=Zt),Cl=n(e),y(Ue.$$.fragment,e),vl=n(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-4cwxjs"&&(Z.innerHTML=Wt),Xl=n(e),y(Te.$$.fragment,e),Ql=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-d93hmf"&&(je.innerHTML=Bt),_l=n(e),y(fe.$$.fragment,e),Vl=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-16f827k"&&(ge.innerHTML=kt),Rl=n(e),y(Ie.$$.fragment,e),Yl=n(e),W=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-y2cfia"&&(W.innerHTML=Gt),Hl=n(e),y(Ze.$$.fragment,e),xl=n(e),Ge=o(e,"P",{}),zl(Ge).forEach(t),this.h()},h(){J(h,"name","hf:doc:metadata"),J(h,"content",xt),J(b,"class","tip"),J(U,"class","flex gap-4"),J(T,"class","tip"),J(j,"class","flex gap-4"),J(f,"class","tip"),J(w,"class","tip"),J(g,"class","flex justify-center"),J(I,"class","tip"),J(Z,"class","flex justify-center"),J(W,"class","flex justify-center")},m(e,l){El(document.head,h),s(e,Ce,l),s(e,ke,l),s(e,ve,l),r(B,e,l),s(e,Xe,l),r(k,e,l),s(e,Qe,l),s(e,G,l),s(e,_e,l),s(e,C,l),s(e,Ve,l),r(v,e,l),s(e,Re,l),s(e,b,l),s(e,Ye,l),s(e,X,l),s(e,He,l),s(e,Q,l),s(e,xe,l),s(e,U,l),s(e,qe,l),r(_,e,l),s(e,Se,l),s(e,V,l),s(e,Ne,l),s(e,R,l),s(e,ze,l),s(e,T,l),s(e,Ee,l),s(e,Y,l),s(e,Fe,l),r(H,e,l),s(e,$e,l),s(e,x,l),s(e,Ae,l),r(q,e,l),s(e,De,l),s(e,S,l),s(e,Le,l),r(N,e,l),s(e,Pe,l),s(e,z,l),s(e,Ke,l),r(E,e,l),s(e,Oe,l),s(e,F,l),s(e,el,l),r($,e,l),s(e,ll,l),s(e,A,l),s(e,tl,l),r(D,e,l),s(e,sl,l),s(e,L,l),s(e,al,l),r(P,e,l),s(e,nl,l),s(e,j,l),s(e,il,l),r(K,e,l),s(e,ol,l),s(e,O,l),s(e,pl,l),s(e,ee,l),s(e,Ml,l),s(e,f,l),s(e,yl,l),s(e,le,l),s(e,rl,l),s(e,te,l),s(e,dl,l),r(se,e,l),s(e,cl,l),s(e,ae,l),s(e,ml,l),r(ne,e,l),s(e,ul,l),s(e,ie,l),s(e,Jl,l),s(e,oe,l),s(e,hl,l),s(e,pe,l),s(e,wl,l),r(Me,e,l),s(e,bl,l),s(e,ye,l),s(e,Ul,l),s(e,w,l),El(w,We),El(w,Nl),r(re,w,null),s(e,Tl,l),r(de,e,l),s(e,jl,l),s(e,g,l),s(e,fl,l),s(e,I,l),s(e,gl,l),r(ce,e,l),s(e,Il,l),s(e,me,l),s(e,Zl,l),s(e,ue,l),s(e,Wl,l),r(Je,e,l),s(e,Bl,l),s(e,he,l),s(e,kl,l),r(we,e,l),s(e,Gl,l),s(e,be,l),s(e,Cl,l),r(Ue,e,l),s(e,vl,l),s(e,Z,l),s(e,Xl,l),r(Te,e,l),s(e,Ql,l),s(e,je,l),s(e,_l,l),r(fe,e,l),s(e,Vl,l),s(e,ge,l),s(e,Rl,l),r(Ie,e,l),s(e,Yl,l),s(e,W,l),s(e,Hl,l),r(Ze,e,l),s(e,xl,l),s(e,Ge,l),ql=!0},p:vt,i(e){ql||(d(B.$$.fragment,e),d(k.$$.fragment,e),d(v.$$.fragment,e),d(_.$$.fragment,e),d(H.$$.fragment,e),d(q.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),d($.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(Me.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(Je.$$.fragment,e),d(we.$$.fragment,e),d(Ue.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(Ie.$$.fragment,e),d(Ze.$$.fragment,e),ql=!0)},o(e){c(B.$$.fragment,e),c(k.$$.fragment,e),c(v.$$.fragment,e),c(_.$$.fragment,e),c(H.$$.fragment,e),c(q.$$.fragment,e),c(N.$$.fragment,e),c(E.$$.fragment,e),c($.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(Me.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(Te.$$.fragment,e),c(fe.$$.fragment,e),c(Ie.$$.fragment,e),c(Ze.$$.fragment,e),ql=!1},d(e){e&&(t(Ce),t(ke),t(ve),t(Xe),t(Qe),t(G),t(_e),t(C),t(Ve),t(Re),t(b),t(Ye),t(X),t(He),t(Q),t(xe),t(U),t(qe),t(Se),t(V),t(Ne),t(R),t(ze),t(T),t(Ee),t(Y),t(Fe),t($e),t(x),t(Ae),t(De),t(S),t(Le),t(Pe),t(z),t(Ke),t(Oe),t(F),t(el),t(ll),t(A),t(tl),t(sl),t(L),t(al),t(nl),t(j),t(il),t(ol),t(O),t(pl),t(ee),t(Ml),t(f),t(yl),t(le),t(rl),t(te),t(dl),t(cl),t(ae),t(ml),t(ul),t(ie),t(Jl),t(oe),t(hl),t(pe),t(wl),t(bl),t(ye),t(Ul),t(w),t(Tl),t(jl),t(g),t(fl),t(I),t(gl),t(Il),t(me),t(Zl),t(ue),t(Wl),t(Bl),t(he),t(kl),t(Gl),t(be),t(Cl),t(vl),t(Z),t(Xl),t(Ql),t(je),t(_l),t(Vl),t(ge),t(Rl),t(Yl),t(W),t(Hl),t(xl),t(Ge)),t(h),m(B,e),m(k,e),m(v,e),m(_,e),m(H,e),m(q,e),m(N,e),m(E,e),m($,e),m(D,e),m(P,e),m(K,e),m(se,e),m(ne,e),m(Me,e),m(re),m(de,e),m(ce,e),m(Je,e),m(we,e),m(Ue,e),m(Te,e),m(fe,e),m(Ie,e),m(Ze,e)}}}const xt='{"title":"Prompt techniques","local":"prompt-techniques","sections":[{"title":"Prompt engineering","local":"prompt-engineering","sections":[],"depth":2},{"title":"Prompt enhancing with GPT2","local":"prompt-enhancing-with-gpt2","sections":[],"depth":2},{"title":"Prompt weighting","local":"prompt-weighting","sections":[{"title":"Textual inversion","local":"textual-inversion","sections":[],"depth":3},{"title":"DreamBooth","local":"dreambooth","sections":[],"depth":3}],"depth":2}],"depth":1}';function qt(Fl){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $t extends Qt{constructor(h){super(),_t(this,h,qt,Ht,Ct,{})}}export{$t as component};
