import{s as Yt,n as At,o as Dt}from"../chunks/scheduler.888833de.js";import{S as qt,i as Pt,e as i,s as a,c as o,h as Kt,a as p,d as t,b as n,f as at,g as r,j as m,k as f,l as nt,m as l,n as d,t as c,o as h,p as u}from"../chunks/index.128ce987.js";import{C as M}from"../chunks/CodeBlock.37df032e.js";import{D as Ot}from"../chunks/DocNotebookDropdown.cbea0b77.js";import{H as $,E as el}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function sl(it){let b,Be,Re,Xe,k,He,_,Se,V,pt='🧨 Diffusers is designed to be a user-friendly and flexible toolbox for building diffusion systems tailored to your use-case. At the core of the toolbox are models and schedulers. While the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> bundles these components together for convenience, you can also unbundle the pipeline and use the models and schedulers separately to create new diffusion systems.',ze,x,mt="In this tutorial, you’ll learn how to use models and schedulers to assemble a diffusion system for inference, starting with a basic pipeline and then progressing to the Stable Diffusion pipeline.",Ee,G,Le,W,ot="A pipeline is a quick and easy way to run a model for inference, requiring no more than four lines of code to generate an image:",Fe,I,Qe,y,rt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ddpm-cat.png" alt="Image of cat created from DDPMPipeline"/>',Ye,R,dt="That was super easy, but how did the pipeline do that? Let’s breakdown the pipeline and take a look at what’s happening under the hood.",Ae,N,ct='In the example above, the pipeline contains a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> model and a <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>. The pipeline denoises an image by taking random noise the size of the desired output and passing it through the model several times. At each timestep, the model predicts the <em>noise residual</em> and the scheduler uses it to predict a less noisy image. The pipeline repeats this process until it reaches the end of the specified number of inference steps.',De,B,ht="To recreate the pipeline with the model and scheduler separately, let’s write our own denoising process.",qe,X,ut="<li>Load the model and scheduler:</li>",Pe,H,Ke,j,Mt="<li>Set the number of timesteps to run the denoising process for:</li>",Oe,S,es,w,ft="<li>Setting the scheduler timesteps creates a tensor with evenly spaced elements in it, 50 in this example. Each element corresponds to a timestep at which the model denoises an image. When you create the denoising loop later, you’ll iterate over this tensor to denoise an image:</li>",ss,z,ts,T,bt="<li>Create some random noise with the same shape as the desired output:</li>",ls,E,as,U,gt='<li>Now write a loop to iterate over the timesteps. At each timestep, the model does a <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel.forward">UNet2DModel.forward()</a> pass and returns the noisy residual. The scheduler’s <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler.step">step()</a> method takes the noisy residual, timestep, and input and it predicts the image at the previous timestep. This output becomes the next input to the model in the denoising loop, and it’ll repeat until it reaches the end of the <code>timesteps</code> array.</li>',ns,L,is,F,yt="This is the entire denoising process, and you can use this same pattern to write any diffusion system.",ps,J,jt="<li>The last step is to convert the denoised output into an image:</li>",ms,Q,os,Y,wt="In the next section, you’ll put your skills to the test and breakdown the more complex Stable Diffusion pipeline. The steps are more or less the same. You’ll initialize the necessary components, and set the number of timesteps to create a <code>timestep</code> array. The <code>timestep</code> array is used in the denoising loop, and for each element in this array, the model predicts a less noisy image. The denoising loop iterates over the <code>timestep</code>’s, and at each timestep, it outputs a noisy residual and the scheduler uses it to predict a less noisy image at the previous timestep. This process is repeated until you reach the end of the <code>timestep</code> array.",rs,A,Tt="Let’s try it out!",ds,D,cs,q,Ut="Stable Diffusion is a text-to-image <em>latent diffusion</em> model. It is called a latent diffusion model because it works with a lower-dimensional representation of the image instead of the actual pixel space, which makes it more memory efficient. The encoder compresses the image into a smaller representation, and a decoder converts the compressed representation back into an image. For text-to-image models, you’ll need a tokenizer and an encoder to generate text embeddings. From the previous example, you already know you need a UNet model and a scheduler.",hs,P,Jt="As you can see, this is already more complex than the DDPM pipeline which only contains a UNet model. The Stable Diffusion model has three separate pretrained models.",us,v,vt='<p>💡 Read the <a href="https://huggingface.co/blog/stable_diffusion#how-does-stable-diffusion-work" rel="nofollow">How does Stable Diffusion work?</a> blog for more details about how the VAE, UNet, and text encoder models work.</p>',Ms,K,Ct='Now that you know what you need for the Stable Diffusion pipeline, load all these components with the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method. You can find them in the pretrained <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> checkpoint, and each component is stored in a separate subfolder:',fs,O,bs,ee,Zt='Instead of the default <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>, exchange it for the <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> to see how easy it is to plug a different scheduler in:',gs,se,ys,te,$t="To speed up inference, move the models to a GPU since, unlike the scheduler, they have trainable weights:",js,le,ws,ae,Ts,ne,kt="The next step is to tokenize the text to generate embeddings. The text is used to condition the UNet model and steer the diffusion process towards something that resembles the input prompt.",Us,C,_t="<p>💡 The <code>guidance_scale</code> parameter determines how much weight should be given to the prompt when generating an image.</p>",Js,ie,Vt="Feel free to choose any prompt you like if you want to generate something else!",vs,pe,Cs,me,xt="Tokenize the text and generate the embeddings from the prompt:",Zs,oe,$s,re,Gt="You’ll also need to generate the <em>unconditional text embeddings</em> which are the embeddings for the padding token. These need to have the same shape (<code>batch_size</code> and <code>seq_length</code>) as the conditional <code>text_embeddings</code>:",ks,de,_s,ce,Wt="Let’s concatenate the conditional and unconditional embeddings into a batch to avoid doing two forward passes:",Vs,he,xs,ue,Gs,Me,It="Next, generate some initial random noise as a starting point for the diffusion process. This is the latent representation of the image, and it’ll be gradually denoised. At this point, the <code>latent</code> image is smaller than the final image size but that’s okay though because the model will transform it into the final 512x512 image dimensions later.",Ws,g,Ie,Rt="💡 The height and width are divided by 8 because the <code>vae</code> model has 3 down-sampling layers. You can check by running the following:",lt,fe,Is,be,Rs,ge,Ns,ye,Nt='Start by scaling the input with the initial noise distribution, <em>sigma</em>, the noise scale value, which is required for improved schedulers like <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>:',Bs,je,Xs,we,Bt="The last step is to create the denoising loop that’ll progressively transform the pure noise in <code>latents</code> to an image described by your prompt. Remember, the denoising loop needs to do three things:",Hs,Te,Xt="<li>Set the scheduler’s timesteps to use during denoising.</li> <li>Iterate over the timesteps.</li> <li>At each timestep, call the UNet model to predict the noise residual and pass it to the scheduler to compute the previous noisy sample.</li>",Ss,Ue,zs,Je,Es,ve,Ht="The final step is to use the <code>vae</code> to decode the latent representation into an image and get the decoded output with <code>sample</code>:",Ls,Ce,Fs,Ze,St="Lastly, convert the image to a <code>PIL.Image</code> to see your generated image!",Qs,$e,Ys,Z,zt='<img src="https://huggingface.co/blog/assets/98_stable_diffusion/stable_diffusion_k_lms.png"/>',As,ke,Ds,_e,Et="From basic to complex pipelines, you’ve seen that all you really need to write your own diffusion system is a denoising loop. The loop should set the scheduler’s timesteps, iterate over them, and alternate between calling the UNet model to predict the noise residual and passing it to the scheduler to compute the previous noisy sample.",qs,Ve,Lt="This is really what 🧨 Diffusers is designed for: to make it intuitive and easy to write your own diffusion system using models and schedulers.",Ps,xe,Ft="For your next steps, feel free to:",Ks,Ge,Qt='<li>Learn how to <a href="../using-diffusers/contribute_pipeline">build and contribute a pipeline</a> to 🧨 Diffusers. We can’t wait and see what you’ll come up with!</li> <li>Explore <a href="../api/pipelines/overview">existing pipelines</a> in the library, and see if you can deconstruct and build a pipeline from scratch using the models and schedulers separately.</li>',Os,We,et,Ne,st;return k=new $({props:{title:"Understanding pipelines, models and schedulers",local:"understanding-pipelines-models-and-schedulers",headingTag:"h1"}}),_=new Ot({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/write_own_pipeline.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/write_own_pipeline.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/write_own_pipeline.ipynb"}]}}),G=new $({props:{title:"Deconstruct a basic pipeline",local:"deconstruct-a-basic-pipeline",headingTag:"h2"}}),I=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQSUwQWRkcG0lMjAlM0QlMjBERFBNUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBkZHBtKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>ddpm = DDPMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = ddpm(num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),H=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiklMEFtb2RlbCUyMCUzRCUyMFVOZXQyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNhdC0yNTYlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),S=new M({props:{code:"c2NoZWR1bGVyLnNldF90aW1lc3RlcHMoNTAp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(<span class="hljs-number">50</span>)',wrap:!1}}),z=new M({props:{code:"c2NoZWR1bGVyLnRpbWVzdGVwcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.timesteps
tensor([<span class="hljs-number">980</span>, <span class="hljs-number">960</span>, <span class="hljs-number">940</span>, <span class="hljs-number">920</span>, <span class="hljs-number">900</span>, <span class="hljs-number">880</span>, <span class="hljs-number">860</span>, <span class="hljs-number">840</span>, <span class="hljs-number">820</span>, <span class="hljs-number">800</span>, <span class="hljs-number">780</span>, <span class="hljs-number">760</span>, <span class="hljs-number">740</span>, <span class="hljs-number">720</span>,
    <span class="hljs-number">700</span>, <span class="hljs-number">680</span>, <span class="hljs-number">660</span>, <span class="hljs-number">640</span>, <span class="hljs-number">620</span>, <span class="hljs-number">600</span>, <span class="hljs-number">580</span>, <span class="hljs-number">560</span>, <span class="hljs-number">540</span>, <span class="hljs-number">520</span>, <span class="hljs-number">500</span>, <span class="hljs-number">480</span>, <span class="hljs-number">460</span>, <span class="hljs-number">440</span>,
    <span class="hljs-number">420</span>, <span class="hljs-number">400</span>, <span class="hljs-number">380</span>, <span class="hljs-number">360</span>, <span class="hljs-number">340</span>, <span class="hljs-number">320</span>, <span class="hljs-number">300</span>, <span class="hljs-number">280</span>, <span class="hljs-number">260</span>, <span class="hljs-number">240</span>, <span class="hljs-number">220</span>, <span class="hljs-number">200</span>, <span class="hljs-number">180</span>, <span class="hljs-number">160</span>,
    <span class="hljs-number">140</span>, <span class="hljs-number">120</span>, <span class="hljs-number">100</span>,  <span class="hljs-number">80</span>,  <span class="hljs-number">60</span>,  <span class="hljs-number">40</span>,  <span class="hljs-number">20</span>,   <span class="hljs-number">0</span>])`,wrap:!1}}),E=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFzYW1wbGVfc2l6ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5zYW1wbGVfc2l6ZSUwQW5vaXNlJTIwJTNEJTIwdG9yY2gucmFuZG4oKDElMkMlMjAzJTJDJTIwc2FtcGxlX3NpemUlMkMlMjBzYW1wbGVfc2l6ZSklMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_size = model.config.sample_size
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, sample_size, sample_size), device=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),L=new M({props:{code:"aW5wdXQlMjAlM0QlMjBub2lzZSUwQSUwQWZvciUyMHQlMjBpbiUyMHNjaGVkdWxlci50aW1lc3RlcHMlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc3lfcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChpbnB1dCUyQyUyMHQpLnNhbXBsZSUwQSUyMCUyMCUyMCUyMHByZXZpb3VzX25vaXN5X3NhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXN5X3Jlc2lkdWFsJTJDJTIwdCUyQyUyMGlucHV0KS5wcmV2X3NhbXBsZSUwQSUyMCUyMCUyMCUyMGlucHV0JTIwJTNEJTIwcHJldmlvdXNfbm9pc3lfc2FtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span> = noise

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> scheduler.timesteps:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noisy_residual = model(<span class="hljs-built_in">input</span>, t).sample
<span class="hljs-meta">... </span>    previous_noisy_sample = scheduler.step(noisy_residual, t, <span class="hljs-built_in">input</span>).prev_sample
<span class="hljs-meta">... </span>    <span class="hljs-built_in">input</span> = previous_noisy_sample`,wrap:!1}}),Q=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBaW1hZ2UlMjAlM0QlMjAoaW5wdXQlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkucm91bmQoKS50byh0b3JjaC51aW50OCkuY3B1KCkubnVtcHkoKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>image = (<span class="hljs-built_in">input</span> / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).<span class="hljs-built_in">round</span>().to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),D=new $({props:{title:"Deconstruct the Stable Diffusion pipeline",local:"deconstruct-the-stable-diffusion-pipeline",headingTag:"h2"}}),O=new M({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFRleHRNb2RlbCUyQyUyMENMSVBUb2tlbml6ZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUyQyUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwUE5ETVNjaGVkdWxlciUwQSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0wuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ2YWUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMENMSVBUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwQ0xJUFRleHRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL, UNet2DConditionModel, PNDMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder = CLIPTextModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet = UNet2DConditionModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),se=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBJTBBc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = UniPCMultistepScheduler.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),le=new M({props:{code:"dG9yY2hfZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQXZhZS50byh0b3JjaF9kZXZpY2UpJTBBdGV4dF9lbmNvZGVyLnRvKHRvcmNoX2RldmljZSklMEF1bmV0LnRvKHRvcmNoX2RldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch_device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder.to(torch_device)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet.to(torch_device)`,wrap:!1}}),ae=new $({props:{title:"Create text embeddings",local:"create-text-embeddings",headingTag:"h3"}}),pe=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyYSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIyJTVEJTBBaGVpZ2h0JTIwJTNEJTIwNTEyJTIwJTIwJTIzJTIwZGVmYXVsdCUyMGhlaWdodCUyMG9mJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTBBd2lkdGglMjAlM0QlMjA1MTIlMjAlMjAlMjMlMjBkZWZhdWx0JTIwd2lkdGglMjBvZiUyMFN0YWJsZSUyMERpZmZ1c2lvbiUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyNSUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwZGVub2lzaW5nJTIwc3RlcHMlMEFndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDcuNSUyMCUyMCUyMyUyMFNjYWxlJTIwZm9yJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUyMCUyMCUyMyUyMFNlZWQlMjBnZW5lcmF0b3IlMjB0byUyMGNyZWF0ZSUyMHRoZSUyMGluaXRpYWwlMjBsYXRlbnQlMjBub2lzZSUwQWJhdGNoX3NpemUlMjAlM0QlMjBsZW4ocHJvbXB0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;a photograph of an astronaut riding a horse&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-number">512</span>  <span class="hljs-comment"># default height of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-number">512</span>  <span class="hljs-comment"># default width of Stable Diffusion</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">25</span>  <span class="hljs-comment"># Number of denoising steps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">7.5</span>  <span class="hljs-comment"># Scale for classifier-free guidance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Seed generator to create the initial latent noise</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-built_in">len</span>(prompt)`,wrap:!1}}),oe=new M({props:{code:"dGV4dF9pbnB1dCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0R0b2tlbml6ZXIubW9kZWxfbWF4X2xlbmd0aCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKHRleHRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_input = tokenizer(
<span class="hljs-meta">... </span>    prompt, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=tokenizer.model_max_length, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    text_embeddings = text_encoder(text_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),de=new M({props:{code:"bWF4X2xlbmd0aCUyMCUzRCUyMHRleHRfaW5wdXQuaW5wdXRfaWRzLnNoYXBlJTVCLTElNUQlMEF1bmNvbmRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyJTIyJTVEJTIwKiUyMGJhdGNoX3NpemUlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0RtYXhfbGVuZ3RoJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF1bmNvbmRfZW1iZWRkaW5ncyUyMCUzRCUyMHRleHRfZW5jb2Rlcih1bmNvbmRfaW5wdXQuaW5wdXRfaWRzLnRvKHRvcmNoX2RldmljZSkpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>max_length = text_input.input_ids.shape[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_input = tokenizer([<span class="hljs-string">&quot;&quot;</span>] * batch_size, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=max_length, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>uncond_embeddings = text_encoder(uncond_input.input_ids.to(torch_device))[<span class="hljs-number">0</span>]`,wrap:!1}}),he=new M({props:{code:"dGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2guY2F0KCU1QnVuY29uZF9lbWJlZGRpbmdzJTJDJTIwdGV4dF9lbWJlZGRpbmdzJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text_embeddings = torch.cat([uncond_embeddings, text_embeddings])',wrap:!1}}),ue=new $({props:{title:"Create random noise",local:"create-random-noise",headingTag:"h3"}}),fe=new M({props:{code:"MiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMjAlM0QlM0QlMjA4",highlighted:'<span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>) == <span class="hljs-number">8</span>',wrap:!1}}),be=new M({props:{code:"bGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCUwQSUyMCUyMCUyMCUyMChiYXRjaF9zaXplJTJDJTIwdW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMjAlMkYlMkYlMjA4JTJDJTIwd2lkdGglMjAlMkYlMkYlMjA4KSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRHRvcmNoX2RldmljZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>latents = torch.randn(
<span class="hljs-meta">... </span>    (batch_size, unet.config.in_channels, height // <span class="hljs-number">8</span>, width // <span class="hljs-number">8</span>),
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    device=torch_device,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ge=new $({props:{title:"Denoise the image",local:"denoise-the-image",headingTag:"h3"}}),je=new M({props:{code:"bGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwc2NoZWR1bGVyLmluaXRfbm9pc2Vfc2lnbWE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>latents = latents * scheduler.init_noise_sigma',wrap:!1}}),Ue=new M({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFzY2hlZHVsZXIuc2V0X3RpbWVzdGVwcyhudW1faW5mZXJlbmNlX3N0ZXBzKSUwQSUwQWZvciUyMHQlMjBpbiUyMHRxZG0oc2NoZWR1bGVyLnRpbWVzdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBleHBhbmQlMjB0aGUlMjBsYXRlbnRzJTIwaWYlMjB3ZSUyMGFyZSUyMGRvaW5nJTIwY2xhc3NpZmllci1mcmVlJTIwZ3VpZGFuY2UlMjB0byUyMGF2b2lkJTIwZG9pbmclMjB0d28lMjBmb3J3YXJkJTIwcGFzc2VzLiUwQSUyMCUyMCUyMCUyMGxhdGVudF9tb2RlbF9pbnB1dCUyMCUzRCUyMHRvcmNoLmNhdCglNUJsYXRlbnRzJTVEJTIwKiUyMDIpJTBBJTBBJTIwJTIwJTIwJTIwbGF0ZW50X21vZGVsX2lucHV0JTIwJTNEJTIwc2NoZWR1bGVyLnNjYWxlX21vZGVsX2lucHV0KGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHRpbWVzdGVwJTNEdCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwcmVkaWN0JTIwdGhlJTIwbm9pc2UlMjByZXNpZHVhbCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwdW5ldChsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTNEdGV4dF9lbWJlZGRpbmdzKS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBwZXJmb3JtJTIwZ3VpZGFuY2UlMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkX3VuY29uZCUyQyUyMG5vaXNlX3ByZWRfdGV4dCUyMCUzRCUyMG5vaXNlX3ByZWQuY2h1bmsoMiklMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwbm9pc2VfcHJlZF91bmNvbmQlMjAlMkIlMjBndWlkYW5jZV9zY2FsZSUyMColMjAobm9pc2VfcHJlZF90ZXh0JTIwLSUyMG5vaXNlX3ByZWRfdW5jb25kKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjB0aGUlMjBwcmV2aW91cyUyMG5vaXN5JTIwc2FtcGxlJTIweF90JTIwLSUzRSUyMHhfdC0xJTBBJTIwJTIwJTIwJTIwbGF0ZW50cyUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXNlX3ByZWQlMkMlMjB0JTJDJTIwbGF0ZW50cykucHJldl9zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(num_inference_steps)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tqdm(scheduler.timesteps):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># expand the latents if we are doing classifier-free guidance to avoid doing two forward passes.</span>
<span class="hljs-meta">... </span>    latent_model_input = torch.cat([latents] * <span class="hljs-number">2</span>)

<span class="hljs-meta">... </span>    latent_model_input = scheduler.scale_model_input(latent_model_input, timestep=t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># predict the noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = unet(latent_model_input, t, encoder_hidden_states=text_embeddings).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># perform guidance</span>
<span class="hljs-meta">... </span>    noise_pred_uncond, noise_pred_text = noise_pred.chunk(<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    noise_pred = noise_pred_uncond + guidance_scale * (noise_pred_text - noise_pred_uncond)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># compute the previous noisy sample x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    latents = scheduler.step(noise_pred, t, latents).prev_sample`,wrap:!1}}),Je=new $({props:{title:"Decode the image",local:"decode-the-image",headingTag:"h3"}}),Ce=new M({props:{code:"JTIzJTIwc2NhbGUlMjBhbmQlMjBkZWNvZGUlMjB0aGUlMjBpbWFnZSUyMGxhdGVudHMlMjB3aXRoJTIwdmFlJTBBbGF0ZW50cyUyMCUzRCUyMDElMjAlMkYlMjAwLjE4MjE1JTIwKiUyMGxhdGVudHMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB2YWUuZGVjb2RlKGxhdGVudHMpLnNhbXBsZQ==",highlighted:`<span class="hljs-comment"># scale and decode the image latents with vae</span>
latents = <span class="hljs-number">1</span> / <span class="hljs-number">0.18215</span> * latents
<span class="hljs-keyword">with</span> torch.no_grad():
    image = vae.decode(latents).sample`,wrap:!1}}),$e=new M({props:{code:"aW1hZ2UlMjAlM0QlMjAoaW1hZ2UlMjAlMkYlMjAyJTIwJTJCJTIwMC41KS5jbGFtcCgwJTJDJTIwMSkuc3F1ZWV6ZSgpJTBBaW1hZ2UlMjAlM0QlMjAoaW1hZ2UucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApJTIwKiUyMDI1NSkudG8odG9yY2gudWludDgpLmNwdSgpLm51bXB5KCklMEFpbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image / <span class="hljs-number">2</span> + <span class="hljs-number">0.5</span>).clamp(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = (image.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).to(torch.uint8).cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),ke=new $({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),We=new el({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/write_own_pipeline.md"}}),{c(){b=i("meta"),Be=a(),Re=i("p"),Xe=a(),o(k.$$.fragment),He=a(),o(_.$$.fragment),Se=a(),V=i("p"),V.innerHTML=pt,ze=a(),x=i("p"),x.textContent=mt,Ee=a(),o(G.$$.fragment),Le=a(),W=i("p"),W.textContent=ot,Fe=a(),o(I.$$.fragment),Qe=a(),y=i("div"),y.innerHTML=rt,Ye=a(),R=i("p"),R.textContent=dt,Ae=a(),N=i("p"),N.innerHTML=ct,De=a(),B=i("p"),B.textContent=ht,qe=a(),X=i("ol"),X.innerHTML=ut,Pe=a(),o(H.$$.fragment),Ke=a(),j=i("ol"),j.innerHTML=Mt,Oe=a(),o(S.$$.fragment),es=a(),w=i("ol"),w.innerHTML=ft,ss=a(),o(z.$$.fragment),ts=a(),T=i("ol"),T.innerHTML=bt,ls=a(),o(E.$$.fragment),as=a(),U=i("ol"),U.innerHTML=gt,ns=a(),o(L.$$.fragment),is=a(),F=i("p"),F.textContent=yt,ps=a(),J=i("ol"),J.innerHTML=jt,ms=a(),o(Q.$$.fragment),os=a(),Y=i("p"),Y.innerHTML=wt,rs=a(),A=i("p"),A.textContent=Tt,ds=a(),o(D.$$.fragment),cs=a(),q=i("p"),q.innerHTML=Ut,hs=a(),P=i("p"),P.textContent=Jt,us=a(),v=i("blockquote"),v.innerHTML=vt,Ms=a(),K=i("p"),K.innerHTML=Ct,fs=a(),o(O.$$.fragment),bs=a(),ee=i("p"),ee.innerHTML=Zt,gs=a(),o(se.$$.fragment),ys=a(),te=i("p"),te.textContent=$t,js=a(),o(le.$$.fragment),ws=a(),o(ae.$$.fragment),Ts=a(),ne=i("p"),ne.textContent=kt,Us=a(),C=i("blockquote"),C.innerHTML=_t,Js=a(),ie=i("p"),ie.textContent=Vt,vs=a(),o(pe.$$.fragment),Cs=a(),me=i("p"),me.textContent=xt,Zs=a(),o(oe.$$.fragment),$s=a(),re=i("p"),re.innerHTML=Gt,ks=a(),o(de.$$.fragment),_s=a(),ce=i("p"),ce.textContent=Wt,Vs=a(),o(he.$$.fragment),xs=a(),o(ue.$$.fragment),Gs=a(),Me=i("p"),Me.innerHTML=It,Ws=a(),g=i("blockquote"),Ie=i("p"),Ie.innerHTML=Rt,lt=a(),o(fe.$$.fragment),Is=a(),o(be.$$.fragment),Rs=a(),o(ge.$$.fragment),Ns=a(),ye=i("p"),ye.innerHTML=Nt,Bs=a(),o(je.$$.fragment),Xs=a(),we=i("p"),we.innerHTML=Bt,Hs=a(),Te=i("ol"),Te.innerHTML=Xt,Ss=a(),o(Ue.$$.fragment),zs=a(),o(Je.$$.fragment),Es=a(),ve=i("p"),ve.innerHTML=Ht,Ls=a(),o(Ce.$$.fragment),Fs=a(),Ze=i("p"),Ze.innerHTML=St,Qs=a(),o($e.$$.fragment),Ys=a(),Z=i("div"),Z.innerHTML=zt,As=a(),o(ke.$$.fragment),Ds=a(),_e=i("p"),_e.textContent=Et,qs=a(),Ve=i("p"),Ve.textContent=Lt,Ps=a(),xe=i("p"),xe.textContent=Ft,Ks=a(),Ge=i("ul"),Ge.innerHTML=Qt,Os=a(),o(We.$$.fragment),et=a(),Ne=i("p"),this.h()},l(e){const s=Kt("svelte-u9bgzb",document.head);b=p(s,"META",{name:!0,content:!0}),s.forEach(t),Be=n(e),Re=p(e,"P",{}),at(Re).forEach(t),Xe=n(e),r(k.$$.fragment,e),He=n(e),r(_.$$.fragment,e),Se=n(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-eguqi8"&&(V.innerHTML=pt),ze=n(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-5khcjg"&&(x.textContent=mt),Ee=n(e),r(G.$$.fragment,e),Le=n(e),W=p(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1o4pmop"&&(W.textContent=ot),Fe=n(e),r(I.$$.fragment,e),Qe=n(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(y)!=="svelte-ej6f4c"&&(y.innerHTML=rt),Ye=n(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-7b411q"&&(R.textContent=dt),Ae=n(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-rmfggx"&&(N.innerHTML=ct),De=n(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-mwr50"&&(B.textContent=ht),qe=n(e),X=p(e,"OL",{"data-svelte-h":!0}),m(X)!=="svelte-g7uo25"&&(X.innerHTML=ut),Pe=n(e),r(H.$$.fragment,e),Ke=n(e),j=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(j)!=="svelte-o7kbas"&&(j.innerHTML=Mt),Oe=n(e),r(S.$$.fragment,e),es=n(e),w=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(w)!=="svelte-1jnsvh9"&&(w.innerHTML=ft),ss=n(e),r(z.$$.fragment,e),ts=n(e),T=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(T)!=="svelte-1hrlquj"&&(T.innerHTML=bt),ls=n(e),r(E.$$.fragment,e),as=n(e),U=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(U)!=="svelte-1hivual"&&(U.innerHTML=gt),ns=n(e),r(L.$$.fragment,e),is=n(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-sdv3mq"&&(F.textContent=yt),ps=n(e),J=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(J)!=="svelte-1du7raq"&&(J.innerHTML=jt),ms=n(e),r(Q.$$.fragment,e),os=n(e),Y=p(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-t8ln8h"&&(Y.innerHTML=wt),rs=n(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-tru974"&&(A.textContent=Tt),ds=n(e),r(D.$$.fragment,e),cs=n(e),q=p(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1m5a7zj"&&(q.innerHTML=Ut),hs=n(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1yb6q1d"&&(P.textContent=Jt),us=n(e),v=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(v)!=="svelte-1nt4zqc"&&(v.innerHTML=vt),Ms=n(e),K=p(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-c54k9v"&&(K.innerHTML=Ct),fs=n(e),r(O.$$.fragment,e),bs=n(e),ee=p(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1mwizy3"&&(ee.innerHTML=Zt),gs=n(e),r(se.$$.fragment,e),ys=n(e),te=p(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1tr4efr"&&(te.textContent=$t),js=n(e),r(le.$$.fragment,e),ws=n(e),r(ae.$$.fragment,e),Ts=n(e),ne=p(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-ltx5oa"&&(ne.textContent=kt),Us=n(e),C=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(C)!=="svelte-mu3bu1"&&(C.innerHTML=_t),Js=n(e),ie=p(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-z6gwd8"&&(ie.textContent=Vt),vs=n(e),r(pe.$$.fragment,e),Cs=n(e),me=p(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-q7skg3"&&(me.textContent=xt),Zs=n(e),r(oe.$$.fragment,e),$s=n(e),re=p(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-e64ab9"&&(re.innerHTML=Gt),ks=n(e),r(de.$$.fragment,e),_s=n(e),ce=p(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-41mj23"&&(ce.textContent=Wt),Vs=n(e),r(he.$$.fragment,e),xs=n(e),r(ue.$$.fragment,e),Gs=n(e),Me=p(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1gyrog2"&&(Me.innerHTML=It),Ws=n(e),g=p(e,"BLOCKQUOTE",{class:!0});var tt=at(g);Ie=p(tt,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1c9k596"&&(Ie.innerHTML=Rt),lt=n(tt),r(fe.$$.fragment,tt),tt.forEach(t),Is=n(e),r(be.$$.fragment,e),Rs=n(e),r(ge.$$.fragment,e),Ns=n(e),ye=p(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1ltl3zx"&&(ye.innerHTML=Nt),Bs=n(e),r(je.$$.fragment,e),Xs=n(e),we=p(e,"P",{"data-svelte-h":!0}),m(we)!=="svelte-ul1wgx"&&(we.innerHTML=Bt),Hs=n(e),Te=p(e,"OL",{"data-svelte-h":!0}),m(Te)!=="svelte-ceuo6w"&&(Te.innerHTML=Xt),Ss=n(e),r(Ue.$$.fragment,e),zs=n(e),r(Je.$$.fragment,e),Es=n(e),ve=p(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-rzriwa"&&(ve.innerHTML=Ht),Ls=n(e),r(Ce.$$.fragment,e),Fs=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-6reqqn"&&(Ze.innerHTML=St),Qs=n(e),r($e.$$.fragment,e),Ys=n(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(Z)!=="svelte-1b0w6va"&&(Z.innerHTML=zt),As=n(e),r(ke.$$.fragment,e),Ds=n(e),_e=p(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-9a4wlz"&&(_e.textContent=Et),qs=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-u3h7jy"&&(Ve.textContent=Lt),Ps=n(e),xe=p(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-xe6tlx"&&(xe.textContent=Ft),Ks=n(e),Ge=p(e,"UL",{"data-svelte-h":!0}),m(Ge)!=="svelte-wmho1r"&&(Ge.innerHTML=Qt),Os=n(e),r(We.$$.fragment,e),et=n(e),Ne=p(e,"P",{}),at(Ne).forEach(t),this.h()},h(){f(b,"name","hf:doc:metadata"),f(b,"content",tl),f(y,"class","flex justify-center"),f(j,"start","2"),f(w,"start","3"),f(T,"start","4"),f(U,"start","5"),f(J,"start","6"),f(v,"class","tip"),f(C,"class","tip"),f(g,"class","tip"),f(Z,"class","flex justify-center")},m(e,s){nt(document.head,b),l(e,Be,s),l(e,Re,s),l(e,Xe,s),d(k,e,s),l(e,He,s),d(_,e,s),l(e,Se,s),l(e,V,s),l(e,ze,s),l(e,x,s),l(e,Ee,s),d(G,e,s),l(e,Le,s),l(e,W,s),l(e,Fe,s),d(I,e,s),l(e,Qe,s),l(e,y,s),l(e,Ye,s),l(e,R,s),l(e,Ae,s),l(e,N,s),l(e,De,s),l(e,B,s),l(e,qe,s),l(e,X,s),l(e,Pe,s),d(H,e,s),l(e,Ke,s),l(e,j,s),l(e,Oe,s),d(S,e,s),l(e,es,s),l(e,w,s),l(e,ss,s),d(z,e,s),l(e,ts,s),l(e,T,s),l(e,ls,s),d(E,e,s),l(e,as,s),l(e,U,s),l(e,ns,s),d(L,e,s),l(e,is,s),l(e,F,s),l(e,ps,s),l(e,J,s),l(e,ms,s),d(Q,e,s),l(e,os,s),l(e,Y,s),l(e,rs,s),l(e,A,s),l(e,ds,s),d(D,e,s),l(e,cs,s),l(e,q,s),l(e,hs,s),l(e,P,s),l(e,us,s),l(e,v,s),l(e,Ms,s),l(e,K,s),l(e,fs,s),d(O,e,s),l(e,bs,s),l(e,ee,s),l(e,gs,s),d(se,e,s),l(e,ys,s),l(e,te,s),l(e,js,s),d(le,e,s),l(e,ws,s),d(ae,e,s),l(e,Ts,s),l(e,ne,s),l(e,Us,s),l(e,C,s),l(e,Js,s),l(e,ie,s),l(e,vs,s),d(pe,e,s),l(e,Cs,s),l(e,me,s),l(e,Zs,s),d(oe,e,s),l(e,$s,s),l(e,re,s),l(e,ks,s),d(de,e,s),l(e,_s,s),l(e,ce,s),l(e,Vs,s),d(he,e,s),l(e,xs,s),d(ue,e,s),l(e,Gs,s),l(e,Me,s),l(e,Ws,s),l(e,g,s),nt(g,Ie),nt(g,lt),d(fe,g,null),l(e,Is,s),d(be,e,s),l(e,Rs,s),d(ge,e,s),l(e,Ns,s),l(e,ye,s),l(e,Bs,s),d(je,e,s),l(e,Xs,s),l(e,we,s),l(e,Hs,s),l(e,Te,s),l(e,Ss,s),d(Ue,e,s),l(e,zs,s),d(Je,e,s),l(e,Es,s),l(e,ve,s),l(e,Ls,s),d(Ce,e,s),l(e,Fs,s),l(e,Ze,s),l(e,Qs,s),d($e,e,s),l(e,Ys,s),l(e,Z,s),l(e,As,s),d(ke,e,s),l(e,Ds,s),l(e,_e,s),l(e,qs,s),l(e,Ve,s),l(e,Ps,s),l(e,xe,s),l(e,Ks,s),l(e,Ge,s),l(e,Os,s),d(We,e,s),l(e,et,s),l(e,Ne,s),st=!0},p:At,i(e){st||(c(k.$$.fragment,e),c(_.$$.fragment,e),c(G.$$.fragment,e),c(I.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(z.$$.fragment,e),c(E.$$.fragment,e),c(L.$$.fragment,e),c(Q.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(de.$$.fragment,e),c(he.$$.fragment,e),c(ue.$$.fragment,e),c(fe.$$.fragment,e),c(be.$$.fragment,e),c(ge.$$.fragment,e),c(je.$$.fragment,e),c(Ue.$$.fragment,e),c(Je.$$.fragment,e),c(Ce.$$.fragment,e),c($e.$$.fragment,e),c(ke.$$.fragment,e),c(We.$$.fragment,e),st=!0)},o(e){h(k.$$.fragment,e),h(_.$$.fragment,e),h(G.$$.fragment,e),h(I.$$.fragment,e),h(H.$$.fragment,e),h(S.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(L.$$.fragment,e),h(Q.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(oe.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(ge.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(Je.$$.fragment,e),h(Ce.$$.fragment,e),h($e.$$.fragment,e),h(ke.$$.fragment,e),h(We.$$.fragment,e),st=!1},d(e){e&&(t(Be),t(Re),t(Xe),t(He),t(Se),t(V),t(ze),t(x),t(Ee),t(Le),t(W),t(Fe),t(Qe),t(y),t(Ye),t(R),t(Ae),t(N),t(De),t(B),t(qe),t(X),t(Pe),t(Ke),t(j),t(Oe),t(es),t(w),t(ss),t(ts),t(T),t(ls),t(as),t(U),t(ns),t(is),t(F),t(ps),t(J),t(ms),t(os),t(Y),t(rs),t(A),t(ds),t(cs),t(q),t(hs),t(P),t(us),t(v),t(Ms),t(K),t(fs),t(bs),t(ee),t(gs),t(ys),t(te),t(js),t(ws),t(Ts),t(ne),t(Us),t(C),t(Js),t(ie),t(vs),t(Cs),t(me),t(Zs),t($s),t(re),t(ks),t(_s),t(ce),t(Vs),t(xs),t(Gs),t(Me),t(Ws),t(g),t(Is),t(Rs),t(Ns),t(ye),t(Bs),t(Xs),t(we),t(Hs),t(Te),t(Ss),t(zs),t(Es),t(ve),t(Ls),t(Fs),t(Ze),t(Qs),t(Ys),t(Z),t(As),t(Ds),t(_e),t(qs),t(Ve),t(Ps),t(xe),t(Ks),t(Ge),t(Os),t(et),t(Ne)),t(b),u(k,e),u(_,e),u(G,e),u(I,e),u(H,e),u(S,e),u(z,e),u(E,e),u(L,e),u(Q,e),u(D,e),u(O,e),u(se,e),u(le,e),u(ae,e),u(pe,e),u(oe,e),u(de,e),u(he,e),u(ue,e),u(fe),u(be,e),u(ge,e),u(je,e),u(Ue,e),u(Je,e),u(Ce,e),u($e,e),u(ke,e),u(We,e)}}}const tl='{"title":"Understanding pipelines, models and schedulers","local":"understanding-pipelines-models-and-schedulers","sections":[{"title":"Deconstruct a basic pipeline","local":"deconstruct-a-basic-pipeline","sections":[],"depth":2},{"title":"Deconstruct the Stable Diffusion pipeline","local":"deconstruct-the-stable-diffusion-pipeline","sections":[{"title":"Create text embeddings","local":"create-text-embeddings","sections":[],"depth":3},{"title":"Create random noise","local":"create-random-noise","sections":[],"depth":3},{"title":"Denoise the image","local":"denoise-the-image","sections":[],"depth":3},{"title":"Decode the image","local":"decode-the-image","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ll(it){return Dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends qt{constructor(b){super(),Pt(this,b,ll,sl,Yt,{})}}export{ol as component};
