import{s as ts,n as rs,o as os}from"../chunks/scheduler.888833de.js";import{S as ss,i as as,e as s,s as r,c as d,h as ns,a,d as n,b as o,f as _,g as m,j as u,k as v,l as t,m as I,n as p,t as g,o as l,p as f}from"../chunks/index.128ce987.js";import{D as b}from"../chunks/Docstring.23ed6b62.js";import{H as xt,E as is}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";function cs(bo){let T,$t,yt,wt,te,Tt,re,Io='The <code>VaeImageProcessor</code> provides a unified API for <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>s to prepare image inputs for VAE encoding and post-processing outputs once they’re decoded. This includes transformations such as resizing, normalization, and conversion between PIL Image, PyTorch, and NumPy arrays.',zt,oe,xo="All pipelines with <code>VaeImageProcessor</code> accept PIL Image, PyTorch tensor, or NumPy arrays as image inputs and return outputs based on the <code>output_type</code> argument by the user. You can pass encoded image latents directly to the pipeline and return latents from the pipeline as a specific output with the <code>output_type</code> argument (for example <code>output_type=&quot;latent&quot;</code>). This allows you to take the generated latents from one pipeline and pass it to another pipeline as input without leaving the latent space. It also makes it much easier to use multiple pipelines together by passing PyTorch tensors directly between different pipelines.",Lt,se,Dt,i,ae,hr,qe,yo="Image processor for VAE.",ur,z,ne,_r,Ge,Po="Applies an overlay of the mask and the inpainted image on the original image.",vr,L,ie,br,Be,$o="Create a mask.",Ir,D,ce,xr,je,wo="Applies Gaussian blur to an image.",yr,V,de,Pr,Se,To="Converts a given PIL image to grayscale.",$r,C,me,wr,Ye,zo="Converts a PIL image to RGB format.",Tr,k,pe,zr,Je,Lo="Denormalize an image array to [0,1].",Lr,A,ge,Dr,Ke,Do=`Finds a rectangular region that contains all masked ares in an image, and expands region to match the aspect
ratio of the original image; for example, if user drew mask in a 128x32 region, and the dimensions for
processing are 512x512, the region will be expanded to 128x128.`,Vr,N,le,Cr,Qe,Vo="Returns the height and width of the image, downscaled to the next integer multiple of <code>vae_scale_factor</code>.",kr,M,fe,Ar,Xe,Co="Normalize an image array to [-1,1].",Nr,E,he,Mr,Ze,ko="Convert a numpy image or a batch of images to a PIL image.",Er,O,ue,Or,et,Ao="Convert a NumPy image to a PyTorch tensor.",Wr,W,_e,Rr,tt,No="Convert a PIL image or a list of PIL images to NumPy arrays.",Hr,R,ve,Fr,rt,Mo="Postprocess the image output from tensor to <code>output_type</code>.",Ur,H,be,qr,ot,Eo="Preprocess the image input.",Gr,F,Ie,Br,st,Oo="Convert a PyTorch tensor to a NumPy image.",jr,U,xe,Sr,at,Wo="Resize image.",Vt,ye,Ct,Pe,Ro="The <code>InpaintProcessor</code> accepts <code>mask</code> and <code>image</code> inputs and process them together. Optionally, it can accept padding_mask_crop and apply mask overlay.",kt,P,$e,Yr,nt,Ho="Image processor for inpainting image and mask.",Jr,q,we,Kr,it,Fo="Postprocess the image, optionally apply mask overlay",Qr,G,Te,Xr,ct,Uo="Preprocess the image and mask.",At,ze,Nt,Le,qo="The <code>VaeImageProcessorLDM3D</code> accepts RGB and depth inputs and returns RGB and depth outputs.",Mt,x,De,Zr,dt,Go="Image processor for VAE LDM3D.",eo,B,Ve,to,mt,Bo="Convert a PIL image or a list of PIL images to NumPy arrays.",ro,j,Ce,oo,pt,jo="Convert a NumPy depth image or a batch of images to a list of PIL images.",so,S,ke,ao,gt,So="Convert a NumPy image or a batch of images to a list of PIL images.",no,Y,Ae,io,lt,Yo="Preprocess the image input. Accepted formats are PIL images, NumPy arrays, or PyTorch tensors.",co,J,Ne,mo,ft,Jo="Convert an RGB-like depth image to a depth map.",Et,Me,Ot,$,Ee,po,ht,Ko="Image processor for PixArt image resize and crop.",go,K,Oe,lo,ut,Qo="Returns the binned height and width based on the aspect ratio.",fo,Q,We,ho,_t,Xo="Resizes and crops a tensor of images to the specified dimensions.",Wt,Re,Rt,w,He,uo,vt,Zo="Image processor for IP Adapter image masks.",_o,X,Fe,vo,bt,es=`Downsamples the provided mask tensor to match the expected dimensions for scaled dot-product attention. If the
aspect ratio of the mask does not match the aspect ratio of the output image, a warning is issued.`,Ht,Ue,Ft,Pt,Ut;return te=new xt({props:{title:"VAE Image Processor",local:"vae-image-processor",headingTag:"h1"}}),se=new xt({props:{title:"VaeImageProcessor",local:"diffusers.image_processor.VaeImageProcessor",headingTag:"h2"}}),ae=new b({props:{name:"class diffusers.image_processor.VaeImageProcessor",anchor:"diffusers.image_processor.VaeImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"vae_scale_factor",val:": int = 8"},{name:"vae_latent_channels",val:": int = 4"},{name:"resample",val:": str = 'lanczos'"},{name:"reducing_gap",val:": int = None"},{name:"do_normalize",val:": bool = True"},{name:"do_binarize",val:": bool = False"},{name:"do_convert_rgb",val:": bool = False"},{name:"do_convert_grayscale",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to downscale the image&#x2019;s (height, width) dimensions to multiples of <code>vae_scale_factor</code>. Can accept
<code>height</code> and <code>width</code> arguments from <a href="/docs/diffusers/main/en/api/image_processor#diffusers.image_processor.VaeImageProcessor.preprocess">image_processor.VaeImageProcessor.preprocess()</a> method.`,name:"do_resize"},{anchor:"diffusers.image_processor.VaeImageProcessor.vae_scale_factor",description:`<strong>vae_scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>8</code>) &#x2014;
VAE scale factor. If <code>do_resize</code> is <code>True</code>, the image is automatically resized to multiples of this factor.`,name:"vae_scale_factor"},{anchor:"diffusers.image_processor.VaeImageProcessor.resample",description:`<strong>resample</strong> (<code>str</code>, <em>optional</em>, defaults to <code>lanczos</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"diffusers.image_processor.VaeImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image to [-1,1].`,name:"do_normalize"},{anchor:"diffusers.image_processor.VaeImageProcessor.do_binarize",description:`<strong>do_binarize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to binarize the image to 0/1.`,name:"do_binarize"},{anchor:"diffusers.image_processor.VaeImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>False</code>) &#x2014;
Whether to convert the images to RGB format.`,name:"do_convert_rgb"},{anchor:"diffusers.image_processor.VaeImageProcessor.do_convert_grayscale",description:`<strong>do_convert_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>False</code>) &#x2014;
Whether to convert the images to grayscale format.`,name:"do_convert_grayscale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L88"}}),ne=new b({props:{name:"apply_overlay",anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay",parameters:[{name:"mask",val:": Image"},{name:"init_image",val:": Image"},{name:"image",val:": Image"},{name:"crop_coords",val:": typing.Optional[typing.Tuple[int, int, int, int]] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay.mask",description:`<strong>mask</strong> (<code>PIL.Image.Image</code>) &#x2014;
The mask image that highlights regions to overlay.`,name:"mask"},{anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay.init_image",description:`<strong>init_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The original image to which the overlay is applied.`,name:"init_image"},{anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The image to overlay onto the original.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.apply_overlay.crop_coords",description:`<strong>crop_coords</strong> (<code>Tuple[int, int, int, int]</code>, <em>optional</em>) &#x2014;
Coordinates to crop the image. If provided, the image will be cropped accordingly.`,name:"crop_coords"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L794",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The final image with the overlay applied.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),ie=new b({props:{name:"binarize",anchor:"diffusers.image_processor.VaeImageProcessor.binarize",parameters:[{name:"image",val:": Image"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.binarize.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The image input, should be a PIL image.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L529",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The binarized image. Values less than 0.5 are set to 0, values greater than 0.5 are set to 1.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),ce=new b({props:{name:"blur",anchor:"diffusers.image_processor.VaeImageProcessor.blur",parameters:[{name:"image",val:": Image"},{name:"blur_factor",val:": int = 4"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.blur.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The PIL image to convert to grayscale.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L276",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The grayscale-converted PIL image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),de=new b({props:{name:"convert_to_grayscale",anchor:"diffusers.image_processor.VaeImageProcessor.convert_to_grayscale",parameters:[{name:"image",val:": Image"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.convert_to_grayscale.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The input image to convert.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L259",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image converted to grayscale.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),me=new b({props:{name:"convert_to_rgb",anchor:"diffusers.image_processor.VaeImageProcessor.convert_to_rgb",parameters:[{name:"image",val:": Image"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.convert_to_rgb.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
The PIL image to convert to RGB.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L242",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The RGB-converted PIL image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code></p>
`}}),pe=new b({props:{name:"denormalize",anchor:"diffusers.image_processor.VaeImageProcessor.denormalize",parameters:[{name:"images",val:": typing.Union[numpy.ndarray, torch.Tensor]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.denormalize.images",description:`<strong>images</strong> (<code>np.ndarray</code> or <code>torch.Tensor</code>) &#x2014;
The image array to denormalize.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L227",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The denormalized image array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code> or <code>torch.Tensor</code></p>
`}}),ge=new b({props:{name:"get_crop_region",anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region",parameters:[{name:"mask_image",val:": Image"},{name:"width",val:": int"},{name:"height",val:": int"},{name:"pad",val:" = 0"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region.mask_image",description:"<strong>mask_image</strong> (PIL.Image.Image) &#x2014; Mask image.",name:"mask_image"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region.width",description:"<strong>width</strong> (int) &#x2014; Width of the image to be processed.",name:"width"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region.height",description:"<strong>height</strong> (int) &#x2014; Height of the image to be processed.",name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_crop_region.pad",description:"<strong>pad</strong> (int, optional) &#x2014; Padding to be added to the crop region. Defaults to 0.",name:"pad"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L293",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(x1, y1, x2, y2) represent a rectangular region that contains all masked ares in an image and
matches the original aspect ratio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tuple</p>
`}}),le=new b({props:{name:"get_default_height_width",anchor:"diffusers.image_processor.VaeImageProcessor.get_default_height_width",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.get_default_height_width.image",description:`<strong>image</strong> (<code>Union[PIL.Image.Image, np.ndarray, torch.Tensor]</code>) &#x2014;
The image input, which can be a PIL image, NumPy array, or PyTorch tensor. If it is a NumPy array, it
should have shape <code>[batch, height, width]</code> or <code>[batch, height, width, channels]</code>. If it is a PyTorch
tensor, it should have shape <code>[batch, channels, height, width]</code>.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_default_height_width.height",description:`<strong>height</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The height of the preprocessed image. If <code>None</code>, the height of the <code>image</code> input will be used.`,name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessor.get_default_height_width.width",description:`<strong>width</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The width of the preprocessed image. If <code>None</code>, the width of the <code>image</code> input will be used.`,name:"width"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L566",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the height and width, both resized to the nearest integer multiple of
<code>vae_scale_factor</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[int, int]</code></p>
`}}),fe=new b({props:{name:"normalize",anchor:"diffusers.image_processor.VaeImageProcessor.normalize",parameters:[{name:"images",val:": typing.Union[numpy.ndarray, torch.Tensor]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.normalize.images",description:`<strong>images</strong> (<code>np.ndarray</code> or <code>torch.Tensor</code>) &#x2014;
The image array to normalize.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The normalized image array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code> or <code>torch.Tensor</code></p>
`}}),he=new b({props:{name:"numpy_to_pil",anchor:"diffusers.image_processor.VaeImageProcessor.numpy_to_pil",parameters:[{name:"images",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.numpy_to_pil.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
The image array to convert to PIL format.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of PIL images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[PIL.Image.Image]</code></p>
`}}),ue=new b({props:{name:"numpy_to_pt",anchor:"diffusers.image_processor.VaeImageProcessor.numpy_to_pt",parameters:[{name:"images",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.numpy_to_pt.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
The NumPy image array to convert to PyTorch format.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L177",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A PyTorch tensor representation of the images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),_e=new b({props:{name:"pil_to_numpy",anchor:"diffusers.image_processor.VaeImageProcessor.pil_to_numpy",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], PIL.Image.Image]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.pil_to_numpy.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code>) &#x2014;
The PIL image or list of images to convert to NumPy format.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L157",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A NumPy array representation of the images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),ve=new b({props:{name:"postprocess",anchor:"diffusers.image_processor.VaeImageProcessor.postprocess",parameters:[{name:"image",val:": Tensor"},{name:"output_type",val:": str = 'pil'"},{name:"do_denormalize",val:": typing.Optional[typing.List[bool]] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.postprocess.image",description:`<strong>image</strong> (<code>torch.Tensor</code>) &#x2014;
The image input, should be a pytorch tensor with shape <code>B x C x H x W</code>.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.postprocess.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>pil</code>) &#x2014;
The output type of the image, can be one of <code>pil</code>, <code>np</code>, <code>pt</code>, <code>latent</code>.`,name:"output_type"},{anchor:"diffusers.image_processor.VaeImageProcessor.postprocess.do_denormalize",description:`<strong>do_denormalize</strong> (<code>List[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to denormalize the image to [0,1]. If <code>None</code>, will use the value of <code>do_normalize</code> in the
<code>VaeImageProcessor</code> config.`,name:"do_denormalize"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L744",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The postprocessed image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code>, <code>np.ndarray</code> or <code>torch.Tensor</code></p>
`}}),be=new b({props:{name:"preprocess",anchor:"diffusers.image_processor.VaeImageProcessor.preprocess",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"resize_mode",val:": str = 'default'"},{name:"crops_coords",val:": typing.Optional[typing.Tuple[int, int, int, int]] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The image input, accepted formats are PIL images, NumPy arrays, PyTorch tensors; Also accept list of
supported formats.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The height in preprocessed image. If <code>None</code>, will use the <code>get_default_height_width()</code> to get default
height.`,name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.width",description:"<strong>width</strong> (<code>int</code>, <em>optional</em>) &#x2014;\nThe width in preprocessed. If <code>None</code>, will use get_default_height_width()` to get the default width.",name:"width"},{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.resize_mode",description:`<strong>resize_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>default</code>) &#x2014;
The resize mode, can be one of <code>default</code> or <code>fill</code>. If <code>default</code>, will resize the image to fit within
the specified width and height, and it may not maintaining the original aspect ratio. If <code>fill</code>, will
resize the image to fit within the specified width and height, maintaining the aspect ratio, and then
center the image within the dimensions, filling empty with data from image. If <code>crop</code>, will resize the
image to fit within the specified width and height, maintaining the aspect ratio, and then center the
image within the dimensions, cropping the excess. Note that resize_mode <code>fill</code> and <code>crop</code> are only
supported for PIL image input.`,name:"resize_mode"},{anchor:"diffusers.image_processor.VaeImageProcessor.preprocess.crops_coords",description:`<strong>crops_coords</strong> (<code>List[Tuple[int, int, int, int]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The crop coordinates for each image in the batch. If <code>None</code>, will not crop the image.`,name:"crops_coords"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L613",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The preprocessed image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Ie=new b({props:{name:"pt_to_numpy",anchor:"diffusers.image_processor.VaeImageProcessor.pt_to_numpy",parameters:[{name:"images",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.pt_to_numpy.images",description:`<strong>images</strong> (<code>torch.Tensor</code>) &#x2014;
The PyTorch tensor to convert to NumPy format.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L196",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A NumPy array representation of the images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),xe=new b({props:{name:"resize",anchor:"diffusers.image_processor.VaeImageProcessor.resize",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor]"},{name:"height",val:": int"},{name:"width",val:": int"},{name:"resize_mode",val:": str = 'default'"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessor.resize.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code> or <code>torch.Tensor</code>) &#x2014;
The image input, can be a PIL image, numpy array or pytorch tensor.`,name:"image"},{anchor:"diffusers.image_processor.VaeImageProcessor.resize.height",description:`<strong>height</strong> (<code>int</code>) &#x2014;
The height to resize to.`,name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessor.resize.width",description:`<strong>width</strong> (<code>int</code>) &#x2014;
The width to resize to.`,name:"width"},{anchor:"diffusers.image_processor.VaeImageProcessor.resize.resize_mode",description:`<strong>resize_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>default</code>) &#x2014;
The resize mode to use, can be one of <code>default</code> or <code>fill</code>. If <code>default</code>, will resize the image to fit
within the specified width and height, and it may not maintaining the original aspect ratio. If <code>fill</code>,
will resize the image to fit within the specified width and height, maintaining the aspect ratio, and
then center the image within the dimensions, filling empty with data from image. If <code>crop</code>, will resize
the image to fit within the specified width and height, maintaining the aspect ratio, and then center
the image within the dimensions, cropping the excess. Note that resize_mode <code>fill</code> and <code>crop</code> are only
supported for PIL image input.`,name:"resize_mode"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L468",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The resized image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PIL.Image.Image</code>, <code>np.ndarray</code> or <code>torch.Tensor</code></p>
`}}),ye=new xt({props:{title:"InpaintProcessor",local:"diffusers.image_processor.InpaintProcessor",headingTag:"h2"}}),$e=new b({props:{name:"class diffusers.image_processor.InpaintProcessor",anchor:"diffusers.image_processor.InpaintProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"vae_scale_factor",val:": int = 8"},{name:"vae_latent_channels",val:": int = 4"},{name:"resample",val:": str = 'lanczos'"},{name:"reducing_gap",val:": int = None"},{name:"do_normalize",val:": bool = True"},{name:"do_binarize",val:": bool = False"},{name:"do_convert_grayscale",val:": bool = False"},{name:"mask_do_normalize",val:": bool = False"},{name:"mask_do_binarize",val:": bool = True"},{name:"mask_do_convert_grayscale",val:": bool = True"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L842"}}),we=new b({props:{name:"postprocess",anchor:"diffusers.image_processor.InpaintProcessor.postprocess",parameters:[{name:"image",val:": Tensor"},{name:"output_type",val:": str = 'pil'"},{name:"original_image",val:": typing.Optional[PIL.Image.Image] = None"},{name:"original_mask",val:": typing.Optional[PIL.Image.Image] = None"},{name:"crops_coords",val:": typing.Optional[typing.Tuple[int, int, int, int]] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L943"}}),Te=new b({props:{name:"preprocess",anchor:"diffusers.image_processor.InpaintProcessor.preprocess",parameters:[{name:"image",val:": Image"},{name:"mask",val:": Image = None"},{name:"height",val:": int = None"},{name:"width",val:": int = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L887"}}),ze=new xt({props:{title:"VaeImageProcessorLDM3D",local:"diffusers.image_processor.VaeImageProcessorLDM3D",headingTag:"h2"}}),De=new b({props:{name:"class diffusers.image_processor.VaeImageProcessorLDM3D",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D",parameters:[{name:"do_resize",val:": bool = True"},{name:"vae_scale_factor",val:": int = 8"},{name:"resample",val:": str = 'lanczos'"},{name:"do_normalize",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to downscale the image&#x2019;s (height, width) dimensions to multiples of <code>vae_scale_factor</code>.`,name:"do_resize"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.vae_scale_factor",description:`<strong>vae_scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>8</code>) &#x2014;
VAE scale factor. If <code>do_resize</code> is <code>True</code>, the image is automatically resized to multiples of this factor.`,name:"vae_scale_factor"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.resample",description:`<strong>resample</strong> (<code>str</code>, <em>optional</em>, defaults to <code>lanczos</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image to [-1,1].`,name:"do_normalize"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L973"}}),Ve=new b({props:{name:"depth_pil_to_numpy",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.depth_pil_to_numpy",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], PIL.Image.Image]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.depth_pil_to_numpy.images",description:`<strong>images</strong> (<code>Union[List[PIL.Image.Image], PIL.Image.Image]</code>) &#x2014;
The input image or list of images to be converted.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1024",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A NumPy array of the converted images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),Ce=new b({props:{name:"numpy_to_depth",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.numpy_to_depth",parameters:[{name:"images",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.numpy_to_depth.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
The input NumPy array of depth images, which can be a single image or a batch.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1059",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of PIL images converted from the input NumPy depth images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[PIL.Image.Image]</code></p>
`}}),ke=new b({props:{name:"numpy_to_pil",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.numpy_to_pil",parameters:[{name:"images",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.numpy_to_pil.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
The input NumPy array of images, which can be a single image or a batch.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1000",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of PIL images converted from the input NumPy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[PIL.Image.Image]</code></p>
`}}),Ae=new b({props:{name:"preprocess",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess",parameters:[{name:"rgb",val:": typing.Union[torch.Tensor, PIL.Image.Image, numpy.ndarray]"},{name:"depth",val:": typing.Union[torch.Tensor, PIL.Image.Image, numpy.ndarray]"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"target_res",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.rgb",description:`<strong>rgb</strong> (<code>Union[torch.Tensor, PIL.Image.Image, np.ndarray]</code>) &#x2014;
The RGB input image, which can be a single image or a batch.`,name:"rgb"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.depth",description:`<strong>depth</strong> (<code>Union[torch.Tensor, PIL.Image.Image, np.ndarray]</code>) &#x2014;
The depth input image, which can be a single image or a batch.`,name:"depth"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.height",description:`<strong>height</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The desired height of the processed image. If <code>None</code>, defaults to the height of the input image.`,name:"height"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.width",description:`<strong>width</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The desired width of the processed image. If <code>None</code>, defaults to the width of the input image.`,name:"width"},{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.preprocess.target_res",description:`<strong>target_res</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Target resolution for resizing the images. If specified, overrides height and width.`,name:"target_res"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1137",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the processed RGB and depth images as PyTorch tensors.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[torch.Tensor, torch.Tensor]</code></p>
`}}),Ne=new b({props:{name:"rgblike_to_depthmap",anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.rgblike_to_depthmap",parameters:[{name:"image",val:": typing.Union[numpy.ndarray, torch.Tensor]"}],parametersDescription:[{anchor:"diffusers.image_processor.VaeImageProcessorLDM3D.rgblike_to_depthmap.image",description:`<strong>image</strong> (<code>Union[np.ndarray, torch.Tensor]</code>) &#x2014;
The RGB-like depth image to convert.`,name:"image"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1044",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The corresponding depth map.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[np.ndarray, torch.Tensor]</code></p>
`}}),Me=new xt({props:{title:"PixArtImageProcessor",local:"diffusers.image_processor.PixArtImageProcessor",headingTag:"h2"}}),Ee=new b({props:{name:"class diffusers.image_processor.PixArtImageProcessor",anchor:"diffusers.image_processor.PixArtImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"vae_scale_factor",val:": int = 8"},{name:"resample",val:": str = 'lanczos'"},{name:"do_normalize",val:": bool = True"},{name:"do_binarize",val:": bool = False"},{name:"do_convert_grayscale",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.image_processor.PixArtImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to downscale the image&#x2019;s (height, width) dimensions to multiples of <code>vae_scale_factor</code>. Can accept
<code>height</code> and <code>width</code> arguments from <a href="/docs/diffusers/main/en/api/image_processor#diffusers.image_processor.VaeImageProcessor.preprocess">image_processor.VaeImageProcessor.preprocess()</a> method.`,name:"do_resize"},{anchor:"diffusers.image_processor.PixArtImageProcessor.vae_scale_factor",description:`<strong>vae_scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>8</code>) &#x2014;
VAE scale factor. If <code>do_resize</code> is <code>True</code>, the image is automatically resized to multiples of this factor.`,name:"vae_scale_factor"},{anchor:"diffusers.image_processor.PixArtImageProcessor.resample",description:`<strong>resample</strong> (<code>str</code>, <em>optional</em>, defaults to <code>lanczos</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"diffusers.image_processor.PixArtImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image to [-1,1].`,name:"do_normalize"},{anchor:"diffusers.image_processor.PixArtImageProcessor.do_binarize",description:`<strong>do_binarize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to binarize the image to 0/1.`,name:"do_binarize"},{anchor:"diffusers.image_processor.PixArtImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>False</code>) &#x2014;
Whether to convert the images to RGB format.`,name:"do_convert_rgb"},{anchor:"diffusers.image_processor.PixArtImageProcessor.do_convert_grayscale",description:`<strong>do_convert_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>False</code>) &#x2014;
Whether to convert the images to grayscale format.`,name:"do_convert_grayscale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1357"}}),Oe=new b({props:{name:"classify_height_width_bin",anchor:"diffusers.image_processor.PixArtImageProcessor.classify_height_width_bin",parameters:[{name:"height",val:": int"},{name:"width",val:": int"},{name:"ratios",val:": dict"}],parametersDescription:[{anchor:"diffusers.image_processor.PixArtImageProcessor.classify_height_width_bin.height",description:"<strong>height</strong> (<code>int</code>) &#x2014; The height of the image.",name:"height"},{anchor:"diffusers.image_processor.PixArtImageProcessor.classify_height_width_bin.width",description:"<strong>width</strong> (<code>int</code>) &#x2014; The width of the image.",name:"width"},{anchor:"diffusers.image_processor.PixArtImageProcessor.classify_height_width_bin.ratios",description:"<strong>ratios</strong> (<code>dict</code>) &#x2014; A dictionary where keys are aspect ratios and values are tuples of (height, width).",name:"ratios"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1398",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The closest binned height and width.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[int, int]</code></p>
`}}),We=new b({props:{name:"resize_and_crop_tensor",anchor:"diffusers.image_processor.PixArtImageProcessor.resize_and_crop_tensor",parameters:[{name:"samples",val:": Tensor"},{name:"new_width",val:": int"},{name:"new_height",val:": int"}],parametersDescription:[{anchor:"diffusers.image_processor.PixArtImageProcessor.resize_and_crop_tensor.samples",description:`<strong>samples</strong> (<code>torch.Tensor</code>) &#x2014;
A tensor of shape (N, C, H, W) where N is the batch size, C is the number of channels, H is the height,
and W is the width.`,name:"samples"},{anchor:"diffusers.image_processor.PixArtImageProcessor.resize_and_crop_tensor.new_width",description:"<strong>new_width</strong> (<code>int</code>) &#x2014; The desired width of the output images.",name:"new_width"},{anchor:"diffusers.image_processor.PixArtImageProcessor.resize_and_crop_tensor.new_height",description:"<strong>new_height</strong> (<code>int</code>) &#x2014; The desired height of the output images.",name:"new_height"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1416",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor containing the resized and cropped images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Re=new xt({props:{title:"IPAdapterMaskProcessor",local:"diffusers.image_processor.IPAdapterMaskProcessor",headingTag:"h2"}}),He=new b({props:{name:"class diffusers.image_processor.IPAdapterMaskProcessor",anchor:"diffusers.image_processor.IPAdapterMaskProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"vae_scale_factor",val:": int = 8"},{name:"resample",val:": str = 'lanczos'"},{name:"do_normalize",val:": bool = False"},{name:"do_binarize",val:": bool = True"},{name:"do_convert_grayscale",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to downscale the image&#x2019;s (height, width) dimensions to multiples of <code>vae_scale_factor</code>.`,name:"do_resize"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.vae_scale_factor",description:`<strong>vae_scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>8</code>) &#x2014;
VAE scale factor. If <code>do_resize</code> is <code>True</code>, the image is automatically resized to multiples of this factor.`,name:"vae_scale_factor"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.resample",description:`<strong>resample</strong> (<code>str</code>, <em>optional</em>, defaults to <code>lanczos</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the image to [-1,1].`,name:"do_normalize"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.do_binarize",description:`<strong>do_binarize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to binarize the image to 0/1.`,name:"do_binarize"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.do_convert_grayscale",description:`<strong>do_convert_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to be <code>True</code>) &#x2014;
Whether to convert the images to grayscale format.`,name:"do_convert_grayscale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1253"}}),Fe=new b({props:{name:"downsample",anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample",parameters:[{name:"mask",val:": Tensor"},{name:"batch_size",val:": int"},{name:"num_queries",val:": int"},{name:"value_embed_dim",val:": int"}],parametersDescription:[{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample.mask",description:`<strong>mask</strong> (<code>torch.Tensor</code>) &#x2014;
The input mask tensor generated with <code>IPAdapterMaskProcessor.preprocess()</code>.`,name:"mask"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size.`,name:"batch_size"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample.num_queries",description:`<strong>num_queries</strong> (<code>int</code>) &#x2014;
The number of queries.`,name:"num_queries"},{anchor:"diffusers.image_processor.IPAdapterMaskProcessor.downsample.value_embed_dim",description:`<strong>value_embed_dim</strong> (<code>int</code>) &#x2014;
The dimensionality of the value embeddings.`,name:"value_embed_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/image_processor.py#L1294",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The downsampled mask tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Ue=new is({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/image_processor.md"}}),{c(){T=s("meta"),$t=r(),yt=s("p"),wt=r(),d(te.$$.fragment),Tt=r(),re=s("p"),re.innerHTML=Io,zt=r(),oe=s("p"),oe.innerHTML=xo,Lt=r(),d(se.$$.fragment),Dt=r(),i=s("div"),d(ae.$$.fragment),hr=r(),qe=s("p"),qe.textContent=yo,ur=r(),z=s("div"),d(ne.$$.fragment),_r=r(),Ge=s("p"),Ge.textContent=Po,vr=r(),L=s("div"),d(ie.$$.fragment),br=r(),Be=s("p"),Be.textContent=$o,Ir=r(),D=s("div"),d(ce.$$.fragment),xr=r(),je=s("p"),je.textContent=wo,yr=r(),V=s("div"),d(de.$$.fragment),Pr=r(),Se=s("p"),Se.textContent=To,$r=r(),C=s("div"),d(me.$$.fragment),wr=r(),Ye=s("p"),Ye.textContent=zo,Tr=r(),k=s("div"),d(pe.$$.fragment),zr=r(),Je=s("p"),Je.textContent=Lo,Lr=r(),A=s("div"),d(ge.$$.fragment),Dr=r(),Ke=s("p"),Ke.textContent=Do,Vr=r(),N=s("div"),d(le.$$.fragment),Cr=r(),Qe=s("p"),Qe.innerHTML=Vo,kr=r(),M=s("div"),d(fe.$$.fragment),Ar=r(),Xe=s("p"),Xe.textContent=Co,Nr=r(),E=s("div"),d(he.$$.fragment),Mr=r(),Ze=s("p"),Ze.textContent=ko,Er=r(),O=s("div"),d(ue.$$.fragment),Or=r(),et=s("p"),et.textContent=Ao,Wr=r(),W=s("div"),d(_e.$$.fragment),Rr=r(),tt=s("p"),tt.textContent=No,Hr=r(),R=s("div"),d(ve.$$.fragment),Fr=r(),rt=s("p"),rt.innerHTML=Mo,Ur=r(),H=s("div"),d(be.$$.fragment),qr=r(),ot=s("p"),ot.textContent=Eo,Gr=r(),F=s("div"),d(Ie.$$.fragment),Br=r(),st=s("p"),st.textContent=Oo,jr=r(),U=s("div"),d(xe.$$.fragment),Sr=r(),at=s("p"),at.textContent=Wo,Vt=r(),d(ye.$$.fragment),Ct=r(),Pe=s("p"),Pe.innerHTML=Ro,kt=r(),P=s("div"),d($e.$$.fragment),Yr=r(),nt=s("p"),nt.textContent=Ho,Jr=r(),q=s("div"),d(we.$$.fragment),Kr=r(),it=s("p"),it.textContent=Fo,Qr=r(),G=s("div"),d(Te.$$.fragment),Xr=r(),ct=s("p"),ct.textContent=Uo,At=r(),d(ze.$$.fragment),Nt=r(),Le=s("p"),Le.innerHTML=qo,Mt=r(),x=s("div"),d(De.$$.fragment),Zr=r(),dt=s("p"),dt.textContent=Go,eo=r(),B=s("div"),d(Ve.$$.fragment),to=r(),mt=s("p"),mt.textContent=Bo,ro=r(),j=s("div"),d(Ce.$$.fragment),oo=r(),pt=s("p"),pt.textContent=jo,so=r(),S=s("div"),d(ke.$$.fragment),ao=r(),gt=s("p"),gt.textContent=So,no=r(),Y=s("div"),d(Ae.$$.fragment),io=r(),lt=s("p"),lt.textContent=Yo,co=r(),J=s("div"),d(Ne.$$.fragment),mo=r(),ft=s("p"),ft.textContent=Jo,Et=r(),d(Me.$$.fragment),Ot=r(),$=s("div"),d(Ee.$$.fragment),po=r(),ht=s("p"),ht.textContent=Ko,go=r(),K=s("div"),d(Oe.$$.fragment),lo=r(),ut=s("p"),ut.textContent=Qo,fo=r(),Q=s("div"),d(We.$$.fragment),ho=r(),_t=s("p"),_t.textContent=Xo,Wt=r(),d(Re.$$.fragment),Rt=r(),w=s("div"),d(He.$$.fragment),uo=r(),vt=s("p"),vt.textContent=Zo,_o=r(),X=s("div"),d(Fe.$$.fragment),vo=r(),bt=s("p"),bt.textContent=es,Ht=r(),d(Ue.$$.fragment),Ft=r(),Pt=s("p"),this.h()},l(e){const c=ns("svelte-u9bgzb",document.head);T=a(c,"META",{name:!0,content:!0}),c.forEach(n),$t=o(e),yt=a(e,"P",{}),_(yt).forEach(n),wt=o(e),m(te.$$.fragment,e),Tt=o(e),re=a(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-lut875"&&(re.innerHTML=Io),zt=o(e),oe=a(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-15xkwv1"&&(oe.innerHTML=xo),Lt=o(e),m(se.$$.fragment,e),Dt=o(e),i=a(e,"DIV",{class:!0});var h=_(i);m(ae.$$.fragment,h),hr=o(h),qe=a(h,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-20k7u4"&&(qe.textContent=yo),ur=o(h),z=a(h,"DIV",{class:!0});var qt=_(z);m(ne.$$.fragment,qt),_r=o(qt),Ge=a(qt,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-1rfnp0c"&&(Ge.textContent=Po),qt.forEach(n),vr=o(h),L=a(h,"DIV",{class:!0});var Gt=_(L);m(ie.$$.fragment,Gt),br=o(Gt),Be=a(Gt,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-1jdqg5n"&&(Be.textContent=$o),Gt.forEach(n),Ir=o(h),D=a(h,"DIV",{class:!0});var Bt=_(D);m(ce.$$.fragment,Bt),xr=o(Bt),je=a(Bt,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1l3ylqr"&&(je.textContent=wo),Bt.forEach(n),yr=o(h),V=a(h,"DIV",{class:!0});var jt=_(V);m(de.$$.fragment,jt),Pr=o(jt),Se=a(jt,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-1byxcdi"&&(Se.textContent=To),jt.forEach(n),$r=o(h),C=a(h,"DIV",{class:!0});var St=_(C);m(me.$$.fragment,St),wr=o(St),Ye=a(St,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-ckvlrc"&&(Ye.textContent=zo),St.forEach(n),Tr=o(h),k=a(h,"DIV",{class:!0});var Yt=_(k);m(pe.$$.fragment,Yt),zr=o(Yt),Je=a(Yt,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-ipi2rr"&&(Je.textContent=Lo),Yt.forEach(n),Lr=o(h),A=a(h,"DIV",{class:!0});var Jt=_(A);m(ge.$$.fragment,Jt),Dr=o(Jt),Ke=a(Jt,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-1gkaazy"&&(Ke.textContent=Do),Jt.forEach(n),Vr=o(h),N=a(h,"DIV",{class:!0});var Kt=_(N);m(le.$$.fragment,Kt),Cr=o(Kt),Qe=a(Kt,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-gf87un"&&(Qe.innerHTML=Vo),Kt.forEach(n),kr=o(h),M=a(h,"DIV",{class:!0});var Qt=_(M);m(fe.$$.fragment,Qt),Ar=o(Qt),Xe=a(Qt,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-1l17iqw"&&(Xe.textContent=Co),Qt.forEach(n),Nr=o(h),E=a(h,"DIV",{class:!0});var Xt=_(E);m(he.$$.fragment,Xt),Mr=o(Xt),Ze=a(Xt,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-49eriv"&&(Ze.textContent=ko),Xt.forEach(n),Er=o(h),O=a(h,"DIV",{class:!0});var Zt=_(O);m(ue.$$.fragment,Zt),Or=o(Zt),et=a(Zt,"P",{"data-svelte-h":!0}),u(et)!=="svelte-uauale"&&(et.textContent=Ao),Zt.forEach(n),Wr=o(h),W=a(h,"DIV",{class:!0});var er=_(W);m(_e.$$.fragment,er),Rr=o(er),tt=a(er,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-x3z8ka"&&(tt.textContent=No),er.forEach(n),Hr=o(h),R=a(h,"DIV",{class:!0});var tr=_(R);m(ve.$$.fragment,tr),Fr=o(tr),rt=a(tr,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-m705s9"&&(rt.innerHTML=Mo),tr.forEach(n),Ur=o(h),H=a(h,"DIV",{class:!0});var rr=_(H);m(be.$$.fragment,rr),qr=o(rr),ot=a(rr,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-1p2bpse"&&(ot.textContent=Eo),rr.forEach(n),Gr=o(h),F=a(h,"DIV",{class:!0});var or=_(F);m(Ie.$$.fragment,or),Br=o(or),st=a(or,"P",{"data-svelte-h":!0}),u(st)!=="svelte-1acncdu"&&(st.textContent=Oo),or.forEach(n),jr=o(h),U=a(h,"DIV",{class:!0});var sr=_(U);m(xe.$$.fragment,sr),Sr=o(sr),at=a(sr,"P",{"data-svelte-h":!0}),u(at)!=="svelte-si84j5"&&(at.textContent=Wo),sr.forEach(n),h.forEach(n),Vt=o(e),m(ye.$$.fragment,e),Ct=o(e),Pe=a(e,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-1v7z9kv"&&(Pe.innerHTML=Ro),kt=o(e),P=a(e,"DIV",{class:!0});var Z=_(P);m($e.$$.fragment,Z),Yr=o(Z),nt=a(Z,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-1oe2yi5"&&(nt.textContent=Ho),Jr=o(Z),q=a(Z,"DIV",{class:!0});var ar=_(q);m(we.$$.fragment,ar),Kr=o(ar),it=a(ar,"P",{"data-svelte-h":!0}),u(it)!=="svelte-1bt74bm"&&(it.textContent=Fo),ar.forEach(n),Qr=o(Z),G=a(Z,"DIV",{class:!0});var nr=_(G);m(Te.$$.fragment,nr),Xr=o(nr),ct=a(nr,"P",{"data-svelte-h":!0}),u(ct)!=="svelte-8pqlt"&&(ct.textContent=Uo),nr.forEach(n),Z.forEach(n),At=o(e),m(ze.$$.fragment,e),Nt=o(e),Le=a(e,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-12yfhhz"&&(Le.innerHTML=qo),Mt=o(e),x=a(e,"DIV",{class:!0});var y=_(x);m(De.$$.fragment,y),Zr=o(y),dt=a(y,"P",{"data-svelte-h":!0}),u(dt)!=="svelte-bz065s"&&(dt.textContent=Go),eo=o(y),B=a(y,"DIV",{class:!0});var ir=_(B);m(Ve.$$.fragment,ir),to=o(ir),mt=a(ir,"P",{"data-svelte-h":!0}),u(mt)!=="svelte-x3z8ka"&&(mt.textContent=Bo),ir.forEach(n),ro=o(y),j=a(y,"DIV",{class:!0});var cr=_(j);m(Ce.$$.fragment,cr),oo=o(cr),pt=a(cr,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-taiq20"&&(pt.textContent=jo),cr.forEach(n),so=o(y),S=a(y,"DIV",{class:!0});var dr=_(S);m(ke.$$.fragment,dr),ao=o(dr),gt=a(dr,"P",{"data-svelte-h":!0}),u(gt)!=="svelte-6xu3xh"&&(gt.textContent=So),dr.forEach(n),no=o(y),Y=a(y,"DIV",{class:!0});var mr=_(Y);m(Ae.$$.fragment,mr),io=o(mr),lt=a(mr,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-jw9t5f"&&(lt.textContent=Yo),mr.forEach(n),co=o(y),J=a(y,"DIV",{class:!0});var pr=_(J);m(Ne.$$.fragment,pr),mo=o(pr),ft=a(pr,"P",{"data-svelte-h":!0}),u(ft)!=="svelte-8ahhcq"&&(ft.textContent=Jo),pr.forEach(n),y.forEach(n),Et=o(e),m(Me.$$.fragment,e),Ot=o(e),$=a(e,"DIV",{class:!0});var ee=_($);m(Ee.$$.fragment,ee),po=o(ee),ht=a(ee,"P",{"data-svelte-h":!0}),u(ht)!=="svelte-saajey"&&(ht.textContent=Ko),go=o(ee),K=a(ee,"DIV",{class:!0});var gr=_(K);m(Oe.$$.fragment,gr),lo=o(gr),ut=a(gr,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-1vfwv9u"&&(ut.textContent=Qo),gr.forEach(n),fo=o(ee),Q=a(ee,"DIV",{class:!0});var lr=_(Q);m(We.$$.fragment,lr),ho=o(lr),_t=a(lr,"P",{"data-svelte-h":!0}),u(_t)!=="svelte-izj9xl"&&(_t.textContent=Xo),lr.forEach(n),ee.forEach(n),Wt=o(e),m(Re.$$.fragment,e),Rt=o(e),w=a(e,"DIV",{class:!0});var It=_(w);m(He.$$.fragment,It),uo=o(It),vt=a(It,"P",{"data-svelte-h":!0}),u(vt)!=="svelte-mxmwf6"&&(vt.textContent=Zo),_o=o(It),X=a(It,"DIV",{class:!0});var fr=_(X);m(Fe.$$.fragment,fr),vo=o(fr),bt=a(fr,"P",{"data-svelte-h":!0}),u(bt)!=="svelte-1jm7ypm"&&(bt.textContent=es),fr.forEach(n),It.forEach(n),Ht=o(e),m(Ue.$$.fragment,e),Ft=o(e),Pt=a(e,"P",{}),_(Pt).forEach(n),this.h()},h(){v(T,"name","hf:doc:metadata"),v(T,"content",ds),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,T),I(e,$t,c),I(e,yt,c),I(e,wt,c),p(te,e,c),I(e,Tt,c),I(e,re,c),I(e,zt,c),I(e,oe,c),I(e,Lt,c),p(se,e,c),I(e,Dt,c),I(e,i,c),p(ae,i,null),t(i,hr),t(i,qe),t(i,ur),t(i,z),p(ne,z,null),t(z,_r),t(z,Ge),t(i,vr),t(i,L),p(ie,L,null),t(L,br),t(L,Be),t(i,Ir),t(i,D),p(ce,D,null),t(D,xr),t(D,je),t(i,yr),t(i,V),p(de,V,null),t(V,Pr),t(V,Se),t(i,$r),t(i,C),p(me,C,null),t(C,wr),t(C,Ye),t(i,Tr),t(i,k),p(pe,k,null),t(k,zr),t(k,Je),t(i,Lr),t(i,A),p(ge,A,null),t(A,Dr),t(A,Ke),t(i,Vr),t(i,N),p(le,N,null),t(N,Cr),t(N,Qe),t(i,kr),t(i,M),p(fe,M,null),t(M,Ar),t(M,Xe),t(i,Nr),t(i,E),p(he,E,null),t(E,Mr),t(E,Ze),t(i,Er),t(i,O),p(ue,O,null),t(O,Or),t(O,et),t(i,Wr),t(i,W),p(_e,W,null),t(W,Rr),t(W,tt),t(i,Hr),t(i,R),p(ve,R,null),t(R,Fr),t(R,rt),t(i,Ur),t(i,H),p(be,H,null),t(H,qr),t(H,ot),t(i,Gr),t(i,F),p(Ie,F,null),t(F,Br),t(F,st),t(i,jr),t(i,U),p(xe,U,null),t(U,Sr),t(U,at),I(e,Vt,c),p(ye,e,c),I(e,Ct,c),I(e,Pe,c),I(e,kt,c),I(e,P,c),p($e,P,null),t(P,Yr),t(P,nt),t(P,Jr),t(P,q),p(we,q,null),t(q,Kr),t(q,it),t(P,Qr),t(P,G),p(Te,G,null),t(G,Xr),t(G,ct),I(e,At,c),p(ze,e,c),I(e,Nt,c),I(e,Le,c),I(e,Mt,c),I(e,x,c),p(De,x,null),t(x,Zr),t(x,dt),t(x,eo),t(x,B),p(Ve,B,null),t(B,to),t(B,mt),t(x,ro),t(x,j),p(Ce,j,null),t(j,oo),t(j,pt),t(x,so),t(x,S),p(ke,S,null),t(S,ao),t(S,gt),t(x,no),t(x,Y),p(Ae,Y,null),t(Y,io),t(Y,lt),t(x,co),t(x,J),p(Ne,J,null),t(J,mo),t(J,ft),I(e,Et,c),p(Me,e,c),I(e,Ot,c),I(e,$,c),p(Ee,$,null),t($,po),t($,ht),t($,go),t($,K),p(Oe,K,null),t(K,lo),t(K,ut),t($,fo),t($,Q),p(We,Q,null),t(Q,ho),t(Q,_t),I(e,Wt,c),p(Re,e,c),I(e,Rt,c),I(e,w,c),p(He,w,null),t(w,uo),t(w,vt),t(w,_o),t(w,X),p(Fe,X,null),t(X,vo),t(X,bt),I(e,Ht,c),p(Ue,e,c),I(e,Ft,c),I(e,Pt,c),Ut=!0},p:rs,i(e){Ut||(g(te.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(ie.$$.fragment,e),g(ce.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(ge.$$.fragment,e),g(le.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(Ie.$$.fragment,e),g(xe.$$.fragment,e),g(ye.$$.fragment,e),g($e.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(ze.$$.fragment,e),g(De.$$.fragment,e),g(Ve.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),g(Ae.$$.fragment,e),g(Ne.$$.fragment,e),g(Me.$$.fragment,e),g(Ee.$$.fragment,e),g(Oe.$$.fragment,e),g(We.$$.fragment,e),g(Re.$$.fragment,e),g(He.$$.fragment,e),g(Fe.$$.fragment,e),g(Ue.$$.fragment,e),Ut=!0)},o(e){l(te.$$.fragment,e),l(se.$$.fragment,e),l(ae.$$.fragment,e),l(ne.$$.fragment,e),l(ie.$$.fragment,e),l(ce.$$.fragment,e),l(de.$$.fragment,e),l(me.$$.fragment,e),l(pe.$$.fragment,e),l(ge.$$.fragment,e),l(le.$$.fragment,e),l(fe.$$.fragment,e),l(he.$$.fragment,e),l(ue.$$.fragment,e),l(_e.$$.fragment,e),l(ve.$$.fragment,e),l(be.$$.fragment,e),l(Ie.$$.fragment,e),l(xe.$$.fragment,e),l(ye.$$.fragment,e),l($e.$$.fragment,e),l(we.$$.fragment,e),l(Te.$$.fragment,e),l(ze.$$.fragment,e),l(De.$$.fragment,e),l(Ve.$$.fragment,e),l(Ce.$$.fragment,e),l(ke.$$.fragment,e),l(Ae.$$.fragment,e),l(Ne.$$.fragment,e),l(Me.$$.fragment,e),l(Ee.$$.fragment,e),l(Oe.$$.fragment,e),l(We.$$.fragment,e),l(Re.$$.fragment,e),l(He.$$.fragment,e),l(Fe.$$.fragment,e),l(Ue.$$.fragment,e),Ut=!1},d(e){e&&(n($t),n(yt),n(wt),n(Tt),n(re),n(zt),n(oe),n(Lt),n(Dt),n(i),n(Vt),n(Ct),n(Pe),n(kt),n(P),n(At),n(Nt),n(Le),n(Mt),n(x),n(Et),n(Ot),n($),n(Wt),n(Rt),n(w),n(Ht),n(Ft),n(Pt)),n(T),f(te,e),f(se,e),f(ae),f(ne),f(ie),f(ce),f(de),f(me),f(pe),f(ge),f(le),f(fe),f(he),f(ue),f(_e),f(ve),f(be),f(Ie),f(xe),f(ye,e),f($e),f(we),f(Te),f(ze,e),f(De),f(Ve),f(Ce),f(ke),f(Ae),f(Ne),f(Me,e),f(Ee),f(Oe),f(We),f(Re,e),f(He),f(Fe),f(Ue,e)}}}const ds='{"title":"VAE Image Processor","local":"vae-image-processor","sections":[{"title":"VaeImageProcessor","local":"diffusers.image_processor.VaeImageProcessor","sections":[],"depth":2},{"title":"InpaintProcessor","local":"diffusers.image_processor.InpaintProcessor","sections":[],"depth":2},{"title":"VaeImageProcessorLDM3D","local":"diffusers.image_processor.VaeImageProcessorLDM3D","sections":[],"depth":2},{"title":"PixArtImageProcessor","local":"diffusers.image_processor.PixArtImageProcessor","sections":[],"depth":2},{"title":"IPAdapterMaskProcessor","local":"diffusers.image_processor.IPAdapterMaskProcessor","sections":[],"depth":2}],"depth":1}';function ms(bo){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends ss{constructor(T){super(),as(this,T,ms,cs,ts,{})}}export{hs as component};
