import{s as En,o as Hn,n as jt}from"../chunks/scheduler.888833de.js";import{S as zn,i as qn,e as a,s as o,c as f,h as Ln,a as r,d as i,b as n,f as V,j as u,g as h,k as J,w as Qn,l as t,m,n as _,t as b,o as y,p as v}from"../chunks/index.128ce987.js";import{D as C}from"../chunks/Docstring.23ed6b62.js";import{C as qe}from"../chunks/CodeBlock.37df032e.js";import{E as ro}from"../chunks/ExampleCodeBlock.6d7ae280.js";import{H as ze,E as Sn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.76e16928.js";import{H as An,a as Fn}from"../chunks/HfOption.79a0a3f5.js";function Dn(G){let l,T='Refer to the <a href="../../optimization/memory">Reduce memory usage</a> guide for more details about the various memory saving techniques.',g,p,c="The quantized CogVideoX 5B model below requires ~16GB of VRAM.",s,w,j;return w=new qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline, AutoModel
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-comment"># quantize weights to int8 with torchao</span>
pipeline_quant_config = PipelineQuantizationConfig(
  quant_backend=<span class="hljs-string">&quot;torchao&quot;</span>,
  quant_kwargs={<span class="hljs-string">&quot;quant_type&quot;</span>: <span class="hljs-string">&quot;int8wo&quot;</span>},
  components_to_quantize=<span class="hljs-string">&quot;transformer&quot;</span>
)

<span class="hljs-comment"># fp8 layerwise weight-casting</span>
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    torch_dtype=torch.bfloat16
)
transformer.enable_layerwise_casting(
    storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16
)

pipeline = CogVideoXPipeline.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>,
    transformer=transformer,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># model-offloading</span>
pipeline.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;&quot;&quot;
A detailed wooden toy ship with intricately carved masts and sails is seen gliding smoothly over a plush, blue carpet that mimics the waves of the sea. 
The ship&#x27;s hull is painted a rich brown, with tiny windows. The carpet, soft and textured, provides a perfect backdrop, resembling an oceanic expanse. 
Surrounding the ship are various other toys and children&#x27;s items, hinting at a playful environment. The scene captures the innocence and imagination of childhood, 
with the toy ship&#x27;s journey symbolizing endless adventures in a whimsical, indoor setting.
&quot;&quot;&quot;</span>

video = pipeline(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">6</span>,
    num_inference_steps=<span class="hljs-number">50</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){l=a("p"),l.innerHTML=T,g=o(),p=a("p"),p.textContent=c,s=o(),f(w.$$.fragment)},l(M){l=r(M,"P",{"data-svelte-h":!0}),u(l)!=="svelte-iowzkr"&&(l.innerHTML=T),g=n(M),p=r(M,"P",{"data-svelte-h":!0}),u(p)!=="svelte-1ceufi"&&(p.textContent=c),s=n(M),h(w.$$.fragment,M)},m(M,x){m(M,l,x),m(M,g,x),m(M,p,x),m(M,s,x),_(w,M,x),j=!0},p:jt,i(M){j||(b(w.$$.fragment,M),j=!0)},o(M){y(w.$$.fragment,M),j=!1},d(M){M&&(i(l),i(g),i(p),i(s)),v(w,M)}}}function On(G){let l,T='<a href="../../optimization/fp16#torchcompile">Compilation</a> is slow the first time but subsequent calls to the pipeline are faster.',g,p,c="The average inference time with torch.compile on a 80GB A100 is 76.27 seconds compared to 96.89 seconds for an uncompiled model.",s,w,j;return w=new qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipeline = CogVideoXPipeline.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># torch.compile</span>
pipeline.transformer.to(memory_format=torch.channels_last)
pipeline.transformer = torch.<span class="hljs-built_in">compile</span>(
    pipeline.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>
)

prompt = <span class="hljs-string">&quot;&quot;&quot;
A detailed wooden toy ship with intricately carved masts and sails is seen gliding smoothly over a plush, blue carpet that mimics the waves of the sea. 
The ship&#x27;s hull is painted a rich brown, with tiny windows. The carpet, soft and textured, provides a perfect backdrop, resembling an oceanic expanse. 
Surrounding the ship are various other toys and children&#x27;s items, hinting at a playful environment. The scene captures the innocence and imagination of childhood, 
with the toy ship&#x27;s journey symbolizing endless adventures in a whimsical, indoor setting.
&quot;&quot;&quot;</span>

video = pipeline(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">6</span>,
    num_inference_steps=<span class="hljs-number">50</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){l=a("p"),l.innerHTML=T,g=o(),p=a("p"),p.textContent=c,s=o(),f(w.$$.fragment)},l(M){l=r(M,"P",{"data-svelte-h":!0}),u(l)!=="svelte-dcc01q"&&(l.innerHTML=T),g=n(M),p=r(M,"P",{"data-svelte-h":!0}),u(p)!=="svelte-n9kv5l"&&(p.textContent=c),s=n(M),h(w.$$.fragment,M)},m(M,x){m(M,l,x),m(M,g,x),m(M,p,x),m(M,s,x),_(w,M,x),j=!0},p:jt,i(M){j||(b(w.$$.fragment,M),j=!0)},o(M){y(w.$$.fragment,M),j=!1},d(M){M&&(i(l),i(g),i(p),i(s)),v(w,M)}}}function Kn(G){let l,T,g,p;return l=new Fn({props:{id:"usage",option:"memory",$$slots:{default:[Dn]},$$scope:{ctx:G}}}),g=new Fn({props:{id:"usage",option:"inference speed",$$slots:{default:[On]},$$scope:{ctx:G}}}),{c(){f(l.$$.fragment),T=o(),f(g.$$.fragment)},l(c){h(l.$$.fragment,c),T=n(c),h(g.$$.fragment,c)},m(c,s){_(l,c,s),m(c,T,s),_(g,c,s),p=!0},p(c,s){const w={};s&2&&(w.$$scope={dirty:s,ctx:c}),l.$set(w);const j={};s&2&&(j.$$scope={dirty:s,ctx:c}),g.$set(j)},i(c){p||(b(l.$$.fragment,c),b(g.$$.fragment,c),p=!0)},o(c){y(l.$$.fragment,c),y(g.$$.fragment,c),p=!1},d(c){c&&i(T),v(l,c),v(g,c)}}}function es(G){let l,T="Examples:",g,p,c;return p=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBJTIzJTIwTW9kZWxzJTNBJTIwJTIyVEhVRE0lMkZDb2dWaWRlb1gtMmIlMjIlMjBvciUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTViJTIyJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJUSFVETSUyRkNvZ1ZpZGVvWC0yYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHBhbmRhJTJDJTIwZHJlc3NlZCUyMGluJTIwYSUyMHNtYWxsJTJDJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYSUyMHRpbnklMjBoYXQlMkMlMjBzaXRzJTIwb24lMjBhJTIwd29vZGVuJTIwc3Rvb2wlMjBpbiUyMGElMjBzZXJlbmUlMjBiYW1ib28lMjBmb3Jlc3QuJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwcGFuZGEncyUyMGZsdWZmeSUyMHBhd3MlMjBzdHJ1bSUyMGElMjBtaW5pYXR1cmUlMjBhY291c3RpYyUyMGd1aXRhciUyQyUyMHByb2R1Y2luZyUyMHNvZnQlMkMlMjBtZWxvZGljJTIwdHVuZXMuJTIwTmVhcmJ5JTJDJTIwYSUyMGZldyUyMG90aGVyJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIycGFuZGFzJTIwZ2F0aGVyJTJDJTIwd2F0Y2hpbmclMjBjdXJpb3VzbHklMjBhbmQlMjBzb21lJTIwY2xhcHBpbmclMjBpbiUyMHJoeXRobS4lMjBTdW5saWdodCUyMGZpbHRlcnMlMjB0aHJvdWdoJTIwdGhlJTIwdGFsbCUyMGJhbWJvbyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmNhc3RpbmclMjBhJTIwZ2VudGxlJTIwZ2xvdyUyMG9uJTIwdGhlJTIwc2NlbmUuJTIwVGhlJTIwcGFuZGEncyUyMGZhY2UlMjBpcyUyMGV4cHJlc3NpdmUlMkMlMjBzaG93aW5nJTIwY29uY2VudHJhdGlvbiUyMGFuZCUyMGpveSUyMGFzJTIwaXQlMjBwbGF5cy4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBiYWNrZ3JvdW5kJTIwaW5jbHVkZXMlMjBhJTIwc21hbGwlMkMlMjBmbG93aW5nJTIwc3RyZWFtJTIwYW5kJTIwdmlicmFudCUyMGdyZWVuJTIwZm9saWFnZSUyQyUyMGVuaGFuY2luZyUyMHRoZSUyMHBlYWNlZnVsJTIwYW5kJTIwbWFnaWNhbCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMmF0bW9zcGhlcmUlMjBvZiUyMHRoaXMlMjB1bmlxdWUlMjBtdXNpY2FsJTIwcGVyZm9ybWFuY2UuJTIyJTBBKSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-2b&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){l=a("p"),l.textContent=T,g=o(),f(p.$$.fragment)},l(s){l=r(s,"P",{"data-svelte-h":!0}),u(l)!=="svelte-kvfsh7"&&(l.textContent=T),g=n(s),h(p.$$.fragment,s)},m(s,w){m(s,l,w),m(s,g,w),_(p,s,w),c=!0},p:jt,i(s){c||(b(p.$$.fragment,s),c=!0)},o(s){y(p.$$.fragment,s),c=!1},d(s){s&&(i(l),i(g)),v(p,s)}}}function ts(G){let l,T="Examples:",g,p,c;return p=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBDb2dWaWRlb1hJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyVEhVRE0lMkZDb2dWaWRlb1gtNWItSTJWJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjBoYXRjaGluZyUyMGZyb20lMjBhbiUyMGVnZyUyQyUyMG9uJTIwdGhlJTIwc3VyZmFjZSUyMG9mJTIwdGhlJTIwbW9vbiUyQyUyMHRoZSUyMGRhcmtuZXNzJTIwYW5kJTIwZGVwdGglMjBvZiUyMHNwYWNlJTIwcmVhbGlzZWQlMjBpbiUyMHRoZSUyMGJhY2tncm91bmQuJTIwSGlnaCUyMHF1YWxpdHklMkMlMjB1bHRyYXJlYWxpc3RpYyUyMGRldGFpbCUyMGFuZCUyMGJyZWF0aC10YWtpbmclMjBtb3ZpZS1saWtlJTIwY2FtZXJhJTIwc2hvdC4lMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGYXN0cm9uYXV0LmpwZyUyMiUwQSklMEF2aWRlbyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBwcm9tcHQlMkMlMjB1c2VfZHluYW1pY19jZmclM0RUcnVlKSUwQWV4cG9ydF90b192aWRlbyh2aWRlby5mcmFtZXMlNUIwJTVEJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b-I2V&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;An astronaut hatching from an egg, on the surface of the moon, the darkness and depth of space realised in the background. High quality, ultrarealistic detail and breath-taking movie-like camera shot.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astronaut.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(image, prompt, use_dynamic_cfg=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){l=a("p"),l.textContent=T,g=o(),f(p.$$.fragment)},l(s){l=r(s,"P",{"data-svelte-h":!0}),u(l)!=="svelte-kvfsh7"&&(l.textContent=T),g=n(s),h(p.$$.fragment,s)},m(s,w){m(s,l,w),m(s,g,w),_(p,s,w),c=!0},p:jt,i(s){c||(b(p.$$.fragment,s),c=!0)},o(s){y(p.$$.fragment,s),c=!1},d(s){s&&(i(l),i(g)),v(p,s)}}}function os(G){let l,T="Examples:",g,p,c;return p=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YRFBNU2NoZWR1bGVyJTJDJTIwQ29nVmlkZW9YVmlkZW9Ub1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF92aWRlbyUwQSUwQSUyMyUyME1vZGVscyUzQSUyMCUyMlRIVURNJTJGQ29nVmlkZW9YLTJiJTIyJTIwb3IlMjAlMjJUSFVETSUyRkNvZ1ZpZGVvWC01YiUyMiUwQXBpcGUlMjAlM0QlMjBDb2dWaWRlb1hWaWRlb1RvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyVEhVRE0lMkZDb2dWaWRlb1gtNWIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMENvZ1ZpZGVvWERQTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBaW5wdXRfdmlkZW8lMjAlM0QlMjBsb2FkX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmhpa2VyLm1wNCUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjBzdGFuZHMlMjB0cml1bXBoYW50bHklMjBhdCUyMHRoZSUyMHBlYWslMjBvZiUyMGElMjB0b3dlcmluZyUyMG1vdW50YWluLiUyMFBhbm9yYW1hJTIwb2YlMjBydWdnZWQlMjBwZWFrcyUyMGFuZCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnZhbGxleXMuJTIwVmVyeSUyMGZ1dHVyaXN0aWMlMjB2aWJlJTIwYW5kJTIwYW5pbWF0ZWQlMjBhZXN0aGV0aWMuJTIwSGlnaGxpZ2h0cyUyMG9mJTIwcHVycGxlJTIwYW5kJTIwZ29sZGVuJTIwY29sb3JzJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBzY2VuZS4lMjBUaGUlMjBza3klMjBpcyUyMGxvb2tzJTIwbGlrZSUyMGFuJTIwYW5pbWF0ZWQlMkZjYXJ0b29uaXNoJTIwZHJlYW0lMjBvZiUyMGdhbGF4aWVzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwcGxhbmV0cyUyQyUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMm1vb25zJTJDJTIwYnV0JTIwdGhlJTIwcmVtYWluZGVyJTIwb2YlMjB0aGUlMjBzY2VuZSUyMGlzJTIwbW9zdGx5JTIwcmVhbGlzdGljLiUyMiUwQSklMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwdmlkZW8lM0RpbnB1dF92aWRlbyUyQyUyMHByb21wdCUzRHByb21wdCUyQyUyMHN0cmVuZ3RoJTNEMC44JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q2JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXDPMScheduler, CogVideoXVideoToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Models: &quot;THUDM/CogVideoX-2b&quot; or &quot;THUDM/CogVideoX-5b&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXVideoToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = CogVideoXDPMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hiker.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut stands triumphantly at the peak of a towering mountain. Panorama of rugged peaks and &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;valleys. Very futuristic vibe and animated aesthetic. Highlights of purple and golden colors in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the scene. The sky is looks like an animated/cartoonish dream of galaxies, nebulae, stars, planets, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;moons, but the remainder of the scene is mostly realistic.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    video=input_video, prompt=prompt, strength=<span class="hljs-number">0.8</span>, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){l=a("p"),l.textContent=T,g=o(),f(p.$$.fragment)},l(s){l=r(s,"P",{"data-svelte-h":!0}),u(l)!=="svelte-kvfsh7"&&(l.textContent=T),g=n(s),h(p.$$.fragment,s)},m(s,w){m(s,l,w),m(s,g,w),_(p,s,w),c=!0},p:jt,i(s){c||(b(p.$$.fragment,s),c=!0)},o(s){y(p.$$.fragment,s),c=!1},d(s){s&&(i(l),i(g)),v(p,s)}}}function ns(G){let l,T="Examples:",g,p,c;return p=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YRnVuQ29udHJvbFBpcGVsaW5lJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMkMlMjBsb2FkX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWEZ1bkNvbnRyb2xQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYWxpYmFiYS1wYWklMkZDb2dWaWRlb1gtRnVuLVYxLjEtNWItUG9zZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBY29udHJvbF92aWRlbyUyMCUzRCUyMGxvYWRfdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaGlrZXIubXA0JTIyJTBBKSUwQXByb21wdCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHN0YW5kcyUyMHRyaXVtcGhhbnRseSUyMGF0JTIwdGhlJTIwcGVhayUyMG9mJTIwYSUyMHRvd2VyaW5nJTIwbW91bnRhaW4uJTIwUGFub3JhbWElMjBvZiUyMHJ1Z2dlZCUyMHBlYWtzJTIwYW5kJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIydmFsbGV5cy4lMjBWZXJ5JTIwZnV0dXJpc3RpYyUyMHZpYmUlMjBhbmQlMjBhbmltYXRlZCUyMGFlc3RoZXRpYy4lMjBIaWdobGlnaHRzJTIwb2YlMjBwdXJwbGUlMjBhbmQlMjBnb2xkZW4lMjBjb2xvcnMlMjBpbiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnRoZSUyMHNjZW5lLiUyMFRoZSUyMHNreSUyMGlzJTIwbG9va3MlMjBsaWtlJTIwYW4lMjBhbmltYXRlZCUyRmNhcnRvb25pc2glMjBkcmVhbSUyMG9mJTIwZ2FsYXhpZXMlMkMlMjBuZWJ1bGFlJTJDJTIwc3RhcnMlMkMlMjBwbGFuZXRzJTJDJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIybW9vbnMlMkMlMjBidXQlMjB0aGUlMjByZW1haW5kZXIlMjBvZiUyMHRoZSUyMHNjZW5lJTIwaXMlMjBtb3N0bHklMjByZWFsaXN0aWMuJTIyJTBBKSUwQSUwQXZpZGVvJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBjb250cm9sX3ZpZGVvJTNEY29udHJvbF92aWRlbykuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMm91dHB1dC5tcDQlMjIlMkMlMjBmcHMlM0Q4KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXFunControlPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = CogVideoXFunControlPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alibaba-pai/CogVideoX-Fun-V1.1-5b-Pose&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>control_video = load_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hiker.mp4&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut stands triumphantly at the peak of a towering mountain. Panorama of rugged peaks and &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;valleys. Very futuristic vibe and animated aesthetic. Highlights of purple and golden colors in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the scene. The sky is looks like an animated/cartoonish dream of galaxies, nebulae, stars, planets, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;moons, but the remainder of the scene is mostly realistic.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(prompt=prompt, control_video=control_video).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){l=a("p"),l.textContent=T,g=o(),f(p.$$.fragment)},l(s){l=r(s,"P",{"data-svelte-h":!0}),u(l)!=="svelte-kvfsh7"&&(l.textContent=T),g=n(s),h(p.$$.fragment,s)},m(s,w){m(s,l,w),m(s,g,w),_(p,s,w),c=!0},p:jt,i(s){c||(b(p.$$.fragment,s),c=!0)},o(s){y(p.$$.fragment,s),c=!1},d(s){s&&(i(l),i(g)),v(p,s)}}}function ss(G){let l,T,g,p,c,s='<div class="flex flex-wrap space-x-1"><a href="https://huggingface.co/docs/diffusers/main/en/tutorials/using_peft_for_inference" target="_blank" rel="noopener"><img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/></a></div>',w,j,M,x,rn='<a href="https://huggingface.co/papers/2408.06072" rel="nofollow">CogVideoX</a> is a large diffusion transformer model - available in 2B and 5B parameters - designed to generate longer and more consistent videos from text. This model uses a 3D causal variational autoencoder to more efficiently process video data by reducing sequence length (and associated training compute) and preventing flickering in generated videos. An “expert” transformer with adaptive LayerNorm improves alignment between text and video, and 3D full attention helps accurately capture motion and time in generated videos.',Ut,pe,ln='You can find all the original CogVideoX checkpoints under the <a href="https://huggingface.co/collections/THUDM/cogvideo-66c08e62f1685a3ade464cce" rel="nofollow">CogVideoX</a> collection.',It,q,dn="<p>Click on the CogVideoX models in the right sidebar for more examples of other video generation tasks.</p>",Xt,ce,pn="The example below demonstrates how to generate a video optimized for memory or inference speed.",Zt,L,kt,me,Gt,W,ge,Le,cn='CogVideoX supports LoRAs with <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.CogVideoXLoraLoaderMixin.load_lora_weights">load_lora_weights()</a>.',lo,ue,Qe,mn="Show example code",po,fe,co,Se,gn="<p>The text-to-video (T2V) checkpoints work best with a resolution of 1360x768 because that was the resolution it was pretrained on.</p>",mo,Ae,un="<p>The image-to-video (I2V) checkpoints work with multiple resolutions. The width can vary from 768 to 1360, but the height must be 758. Both height and width must be divisible by 16.</p>",go,De,fn="<p>Both T2V and I2V checkpoints work best with 81 and 161 frames. It is recommended to export the generated video at 16fps.</p>",uo,Oe,hn="<p>Refer to the table below to view memory usage when various memory-saving techniques are enabled.</p> <table><thead><tr><th>method</th> <th>memory usage (enabled)</th> <th>memory usage (disabled)</th></tr></thead> <tbody><tr><td>enable_model_cpu_offload</td> <td>19GB</td> <td>33GB</td></tr> <tr><td>enable_sequential_cpu_offload</td> <td>&lt;4GB</td> <td>~33GB (very slow inference speed)</td></tr> <tr><td>enable_tiling</td> <td>11GB (with enable_model_cpu_offload)</td> <td>---</td></tr></tbody></table>",Wt,he,Bt,U,_e,fo,Ke,_n="Pipeline for text-to-video generation using CogVideoX.",ho,et,bn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,_o,R,be,bo,tt,yn="Function invoked when calling the pipeline for generation.",yo,Q,vo,S,ye,Mo,ot,vn="Encodes the prompt into text encoder hidden states.",wo,A,ve,To,nt,Mn="Enables fused QKV projections.",Vo,D,Me,Jo,st,wn="Disable QKV projection fusion if enabled.",$t,we,Pt,I,Te,Co,it,Tn="Pipeline for image-to-video generation using CogVideoX.",jo,at,Vn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,xo,Y,Ve,Uo,rt,Jn="Function invoked when calling the pipeline for generation.",Io,O,Xo,K,Je,Zo,lt,Cn="Encodes the prompt into text encoder hidden states.",ko,ee,Ce,Go,dt,jn="Enables fused QKV projections.",Wo,te,je,Bo,pt,xn="Disable QKV projection fusion if enabled.",Nt,xe,Rt,X,Ue,$o,ct,Un="Pipeline for video-to-video generation using CogVideoX.",Po,mt,In=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,No,F,Ie,Ro,gt,Xn="Function invoked when calling the pipeline for generation.",Yo,oe,Fo,ne,Xe,Eo,ut,Zn="Encodes the prompt into text encoder hidden states.",Ho,se,Ze,zo,ft,kn="Enables fused QKV projections.",qo,ie,ke,Lo,ht,Gn="Disable QKV projection fusion if enabled.",Yt,Ge,Ft,Z,We,Qo,_t,Wn="Pipeline for controlled text-to-video generation using CogVideoX Fun.",So,bt,Bn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ao,E,Be,Do,yt,$n="Function invoked when calling the pipeline for generation.",Oo,ae,Ko,re,$e,en,vt,Pn="Encodes the prompt into text encoder hidden states.",tn,le,Pe,on,Mt,Nn="Enables fused QKV projections.",nn,de,Ne,sn,wt,Rn="Disable QKV projection fusion if enabled.",Et,Re,Ht,H,Ye,an,Tt,Yn="Output class for CogVideo pipelines.",zt,Fe,qt,xt,Lt;return j=new ze({props:{title:"CogVideoX",local:"cogvideox",headingTag:"h1"}}),L=new An({props:{id:"usage",options:["memory","inference speed"],$$slots:{default:[Kn]},$$scope:{ctx:G}}}),me=new ze({props:{title:"Notes",local:"notes",headingTag:"h2"}}),fe=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLmhvb2tzJTIwaW1wb3J0JTIwYXBwbHlfZ3JvdXBfb2ZmbG9hZGluZyUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlbGluZSUyMCUzRCUyMENvZ1ZpZGVvWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJUSFVETSUyRkNvZ1ZpZGVvWC01YiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBsb2FkJTIwTG9SQSUyMHdlaWdodHMlMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJmaW5ldHJhaW5lcnMlMkZDb2dWaWRlb1gtMS41LWNydXNoLXNtb2wtdjAlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJjcnVzaC1sb3JhJTIyKSUwQXBpcGVsaW5lLnNldF9hZGFwdGVycyglMjJjcnVzaC1sb3JhJTIyJTJDJTIwMC45KSUwQSUwQSUyMyUyMG1vZGVsLW9mZmxvYWRpbmclMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUwQVBJS0FfQ1JVU0glMjBBJTIwbGFyZ2UlMjBtZXRhbCUyMGN5bGluZGVyJTIwaXMlMjBzZWVuJTIwcHJlc3NpbmclMjBkb3duJTIwb24lMjBhJTIwcGlsZSUyMG9mJTIwT3JlbyUyMGNvb2tpZXMlMkMlMjBmbGF0dGVuaW5nJTIwdGhlbSUyMGFzJTIwaWYlMjB0aGV5JTIwd2VyZSUyMHVuZGVyJTIwYSUyMGh5ZHJhdWxpYyUyMHByZXNzLiUwQSUyMiUyMiUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmluY29uc2lzdGVudCUyMG1vdGlvbiUyQyUyMGJsdXJyeSUyMG1vdGlvbiUyQyUyMHdvcnNlJTIwcXVhbGl0eSUyQyUyMGRlZ2VuZXJhdGUlMjBvdXRwdXRzJTJDJTIwZGVmb3JtZWQlMjBvdXRwdXRzJTIyJTBBJTBBdmlkZW8lMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjAlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMjAlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEODElMkMlMjAlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUwQSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMm91dHB1dC5tcDQlMjIlMkMlMjBmcHMlM0QxNik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipeline = CogVideoXPipeline.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>,
    torch_dtype=torch.bfloat16
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># load LoRA weights</span>
pipeline.load_lora_weights(<span class="hljs-string">&quot;finetrainers/CogVideoX-1.5-crush-smol-v0&quot;</span>, adapter_name=<span class="hljs-string">&quot;crush-lora&quot;</span>)
pipeline.set_adapters(<span class="hljs-string">&quot;crush-lora&quot;</span>, <span class="hljs-number">0.9</span>)

<span class="hljs-comment"># model-offloading</span>
pipeline.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;&quot;&quot;
PIKA_CRUSH A large metal cylinder is seen pressing down on a pile of Oreo cookies, flattening them as if they were under a hydraulic press.
&quot;&quot;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;inconsistent motion, blurry motion, worse quality, degenerate outputs, deformed outputs&quot;</span>

video = pipeline(
    prompt=prompt, 
    negative_prompt=negative_prompt, 
    num_frames=<span class="hljs-number">81</span>, 
    height=<span class="hljs-number">480</span>,
    width=<span class="hljs-number">768</span>,
    num_inference_steps=<span class="hljs-number">50</span>
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),he=new ze({props:{title:"CogVideoXPipeline",local:"diffusers.CogVideoXPipeline",headingTag:"h2"}}),_e=new C({props:{name:"class diffusers.CogVideoXPipeline",anchor:"diffusers.CogVideoXPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L147"}}),be=new C({props:{name:"__call__",anchor:"diffusers.CogVideoXPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 8. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L505",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),Q=new ro({props:{anchor:"diffusers.CogVideoXPipeline.__call__.example",$$slots:{default:[es]},$$scope:{ctx:G}}}),ye=new C({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L244"}}),ve=new C({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L428"}}),Me=new C({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox.py#L433"}}),we=new ze({props:{title:"CogVideoXImageToVideoPipeline",local:"diffusers.CogVideoXImageToVideoPipeline",headingTag:"h2"}}),Te=new C({props:{name:"class diffusers.CogVideoXImageToVideoPipeline",anchor:"diffusers.CogVideoXImageToVideoPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L160"}}),Ve=new C({props:{name:"__call__",anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_frames",val:": int = 49"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>48</code>) &#x2014;
Number of frames to generate. Must be divisible by self.vae_scale_factor_temporal. Generated video will
contain 1 extra frame because CogVideoX is conditioned with (num_seconds * fps + 1) frames where
num_seconds is 6 and fps is 8. However, since videos can be saved at any fps, the only condition that
needs to be satisfied is that of divisibility mentioned above.`,name:"num_frames"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L598",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),O=new ro({props:{anchor:"diffusers.CogVideoXImageToVideoPipeline.__call__.example",$$slots:{default:[ts]},$$scope:{ctx:G}}}),Je=new C({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L263"}}),Ce=new C({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXImageToVideoPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L519"}}),je=new C({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXImageToVideoPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_image2video.py#L525"}}),xe=new ze({props:{title:"CogVideoXVideoToVideoPipeline",local:"diffusers.CogVideoXVideoToVideoPipeline",headingTag:"h2"}}),Ue=new C({props:{name:"class diffusers.CogVideoXVideoToVideoPipeline",anchor:"diffusers.CogVideoXVideoToVideoPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_cogvideox.CogVideoXDDIMScheduler, diffusers.schedulers.scheduling_dpm_cogvideox.CogVideoXDPMScheduler]"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L169"}}),Ie=new C({props:{name:"__call__",anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": typing.List[PIL.Image.Image] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"strength",val:": float = 0.8"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The input video to condition the generation on. Must be a list of images/frames of the video.`,name:"video"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Higher strength leads to more differences between original video and generated video.`,name:"strength"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L575",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),oe=new ro({props:{anchor:"diffusers.CogVideoXVideoToVideoPipeline.__call__.example",$$slots:{default:[os]},$$scope:{ctx:G}}}),Xe=new C({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXVideoToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L269"}}),Ze=new C({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L496"}}),ke=new C({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXVideoToVideoPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_video2video.py#L502"}}),Ge=new ze({props:{title:"CogVideoXFunControlPipeline",local:"diffusers.CogVideoXFunControlPipeline",headingTag:"h2"}}),We=new C({props:{name:"class diffusers.CogVideoXFunControlPipeline",anchor:"diffusers.CogVideoXFunControlPipeline",parameters:[{name:"tokenizer",val:": T5Tokenizer"},{name:"text_encoder",val:": T5EncoderModel"},{name:"vae",val:": AutoencoderKLCogVideoX"},{name:"transformer",val:": CogVideoXTransformer3DModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.CogVideoXFunControlPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. CogVideoX uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>; specifically the
<a href="https://huggingface.co/PixArt-alpha/PixArt-alpha/tree/main/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.CogVideoXFunControlPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.CogVideoXFunControlPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/cogvideox_transformer3d#diffusers.CogVideoXTransformer3DModel">CogVideoXTransformer3DModel</a>) &#x2014;
A text conditioned <code>CogVideoXTransformer3DModel</code> to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.CogVideoXFunControlPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded video latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L154"}}),Be=new C({props:{name:"__call__",anchor:"diffusers.CogVideoXFunControlPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"control_video",val:": typing.Optional[typing.List[PIL.Image.Image]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"guidance_scale",val:": float = 6"},{name:"use_dynamic_cfg",val:": bool = False"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"control_video_latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 226"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.control_video",description:`<strong>control_video</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The control video to condition the generation on. Must be a list of images/frames of the video. If not
provided, <code>control_video_latents</code> must be provided.`,name:"control_video"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.transformer.config.sample_height * self.vae_scale_factor_spatial) &#x2014;
The width in pixels of the generated image. This is set to 720 by default for the best results.`,name:"width"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will be generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.control_video_latents",description:`<strong>control_video_latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated control latents, sampled from a Gaussian distribution, to be used as inputs for
controlled video generation. If not provided, <code>control_video</code> must be provided.`,name:"control_video_latents"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, defaults to <code>226</code>) &#x2014;
Maximum sequence length in encoded prompt. Must be consistent with
<code>self.transformer.config.max_text_seq_length</code> otherwise may lead to poor results.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L551",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/cogvideox#diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput"
>CogVideoXPipelineOutput</a> or <code>tuple</code></p>
`}}),ae=new ro({props:{anchor:"diffusers.CogVideoXFunControlPipeline.__call__.example",$$slots:{default:[ns]},$$scope:{ctx:G}}}),$e=new C({props:{name:"encode_prompt",anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.CogVideoXFunControlPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L253"}}),Pe=new C({props:{name:"fuse_qkv_projections",anchor:"diffusers.CogVideoXFunControlPipeline.fuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L473"}}),Ne=new C({props:{name:"unfuse_qkv_projections",anchor:"diffusers.CogVideoXFunControlPipeline.unfuse_qkv_projections",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_cogvideox_fun_control.py#L478"}}),Re=new ze({props:{title:"CogVideoXPipelineOutput",local:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",headingTag:"h2"}}),Ye=new C({props:{name:"class diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/cogvideo/pipeline_output.py#L9"}}),Fe=new Sn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/cogvideox.md"}}),{c(){l=a("meta"),T=o(),g=a("p"),p=o(),c=a("div"),c.innerHTML=s,w=o(),f(j.$$.fragment),M=o(),x=a("p"),x.innerHTML=rn,Ut=o(),pe=a("p"),pe.innerHTML=ln,It=o(),q=a("blockquote"),q.innerHTML=dn,Xt=o(),ce=a("p"),ce.textContent=pn,Zt=o(),f(L.$$.fragment),kt=o(),f(me.$$.fragment),Gt=o(),W=a("ul"),ge=a("li"),Le=a("p"),Le.innerHTML=cn,lo=o(),ue=a("details"),Qe=a("summary"),Qe.textContent=mn,po=o(),f(fe.$$.fragment),co=o(),Se=a("li"),Se.innerHTML=gn,mo=o(),Ae=a("li"),Ae.innerHTML=un,go=o(),De=a("li"),De.innerHTML=fn,uo=o(),Oe=a("li"),Oe.innerHTML=hn,Wt=o(),f(he.$$.fragment),Bt=o(),U=a("div"),f(_e.$$.fragment),fo=o(),Ke=a("p"),Ke.textContent=_n,ho=o(),et=a("p"),et.innerHTML=bn,_o=o(),R=a("div"),f(be.$$.fragment),bo=o(),tt=a("p"),tt.textContent=yn,yo=o(),f(Q.$$.fragment),vo=o(),S=a("div"),f(ye.$$.fragment),Mo=o(),ot=a("p"),ot.textContent=vn,wo=o(),A=a("div"),f(ve.$$.fragment),To=o(),nt=a("p"),nt.textContent=Mn,Vo=o(),D=a("div"),f(Me.$$.fragment),Jo=o(),st=a("p"),st.textContent=wn,$t=o(),f(we.$$.fragment),Pt=o(),I=a("div"),f(Te.$$.fragment),Co=o(),it=a("p"),it.textContent=Tn,jo=o(),at=a("p"),at.innerHTML=Vn,xo=o(),Y=a("div"),f(Ve.$$.fragment),Uo=o(),rt=a("p"),rt.textContent=Jn,Io=o(),f(O.$$.fragment),Xo=o(),K=a("div"),f(Je.$$.fragment),Zo=o(),lt=a("p"),lt.textContent=Cn,ko=o(),ee=a("div"),f(Ce.$$.fragment),Go=o(),dt=a("p"),dt.textContent=jn,Wo=o(),te=a("div"),f(je.$$.fragment),Bo=o(),pt=a("p"),pt.textContent=xn,Nt=o(),f(xe.$$.fragment),Rt=o(),X=a("div"),f(Ue.$$.fragment),$o=o(),ct=a("p"),ct.textContent=Un,Po=o(),mt=a("p"),mt.innerHTML=In,No=o(),F=a("div"),f(Ie.$$.fragment),Ro=o(),gt=a("p"),gt.textContent=Xn,Yo=o(),f(oe.$$.fragment),Fo=o(),ne=a("div"),f(Xe.$$.fragment),Eo=o(),ut=a("p"),ut.textContent=Zn,Ho=o(),se=a("div"),f(Ze.$$.fragment),zo=o(),ft=a("p"),ft.textContent=kn,qo=o(),ie=a("div"),f(ke.$$.fragment),Lo=o(),ht=a("p"),ht.textContent=Gn,Yt=o(),f(Ge.$$.fragment),Ft=o(),Z=a("div"),f(We.$$.fragment),Qo=o(),_t=a("p"),_t.textContent=Wn,So=o(),bt=a("p"),bt.innerHTML=Bn,Ao=o(),E=a("div"),f(Be.$$.fragment),Do=o(),yt=a("p"),yt.textContent=$n,Oo=o(),f(ae.$$.fragment),Ko=o(),re=a("div"),f($e.$$.fragment),en=o(),vt=a("p"),vt.textContent=Pn,tn=o(),le=a("div"),f(Pe.$$.fragment),on=o(),Mt=a("p"),Mt.textContent=Nn,nn=o(),de=a("div"),f(Ne.$$.fragment),sn=o(),wt=a("p"),wt.textContent=Rn,Et=o(),f(Re.$$.fragment),Ht=o(),H=a("div"),f(Ye.$$.fragment),an=o(),Tt=a("p"),Tt.textContent=Yn,zt=o(),f(Fe.$$.fragment),qt=o(),xt=a("p"),this.h()},l(e){const d=Ln("svelte-u9bgzb",document.head);l=r(d,"META",{name:!0,content:!0}),d.forEach(i),T=n(e),g=r(e,"P",{}),V(g).forEach(i),p=n(e),c=r(e,"DIV",{style:!0,"data-svelte-h":!0}),u(c)!=="svelte-p206qu"&&(c.innerHTML=s),w=n(e),h(j.$$.fragment,e),M=n(e),x=r(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-12eftj"&&(x.innerHTML=rn),Ut=n(e),pe=r(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1tt16w3"&&(pe.innerHTML=ln),It=n(e),q=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(q)!=="svelte-apdep0"&&(q.innerHTML=dn),Xt=n(e),ce=r(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-pzhop3"&&(ce.textContent=pn),Zt=n(e),h(L.$$.fragment,e),kt=n(e),h(me.$$.fragment,e),Gt=n(e),W=r(e,"UL",{});var N=V(W);ge=r(N,"LI",{});var Ee=V(ge);Le=r(Ee,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-10mpltu"&&(Le.innerHTML=cn),lo=n(Ee),ue=r(Ee,"DETAILS",{});var He=V(ue);Qe=r(He,"SUMMARY",{"data-svelte-h":!0}),u(Qe)!=="svelte-1m0l1gk"&&(Qe.textContent=mn),po=n(He),h(fe.$$.fragment,He),He.forEach(i),Ee.forEach(i),co=n(N),Se=r(N,"LI",{"data-svelte-h":!0}),u(Se)!=="svelte-1ius1gf"&&(Se.innerHTML=gn),mo=n(N),Ae=r(N,"LI",{"data-svelte-h":!0}),u(Ae)!=="svelte-152k8lk"&&(Ae.innerHTML=un),go=n(N),De=r(N,"LI",{"data-svelte-h":!0}),u(De)!=="svelte-14p2fdr"&&(De.innerHTML=fn),uo=n(N),Oe=r(N,"LI",{"data-svelte-h":!0}),u(Oe)!=="svelte-1dl97ou"&&(Oe.innerHTML=hn),N.forEach(i),Wt=n(e),h(he.$$.fragment,e),Bt=n(e),U=r(e,"DIV",{class:!0});var k=V(U);h(_e.$$.fragment,k),fo=n(k),Ke=r(k,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-gmblkq"&&(Ke.textContent=_n),ho=n(k),et=r(k,"P",{"data-svelte-h":!0}),u(et)!=="svelte-wu1jmh"&&(et.innerHTML=bn),_o=n(k),R=r(k,"DIV",{class:!0});var z=V(R);h(be.$$.fragment,z),bo=n(z),tt=r(z,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-v78lg8"&&(tt.textContent=yn),yo=n(z),h(Q.$$.fragment,z),z.forEach(i),vo=n(k),S=r(k,"DIV",{class:!0});var Qt=V(S);h(ye.$$.fragment,Qt),Mo=n(Qt),ot=r(Qt,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-16q0ax1"&&(ot.textContent=vn),Qt.forEach(i),wo=n(k),A=r(k,"DIV",{class:!0});var St=V(A);h(ve.$$.fragment,St),To=n(St),nt=r(St,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-1vadzv1"&&(nt.textContent=Mn),St.forEach(i),Vo=n(k),D=r(k,"DIV",{class:!0});var At=V(D);h(Me.$$.fragment,At),Jo=n(At),st=r(At,"P",{"data-svelte-h":!0}),u(st)!=="svelte-fohozp"&&(st.textContent=wn),At.forEach(i),k.forEach(i),$t=n(e),h(we.$$.fragment,e),Pt=n(e),I=r(e,"DIV",{class:!0});var B=V(I);h(Te.$$.fragment,B),Co=n(B),it=r(B,"P",{"data-svelte-h":!0}),u(it)!=="svelte-cngl0i"&&(it.textContent=Tn),jo=n(B),at=r(B,"P",{"data-svelte-h":!0}),u(at)!=="svelte-wu1jmh"&&(at.innerHTML=Vn),xo=n(B),Y=r(B,"DIV",{class:!0});var Vt=V(Y);h(Ve.$$.fragment,Vt),Uo=n(Vt),rt=r(Vt,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-v78lg8"&&(rt.textContent=Jn),Io=n(Vt),h(O.$$.fragment,Vt),Vt.forEach(i),Xo=n(B),K=r(B,"DIV",{class:!0});var Dt=V(K);h(Je.$$.fragment,Dt),Zo=n(Dt),lt=r(Dt,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-16q0ax1"&&(lt.textContent=Cn),Dt.forEach(i),ko=n(B),ee=r(B,"DIV",{class:!0});var Ot=V(ee);h(Ce.$$.fragment,Ot),Go=n(Ot),dt=r(Ot,"P",{"data-svelte-h":!0}),u(dt)!=="svelte-1vadzv1"&&(dt.textContent=jn),Ot.forEach(i),Wo=n(B),te=r(B,"DIV",{class:!0});var Kt=V(te);h(je.$$.fragment,Kt),Bo=n(Kt),pt=r(Kt,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-fohozp"&&(pt.textContent=xn),Kt.forEach(i),B.forEach(i),Nt=n(e),h(xe.$$.fragment,e),Rt=n(e),X=r(e,"DIV",{class:!0});var $=V(X);h(Ue.$$.fragment,$),$o=n($),ct=r($,"P",{"data-svelte-h":!0}),u(ct)!=="svelte-4lf8uk"&&(ct.textContent=Un),Po=n($),mt=r($,"P",{"data-svelte-h":!0}),u(mt)!=="svelte-wu1jmh"&&(mt.innerHTML=In),No=n($),F=r($,"DIV",{class:!0});var Jt=V(F);h(Ie.$$.fragment,Jt),Ro=n(Jt),gt=r(Jt,"P",{"data-svelte-h":!0}),u(gt)!=="svelte-v78lg8"&&(gt.textContent=Xn),Yo=n(Jt),h(oe.$$.fragment,Jt),Jt.forEach(i),Fo=n($),ne=r($,"DIV",{class:!0});var eo=V(ne);h(Xe.$$.fragment,eo),Eo=n(eo),ut=r(eo,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-16q0ax1"&&(ut.textContent=Zn),eo.forEach(i),Ho=n($),se=r($,"DIV",{class:!0});var to=V(se);h(Ze.$$.fragment,to),zo=n(to),ft=r(to,"P",{"data-svelte-h":!0}),u(ft)!=="svelte-1vadzv1"&&(ft.textContent=kn),to.forEach(i),qo=n($),ie=r($,"DIV",{class:!0});var oo=V(ie);h(ke.$$.fragment,oo),Lo=n(oo),ht=r(oo,"P",{"data-svelte-h":!0}),u(ht)!=="svelte-fohozp"&&(ht.textContent=Gn),oo.forEach(i),$.forEach(i),Yt=n(e),h(Ge.$$.fragment,e),Ft=n(e),Z=r(e,"DIV",{class:!0});var P=V(Z);h(We.$$.fragment,P),Qo=n(P),_t=r(P,"P",{"data-svelte-h":!0}),u(_t)!=="svelte-8tkh5d"&&(_t.textContent=Wn),So=n(P),bt=r(P,"P",{"data-svelte-h":!0}),u(bt)!=="svelte-wu1jmh"&&(bt.innerHTML=Bn),Ao=n(P),E=r(P,"DIV",{class:!0});var Ct=V(E);h(Be.$$.fragment,Ct),Do=n(Ct),yt=r(Ct,"P",{"data-svelte-h":!0}),u(yt)!=="svelte-v78lg8"&&(yt.textContent=$n),Oo=n(Ct),h(ae.$$.fragment,Ct),Ct.forEach(i),Ko=n(P),re=r(P,"DIV",{class:!0});var no=V(re);h($e.$$.fragment,no),en=n(no),vt=r(no,"P",{"data-svelte-h":!0}),u(vt)!=="svelte-16q0ax1"&&(vt.textContent=Pn),no.forEach(i),tn=n(P),le=r(P,"DIV",{class:!0});var so=V(le);h(Pe.$$.fragment,so),on=n(so),Mt=r(so,"P",{"data-svelte-h":!0}),u(Mt)!=="svelte-1vadzv1"&&(Mt.textContent=Nn),so.forEach(i),nn=n(P),de=r(P,"DIV",{class:!0});var io=V(de);h(Ne.$$.fragment,io),sn=n(io),wt=r(io,"P",{"data-svelte-h":!0}),u(wt)!=="svelte-fohozp"&&(wt.textContent=Rn),io.forEach(i),P.forEach(i),Et=n(e),h(Re.$$.fragment,e),Ht=n(e),H=r(e,"DIV",{class:!0});var ao=V(H);h(Ye.$$.fragment,ao),an=n(ao),Tt=r(ao,"P",{"data-svelte-h":!0}),u(Tt)!=="svelte-1qnvsrt"&&(Tt.textContent=Yn),ao.forEach(i),zt=n(e),h(Fe.$$.fragment,e),qt=n(e),xt=r(e,"P",{}),V(xt).forEach(i),this.h()},h(){J(l,"name","hf:doc:metadata"),J(l,"content",is),Qn(c,"float","right"),J(q,"class","tip"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){t(document.head,l),m(e,T,d),m(e,g,d),m(e,p,d),m(e,c,d),m(e,w,d),_(j,e,d),m(e,M,d),m(e,x,d),m(e,Ut,d),m(e,pe,d),m(e,It,d),m(e,q,d),m(e,Xt,d),m(e,ce,d),m(e,Zt,d),_(L,e,d),m(e,kt,d),_(me,e,d),m(e,Gt,d),m(e,W,d),t(W,ge),t(ge,Le),t(ge,lo),t(ge,ue),t(ue,Qe),t(ue,po),_(fe,ue,null),t(W,co),t(W,Se),t(W,mo),t(W,Ae),t(W,go),t(W,De),t(W,uo),t(W,Oe),m(e,Wt,d),_(he,e,d),m(e,Bt,d),m(e,U,d),_(_e,U,null),t(U,fo),t(U,Ke),t(U,ho),t(U,et),t(U,_o),t(U,R),_(be,R,null),t(R,bo),t(R,tt),t(R,yo),_(Q,R,null),t(U,vo),t(U,S),_(ye,S,null),t(S,Mo),t(S,ot),t(U,wo),t(U,A),_(ve,A,null),t(A,To),t(A,nt),t(U,Vo),t(U,D),_(Me,D,null),t(D,Jo),t(D,st),m(e,$t,d),_(we,e,d),m(e,Pt,d),m(e,I,d),_(Te,I,null),t(I,Co),t(I,it),t(I,jo),t(I,at),t(I,xo),t(I,Y),_(Ve,Y,null),t(Y,Uo),t(Y,rt),t(Y,Io),_(O,Y,null),t(I,Xo),t(I,K),_(Je,K,null),t(K,Zo),t(K,lt),t(I,ko),t(I,ee),_(Ce,ee,null),t(ee,Go),t(ee,dt),t(I,Wo),t(I,te),_(je,te,null),t(te,Bo),t(te,pt),m(e,Nt,d),_(xe,e,d),m(e,Rt,d),m(e,X,d),_(Ue,X,null),t(X,$o),t(X,ct),t(X,Po),t(X,mt),t(X,No),t(X,F),_(Ie,F,null),t(F,Ro),t(F,gt),t(F,Yo),_(oe,F,null),t(X,Fo),t(X,ne),_(Xe,ne,null),t(ne,Eo),t(ne,ut),t(X,Ho),t(X,se),_(Ze,se,null),t(se,zo),t(se,ft),t(X,qo),t(X,ie),_(ke,ie,null),t(ie,Lo),t(ie,ht),m(e,Yt,d),_(Ge,e,d),m(e,Ft,d),m(e,Z,d),_(We,Z,null),t(Z,Qo),t(Z,_t),t(Z,So),t(Z,bt),t(Z,Ao),t(Z,E),_(Be,E,null),t(E,Do),t(E,yt),t(E,Oo),_(ae,E,null),t(Z,Ko),t(Z,re),_($e,re,null),t(re,en),t(re,vt),t(Z,tn),t(Z,le),_(Pe,le,null),t(le,on),t(le,Mt),t(Z,nn),t(Z,de),_(Ne,de,null),t(de,sn),t(de,wt),m(e,Et,d),_(Re,e,d),m(e,Ht,d),m(e,H,d),_(Ye,H,null),t(H,an),t(H,Tt),m(e,zt,d),_(Fe,e,d),m(e,qt,d),m(e,xt,d),Lt=!0},p(e,[d]){const N={};d&2&&(N.$$scope={dirty:d,ctx:e}),L.$set(N);const Ee={};d&2&&(Ee.$$scope={dirty:d,ctx:e}),Q.$set(Ee);const He={};d&2&&(He.$$scope={dirty:d,ctx:e}),O.$set(He);const k={};d&2&&(k.$$scope={dirty:d,ctx:e}),oe.$set(k);const z={};d&2&&(z.$$scope={dirty:d,ctx:e}),ae.$set(z)},i(e){Lt||(b(j.$$.fragment,e),b(L.$$.fragment,e),b(me.$$.fragment,e),b(fe.$$.fragment,e),b(he.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(Q.$$.fragment,e),b(ye.$$.fragment,e),b(ve.$$.fragment,e),b(Me.$$.fragment,e),b(we.$$.fragment,e),b(Te.$$.fragment,e),b(Ve.$$.fragment,e),b(O.$$.fragment,e),b(Je.$$.fragment,e),b(Ce.$$.fragment,e),b(je.$$.fragment,e),b(xe.$$.fragment,e),b(Ue.$$.fragment,e),b(Ie.$$.fragment,e),b(oe.$$.fragment,e),b(Xe.$$.fragment,e),b(Ze.$$.fragment,e),b(ke.$$.fragment,e),b(Ge.$$.fragment,e),b(We.$$.fragment,e),b(Be.$$.fragment,e),b(ae.$$.fragment,e),b($e.$$.fragment,e),b(Pe.$$.fragment,e),b(Ne.$$.fragment,e),b(Re.$$.fragment,e),b(Ye.$$.fragment,e),b(Fe.$$.fragment,e),Lt=!0)},o(e){y(j.$$.fragment,e),y(L.$$.fragment,e),y(me.$$.fragment,e),y(fe.$$.fragment,e),y(he.$$.fragment,e),y(_e.$$.fragment,e),y(be.$$.fragment,e),y(Q.$$.fragment,e),y(ye.$$.fragment,e),y(ve.$$.fragment,e),y(Me.$$.fragment,e),y(we.$$.fragment,e),y(Te.$$.fragment,e),y(Ve.$$.fragment,e),y(O.$$.fragment,e),y(Je.$$.fragment,e),y(Ce.$$.fragment,e),y(je.$$.fragment,e),y(xe.$$.fragment,e),y(Ue.$$.fragment,e),y(Ie.$$.fragment,e),y(oe.$$.fragment,e),y(Xe.$$.fragment,e),y(Ze.$$.fragment,e),y(ke.$$.fragment,e),y(Ge.$$.fragment,e),y(We.$$.fragment,e),y(Be.$$.fragment,e),y(ae.$$.fragment,e),y($e.$$.fragment,e),y(Pe.$$.fragment,e),y(Ne.$$.fragment,e),y(Re.$$.fragment,e),y(Ye.$$.fragment,e),y(Fe.$$.fragment,e),Lt=!1},d(e){e&&(i(T),i(g),i(p),i(c),i(w),i(M),i(x),i(Ut),i(pe),i(It),i(q),i(Xt),i(ce),i(Zt),i(kt),i(Gt),i(W),i(Wt),i(Bt),i(U),i($t),i(Pt),i(I),i(Nt),i(Rt),i(X),i(Yt),i(Ft),i(Z),i(Et),i(Ht),i(H),i(zt),i(qt),i(xt)),i(l),v(j,e),v(L,e),v(me,e),v(fe),v(he,e),v(_e),v(be),v(Q),v(ye),v(ve),v(Me),v(we,e),v(Te),v(Ve),v(O),v(Je),v(Ce),v(je),v(xe,e),v(Ue),v(Ie),v(oe),v(Xe),v(Ze),v(ke),v(Ge,e),v(We),v(Be),v(ae),v($e),v(Pe),v(Ne),v(Re,e),v(Ye),v(Fe,e)}}}const is='{"title":"CogVideoX","local":"cogvideox","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"CogVideoXPipeline","local":"diffusers.CogVideoXPipeline","sections":[],"depth":2},{"title":"CogVideoXImageToVideoPipeline","local":"diffusers.CogVideoXImageToVideoPipeline","sections":[],"depth":2},{"title":"CogVideoXVideoToVideoPipeline","local":"diffusers.CogVideoXVideoToVideoPipeline","sections":[],"depth":2},{"title":"CogVideoXFunControlPipeline","local":"diffusers.CogVideoXFunControlPipeline","sections":[],"depth":2},{"title":"CogVideoXPipelineOutput","local":"diffusers.pipelines.cogvideo.pipeline_output.CogVideoXPipelineOutput","sections":[],"depth":2}],"depth":1}';function as(G){return Hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class us extends zn{constructor(l){super(),qn(this,l,as,ss,En,{})}}export{us as component};
