# CMStochasticIterativeScheduler

[Consistency Models](https://huggingface.co/papers/2303.01469) by Yang Song, Prafulla Dhariwal, Mark Chen, and Ilya Sutskever introduced a multistep and onestep scheduler (Algorithm 1) that is capable of generating good samples in one or a small number of steps.

The abstract from the paper is:

*Diffusion models have significantly advanced the fields of image, audio, and video generation, but they depend on an iterative sampling process that causes slow generation. To overcome this limitation, we propose consistency models, a new family of models that generate high quality samples by directly mapping noise to data. They support fast one-step generation by design, while still allowing multistep sampling to trade compute for sample quality. They also support zero-shot data editing, such as image inpainting, colorization, and super-resolution, without requiring explicit training on these tasks. Consistency models can be trained either by distilling pre-trained diffusion models, or as standalone generative models altogether. Through extensive experiments, we demonstrate that they outperform existing distillation techniques for diffusion models in one- and few-step sampling, achieving the new state-of-the-art FID of 3.55 on CIFAR-10 and 6.20 on ImageNet 64x64 for one-step generation. When trained in isolation, consistency models become a new family of generative models that can outperform existing one-step, non-adversarial generative models on standard benchmarks such as CIFAR-10, ImageNet 64x64 and LSUN 256x256.*

The original codebase can be found at [openai/consistency_models](https://github.com/openai/consistency_models).

## CMStochasticIterativeScheduler[[diffusers.CMStochasticIterativeScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.CMStochasticIterativeScheduler</name><anchor>diffusers.CMStochasticIterativeScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_models.py#L44</source><parameters>[{"name": "num_train_timesteps", "val": ": int = 40"}, {"name": "sigma_min", "val": ": float = 0.002"}, {"name": "sigma_max", "val": ": float = 80.0"}, {"name": "sigma_data", "val": ": float = 0.5"}, {"name": "s_noise", "val": ": float = 1.0"}, {"name": "rho", "val": ": float = 7.0"}, {"name": "clip_denoised", "val": ": bool = True"}]</parameters><paramsdesc>- **num_train_timesteps** (`int`, defaults to 40) --
  The number of diffusion steps to train the model.
- **sigma_min** (`float`, defaults to 0.002) --
  Minimum noise magnitude in the sigma schedule. Defaults to 0.002 from the original implementation.
- **sigma_max** (`float`, defaults to 80.0) --
  Maximum noise magnitude in the sigma schedule. Defaults to 80.0 from the original implementation.
- **sigma_data** (`float`, defaults to 0.5) --
  The standard deviation of the data distribution from the EDM
  [paper](https://huggingface.co/papers/2206.00364). Defaults to 0.5 from the original implementation.
- **s_noise** (`float`, defaults to 1.0) --
  The amount of additional noise to counteract loss of detail during sampling. A reasonable range is [1.000,
  1.011]. Defaults to 1.0 from the original implementation.
- **rho** (`float`, defaults to 7.0) --
  The parameter for calculating the Karras sigma schedule from the EDM
  [paper](https://huggingface.co/papers/2206.00364). Defaults to 7.0 from the original implementation.
- **clip_denoised** (`bool`, defaults to `True`) --
  Whether to clip the denoised outputs to `(-1, 1)`.
- **timesteps** (`List` or `np.ndarray` or `torch.Tensor`, *optional*) --
  An explicit timestep schedule that can be optionally specified. The timesteps are expected to be in
  increasing order.</paramsdesc><paramgroups>0</paramgroups></docstring>

Multistep and onestep sampling for consistency models.

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_scalings_for_boundary_condition</name><anchor>diffusers.CMStochasticIterativeScheduler.get_scalings_for_boundary_condition</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_models.py#L266</source><parameters>[{"name": "sigma", "val": ""}]</parameters><paramsdesc>- **sigma** (`torch.Tensor`) --
  The current sigma in the Karras sigma schedule.</paramsdesc><paramgroups>0</paramgroups><rettype>`tuple`</rettype><retdesc>A two-element tuple where `c_skip` (which weights the current sample) is the first element and `c_out`
(which weights the consistency model output) is the second element.</retdesc></docstring>

Gets the scalings used in the consistency model parameterization (from Appendix C of the
[paper](https://huggingface.co/papers/2303.01469)) to enforce boundary condition.

> [!TIP] > `epsilon` in the equations for `c_skip` and `c_out` is set to `sigma_min`.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_model_input</name><anchor>diffusers.CMStochasticIterativeScheduler.scale_model_input</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_models.py#L129</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Union[float, torch.Tensor]"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The input sample.
- **timestep** (`float` or `torch.Tensor`) --
  The current timestep in the diffusion chain.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Scales the consistency model input by `(sigma**2 + sigma_data**2) ** 0.5`.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_begin_index</name><anchor>diffusers.CMStochasticIterativeScheduler.set_begin_index</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_models.py#L119</source><parameters>[{"name": "begin_index", "val": ": int = 0"}]</parameters><paramsdesc>- **begin_index** (`int`) --
  The begin index for the scheduler.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the begin index for the scheduler. This function should be run from pipeline before the inference.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_timesteps</name><anchor>diffusers.CMStochasticIterativeScheduler.set_timesteps</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_models.py#L173</source><parameters>[{"name": "num_inference_steps", "val": ": typing.Optional[int] = None"}, {"name": "device", "val": ": typing.Union[str, torch.device] = None"}, {"name": "timesteps", "val": ": typing.Optional[typing.List[int]] = None"}]</parameters><paramsdesc>- **num_inference_steps** (`int`) --
  The number of diffusion steps used when generating samples with a pre-trained model.
- **device** (`str` or `torch.device`, *optional*) --
  The device to which the timesteps should be moved to. If `None`, the timesteps are not moved.
- **timesteps** (`List[int]`, *optional*) --
  Custom timesteps used to support arbitrary spacing between timesteps. If `None`, then the default
  timestep spacing strategy of equal spacing between timesteps is used. If `timesteps` is passed,
  `num_inference_steps` must be `None`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the timesteps used for the diffusion chain (to be run before inference).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>sigma_to_t</name><anchor>diffusers.CMStochasticIterativeScheduler.sigma_to_t</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_models.py#L154</source><parameters>[{"name": "sigmas", "val": ": typing.Union[float, numpy.ndarray]"}]</parameters><paramsdesc>- **sigmas** (`float` or `np.ndarray`) --
  A single Karras sigma or an array of Karras sigmas.</paramsdesc><paramgroups>0</paramgroups><rettype>`float` or `np.ndarray`</rettype><retdesc>A scaled input timestep or scaled input timestep array.</retdesc></docstring>

Gets scaled timesteps from the Karras sigmas for input to the consistency model.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.CMStochasticIterativeScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_models.py#L313</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Union[float, torch.Tensor]"}, {"name": "sample", "val": ": Tensor"}, {"name": "generator", "val": ": typing.Optional[torch._C.Generator] = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from the learned diffusion model.
- **timestep** (`float`) --
  The current timestep in the diffusion chain.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.
- **generator** (`torch.Generator`, *optional*) --
  A random number generator.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a
  [CMStochasticIterativeSchedulerOutput](/docs/diffusers/main/en/api/schedulers/cm_stochastic_iterative#diffusers.schedulers.scheduling_consistency_models.CMStochasticIterativeSchedulerOutput) or `tuple`.</paramsdesc><paramgroups>0</paramgroups><rettype>[CMStochasticIterativeSchedulerOutput](/docs/diffusers/main/en/api/schedulers/cm_stochastic_iterative#diffusers.schedulers.scheduling_consistency_models.CMStochasticIterativeSchedulerOutput) or `tuple`</rettype><retdesc>If return_dict is `True`,
[CMStochasticIterativeSchedulerOutput](/docs/diffusers/main/en/api/schedulers/cm_stochastic_iterative#diffusers.schedulers.scheduling_consistency_models.CMStochasticIterativeSchedulerOutput) is returned,
otherwise a tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the diffusion
process from the learned model outputs (most often the predicted noise).








</div></div>

## CMStochasticIterativeSchedulerOutput[[diffusers.schedulers.scheduling_consistency_models.CMStochasticIterativeSchedulerOutput]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.schedulers.scheduling_consistency_models.CMStochasticIterativeSchedulerOutput</name><anchor>diffusers.schedulers.scheduling_consistency_models.CMStochasticIterativeSchedulerOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_consistency_models.py#L31</source><parameters>[{"name": "prev_sample", "val": ": Tensor"}]</parameters><paramsdesc>- **prev_sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` for images) --
  Computed sample `(x_{t-1})` of previous timestep. `prev_sample` should be used as next model input in the
  denoising loop.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output class for the scheduler's `step` function.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/cm_stochastic_iterative.md" />