# CosineDPMSolverMultistepScheduler

The [CosineDPMSolverMultistepScheduler](/docs/diffusers/main/en/api/schedulers/cosine_dpm#diffusers.CosineDPMSolverMultistepScheduler) is a variant of [DPMSolverMultistepScheduler](/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler) with cosine schedule, proposed by Nichol and Dhariwal (2021).
It is being used in the [Stable Audio Open](https://huggingface.co/papers/2407.14358) paper and the [Stability-AI/stable-audio-tool](https://github.com/Stability-AI/stable-audio-tools) codebase.

This scheduler was contributed by [Yoach Lacombe](https://huggingface.co/ylacombe).

## CosineDPMSolverMultistepScheduler[[diffusers.CosineDPMSolverMultistepScheduler]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.CosineDPMSolverMultistepScheduler</name><anchor>diffusers.CosineDPMSolverMultistepScheduler</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L28</source><parameters>[{"name": "sigma_min", "val": ": float = 0.3"}, {"name": "sigma_max", "val": ": float = 500"}, {"name": "sigma_data", "val": ": float = 1.0"}, {"name": "sigma_schedule", "val": ": str = 'exponential'"}, {"name": "num_train_timesteps", "val": ": int = 1000"}, {"name": "solver_order", "val": ": int = 2"}, {"name": "prediction_type", "val": ": str = 'v_prediction'"}, {"name": "rho", "val": ": float = 7.0"}, {"name": "solver_type", "val": ": str = 'midpoint'"}, {"name": "lower_order_final", "val": ": bool = True"}, {"name": "euler_at_final", "val": ": bool = False"}, {"name": "final_sigmas_type", "val": ": typing.Optional[str] = 'zero'"}]</parameters><paramsdesc>- **sigma_min** (`float`, *optional*, defaults to 0.3) --
  Minimum noise magnitude in the sigma schedule. This was set to 0.3 in Stable Audio Open [1].
- **sigma_max** (`float`, *optional*, defaults to 500) --
  Maximum noise magnitude in the sigma schedule. This was set to 500 in Stable Audio Open [1].
- **sigma_data** (`float`, *optional*, defaults to 1.0) --
  The standard deviation of the data distribution. This is set to 1.0 in Stable Audio Open [1].
- **sigma_schedule** (`str`, *optional*, defaults to `exponential`) --
  Sigma schedule to compute the `sigmas`. By default, we the schedule introduced in the EDM paper
  (https://huggingface.co/papers/2206.00364). Other acceptable value is "exponential". The exponential
  schedule was incorporated in this model: https://huggingface.co/stabilityai/cosxl.
- **num_train_timesteps** (`int`, defaults to 1000) --
  The number of diffusion steps to train the model.
- **solver_order** (`int`, defaults to 2) --
  The DPMSolver order which can be `1` or `2`. It is recommended to use `solver_order=2`.
- **prediction_type** (`str`, defaults to `v_prediction`, *optional*) --
  Prediction type of the scheduler function; can be `epsilon` (predicts the noise of the diffusion process),
  `sample` (directly predicts the noisy sample`) or `v_prediction` (see section 2.4 of [Imagen
  Video](https://imagen.research.google/video/paper.pdf) paper).
- **solver_type** (`str`, defaults to `midpoint`) --
  Solver type for the second-order solver; can be `midpoint` or `heun`. The solver type slightly affects the
  sample quality, especially for a small number of steps. It is recommended to use `midpoint` solvers.
- **lower_order_final** (`bool`, defaults to `True`) --
  Whether to use lower-order solvers in the final steps. Only valid for < 15 inference steps. This can
  stabilize the sampling of DPMSolver for steps < 15, especially for steps <= 10.
- **euler_at_final** (`bool`, defaults to `False`) --
  Whether to use Euler's method in the final step. It is a trade-off between numerical stability and detail
  richness. This can stabilize the sampling of the SDE variant of DPMSolver for small number of inference
  steps, but sometimes may result in blurring.
- **final_sigmas_type** (`str`, defaults to `"zero"`) --
  The final `sigma` value for the noise schedule during the sampling process. If `"sigma_min"`, the final
  sigma is the same as the last sigma in the training schedule. If `zero`, the final sigma is set to 0.</paramsdesc><paramgroups>0</paramgroups></docstring>

Implements a variant of `DPMSolverMultistepScheduler` with cosine schedule, proposed by Nichol and Dhariwal (2021).
This scheduler was used in Stable Audio Open [1].

[1] Evans, Parker, et al. "Stable Audio Open" https://huggingface.co/papers/2407.14358

This model inherits from [SchedulerMixin](/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin) and [ConfigMixin](/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin). Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>convert_model_output</name><anchor>diffusers.CosineDPMSolverMultistepScheduler.convert_model_output</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L297</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "sample", "val": ": Tensor = None"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from the learned diffusion model.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>The converted model output.</retdesc></docstring>

Convert the model output to the corresponding type the DPMSolver/DPMSolver++ algorithm needs. DPM-Solver is
designed to discretize an integral of the noise prediction model, and DPM-Solver++ is designed to discretize an
integral of the data prediction model.

> [!TIP] > The algorithm and model type are decoupled. You can use either DPMSolver or DPMSolver++ for both
noise > prediction and data prediction models.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>dpm_solver_first_order_update</name><anchor>diffusers.CosineDPMSolverMultistepScheduler.dpm_solver_first_order_update</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L325</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "sample", "val": ": Tensor = None"}, {"name": "noise", "val": ": typing.Optional[torch.Tensor] = None"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from the learned diffusion model.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>The sample tensor at the previous timestep.</retdesc></docstring>

One step for the first-order DPMSolver (equivalent to DDIM).








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>multistep_dpm_solver_second_order_update</name><anchor>diffusers.CosineDPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L360</source><parameters>[{"name": "model_output_list", "val": ": typing.List[torch.Tensor]"}, {"name": "sample", "val": ": Tensor = None"}, {"name": "noise", "val": ": typing.Optional[torch.Tensor] = None"}]</parameters><paramsdesc>- **model_output_list** (`List[torch.Tensor]`) --
  The direct outputs from learned diffusion model at current and latter timesteps.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>The sample tensor at the previous timestep.</retdesc></docstring>

One step for the second-order multistep DPMSolver.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>scale_model_input</name><anchor>diffusers.CosineDPMSolverMultistepScheduler.scale_model_input</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L174</source><parameters>[{"name": "sample", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Union[float, torch.Tensor]"}]</parameters><paramsdesc>- **sample** (`torch.Tensor`) --
  The input sample.
- **timestep** (`int`, *optional*) --
  The current timestep in the diffusion chain.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.Tensor`</rettype><retdesc>A scaled input sample.</retdesc></docstring>

Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep. Scales the denoising model input by `(sigma**2 + 1) ** 0.5` to match the Euler algorithm.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_begin_index</name><anchor>diffusers.CosineDPMSolverMultistepScheduler.set_begin_index</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L135</source><parameters>[{"name": "begin_index", "val": ": int = 0"}]</parameters><paramsdesc>- **begin_index** (`int`) --
  The begin index for the scheduler.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the begin index for the scheduler. This function should be run from pipeline before the inference.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_timesteps</name><anchor>diffusers.CosineDPMSolverMultistepScheduler.set_timesteps</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L198</source><parameters>[{"name": "num_inference_steps", "val": ": int = None"}, {"name": "device", "val": ": typing.Union[str, torch.device] = None"}]</parameters><paramsdesc>- **num_inference_steps** (`int`) --
  The number of diffusion steps used when generating samples with a pre-trained model.
- **device** (`str` or `torch.device`, *optional*) --
  The device to which the timesteps should be moved to. If `None`, the timesteps are not moved.</paramsdesc><paramgroups>0</paramgroups></docstring>

Sets the discrete timesteps used for the diffusion chain (to be run before inference).




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>step</name><anchor>diffusers.CosineDPMSolverMultistepScheduler.step</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_cosine_dpmsolver_multistep.py#L451</source><parameters>[{"name": "model_output", "val": ": Tensor"}, {"name": "timestep", "val": ": typing.Union[int, torch.Tensor]"}, {"name": "sample", "val": ": Tensor"}, {"name": "generator", "val": " = None"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **model_output** (`torch.Tensor`) --
  The direct output from learned diffusion model.
- **timestep** (`int`) --
  The current discrete timestep in the diffusion chain.
- **sample** (`torch.Tensor`) --
  A current instance of a sample created by the diffusion process.
- **generator** (`torch.Generator`, *optional*) --
  A random number generator.
- **return_dict** (`bool`) --
  Whether or not to return a [SchedulerOutput](/docs/diffusers/main/en/api/schedulers/edm_multistep_dpm_solver#diffusers.schedulers.scheduling_utils.SchedulerOutput) or `tuple`.</paramsdesc><paramgroups>0</paramgroups><rettype>[SchedulerOutput](/docs/diffusers/main/en/api/schedulers/edm_multistep_dpm_solver#diffusers.schedulers.scheduling_utils.SchedulerOutput) or `tuple`</rettype><retdesc>If return_dict is `True`, [SchedulerOutput](/docs/diffusers/main/en/api/schedulers/edm_multistep_dpm_solver#diffusers.schedulers.scheduling_utils.SchedulerOutput) is returned, otherwise a
tuple is returned where the first element is the sample tensor.</retdesc></docstring>

Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep DPMSolver.








</div></div>

## SchedulerOutput[[diffusers.schedulers.scheduling_utils.SchedulerOutput]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.schedulers.scheduling_utils.SchedulerOutput</name><anchor>diffusers.schedulers.scheduling_utils.SchedulerOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L62</source><parameters>[{"name": "prev_sample", "val": ": Tensor"}]</parameters><paramsdesc>- **prev_sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` for images) --
  Computed sample `(x_{t-1})` of previous timestep. `prev_sample` should be used as next model input in the
  denoising loop.</paramsdesc><paramgroups>0</paramgroups></docstring>

Base class for the output of a scheduler's `step` function.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/schedulers/cosine_dpm.md" />