import{s as Ft,n as Dt,o as Yt}from"../chunks/scheduler.ed14c3fe.js";import{S as At,i as Pt,e as a,s as i,c as M,h as qt,a as p,d as t,b as n,f as Et,g as m,j as r,k as y,l as Kt,m as s,n as o,t as c,o as f,p as u}from"../chunks/index.0eb90eca.js";import{C as d}from"../chunks/CodeBlock.c826eb2a.js";import{D as Ot}from"../chunks/DocNotebookDropdown.21742870.js";import{H as $,E as es}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.432ceae3.js";function ls(tt){let b,xe,Ve,Re,v,Xe,W,Le,_,st="특정 스타일로 이미지를 생성하거나 원하는 내용을 포함하도록<code>DiffusionPipeline</code>을 설정하는 것은 까다로울 수 있습니다. 종종 만족스러운 이미지를 얻기까지 <code>DiffusionPipeline</code>을 여러 번 실행해야 하는 경우가 많습니다. 그러나 무에서 유를 창조하는 것은 특히 추론을 반복해서 실행하는 경우 계산 집약적인 프로세스입니다.",Ne,C,it="그렇기 때문에 파이프라인에서 <em>계산</em>(속도) 및 <em>메모리</em>(GPU RAM) 효율성을 극대화하여 추론 주기 사이의 시간을 단축하여 더 빠르게 반복할 수 있도록 하는 것이 중요합니다.",ze,I,nt="이 튜토리얼에서는 <code>DiffusionPipeline</code>을 사용하여 더 빠르고 효과적으로 생성하는 방법을 안내합니다.",Se,k,at='<a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> 모델을 불러와서 시작합니다:',Qe,B,Ee,V,pt="예제 프롬프트는 “portrait of an old warrior chief” 이지만, 자유롭게 자신만의 프롬프트를 사용해도 됩니다:",Fe,H,De,x,Ye,h,rt='<p>💡 GPU에 액세스할 수 없는 경우 다음과 같은 GPU 제공업체에서 무료로 사용할 수 있습니다!. <a href="https://colab.research.google.com/" rel="nofollow">Colab</a></p>',Ae,R,Mt="추론 속도를 높이는 가장 간단한 방법 중 하나는 Pytorch 모듈을 사용할 때와 같은 방식으로 GPU에 파이프라인을 배치하는 것입니다:",Pe,X,qe,L,mt='동일한 이미지를 사용하고 개선할 수 있는지 확인하려면 <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a>를 사용하고 <a href="./using-diffusers/reusing_seeds">재현성</a>에 대한 시드를 설정하세요:',Ke,N,Oe,z,ot="이제 이미지를 생성할 수 있습니다:",el,S,ll,J,ct='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_1.png"/>',tl,Q,ft="이 프로세스는 T4 GPU에서 약 30초가 소요되었습니다(할당된 GPU가 T4보다 나은 경우 더 빠를 수 있음). 기본적으로 <code>DiffusionPipeline</code>은 50개의 추론 단계에 대해 전체 <code>float32</code> 정밀도로 추론을 실행합니다. <code>float16</code>과 같은 더 낮은 정밀도로 전환하거나 추론 단계를 더 적게 실행하여 속도를 높일 수 있습니다.",sl,E,ut="<code>float16</code>으로 모델을 로드하고 이미지를 생성해 보겠습니다:",il,F,nl,w,dt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_2.png"/>',al,D,yt="이번에는 이미지를 생성하는 데 약 11초밖에 걸리지 않아 이전보다 3배 가까이 빨라졌습니다!",pl,T,bt="<p>💡 파이프라인은 항상 <code>float16</code>에서 실행할 것을 강력히 권장하며, 지금까지 출력 품질이 저하되는 경우는 거의 없었습니다.</p>",rl,Y,ht="또 다른 옵션은 추론 단계의 수를 줄이는 것입니다. 보다 효율적인 스케줄러를 선택하면 출력 품질 저하 없이 단계 수를 줄이는 데 도움이 될 수 있습니다. 현재 모델과 호환되는 스케줄러는 <code>compatibles</code> 메서드를 호출하여 <code>DiffusionPipeline</code>에서 찾을 수 있습니다:",Ml,A,ml,P,Jt="Stable Diffusion 모델은 일반적으로 약 50개의 추론 단계가 필요한 <code>PNDMScheduler</code>를 기본으로 사용하지만, <code>DPMSolverMultistepScheduler</code>와 같이 성능이 더 뛰어난 스케줄러는 약 20개 또는 25개의 추론 단계만 필요로 합니다. 새 스케줄러를 로드하려면 <code>ConfigMixin.from_config()</code> 메서드를 사용합니다:",ol,q,cl,K,wt="<code>num_inference_steps</code>를 20으로 설정합니다:",fl,O,ul,U,Tt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_3.png"/>',dl,ee,Ut="추론시간을 4초로 단축할 수 있었습니다! ⚡️",yl,le,bl,te,Zt="파이프라인 성능 향상의 또 다른 핵심은 메모리 사용량을 줄이는 것인데, 초당 생성되는 이미지 수를 최대화하려고 하는 경우가 많기 때문에 간접적으로 더 빠른 속도를 의미합니다. 한 번에 생성할 수 있는 이미지 수를 확인하는 가장 쉬운 방법은 <code>OutOfMemoryError</code>(OOM)이 발생할 때까지 다양한 배치 크기를 시도해 보는 것입니다.",hl,se,jt="프롬프트 목록과 <code>Generators</code>에서 이미지 배치를 생성하는 함수를 만듭니다. 좋은 결과를 생성하는 경우 재사용할 수 있도록 각 <code>Generator</code>에 시드를 할당해야 합니다.",Jl,ie,wl,ne,gt="또한 각 이미지 배치를 보여주는 기능이 필요합니다:",Tl,ae,Ul,pe,Gt="<code>batch_size=4</code>부터 시작해 얼마나 많은 메모리를 소비했는지 확인합니다:",Zl,re,jl,Me,$t="RAM이 더 많은 GPU가 아니라면 위의 코드에서 <code>OOM</code> 오류가 반환되었을 것입니다! 대부분의 메모리는 cross-attention 레이어가 차지합니다. 이 작업을 배치로 실행하는 대신 순차적으로 실행하면 상당한 양의 메모리를 절약할 수 있습니다. 파이프라인을 구성하여 <code>enable_attention_slicing()</code> 함수를 사용하기만 하면 됩니다:",gl,me,Gl,oe,vt="이제 <code>batch_size</code>를 8로 늘려보세요!",$l,ce,vl,Z,Wt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_5.png"/>',Wl,fe,_t="이전에는 4개의 이미지를 배치로 생성할 수도 없었지만, 이제는 이미지당 약 3.5초 만에 8개의 이미지를 배치로 생성할 수 있습니다! 이는 아마도 품질 저하 없이 T4 GPU에서 가장 빠른 속도일 것입니다.",_l,ue,Cl,de,Ct="지난 두 섹션에서는 <code>fp16</code>을 사용하여 파이프라인의 속도를 최적화하고, 더 성능이 좋은 스케줄러를 사용하여 추론 단계의 수를 줄이고, attention slicing을 활성화하여 메모리 소비를 줄이는 방법을 배웠습니다. 이제 생성된 이미지의 품질을 개선하는 방법에 대해 집중적으로 알아보겠습니다.",Il,ye,kl,be,It='가장 확실한 단계는 더 나은 체크포인트를 사용하는 것입니다. Stable Diffusion 모델은 좋은 출발점이며, 공식 출시 이후 몇 가지 개선된 버전도 출시되었습니다. 하지만 최신 버전을 사용한다고 해서 자동으로 더 나은 결과를 얻을 수 있는 것은 아닙니다. 여전히 다양한 체크포인트를 직접 실험해보고, <a href="https://minimaxir.com/2022/11/stable-diffusion-negative-prompt/" rel="nofollow">negative prompts</a> 사용 등 약간의 조사를 통해 최상의 결과를 얻어야 합니다.',Bl,he,kt='이 분야가 성장함에 따라 특정 스타일을 연출할 수 있도록 세밀하게 조정된 고품질 체크포인트가 점점 더 많아지고 있습니다. <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">Hub</a>와 <a href="https://huggingface.co/spaces/huggingface-projects/diffusers-gallery" rel="nofollow">Diffusers Gallery</a>를 둘러보고 관심 있는 것을 찾아보세요!',Vl,Je,Hl,we,Bt='현재 파이프라인 구성 요소를 최신 버전으로 교체해 볼 수도 있습니다. Stability AI의 최신 <a href="https://huggingface.co/stabilityai/stable-diffusion-2-1/tree/main/vae" rel="nofollow">autodecoder</a>를 파이프라인에 로드하고 몇 가지 이미지를 생성해 보겠습니다:',xl,Te,Rl,j,Vt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_6.png"/>',Xl,Ue,Ll,Ze,Ht="이미지를 생성하는 데 사용하는 텍스트 프롬프트는 <em>prompt engineering</em>이라고 할 정도로 매우 중요합니다. 프롬프트 엔지니어링 시 고려해야 할 몇 가지 사항은 다음과 같습니다:",Nl,je,xt="<li>생성하려는 이미지 또는 유사한 이미지가 인터넷에 어떻게 저장되어 있는가?</li> <li>내가 원하는 스타일로 모델을 유도하기 위해 어떤 추가 세부 정보를 제공할 수 있는가?</li>",zl,ge,Rt="이를 염두에 두고 색상과 더 높은 품질의 디테일을 포함하도록 프롬프트를 개선해 봅시다:",Sl,Ge,Ql,$e,Xt="새로운 프롬프트로 이미지 배치를 생성합니다:",El,ve,Fl,g,Lt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_7.png"/>',Dl,We,Nt="꽤 인상적입니다! <code>1</code>의 시드를 가진 <code>Generator</code>에 해당하는 두 번째 이미지에 피사체의 나이에 대한 텍스트를 추가하여 조금 더 조정해 보겠습니다:",Yl,_e,Al,G,zt='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_8.png"/>',Pl,Ce,ql,Ie,St="이 튜토리얼에서는 계산 및 메모리 효율을 높이고 생성된 출력의 품질을 개선하기 위해 <code>DiffusionPipeline</code>을 최적화하는 방법을 배웠습니다. 파이프라인을 더 빠르게 만드는 데 관심이 있다면 다음 리소스를 살펴보세요:",Kl,ke,Qt='<li><a href="./optimization/torch2.0">PyTorch 2.0</a> 및 <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a>이 어떻게 추론 속도를 5~300% 향상시킬 수 있는지 알아보세요. A100 GPU에서는 추론 속도가 최대 50%까지 빨라질 수 있습니다!</li> <li>PyTorch 2를 사용할 수 없는 경우, <a href="./optimization/xformers">xFormers</a>를 설치하는 것이 좋습니다. 메모리 효율적인 어텐션 메커니즘은 PyTorch 1.13.1과 함께 사용하면 속도가 빨라지고 메모리 소비가 줄어듭니다.</li> <li>모델 오프로딩과 같은 다른 최적화 기법은 <a href="./optimization/fp16">이 가이드</a>에서 다루고 있습니다.</li>',Ol,Be,et,He,lt;return v=new $({props:{title:"효과적이고 효율적인 Diffusion",local:"효과적이고-효율적인-diffusion",headingTag:"h1"}}),W=new Ot({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/ko/tensorflow/stable_diffusion.ipynb"}]}}),B=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(model_id)`,wrap:!1}}),H=new d({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMG9sZCUyMHdhcnJpb3IlMjBjaGllZiUyMg==",highlighted:'prompt = <span class="hljs-string">&quot;portrait photo of a old warrior chief&quot;</span>',wrap:!1}}),x=new $({props:{title:"속도",local:"속도",headingTag:"h2"}}),X=new d({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:'pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),N=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCk=",highlighted:`<span class="hljs-keyword">import</span> torch

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)`,wrap:!1}}),S=new d({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),F=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),A=new d({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVzJTBBJTVCJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3VuaXBjX211bHRpc3RlcC5VbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9kaXNjcmV0ZS5LRFBNMkRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9kaXNjcmV0ZS5FdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfbXVsdGlzdGVwLkRQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfc2luZ2xlc3RlcC5EUE1Tb2x2ZXJTaW5nbGVzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19rX2RwbV8yX2FuY2VzdHJhbF9kaXNjcmV0ZS5LRFBNMkFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19oZXVuX2Rpc2NyZXRlLkhldW5EaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfcG5kbS5QTkRNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9hbmNlc3RyYWxfZGlzY3JldGUuRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRpbS5ERElNU2NoZWR1bGVyJTJDJTBBJTVE",highlighted:`pipeline.scheduler.compatibles
[
    diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
    diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
    diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
    diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
    diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
    diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
    diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
    diffusers.schedulers.scheduling_pndm.PNDMScheduler,
    diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_ddim.DDIMScheduler,
]`,wrap:!1}}),q=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),O=new d({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),le=new $({props:{title:"메모리",local:"메모리",headingTag:"h2"}}),ie=new d({props:{code:"ZGVmJTIwZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNEMSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoaSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShiYXRjaF9zaXplKSU1RCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjBiYXRjaF9zaXplJTIwKiUyMCU1QnByb21wdCU1RCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyMCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnByb21wdCUyMiUzQSUyMHByb21wdHMlMkMlMjAlMjJnZW5lcmF0b3IlMjIlM0ElMjBnZW5lcmF0b3IlMkMlMjAlMjJudW1faW5mZXJlbmNlX3N0ZXBzJTIyJTNBJTIwbnVtX2luZmVyZW5jZV9zdGVwcyU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_inputs</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1</span></span>):
    generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size)]
    prompts = batch_size * [prompt]
    num_inference_steps = <span class="hljs-number">20</span>

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts, <span class="hljs-string">&quot;generator&quot;</span>: generator, <span class="hljs-string">&quot;num_inference_steps&quot;</span>: num_inference_steps}`,wrap:!1}}),ae=new d({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBJTBBZGVmJTIwaW1hZ2VfZ3JpZChpbWdzJTJDJTIwcm93cyUzRDIlMkMlMjBjb2xzJTNEMiklM0ElMEElMjAlMjAlMjAlMjB3JTJDJTIwaCUyMCUzRCUyMGltZ3MlNUIwJTVELnNpemUlMEElMjAlMjAlMjAlMjBncmlkJTIwJTNEJTIwSW1hZ2UubmV3KCUyMlJHQiUyMiUyQyUyMHNpemUlM0QoY29scyUyMColMjB3JTJDJTIwcm93cyUyMColMjBoKSklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTJDJTIwaW1nJTIwaW4lMjBlbnVtZXJhdGUoaW1ncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncmlkLnBhc3RlKGltZyUyQyUyMGJveCUzRChpJTIwJTI1JTIwY29scyUyMColMjB3JTJDJTIwaSUyMCUyRiUyRiUyMGNvbHMlMjAqJTIwaCkpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3JpZA==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image


<span class="hljs-keyword">def</span> <span class="hljs-title function_">image_grid</span>(<span class="hljs-params">imgs, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span></span>):
    w, h = imgs[<span class="hljs-number">0</span>].size
    grid = Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, size=(cols * w, rows * h))

    <span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(imgs):
        grid.paste(img, box=(i % cols * w, i // cols * h))
    <span class="hljs-keyword">return</span> grid`,wrap:!1}}),re=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q0KSkuaW1hZ2VzJTBBaW1hZ2VfZ3JpZChpbWFnZXMp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">4</span>)).images
image_grid(images)`,wrap:!1}}),me=new d({props:{code:"cGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCk=",highlighted:"pipeline.enable_attention_slicing()",wrap:!1}}),ce=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjByb3dzJTNEMiUyQyUyMGNvbHMlM0Q0KQ==",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),ue=new $({props:{title:"품질",local:"품질",headingTag:"h2"}}),ye=new $({props:{title:"더 나은 체크포인트",local:"더-나은-체크포인트",headingTag:"h3"}}),Je=new $({props:{title:"더 나은 파이프라인 구성 요소",local:"더-나은-파이프라인-구성-요소",headingTag:"h3"}}),Te=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkLXZhZS1mdC1tc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudmFlJTIwJTNEJTIwdmFlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjByb3dzJTNEMiUyQyUyMGNvbHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.vae = vae
images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),Ue=new $({props:{title:"더 나은 프롬프트 엔지니어링",local:"더-나은-프롬프트-엔지니어링",headingTag:"h3"}}),Ge=new d({props:{code:"cHJvbXB0JTIwJTJCJTNEJTIwJTIyJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMiUwQXByb21wdCUyMCUyQiUzRCUyMCUyMiUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMg==",highlighted:`prompt += <span class="hljs-string">&quot;, tribal panther make up, blue on red, side profile, looking away, serious eyes&quot;</span>
prompt += <span class="hljs-string">&quot; 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>`,wrap:!1}}),ve=new d({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjByb3dzJTNEMiUyQyUyMGNvbHMlM0Q0KQ==",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),_e=new d({props:{code:"cHJvbXB0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnBvcnRyYWl0JTIwcGhvdG8lMjBvZiUyMHRoZSUyMG9sZGVzdCUyMHdhcnJpb3IlMjBjaGllZiUyQyUyMHRyaWJhbCUyMHBhbnRoZXIlMjBtYWtlJTIwdXAlMkMlMjBibHVlJTIwb24lMjByZWQlMkMlMjBzaWRlJTIwcHJvZmlsZSUyQyUyMGxvb2tpbmclMjBhd2F5JTJDJTIwc2VyaW91cyUyMGV5ZXMlMjA1MG1tJTIwcG9ydHJhaXQlMjBwaG90b2dyYXBoeSUyQyUyMGhhcmQlMjByaW0lMjBsaWdodGluZyUyMHBob3RvZ3JhcGh5LS1iZXRhJTIwLS1hciUyMDIlM0EzJTIwJTIwLS1iZXRhJTIwLS11cGJldGElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwb3J0cmFpdCUyMHBob3RvJTIwb2YlMjBhJTIwb2xkJTIwd2FycmlvciUyMGNoaWVmJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnBvcnRyYWl0JTIwcGhvdG8lMjBvZiUyMGElMjB3YXJyaW9yJTIwY2hpZWYlMkMlMjB0cmliYWwlMjBwYW50aGVyJTIwbWFrZSUyMHVwJTJDJTIwYmx1ZSUyMG9uJTIwcmVkJTJDJTIwc2lkZSUyMHByb2ZpbGUlMkMlMjBsb29raW5nJTIwYXdheSUyQyUyMHNlcmlvdXMlMjBleWVzJTIwNTBtbSUyMHBvcnRyYWl0JTIwcGhvdG9ncmFwaHklMkMlMjBoYXJkJTIwcmltJTIwbGlnaHRpbmclMjBwaG90b2dyYXBoeS0tYmV0YSUyMC0tYXIlMjAyJTNBMyUyMCUyMC0tYmV0YSUyMC0tdXBiZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMHlvdW5nJTIwd2FycmlvciUyMGNoaWVmJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMiUyQyUwQSU1RCUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMCU1QnRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgxKSUyMGZvciUyMF8lMjBpbiUyMHJhbmdlKGxlbihwcm9tcHRzKSklNUQlMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHRzJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlMEFpbWFnZV9ncmlkKGltYWdlcyk=",highlighted:`prompts = [
    <span class="hljs-string">&quot;portrait photo of the oldest warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a old warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a young warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
]

generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompts))]
images = pipeline(prompt=prompts, generator=generator, num_inference_steps=<span class="hljs-number">25</span>).images
image_grid(images)`,wrap:!1}}),Ce=new $({props:{title:"다음 단계",local:"다음-단계",headingTag:"h2"}}),Be=new es({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/ko/stable_diffusion.md"}}),{c(){b=a("meta"),xe=i(),Ve=a("p"),Re=i(),M(v.$$.fragment),Xe=i(),M(W.$$.fragment),Le=i(),_=a("p"),_.innerHTML=st,Ne=i(),C=a("p"),C.innerHTML=it,ze=i(),I=a("p"),I.innerHTML=nt,Se=i(),k=a("p"),k.innerHTML=at,Qe=i(),M(B.$$.fragment),Ee=i(),V=a("p"),V.textContent=pt,Fe=i(),M(H.$$.fragment),De=i(),M(x.$$.fragment),Ye=i(),h=a("blockquote"),h.innerHTML=rt,Ae=i(),R=a("p"),R.textContent=Mt,Pe=i(),M(X.$$.fragment),qe=i(),L=a("p"),L.innerHTML=mt,Ke=i(),M(N.$$.fragment),Oe=i(),z=a("p"),z.textContent=ot,el=i(),M(S.$$.fragment),ll=i(),J=a("div"),J.innerHTML=ct,tl=i(),Q=a("p"),Q.innerHTML=ft,sl=i(),E=a("p"),E.innerHTML=ut,il=i(),M(F.$$.fragment),nl=i(),w=a("div"),w.innerHTML=dt,al=i(),D=a("p"),D.textContent=yt,pl=i(),T=a("blockquote"),T.innerHTML=bt,rl=i(),Y=a("p"),Y.innerHTML=ht,Ml=i(),M(A.$$.fragment),ml=i(),P=a("p"),P.innerHTML=Jt,ol=i(),M(q.$$.fragment),cl=i(),K=a("p"),K.innerHTML=wt,fl=i(),M(O.$$.fragment),ul=i(),U=a("div"),U.innerHTML=Tt,dl=i(),ee=a("p"),ee.textContent=Ut,yl=i(),M(le.$$.fragment),bl=i(),te=a("p"),te.innerHTML=Zt,hl=i(),se=a("p"),se.innerHTML=jt,Jl=i(),M(ie.$$.fragment),wl=i(),ne=a("p"),ne.textContent=gt,Tl=i(),M(ae.$$.fragment),Ul=i(),pe=a("p"),pe.innerHTML=Gt,Zl=i(),M(re.$$.fragment),jl=i(),Me=a("p"),Me.innerHTML=$t,gl=i(),M(me.$$.fragment),Gl=i(),oe=a("p"),oe.innerHTML=vt,$l=i(),M(ce.$$.fragment),vl=i(),Z=a("div"),Z.innerHTML=Wt,Wl=i(),fe=a("p"),fe.textContent=_t,_l=i(),M(ue.$$.fragment),Cl=i(),de=a("p"),de.innerHTML=Ct,Il=i(),M(ye.$$.fragment),kl=i(),be=a("p"),be.innerHTML=It,Bl=i(),he=a("p"),he.innerHTML=kt,Vl=i(),M(Je.$$.fragment),Hl=i(),we=a("p"),we.innerHTML=Bt,xl=i(),M(Te.$$.fragment),Rl=i(),j=a("div"),j.innerHTML=Vt,Xl=i(),M(Ue.$$.fragment),Ll=i(),Ze=a("p"),Ze.innerHTML=Ht,Nl=i(),je=a("ul"),je.innerHTML=xt,zl=i(),ge=a("p"),ge.textContent=Rt,Sl=i(),M(Ge.$$.fragment),Ql=i(),$e=a("p"),$e.textContent=Xt,El=i(),M(ve.$$.fragment),Fl=i(),g=a("div"),g.innerHTML=Lt,Dl=i(),We=a("p"),We.innerHTML=Nt,Yl=i(),M(_e.$$.fragment),Al=i(),G=a("div"),G.innerHTML=zt,Pl=i(),M(Ce.$$.fragment),ql=i(),Ie=a("p"),Ie.innerHTML=St,Kl=i(),ke=a("ul"),ke.innerHTML=Qt,Ol=i(),M(Be.$$.fragment),et=i(),He=a("p"),this.h()},l(e){const l=qt("svelte-u9bgzb",document.head);b=p(l,"META",{name:!0,content:!0}),l.forEach(t),xe=n(e),Ve=p(e,"P",{}),Et(Ve).forEach(t),Re=n(e),m(v.$$.fragment,e),Xe=n(e),m(W.$$.fragment,e),Le=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-18ayv9y"&&(_.innerHTML=st),Ne=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-oyyvon"&&(C.innerHTML=it),ze=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1enrctx"&&(I.innerHTML=nt),Se=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1oj4hh8"&&(k.innerHTML=at),Qe=n(e),m(B.$$.fragment,e),Ee=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-ssflff"&&(V.textContent=pt),Fe=n(e),m(H.$$.fragment,e),De=n(e),m(x.$$.fragment,e),Ye=n(e),h=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-1sothi9"&&(h.innerHTML=rt),Ae=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1rfznlg"&&(R.textContent=Mt),Pe=n(e),m(X.$$.fragment,e),qe=n(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-qirl6n"&&(L.innerHTML=mt),Ke=n(e),m(N.$$.fragment,e),Oe=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-8nqpod"&&(z.textContent=ot),el=n(e),m(S.$$.fragment,e),ll=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1of5nwm"&&(J.innerHTML=ct),tl=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-dt1sqn"&&(Q.innerHTML=ft),sl=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1jr1trd"&&(E.innerHTML=ut),il=n(e),m(F.$$.fragment,e),nl=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1why3l7"&&(w.innerHTML=dt),al=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1gv5jsc"&&(D.textContent=yt),pl=n(e),T=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1v23von"&&(T.innerHTML=bt),rl=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-a5gi7u"&&(Y.innerHTML=ht),Ml=n(e),m(A.$$.fragment,e),ml=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-gjxj1i"&&(P.innerHTML=Jt),ol=n(e),m(q.$$.fragment,e),cl=n(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-f76kxz"&&(K.innerHTML=wt),fl=n(e),m(O.$$.fragment,e),ul=n(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-19w49w4"&&(U.innerHTML=Tt),dl=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-gcc2pb"&&(ee.textContent=Ut),yl=n(e),m(le.$$.fragment,e),bl=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-nqgs99"&&(te.innerHTML=Zt),hl=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-j2noup"&&(se.innerHTML=jt),Jl=n(e),m(ie.$$.fragment,e),wl=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-wyajyh"&&(ne.textContent=gt),Tl=n(e),m(ae.$$.fragment,e),Ul=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-ubrl9r"&&(pe.innerHTML=Gt),Zl=n(e),m(re.$$.fragment,e),jl=n(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-i1t4xo"&&(Me.innerHTML=$t),gl=n(e),m(me.$$.fragment,e),Gl=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-u177c0"&&(oe.innerHTML=vt),$l=n(e),m(ce.$$.fragment,e),vl=n(e),Z=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-vxa9bu"&&(Z.innerHTML=Wt),Wl=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1nhne3o"&&(fe.textContent=_t),_l=n(e),m(ue.$$.fragment,e),Cl=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-yzzx1p"&&(de.innerHTML=Ct),Il=n(e),m(ye.$$.fragment,e),kl=n(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-97fik6"&&(be.innerHTML=It),Bl=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1pk1tvb"&&(he.innerHTML=kt),Vl=n(e),m(Je.$$.fragment,e),Hl=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-3m63vd"&&(we.innerHTML=Bt),xl=n(e),m(Te.$$.fragment,e),Rl=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-610rhb"&&(j.innerHTML=Vt),Xl=n(e),m(Ue.$$.fragment,e),Ll=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-15owmr0"&&(Ze.innerHTML=Ht),Nl=n(e),je=p(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-1y16yq3"&&(je.innerHTML=xt),zl=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-17wtiaq"&&(ge.textContent=Rt),Sl=n(e),m(Ge.$$.fragment,e),Ql=n(e),$e=p(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-8cwtf"&&($e.textContent=Xt),El=n(e),m(ve.$$.fragment,e),Fl=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-n1o5lk"&&(g.innerHTML=Lt),Dl=n(e),We=p(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1a7wb1e"&&(We.innerHTML=Nt),Yl=n(e),m(_e.$$.fragment,e),Al=n(e),G=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-1lkw2bx"&&(G.innerHTML=zt),Pl=n(e),m(Ce.$$.fragment,e),ql=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-10t9jtg"&&(Ie.innerHTML=St),Kl=n(e),ke=p(e,"UL",{"data-svelte-h":!0}),r(ke)!=="svelte-1xpkcqm"&&(ke.innerHTML=Qt),Ol=n(e),m(Be.$$.fragment,e),et=n(e),He=p(e,"P",{}),Et(He).forEach(t),this.h()},h(){y(b,"name","hf:doc:metadata"),y(b,"content",ts),y(h,"class","tip"),y(J,"class","flex justify-center"),y(w,"class","flex justify-center"),y(T,"class","tip"),y(U,"class","flex justify-center"),y(Z,"class","flex justify-center"),y(j,"class","flex justify-center"),y(g,"class","flex justify-center"),y(G,"class","flex justify-center")},m(e,l){Kt(document.head,b),s(e,xe,l),s(e,Ve,l),s(e,Re,l),o(v,e,l),s(e,Xe,l),o(W,e,l),s(e,Le,l),s(e,_,l),s(e,Ne,l),s(e,C,l),s(e,ze,l),s(e,I,l),s(e,Se,l),s(e,k,l),s(e,Qe,l),o(B,e,l),s(e,Ee,l),s(e,V,l),s(e,Fe,l),o(H,e,l),s(e,De,l),o(x,e,l),s(e,Ye,l),s(e,h,l),s(e,Ae,l),s(e,R,l),s(e,Pe,l),o(X,e,l),s(e,qe,l),s(e,L,l),s(e,Ke,l),o(N,e,l),s(e,Oe,l),s(e,z,l),s(e,el,l),o(S,e,l),s(e,ll,l),s(e,J,l),s(e,tl,l),s(e,Q,l),s(e,sl,l),s(e,E,l),s(e,il,l),o(F,e,l),s(e,nl,l),s(e,w,l),s(e,al,l),s(e,D,l),s(e,pl,l),s(e,T,l),s(e,rl,l),s(e,Y,l),s(e,Ml,l),o(A,e,l),s(e,ml,l),s(e,P,l),s(e,ol,l),o(q,e,l),s(e,cl,l),s(e,K,l),s(e,fl,l),o(O,e,l),s(e,ul,l),s(e,U,l),s(e,dl,l),s(e,ee,l),s(e,yl,l),o(le,e,l),s(e,bl,l),s(e,te,l),s(e,hl,l),s(e,se,l),s(e,Jl,l),o(ie,e,l),s(e,wl,l),s(e,ne,l),s(e,Tl,l),o(ae,e,l),s(e,Ul,l),s(e,pe,l),s(e,Zl,l),o(re,e,l),s(e,jl,l),s(e,Me,l),s(e,gl,l),o(me,e,l),s(e,Gl,l),s(e,oe,l),s(e,$l,l),o(ce,e,l),s(e,vl,l),s(e,Z,l),s(e,Wl,l),s(e,fe,l),s(e,_l,l),o(ue,e,l),s(e,Cl,l),s(e,de,l),s(e,Il,l),o(ye,e,l),s(e,kl,l),s(e,be,l),s(e,Bl,l),s(e,he,l),s(e,Vl,l),o(Je,e,l),s(e,Hl,l),s(e,we,l),s(e,xl,l),o(Te,e,l),s(e,Rl,l),s(e,j,l),s(e,Xl,l),o(Ue,e,l),s(e,Ll,l),s(e,Ze,l),s(e,Nl,l),s(e,je,l),s(e,zl,l),s(e,ge,l),s(e,Sl,l),o(Ge,e,l),s(e,Ql,l),s(e,$e,l),s(e,El,l),o(ve,e,l),s(e,Fl,l),s(e,g,l),s(e,Dl,l),s(e,We,l),s(e,Yl,l),o(_e,e,l),s(e,Al,l),s(e,G,l),s(e,Pl,l),o(Ce,e,l),s(e,ql,l),s(e,Ie,l),s(e,Kl,l),s(e,ke,l),s(e,Ol,l),o(Be,e,l),s(e,et,l),s(e,He,l),lt=!0},p:Dt,i(e){lt||(c(v.$$.fragment,e),c(W.$$.fragment,e),c(B.$$.fragment,e),c(H.$$.fragment,e),c(x.$$.fragment,e),c(X.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(F.$$.fragment,e),c(A.$$.fragment,e),c(q.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(ye.$$.fragment,e),c(Je.$$.fragment,e),c(Te.$$.fragment,e),c(Ue.$$.fragment,e),c(Ge.$$.fragment,e),c(ve.$$.fragment,e),c(_e.$$.fragment,e),c(Ce.$$.fragment,e),c(Be.$$.fragment,e),lt=!0)},o(e){f(v.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(H.$$.fragment,e),f(x.$$.fragment,e),f(X.$$.fragment,e),f(N.$$.fragment,e),f(S.$$.fragment,e),f(F.$$.fragment,e),f(A.$$.fragment,e),f(q.$$.fragment,e),f(O.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(me.$$.fragment,e),f(ce.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),f(Je.$$.fragment,e),f(Te.$$.fragment,e),f(Ue.$$.fragment,e),f(Ge.$$.fragment,e),f(ve.$$.fragment,e),f(_e.$$.fragment,e),f(Ce.$$.fragment,e),f(Be.$$.fragment,e),lt=!1},d(e){e&&(t(xe),t(Ve),t(Re),t(Xe),t(Le),t(_),t(Ne),t(C),t(ze),t(I),t(Se),t(k),t(Qe),t(Ee),t(V),t(Fe),t(De),t(Ye),t(h),t(Ae),t(R),t(Pe),t(qe),t(L),t(Ke),t(Oe),t(z),t(el),t(ll),t(J),t(tl),t(Q),t(sl),t(E),t(il),t(nl),t(w),t(al),t(D),t(pl),t(T),t(rl),t(Y),t(Ml),t(ml),t(P),t(ol),t(cl),t(K),t(fl),t(ul),t(U),t(dl),t(ee),t(yl),t(bl),t(te),t(hl),t(se),t(Jl),t(wl),t(ne),t(Tl),t(Ul),t(pe),t(Zl),t(jl),t(Me),t(gl),t(Gl),t(oe),t($l),t(vl),t(Z),t(Wl),t(fe),t(_l),t(Cl),t(de),t(Il),t(kl),t(be),t(Bl),t(he),t(Vl),t(Hl),t(we),t(xl),t(Rl),t(j),t(Xl),t(Ll),t(Ze),t(Nl),t(je),t(zl),t(ge),t(Sl),t(Ql),t($e),t(El),t(Fl),t(g),t(Dl),t(We),t(Yl),t(Al),t(G),t(Pl),t(ql),t(Ie),t(Kl),t(ke),t(Ol),t(et),t(He)),t(b),u(v,e),u(W,e),u(B,e),u(H,e),u(x,e),u(X,e),u(N,e),u(S,e),u(F,e),u(A,e),u(q,e),u(O,e),u(le,e),u(ie,e),u(ae,e),u(re,e),u(me,e),u(ce,e),u(ue,e),u(ye,e),u(Je,e),u(Te,e),u(Ue,e),u(Ge,e),u(ve,e),u(_e,e),u(Ce,e),u(Be,e)}}}const ts='{"title":"효과적이고 효율적인 Diffusion","local":"효과적이고-효율적인-diffusion","sections":[{"title":"속도","local":"속도","sections":[],"depth":2},{"title":"메모리","local":"메모리","sections":[],"depth":2},{"title":"품질","local":"품질","sections":[{"title":"더 나은 체크포인트","local":"더-나은-체크포인트","sections":[],"depth":3},{"title":"더 나은 파이프라인 구성 요소","local":"더-나은-파이프라인-구성-요소","sections":[],"depth":3},{"title":"더 나은 프롬프트 엔지니어링","local":"더-나은-프롬프트-엔지니어링","sections":[],"depth":3}],"depth":2},{"title":"다음 단계","local":"다음-단계","sections":[],"depth":2}],"depth":1}';function ss(tt){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ms extends At{constructor(b){super(),Pt(this,b,ss,ls,Ft,{})}}export{Ms as component};
