import{s as ds,n as bs,o as fs}from"../chunks/scheduler.7da89386.js";import{S as js,i as Ms,g as p,s as l,r,A as ys,h as o,f as a,c as n,j as gs,u as h,x as m,k as C,y as ws,a as e,v as u,d as g,t as d,w as b}from"../chunks/index.0b7befd3.js";import{C as Q}from"../chunks/CodeBlock.ce33a881.js";import{H as es}from"../chunks/Heading.8a936589.js";function Ts(ls){let c,v,$,F,f,V,i,ns='<img alt="Open In Colab" class="!m-0" src="https://colab.research.google.com/assets/colab-badge.svg"/>',H,j,ps='<code>Safetensors</code> is really fast. Let’s compare it against <code>PyTorch</code> by loading <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a> weights. To run the <a href="#gpu-benchmark">GPU benchmark</a>, make sure your machine has GPU or you have selected <code>GPU runtime</code> if you are using Google Colab.',Y,M,os="Before you begin, make sure you have all the necessary libraries installed:",N,y,q,w,is="Let’s start by importing all the packages that will be used:",S,T,x,J,cs="Download safetensors & torch weights for gpt2:",E,U,L,Z,P,_,A,G,ms=`This speedup is due to the fact that this library avoids unnecessary copies by mapping the file directly. It is actually possible to do on <a href="https://gist.github.com/Narsil/3edeec2669a5e94e4707aa0f901d2282" rel="nofollow">pure pytorch</a>.
The currently shown speedup was gotten on:`,z,W,rs="<li>OS: Ubuntu 18.04.6 LTS</li> <li>CPU: Intel(R) Xeon(R) CPU @ 2.00GHz</li>",K,B,D,I,O,k,hs=`The speedup works because this library is able to skip unnecessary CPU allocations. It is unfortunately not replicable in pure pytorch as far as we know. The library works by memory mapping the file, creating the tensor empty with pytorch and calling <code>cudaMemcpy</code> directly to move the tensor directly on the GPU.
The currently shown speedup was gotten on:`,ss,R,us="<li>OS: Ubuntu 18.04.6 LTS.</li> <li>GPU: Tesla T4</li> <li>Driver Version: 460.32.03</li> <li>CUDA Version: 11.2</li>",ts,X,as;return f=new es({props:{title:"Speed Comparison",local:"speed-comparison",headingTag:"h1"}}),y=new Q({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZmV0ZW5zb3JzJTIwaHVnZ2luZ2ZhY2VfaHViJTIwdG9yY2g=",highlighted:"pip install safetensors huggingface_hub torch",wrap:!1}}),T=new Q({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBkYXRldGltZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEFmcm9tJTIwc2FmZXRlbnNvcnMudG9yY2glMjBpbXBvcnQlMjBsb2FkX2ZpbGUlMEFpbXBvcnQlMjB0b3JjaA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> datetime
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_file
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch`,wrap:!1}}),U=new Q({props:{code:"c2ZfZmlsZW5hbWUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTIyZ3B0MiUyMiUyQyUyMGZpbGVuYW1lJTNEJTIybW9kZWwuc2FmZXRlbnNvcnMlMjIpJTBBcHRfZmlsZW5hbWUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTIyZ3B0MiUyMiUyQyUyMGZpbGVuYW1lJTNEJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sf_filename = hf_hub_download(<span class="hljs-string">&quot;gpt2&quot;</span>, filename=<span class="hljs-string">&quot;model.safetensors&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pt_filename = hf_hub_download(<span class="hljs-string">&quot;gpt2&quot;</span>, filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),Z=new es({props:{title:"CPU benchmark",local:"cpu-benchmark",headingTag:"h3"}}),_=new Q({props:{code:"c3RhcnRfc3QlMjAlM0QlMjBkYXRldGltZS5kYXRldGltZS5ub3coKSUwQXdlaWdodHMlMjAlM0QlMjBsb2FkX2ZpbGUoc2ZfZmlsZW5hbWUlMkMlMjBkZXZpY2UlM0QlMjJjcHUlMjIpJTBBbG9hZF90aW1lX3N0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMjAtJTIwc3RhcnRfc3QlMEFwcmludChmJTIyTG9hZGVkJTIwc2FmZXRlbnNvcnMlMjAlN0Jsb2FkX3RpbWVfc3QlN0QlMjIpJTBBJTBBc3RhcnRfcHQlMjAlM0QlMjBkYXRldGltZS5kYXRldGltZS5ub3coKSUwQXdlaWdodHMlMjAlM0QlMjB0b3JjaC5sb2FkKHB0X2ZpbGVuYW1lJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQWxvYWRfdGltZV9wdCUyMCUzRCUyMGRhdGV0aW1lLmRhdGV0aW1lLm5vdygpJTIwLSUyMHN0YXJ0X3B0JTBBcHJpbnQoZiUyMkxvYWRlZCUyMHB5dG9yY2glMjAlN0Jsb2FkX3RpbWVfcHQlN0QlMjIpJTBBJTBBcHJpbnQoZiUyMm9uJTIwQ1BVJTJDJTIwc2FmZXRlbnNvcnMlMjBpcyUyMGZhc3RlciUyMHRoYW4lMjBweXRvcmNoJTIwYnklM0ElMjAlN0Jsb2FkX3RpbWVfcHQlMkZsb2FkX3RpbWVfc3QlM0EuMWYlN0QlMjBYJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start_st = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = load_file(sf_filename, device=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_st = datetime.datetime.now() - start_st
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded safetensors <span class="hljs-subst">{load_time_st}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>start_pt = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = torch.load(pt_filename, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_pt = datetime.datetime.now() - start_pt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded pytorch <span class="hljs-subst">{load_time_pt}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;on CPU, safetensors is faster than pytorch by: <span class="hljs-subst">{load_time_pt/load_time_st:<span class="hljs-number">.1</span>f}</span> X&quot;</span>)
Loaded safetensors <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.004015</span>
Loaded pytorch <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.307460</span>
on CPU, safetensors <span class="hljs-keyword">is</span> faster than pytorch by: <span class="hljs-number">76.6</span> X`,wrap:!1}}),B=new es({props:{title:"GPU benchmark",local:"gpu-benchmark",headingTag:"h3"}}),I=new Q({props:{code:"JTIzJTIwVGhpcyUyMGlzJTIwcmVxdWlyZWQlMjBiZWNhdXNlJTIwdGhpcyUyMGZlYXR1cmUlMjBoYXNuJ3QlMjBiZWVuJTIwZnVsbHklMjB2ZXJpZmllZCUyMHlldCUyQyUyMGJ1dCUyMCUwQSUyMyUyMGl0J3MlMjBiZWVuJTIwdGVzdGVkJTIwb24lMjBtYW55JTIwZGlmZmVyZW50JTIwZW52aXJvbm1lbnRzJTBBb3MuZW52aXJvbiU1QiUyMlNBRkVURU5TT1JTX0ZBU1RfR1BVJTIyJTVEJTIwJTNEJTIwJTIyMSUyMiUwQSUwQSUyMyUyMENVREElMjBzdGFydHVwJTIwb3V0JTIwb2YlMjB0aGUlMjBtZWFzdXJlbWVudCUwQXRvcmNoLnplcm9zKCgyJTJDJTIwMikpLmN1ZGEoKSUwQSUwQXN0YXJ0X3N0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMEF3ZWlnaHRzJTIwJTNEJTIwbG9hZF9maWxlKHNmX2ZpbGVuYW1lJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUzQTAlMjIpJTBBbG9hZF90aW1lX3N0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMjAtJTIwc3RhcnRfc3QlMEFwcmludChmJTIyTG9hZGVkJTIwc2FmZXRlbnNvcnMlMjAlN0Jsb2FkX3RpbWVfc3QlN0QlMjIpJTBBJTBBc3RhcnRfcHQlMjAlM0QlMjBkYXRldGltZS5kYXRldGltZS5ub3coKSUwQXdlaWdodHMlMjAlM0QlMjB0b3JjaC5sb2FkKHB0X2ZpbGVuYW1lJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3VkYSUzQTAlMjIpJTBBbG9hZF90aW1lX3B0JTIwJTNEJTIwZGF0ZXRpbWUuZGF0ZXRpbWUubm93KCklMjAtJTIwc3RhcnRfcHQlMEFwcmludChmJTIyTG9hZGVkJTIwcHl0b3JjaCUyMCU3QmxvYWRfdGltZV9wdCU3RCUyMiklMEElMEFwcmludChmJTIyb24lMjBHUFUlMkMlMjBzYWZldGVuc29ycyUyMGlzJTIwZmFzdGVyJTIwdGhhbiUyMHB5dG9yY2glMjBieSUzQSUyMCU3QmxvYWRfdGltZV9wdCUyRmxvYWRfdGltZV9zdCUzQS4xZiU3RCUyMFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is required because this feature hasn&#x27;t been fully verified yet, but </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it&#x27;s been tested on many different environments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;SAFETENSORS_FAST_GPU&quot;</span>] = <span class="hljs-string">&quot;1&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CUDA startup out of the measurement</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>torch.zeros((<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)).cuda()

<span class="hljs-meta">&gt;&gt;&gt; </span>start_st = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = load_file(sf_filename, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_st = datetime.datetime.now() - start_st
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded safetensors <span class="hljs-subst">{load_time_st}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>start_pt = datetime.datetime.now()
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = torch.load(pt_filename, map_location=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>load_time_pt = datetime.datetime.now() - start_pt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loaded pytorch <span class="hljs-subst">{load_time_pt}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;on GPU, safetensors is faster than pytorch by: <span class="hljs-subst">{load_time_pt/load_time_st:<span class="hljs-number">.1</span>f}</span> X&quot;</span>)
Loaded safetensors <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.165206</span>
Loaded pytorch <span class="hljs-number">0</span>:<span class="hljs-number">00</span>:<span class="hljs-number">00.353889</span>
on GPU, safetensors <span class="hljs-keyword">is</span> faster than pytorch by: <span class="hljs-number">2.1</span> X`,wrap:!1}}),{c(){c=p("meta"),v=l(),$=p("p"),F=l(),r(f.$$.fragment),V=l(),i=p("a"),i.innerHTML=ns,H=l(),j=p("p"),j.innerHTML=ps,Y=l(),M=p("p"),M.textContent=os,N=l(),r(y.$$.fragment),q=l(),w=p("p"),w.textContent=is,S=l(),r(T.$$.fragment),x=l(),J=p("p"),J.textContent=cs,E=l(),r(U.$$.fragment),L=l(),r(Z.$$.fragment),P=l(),r(_.$$.fragment),A=l(),G=p("p"),G.innerHTML=ms,z=l(),W=p("ul"),W.innerHTML=rs,K=l(),r(B.$$.fragment),D=l(),r(I.$$.fragment),O=l(),k=p("p"),k.innerHTML=hs,ss=l(),R=p("ul"),R.innerHTML=us,ts=l(),X=p("p"),this.h()},l(s){const t=ys("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),v=n(s),$=o(s,"P",{}),gs($).forEach(a),F=n(s),h(f.$$.fragment,s),V=n(s),i=o(s,"A",{href:!0,target:!0,class:!0,"data-svelte-h":!0}),m(i)!=="svelte-lfr1jd"&&(i.innerHTML=ns),H=n(s),j=o(s,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1f2qiql"&&(j.innerHTML=ps),Y=n(s),M=o(s,"P",{"data-svelte-h":!0}),m(M)!=="svelte-1c9nexd"&&(M.textContent=os),N=n(s),h(y.$$.fragment,s),q=n(s),w=o(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-x2g6fp"&&(w.textContent=is),S=n(s),h(T.$$.fragment,s),x=n(s),J=o(s,"P",{"data-svelte-h":!0}),m(J)!=="svelte-ppqluq"&&(J.textContent=cs),E=n(s),h(U.$$.fragment,s),L=n(s),h(Z.$$.fragment,s),P=n(s),h(_.$$.fragment,s),A=n(s),G=o(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-12qeleu"&&(G.innerHTML=ms),z=n(s),W=o(s,"UL",{"data-svelte-h":!0}),m(W)!=="svelte-1truf0w"&&(W.innerHTML=rs),K=n(s),h(B.$$.fragment,s),D=n(s),h(I.$$.fragment,s),O=n(s),k=o(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1c8g3ot"&&(k.innerHTML=hs),ss=n(s),R=o(s,"UL",{"data-svelte-h":!0}),m(R)!=="svelte-1emnou5"&&(R.innerHTML=us),ts=n(s),X=o(s,"P",{}),gs(X).forEach(a),this.h()},h(){C(c,"name","hf:doc:metadata"),C(c,"content",Js),C(i,"href","https://colab.research.google.com/github/huggingface/notebooks/blob/main/safetensors_doc/en/speed.ipynb"),C(i,"target","_blank"),C(i,"class","absolute z-10 right-0 top-0")},m(s,t){ws(document.head,c),e(s,v,t),e(s,$,t),e(s,F,t),u(f,s,t),e(s,V,t),e(s,i,t),e(s,H,t),e(s,j,t),e(s,Y,t),e(s,M,t),e(s,N,t),u(y,s,t),e(s,q,t),e(s,w,t),e(s,S,t),u(T,s,t),e(s,x,t),e(s,J,t),e(s,E,t),u(U,s,t),e(s,L,t),u(Z,s,t),e(s,P,t),u(_,s,t),e(s,A,t),e(s,G,t),e(s,z,t),e(s,W,t),e(s,K,t),u(B,s,t),e(s,D,t),u(I,s,t),e(s,O,t),e(s,k,t),e(s,ss,t),e(s,R,t),e(s,ts,t),e(s,X,t),as=!0},p:bs,i(s){as||(g(f.$$.fragment,s),g(y.$$.fragment,s),g(T.$$.fragment,s),g(U.$$.fragment,s),g(Z.$$.fragment,s),g(_.$$.fragment,s),g(B.$$.fragment,s),g(I.$$.fragment,s),as=!0)},o(s){d(f.$$.fragment,s),d(y.$$.fragment,s),d(T.$$.fragment,s),d(U.$$.fragment,s),d(Z.$$.fragment,s),d(_.$$.fragment,s),d(B.$$.fragment,s),d(I.$$.fragment,s),as=!1},d(s){s&&(a(v),a($),a(F),a(V),a(i),a(H),a(j),a(Y),a(M),a(N),a(q),a(w),a(S),a(x),a(J),a(E),a(L),a(P),a(A),a(G),a(z),a(W),a(K),a(D),a(O),a(k),a(ss),a(R),a(ts),a(X)),a(c),b(f,s),b(y,s),b(T,s),b(U,s),b(Z,s),b(_,s),b(B,s),b(I,s)}}}const Js='{"title":"Speed Comparison","local":"speed-comparison","sections":[{"title":"CPU benchmark","local":"cpu-benchmark","sections":[],"depth":3},{"title":"GPU benchmark","local":"gpu-benchmark","sections":[],"depth":3}],"depth":1}';function Us(ls){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bs extends js{constructor(c){super(),Ms(this,c,Us,Ts,ds,{})}}export{Bs as component};
