import{s as Ct,o as xt,n as we}from"../chunks/scheduler.18a86fab.js";import{S as It,i as jt,g as m,s as r,r as h,A as zt,h as c,f as a,c as i,j as ie,u,x as M,k as N,y as p,a as s,v as f,d as g,t as b,w as _}from"../chunks/index.98837b22.js";import{T as $t}from"../chunks/Tip.77304350.js";import{D as Te}from"../chunks/Docstring.6758ea23.js";import{C as ye}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as it}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as le}from"../chunks/Heading.7e7e0c5b.js";import{E as Ut}from"../chunks/index.499f366c.js";function Wt(x){let o,w="Example:",l,d,T;return d=new ye({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hbWJhMkNvbmZpZyUyQyUyME1hbWJhMk1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1hbWJhMiUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTWFtYmEyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1hbWJhMk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Mamba2Config, Mamba2Model

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mamba2 configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Mamba2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mamba2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=w,l=r(),h(d.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),M(o)!=="svelte-11lpom8"&&(o.textContent=w),l=i(n),u(d.$$.fragment,n)},m(n,y){s(n,o,y),s(n,l,y),f(d,n,y),T=!0},p:we,i(n){T||(g(d.$$.fragment,n),T=!0)},o(n){b(d.$$.fragment,n),T=!1},d(n){n&&(a(o),a(l)),_(d,n)}}}function Zt(x){let o,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=w},l(l){o=c(l,"P",{"data-svelte-h":!0}),M(o)!=="svelte-fincs2"&&(o.innerHTML=w)},m(l,d){s(l,o,d)},p:we,d(l){l&&a(o)}}}function Bt(x){let o,w="Example:",l,d,T;return d=new ye({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYW1iYTJNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGbWFtYmEtY29kZXN0cmFsLTdCLXYwLjElMjIpJTBBbW9kZWwlMjAlM0QlMjBNYW1iYTJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGbWFtYmEtY29kZXN0cmFsLTdCLXYwLjElMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Mamba2Model
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/mamba-codestral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mamba2Model.from_pretrained(<span class="hljs-string">&quot;mistralai/mamba-codestral-7B-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){o=m("p"),o.textContent=w,l=r(),h(d.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),M(o)!=="svelte-11lpom8"&&(o.textContent=w),l=i(n),u(d.$$.fragment,n)},m(n,y){s(n,o,y),s(n,l,y),f(d,n,y),T=!0},p:we,i(n){T||(g(d.$$.fragment,n),T=!0)},o(n){b(d.$$.fragment,n),T=!1},d(n){n&&(a(o),a(l)),_(d,n)}}}function Ft(x){let o,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=w},l(l){o=c(l,"P",{"data-svelte-h":!0}),M(o)!=="svelte-fincs2"&&(o.innerHTML=w)},m(l,d){s(l,o,d)},p:we,d(l){l&&a(o)}}}function Xt(x){let o,w="Example:",l,d,T;return d=new ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1hbWJhMkZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGbWFtYmEtY29kZXN0cmFsLTdCLXYwLjElMjIpJTBBbW9kZWwlMjAlM0QlMjBNYW1iYTJGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGbWFtYmEtY29kZXN0cmFsLTdCLXYwLjElMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Mamba2ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/mamba-codestral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mamba2ForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/mamba-codestral-7B-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){o=m("p"),o.textContent=w,l=r(),h(d.$$.fragment)},l(n){o=c(n,"P",{"data-svelte-h":!0}),M(o)!=="svelte-11lpom8"&&(o.textContent=w),l=i(n),u(d.$$.fragment,n)},m(n,y){s(n,o,y),s(n,l,y),f(d,n,y),T=!0},p:we,i(n){T||(g(d.$$.fragment,n),T=!0)},o(n){b(d.$$.fragment,n),T=!1},d(n){n&&(a(o),a(l)),_(d,n)}}}function Rt(x){let o,w,l,d,T,n,y,lt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Je,E,ve,G,dt='The Mamba2 model was proposed in <a href="https://arxiv.org/abs/2405.21060" rel="nofollow">Transformers are SSMs: Generalized Models and Efficient Algorithms Through Structured State Space Duality</a> by Tri Dao and Albert Gu. It is a State Space Model similar to Mamba 1, with better performances in a simplified architecture.',ke,H,mt="The abstract from the paper is the following:",$e,L,ct="<em>While Transformers have been the main architecture behind deep learning’s success in language modeling, state-space models (SSMs) such as Mamba have recently been shown to match or outperform Transformers at small to medium scale. We show that these families of models are actually quite closely related, and develop a rich framework of theoretical connections between SSMs and variants of attention, connected through various decompositions of a well-studied class of structured semiseparable matrices. Our state space duality (SSD) framework allows us to design a new architecture (Mamba-2) whose core layer is an a refinement of Mamba’s selective SSM that is 2-8X faster, while continuing to be competitive with Transformers on language modeling.</em>",Ce,V,pt="Tips:",xe,q,ht=`This version should support all implementations of Mamba 2, and in particular <a href="https://huggingface.co/mistralai/Mamba-Codestral-7B-v0.1" rel="nofollow">Mamba-2 codestral</a> from Mistral AI. In particular, mamba 2 codestral was released with a number of <code>groups</code> equal to 8, which can be thought intuitively as similar to the number of kv heads in an attention-based model.
This model has two different forward passes, <code>torch_forward</code> or <code>cuda_kernels_forward</code>. The latter uses the original cuda kernels if they are found in your environment, and is slower on the prefill i.e. requires a “warmup run” due to high cpu overhead, see <a href="https://github.com/state-spaces/mamba/issues/389#issuecomment-2171755306" rel="nofollow">here</a> and <a href="https://github.com/state-spaces/mamba/issues/355#issuecomment-2147597457" rel="nofollow">also here</a>. Without compilation, the <code>torch_forward</code> implementation is faster by a factor 3 to 4. Further, there are no positional embeddings in this model, but there is an <code>attention_mask</code> and a specific logic to mask out hidden states in two places in the case of batched generation, see <a href="https://github.com/state-spaces/mamba/issues/66#issuecomment-1863563829" rel="nofollow">here</a> as well. Due to this, in addition to the reimplementation of mamba2 kernels, batched generation and cached generation are expected to have slight discrepancies. Further, the results given by the cuda kernels or the torch forward are expected to be slightly different. The SSM algorithm heavily relies on tensor contractions, which have matmul equivalents but the order of operations is slightly different, making the difference greater at smaller precisions.
Another note, shutdown of hidden states corresponding to padding tokens is done in 2 places and mostly has been tested with left-padding. Right-padding will propagate noise down the line and is not guaranteed to yield satisfactory results. <code>tokenizer.padding_side = &quot;left&quot;</code> ensures you are using the correct padding side.`,Ie,Y,ut=`This model was contributed by <a href="https://huggingface.co/Molbap" rel="nofollow">Molbap</a>, with tremendous help from <a href="https://github.com/vasqu" rel="nofollow">Anton Vlasjuk</a>.
The original code can be found <a href="https://github.com/state-spaces/mamba" rel="nofollow">here</a>.`,je,Q,ze,A,Ue,S,We,P,ft="Here’s a draft script for finetuning:",Ze,D,Be,O,Fe,k,K,Ve,de,gt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Model">Mamba2Model</a>. It is used to instantiate a MAMBA2
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the MAMBA2
<a href="https://huggingface.co/state-spaces/mamba2-2.8b" rel="nofollow">state-spaces/mamba2-2.8b</a> architecture.`,qe,me,bt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ye,Z,Xe,ee,Re,J,te,Qe,ce,_t="The bare MAMBA2 Model transformer outputting raw hidden-states without any specific head on top.",Ae,pe,Mt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Se,he,Tt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pe,I,ae,De,ue,yt='The <a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Model">Mamba2Model</a> forward method, overrides the <code>__call__</code> special method.',Oe,B,Ke,F,Ne,oe,Ee,v,ne,et,fe,wt=`The MAMBA2 Model transformer with a language modeling head on top (linear layer with weights not tied to the input
embeddings).`,tt,ge,Jt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,at,be,vt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ot,j,se,nt,_e,kt='The <a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2ForCausalLM">Mamba2ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',st,X,rt,R,Ge,re,He,Me,Le;return T=new le({props:{title:"Mamba 2",local:"mamba-2",headingTag:"h1"}}),E=new le({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Q=new le({props:{title:"Usage",local:"usage",headingTag:"h1"}}),A=new le({props:{title:"A simple generation example:",local:"a-simple-generation-example",headingTag:"h3"}}),S=new ye({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hbWJhMkNvbmZpZyUyQyUyME1hbWJhMkZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBbW9kZWxfaWQlMjAlM0QlMjAnbWlzdHJhbGFpJTJGTWFtYmEtQ29kZXN0cmFsLTdCLXYwLjEnJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCdyZWZzJTJGcHIlMkY5JyUyQyUyMGZyb21fc2xvdyUzRFRydWUlMkMlMjBsZWdhY3klM0RGYWxzZSklMEFtb2RlbCUyMCUzRCUyME1hbWJhMkZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHJldmlzaW9uJTNEJ3JlZnMlMkZwciUyRjknKSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMjJIZXklMjBob3clMjBhcmUlMjB5b3UlMjBkb2luZyUzRiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIwJTIycHQlMjIpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Mamba2Config, Mamba2ForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
model_id = <span class="hljs-string">&#x27;mistralai/Mamba-Codestral-7B-v0.1&#x27;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id, revision=<span class="hljs-string">&#x27;refs/pr/9&#x27;</span>, from_slow=<span class="hljs-literal">True</span>, legacy=<span class="hljs-literal">False</span>)
model = Mamba2ForCausalLM.from_pretrained(model_id, revision=<span class="hljs-string">&#x27;refs/pr/9&#x27;</span>)
input_ids = tokenizer(<span class="hljs-string">&quot;Hey how are you doing?&quot;</span>, return_tensors= <span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

out = model.generate(input_ids, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(out))`,wrap:!1}}),D=new ye({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Mamba2ForCausalLM, TrainingArguments
model_id = <span class="hljs-string">&#x27;mistralai/Mamba-Codestral-7B-v0.1&#x27;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id, revision=<span class="hljs-string">&#x27;refs/pr/9&#x27;</span>, from_slow=<span class="hljs-literal">True</span>, legacy=<span class="hljs-literal">False</span>)
tokenizer.pad_token = tokenizer.eos_token
tokenizer.padding_side = <span class="hljs-string">&quot;left&quot;</span> <span class="hljs-comment">#enforce padding side left</span>

model = Mamba2ForCausalLM.from_pretrained(model_id, revision=<span class="hljs-string">&#x27;refs/pr/9&#x27;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;Abirate/english_quotes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># Without CUDA kernels, batch size of 2 occupies one 80GB device</span>
<span class="hljs-comment"># but precision can be reduced.</span>
<span class="hljs-comment"># Experiments and trials welcome!</span>
training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    per_device_train_batch_size=<span class="hljs-number">2</span>,
    logging_dir=<span class="hljs-string">&#x27;./logs&#x27;</span>,
    logging_steps=<span class="hljs-number">10</span>,
    learning_rate=<span class="hljs-number">2e-3</span>
)
lora_config =  LoraConfig(
        r=<span class="hljs-number">8</span>,
        target_modules=[<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;in_proj&quot;</span>, <span class="hljs-string">&quot;out_proj&quot;</span>],
        task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
        bias=<span class="hljs-string">&quot;none&quot;</span>
)
trainer = SFTTrainer(
    model=model,
    tokenizer=tokenizer,
    args=training_args,
    peft_config=lora_config,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;quote&quot;</span>,
)
trainer.train()`,wrap:!1}}),O=new le({props:{title:"Mamba2Config",local:"transformers.Mamba2Config",headingTag:"h2"}}),K=new Te({props:{name:"class transformers.Mamba2Config",anchor:"transformers.Mamba2Config",parameters:[{name:"num_heads",val:" = 128"},{name:"head_dim",val:" = 64"},{name:"vocab_size",val:" = 32768"},{name:"hidden_size",val:" = 4096"},{name:"state_size",val:" = 128"},{name:"num_hidden_layers",val:" = 64"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"expand",val:" = 2"},{name:"conv_kernel",val:" = 4"},{name:"n_groups",val:" = 8"},{name:"use_bias",val:" = False"},{name:"use_conv_bias",val:" = True"},{name:"hidden_act",val:" = 'silu'"},{name:"initializer_range",val:" = 0.1"},{name:"residual_in_fp32",val:" = True"},{name:"time_step_rank",val:" = 'auto'"},{name:"time_step_min",val:" = 0.001"},{name:"time_step_max",val:" = 0.1"},{name:"time_step_floor",val:" = 0.0001"},{name:"time_step_limit",val:" = (0.0, inf)"},{name:"rescale_prenorm_residual",val:" = False"},{name:"use_cache",val:" = True"},{name:"rms_norm",val:" = True"},{name:"chunk_size",val:" = 256"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mamba2Config.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of heads for the evolution matrices of mamba 2.`,name:"num_heads"},{anchor:"transformers.Mamba2Config.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimension of each head.`,name:"head_dim"},{anchor:"transformers.Mamba2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32768) &#x2014;
Vocabulary size of the MAMBA2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Model">Mamba2Model</a>.`,name:"vocab_size"},{anchor:"transformers.Mamba2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"hidden_size"},{anchor:"transformers.Mamba2Config.state_size",description:"<strong>state_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014; shape of the state space latents.",name:"state_size"},{anchor:"transformers.Mamba2Config.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of hidden layers in the model.`,name:"num_hidden_layers"},{anchor:"transformers.Mamba2Config.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon to use in the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.Mamba2Config.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.Mamba2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the beginning of sentence token in the vocabulary.`,name:"bos_token_id"},{anchor:"transformers.Mamba2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the end of sentence token in the vocabulary.`,name:"eos_token_id"},{anchor:"transformers.Mamba2Config.expand",description:"<strong>expand</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014; Expanding factor used to determine the intermediate size.",name:"expand"},{anchor:"transformers.Mamba2Config.conv_kernel",description:"<strong>conv_kernel</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Size of the convolution kernel.",name:"conv_kernel"},{anchor:"transformers.Mamba2Config.n_groups",description:`<strong>n_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of groups for the evolution matrices of mamba 2.`,name:"n_groups"},{anchor:"transformers.Mamba2Config.use_bias",description:`<strong>use_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use bias in [&#x201C;in_proj&#x201D;, &#x201C;out_proj&#x201D;] of the mixer block`,name:"use_bias"},{anchor:"transformers.Mamba2Config.use_conv_bias",description:`<strong>use_conv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use bias in the convolution layer of the mixer block.`,name:"use_conv_bias"},{anchor:"transformers.Mamba2Config.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Mamba2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Mamba2Config.residual_in_fp32",description:`<strong>residual_in_fp32</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not residuals should be in <code>float32</code>. If set to <code>False</code> residuals will keep the same <code>dtype</code> as the rest of the model`,name:"residual_in_fp32"},{anchor:"transformers.Mamba2Config.time_step_rank",description:`<strong>time_step_rank</strong> (<code>Union[int,str]</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
Rank of the discretization projection matrix. <code>&quot;auto&quot;</code> means that it will default to <code>math.ceil(self.hidden_size / 16)</code>`,name:"time_step_rank"},{anchor:"transformers.Mamba2Config.time_step_min",description:`<strong>time_step_min</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
Minimum <code>time_step</code> used to bound <code>dt_proj.bias</code>.`,name:"time_step_min"},{anchor:"transformers.Mamba2Config.time_step_max",description:`<strong>time_step_max</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Maximum <code>time_step</code> used to bound <code>dt_proj.bias</code>.`,name:"time_step_max"},{anchor:"transformers.Mamba2Config.time_step_floor",description:`<strong>time_step_floor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0001) &#x2014;
Minimum clamping value of the <code>dt_proj.bias</code> layer initialization.`,name:"time_step_floor"},{anchor:"transformers.Mamba2Config.time_step_limit",description:`<strong>time_step_limit</strong> (<code>tuple</code>, <em>optional</em>, defaults to <code>(0.0, inf)</code>) &#x2014;
Accepted range of time step values.`,name:"time_step_limit"},{anchor:"transformers.Mamba2Config.rescale_prenorm_residual",description:`<strong>rescale_prenorm_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to rescale <code>out_proj</code> weights when initializing.`,name:"rescale_prenorm_residual"},{anchor:"transformers.Mamba2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the cache should be used.`,name:"use_cache"},{anchor:"transformers.Mamba2Config.rms_norm",description:`<strong>rms_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use RMS norm or not.`,name:"rms_norm"},{anchor:"transformers.Mamba2Config.chunk_size",description:`<strong>chunk_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Size of the chunks that will comprise the sequence.`,name:"chunk_size"},{anchor:"transformers.Mamba2Config.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie word embeddings or not.`,name:"tie_word_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/configuration_mamba2.py#L26"}}),Z=new it({props:{anchor:"transformers.Mamba2Config.example",$$slots:{default:[Wt]},$$scope:{ctx:x}}}),ee=new le({props:{title:"Mamba2Model",local:"transformers.Mamba2Model",headingTag:"h2"}}),te=new Te({props:{name:"class transformers.Mamba2Model",anchor:"transformers.Mamba2Model",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Mamba2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Config">Mamba2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/modeling_mamba2.py#L883"}}),ae=new Te({props:{name:"forward",anchor:"transformers.Mamba2Model.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.LongTensor] = None"},{name:"cache_params",val:": typing.Optional[transformers.models.mamba2.modeling_mamba2.Mamba2Cache] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mamba2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>cache_params.seqlen_offset&gt;0</code>, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Mamba2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Mamba2Model.forward.cache_params",description:`<strong>cache_params</strong> (<code>Mamba2Cache</code>, <em>optional</em>) &#x2014;
If passed along, the model uses the previous state in all the blocks (which will give the output for the
<code>input_ids</code> provided as if the model add <code>state_input_ids + input_ids</code> as context).`,name:"cache_params"},{anchor:"transformers.Mamba2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the <code>cache_params</code> is returned and can be used to quickly generate the next logits.`,name:"use_cache"},{anchor:"transformers.Mamba2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mamba2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Mamba2Model.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
The position of the current input in the cache. This is used to ensure that the cache is correctly updated.
If <code>cache_params</code> is passed, <code>cache_position</code> should also be passed.`,name:"cache_position"},{anchor:"transformers.Mamba2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/modeling_mamba2.py#L912",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.mamba2.modeling_mamba2.Mamba2Output</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Config"
>Mamba2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>cache_params</strong> (<code>Mamba2Cache</code>) — The state of the model at the last time step. Can be used in a forward method with the next <code>input_ids</code> to
avoid providing the old <code>input_ids</code>.</p>
<p>Includes both the State space model state matrices after the selective scan, and the Convolutional states</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.mamba2.modeling_mamba2.Mamba2Output</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new $t({props:{$$slots:{default:[Zt]},$$scope:{ctx:x}}}),F=new it({props:{anchor:"transformers.Mamba2Model.forward.example",$$slots:{default:[Bt]},$$scope:{ctx:x}}}),oe=new le({props:{title:"Mamba2LMHeadModel",local:"transformers.Mamba2ForCausalLM",headingTag:"h2"}}),ne=new Te({props:{name:"class transformers.Mamba2ForCausalLM",anchor:"transformers.Mamba2ForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Mamba2ForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Config">Mamba2Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/modeling_mamba2.py#L996"}}),se=new Te({props:{name:"forward",anchor:"transformers.Mamba2ForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cache_params",val:": typing.Optional[transformers.models.mamba2.modeling_mamba2.Mamba2Cache] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mamba2ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>cache_params.seqlen_offset&gt;0</code>, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Mamba2ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Mamba2ForCausalLM.forward.cache_params",description:`<strong>cache_params</strong> (<code>Mamba2Cache</code>, <em>optional</em>) &#x2014;
If passed along, the model uses the previous state in all the blocks (which will give the output for the
<code>input_ids</code> provided as if the model add <code>state_input_ids + input_ids</code> as context).`,name:"cache_params"},{anchor:"transformers.Mamba2ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the <code>cache_params</code> is returned and can be used to quickly generate the next logits.`,name:"use_cache"},{anchor:"transformers.Mamba2ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mamba2ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Mamba2ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
The position of the current input in the cache. This is used to ensure that the cache is correctly updated.
If <code>cache_params</code> is passed, <code>cache_position</code> should also be passed.`,name:"cache_position"},{anchor:"transformers.Mamba2ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Mamba2ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mamba2/modeling_mamba2.py#L1072",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.mamba2.modeling_mamba2.Mamba2CausalLMOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mamba2#transformers.Mamba2Config"
>Mamba2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>cache_params</strong> (<code>Mamba2Cache</code>) — The state of the model at the last time step. Can be used in a forward method with the next <code>input_ids</code> to
avoid providing the old <code>input_ids</code>.</p>
<p>Includes both the State space model state matrices after the selective scan, and the Convolutional states</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.mamba2.modeling_mamba2.Mamba2CausalLMOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new $t({props:{$$slots:{default:[Ft]},$$scope:{ctx:x}}}),R=new it({props:{anchor:"transformers.Mamba2ForCausalLM.forward.example",$$slots:{default:[Xt]},$$scope:{ctx:x}}}),re=new Ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mamba2.md"}}),{c(){o=m("meta"),w=r(),l=m("p"),d=r(),h(T.$$.fragment),n=r(),y=m("div"),y.innerHTML=lt,Je=r(),h(E.$$.fragment),ve=r(),G=m("p"),G.innerHTML=dt,ke=r(),H=m("p"),H.textContent=mt,$e=r(),L=m("p"),L.innerHTML=ct,Ce=r(),V=m("p"),V.textContent=pt,xe=r(),q=m("p"),q.innerHTML=ht,Ie=r(),Y=m("p"),Y.innerHTML=ut,je=r(),h(Q.$$.fragment),ze=r(),h(A.$$.fragment),Ue=r(),h(S.$$.fragment),We=r(),P=m("p"),P.textContent=ft,Ze=r(),h(D.$$.fragment),Be=r(),h(O.$$.fragment),Fe=r(),k=m("div"),h(K.$$.fragment),Ve=r(),de=m("p"),de.innerHTML=gt,qe=r(),me=m("p"),me.innerHTML=bt,Ye=r(),h(Z.$$.fragment),Xe=r(),h(ee.$$.fragment),Re=r(),J=m("div"),h(te.$$.fragment),Qe=r(),ce=m("p"),ce.textContent=_t,Ae=r(),pe=m("p"),pe.innerHTML=Mt,Se=r(),he=m("p"),he.innerHTML=Tt,Pe=r(),I=m("div"),h(ae.$$.fragment),De=r(),ue=m("p"),ue.innerHTML=yt,Oe=r(),h(B.$$.fragment),Ke=r(),h(F.$$.fragment),Ne=r(),h(oe.$$.fragment),Ee=r(),v=m("div"),h(ne.$$.fragment),et=r(),fe=m("p"),fe.textContent=wt,tt=r(),ge=m("p"),ge.innerHTML=Jt,at=r(),be=m("p"),be.innerHTML=vt,ot=r(),j=m("div"),h(se.$$.fragment),nt=r(),_e=m("p"),_e.innerHTML=kt,st=r(),h(X.$$.fragment),rt=r(),h(R.$$.fragment),Ge=r(),h(re.$$.fragment),He=r(),Me=m("p"),this.h()},l(e){const t=zt("svelte-u9bgzb",document.head);o=c(t,"META",{name:!0,content:!0}),t.forEach(a),w=i(e),l=c(e,"P",{}),ie(l).forEach(a),d=i(e),u(T.$$.fragment,e),n=i(e),y=c(e,"DIV",{class:!0,"data-svelte-h":!0}),M(y)!=="svelte-13t8s2t"&&(y.innerHTML=lt),Je=i(e),u(E.$$.fragment,e),ve=i(e),G=c(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1d6fl0b"&&(G.innerHTML=dt),ke=i(e),H=c(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-vfdo9a"&&(H.textContent=mt),$e=i(e),L=c(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-7hg709"&&(L.innerHTML=ct),Ce=i(e),V=c(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-axv494"&&(V.textContent=pt),xe=i(e),q=c(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-130dh8m"&&(q.innerHTML=ht),Ie=i(e),Y=c(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-sx29qw"&&(Y.innerHTML=ut),je=i(e),u(Q.$$.fragment,e),ze=i(e),u(A.$$.fragment,e),Ue=i(e),u(S.$$.fragment,e),We=i(e),P=c(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-n2y54r"&&(P.textContent=ft),Ze=i(e),u(D.$$.fragment,e),Be=i(e),u(O.$$.fragment,e),Fe=i(e),k=c(e,"DIV",{class:!0});var z=ie(k);u(K.$$.fragment,z),Ve=i(z),de=c(z,"P",{"data-svelte-h":!0}),M(de)!=="svelte-k7tbfb"&&(de.innerHTML=gt),qe=i(z),me=c(z,"P",{"data-svelte-h":!0}),M(me)!=="svelte-o55m63"&&(me.innerHTML=bt),Ye=i(z),u(Z.$$.fragment,z),z.forEach(a),Xe=i(e),u(ee.$$.fragment,e),Re=i(e),J=c(e,"DIV",{class:!0});var $=ie(J);u(te.$$.fragment,$),Qe=i($),ce=c($,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-1rstypp"&&(ce.textContent=_t),Ae=i($),pe=c($,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-6pahdo"&&(pe.innerHTML=Mt),Se=i($),he=c($,"P",{"data-svelte-h":!0}),M(he)!=="svelte-hswkmf"&&(he.innerHTML=Tt),Pe=i($),I=c($,"DIV",{class:!0});var U=ie(I);u(ae.$$.fragment,U),De=i(U),ue=c(U,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-y382d"&&(ue.innerHTML=yt),Oe=i(U),u(B.$$.fragment,U),Ke=i(U),u(F.$$.fragment,U),U.forEach(a),$.forEach(a),Ne=i(e),u(oe.$$.fragment,e),Ee=i(e),v=c(e,"DIV",{class:!0});var C=ie(v);u(ne.$$.fragment,C),et=i(C),fe=c(C,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-14gyjie"&&(fe.textContent=wt),tt=i(C),ge=c(C,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-6pahdo"&&(ge.innerHTML=Jt),at=i(C),be=c(C,"P",{"data-svelte-h":!0}),M(be)!=="svelte-hswkmf"&&(be.innerHTML=vt),ot=i(C),j=c(C,"DIV",{class:!0});var W=ie(j);u(se.$$.fragment,W),nt=i(W),_e=c(W,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-mv4mtl"&&(_e.innerHTML=kt),st=i(W),u(X.$$.fragment,W),rt=i(W),u(R.$$.fragment,W),W.forEach(a),C.forEach(a),Ge=i(e),u(re.$$.fragment,e),He=i(e),Me=c(e,"P",{}),ie(Me).forEach(a),this.h()},h(){N(o,"name","hf:doc:metadata"),N(o,"content",Nt),N(y,"class","flex flex-wrap space-x-1"),N(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),N(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,o),s(e,w,t),s(e,l,t),s(e,d,t),f(T,e,t),s(e,n,t),s(e,y,t),s(e,Je,t),f(E,e,t),s(e,ve,t),s(e,G,t),s(e,ke,t),s(e,H,t),s(e,$e,t),s(e,L,t),s(e,Ce,t),s(e,V,t),s(e,xe,t),s(e,q,t),s(e,Ie,t),s(e,Y,t),s(e,je,t),f(Q,e,t),s(e,ze,t),f(A,e,t),s(e,Ue,t),f(S,e,t),s(e,We,t),s(e,P,t),s(e,Ze,t),f(D,e,t),s(e,Be,t),f(O,e,t),s(e,Fe,t),s(e,k,t),f(K,k,null),p(k,Ve),p(k,de),p(k,qe),p(k,me),p(k,Ye),f(Z,k,null),s(e,Xe,t),f(ee,e,t),s(e,Re,t),s(e,J,t),f(te,J,null),p(J,Qe),p(J,ce),p(J,Ae),p(J,pe),p(J,Se),p(J,he),p(J,Pe),p(J,I),f(ae,I,null),p(I,De),p(I,ue),p(I,Oe),f(B,I,null),p(I,Ke),f(F,I,null),s(e,Ne,t),f(oe,e,t),s(e,Ee,t),s(e,v,t),f(ne,v,null),p(v,et),p(v,fe),p(v,tt),p(v,ge),p(v,at),p(v,be),p(v,ot),p(v,j),f(se,j,null),p(j,nt),p(j,_e),p(j,st),f(X,j,null),p(j,rt),f(R,j,null),s(e,Ge,t),f(re,e,t),s(e,He,t),s(e,Me,t),Le=!0},p(e,[t]){const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),Z.$set(z);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),B.$set($);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),F.$set(U);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),X.$set(C);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),R.$set(W)},i(e){Le||(g(T.$$.fragment,e),g(E.$$.fragment,e),g(Q.$$.fragment,e),g(A.$$.fragment,e),g(S.$$.fragment,e),g(D.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(Z.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(B.$$.fragment,e),g(F.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(X.$$.fragment,e),g(R.$$.fragment,e),g(re.$$.fragment,e),Le=!0)},o(e){b(T.$$.fragment,e),b(E.$$.fragment,e),b(Q.$$.fragment,e),b(A.$$.fragment,e),b(S.$$.fragment,e),b(D.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(Z.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(ae.$$.fragment,e),b(B.$$.fragment,e),b(F.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(X.$$.fragment,e),b(R.$$.fragment,e),b(re.$$.fragment,e),Le=!1},d(e){e&&(a(w),a(l),a(d),a(n),a(y),a(Je),a(ve),a(G),a(ke),a(H),a($e),a(L),a(Ce),a(V),a(xe),a(q),a(Ie),a(Y),a(je),a(ze),a(Ue),a(We),a(P),a(Ze),a(Be),a(Fe),a(k),a(Xe),a(Re),a(J),a(Ne),a(Ee),a(v),a(Ge),a(He),a(Me)),a(o),_(T,e),_(E,e),_(Q,e),_(A,e),_(S,e),_(D,e),_(O,e),_(K),_(Z),_(ee,e),_(te),_(ae),_(B),_(F),_(oe,e),_(ne),_(se),_(X),_(R),_(re,e)}}}const Nt='{"title":"Mamba 2","local":"mamba-2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2}],"depth":1}';function Et(x){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class St extends It{constructor(o){super(),jt(this,o,Et,Rt,Ct,{})}}export{St as component};
