import{s as Gs,o as Bs,n as zs}from"../chunks/scheduler.18a86fab.js";import{S as Hs,i as Rs,g as l,s as r,r as y,A as Fs,h as n,f as t,c as o,j as Ws,u as M,x as c,k as ns,y as Ns,a,v as b,d as v,t as w,w as J}from"../chunks/index.98837b22.js";import{C as U}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as be}from"../chunks/Heading.7e7e0c5b.js";import{H as Ps,a as Vs}from"../chunks/HfOption.6641485e.js";import{E as Xs}from"../chunks/index.499f366c.js";function qs(Z){let i,_='The <a href="./model_doc/auto">AutoClass</a> API provides a convenient method to load an image processor without directly specifying the model the image processor is associated with.',g,h,m='Use <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor.from_pretrained">from_pretrained()</a> to load an image processor, and set <code>use_fast=True</code> to load a fast image processor if it’s supported.',u,d,j;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIlMkMlMjB1c2VfZmFzdCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, use_fast=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){i=l("p"),i.innerHTML=_,g=r(),h=l("p"),h.innerHTML=m,u=r(),y(d.$$.fragment)},l(f){i=n(f,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1vwm687"&&(i.innerHTML=_),g=o(f),h=n(f,"P",{"data-svelte-h":!0}),c(h)!=="svelte-cmw0lf"&&(h.innerHTML=m),u=o(f),M(d.$$.fragment,f)},m(f,T){a(f,i,T),a(f,g,T),a(f,h,T),a(f,u,T),b(d,f,T),j=!0},p:zs,i(f){j||(v(d.$$.fragment,f),j=!0)},o(f){w(d.$$.fragment,f),j=!1},d(f){f&&(t(i),t(g),t(h),t(u)),J(d,f)}}}function Ys(Z){let i,_="Each image processor is associated with a specific pretrained vision model, and the image processors configuration contains the models expected size and whether to normalize and resize.",g,h,m="The image processor can be loaded directly from the model-specific class. Check a models API documentation to see whether it supports a fast image processor.",u,d,j,f,T="To load a fast image processor, use the fast implementation class.",W,C,I;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVEltYWdlUHJvY2Vzc29yJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwVmlUSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTImageProcessor

image_processor = ViTImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)`,wrap:!1}}),C=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVEltYWdlUHJvY2Vzc29yRmFzdCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMFZpVEltYWdlUHJvY2Vzc29yRmFzdC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTImageProcessorFast

image_processor = ViTImageProcessorFast.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)`,wrap:!1}}),{c(){i=l("p"),i.textContent=_,g=r(),h=l("p"),h.textContent=m,u=r(),y(d.$$.fragment),j=r(),f=l("p"),f.textContent=T,W=r(),y(C.$$.fragment)},l(p){i=n(p,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1cfhfmu"&&(i.textContent=_),g=o(p),h=n(p,"P",{"data-svelte-h":!0}),c(h)!=="svelte-1w3u6hy"&&(h.textContent=m),u=o(p),M(d.$$.fragment,p),j=o(p),f=n(p,"P",{"data-svelte-h":!0}),c(f)!=="svelte-i6kp8f"&&(f.textContent=T),W=o(p),M(C.$$.fragment,p)},m(p,$){a(p,i,$),a(p,g,$),a(p,h,$),a(p,u,$),b(d,p,$),a(p,j,$),a(p,f,$),a(p,W,$),b(C,p,$),I=!0},p:zs,i(p){I||(v(d.$$.fragment,p),v(C.$$.fragment,p),I=!0)},o(p){w(d.$$.fragment,p),w(C.$$.fragment,p),I=!1},d(p){p&&(t(i),t(g),t(h),t(u),t(j),t(f),t(W)),J(d,p),J(C,p)}}}function Qs(Z){let i,_,g,h;return i=new Vs({props:{id:"image-processor-classes",option:"AutoImageProcessor",$$slots:{default:[qs]},$$scope:{ctx:Z}}}),g=new Vs({props:{id:"image-processor-classes",option:"model-specific image processor",$$slots:{default:[Ys]},$$scope:{ctx:Z}}}),{c(){y(i.$$.fragment),_=r(),y(g.$$.fragment)},l(m){M(i.$$.fragment,m),_=o(m),M(g.$$.fragment,m)},m(m,u){b(i,m,u),a(m,_,u),b(g,m,u),h=!0},p(m,u){const d={};u&2&&(d.$$scope={dirty:u,ctx:m}),i.$set(d);const j={};u&2&&(j.$$scope={dirty:u,ctx:m}),g.$set(j)},i(m){h||(v(i.$$.fragment,m),v(g.$$.fragment,m),h=!0)},o(m){w(i.$$.fragment,m),w(g.$$.fragment,m),h=!1},d(m){m&&t(_),J(i,m),J(g,m)}}}function Es(Z){let i,_,g,h,m,u,d,j="Image processors converts images into pixel values, tensors that represent image colors and size. The pixel values are inputs to a vision or video model. To ensure a pretrained model receives the correct input, an image processor can perform the following operations to make sure an image is exactly like the images a model was pretrained on.",f,T,W='<li><a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor.center_crop">center_crop()</a> to resize an image</li> <li><a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor.normalize">normalize()</a> or <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor.rescale">rescale()</a> pixel values</li>',C,I,p='Use <a href="/docs/transformers/main/en/internal/image_processing_utils#transformers.ImageProcessingMixin.from_pretrained">from_pretrained()</a> to load an image processors configuration (image size, whether to normalize and rescale, etc.) from a vision model on the Hugging Face <a href="https://hf.co" rel="nofollow">Hub</a> or local directory. The configuration for each pretrained model is saved in a <a href="https://huggingface.co/google/vit-base-patch16-224/blob/main/preprocessor_config.json" rel="nofollow">preprocessor_config.json</a> file.',$,V,ve,z,is="Pass an image to the image processor to transform it into pixel values, and set <code>return_tensors=&quot;pt&quot;</code> to return PyTorch tensors. Feel free to print out the inputs to see what the image looks like as a tensor.",we,G,Je,B,ms="This guide covers the image processor class and how to preprocess images for vision models.",Te,H,_e,R,ps='Image processors inherit from the <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a> class which provides the <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor.center_crop">center_crop()</a>, <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor.normalize">normalize()</a>, and <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor.rescale">rescale()</a> functions. There are two types of image processors.',je,F,cs='<li><a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a> is a Python implementation.</li> <li><a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessorFast">BaseImageProcessorFast</a> is a faster <a href="https://pytorch.org/vision/stable/index.html" rel="nofollow">torchvision-backed</a> version. For a batch of <a href="https://pytorch.org/docs/stable/tensors.html" rel="nofollow">torch.Tensor</a> inputs, this can be up to 33x faster. <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessorFast">BaseImageProcessorFast</a> is not available for all vision models at the moment. Refer to a models API documentation to check if it is supported.</li>',$e,N,fs='Each image processor subclasses the <a href="/docs/transformers/main/en/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> class which provides the <a href="/docs/transformers/main/en/internal/image_processing_utils#transformers.ImageProcessingMixin.from_pretrained">from_pretrained()</a> and <a href="/docs/transformers/main/en/internal/image_processing_utils#transformers.ImageProcessingMixin.save_pretrained">save_pretrained()</a> methods for loading and saving image processors.',Ue,P,ds='There are two ways you can load an image processor, with <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> or a model-specific image processor.',Ce,x,Ie,X,Ze,q,hs='<a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessorFast">BaseImageProcessorFast</a> is based on <a href="https://pytorch.org/vision/stable/index.html" rel="nofollow">torchvision</a> and is significantly faster, especially when processing on a GPU. This class can be used as a drop-in replacement for <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a> if it’s available for a model because it has the same design. Make sure <a href="https://pytorch.org/get-started/locally/#mac-installation" rel="nofollow">torchvision</a> is installed, and set the <code>use_fast</code> parameter to <code>True</code>.',xe,Y,ke,Q,gs="Control which device processing is performed on with the <code>device</code> parameter. Processing is performed on the same device as the input by default if the inputs are tensors, otherwise they are processed on the CPU. The example below places the fast processor on a GPU.",We,E,Ve,A,us='<summary>Benchmarks</summary> <p>The benchmarks are obtained from an <a href="https://aws.amazon.com/ec2/instance-types/g5/" rel="nofollow">AWS EC2 g5.2xlarge</a> instance with a NVIDIA A10G Tensor Core GPU.</p> <div class="flex"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/benchmark_results_full_pipeline_detr_fast_padded.png"/></div> <div class="flex"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/benchmark_results_full_pipeline_detr_fast_batched_compiled.png"/></div> <div class="flex"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/benchmark_results_full_pipeline_rt_detr_fast_single.png"/></div> <div class="flex"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/benchmark_results_full_pipeline_rt_detr_fast_batched.png"/></div>',ze,L,Ge,S,ys="Transformers’ vision models expects the input as PyTorch tensors of pixel values. An image processor handles the conversion of images to pixel values, which is represented by the batch size, number of channels, height, and width. To achieve this, an image is resized (center cropped) and the pixel values are normalized and rescaled to the models expected values.",Be,D,Ms="Image preprocessing is not the same as <em>image augmentation</em>. Image augmentation makes changes (brightness, colors, rotatation, etc.) to an image for the purpose of either creating new training examples or prevent overfitting. Image preprocessing makes changes to an image for the purpose of matching a pretrained model’s expected input format.",He,K,bs='Typically, images are augmented (to increase performance) and then preprocessed before being passed to a model. You can use any library (<a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification_albumentations.ipynb" rel="nofollow">Albumentations</a>, <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification_kornia.ipynb" rel="nofollow">Kornia</a>) for augmentation and an image processor for preprocessing.',Re,O,vs='This guide uses the torchvision <a href="https://pytorch.org/vision/stable/transforms.html" rel="nofollow">transforms</a> module for augmentation.',Fe,ee,ws='Start by loading a small sample of the <a href="https://hf.co/datasets/food101" rel="nofollow">food101</a> dataset.',Ne,se,Pe,te,Js='From the <a href="https://pytorch.org/vision/stable/transforms.html" rel="nofollow">transforms</a> module, use the <a href="https://pytorch.org/vision/master/generated/torchvision.transforms.Compose.html" rel="nofollow">Compose</a> API to chain together <a href="https://pytorch.org/vision/main/generated/torchvision.transforms.RandomResizedCrop.html" rel="nofollow">RandomResizedCrop</a> and <a href="https://pytorch.org/vision/main/generated/torchvision.transforms.ColorJitter.html" rel="nofollow">ColorJitter</a>. These transforms randomly crop and resize an image, and randomly adjusts an images colors.',Xe,ae,Ts="The image size to randomly crop to can be retrieved from the image processor. For some models, an exact height and width are expected while for others, only the <code>shortest_edge</code> is required.",qe,re,Ye,oe,_s="Apply the transforms to the images and convert them to the RGB format. Then pass the augmented images to the image processor to return the pixel values.",Qe,le,js='The <code>do_resize</code> parameter is set to <code>False</code> because the images have already been resized in the augmentation step by <a href="https://pytorch.org/vision/main/generated/torchvision.transforms.RandomResizedCrop.html" rel="nofollow">RandomResizedCrop</a>. If you don’t augment the images, then the image processor automatically resizes and normalizes the images with the <code>image_mean</code> and <code>image_std</code> values. These values are found in the preprocessor configuration file.',Ee,ne,Ae,ie,$s='Apply the combined augmentation and preprocessing function to the entire dataset on the fly with <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a>.',Le,me,Se,pe,Us="Convert the pixel values back into an image to see how the image has been augmented and preprocessed.",De,ce,Ke,k,Cs='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/vision-preprocess-tutorial.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">before</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/preprocessed_image.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">after</figcaption></div>',Oe,fe,Is="For other vision tasks like object detection or segmentation, the image processor includes post-processing methods to convert a models raw output into meaningful predictions like bounding boxes or segmentation maps.",es,de,ss,he,Zs='Some models, like <a href="./model_doc/detr">DETR</a>, applies <a href="https://paperswithcode.com/method/image-scale-augmentation" rel="nofollow">scale augmentation</a> during training which can cause images in a batch to have different sizes. Images with different sizes can’t be batched together.',ts,ge,xs='To fix this, pad the images with the special padding token <code>0</code>. Use the <a href="https://github.com/huggingface/transformers/blob/9578c2597e2d88b6f0b304b5a05864fd613ddcc1/src/transformers/models/detr/image_processing_detr.py#L1151" rel="nofollow">pad</a> method to pad the images, and define a custom collate function to batch them together.',as,ue,rs,ye,os,Me,ls;return m=new be({props:{title:"Image processors",local:"image-processors",headingTag:"h1"}}),V=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)`,wrap:!1}}),G=new U({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZpbWFnZV9wcm9jZXNzb3JfZXhhbXBsZS5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIpJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/image_processor_example.png&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),H=new be({props:{title:"Image processor classes",local:"image-processor-classes",headingTag:"h2"}}),x=new Ps({props:{id:"image-processor-classes",options:["AutoImageProcessor","model-specific image processor"],$$slots:{default:[Qs]},$$scope:{ctx:Z}}}),X=new be({props:{title:"Fast image processors",local:"fast-image-processors",headingTag:"h2"}}),Y=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiUyQyUyMHVzZV9mYXN0JTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>, use_fast=<span class="hljs-literal">True</span>)`,wrap:!1}}),E=new U({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLmlvJTIwaW1wb3J0JTIwcmVhZF9pbWFnZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBEZXRySW1hZ2VQcm9jZXNzb3JGYXN0JTBBJTBBaW1hZ2VzJTIwJTNEJTIwcmVhZF9pbWFnZSglMjJpbWFnZS5qcGclMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwRGV0ckltYWdlUHJvY2Vzc29yRmFzdC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEFpbWFnZXNfcHJvY2Vzc2VkJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> torchvision.io <span class="hljs-keyword">import</span> read_image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrImageProcessorFast

images = read_image(<span class="hljs-string">&quot;image.jpg&quot;</span>)
processor = DetrImageProcessorFast.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
images_processed = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),L=new be({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),se=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTEwMCU1RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, split=<span class="hljs-string">&quot;train[:100]&quot;</span>)`,wrap:!1}}),re=new U({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBSYW5kb21SZXNpemVkQ3JvcCUyQyUyMENvbG9ySml0dGVyJTJDJTIwQ29tcG9zZSUwQSUwQXNpemUlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJzaG9ydGVzdF9lZGdlJTIyJTVEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJzaG9ydGVzdF9lZGdlJTIyJTIwaW4lMjBpbWFnZV9wcm9jZXNzb3Iuc2l6ZSUwQSUyMCUyMCUyMCUyMGVsc2UlMjAoaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJoZWlnaHQlMjIlNUQlMkMlMjBpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMndpZHRoJTIyJTVEKSUwQSklMEFfdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTVCUmFuZG9tUmVzaXplZENyb3Aoc2l6ZSklMkMlMjBDb2xvckppdHRlcihicmlnaHRuZXNzJTNEMC41JTJDJTIwaHVlJTNEMC41KSU1RCk=",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> RandomResizedCrop, ColorJitter, Compose

size = (
    image_processor.size[<span class="hljs-string">&quot;shortest_edge&quot;</span>]
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;shortest_edge&quot;</span> <span class="hljs-keyword">in</span> image_processor.size
    <span class="hljs-keyword">else</span> (image_processor.size[<span class="hljs-string">&quot;height&quot;</span>], image_processor.size[<span class="hljs-string">&quot;width&quot;</span>])
)
_transforms = Compose([RandomResizedCrop(size), ColorJitter(brightness=<span class="hljs-number">0.5</span>, hue=<span class="hljs-number">0.5</span>)])`,wrap:!1}}),ne=new U({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJfdHJhbnNmb3JtcyhpbWcuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltZyUyMGluJTIwZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUyQyUyMGRvX3Jlc2l6ZSUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxlcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">examples</span>):
    images = [_transforms(img.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> img <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = image_processor(images, do_resize=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;pixel_values&quot;</span>]
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),me=new U({props:{code:"ZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMp",highlighted:"dataset.set_transform(transforms)",wrap:!1}}),ce=new U({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWltZyUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTBBcGx0Lmltc2hvdyhpbWcucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

img = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;pixel_values&quot;</span>]
plt.imshow(img.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>))`,wrap:!1}}),de=new be({props:{title:"Padding",local:"padding",headingTag:"h3"}}),ue=new U({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBwaXhlbF92YWx1ZXMlMjAlM0QlMjAlNUJpdGVtJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBlbmNvZGluZyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wYWQocGl4ZWxfdmFsdWVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjAlNUJpdGVtJTVCJTIybGFiZWxzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwZW5jb2RpbmclNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnBpeGVsX21hc2slMjIlNUQlMjAlM0QlMjBlbmNvZGluZyU1QiUyMnBpeGVsX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNo",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">batch</span>):
    pixel_values = [item[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
    encoding = image_processor.pad(pixel_values, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = [item[<span class="hljs-string">&quot;labels&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
    batch = {}
    batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>]
    batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_mask&quot;</span>]
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),ye=new Xs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/image_processors.md"}}),{c(){i=l("meta"),_=r(),g=l("p"),h=r(),y(m.$$.fragment),u=r(),d=l("p"),d.textContent=j,f=r(),T=l("ul"),T.innerHTML=W,C=r(),I=l("p"),I.innerHTML=p,$=r(),y(V.$$.fragment),ve=r(),z=l("p"),z.innerHTML=is,we=r(),y(G.$$.fragment),Je=r(),B=l("p"),B.textContent=ms,Te=r(),y(H.$$.fragment),_e=r(),R=l("p"),R.innerHTML=ps,je=r(),F=l("ul"),F.innerHTML=cs,$e=r(),N=l("p"),N.innerHTML=fs,Ue=r(),P=l("p"),P.innerHTML=ds,Ce=r(),y(x.$$.fragment),Ie=r(),y(X.$$.fragment),Ze=r(),q=l("p"),q.innerHTML=hs,xe=r(),y(Y.$$.fragment),ke=r(),Q=l("p"),Q.innerHTML=gs,We=r(),y(E.$$.fragment),Ve=r(),A=l("details"),A.innerHTML=us,ze=r(),y(L.$$.fragment),Ge=r(),S=l("p"),S.textContent=ys,Be=r(),D=l("p"),D.innerHTML=Ms,He=r(),K=l("p"),K.innerHTML=bs,Re=r(),O=l("p"),O.innerHTML=vs,Fe=r(),ee=l("p"),ee.innerHTML=ws,Ne=r(),y(se.$$.fragment),Pe=r(),te=l("p"),te.innerHTML=Js,Xe=r(),ae=l("p"),ae.innerHTML=Ts,qe=r(),y(re.$$.fragment),Ye=r(),oe=l("p"),oe.textContent=_s,Qe=r(),le=l("p"),le.innerHTML=js,Ee=r(),y(ne.$$.fragment),Ae=r(),ie=l("p"),ie.innerHTML=$s,Le=r(),y(me.$$.fragment),Se=r(),pe=l("p"),pe.textContent=Us,De=r(),y(ce.$$.fragment),Ke=r(),k=l("div"),k.innerHTML=Cs,Oe=r(),fe=l("p"),fe.textContent=Is,es=r(),y(de.$$.fragment),ss=r(),he=l("p"),he.innerHTML=Zs,ts=r(),ge=l("p"),ge.innerHTML=xs,as=r(),y(ue.$$.fragment),rs=r(),y(ye.$$.fragment),os=r(),Me=l("p"),this.h()},l(e){const s=Fs("svelte-u9bgzb",document.head);i=n(s,"META",{name:!0,content:!0}),s.forEach(t),_=o(e),g=n(e,"P",{}),Ws(g).forEach(t),h=o(e),M(m.$$.fragment,e),u=o(e),d=n(e,"P",{"data-svelte-h":!0}),c(d)!=="svelte-1lb61zm"&&(d.textContent=j),f=o(e),T=n(e,"UL",{"data-svelte-h":!0}),c(T)!=="svelte-86mn3o"&&(T.innerHTML=W),C=o(e),I=n(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1891i99"&&(I.innerHTML=p),$=o(e),M(V.$$.fragment,e),ve=o(e),z=n(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-otipb3"&&(z.innerHTML=is),we=o(e),M(G.$$.fragment,e),Je=o(e),B=n(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-uhg2yr"&&(B.textContent=ms),Te=o(e),M(H.$$.fragment,e),_e=o(e),R=n(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1edgizn"&&(R.innerHTML=ps),je=o(e),F=n(e,"UL",{"data-svelte-h":!0}),c(F)!=="svelte-13td0ss"&&(F.innerHTML=cs),$e=o(e),N=n(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-qwpdo5"&&(N.innerHTML=fs),Ue=o(e),P=n(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-yfkl26"&&(P.innerHTML=ds),Ce=o(e),M(x.$$.fragment,e),Ie=o(e),M(X.$$.fragment,e),Ze=o(e),q=n(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1o0jpq5"&&(q.innerHTML=hs),xe=o(e),M(Y.$$.fragment,e),ke=o(e),Q=n(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-4xtqm3"&&(Q.innerHTML=gs),We=o(e),M(E.$$.fragment,e),Ve=o(e),A=n(e,"DETAILS",{"data-svelte-h":!0}),c(A)!=="svelte-8lmygb"&&(A.innerHTML=us),ze=o(e),M(L.$$.fragment,e),Ge=o(e),S=n(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-13omjsb"&&(S.textContent=ys),Be=o(e),D=n(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-cssom3"&&(D.innerHTML=Ms),He=o(e),K=n(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1h6eup4"&&(K.innerHTML=bs),Re=o(e),O=n(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-a329u4"&&(O.innerHTML=vs),Fe=o(e),ee=n(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-11fp1oy"&&(ee.innerHTML=ws),Ne=o(e),M(se.$$.fragment,e),Pe=o(e),te=n(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-imdmpj"&&(te.innerHTML=Js),Xe=o(e),ae=n(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1fq1fnx"&&(ae.innerHTML=Ts),qe=o(e),M(re.$$.fragment,e),Ye=o(e),oe=n(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1qqust8"&&(oe.textContent=_s),Qe=o(e),le=n(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1edprqw"&&(le.innerHTML=js),Ee=o(e),M(ne.$$.fragment,e),Ae=o(e),ie=n(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-dkipat"&&(ie.innerHTML=$s),Le=o(e),M(me.$$.fragment,e),Se=o(e),pe=n(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1nnxl6x"&&(pe.textContent=Us),De=o(e),M(ce.$$.fragment,e),Ke=o(e),k=n(e,"DIV",{class:!0,"data-svelte-h":!0}),c(k)!=="svelte-1lm3aib"&&(k.innerHTML=Cs),Oe=o(e),fe=n(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-2475d2"&&(fe.textContent=Is),es=o(e),M(de.$$.fragment,e),ss=o(e),he=n(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-tpbwvw"&&(he.innerHTML=Zs),ts=o(e),ge=n(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-i4a6ta"&&(ge.innerHTML=xs),as=o(e),M(ue.$$.fragment,e),rs=o(e),M(ye.$$.fragment,e),os=o(e),Me=n(e,"P",{}),Ws(Me).forEach(t),this.h()},h(){ns(i,"name","hf:doc:metadata"),ns(i,"content",As),ns(k,"class","flex gap-4")},m(e,s){Ns(document.head,i),a(e,_,s),a(e,g,s),a(e,h,s),b(m,e,s),a(e,u,s),a(e,d,s),a(e,f,s),a(e,T,s),a(e,C,s),a(e,I,s),a(e,$,s),b(V,e,s),a(e,ve,s),a(e,z,s),a(e,we,s),b(G,e,s),a(e,Je,s),a(e,B,s),a(e,Te,s),b(H,e,s),a(e,_e,s),a(e,R,s),a(e,je,s),a(e,F,s),a(e,$e,s),a(e,N,s),a(e,Ue,s),a(e,P,s),a(e,Ce,s),b(x,e,s),a(e,Ie,s),b(X,e,s),a(e,Ze,s),a(e,q,s),a(e,xe,s),b(Y,e,s),a(e,ke,s),a(e,Q,s),a(e,We,s),b(E,e,s),a(e,Ve,s),a(e,A,s),a(e,ze,s),b(L,e,s),a(e,Ge,s),a(e,S,s),a(e,Be,s),a(e,D,s),a(e,He,s),a(e,K,s),a(e,Re,s),a(e,O,s),a(e,Fe,s),a(e,ee,s),a(e,Ne,s),b(se,e,s),a(e,Pe,s),a(e,te,s),a(e,Xe,s),a(e,ae,s),a(e,qe,s),b(re,e,s),a(e,Ye,s),a(e,oe,s),a(e,Qe,s),a(e,le,s),a(e,Ee,s),b(ne,e,s),a(e,Ae,s),a(e,ie,s),a(e,Le,s),b(me,e,s),a(e,Se,s),a(e,pe,s),a(e,De,s),b(ce,e,s),a(e,Ke,s),a(e,k,s),a(e,Oe,s),a(e,fe,s),a(e,es,s),b(de,e,s),a(e,ss,s),a(e,he,s),a(e,ts,s),a(e,ge,s),a(e,as,s),b(ue,e,s),a(e,rs,s),b(ye,e,s),a(e,os,s),a(e,Me,s),ls=!0},p(e,[s]){const ks={};s&2&&(ks.$$scope={dirty:s,ctx:e}),x.$set(ks)},i(e){ls||(v(m.$$.fragment,e),v(V.$$.fragment,e),v(G.$$.fragment,e),v(H.$$.fragment,e),v(x.$$.fragment,e),v(X.$$.fragment,e),v(Y.$$.fragment,e),v(E.$$.fragment,e),v(L.$$.fragment,e),v(se.$$.fragment,e),v(re.$$.fragment,e),v(ne.$$.fragment,e),v(me.$$.fragment,e),v(ce.$$.fragment,e),v(de.$$.fragment,e),v(ue.$$.fragment,e),v(ye.$$.fragment,e),ls=!0)},o(e){w(m.$$.fragment,e),w(V.$$.fragment,e),w(G.$$.fragment,e),w(H.$$.fragment,e),w(x.$$.fragment,e),w(X.$$.fragment,e),w(Y.$$.fragment,e),w(E.$$.fragment,e),w(L.$$.fragment,e),w(se.$$.fragment,e),w(re.$$.fragment,e),w(ne.$$.fragment,e),w(me.$$.fragment,e),w(ce.$$.fragment,e),w(de.$$.fragment,e),w(ue.$$.fragment,e),w(ye.$$.fragment,e),ls=!1},d(e){e&&(t(_),t(g),t(h),t(u),t(d),t(f),t(T),t(C),t(I),t($),t(ve),t(z),t(we),t(Je),t(B),t(Te),t(_e),t(R),t(je),t(F),t($e),t(N),t(Ue),t(P),t(Ce),t(Ie),t(Ze),t(q),t(xe),t(ke),t(Q),t(We),t(Ve),t(A),t(ze),t(Ge),t(S),t(Be),t(D),t(He),t(K),t(Re),t(O),t(Fe),t(ee),t(Ne),t(Pe),t(te),t(Xe),t(ae),t(qe),t(Ye),t(oe),t(Qe),t(le),t(Ee),t(Ae),t(ie),t(Le),t(Se),t(pe),t(De),t(Ke),t(k),t(Oe),t(fe),t(es),t(ss),t(he),t(ts),t(ge),t(as),t(rs),t(os),t(Me)),t(i),J(m,e),J(V,e),J(G,e),J(H,e),J(x,e),J(X,e),J(Y,e),J(E,e),J(L,e),J(se,e),J(re,e),J(ne,e),J(me,e),J(ce,e),J(de,e),J(ue,e),J(ye,e)}}}const As='{"title":"Image processors","local":"image-processors","sections":[{"title":"Image processor classes","local":"image-processor-classes","sections":[],"depth":2},{"title":"Fast image processors","local":"fast-image-processors","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[{"title":"Padding","local":"padding","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ls(Z){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tt extends Hs{constructor(i){super(),Rs(this,i,Ls,Es,Gs,{})}}export{tt as component};
