import{s as Ot,z as eo,o as to,n as Kt}from"../chunks/scheduler.18a86fab.js";import{S as oo,i as no,g as a,s,r as d,A as so,h as i,f as o,c as r,j as I,u as m,x as c,k as J,y as l,a as n,v as u,d as h,t as f,w as g}from"../chunks/index.98837b22.js";import{T as ro}from"../chunks/Tip.77304350.js";import{D as ge}from"../chunks/Docstring.6758ea23.js";import{C as pt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ao}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ye}from"../chunks/Heading.7e7e0c5b.js";import{E as io}from"../chunks/index.499f366c.js";function lo(_e){let p,U="Example:",_,w,C;return w=new pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN1cGVyUG9pbnRDb25maWclMkMlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24lMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3VwZXJQb2ludCUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3VwZXJQb2ludENvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbihjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SuperPointConfig, SuperPointForKeypointDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SuperPoint superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SuperPointConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SuperPointForKeypointDetection(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){p=a("p"),p.textContent=U,_=s(),d(w.$$.fragment)},l(y){p=i(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-11lpom8"&&(p.textContent=U),_=r(y),m(w.$$.fragment,y)},m(y,P){n(y,p,P),n(y,_,P),u(w,y,P),C=!0},p:Kt,i(y){C||(h(w.$$.fragment,y),C=!0)},o(y){f(w.$$.fragment,y),C=!1},d(y){y&&(o(p),o(_)),g(w,y)}}}function co(_e){let p,U=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){p=a("p"),p.innerHTML=U},l(_){p=i(_,"P",{"data-svelte-h":!0}),c(p)!=="svelte-fincs2"&&(p.innerHTML=U)},m(_,w){n(_,p,w)},p:Kt,d(_){_&&o(p)}}}function po(_e){let p,U,_,w,C,y,P,Pt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Ie,D,je,q,$t=`The SuperPoint model was proposed
in <a href="https://arxiv.org/abs/1712.07629" rel="nofollow">SuperPoint: Self-Supervised Interest Point Detection and Description</a> by Daniel
DeTone, Tomasz Malisiewicz and Andrew Rabinovich.`,xe,H,Ut=`This model is the result of a self-supervised training of a fully-convolutional network for interest point detection and
description. The model is able to detect interest points that are repeatable under homographic transformations and
provide a descriptor for each point. The use of the model in its own is limited, but it can be used as a feature
extractor for other tasks such as homography estimation, image matching, etc.`,ze,Z,St="The abstract from the paper is the following:",ke,N,It=`<em>This paper presents a self-supervised framework for training interest point detectors and descriptors suitable for a
large number of multiple-view geometry problems in computer vision. As opposed to patch-based neural networks, our
fully-convolutional model operates on full-sized images and jointly computes pixel-level interest point locations and
associated descriptors in one forward pass. We introduce Homographic Adaptation, a multi-scale, multi-homography
approach for boosting interest point detection repeatability and performing cross-domain adaptation (e.g.,
synthetic-to-real). Our model, when trained on the MS-COCO generic image dataset using Homographic Adaptation, is able
to repeatedly detect a much richer set of interest points than the initial pre-adapted deep model and any other
traditional corner detector. The final system gives rise to state-of-the-art homography estimation results on HPatches
when compared to LIFT, SIFT and ORB.</em>`,Ve,j,jt,We,G,xt='SuperPoint overview. Taken from the <a href="https://arxiv.org/abs/1712.07629v4">original paper.</a>',Re,B,De,E,zt="Here is a quick example of using the model to detect interest points in an image:",qe,F,He,L,kt="The outputs contain the list of keypoint coordinates with their respective score and description (a 256-long vector).",Ze,X,Vt=`You can also feed multiple images to the model. Due to the nature of SuperPoint, to output a dynamic number of keypoints,
you will need to use the mask attribute to retrieve the respective information :`,Ne,Q,Ge,Y,Wt="You can then print the keypoints on the image of your choice to visualize the result:",Be,A,Ee,K,Rt='<img src="https://cdn-uploads.huggingface.co/production/uploads/632885ba1558dac67c440aa8/ZtFmphEhx8tcbEQqOolyE.png" alt="image/png"/>',Fe,O,Dt=`This model was contributed by <a href="https://huggingface.co/stevenbucaille" rel="nofollow">stevenbucaille</a>.
The original code can be found <a href="https://github.com/magicleap/SuperPointPretrainedNetwork" rel="nofollow">here</a>.`,Le,ee,Xe,te,qt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with SuperPoint. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Qe,oe,Ht='<li>A notebook showcasing inference and visualization with SuperPoint can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/SuperPoint/Inference_with_SuperPoint_to_detect_interest_points_in_an_image.ipynb" rel="nofollow">here</a>. 🌎</li>',Ye,ne,Ae,T,se,dt,be,Zt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a>. It is used to instantiate a
SuperPoint model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SuperPoint
<a href="https://huggingface.co/magic-leap-community/superpoint" rel="nofollow">magic-leap-community/superpoint</a> architecture.`,mt,we,Nt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ut,x,Ke,re,Oe,b,ae,ht,Te,Gt="Constructs a SuperPoint image processor.",ft,z,ie,gt,Me,Bt=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a> into lists of keypoints, scores and descriptors
with coordinates absolute to the original image sizes.`,yt,k,le,_t,ve,Et="Preprocess an image or batch of images.",bt,V,ce,wt,Je,Ft="Resize an image.",et,pe,Lt="<li>preprocess</li> <li>post_process_keypoint_detection</li>",tt,de,ot,M,me,Tt,Ce,Xt=`SuperPoint model outputting keypoints and descriptors.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Mt,Pe,Qt=`SuperPoint model. It consists of a SuperPointEncoder, a SuperPointInterestPointDecoder and a
SuperPointDescriptorDecoder. SuperPoint was proposed in <code>SuperPoint: Self-Supervised Interest Point Detection and Description &lt;https://arxiv.org/abs/1712.07629&gt;</code>__ by Daniel DeTone, Tomasz Malisiewicz, and Andrew Rabinovich. It
is a fully convolutional neural network that extracts keypoints and descriptors from an image. It is trained in a
self-supervised manner, using a combination of a photometric loss and a loss based on the homographic adaptation of
keypoints. It is made of a convolutional encoder and two decoders: one for keypoints and one for descriptors.`,vt,S,ue,Jt,$e,Yt='The <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a> forward method, overrides the <code>__call__</code> special method.',Ct,W,nt,he,At="<li>forward</li>",st,fe,rt,Se,at;return C=new ye({props:{title:"SuperPoint",local:"superpoint",headingTag:"h1"}}),D=new ye({props:{title:"Overview",local:"overview",headingTag:"h2"}}),B=new ye({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),F=new pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJwb2ludCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)`,wrap:!1}}),Q=new pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmxfaW1hZ2VfMSUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZV8xJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsX2ltYWdlXzElMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBdXJsX2ltYWdlXzIlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnRlc3Qtc3R1ZmYyMDE3JTJGMDAwMDAwMDAwNTY4LmpwZyUyMiUwQWltYWdlXzIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmxfaW1hZ2VfMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZV8xJTJDJTIwaW1hZ2VfMiU1RCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWFnaWMtbGVhcC1jb21tdW5pdHklMkZzdXBlcnBvaW50JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3VwZXJQb2ludEZvcktleXBvaW50RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWltYWdlX3NpemVzJTIwJTNEJTIwJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSUyMGZvciUyMGltYWdlJTIwaW4lMjBpbWFnZXMlNUQlMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19rZXlwb2ludF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMGltYWdlX3NpemVzKSUwQSUwQWZvciUyMG91dHB1dCUyMGluJTIwb3V0cHV0cyUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGtleXBvaW50cyUyQyUyMHNjb3JlcyUyQyUyMGRlc2NyaXB0b3JzJTIwaW4lMjB6aXAob3V0cHV0JTVCJTIya2V5cG9pbnRzJTIyJTVEJTJDJTIwb3V0cHV0JTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwb3V0cHV0JTVCJTIyZGVzY3JpcHRvcnMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMktleXBvaW50cyUzQSUyMCU3QmtleXBvaW50cyU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyU2NvcmVzJTNBJTIwJTdCc2NvcmVzJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJEZXNjcmlwdG9ycyUzQSUyMCU3QmRlc2NyaXB0b3JzJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url_image_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_1, stream=<span class="hljs-literal">True</span>).raw)
url_image_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/test-stuff2017/000000000568.jpg&quot;</span>
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_2, stream=<span class="hljs-literal">True</span>).raw)

images = [image_1, image_2]

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)
image_sizes = [(image.height, image.width) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
outputs = processor.post_process_keypoint_detection(outputs, image_sizes)

<span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> outputs:
    <span class="hljs-keyword">for</span> keypoints, scores, descriptors <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(output[<span class="hljs-string">&quot;keypoints&quot;</span>], output[<span class="hljs-string">&quot;scores&quot;</span>], output[<span class="hljs-string">&quot;descriptors&quot;</span>]):
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Keypoints: <span class="hljs-subst">{keypoints}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Scores: <span class="hljs-subst">{scores}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Descriptors: <span class="hljs-subst">{descriptors}</span>&quot;</span>)`,wrap:!1}}),A=new pt({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5heGlzKCUyMm9mZiUyMiklMEFwbHQuaW1zaG93KGltYWdlXzEpJTBBcGx0LnNjYXR0ZXIoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyU1QjAlNUQlNUIlMjJrZXlwb2ludHMlMjIlNUQlNUIlM0ElMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyU1QjAlNUQlNUIlMjJrZXlwb2ludHMlMjIlNUQlNUIlM0ElMkMlMjAxJTVEJTJDJTBBJTIwJTIwJTIwJTIwYyUzRG91dHB1dHMlNUIwJTVEJTVCJTIyc2NvcmVzJTIyJTVEJTIwKiUyMDEwMCUyQyUwQSUyMCUyMCUyMCUyMHMlM0RvdXRwdXRzJTVCMCU1RCU1QiUyMnNjb3JlcyUyMiU1RCUyMColMjA1MCUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMC44JTBBKSUwQXBsdC5zYXZlZmlnKGYlMjJvdXRwdXRfaW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.imshow(image_1)
plt.scatter(
    outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;keypoints&quot;</span>][:, <span class="hljs-number">0</span>],
    outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;keypoints&quot;</span>][:, <span class="hljs-number">1</span>],
    c=outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;scores&quot;</span>] * <span class="hljs-number">100</span>,
    s=outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;scores&quot;</span>] * <span class="hljs-number">50</span>,
    alpha=<span class="hljs-number">0.8</span>
)
plt.savefig(<span class="hljs-string">f&quot;output_image.png&quot;</span>)`,wrap:!1}}),ee=new ye({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ne=new ye({props:{title:"SuperPointConfig",local:"transformers.SuperPointConfig",headingTag:"h2"}}),se=new ge({props:{name:"class transformers.SuperPointConfig",anchor:"transformers.SuperPointConfig",parameters:[{name:"encoder_hidden_sizes",val:": typing.List[int] = [64, 64, 128, 128]"},{name:"decoder_hidden_size",val:": int = 256"},{name:"keypoint_decoder_dim",val:": int = 65"},{name:"descriptor_decoder_dim",val:": int = 256"},{name:"keypoint_threshold",val:": float = 0.005"},{name:"max_keypoints",val:": int = -1"},{name:"nms_radius",val:": int = 4"},{name:"border_removal_distance",val:": int = 4"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointConfig.encoder_hidden_sizes",description:`<strong>encoder_hidden_sizes</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[64, 64, 128, 128]</code>) &#x2014;
The number of channels in each convolutional layer in the encoder.`,name:"encoder_hidden_sizes"},{anchor:"transformers.SuperPointConfig.decoder_hidden_size",description:"<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The hidden size of the decoder.",name:"decoder_hidden_size"},{anchor:"transformers.SuperPointConfig.keypoint_decoder_dim",description:"<strong>keypoint_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 65) &#x2014; The output dimension of the keypoint decoder.",name:"keypoint_decoder_dim"},{anchor:"transformers.SuperPointConfig.descriptor_decoder_dim",description:"<strong>descriptor_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The output dimension of the descriptor decoder.",name:"descriptor_decoder_dim"},{anchor:"transformers.SuperPointConfig.keypoint_threshold",description:`<strong>keypoint_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.005) &#x2014;
The threshold to use for extracting keypoints.`,name:"keypoint_threshold"},{anchor:"transformers.SuperPointConfig.max_keypoints",description:`<strong>max_keypoints</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The maximum number of keypoints to extract. If <code>-1</code>, will extract all keypoints.`,name:"max_keypoints"},{anchor:"transformers.SuperPointConfig.nms_radius",description:`<strong>nms_radius</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The radius for non-maximum suppression.`,name:"nms_radius"},{anchor:"transformers.SuperPointConfig.border_removal_distance",description:`<strong>border_removal_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The distance from the border to remove keypoints.`,name:"border_removal_distance"},{anchor:"transformers.SuperPointConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/configuration_superpoint.py#L23"}}),x=new ao({props:{anchor:"transformers.SuperPointConfig.example",$$slots:{default:[lo]},$$scope:{ctx:_e}}}),re=new ye({props:{title:"SuperPointImageProcessor",local:"transformers.SuperPointImageProcessor",headingTag:"h2"}}),ae=new ge({props:{name:"class transformers.SuperPointImageProcessor",anchor:"transformers.SuperPointImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_grayscale",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 480, &quot;width&quot;: 640}</code>):
Resolution of the output image after <code>resize</code> is applied. Only has an effect if <code>do_resize</code> is set to
<code>True</code>. Can be overridden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.SuperPointImageProcessor.do_grayscale",description:`<strong>do_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to convert the image to grayscale. Can be overridden by <code>do_grayscale</code> in the <code>preprocess</code> method.`,name:"do_grayscale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L99"}}),ie=new ge({props:{name:"post_process_keypoint_detection",anchor:"transformers.SuperPointImageProcessor.post_process_keypoint_detection",parameters:[{name:"outputs",val:": SuperPointKeypointDescriptionOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]]"}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.post_process_keypoint_detection.outputs",description:`<strong>outputs</strong> (<code>SuperPointKeypointDescriptionOutput</code>) &#x2014;
Raw outputs of the model containing keypoints in a relative (x, y) format, with scores and descriptors.`,name:"outputs"},{anchor:"transformers.SuperPointImageProcessor.post_process_keypoint_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. This must be the original
image size (before any processing).`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L292",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the keypoints in absolute format according
to target_sizes, scores and descriptors for an image in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),le=new ge({props:{name:"preprocess",anchor:"transformers.SuperPointImageProcessor.preprocess",parameters:[{name:"images",val:""},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_grayscale",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after <code>resize</code> has been applied. If <code>size[&quot;shortest_edge&quot;]</code> &gt;= 384, the image
is resized to <code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Otherwise, the smaller edge of the
image will be matched to <code>int(size[&quot;shortest_edge&quot;]/ crop_pct)</code>, after which the image is cropped to
<code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_grayscale",description:`<strong>do_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_grayscale</code>) &#x2014;
Whether to convert the image to grayscale.`,name:"do_grayscale"},{anchor:"transformers.SuperPointImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SuperPointImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L180"}}),ce=new ge({props:{name:"resize",anchor:"transformers.SuperPointImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.SuperPointImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary of the form <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>, specifying the size of the output image.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the output image. If not provided, it will be inferred from the input
image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L141"}}),de=new ye({props:{title:"SuperPointForKeypointDetection",local:"transformers.SuperPointForKeypointDetection",headingTag:"h2"}}),me=new ge({props:{name:"class transformers.SuperPointForKeypointDetection",anchor:"transformers.SuperPointForKeypointDetection",parameters:[{name:"config",val:": SuperPointConfig"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointConfig">SuperPointConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L390"}}),ue=new ge({props:{name:"forward",anchor:"transformers.SuperPointForKeypointDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointImageProcessor">SuperPointImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">SuperPointImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.SuperPointForKeypointDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for more
detail.`,name:"output_hidden_states"},{anchor:"transformers.SuperPointForKeypointDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Examples:`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L415"}}),W=new ro({props:{$$slots:{default:[co]},$$scope:{ctx:_e}}}),fe=new io({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/superpoint.md"}}),{c(){p=a("meta"),U=s(),_=a("p"),w=s(),d(C.$$.fragment),y=s(),P=a("div"),P.innerHTML=Pt,Ie=s(),d(D.$$.fragment),je=s(),q=a("p"),q.innerHTML=$t,xe=s(),H=a("p"),H.textContent=Ut,ze=s(),Z=a("p"),Z.textContent=St,ke=s(),N=a("p"),N.innerHTML=It,Ve=s(),j=a("img"),We=s(),G=a("small"),G.innerHTML=xt,Re=s(),d(B.$$.fragment),De=s(),E=a("p"),E.textContent=zt,qe=s(),d(F.$$.fragment),He=s(),L=a("p"),L.textContent=kt,Ze=s(),X=a("p"),X.textContent=Vt,Ne=s(),d(Q.$$.fragment),Ge=s(),Y=a("p"),Y.textContent=Wt,Be=s(),d(A.$$.fragment),Ee=s(),K=a("p"),K.innerHTML=Rt,Fe=s(),O=a("p"),O.innerHTML=Dt,Le=s(),d(ee.$$.fragment),Xe=s(),te=a("p"),te.textContent=qt,Qe=s(),oe=a("ul"),oe.innerHTML=Ht,Ye=s(),d(ne.$$.fragment),Ae=s(),T=a("div"),d(se.$$.fragment),dt=s(),be=a("p"),be.innerHTML=Zt,mt=s(),we=a("p"),we.innerHTML=Nt,ut=s(),d(x.$$.fragment),Ke=s(),d(re.$$.fragment),Oe=s(),b=a("div"),d(ae.$$.fragment),ht=s(),Te=a("p"),Te.textContent=Gt,ft=s(),z=a("div"),d(ie.$$.fragment),gt=s(),Me=a("p"),Me.innerHTML=Bt,yt=s(),k=a("div"),d(le.$$.fragment),_t=s(),ve=a("p"),ve.textContent=Et,bt=s(),V=a("div"),d(ce.$$.fragment),wt=s(),Je=a("p"),Je.textContent=Ft,et=s(),pe=a("ul"),pe.innerHTML=Lt,tt=s(),d(de.$$.fragment),ot=s(),M=a("div"),d(me.$$.fragment),Tt=s(),Ce=a("p"),Ce.innerHTML=Xt,Mt=s(),Pe=a("p"),Pe.innerHTML=Qt,vt=s(),S=a("div"),d(ue.$$.fragment),Jt=s(),$e=a("p"),$e.innerHTML=Yt,Ct=s(),d(W.$$.fragment),nt=s(),he=a("ul"),he.innerHTML=At,st=s(),d(fe.$$.fragment),rt=s(),Se=a("p"),this.h()},l(e){const t=so("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(o),U=r(e),_=i(e,"P",{}),I(_).forEach(o),w=r(e),m(C.$$.fragment,e),y=r(e),P=i(e,"DIV",{class:!0,"data-svelte-h":!0}),c(P)!=="svelte-13t8s2t"&&(P.innerHTML=Pt),Ie=r(e),m(D.$$.fragment,e),je=r(e),q=i(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-3y1k2h"&&(q.innerHTML=$t),xe=r(e),H=i(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-113tmz"&&(H.textContent=Ut),ze=r(e),Z=i(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-vfdo9a"&&(Z.textContent=St),ke=r(e),N=i(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-110fra1"&&(N.innerHTML=It),Ve=r(e),j=i(e,"IMG",{src:!0,alt:!0,width:!0}),We=r(e),G=i(e,"SMALL",{"data-svelte-h":!0}),c(G)!=="svelte-1md4ofy"&&(G.innerHTML=xt),Re=r(e),m(B.$$.fragment,e),De=r(e),E=i(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-u2cob9"&&(E.textContent=zt),qe=r(e),m(F.$$.fragment,e),He=r(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-qs9qlh"&&(L.textContent=kt),Ze=r(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-g88i9e"&&(X.textContent=Vt),Ne=r(e),m(Q.$$.fragment,e),Ge=r(e),Y=i(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1ak0l5f"&&(Y.textContent=Wt),Be=r(e),m(A.$$.fragment,e),Ee=r(e),K=i(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-oxei2o"&&(K.innerHTML=Rt),Fe=r(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1s32sqj"&&(O.innerHTML=Dt),Le=r(e),m(ee.$$.fragment,e),Xe=r(e),te=i(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-1tjytfm"&&(te.textContent=qt),Qe=r(e),oe=i(e,"UL",{"data-svelte-h":!0}),c(oe)!=="svelte-1w6ygh7"&&(oe.innerHTML=Ht),Ye=r(e),m(ne.$$.fragment,e),Ae=r(e),T=i(e,"DIV",{class:!0});var $=I(T);m(se.$$.fragment,$),dt=r($),be=i($,"P",{"data-svelte-h":!0}),c(be)!=="svelte-rmywrk"&&(be.innerHTML=Zt),mt=r($),we=i($,"P",{"data-svelte-h":!0}),c(we)!=="svelte-o55m63"&&(we.innerHTML=Nt),ut=r($),m(x.$$.fragment,$),$.forEach(o),Ke=r(e),m(re.$$.fragment,e),Oe=r(e),b=i(e,"DIV",{class:!0});var v=I(b);m(ae.$$.fragment,v),ht=r(v),Te=i(v,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-bn94yj"&&(Te.textContent=Gt),ft=r(v),z=i(v,"DIV",{class:!0});var it=I(z);m(ie.$$.fragment,it),gt=r(it),Me=i(it,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-14d1kg5"&&(Me.innerHTML=Bt),it.forEach(o),yt=r(v),k=i(v,"DIV",{class:!0});var lt=I(k);m(le.$$.fragment,lt),_t=r(lt),ve=i(lt,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-1x3yxsa"&&(ve.textContent=Et),lt.forEach(o),bt=r(v),V=i(v,"DIV",{class:!0});var ct=I(V);m(ce.$$.fragment,ct),wt=r(ct),Je=i(ct,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1eb2h1k"&&(Je.textContent=Ft),ct.forEach(o),v.forEach(o),et=r(e),pe=i(e,"UL",{"data-svelte-h":!0}),c(pe)!=="svelte-166rkny"&&(pe.innerHTML=Lt),tt=r(e),m(de.$$.fragment,e),ot=r(e),M=i(e,"DIV",{class:!0});var R=I(M);m(me.$$.fragment,R),Tt=r(R),Ce=i(R,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1jukl7g"&&(Ce.innerHTML=Xt),Mt=r(R),Pe=i(R,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-1177mku"&&(Pe.innerHTML=Qt),vt=r(R),S=i(R,"DIV",{class:!0});var Ue=I(S);m(ue.$$.fragment,Ue),Jt=r(Ue),$e=i(Ue,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1kya80i"&&($e.innerHTML=Yt),Ct=r(Ue),m(W.$$.fragment,Ue),Ue.forEach(o),R.forEach(o),nt=r(e),he=i(e,"UL",{"data-svelte-h":!0}),c(he)!=="svelte-n3ow4o"&&(he.innerHTML=At),st=r(e),m(fe.$$.fragment,e),rt=r(e),Se=i(e,"P",{}),I(Se).forEach(o),this.h()},h(){J(p,"name","hf:doc:metadata"),J(p,"content",mo),J(P,"class","flex flex-wrap space-x-1"),eo(j.src,jt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/superpoint_architecture.png")||J(j,"src",jt),J(j,"alt","drawing"),J(j,"width","500"),J(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,p),n(e,U,t),n(e,_,t),n(e,w,t),u(C,e,t),n(e,y,t),n(e,P,t),n(e,Ie,t),u(D,e,t),n(e,je,t),n(e,q,t),n(e,xe,t),n(e,H,t),n(e,ze,t),n(e,Z,t),n(e,ke,t),n(e,N,t),n(e,Ve,t),n(e,j,t),n(e,We,t),n(e,G,t),n(e,Re,t),u(B,e,t),n(e,De,t),n(e,E,t),n(e,qe,t),u(F,e,t),n(e,He,t),n(e,L,t),n(e,Ze,t),n(e,X,t),n(e,Ne,t),u(Q,e,t),n(e,Ge,t),n(e,Y,t),n(e,Be,t),u(A,e,t),n(e,Ee,t),n(e,K,t),n(e,Fe,t),n(e,O,t),n(e,Le,t),u(ee,e,t),n(e,Xe,t),n(e,te,t),n(e,Qe,t),n(e,oe,t),n(e,Ye,t),u(ne,e,t),n(e,Ae,t),n(e,T,t),u(se,T,null),l(T,dt),l(T,be),l(T,mt),l(T,we),l(T,ut),u(x,T,null),n(e,Ke,t),u(re,e,t),n(e,Oe,t),n(e,b,t),u(ae,b,null),l(b,ht),l(b,Te),l(b,ft),l(b,z),u(ie,z,null),l(z,gt),l(z,Me),l(b,yt),l(b,k),u(le,k,null),l(k,_t),l(k,ve),l(b,bt),l(b,V),u(ce,V,null),l(V,wt),l(V,Je),n(e,et,t),n(e,pe,t),n(e,tt,t),u(de,e,t),n(e,ot,t),n(e,M,t),u(me,M,null),l(M,Tt),l(M,Ce),l(M,Mt),l(M,Pe),l(M,vt),l(M,S),u(ue,S,null),l(S,Jt),l(S,$e),l(S,Ct),u(W,S,null),n(e,nt,t),n(e,he,t),n(e,st,t),u(fe,e,t),n(e,rt,t),n(e,Se,t),at=!0},p(e,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:e}),x.$set($);const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),W.$set(v)},i(e){at||(h(C.$$.fragment,e),h(D.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(Q.$$.fragment,e),h(A.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(x.$$.fragment,e),h(re.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(le.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(W.$$.fragment,e),h(fe.$$.fragment,e),at=!0)},o(e){f(C.$$.fragment,e),f(D.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(se.$$.fragment,e),f(x.$$.fragment,e),f(re.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(W.$$.fragment,e),f(fe.$$.fragment,e),at=!1},d(e){e&&(o(U),o(_),o(w),o(y),o(P),o(Ie),o(je),o(q),o(xe),o(H),o(ze),o(Z),o(ke),o(N),o(Ve),o(j),o(We),o(G),o(Re),o(De),o(E),o(qe),o(He),o(L),o(Ze),o(X),o(Ne),o(Ge),o(Y),o(Be),o(Ee),o(K),o(Fe),o(O),o(Le),o(Xe),o(te),o(Qe),o(oe),o(Ye),o(Ae),o(T),o(Ke),o(Oe),o(b),o(et),o(pe),o(tt),o(ot),o(M),o(nt),o(he),o(st),o(rt),o(Se)),o(p),g(C,e),g(D,e),g(B,e),g(F,e),g(Q,e),g(A,e),g(ee,e),g(ne,e),g(se),g(x),g(re,e),g(ae),g(ie),g(le),g(ce),g(de,e),g(me),g(ue),g(W),g(fe,e)}}}const mo='{"title":"SuperPoint","local":"superpoint","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SuperPointConfig","local":"transformers.SuperPointConfig","sections":[],"depth":2},{"title":"SuperPointImageProcessor","local":"transformers.SuperPointImageProcessor","sections":[],"depth":2},{"title":"SuperPointForKeypointDetection","local":"transformers.SuperPointForKeypointDetection","sections":[],"depth":2}],"depth":1}';function uo(_e){return to(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mo extends oo{constructor(p){super(),no(this,p,uo,po,Ot,{})}}export{Mo as component};
