import{s as mt,n as ft,o as ut}from"../chunks/scheduler.18a86fab.js";import{S as ht,i as gt,g as a,s as i,r as f,A as vt,h as o,f as n,c as l,j as Ae,u,x as r,k as Ie,y as c,a as s,v as h,d as g,t as v,w as $}from"../chunks/index.98837b22.js";import{D as dt}from"../chunks/Docstring.6758ea23.js";import{C as De}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as ne}from"../chunks/Heading.7e7e0c5b.js";import{E as $t}from"../chunks/index.499f366c.js";function yt(Ve){let y,se,ee,ie,_,le,b,Ze=`This page goes through the transformers utilities to enable lazy and fast object import.
While we strive for minimal dependencies, some models have specific dependencies requirements that cannot be
worked around. We don’t want for all users of <code>transformers</code> to have to install those dependencies to use other models,
we therefore mark those as soft dependencies rather than hard dependencies.`,ae,x,We=`The transformers toolkit is not made to error-out on import of a model that has a specific dependency; instead, an
object for which you are lacking a dependency will error-out when calling any method on it. As an example, if
<code>torchvision</code> isn’t installed, the fast image processors will not be available.`,oe,w,Re="This object is still importable:",re,C,pe,T,Se="However, no method can be called on that object:",ce,j,de,M,Xe="Let’s see how to specify specific object dependencies.",me,P,fe,k,ue,H,Ne="All objects under a given filename have an automatic dependency to the tool linked to the filename",he,L,Qe="<strong>TensorFlow</strong>: All files starting with <code>modeling_tf_</code> have an automatic TensorFlow dependency.",ge,A,Ye="<strong>Flax</strong>: All files starting with <code>modeling_flax_</code> have an automatic Flax dependency",ve,I,Ge=`<strong>PyTorch</strong>: All files starting with <code>modeling_</code> and not valid with the above (TensorFlow and Flax) have an automatic
PyTorch dependency`,$e,J,Oe="<strong>Tokenizers</strong>: All files starting with <code>tokenization_</code> and ending with <code>_fast</code> have an automatic <code>tokenizers</code> dependency",ye,z,Ke=`<strong>Vision</strong>: All files starting with <code>image_processing_</code> have an automatic dependency to the <code>vision</code> dependency group;
at the time of writing, this only contains the <code>pillow</code> dependency.`,_e,F,et=`<strong>Vision + Torch + Torchvision</strong>: All files starting with <code>image_processing_</code> and ending with <code>_fast</code> have an automatic
dependency to <code>vision</code>, <code>torch</code>, and <code>torchvision</code>.`,be,q,tt="All of these automatic dependencies are added on top of the explicit dependencies that are detailed below.",xe,E,we,U,nt=`We add a method called <code>requires</code> that is used to explicitly specify the dependencies of a given object. As an
example, the <code>Trainer</code> class has two hard dependencies: <code>torch</code> and <code>accelerate</code>. Here is how we specify these
required dependencies:`,Ce,B,Te,D,st="Backends that can be added here are all the backends that are available in the <code>import_utils.py</code> module.",je,V,Me,p,Z,Je,S,it="This method takes a module_path as input and creates an import structure digestible by a _LazyModule.",ze,X,lt="Here’s an example of an output import structure at the src.transformers.models level:",Fe,N,at=`{
frozenset({‘tokenizers’}): {
‘albert.tokenization_albert_fast’: {‘AlbertTokenizerFast’}
},
frozenset(): {
‘albert.configuration_albert’: {‘AlbertConfig’, ‘AlbertOnnxConfig’},
‘align.processing_align’: {‘AlignProcessor’},
‘align.configuration_align’: {‘AlignConfig’, ‘AlignTextConfig’, ‘AlignVisionConfig’},
‘altclip.configuration_altclip’: {‘AltCLIPConfig’, ‘AltCLIPTextConfig’, ‘AltCLIPVisionConfig’},
‘altclip.processing_altclip’: {‘AltCLIPProcessor’}
}
}`,qe,Q,ot="The import structure is a dict defined with frozensets as keys, and dicts of strings to sets of objects.",Ee,Y,rt="If <code>prefix</code> is not None, it will add that prefix to all keys in the returned dict.",Pe,m,W,Ue,G,pt="This decorator enables two things:",Be,O,ct=`<li>Attaching a <code>__backends</code> tuple to an object to see what are the necessary backends for it
to execute correctly without instantiating it</li> <li>The ‘@requires’ string is used to dynamically import objects</li>`,ke,R,He,te,Le;return _=new ne({props:{title:"Import Utilities",local:"import-utilities",headingTag:"h1"}}),C=new De({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERldHJJbWFnZVByb2Nlc3NvckZhc3QlMEFwcmludChEZXRySW1hZ2VQcm9jZXNzb3JGYXN0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrImageProcessorFast
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(DetrImageProcessorFast)
&lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;DetrImageProcessorFast&#x27;</span>&gt;`,wrap:!1}}),j=new De({props:{code:"RGV0ckltYWdlUHJvY2Vzc29yRmFzdC5mcm9tX3ByZXRyYWluZWQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>DetrImageProcessorFast.from_pretrained()
ImportError: 
DetrImageProcessorFast requires the Torchvision library but it was <span class="hljs-keyword">not</span> found <span class="hljs-keyword">in</span> your environment. Checkout the instructions on the
installation page: https://pytorch.org/get-started/locally/ <span class="hljs-keyword">and</span> follow the ones that <span class="hljs-keyword">match</span> your environment.
Please note that you may need to restart your runtime after installation.`,wrap:!1}}),P=new ne({props:{title:"Specifying Object Dependencies",local:"specifying-object-dependencies",headingTag:"h2"}}),k=new ne({props:{title:"Filename-based",local:"filename-based",headingTag:"h3"}}),E=new ne({props:{title:"Explicit Object Dependencies",local:"explicit-object-dependencies",headingTag:"h3"}}),B=new De({props:{code:"ZnJvbSUyMC51dGlscy5pbXBvcnRfdXRpbHMlMjBpbXBvcnQlMjByZXF1aXJlcyUwQSUwQSU0MHJlcXVpcmVzKGJhY2tlbmRzJTNEKCUyMnRvcmNoJTIyJTJDJTIwJTIyYWNjZWxlcmF0ZSUyMikpJTBBY2xhc3MlMjBUcmFpbmVyJTNBJTBBJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">from</span> .utils.import_utils <span class="hljs-keyword">import</span> requires

<span class="hljs-meta">@requires(<span class="hljs-params">backends=(<span class="hljs-params"><span class="hljs-string">&quot;torch&quot;</span>, <span class="hljs-string">&quot;accelerate&quot;</span></span>)</span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Trainer</span>:
    ...`,wrap:!1}}),V=new ne({props:{title:"Methods",local:"transformers.utils.import_utils.define_import_structure",headingTag:"h2"}}),Z=new dt({props:{name:"transformers.utils.import_utils.define_import_structure",anchor:"transformers.utils.import_utils.define_import_structure",parameters:[{name:"module_path",val:": str"},{name:"prefix",val:": typing.Optional[str] = None"}]}}),W=new dt({props:{name:"transformers.utils.import_utils.requires",anchor:"transformers.utils.import_utils.requires",parameters:[{name:"backends",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/import_utils.py#L2045"}}),R=new $t({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/internal/import_utils.md"}}),{c(){y=a("meta"),se=i(),ee=a("p"),ie=i(),f(_.$$.fragment),le=i(),b=a("p"),b.innerHTML=Ze,ae=i(),x=a("p"),x.innerHTML=We,oe=i(),w=a("p"),w.textContent=Re,re=i(),f(C.$$.fragment),pe=i(),T=a("p"),T.textContent=Se,ce=i(),f(j.$$.fragment),de=i(),M=a("p"),M.textContent=Xe,me=i(),f(P.$$.fragment),fe=i(),f(k.$$.fragment),ue=i(),H=a("p"),H.textContent=Ne,he=i(),L=a("p"),L.innerHTML=Qe,ge=i(),A=a("p"),A.innerHTML=Ye,ve=i(),I=a("p"),I.innerHTML=Ge,$e=i(),J=a("p"),J.innerHTML=Oe,ye=i(),z=a("p"),z.innerHTML=Ke,_e=i(),F=a("p"),F.innerHTML=et,be=i(),q=a("p"),q.textContent=tt,xe=i(),f(E.$$.fragment),we=i(),U=a("p"),U.innerHTML=nt,Ce=i(),f(B.$$.fragment),Te=i(),D=a("p"),D.innerHTML=st,je=i(),f(V.$$.fragment),Me=i(),p=a("div"),f(Z.$$.fragment),Je=i(),S=a("p"),S.textContent=it,ze=i(),X=a("p"),X.textContent=lt,Fe=i(),N=a("p"),N.textContent=at,qe=i(),Q=a("p"),Q.textContent=ot,Ee=i(),Y=a("p"),Y.innerHTML=rt,Pe=i(),m=a("div"),f(W.$$.fragment),Ue=i(),G=a("p"),G.textContent=pt,Be=i(),O=a("ul"),O.innerHTML=ct,ke=i(),f(R.$$.fragment),He=i(),te=a("p"),this.h()},l(e){const t=vt("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(n),se=l(e),ee=o(e,"P",{}),Ae(ee).forEach(n),ie=l(e),u(_.$$.fragment,e),le=l(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1sq0d21"&&(b.innerHTML=Ze),ae=l(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1h66sjo"&&(x.innerHTML=We),oe=l(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-ofaiyy"&&(w.textContent=Re),re=l(e),u(C.$$.fragment,e),pe=l(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1lv9355"&&(T.textContent=Se),ce=l(e),u(j.$$.fragment,e),de=l(e),M=o(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1urggpc"&&(M.textContent=Xe),me=l(e),u(P.$$.fragment,e),fe=l(e),u(k.$$.fragment,e),ue=l(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1fa77p5"&&(H.textContent=Ne),he=l(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-jlavg6"&&(L.innerHTML=Qe),ge=l(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-142jhdv"&&(A.innerHTML=Ye),ve=l(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-e67hmr"&&(I.innerHTML=Ge),$e=l(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-2ds1y"&&(J.innerHTML=Oe),ye=l(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-12il0co"&&(z.innerHTML=Ke),_e=l(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-9v6z5i"&&(F.innerHTML=et),be=l(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-spzh9a"&&(q.textContent=tt),xe=l(e),u(E.$$.fragment,e),we=l(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1tp2bu8"&&(U.innerHTML=nt),Ce=l(e),u(B.$$.fragment,e),Te=l(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-tt5tx3"&&(D.innerHTML=st),je=l(e),u(V.$$.fragment,e),Me=l(e),p=o(e,"DIV",{class:!0});var d=Ae(p);u(Z.$$.fragment,d),Je=l(d),S=o(d,"P",{"data-svelte-h":!0}),r(S)!=="svelte-95xerm"&&(S.textContent=it),ze=l(d),X=o(d,"P",{"data-svelte-h":!0}),r(X)!=="svelte-156ifki"&&(X.textContent=lt),Fe=l(d),N=o(d,"P",{"data-svelte-h":!0}),r(N)!=="svelte-yg830s"&&(N.textContent=at),qe=l(d),Q=o(d,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-5u4rti"&&(Q.textContent=ot),Ee=l(d),Y=o(d,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1bsr87l"&&(Y.innerHTML=rt),d.forEach(n),Pe=l(e),m=o(e,"DIV",{class:!0});var K=Ae(m);u(W.$$.fragment,K),Ue=l(K),G=o(K,"P",{"data-svelte-h":!0}),r(G)!=="svelte-m9yvj6"&&(G.textContent=pt),Be=l(K),O=o(K,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-1a9rw40"&&(O.innerHTML=ct),K.forEach(n),ke=l(e),u(R.$$.fragment,e),He=l(e),te=o(e,"P",{}),Ae(te).forEach(n),this.h()},h(){Ie(y,"name","hf:doc:metadata"),Ie(y,"content",_t),Ie(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ie(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,y),s(e,se,t),s(e,ee,t),s(e,ie,t),h(_,e,t),s(e,le,t),s(e,b,t),s(e,ae,t),s(e,x,t),s(e,oe,t),s(e,w,t),s(e,re,t),h(C,e,t),s(e,pe,t),s(e,T,t),s(e,ce,t),h(j,e,t),s(e,de,t),s(e,M,t),s(e,me,t),h(P,e,t),s(e,fe,t),h(k,e,t),s(e,ue,t),s(e,H,t),s(e,he,t),s(e,L,t),s(e,ge,t),s(e,A,t),s(e,ve,t),s(e,I,t),s(e,$e,t),s(e,J,t),s(e,ye,t),s(e,z,t),s(e,_e,t),s(e,F,t),s(e,be,t),s(e,q,t),s(e,xe,t),h(E,e,t),s(e,we,t),s(e,U,t),s(e,Ce,t),h(B,e,t),s(e,Te,t),s(e,D,t),s(e,je,t),h(V,e,t),s(e,Me,t),s(e,p,t),h(Z,p,null),c(p,Je),c(p,S),c(p,ze),c(p,X),c(p,Fe),c(p,N),c(p,qe),c(p,Q),c(p,Ee),c(p,Y),s(e,Pe,t),s(e,m,t),h(W,m,null),c(m,Ue),c(m,G),c(m,Be),c(m,O),s(e,ke,t),h(R,e,t),s(e,He,t),s(e,te,t),Le=!0},p:ft,i(e){Le||(g(_.$$.fragment,e),g(C.$$.fragment,e),g(j.$$.fragment,e),g(P.$$.fragment,e),g(k.$$.fragment,e),g(E.$$.fragment,e),g(B.$$.fragment,e),g(V.$$.fragment,e),g(Z.$$.fragment,e),g(W.$$.fragment,e),g(R.$$.fragment,e),Le=!0)},o(e){v(_.$$.fragment,e),v(C.$$.fragment,e),v(j.$$.fragment,e),v(P.$$.fragment,e),v(k.$$.fragment,e),v(E.$$.fragment,e),v(B.$$.fragment,e),v(V.$$.fragment,e),v(Z.$$.fragment,e),v(W.$$.fragment,e),v(R.$$.fragment,e),Le=!1},d(e){e&&(n(se),n(ee),n(ie),n(le),n(b),n(ae),n(x),n(oe),n(w),n(re),n(pe),n(T),n(ce),n(de),n(M),n(me),n(fe),n(ue),n(H),n(he),n(L),n(ge),n(A),n(ve),n(I),n($e),n(J),n(ye),n(z),n(_e),n(F),n(be),n(q),n(xe),n(we),n(U),n(Ce),n(Te),n(D),n(je),n(Me),n(p),n(Pe),n(m),n(ke),n(He),n(te)),n(y),$(_,e),$(C,e),$(j,e),$(P,e),$(k,e),$(E,e),$(B,e),$(V,e),$(Z),$(W),$(R,e)}}}const _t='{"title":"Import Utilities","local":"import-utilities","sections":[{"title":"Specifying Object Dependencies","local":"specifying-object-dependencies","sections":[{"title":"Filename-based","local":"filename-based","sections":[],"depth":3},{"title":"Explicit Object Dependencies","local":"explicit-object-dependencies","sections":[],"depth":3}],"depth":2},{"title":"Methods","local":"transformers.utils.import_utils.define_import_structure","sections":[],"depth":2}],"depth":1}';function bt(Ve){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends ht{constructor(y){super(),gt(this,y,bt,yt,mt,{})}}export{Pt as component};
