import{s as en,o as tn,n as q}from"../chunks/scheduler.18a86fab.js";import{S as nn,i as ln,g as u,s as p,r as y,A as an,h as c,f as t,c as m,j as Ot,u as $,x as b,k as Ge,y as sn,a as n,v as w,d as T,t as g,w as v}from"../chunks/index.98837b22.js";import{T as on}from"../chunks/Tip.77304350.js";import{C as X}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as xe}from"../chunks/Heading.7e7e0c5b.js";import{H as vt,a as Y}from"../chunks/HfOption.6641485e.js";import{E as rn}from"../chunks/index.499f366c.js";function pn(_){let a,f='For text generation with 8-bit quantization, you should use <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> instead of the high-level <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> API. The <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> returns slower performance because it isn’t optimized for 8-bit models, and some sampling strategies (nucleus sampling) also aren’t supported.',o,r,s='Set up a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> and set <code>load_in_8bit=True</code> to load a model in 8-bit precision. The <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> is passed to the <code>quantization_config</code> parameter in <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>.',i,d,U='Allow Accelerate to automatically distribute the model across your available hardware by setting <a href="https://hf.co/docs/accelerate/concept_guides/big_model_inference#designing-a-device-map" rel="nofollow">device_map=“auto”</a>.',G,W,R="Place all inputs on the same device as the model.",x,B,Z,j,H="For distributed setups, use the <code>max_memory</code> parameter to create a mapping of the amount of memory to allocate to each GPU. The example below distributes 16GB of memory to the first GPU and 16GB of memory to the second GPU.",M,J,F,C,I='Learn in more detail the concepts underlying 8-bit quantization in the <a href="https://hf.co/blog/hf-bitsandbytes-integration" rel="nofollow">Gentle Introduction to 8-bit Matrix Multiplication for transformers at scale using Hugging Face Transformers, Accelerate and bitsandbytes</a> blog post.',L;return B=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04QiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySGVsbG8lMkMlMjBteSUyMGxsYW1hJTIwaXMlMjBjdXRlJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQW91dHB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig, AutoTokenizer, AutoModelForCausalLM

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer(<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=quantization_config)

prompt = <span class="hljs-string">&quot;Hello, my llama is cute&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generated_ids = model.generate(**inputs)
outputs = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),J=new X({props:{code:"bWF4X21lbW9yeV9tYXBwaW5nJTIwJTNEJTIwJTdCMCUzQSUyMCUyMjE2R0IlMjIlMkMlMjAxJTNBJTIwJTIyMTZHQiUyMiU3RCUwQW1vZGVsXzhiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04QiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjBtYXhfbWVtb3J5JTNEbWF4X21lbW9yeV9tYXBwaW5nJTBBKQ==",highlighted:`max_memory_mapping = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>}
model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=quantization_config, max_memory=max_memory_mapping
)`,wrap:!1}}),{c(){a=u("p"),a.innerHTML=f,o=p(),r=u("p"),r.innerHTML=s,i=p(),d=u("p"),d.innerHTML=U,G=p(),W=u("p"),W.textContent=R,x=p(),y(B.$$.fragment),Z=p(),j=u("p"),j.innerHTML=H,M=p(),y(J.$$.fragment),F=p(),C=u("p"),C.innerHTML=I},l(h){a=c(h,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1i3peqo"&&(a.innerHTML=f),o=m(h),r=c(h,"P",{"data-svelte-h":!0}),b(r)!=="svelte-ogykwt"&&(r.innerHTML=s),i=m(h),d=c(h,"P",{"data-svelte-h":!0}),b(d)!=="svelte-189jfcc"&&(d.innerHTML=U),G=m(h),W=c(h,"P",{"data-svelte-h":!0}),b(W)!=="svelte-6y3wld"&&(W.textContent=R),x=m(h),$(B.$$.fragment,h),Z=m(h),j=c(h,"P",{"data-svelte-h":!0}),b(j)!=="svelte-m5ityn"&&(j.innerHTML=H),M=m(h),$(J.$$.fragment,h),F=m(h),C=c(h,"P",{"data-svelte-h":!0}),b(C)!=="svelte-1xjsovs"&&(C.innerHTML=I)},m(h,k){n(h,a,k),n(h,o,k),n(h,r,k),n(h,i,k),n(h,d,k),n(h,G,k),n(h,W,k),n(h,x,k),w(B,h,k),n(h,Z,k),n(h,j,k),n(h,M,k),w(J,h,k),n(h,F,k),n(h,C,k),L=!0},p:q,i(h){L||(T(B.$$.fragment,h),T(J.$$.fragment,h),L=!0)},o(h){g(B.$$.fragment,h),g(J.$$.fragment,h),L=!1},d(h){h&&(t(a),t(o),t(r),t(i),t(d),t(G),t(W),t(x),t(Z),t(j),t(M),t(F),t(C)),v(B,h),v(J,h)}}}function mn(_){let a,f='Set up a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> and set <code>load_in_4bit=True</code> to load a model in 4-bit precision. The <a href="/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> is passed to the <code>quantization_config</code> parameter in <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>.',o,r,s="Allow Accelerate to automatically distribute the model across your available hardware by setting <code>device_map=“auto”</code>.",i,d,U="Place all inputs on the same device as the model.",G,W,R,x,B="For distributed setups, use the <code>max_memory</code> parameter to create a mapping of the amount of memory to allocate to each GPU. The example below distributes 16GB of memory to the first GPU and 16GB of memory to the second GPU.",Z,j,H;return W=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl80Yml0JTNEVHJ1ZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04QiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySGVsbG8lMkMlMjBteSUyMGxsYW1hJTIwaXMlMjBjdXRlJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsXzhiaXQuZGV2aWNlKSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbF84Yml0LmdlbmVyYXRlKCoqaW5wdXRzKSUwQW91dHB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig, AutoTokenizer, AutoModelForCausalLM

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer(<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=quantization_config)

prompt = <span class="hljs-string">&quot;Hello, my llama is cute&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model_8bit.device)
generated_ids = model_8bit.generate(**inputs)
outputs = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),j=new X({props:{code:"bWF4X21lbW9yeV9tYXBwaW5nJTIwJTNEJTIwJTdCMCUzQSUyMCUyMjE2R0IlMjIlMkMlMjAxJTNBJTIwJTIyMTZHQiUyMiU3RCUwQW1vZGVsXzRiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04QiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjBtYXhfbWVtb3J5JTNEbWF4X21lbW9yeV9tYXBwaW5nJTBBKQ==",highlighted:`max_memory_mapping = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>}
model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=quantization_config, max_memory=max_memory_mapping
)`,wrap:!1}}),{c(){a=u("p"),a.innerHTML=f,o=p(),r=u("p"),r.innerHTML=s,i=p(),d=u("p"),d.textContent=U,G=p(),y(W.$$.fragment),R=p(),x=u("p"),x.innerHTML=B,Z=p(),y(j.$$.fragment)},l(M){a=c(M,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1fz07sd"&&(a.innerHTML=f),o=m(M),r=c(M,"P",{"data-svelte-h":!0}),b(r)!=="svelte-1xbfxzy"&&(r.innerHTML=s),i=m(M),d=c(M,"P",{"data-svelte-h":!0}),b(d)!=="svelte-6y3wld"&&(d.textContent=U),G=m(M),$(W.$$.fragment,M),R=m(M),x=c(M,"P",{"data-svelte-h":!0}),b(x)!=="svelte-m5ityn"&&(x.innerHTML=B),Z=m(M),$(j.$$.fragment,M)},m(M,J){n(M,a,J),n(M,o,J),n(M,r,J),n(M,i,J),n(M,d,J),n(M,G,J),w(W,M,J),n(M,R,J),n(M,x,J),n(M,Z,J),w(j,M,J),H=!0},p:q,i(M){H||(T(W.$$.fragment,M),T(j.$$.fragment,M),H=!0)},o(M){g(W.$$.fragment,M),g(j.$$.fragment,M),H=!1},d(M){M&&(t(a),t(o),t(r),t(i),t(d),t(G),t(R),t(x),t(Z)),v(W,M),v(j,M)}}}function fn(_){let a,f,o,r;return a=new Y({props:{id:"bnb",option:"8-bit",$$slots:{default:[pn]},$$scope:{ctx:_}}}),o=new Y({props:{id:"bnb",option:"4-bit",$$slots:{default:[mn]},$$scope:{ctx:_}}}),{c(){y(a.$$.fragment),f=p(),y(o.$$.fragment)},l(s){$(a.$$.fragment,s),f=m(s),$(o.$$.fragment,s)},m(s,i){w(a,s,i),n(s,f,i),w(o,s,i),r=!0},p(s,i){const d={};i&2&&(d.$$scope={dirty:i,ctx:s}),a.$set(d);const U={};i&2&&(U.$$scope={dirty:i,ctx:s}),o.$set(U)},i(s){r||(T(a.$$.fragment,s),T(o.$$.fragment,s),r=!0)},o(s){g(a.$$.fragment,s),g(o.$$.fragment,s),r=!1},d(s){s&&t(f),v(a,s),v(o,s)}}}function dn(_){let a,f='Some BetterTransformer features are being upstreamed to Transformers with default support for native <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.nn.functional.scaled_dot_product_attention</a> (SDPA). BetterTransformer has a wider coverage than the Transformers SDPA integration, but you can expect more and more architectures to natively support SDPA in Transformers.';return{c(){a=u("p"),a.innerHTML=f},l(o){a=c(o,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1kg7smu"&&(a.innerHTML=f)},m(o,r){n(o,a,r)},p:q,d(o){o&&t(a)}}}function un(_){let a,f;return a=new X({props:{code:"cGlwJTIwaW5zdGFsbCUyMGZsYXNoLWF0dG4lMjAtLW5vLWJ1aWxkLWlzb2xhdGlvbg==",highlighted:"pip install flash-attn --no-build-isolation",wrap:!1}}),{c(){y(a.$$.fragment)},l(o){$(a.$$.fragment,o)},m(o,r){w(a,o,r),f=!0},p:q,i(o){f||(T(a.$$.fragment,o),f=!0)},o(o){g(a.$$.fragment,o),f=!1},d(o){v(a,o)}}}function cn(_){let a,f='FlashAttention2 support is currently limited to Instinct MI210, Instinct MI250 and Instinct MI300. We strongly suggest running this <a href="https://github.com/huggingface/optimum-amd/tree/main/docker/transformers-pytorch-amd-gpu-flash/Dockerfile" rel="nofollow">Dockerfile</a> for FlashAttention2 on AMD GPUs.';return{c(){a=u("p"),a.innerHTML=f},l(o){a=c(o,"P",{"data-svelte-h":!0}),b(a)!=="svelte-4y1e8d"&&(a.innerHTML=f)},m(o,r){n(o,a,r)},p:q,d(o){o&&t(a)}}}function hn(_){let a,f,o,r;return a=new Y({props:{id:"install",option:"NVIDIA",$$slots:{default:[un]},$$scope:{ctx:_}}}),o=new Y({props:{id:"install",option:"AMD",$$slots:{default:[cn]},$$scope:{ctx:_}}}),{c(){y(a.$$.fragment),f=p(),y(o.$$.fragment)},l(s){$(a.$$.fragment,s),f=m(s),$(o.$$.fragment,s)},m(s,i){w(a,s,i),n(s,f,i),w(o,s,i),r=!0},p(s,i){const d={};i&2&&(d.$$scope={dirty:i,ctx:s}),a.$set(d);const U={};i&2&&(U.$$scope={dirty:i,ctx:s}),o.$set(U)},i(s){r||(T(a.$$.fragment,s),T(o.$$.fragment,s),r=!0)},o(s){g(a.$$.fragment,s),g(o.$$.fragment,s),r=!1},d(s){s&&t(f),v(a,s),v(o,s)}}}function bn(_){let a,f='With a relatively small sequence length, a single forward pass creates overhead leading to a small speed up. The graph below shows the expected speed up for a single forward pass with <a href="https://hf.co/meta-llama/Llama-7b-hf" rel="nofollow">meta-llama/Llama-7b-hf</a> with padding.',o,r,s='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/llama-2-small-seqlen-padding.png"/>';return{c(){a=u("p"),a.innerHTML=f,o=p(),r=u("div"),r.innerHTML=s,this.h()},l(i){a=c(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1c98iqw"&&(a.innerHTML=f),o=m(i),r=c(i,"DIV",{class:!0,"data-svelte-h":!0}),b(r)!=="svelte-yereht"&&(r.innerHTML=s),this.h()},h(){Ge(r,"class","flex justify-center")},m(i,d){n(i,a,d),n(i,o,d),n(i,r,d)},p:q,d(i){i&&(t(a),t(o),t(r))}}}function Mn(_){let a,f='You can train on much longer sequence lengths without running into out-of-memory issues with FlashAttention2, and potentially reduce memory usage up to 20x. The speed up benefits are even better. The graph below shows the expected speed up for a single forward pass with <a href="https://hf.co/meta-llama/Llama-7b-hf" rel="nofollow">meta-llama/Llama-7b-hf</a> with padding on a longer sequence length.',o,r,s='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/llama-2-large-seqlen-padding.png"/>';return{c(){a=u("p"),a.innerHTML=f,o=p(),r=u("div"),r.innerHTML=s,this.h()},l(i){a=c(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1n0ltv3"&&(a.innerHTML=f),o=m(i),r=c(i,"DIV",{class:!0,"data-svelte-h":!0}),b(r)!=="svelte-1gms3ep"&&(r.innerHTML=s),this.h()},h(){Ge(r,"class","flex justify-center")},m(i,d){n(i,a,d),n(i,o,d),n(i,r,d)},p:q,d(i){i&&(t(a),t(o),t(r))}}}function yn(_){let a,f,o,r;return a=new Y({props:{id:"padded",option:"short sequence length",$$slots:{default:[bn]},$$scope:{ctx:_}}}),o=new Y({props:{id:"padded",option:"long sequence length",$$slots:{default:[Mn]},$$scope:{ctx:_}}}),{c(){y(a.$$.fragment),f=p(),y(o.$$.fragment)},l(s){$(a.$$.fragment,s),f=m(s),$(o.$$.fragment,s)},m(s,i){w(a,s,i),n(s,f,i),w(o,s,i),r=!0},p(s,i){const d={};i&2&&(d.$$scope={dirty:i,ctx:s}),a.$set(d);const U={};i&2&&(U.$$scope={dirty:i,ctx:s}),o.$set(U)},i(s){r||(T(a.$$.fragment,s),T(o.$$.fragment,s),r=!0)},o(s){g(a.$$.fragment,s),g(o.$$.fragment,s),r=!1},d(s){s&&t(f),v(a,s),v(o,s)}}}function $n(_){let a,f='The graph below shows the expected speed up for a single forward pass with <a href="https://hf.co/tiiuae/falcon-7b" rel="nofollow">tiiuae/falcon-7b</a> with a sequence length of 4096 and various batch sizes without padding tokens.',o,r,s='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/falcon-7b-inference-large-seqlen.png"/>';return{c(){a=u("p"),a.innerHTML=f,o=p(),r=u("div"),r.innerHTML=s,this.h()},l(i){a=c(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1dnv8z"&&(a.innerHTML=f),o=m(i),r=c(i,"DIV",{class:!0,"data-svelte-h":!0}),b(r)!=="svelte-s5vof8"&&(r.innerHTML=s),this.h()},h(){Ge(r,"class","flex justify-center")},m(i,d){n(i,a,d),n(i,o,d),n(i,r,d)},p:q,d(i){i&&(t(a),t(o),t(r))}}}function wn(_){let a,f='The graph below shows the expected speed up for a single forward pass with <a href="https://hf.co/meta-llama/Llama-7b-hf" rel="nofollow">meta-llama/Llama-7b-hf</a> with a sequence length of 4096 and various batch sizes without padding tokens.',o,r,s='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/llama-7b-inference-large-seqlen.png"/>';return{c(){a=u("p"),a.innerHTML=f,o=p(),r=u("div"),r.innerHTML=s,this.h()},l(i){a=c(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-b835g7"&&(a.innerHTML=f),o=m(i),r=c(i,"DIV",{class:!0,"data-svelte-h":!0}),b(r)!=="svelte-8cq7gw"&&(r.innerHTML=s),this.h()},h(){Ge(r,"class","flex justify-center")},m(i,d){n(i,a,d),n(i,o,d),n(i,r,d)},p:q,d(i){i&&(t(a),t(o),t(r))}}}function Tn(_){let a,f,o,r;return a=new Y({props:{id:"not-padded",option:"tiiuae/falcon-7b",$$slots:{default:[$n]},$$scope:{ctx:_}}}),o=new Y({props:{id:"not-padded",option:"meta-llama/Llama-7b-hf",$$slots:{default:[wn]},$$scope:{ctx:_}}}),{c(){y(a.$$.fragment),f=p(),y(o.$$.fragment)},l(s){$(a.$$.fragment,s),f=m(s),$(o.$$.fragment,s)},m(s,i){w(a,s,i),n(s,f,i),w(o,s,i),r=!0},p(s,i){const d={};i&2&&(d.$$scope={dirty:i,ctx:s}),a.$set(d);const U={};i&2&&(U.$$scope={dirty:i,ctx:s}),o.$set(U)},i(s){r||(T(a.$$.fragment,s),T(o.$$.fragment,s),r=!0)},o(s){g(a.$$.fragment,s),g(o.$$.fragment,s),r=!1},d(s){s&&t(f),v(a,s),v(o,s)}}}function gn(_){let a,f,o,r,s,i,d,U="GPUs are the standard hardware for machine learning because they’re optimized for memory bandwidth and parallelism. With the increasing sizes of modern models, it’s more important than ever to make sure GPUs are capable of efficiently handling and delivering the best possible performance.",G,W,R="This guide will demonstrate a few ways to optimize inference on a GPU. The optimization methods shown below can be combined with each other to achieve even better performance, and they also work for distributed GPUs.",x,B,Z,j,H='<a href="https://hf.co/docs/bitsandbytes/index" rel="nofollow">bitsandbytes</a> is a quantization library that supports 8-bit and 4-bit quantization. Quantization represents weights in a lower precision compared to the original full precision format. It reduces memory requirements and makes it easier to fit large model into memory.',M,J,F="Make sure bitsandbytes and Accelerate are installed first.",C,I,L,h,k,P,Xe,N,_t='<a href="https://hf.co/docs/optimum/en/index" rel="nofollow">Optimum</a> is a Hugging Face library focused on optimizing model performance across various hardware. It supports <a href="https://onnxruntime.ai/docs/" rel="nofollow">ONNX Runtime</a> (ORT), a model accelerator, for a wide range of hardware and frameworks including NVIDIA GPUs and AMD GPUs that use the <a href="https://www.amd.com/en/products/software/rocm.html" rel="nofollow">ROCm</a> stack.',Ce,S,Jt="ORT uses optimization techniques that fuse common operations into a single node and constant folding to reduce the number of computations. ORT also places the most computationally intensive operations on the GPU and the rest on the CPU to intelligently distribute the workload between the two devices.",Re,E,Wt='Optimum provides the <a href="https://huggingface.co/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel" rel="nofollow">ORTModel</a> class for loading ONNX models. Set the <code>provider</code> parameter according to the table below.',He,D,jt='<thead><tr><th>provider</th> <th>hardware</th></tr></thead> <tbody><tr><td><a href="https://hf.co/docs/optimum/main/en/onnxruntime/usage_guides/gpu#cudaexecutionprovider" rel="nofollow">CUDAExecutionProvider</a></td> <td>CUDA-enabled GPUs</td></tr> <tr><td><a href="https://hf.co/docs/optimum/onnxruntime/usage_guides/amdgpu" rel="nofollow">ROCMExecutionProvider</a></td> <td>AMD Instinct, Radeon Pro, Radeon GPUs</td></tr> <tr><td><a href="https://hf.co/docs/optimum/onnxruntime/usage_guides/gpu#tensorrtexecutionprovider" rel="nofollow">TensorrtExecutionProvider</a></td> <td>TensorRT</td></tr></tbody>',Ie,K,Ut='For example, load the <a href="https://hf.co/optimum/roberta-base-squad2" rel="nofollow">distilbert/distilbert-base-uncased-finetuned-sst-2-english</a> checkpoint for sequence classification. This checkpoint contains a <a href="https://hf.co/distilbert/distilbert-base-uncased-finetuned-sst-2-english/blob/main/onnx/model.onnx" rel="nofollow">model.onnx</a> file. If a checkpoint doesn’t have a <code>model.onnx</code> file, set <code>export=True</code> to convert a checkpoint on the fly to the ONNX format.',Le,O,qe,ee,kt='Now you can use the model for inference in a <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.',Ve,te,ze,ne,Bt='Learn more details about using ORT with Optimum in the <a href="https://hf.co/docs/optimum/onnxruntime/usage_guides/gpu#accelerated-inference-on-nvidia-gpus" rel="nofollow">Accelerated inference on NVIDIA GPUs</a> and <a href="https://hf.co/docs/optimum/onnxruntime/usage_guides/amdgpu#accelerated-inference-on-amd-gpus" rel="nofollow">Accelerated inference on AMD GPUs</a> guides.',Qe,le,Ae,ae,xt='<a href="https://pytorch.org/blog/a-better-transformer-for-fast-transformer-encoder-inference/" rel="nofollow">BetterTransformer</a> is a <em>fastpath</em> execution of specialized Transformers functions directly on the hardware level such as a GPU. There are two main components of the fastpath execution.',Ye,se,Gt="<li>fusing multiple operations into a single kernel for faster and more efficient execution</li> <li>skipping unnecessary computation of padding tokens with nested tensors</li>",Fe,V,Pe,oe,Zt='BetterTransformer is available through Optimum with <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.to_bettertransformer">to_bettertransformer()</a>.',Ne,ie,Se,re,Xt='Call <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.reverse_bettertransformer">reverse_bettertransformer()</a> and save it first to return the model to the original Transformers model.',Ee,pe,De,me,Ct='Refer to the benchmarks in <a href="https://pytorch.org/blog/out-of-the-box-acceleration/" rel="nofollow">Out of the box acceleration and memory savings of 🤗 decoder models with PyTorch 2.0</a> for BetterTransformer and scaled dot product attention performance. The <a href="https://medium.com/pytorch/bettertransformer-out-of-the-box-performance-for-huggingface-transformers-3fbe27d50ab2" rel="nofollow">BetterTransformer</a> blog post also discusses fastpath execution in greater detail if you’re interested in learning more.',Ke,fe,Oe,de,Rt='PyTorch’s <a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.nn.functional.scaled_dot_product_attention</a> (SDPA) is a native implementation of the scaled dot product attention mechanism. SDPA is a more efficient and optimized version of the attention mechanism used in transformer models.',et,ue,Ht="There are three supported implementations available.",tt,ce,It='<li><a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention2</a> only supports models with the fp16 or bf16 torch type. Make sure to cast your model to the appropriate type first.</li> <li><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xFormers</a> or Memory-Efficient Attention is able to support models with the fp32 torch type.</li> <li>C++ implementation of scaled dot product attention</li>',nt,he,Lt='SDPA is used by default for PyTorch v2.1.1. and greater when an implementation is available. You could explicitly enable SDPA by setting <code>attn_implementation=&quot;sdpa&quot;</code> in <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> though. Certain attention parameters, such as <code>head_mask</code> and <code>output_attentions=True</code>, are unsupported and returns a warning that Transformers will fall back to the (slower) eager implementation.',lt,be,at,Me,qt='SDPA selects the most performant implementation available, but you can also explicitly select an implementation with <a href="https://pytorch.org/docs/master/backends.html#torch.backends.cuda.sdp_kernel" rel="nofollow">torch.nn.attention.sdpa_kernel</a> as a context manager. The example below shows how to enable the FlashAttention2 implementation with <code>enable_flash=True</code>.',st,ye,ot,$e,Vt="If you encounter the following <code>RuntimeError</code>, try installing the nightly version of PyTorch which has broader coverage for FlashAttention.",it,we,rt,Te,pt,ge,zt='<a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a> is also available as a standalone package. It can significantly speed up inference by:',mt,ve,Qt="<li>additionally parallelizing the attention computation over sequence length</li> <li>partitioning the work between GPU threads to reduce communication and shared memory reads/writes between them</li>",ft,_e,At="Install FlashAttention first for the hardware you’re using.",dt,z,ut,Je,Yt='Enable FlashAttention2 by setting <code>attn_implementation=&quot;flash_attention_2&quot;</code> in <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>. FlashAttention2 is only supported for models with the fp16 or bf16 torch type. Make sure to cast your model to the appropriate data type first.',ct,We,ht,je,bt,Ue,Ft="FlashAttention2 speeds up inference considerably especially for inputs with long sequences. However, since FlashAttention2 doesn’t support computing attention scores with padding tokens, you must manually pad and unpad the attention scores for batched inference if a sequence contains padding tokens. The downside is batched generation is slower with padding tokens.",Mt,Q,yt,ke,Pt="To avoid this slowdown, use FlashAttention2 without padding tokens in the sequence during training. Pack the dataset or concatenate sequences until reaching the maximum sequence length.",$t,A,wt,Be,Tt,Ze,gt;return s=new xe({props:{title:"GPU",local:"gpu",headingTag:"h1"}}),B=new xe({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h2"}}),I=new X({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcyUyMGFjY2VsZXJhdGU=",highlighted:"pip install bitsandbytes accelerate",wrap:!1}}),h=new vt({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[fn]},$$scope:{ctx:_}}}),P=new xe({props:{title:"Optimum",local:"optimum",headingTag:"h2"}}),O=new X({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUyQyUwQSUyMCUyMCUyM2V4cG9ydCUzRFRydWUlMkMlMEElMjAlMjBwcm92aWRlciUzRCUyMkNVREFFeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

ort_model = ORTModelForSequenceClassification.from_pretrained(
  <span class="hljs-string">&quot;distilbert/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
  <span class="hljs-comment">#export=True,</span>
  provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
)`,wrap:!1}}),te=new X({props:{code:"ZnJvbSUyMG9wdGltdW0ucGlwZWxpbmVzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0RvcnRfbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTNBMCUyMiklMEFyZXN1bHQlMjAlM0QlMjBwaXBlbGluZSglMjJCb3RoJTIwdGhlJTIwbXVzaWMlMjBhbmQlMjB2aXN1YWwlMjB3ZXJlJTIwYXN0b3VuZGluZyUyQyUyMG5vdCUyMHRvJTIwbWVudGlvbiUyMHRoZSUyMGFjdG9ycyUyMHBlcmZvcm1hbmNlLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
pipeline = pipeline(task=<span class="hljs-string">&quot;text-classification&quot;</span>, model=ort_model, tokenizer=tokenizer, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
result = pipeline(<span class="hljs-string">&quot;Both the music and visual were astounding, not to mention the actors performance.&quot;</span>)`,wrap:!1}}),le=new xe({props:{title:"BetterTransformer",local:"bettertransformer",headingTag:"h3"}}),V=new on({props:{warning:!0,$$slots:{default:[dn]},$$scope:{ctx:_}}}),ie=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tJTIyKSUwQW1vZGVsJTIwJTNEJTIwbW9kZWwudG9fYmV0dGVydHJhbnNmb3JtZXIoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>)
model = model.to_bettertransformer()`,wrap:!1}}),pe=new X({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC5yZXZlcnNlX2JldHRlcnRyYW5zZm9ybWVyKCklMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyc2F2ZWRfbW9kZWwlMjIp",highlighted:`model = model.reverse_bettertransformer()
model.save_pretrained(<span class="hljs-string">&quot;saved_model&quot;</span>)`,wrap:!1}}),fe=new xe({props:{title:"Scaled dot product attention (SDPA)",local:"scaled-dot-product-attention-sdpa",headingTag:"h2"}}),be=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04QiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>)`,wrap:!1}}),ye=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gubm4uYXR0ZW50aW9uJTIwaW1wb3J0JTIwU0RQQmFja2VuZCUyQyUyMHNkcGFfa2VybmVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04QiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKS50byglMjJjdWRhJTIyKSUwQSUwQWlucHV0X3RleHQlMjAlM0QlMjAlMjJIZWxsbyUyQyUyMG15JTIwbGxhbWElMjBpcyUyMGN1dGUlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBd2l0aCUyMHNkcGFfa2VybmVsKFNEUEJhY2tlbmQuRkxBU0hfQVRURU5USU9OKSUzQSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEElMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

input_text = <span class="hljs-string">&quot;Hello, my llama is cute&quot;</span>
inputs = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.FLASH_ATTENTION)::
    outputs = model.generate(**inputs)

<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),we=new X({props:{code:"UnVudGltZUVycm9yJTNBJTIwTm8lMjBhdmFpbGFibGUlMjBrZXJuZWwuJTIwQWJvcnRpbmclMjBleGVjdXRpb24uJTBBJTBBcGlwMyUyMGluc3RhbGwlMjAtVSUyMC0tcHJlJTIwdG9yY2glMjB0b3JjaHZpc2lvbiUyMHRvcmNoYXVkaW8lMjAtLWluZGV4LXVybCUyMGh0dHBzJTNBJTJGJTJGZG93bmxvYWQucHl0b3JjaC5vcmclMkZ3aGwlMkZuaWdodGx5JTJGY3UxMTg=",highlighted:`RuntimeError: No available kernel. Aborting execution.

pip3 install -U --pre torch torchvision torchaudio --index-url https://download.pytorch.org/whl/nightly/cu118`,wrap:!1}}),Te=new xe({props:{title:"FlashAttention",local:"flashattention",headingTag:"h2"}}),z=new vt({props:{id:"install",options:["NVIDIA","AMD"],$$slots:{default:[hn]},$$scope:{ctx:_}}}),We=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04QiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>)`,wrap:!1}}),je=new xe({props:{title:"Benchmarks",local:"benchmarks",headingTag:"h3"}}),Q=new vt({props:{id:"padded",options:["short sequence length","long sequence length"],$$slots:{default:[yn]},$$scope:{ctx:_}}}),A=new vt({props:{id:"not-padded",options:["tiiuae/falcon-7b","meta-llama/Llama-7b-hf"],$$slots:{default:[Tn]},$$scope:{ctx:_}}}),Be=new rn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/perf_infer_gpu_one.md"}}),{c(){a=u("meta"),f=p(),o=u("p"),r=p(),y(s.$$.fragment),i=p(),d=u("p"),d.textContent=U,G=p(),W=u("p"),W.textContent=R,x=p(),y(B.$$.fragment),Z=p(),j=u("p"),j.innerHTML=H,M=p(),J=u("p"),J.textContent=F,C=p(),y(I.$$.fragment),L=p(),y(h.$$.fragment),k=p(),y(P.$$.fragment),Xe=p(),N=u("p"),N.innerHTML=_t,Ce=p(),S=u("p"),S.textContent=Jt,Re=p(),E=u("p"),E.innerHTML=Wt,He=p(),D=u("table"),D.innerHTML=jt,Ie=p(),K=u("p"),K.innerHTML=Ut,Le=p(),y(O.$$.fragment),qe=p(),ee=u("p"),ee.innerHTML=kt,Ve=p(),y(te.$$.fragment),ze=p(),ne=u("p"),ne.innerHTML=Bt,Qe=p(),y(le.$$.fragment),Ae=p(),ae=u("p"),ae.innerHTML=xt,Ye=p(),se=u("ul"),se.innerHTML=Gt,Fe=p(),y(V.$$.fragment),Pe=p(),oe=u("p"),oe.innerHTML=Zt,Ne=p(),y(ie.$$.fragment),Se=p(),re=u("p"),re.innerHTML=Xt,Ee=p(),y(pe.$$.fragment),De=p(),me=u("p"),me.innerHTML=Ct,Ke=p(),y(fe.$$.fragment),Oe=p(),de=u("p"),de.innerHTML=Rt,et=p(),ue=u("p"),ue.textContent=Ht,tt=p(),ce=u("ul"),ce.innerHTML=It,nt=p(),he=u("p"),he.innerHTML=Lt,lt=p(),y(be.$$.fragment),at=p(),Me=u("p"),Me.innerHTML=qt,st=p(),y(ye.$$.fragment),ot=p(),$e=u("p"),$e.innerHTML=Vt,it=p(),y(we.$$.fragment),rt=p(),y(Te.$$.fragment),pt=p(),ge=u("p"),ge.innerHTML=zt,mt=p(),ve=u("ol"),ve.innerHTML=Qt,ft=p(),_e=u("p"),_e.textContent=At,dt=p(),y(z.$$.fragment),ut=p(),Je=u("p"),Je.innerHTML=Yt,ct=p(),y(We.$$.fragment),ht=p(),y(je.$$.fragment),bt=p(),Ue=u("p"),Ue.textContent=Ft,Mt=p(),y(Q.$$.fragment),yt=p(),ke=u("p"),ke.textContent=Pt,$t=p(),y(A.$$.fragment),wt=p(),y(Be.$$.fragment),Tt=p(),Ze=u("p"),this.h()},l(e){const l=an("svelte-u9bgzb",document.head);a=c(l,"META",{name:!0,content:!0}),l.forEach(t),f=m(e),o=c(e,"P",{}),Ot(o).forEach(t),r=m(e),$(s.$$.fragment,e),i=m(e),d=c(e,"P",{"data-svelte-h":!0}),b(d)!=="svelte-1fwjvck"&&(d.textContent=U),G=m(e),W=c(e,"P",{"data-svelte-h":!0}),b(W)!=="svelte-1abs0sh"&&(W.textContent=R),x=m(e),$(B.$$.fragment,e),Z=m(e),j=c(e,"P",{"data-svelte-h":!0}),b(j)!=="svelte-1n5togo"&&(j.innerHTML=H),M=m(e),J=c(e,"P",{"data-svelte-h":!0}),b(J)!=="svelte-1b4ixl9"&&(J.textContent=F),C=m(e),$(I.$$.fragment,e),L=m(e),$(h.$$.fragment,e),k=m(e),$(P.$$.fragment,e),Xe=m(e),N=c(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-1p718jw"&&(N.innerHTML=_t),Ce=m(e),S=c(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-pvrbx"&&(S.textContent=Jt),Re=m(e),E=c(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-1kel40v"&&(E.innerHTML=Wt),He=m(e),D=c(e,"TABLE",{"data-svelte-h":!0}),b(D)!=="svelte-1wm1a3t"&&(D.innerHTML=jt),Ie=m(e),K=c(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-1pvihnl"&&(K.innerHTML=Ut),Le=m(e),$(O.$$.fragment,e),qe=m(e),ee=c(e,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-1bmczlo"&&(ee.innerHTML=kt),Ve=m(e),$(te.$$.fragment,e),ze=m(e),ne=c(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-tp1950"&&(ne.innerHTML=Bt),Qe=m(e),$(le.$$.fragment,e),Ae=m(e),ae=c(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-12f67in"&&(ae.innerHTML=xt),Ye=m(e),se=c(e,"UL",{"data-svelte-h":!0}),b(se)!=="svelte-1duvg1i"&&(se.innerHTML=Gt),Fe=m(e),$(V.$$.fragment,e),Pe=m(e),oe=c(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-1lkshuc"&&(oe.innerHTML=Zt),Ne=m(e),$(ie.$$.fragment,e),Se=m(e),re=c(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-1cec7qa"&&(re.innerHTML=Xt),Ee=m(e),$(pe.$$.fragment,e),De=m(e),me=c(e,"P",{"data-svelte-h":!0}),b(me)!=="svelte-agxk5z"&&(me.innerHTML=Ct),Ke=m(e),$(fe.$$.fragment,e),Oe=m(e),de=c(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-1vc1lf7"&&(de.innerHTML=Rt),et=m(e),ue=c(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-1wn2wyw"&&(ue.textContent=Ht),tt=m(e),ce=c(e,"UL",{"data-svelte-h":!0}),b(ce)!=="svelte-n7w2td"&&(ce.innerHTML=It),nt=m(e),he=c(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-1tbzsti"&&(he.innerHTML=Lt),lt=m(e),$(be.$$.fragment,e),at=m(e),Me=c(e,"P",{"data-svelte-h":!0}),b(Me)!=="svelte-1kdwdpa"&&(Me.innerHTML=qt),st=m(e),$(ye.$$.fragment,e),ot=m(e),$e=c(e,"P",{"data-svelte-h":!0}),b($e)!=="svelte-1r8c7l7"&&($e.innerHTML=Vt),it=m(e),$(we.$$.fragment,e),rt=m(e),$(Te.$$.fragment,e),pt=m(e),ge=c(e,"P",{"data-svelte-h":!0}),b(ge)!=="svelte-1a1ytd4"&&(ge.innerHTML=zt),mt=m(e),ve=c(e,"OL",{"data-svelte-h":!0}),b(ve)!=="svelte-1t56p9w"&&(ve.innerHTML=Qt),ft=m(e),_e=c(e,"P",{"data-svelte-h":!0}),b(_e)!=="svelte-1b1vtgy"&&(_e.textContent=At),dt=m(e),$(z.$$.fragment,e),ut=m(e),Je=c(e,"P",{"data-svelte-h":!0}),b(Je)!=="svelte-54tmze"&&(Je.innerHTML=Yt),ct=m(e),$(We.$$.fragment,e),ht=m(e),$(je.$$.fragment,e),bt=m(e),Ue=c(e,"P",{"data-svelte-h":!0}),b(Ue)!=="svelte-1dcldcy"&&(Ue.textContent=Ft),Mt=m(e),$(Q.$$.fragment,e),yt=m(e),ke=c(e,"P",{"data-svelte-h":!0}),b(ke)!=="svelte-ox9wk"&&(ke.textContent=Pt),$t=m(e),$(A.$$.fragment,e),wt=m(e),$(Be.$$.fragment,e),Tt=m(e),Ze=c(e,"P",{}),Ot(Ze).forEach(t),this.h()},h(){Ge(a,"name","hf:doc:metadata"),Ge(a,"content",vn)},m(e,l){sn(document.head,a),n(e,f,l),n(e,o,l),n(e,r,l),w(s,e,l),n(e,i,l),n(e,d,l),n(e,G,l),n(e,W,l),n(e,x,l),w(B,e,l),n(e,Z,l),n(e,j,l),n(e,M,l),n(e,J,l),n(e,C,l),w(I,e,l),n(e,L,l),w(h,e,l),n(e,k,l),w(P,e,l),n(e,Xe,l),n(e,N,l),n(e,Ce,l),n(e,S,l),n(e,Re,l),n(e,E,l),n(e,He,l),n(e,D,l),n(e,Ie,l),n(e,K,l),n(e,Le,l),w(O,e,l),n(e,qe,l),n(e,ee,l),n(e,Ve,l),w(te,e,l),n(e,ze,l),n(e,ne,l),n(e,Qe,l),w(le,e,l),n(e,Ae,l),n(e,ae,l),n(e,Ye,l),n(e,se,l),n(e,Fe,l),w(V,e,l),n(e,Pe,l),n(e,oe,l),n(e,Ne,l),w(ie,e,l),n(e,Se,l),n(e,re,l),n(e,Ee,l),w(pe,e,l),n(e,De,l),n(e,me,l),n(e,Ke,l),w(fe,e,l),n(e,Oe,l),n(e,de,l),n(e,et,l),n(e,ue,l),n(e,tt,l),n(e,ce,l),n(e,nt,l),n(e,he,l),n(e,lt,l),w(be,e,l),n(e,at,l),n(e,Me,l),n(e,st,l),w(ye,e,l),n(e,ot,l),n(e,$e,l),n(e,it,l),w(we,e,l),n(e,rt,l),w(Te,e,l),n(e,pt,l),n(e,ge,l),n(e,mt,l),n(e,ve,l),n(e,ft,l),n(e,_e,l),n(e,dt,l),w(z,e,l),n(e,ut,l),n(e,Je,l),n(e,ct,l),w(We,e,l),n(e,ht,l),w(je,e,l),n(e,bt,l),n(e,Ue,l),n(e,Mt,l),w(Q,e,l),n(e,yt,l),n(e,ke,l),n(e,$t,l),w(A,e,l),n(e,wt,l),w(Be,e,l),n(e,Tt,l),n(e,Ze,l),gt=!0},p(e,[l]){const Nt={};l&2&&(Nt.$$scope={dirty:l,ctx:e}),h.$set(Nt);const St={};l&2&&(St.$$scope={dirty:l,ctx:e}),V.$set(St);const Et={};l&2&&(Et.$$scope={dirty:l,ctx:e}),z.$set(Et);const Dt={};l&2&&(Dt.$$scope={dirty:l,ctx:e}),Q.$set(Dt);const Kt={};l&2&&(Kt.$$scope={dirty:l,ctx:e}),A.$set(Kt)},i(e){gt||(T(s.$$.fragment,e),T(B.$$.fragment,e),T(I.$$.fragment,e),T(h.$$.fragment,e),T(P.$$.fragment,e),T(O.$$.fragment,e),T(te.$$.fragment,e),T(le.$$.fragment,e),T(V.$$.fragment,e),T(ie.$$.fragment,e),T(pe.$$.fragment,e),T(fe.$$.fragment,e),T(be.$$.fragment,e),T(ye.$$.fragment,e),T(we.$$.fragment,e),T(Te.$$.fragment,e),T(z.$$.fragment,e),T(We.$$.fragment,e),T(je.$$.fragment,e),T(Q.$$.fragment,e),T(A.$$.fragment,e),T(Be.$$.fragment,e),gt=!0)},o(e){g(s.$$.fragment,e),g(B.$$.fragment,e),g(I.$$.fragment,e),g(h.$$.fragment,e),g(P.$$.fragment,e),g(O.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(V.$$.fragment,e),g(ie.$$.fragment,e),g(pe.$$.fragment,e),g(fe.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(z.$$.fragment,e),g(We.$$.fragment,e),g(je.$$.fragment,e),g(Q.$$.fragment,e),g(A.$$.fragment,e),g(Be.$$.fragment,e),gt=!1},d(e){e&&(t(f),t(o),t(r),t(i),t(d),t(G),t(W),t(x),t(Z),t(j),t(M),t(J),t(C),t(L),t(k),t(Xe),t(N),t(Ce),t(S),t(Re),t(E),t(He),t(D),t(Ie),t(K),t(Le),t(qe),t(ee),t(Ve),t(ze),t(ne),t(Qe),t(Ae),t(ae),t(Ye),t(se),t(Fe),t(Pe),t(oe),t(Ne),t(Se),t(re),t(Ee),t(De),t(me),t(Ke),t(Oe),t(de),t(et),t(ue),t(tt),t(ce),t(nt),t(he),t(lt),t(at),t(Me),t(st),t(ot),t($e),t(it),t(rt),t(pt),t(ge),t(mt),t(ve),t(ft),t(_e),t(dt),t(ut),t(Je),t(ct),t(ht),t(bt),t(Ue),t(Mt),t(yt),t(ke),t($t),t(wt),t(Tt),t(Ze)),t(a),v(s,e),v(B,e),v(I,e),v(h,e),v(P,e),v(O,e),v(te,e),v(le,e),v(V,e),v(ie,e),v(pe,e),v(fe,e),v(be,e),v(ye,e),v(we,e),v(Te,e),v(z,e),v(We,e),v(je,e),v(Q,e),v(A,e),v(Be,e)}}}const vn='{"title":"GPU","local":"gpu","sections":[{"title":"bitsandbytes","local":"bitsandbytes","sections":[],"depth":2},{"title":"Optimum","local":"optimum","sections":[{"title":"BetterTransformer","local":"bettertransformer","sections":[],"depth":3}],"depth":2},{"title":"Scaled dot product attention (SDPA)","local":"scaled-dot-product-attention-sdpa","sections":[],"depth":2},{"title":"FlashAttention","local":"flashattention","sections":[{"title":"Benchmarks","local":"benchmarks","sections":[],"depth":3}],"depth":2}],"depth":1}';function _n(_){return tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gn extends nn{constructor(a){super(),ln(this,a,_n,gn,en,{})}}export{Gn as component};
