import{s as Bl,n as Fl,o as vl}from"../chunks/scheduler.bdbef820.js";import{S as Wl,i as Sl,g as M,s as a,r as m,A as Nl,h as p,f as e,c as n,j as $l,u as y,x as i,k as d,y as zl,a as t,v as U,d as J,t as c,w as r}from"../chunks/index.33f81d56.js";import{C as j}from"../chunks/CodeBlock.3bad7fc9.js";import{H as ys,E as Vl}from"../chunks/index.e01163b6.js";function El(al){let u,Us,is,Js,f,cs,g,nl=`마스크 생성(Mask generation)은 이미지에 대한 의미 있는 마스크를 생성하는 작업입니다.
이 작업은 <a href="semantic_segmentation">이미지 분할</a>과 매우 유사하지만, 많은 차이점이 있습니다. 이미지 분할 모델은 라벨이 달린 데이터셋으로 학습되며, 학습 중에 본 클래스들로만 제한됩니다. 이미지가 주어지면, 이미지 분할 모델은 여러 마스크와 그에 해당하는 클래스를 반환합니다.`,rs,k,Ml="반면, 마스크 생성 모델은 대량의 데이터로 학습되며 두 가지 모드로 작동합니다.",js,Q,pl="<li>프롬프트 모드(Prompting mode): 이 모드에서는 모델이 이미지와 프롬프트를 입력받습니다. 프롬프트는 이미지 내 객체의 2D 좌표(XY 좌표)나 객체를 둘러싼 바운딩 박스가 될 수 있습니다. 프롬프트 모드에서는 모델이 프롬프트가 가리키는 객체의 마스크만 반환합니다.</li> <li>전체 분할 모드(Segment Everything mode): 이 모드에서는 주어진 이미지 내에서 모든 마스크를 생성합니다. 이를 위해 그리드 형태의 점들을 생성하고 이를 이미지에 오버레이하여 추론합니다.</li>",us,x,il='마스크 생성 작업은 <a href="model_doc/sam">전체 분할 모드(Segment Anything Model, SAM)</a>에 의해 지원됩니다. SAM은 Vision Transformer 기반 이미지 인코더, 프롬프트 인코더, 그리고 양방향 트랜스포머 마스크 디코더로 구성된 강력한 모델입니다. 이미지와 프롬프트는 인코딩되고, 디코더는 이러한 임베딩을 받아 유효한 마스크를 생성합니다.',Ts,T,ml='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sam.png" alt="SAM Architecture"/>',ws,Z,yl='SAM은 대규모 데이터를 다룰 수 있는 강력한 분할 기반 모델입니다. 이 모델은 100만 개의 이미지와 11억 개의 마스크를 포함하는 <a href="https://ai.meta.com/datasets/segment-anything/" rel="nofollow">SA-1B</a> 데이터 세트로 학습되었습니다.',os,I,Ul="이 가이드에서는 다음과 같은 내용을 배우게 됩니다:",hs,$,Jl="<li>배치 처리와 함께 전체 분할 모드에서 추론하는 방법</li> <li>포인트 프롬프팅 모드에서 추론하는 방법</li> <li>박스 프롬프팅 모드에서 추론하는 방법</li>",Cs,B,cl="먼저, <code>transformers</code>를 설치해 봅시다:",bs,F,ds,v,fs,W,rl="마스크 생성 모델로 추론하는 가장 쉬운 방법은 <code>mask-generation</code> 파이프라인을 사용하는 것입니다.",gs,S,ks,N,jl="이미지를 예시로 봅시다.",Qs,z,xs,w,ul='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="Example Image"/>',Zs,V,Tl="전체적으로 분할해봅시다. <code>points-per-batch</code>는 전체 분할 모드에서 점들의 병렬 추론을 가능하게 합니다. 이를 통해 추론 속도가 빨라지지만, 더 많은 메모리를 소모하게 됩니다. 또한, SAM은 이미지가 아닌 점들에 대해서만 배치 처리를 지원합니다. <code>pred_iou_thresh</code>는 IoU 신뢰 임계값으로, 이 임계값을 초과하는 마스크만 반환됩니다.",Is,E,$s,H,wl="<code>masks</code> 는 다음과 같이 생겼습니다:",Bs,A,Fs,G,ol="위 내용을 아래와 같이 시각화할 수 있습니다:",vs,X,Ws,Y,hl="아래는 회색조 원본 이미지에 다채로운 색상의 맵을 겹쳐놓은 모습입니다. 매우 인상적인 결과입니다.",Ss,o,Cl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee_segmented.png" alt="Visualized"/>',Ns,_,zs,R,Vs,L,bl="파이프라인 없이도 모델을 사용할 수 있습니다. 이를 위해 모델과 프로세서를 초기화해야 합니다.",Es,D,Hs,q,dl="포인트 프롬프팅을 하기 위해, 입력 포인트를 프로세서에 전달한 다음, 프로세서 출력을 받아 모델에 전달하여 추론합니다. 모델 출력을 후처리하려면, 출력과 함께 프로세서의 초기 출력에서 가져온 <code>original_sizes</code>와 <code>reshaped_input_sizes</code>를 전달해야 합니다. 왜냐하면, 프로세서가 이미지 크기를 조정하고 출력을 추정해야 하기 때문입니다.",As,K,Gs,P,fl="<code>masks</code> 출력으로 세 가지 마스크를 시각화할 수 있습니다.",Xs,O,Ys,h,gl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/masks.png" alt="Visualized"/>',_s,ss,Rs,ls,kl="박스 프롬프팅도 포인트 프롬프팅과 유사한 방식으로 할 수 있습니다. 입력 박스를 <code>[x_min, y_min, x_max, y_max]</code> 형식의 리스트로 작성하여 이미지와 함께 <code>processor</code>에 전달할 수 있습니다. 프로세서 출력을 받아 모델에 직접 전달한 후, 다시 출력을 후처리해야 합니다.",Ls,es,Ds,ts,Ql="이제 아래와 같이, 벌 주위의 바운딩 박스를 시각화할 수 있습니다.",qs,as,Ks,C,xl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/bbox.png" alt="Visualized Bbox"/>',Ps,ns,Zl="아래에서 추론 결과를 확인할 수 있습니다.",Os,Ms,sl,b,Il='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/box_inference.png" alt="Visualized Inference"/>',ll,ps,el,ms,tl;return f=new ys({props:{title:"마스크 생성",local:"mask-generation",headingTag:"h1"}}),F=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),v=new ys({props:{title:"마스크 생성 파이프라인",local:"mask-generation-pipeline",headingTag:"h2"}}),S=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGc2FtLXZpdC1iYXNlJTIyJTBBbWFza19nZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRGNoZWNrcG9pbnQlMkMlMjB0YXNrJTNEJTIybWFzay1nZW5lcmF0aW9uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_generator = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;mask-generation&quot;</span>)`,wrap:!1}}),z=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),E=new j({props:{code:"bWFza3MlMjAlM0QlMjBtYXNrX2dlbmVyYXRvcihpbWFnZSUyQyUyMHBvaW50c19wZXJfYmF0Y2glM0QxMjglMkMlMjBwcmVkX2lvdV90aHJlc2glM0QwLjg4KQ==",highlighted:'masks = mask_generator(image, points_per_batch=<span class="hljs-number">128</span>, pred_iou_thresh=<span class="hljs-number">0.88</span>)',wrap:!1}}),A=new j({props:{code:"JTdCJ21hc2tzJyUzQSUyMCU1QmFycmF5KCU1QiU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCU1RCklMkMlMEElMjAlMjBhcnJheSglNUIlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEEnc2NvcmVzJyUzQSUyMHRlbnNvciglNUIwLjk5NzIlMkMlMjAwLjk5MTclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElN0Q=",highlighted:`{<span class="hljs-string">&#x27;masks&#x27;</span>: [array([[False, False, False, ...,  True,  True,  True],
         [False, False, False, ...,  True,  True,  True],
         [False, False, False, ...,  True,  True,  True],
         ...,
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False]]),
  array([[False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         ...,
<span class="hljs-string">&#x27;scores&#x27;</span>: tensor([0.9972, 0.9917,
        ...,
}`,wrap:!1}}),X=new j({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5pbXNob3coaW1hZ2UlMkMlMjBjbWFwJTNEJ2dyYXknKSUwQSUwQWZvciUyMGklMkMlMjBtYXNrJTIwaW4lMjBlbnVtZXJhdGUobWFza3MlNUIlMjJtYXNrcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBwbHQuaW1zaG93KG1hc2slMkMlMjBjbWFwJTNEJ3ZpcmlkaXMnJTJDJTIwYWxwaGElM0QwLjElMkMlMjB2bWluJTNEMCUyQyUyMHZtYXglM0QxKSUwQSUwQXBsdC5heGlzKCdvZmYnKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.imshow(image, cmap=<span class="hljs-string">&#x27;gray&#x27;</span>)

<span class="hljs-keyword">for</span> i, mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(masks[<span class="hljs-string">&quot;masks&quot;</span>]):
    plt.imshow(mask, cmap=<span class="hljs-string">&#x27;viridis&#x27;</span>, alpha=<span class="hljs-number">0.1</span>, vmin=<span class="hljs-number">0</span>, vmax=<span class="hljs-number">1</span>)

plt.axis(<span class="hljs-string">&#x27;off&#x27;</span>)
plt.show()`,wrap:!1}}),_=new ys({props:{title:"모델 추론",local:"model-inference",headingTag:"h2"}}),R=new ys({props:{title:"포인트 프롬프팅",local:"point-prompting",headingTag:"h3"}}),D=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNhbU1vZGVsJTJDJTIwU2FtUHJvY2Vzc29yJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJ2N1ZGEnJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUnKSUwQSUwQW1vZGVsJTIwJTNEJTIwU2FtTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGc2FtLXZpdC1iYXNlJTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwU2FtUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnNhbS12aXQtYmFzZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel, SamProcessor
<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)

model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>).to(device)
processor = SamProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)`,wrap:!1}}),K=new j({props:{code:"aW5wdXRfcG9pbnRzJTIwJTNEJTIwJTVCJTVCJTVCMjU5MiUyQyUyMDE3MjglNUQlNUQlNUQlMjAlMjMlMjAlRUIlQjIlOEMlRUMlOUQlOTglMjAlRUQlOEYlQUMlRUMlOUQlQjglRUQlOEElQjglMjAlRUMlOUMlODQlRUMlQjklOTglMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjBpbnB1dF9wb2ludHMlM0RpbnB1dF9wb2ludHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFtYXNrcyUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX21hc2tzKG91dHB1dHMucHJlZF9tYXNrcy5jcHUoKSUyQyUyMGlucHV0cyU1QiUyMm9yaWdpbmFsX3NpemVzJTIyJTVELmNwdSgpJTJDJTIwaW5wdXRzJTVCJTIycmVzaGFwZWRfaW5wdXRfc2l6ZXMlMjIlNUQuY3B1KCkp",highlighted:`input_points = [[[<span class="hljs-number">2592</span>, <span class="hljs-number">1728</span>]]] <span class="hljs-comment"># 벌의 포인트 위치</span>

inputs = processor(image, input_points=input_points, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)
masks = processor.image_processor.post_process_masks(outputs.pred_masks.cpu(), inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(), inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu())`,wrap:!1}}),O=new j({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQWZpZyUyQyUyMGF4ZXMlMjAlM0QlMjBwbHQuc3VicGxvdHMoMSUyQyUyMDQlMkMlMjBmaWdzaXplJTNEKDE1JTJDJTIwNSkpJTBBJTBBYXhlcyU1QjAlNUQuaW1zaG93KGltYWdlKSUwQWF4ZXMlNUIwJTVELnNldF90aXRsZSgnT3JpZ2luYWwlMjBJbWFnZScpJTBBbWFza19saXN0JTIwJTNEJTIwJTVCbWFza3MlNUIwJTVEJTVCMCU1RCU1QjAlNUQubnVtcHkoKSUyQyUyMG1hc2tzJTVCMCU1RCU1QjAlNUQlNUIxJTVELm51bXB5KCklMkMlMjBtYXNrcyU1QjAlNUQlNUIwJTVEJTVCMiU1RC5udW1weSgpJTVEJTBBJTBBZm9yJTIwaSUyQyUyMG1hc2slMjBpbiUyMGVudW1lcmF0ZShtYXNrX2xpc3QlMkMlMjBzdGFydCUzRDEpJTNBJTBBJTIwJTIwJTIwJTIwb3ZlcmxheWVkX2ltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpLmNvcHkoKSUwQSUwQSUyMCUyMCUyMCUyMG92ZXJsYXllZF9pbWFnZSU1QiUzQSUyQyUzQSUyQzAlNUQlMjAlM0QlMjBucC53aGVyZShtYXNrJTIwJTNEJTNEJTIwMSUyQyUyMDI1NSUyQyUyMG92ZXJsYXllZF9pbWFnZSU1QiUzQSUyQyUzQSUyQzAlNUQpJTBBJTIwJTIwJTIwJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMSU1RCUyMCUzRCUyMG5wLndoZXJlKG1hc2slMjAlM0QlM0QlMjAxJTJDJTIwMCUyQyUyMG92ZXJsYXllZF9pbWFnZSU1QiUzQSUyQyUzQSUyQzElNUQpJTBBJTIwJTIwJTIwJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMiU1RCUyMCUzRCUyMG5wLndoZXJlKG1hc2slMjAlM0QlM0QlMjAxJTJDJTIwMCUyQyUyMG92ZXJsYXllZF9pbWFnZSU1QiUzQSUyQyUzQSUyQzIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwYXhlcyU1QmklNUQuaW1zaG93KG92ZXJsYXllZF9pbWFnZSklMEElMjAlMjAlMjAlMjBheGVzJTVCaSU1RC5zZXRfdGl0bGUoZidNYXNrJTIwJTdCaSU3RCcpJTBBZm9yJTIwYXglMjBpbiUyMGF4ZXMlM0ElMEElMjAlMjAlMjAlMjBheC5heGlzKCdvZmYnKSUwQSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

fig, axes = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">5</span>))

axes[<span class="hljs-number">0</span>].imshow(image)
axes[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&#x27;Original Image&#x27;</span>)
mask_list = [masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>].numpy(), masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">1</span>].numpy(), masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">2</span>].numpy()]

<span class="hljs-keyword">for</span> i, mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(mask_list, start=<span class="hljs-number">1</span>):
    overlayed_image = np.array(image).copy()

    overlayed_image[:,:,<span class="hljs-number">0</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">255</span>, overlayed_image[:,:,<span class="hljs-number">0</span>])
    overlayed_image[:,:,<span class="hljs-number">1</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, overlayed_image[:,:,<span class="hljs-number">1</span>])
    overlayed_image[:,:,<span class="hljs-number">2</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, overlayed_image[:,:,<span class="hljs-number">2</span>])

    axes[i].imshow(overlayed_image)
    axes[i].set_title(<span class="hljs-string">f&#x27;Mask <span class="hljs-subst">{i}</span>&#x27;</span>)
<span class="hljs-keyword">for</span> ax <span class="hljs-keyword">in</span> axes:
    ax.axis(<span class="hljs-string">&#x27;off&#x27;</span>)

plt.show()`,wrap:!1}}),ss=new ys({props:{title:"박스 프롬프팅",local:"box-prompting",headingTag:"h3"}}),es=new j({props:{code:"JTIzJTIwJUVCJUIyJThDJTIwJUVDJUEzJUJDJUVDJTlDJTg0JUVDJTlEJTk4JTIwJUVCJUIwJTk0JUVDJTlBJUI0JUVCJTk0JUE5JTIwJUVCJUIwJTk1JUVDJThBJUE0JTBBYm94JTIwJTNEJTIwJTVCMjM1MCUyQyUyMDE2MDAlMkMlMjAyODUwJTJDJTIwMjEwMCU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X2JveGVzJTNEJTVCJTVCJTVCYm94JTVEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSUyMCUyMCUyMCUyMCkudG8oJTIyY3VkYSUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQW1hc2slMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19tYXNrcyglMEElMjAlMjAlMjAlMjBvdXRwdXRzLnByZWRfbWFza3MuY3B1KCklMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlNUIlMjJvcmlnaW5hbF9zaXplcyUyMiU1RC5jcHUoKSUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTVELmNwdSgpJTBBKSU1QjAlNUQlNUIwJTVEJTVCMCU1RC5udW1weSgp",highlighted:`<span class="hljs-comment"># 벌 주위의 바운딩 박스</span>
box = [<span class="hljs-number">2350</span>, <span class="hljs-number">1600</span>, <span class="hljs-number">2850</span>, <span class="hljs-number">2100</span>]

inputs = processor(
        image,
        input_boxes=[[[box]]],
        return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
    ).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

mask = processor.image_processor.post_process_masks(
    outputs.pred_masks.cpu(),
    inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(),
    inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu()
)[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>].numpy()`,wrap:!1}}),as=new j({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5wYXRjaGVzJTIwYXMlMjBwYXRjaGVzJTBBJTBBZmlnJTJDJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdHMoKSUwQWF4Lmltc2hvdyhpbWFnZSklMEElMEFyZWN0YW5nbGUlMjAlM0QlMjBwYXRjaGVzLlJlY3RhbmdsZSgoMjM1MCUyQyUyMDE2MDApJTJDJTIwNTAwJTJDJTIwNTAwJTJDJTIwbGluZXdpZHRoJTNEMiUyQyUyMGVkZ2Vjb2xvciUzRCdyJyUyQyUyMGZhY2Vjb2xvciUzRCdub25lJyklMEFheC5hZGRfcGF0Y2gocmVjdGFuZ2xlKSUwQWF4LmF4aXMoJTIyb2ZmJTIyKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.patches <span class="hljs-keyword">as</span> patches

fig, ax = plt.subplots()
ax.imshow(image)

rectangle = patches.Rectangle((<span class="hljs-number">2350</span>, <span class="hljs-number">1600</span>), <span class="hljs-number">500</span>, <span class="hljs-number">500</span>, linewidth=<span class="hljs-number">2</span>, edgecolor=<span class="hljs-string">&#x27;r&#x27;</span>, facecolor=<span class="hljs-string">&#x27;none&#x27;</span>)
ax.add_patch(rectangle)
ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.show()`,wrap:!1}}),Ms=new j({props:{code:"ZmlnJTJDJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdHMoKSUwQWF4Lmltc2hvdyhpbWFnZSklMEFheC5pbXNob3cobWFzayUyQyUyMGNtYXAlM0QndmlyaWRpcyclMkMlMjBhbHBoYSUzRDAuNCklMEElMEFheC5heGlzKCUyMm9mZiUyMiklMEFwbHQuc2hvdygp",highlighted:`fig, ax = plt.subplots()
ax.imshow(image)
ax.imshow(mask, cmap=<span class="hljs-string">&#x27;viridis&#x27;</span>, alpha=<span class="hljs-number">0.4</span>)

ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.show()`,wrap:!1}}),ps=new Vl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/tasks/mask_generation.md"}}),{c(){u=M("meta"),Us=a(),is=M("p"),Js=a(),m(f.$$.fragment),cs=a(),g=M("p"),g.innerHTML=nl,rs=a(),k=M("p"),k.textContent=Ml,js=a(),Q=M("ul"),Q.innerHTML=pl,us=a(),x=M("p"),x.innerHTML=il,Ts=a(),T=M("div"),T.innerHTML=ml,ws=a(),Z=M("p"),Z.innerHTML=yl,os=a(),I=M("p"),I.textContent=Ul,hs=a(),$=M("ul"),$.innerHTML=Jl,Cs=a(),B=M("p"),B.innerHTML=cl,bs=a(),m(F.$$.fragment),ds=a(),m(v.$$.fragment),fs=a(),W=M("p"),W.innerHTML=rl,gs=a(),m(S.$$.fragment),ks=a(),N=M("p"),N.textContent=jl,Qs=a(),m(z.$$.fragment),xs=a(),w=M("div"),w.innerHTML=ul,Zs=a(),V=M("p"),V.innerHTML=Tl,Is=a(),m(E.$$.fragment),$s=a(),H=M("p"),H.innerHTML=wl,Bs=a(),m(A.$$.fragment),Fs=a(),G=M("p"),G.textContent=ol,vs=a(),m(X.$$.fragment),Ws=a(),Y=M("p"),Y.textContent=hl,Ss=a(),o=M("div"),o.innerHTML=Cl,Ns=a(),m(_.$$.fragment),zs=a(),m(R.$$.fragment),Vs=a(),L=M("p"),L.textContent=bl,Es=a(),m(D.$$.fragment),Hs=a(),q=M("p"),q.innerHTML=dl,As=a(),m(K.$$.fragment),Gs=a(),P=M("p"),P.innerHTML=fl,Xs=a(),m(O.$$.fragment),Ys=a(),h=M("div"),h.innerHTML=gl,_s=a(),m(ss.$$.fragment),Rs=a(),ls=M("p"),ls.innerHTML=kl,Ls=a(),m(es.$$.fragment),Ds=a(),ts=M("p"),ts.textContent=Ql,qs=a(),m(as.$$.fragment),Ks=a(),C=M("div"),C.innerHTML=xl,Ps=a(),ns=M("p"),ns.textContent=Zl,Os=a(),m(Ms.$$.fragment),sl=a(),b=M("div"),b.innerHTML=Il,ll=a(),m(ps.$$.fragment),el=a(),ms=M("p"),this.h()},l(s){const l=Nl("svelte-u9bgzb",document.head);u=p(l,"META",{name:!0,content:!0}),l.forEach(e),Us=n(s),is=p(s,"P",{}),$l(is).forEach(e),Js=n(s),y(f.$$.fragment,s),cs=n(s),g=p(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-mmew1k"&&(g.innerHTML=nl),rs=n(s),k=p(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-9b7hts"&&(k.textContent=Ml),js=n(s),Q=p(s,"UL",{"data-svelte-h":!0}),i(Q)!=="svelte-ryg2ha"&&(Q.innerHTML=pl),us=n(s),x=p(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-10uzacz"&&(x.innerHTML=il),Ts=n(s),T=p(s,"DIV",{class:!0,"data-svelte-h":!0}),i(T)!=="svelte-18bgtyc"&&(T.innerHTML=ml),ws=n(s),Z=p(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-i13rxt"&&(Z.innerHTML=yl),os=n(s),I=p(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-5anmm9"&&(I.textContent=Ul),hs=n(s),$=p(s,"UL",{"data-svelte-h":!0}),i($)!=="svelte-34u4u8"&&($.innerHTML=Jl),Cs=n(s),B=p(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1dx4ib6"&&(B.innerHTML=cl),bs=n(s),y(F.$$.fragment,s),ds=n(s),y(v.$$.fragment,s),fs=n(s),W=p(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-13kgcmm"&&(W.innerHTML=rl),gs=n(s),y(S.$$.fragment,s),ks=n(s),N=p(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-ltc9d3"&&(N.textContent=jl),Qs=n(s),y(z.$$.fragment,s),xs=n(s),w=p(s,"DIV",{class:!0,"data-svelte-h":!0}),i(w)!=="svelte-5ac7qo"&&(w.innerHTML=ul),Zs=n(s),V=p(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-sso2e2"&&(V.innerHTML=Tl),Is=n(s),y(E.$$.fragment,s),$s=n(s),H=p(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1iijjkz"&&(H.innerHTML=wl),Bs=n(s),y(A.$$.fragment,s),Fs=n(s),G=p(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-894oei"&&(G.textContent=ol),vs=n(s),y(X.$$.fragment,s),Ws=n(s),Y=p(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1sn01nr"&&(Y.textContent=hl),Ss=n(s),o=p(s,"DIV",{class:!0,"data-svelte-h":!0}),i(o)!=="svelte-1xv3qg"&&(o.innerHTML=Cl),Ns=n(s),y(_.$$.fragment,s),zs=n(s),y(R.$$.fragment,s),Vs=n(s),L=p(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-fmtk55"&&(L.textContent=bl),Es=n(s),y(D.$$.fragment,s),Hs=n(s),q=p(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-w6sf9k"&&(q.innerHTML=dl),As=n(s),y(K.$$.fragment,s),Gs=n(s),P=p(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-8jfq4b"&&(P.innerHTML=fl),Xs=n(s),y(O.$$.fragment,s),Ys=n(s),h=p(s,"DIV",{class:!0,"data-svelte-h":!0}),i(h)!=="svelte-od5m1y"&&(h.innerHTML=gl),_s=n(s),y(ss.$$.fragment,s),Rs=n(s),ls=p(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-1yuitoy"&&(ls.innerHTML=kl),Ls=n(s),y(es.$$.fragment,s),Ds=n(s),ts=p(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-wkxo0l"&&(ts.textContent=Ql),qs=n(s),y(as.$$.fragment,s),Ks=n(s),C=p(s,"DIV",{class:!0,"data-svelte-h":!0}),i(C)!=="svelte-12t8f97"&&(C.innerHTML=xl),Ps=n(s),ns=p(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-1l6eb5k"&&(ns.textContent=Zl),Os=n(s),y(Ms.$$.fragment,s),sl=n(s),b=p(s,"DIV",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-1inger9"&&(b.innerHTML=Il),ll=n(s),y(ps.$$.fragment,s),el=n(s),ms=p(s,"P",{}),$l(ms).forEach(e),this.h()},h(){d(u,"name","hf:doc:metadata"),d(u,"content",Hl),d(T,"class","flex justify-center"),d(w,"class","flex justify-center"),d(o,"class","flex justify-center"),d(h,"class","flex justify-center"),d(C,"class","flex justify-center"),d(b,"class","flex justify-center")},m(s,l){zl(document.head,u),t(s,Us,l),t(s,is,l),t(s,Js,l),U(f,s,l),t(s,cs,l),t(s,g,l),t(s,rs,l),t(s,k,l),t(s,js,l),t(s,Q,l),t(s,us,l),t(s,x,l),t(s,Ts,l),t(s,T,l),t(s,ws,l),t(s,Z,l),t(s,os,l),t(s,I,l),t(s,hs,l),t(s,$,l),t(s,Cs,l),t(s,B,l),t(s,bs,l),U(F,s,l),t(s,ds,l),U(v,s,l),t(s,fs,l),t(s,W,l),t(s,gs,l),U(S,s,l),t(s,ks,l),t(s,N,l),t(s,Qs,l),U(z,s,l),t(s,xs,l),t(s,w,l),t(s,Zs,l),t(s,V,l),t(s,Is,l),U(E,s,l),t(s,$s,l),t(s,H,l),t(s,Bs,l),U(A,s,l),t(s,Fs,l),t(s,G,l),t(s,vs,l),U(X,s,l),t(s,Ws,l),t(s,Y,l),t(s,Ss,l),t(s,o,l),t(s,Ns,l),U(_,s,l),t(s,zs,l),U(R,s,l),t(s,Vs,l),t(s,L,l),t(s,Es,l),U(D,s,l),t(s,Hs,l),t(s,q,l),t(s,As,l),U(K,s,l),t(s,Gs,l),t(s,P,l),t(s,Xs,l),U(O,s,l),t(s,Ys,l),t(s,h,l),t(s,_s,l),U(ss,s,l),t(s,Rs,l),t(s,ls,l),t(s,Ls,l),U(es,s,l),t(s,Ds,l),t(s,ts,l),t(s,qs,l),U(as,s,l),t(s,Ks,l),t(s,C,l),t(s,Ps,l),t(s,ns,l),t(s,Os,l),U(Ms,s,l),t(s,sl,l),t(s,b,l),t(s,ll,l),U(ps,s,l),t(s,el,l),t(s,ms,l),tl=!0},p:Fl,i(s){tl||(J(f.$$.fragment,s),J(F.$$.fragment,s),J(v.$$.fragment,s),J(S.$$.fragment,s),J(z.$$.fragment,s),J(E.$$.fragment,s),J(A.$$.fragment,s),J(X.$$.fragment,s),J(_.$$.fragment,s),J(R.$$.fragment,s),J(D.$$.fragment,s),J(K.$$.fragment,s),J(O.$$.fragment,s),J(ss.$$.fragment,s),J(es.$$.fragment,s),J(as.$$.fragment,s),J(Ms.$$.fragment,s),J(ps.$$.fragment,s),tl=!0)},o(s){c(f.$$.fragment,s),c(F.$$.fragment,s),c(v.$$.fragment,s),c(S.$$.fragment,s),c(z.$$.fragment,s),c(E.$$.fragment,s),c(A.$$.fragment,s),c(X.$$.fragment,s),c(_.$$.fragment,s),c(R.$$.fragment,s),c(D.$$.fragment,s),c(K.$$.fragment,s),c(O.$$.fragment,s),c(ss.$$.fragment,s),c(es.$$.fragment,s),c(as.$$.fragment,s),c(Ms.$$.fragment,s),c(ps.$$.fragment,s),tl=!1},d(s){s&&(e(Us),e(is),e(Js),e(cs),e(g),e(rs),e(k),e(js),e(Q),e(us),e(x),e(Ts),e(T),e(ws),e(Z),e(os),e(I),e(hs),e($),e(Cs),e(B),e(bs),e(ds),e(fs),e(W),e(gs),e(ks),e(N),e(Qs),e(xs),e(w),e(Zs),e(V),e(Is),e($s),e(H),e(Bs),e(Fs),e(G),e(vs),e(Ws),e(Y),e(Ss),e(o),e(Ns),e(zs),e(Vs),e(L),e(Es),e(Hs),e(q),e(As),e(Gs),e(P),e(Xs),e(Ys),e(h),e(_s),e(Rs),e(ls),e(Ls),e(Ds),e(ts),e(qs),e(Ks),e(C),e(Ps),e(ns),e(Os),e(sl),e(b),e(ll),e(el),e(ms)),e(u),r(f,s),r(F,s),r(v,s),r(S,s),r(z,s),r(E,s),r(A,s),r(X,s),r(_,s),r(R,s),r(D,s),r(K,s),r(O,s),r(ss,s),r(es,s),r(as,s),r(Ms,s),r(ps,s)}}}const Hl='{"title":"마스크 생성","local":"mask-generation","sections":[{"title":"마스크 생성 파이프라인","local":"mask-generation-pipeline","sections":[],"depth":2},{"title":"모델 추론","local":"model-inference","sections":[{"title":"포인트 프롬프팅","local":"point-prompting","sections":[],"depth":3},{"title":"박스 프롬프팅","local":"box-prompting","sections":[],"depth":3}],"depth":2}],"depth":1}';function Al(al){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends Wl{constructor(u){super(),Sl(this,u,Al,El,Bl,{})}}export{Rl as component};
