import{s as Fo,f as zo,o as No,n as Pe}from"../chunks/scheduler.9bc65507.js";import{S as So,i as Ro,g as s,s as d,u as g,A as Xo,h as o,f as t,c,j as f,v as M,y as u,k as m,o as a,a as l,w as _,d as y,t as w,x as b}from"../chunks/index.78c82d43.js";import{T as Ps}from"../chunks/Tip.87d55b76.js";import{D as k}from"../chunks/Docstring.f3d04bd2.js";import{C as hs}from"../chunks/CodeBlock.48618ec2.js";import{I as X}from"../chunks/IconCopyLink.bedaa44d.js";import{E as ps}from"../chunks/ExampleCodeBlock.872b014d.js";function Yo(J){let i,v="Example:",p,h,T;return h=new hs({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTUFFQ29uZmlnJTJDJTIwVmlkZW9NQUVNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaWRlb01BRSUyMHZpZGVvbWFlLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVmlkZW9NQUVDb25maWcoKSUwQSUwQSUyMyUyMFJhbmRvbWx5JTIwaW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpZGVvTUFFTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoMAEConfig, VideoMAEModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VideoMAE videomae-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VideoMAEConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){i=s("p"),i.textContent=v,p=d(),g(h.$$.fragment)},l(r){i=o(r,"P",{"data-svelte-h":!0}),u(i)!=="svelte-11lpom8"&&(i.textContent=v),p=c(r),M(h.$$.fragment,r)},m(r,j){l(r,i,j),l(r,p,j),_(h,r,j),T=!0},p:Pe,i(r){T||(y(h.$$.fragment,r),T=!0)},o(r){w(h.$$.fragment,r),T=!1},d(r){r&&(t(i),t(p)),b(h,r)}}}function Po(J){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=s("p"),i.innerHTML=v},l(p){i=o(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(p,h){l(p,i,h)},p:Pe,d(p){p&&t(i)}}}function Qo(J){let i,v="Examples:",p,h,T;return h=new hs({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VideoMAEModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 16 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">16</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEModel.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare video for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1568</span>, <span class="hljs-number">768</span>]`}}),{c(){i=s("p"),i.textContent=v,p=d(),g(h.$$.fragment)},l(r){i=o(r,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=v),p=c(r),M(h.$$.fragment,r)},m(r,j){l(r,i,j),l(r,p,j),_(h,r,j),T=!0},p:Pe,i(r){T||(y(h.$$.fragment,r),T=!0)},o(r){w(h.$$.fragment,r),T=!1},d(r){r&&(t(i),t(p)),b(h,r)}}}function Ho(J){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=s("p"),i.innerHTML=v},l(p){i=o(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(p,h){l(p,i,h)},p:Pe,d(p){p&&t(i)}}}function Lo(J){let i,v="Examples:",p,h,T;return h=new hs({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFZpZGVvTUFFRm9yUHJlVHJhaW5pbmclMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW51bV9mcmFtZXMlMjAlM0QlMjAxNiUwQXZpZGVvJTIwJTNEJTIwbGlzdChucC5yYW5kb20ucmFuZGludCgwJTJDJTIwMjU2JTJDJTIwKG51bV9mcmFtZXMlMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSkpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJNQ0ctTkpVJTJGdmlkZW9tYWUtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMFZpZGVvTUFFRm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUyMk1DRy1OSlUlMkZ2aWRlb21hZS1iYXNlJTIyKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvcih2aWRlbyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQSUwQW51bV9wYXRjaGVzX3Blcl9mcmFtZSUyMCUzRCUyMChtb2RlbC5jb25maWcuaW1hZ2Vfc2l6ZSUyMCUyRiUyRiUyMG1vZGVsLmNvbmZpZy5wYXRjaF9zaXplKSUyMCoqJTIwMiUwQXNlcV9sZW5ndGglMjAlM0QlMjAobnVtX2ZyYW1lcyUyMCUyRiUyRiUyMG1vZGVsLmNvbmZpZy50dWJlbGV0X3NpemUpJTIwKiUyMG51bV9wYXRjaGVzX3Blcl9mcmFtZSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQoMCUyQyUyMDIlMkMlMjAoMSUyQyUyMHNlcV9sZW5ndGgpKS5ib29sKCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwocGl4ZWxfdmFsdWVzJTJDJTIwYm9vbF9tYXNrZWRfcG9zJTNEYm9vbF9tYXNrZWRfcG9zKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VideoMAEForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames = <span class="hljs-number">16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = <span class="hljs-built_in">list</span>(np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">256</span>, (num_frames, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForPreTraining.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(video, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches_per_frame = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>seq_length = (num_frames // model.config.tubelet_size) * num_patches_per_frame
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, (<span class="hljs-number">1</span>, seq_length)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`}}),{c(){i=s("p"),i.textContent=v,p=d(),g(h.$$.fragment)},l(r){i=o(r,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=v),p=c(r),M(h.$$.fragment,r)},m(r,j){l(r,i,j),l(r,p,j),_(h,r,j),T=!0},p:Pe,i(r){T||(y(h.$$.fragment,r),T=!0)},o(r){w(h.$$.fragment,r),T=!1},d(r){r&&(t(i),t(p)),b(h,r)}}}function Do(J){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=s("p"),i.innerHTML=v},l(p){i=o(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(p,h){l(p,i,h)},p:Pe,d(p){p&&t(i)}}}function qo(J){let i,v="Examples:",p,h,T;return h=new hs({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VideoMAEForVideoClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 16 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">16</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base-finetuned-kinetics&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForVideoClassification.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base-finetuned-kinetics&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 400 Kinetics-400 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
eating spaghetti`}}),{c(){i=s("p"),i.textContent=v,p=d(),g(h.$$.fragment)},l(r){i=o(r,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=v),p=c(r),M(h.$$.fragment,r)},m(r,j){l(r,i,j),l(r,p,j),_(h,r,j),T=!0},p:Pe,i(r){T||(y(h.$$.fragment,r),T=!0)},o(r){w(h.$$.fragment,r),T=!1},d(r){r&&(t(i),t(p)),b(h,r)}}}function Ko(J){let i,v,p,h,T,r,j,he,fs,Qe,Qs="VideoMAE",Et,W,Y,Mt,fe,us,He,Hs="Overview",At,ue,Ls=`The VideoMAE model was proposed in <a href="https://arxiv.org/abs/2203.12602" rel="nofollow">VideoMAE: Masked Autoencoders are Data-Efficient Learners for Self-Supervised Video Pre-Training</a> by Zhan Tong, Yibing Song, Jue Wang, Limin Wang.
VideoMAE extends masked auto encoders (<a href="vit_mae">MAE</a>) to video, claiming state-of-the-art performance on several video classification benchmarks.`,Zt,ge,Ds="The abstract from the paper is the following:",xt,Me,qs="<em>Pre-training video transformers on extra large-scale datasets is generally required to achieve premier performance on relatively small datasets. In this paper, we show that video masked autoencoders (VideoMAE) are data-efficient learners for self-supervised video pre-training (SSVP). We are inspired by the recent ImageMAE and propose customized video tube masking and reconstruction. These simple designs turn out to be effective for overcoming information leakage caused by the temporal correlation during video reconstruction. We obtain three important findings on SSVP: (1) An extremely high proportion of masking ratio (i.e., 90% to 95%) still yields favorable performance of VideoMAE. The temporally redundant video content enables higher masking ratio than that of images. (2) VideoMAE achieves impressive results on very small datasets (i.e., around 3k-4k videos) without using any extra data. This is partially ascribed to the challenging task of video reconstruction to enforce high-level structure learning. (3) VideoMAE shows that data quality is more important than data quantity for SSVP. Domain shift between pre-training and target datasets are important issues in SSVP. Notably, our VideoMAE with the vanilla ViT backbone can achieve 83.9% on Kinects-400, 75.3% on Something-Something V2, 90.8% on UCF101, and 61.1% on HMDB51 without using any extra data.</em>",kt,_e,Ks="Tips:",Wt,ye,Os='<li>One can use <a href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEImageProcessor">VideoMAEImageProcessor</a> to prepare videos for the model. It will resize + normalize all frames of a video for you.</li> <li><a href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> includes the decoder on top for self-supervised pre-training.</li>',$t,P,eo,Bt,we,to='VideoMAE pre-training. Taken from the <a href="https://arxiv.org/abs/2203.12602">original paper</a>.',Gt,be,so=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/MCG-NJU/VideoMAE" rel="nofollow">here</a>.`,Ft,$,Q,_t,Te,gs,Le,oo="Resources",zt,ve,ao=`A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with VideoMAE. If
you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll
review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.`,Nt,je,no="<strong>Video classification</strong>",St,Je,ro=`<li><a href="https://github.com/huggingface/notebooks/blob/main/examples/video_classification.ipynb" rel="nofollow">A notebook</a> that shows how
to fine-tune a VideoMAE model on a custom dataset.</li> <li><a href="../tasks/video-classification">Video classification task guide</a></li> <li><a href="https://huggingface.co/spaces/sayakpaul/video-classification-ucf101-subset" rel="nofollow">A 🤗 Space</a> showing how to perform inference with a video classification model.</li>`,Rt,B,H,yt,Ue,Ms,De,lo="VideoMAEConfig",Xt,U,Ce,_s,qe,io=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a>. It is used to instantiate a
VideoMAE model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the VideoMAE
<a href="https://huggingface.co/MCG-NJU/videomae-base" rel="nofollow">MCG-NJU/videomae-base</a> architecture.`,ys,Ke,co=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ws,L,Yt,G,D,wt,Ve,bs,Oe,mo="VideoMAEFeatureExtractor",Pt,F,Ie,Ts,q,Ee,vs,et,po="Preprocess an image or a batch of images.",Qt,z,K,bt,Ae,js,tt,ho="VideoMAEImageProcessor",Ht,E,Ze,Js,st,fo="Constructs a VideoMAE image processor.",Us,O,xe,Cs,ot,uo="Preprocess an image or batch of images.",Lt,N,ee,Tt,ke,Vs,at,go="VideoMAEModel",Dt,A,We,Is,nt,Mo=`The bare VideoMAE Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Es,C,$e,As,rt,_o='The <a href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a> forward method, overrides the <code>__call__</code> special method.',Zs,te,xs,se,qt,S,oe,vt,Be,ks,lt,yo="VideoMAEForPreTraining",Kt,Z,Ge,Ws,it,wo=`The VideoMAE Model transformer with the decoder on top for self-supervised pre-training.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,$s,V,Fe,Bs,dt,bo='The <a href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',Gs,ae,Fs,ne,Ot,R,re,jt,ze,zs,ct,To="VideoMAEForVideoClassification",es,x,Ne,Ns,mt,vo=`VideoMAE Model transformer with a video classification head on top (a linear layer on top of the average pooled hidden
states of all tokens) e.g. for ImageNet.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ss,I,Se,Rs,pt,jo='The <a href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEForVideoClassification">VideoMAEForVideoClassification</a> forward method, overrides the <code>__call__</code> special method.',Xs,le,Ys,ie,ts,Jt,ss;return he=new X({}),fe=new X({}),Te=new X({}),Ue=new X({}),Ce=new k({props:{name:"class transformers.VideoMAEConfig",anchor:"transformers.VideoMAEConfig",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"num_frames",val:" = 16"},{name:"tubelet_size",val:" = 2"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"qkv_bias",val:" = True"},{name:"use_mean_pooling",val:" = True"},{name:"decoder_num_attention_heads",val:" = 6"},{name:"decoder_hidden_size",val:" = 384"},{name:"decoder_num_hidden_layers",val:" = 4"},{name:"decoder_intermediate_size",val:" = 1536"},{name:"norm_pix_loss",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.VideoMAEConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.VideoMAEConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.VideoMAEConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of frames in each video.`,name:"num_frames"},{anchor:"transformers.VideoMAEConfig.tubelet_size",description:`<strong>tubelet_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of tubelets.`,name:"tubelet_size"},{anchor:"transformers.VideoMAEConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.VideoMAEConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.VideoMAEConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.VideoMAEConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.VideoMAEConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.VideoMAEConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.VideoMAEConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.VideoMAEConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VideoMAEConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.VideoMAEConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.VideoMAEConfig.use_mean_pooling",description:`<strong>use_mean_pooling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to mean pool the final hidden states instead of using the final hidden state of the [CLS] token.`,name:"use_mean_pooling"},{anchor:"transformers.VideoMAEConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of attention heads for each attention layer in the decoder.`,name:"decoder_num_attention_heads"},{anchor:"transformers.VideoMAEConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
Dimensionality of the decoder.`,name:"decoder_hidden_size"},{anchor:"transformers.VideoMAEConfig.decoder_num_hidden_layers",description:`<strong>decoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of hidden layers in the decoder.`,name:"decoder_num_hidden_layers"},{anchor:"transformers.VideoMAEConfig.decoder_intermediate_size",description:`<strong>decoder_intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1536) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the decoder.`,name:"decoder_intermediate_size"},{anchor:"transformers.VideoMAEConfig.norm_pix_loss",description:`<strong>norm_pix_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the target patch pixels.`,name:"norm_pix_loss"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/configuration_videomae.py#L28"}}),L=new ps({props:{anchor:"transformers.VideoMAEConfig.example",$$slots:{default:[Yo]},$$scope:{ctx:J}}}),Ve=new X({}),Ie=new k({props:{name:"class transformers.VideoMAEFeatureExtractor",anchor:"transformers.VideoMAEFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/feature_extraction_videomae.py#L26"}}),Ee=new k({props:{name:"__call__",anchor:"transformers.VideoMAEFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/image_processing_utils.py#L544"}}),Ae=new X({}),Ze=new k({props:{name:"class transformers.VideoMAEImageProcessor",anchor:"transformers.VideoMAEImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VideoMAEImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the output image after resizing. The shortest edge of the image will be resized to
<code>size[&quot;shortest_edge&quot;]</code> while maintaining the aspect ratio of the original image. Can be overriden by
<code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.VideoMAEImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VideoMAEImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VideoMAEImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after applying the center crop. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.VideoMAEImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VideoMAEImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.VideoMAEImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.VideoMAEImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VideoMAEImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/image_processing_videomae.py#L62"}}),xe=new k({props:{name:"preprocess",anchor:"transformers.VideoMAEImageProcessor.preprocess",parameters:[{name:"videos",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after applying resize.`,name:"size"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_centre_crop</code>) &#x2014;
Whether to centre crop the image.`,name:"do_center_crop"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after applying the centre crop.`,name:"crop_size"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the inferred channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/image_processing_videomae.py#L233"}}),ke=new X({}),We=new k({props:{name:"class transformers.VideoMAEModel",anchor:"transformers.VideoMAEModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/modeling_videomae.py#L535"}}),$e=new k({props:{name:"forward",anchor:"transformers.VideoMAEModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">VideoMAEImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VideoMAEModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VideoMAEModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoMAEModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoMAEModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoMAEModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0). Each video in the
batch must have the same number of masked patches. If <code>None</code>, then all patches are considered. Sequence
length is <code>(num_frames // tubelet_size) * (image_size // patch_size) ** 2</code>.`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/modeling_videomae.py#L562",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEConfig"
>VideoMAEConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new Ps({props:{$$slots:{default:[Po]},$$scope:{ctx:J}}}),se=new ps({props:{anchor:"transformers.VideoMAEModel.forward.example",$$slots:{default:[Qo]},$$scope:{ctx:J}}}),Be=new X({}),Ge=new k({props:{name:"class transformers.VideoMAEForPreTraining",anchor:"transformers.VideoMAEForPreTraining",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/modeling_videomae.py#L768"}}),Fe=new k({props:{name:"forward",anchor:"transformers.VideoMAEForPreTraining.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"bool_masked_pos",val:": BoolTensor"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEForPreTraining.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">VideoMAEImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VideoMAEForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VideoMAEForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoMAEForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoMAEForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoMAEForPreTraining.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0). Each video in the
batch must have the same number of masked patches. Sequence length is <code>(num_frames // tubelet_size) * (image_size // patch_size) ** 2</code>.`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/modeling_videomae.py#L786",returnDescription:`
<p>A <code>transformers.models.videomae.modeling_videomae.VideoMAEForPreTrainingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEConfig"
>VideoMAEConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Pixel reconstruction loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size ** 2 * num_channels)</code>) — Pixel reconstruction logits.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`
<p><code>transformers.models.videomae.modeling_videomae.VideoMAEForPreTrainingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new Ps({props:{$$slots:{default:[Ho]},$$scope:{ctx:J}}}),ne=new ps({props:{anchor:"transformers.VideoMAEForPreTraining.forward.example",$$slots:{default:[Lo]},$$scope:{ctx:J}}}),ze=new X({}),Ne=new k({props:{name:"class transformers.VideoMAEForVideoClassification",anchor:"transformers.VideoMAEForVideoClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEForVideoClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEConfig">VideoMAEConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/modeling_videomae.py#L952"}}),Se=new k({props:{name:"forward",anchor:"transformers.VideoMAEForVideoClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEForVideoClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">VideoMAEImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VideoMAEForVideoClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VideoMAEForVideoClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoMAEForVideoClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoMAEForVideoClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoMAEForVideoClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/videomae/modeling_videomae.py#L966",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/videomae#transformers.VideoMAEConfig"
>VideoMAEConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),le=new Ps({props:{$$slots:{default:[Do]},$$scope:{ctx:J}}}),ie=new ps({props:{anchor:"transformers.VideoMAEForVideoClassification.forward.example",$$slots:{default:[qo]},$$scope:{ctx:J}}}),{c(){i=s("meta"),v=d(),p=s("p"),h=d(),T=s("h1"),r=s("a"),j=s("span"),g(he.$$.fragment),fs=d(),Qe=s("span"),Qe.textContent=Qs,Et=d(),W=s("h2"),Y=s("a"),Mt=s("span"),g(fe.$$.fragment),us=d(),He=s("span"),He.textContent=Hs,At=d(),ue=s("p"),ue.innerHTML=Ls,Zt=d(),ge=s("p"),ge.textContent=Ds,xt=d(),Me=s("p"),Me.innerHTML=qs,kt=d(),_e=s("p"),_e.textContent=Ks,Wt=d(),ye=s("ul"),ye.innerHTML=Os,$t=d(),P=s("img"),Bt=d(),we=s("small"),we.innerHTML=to,Gt=d(),be=s("p"),be.innerHTML=so,Ft=d(),$=s("h2"),Q=s("a"),_t=s("span"),g(Te.$$.fragment),gs=d(),Le=s("span"),Le.textContent=oo,zt=d(),ve=s("p"),ve.textContent=ao,Nt=d(),je=s("p"),je.innerHTML=no,St=d(),Je=s("ul"),Je.innerHTML=ro,Rt=d(),B=s("h2"),H=s("a"),yt=s("span"),g(Ue.$$.fragment),Ms=d(),De=s("span"),De.textContent=lo,Xt=d(),U=s("div"),g(Ce.$$.fragment),_s=d(),qe=s("p"),qe.innerHTML=io,ys=d(),Ke=s("p"),Ke.innerHTML=co,ws=d(),g(L.$$.fragment),Yt=d(),G=s("h2"),D=s("a"),wt=s("span"),g(Ve.$$.fragment),bs=d(),Oe=s("span"),Oe.textContent=mo,Pt=d(),F=s("div"),g(Ie.$$.fragment),Ts=d(),q=s("div"),g(Ee.$$.fragment),vs=d(),et=s("p"),et.textContent=po,Qt=d(),z=s("h2"),K=s("a"),bt=s("span"),g(Ae.$$.fragment),js=d(),tt=s("span"),tt.textContent=ho,Ht=d(),E=s("div"),g(Ze.$$.fragment),Js=d(),st=s("p"),st.textContent=fo,Us=d(),O=s("div"),g(xe.$$.fragment),Cs=d(),ot=s("p"),ot.textContent=uo,Lt=d(),N=s("h2"),ee=s("a"),Tt=s("span"),g(ke.$$.fragment),Vs=d(),at=s("span"),at.textContent=go,Dt=d(),A=s("div"),g(We.$$.fragment),Is=d(),nt=s("p"),nt.innerHTML=Mo,Es=d(),C=s("div"),g($e.$$.fragment),As=d(),rt=s("p"),rt.innerHTML=_o,Zs=d(),g(te.$$.fragment),xs=d(),g(se.$$.fragment),qt=d(),S=s("h2"),oe=s("a"),vt=s("span"),g(Be.$$.fragment),ks=d(),lt=s("span"),lt.textContent=yo,Kt=d(),Z=s("div"),g(Ge.$$.fragment),Ws=d(),it=s("p"),it.innerHTML=wo,$s=d(),V=s("div"),g(Fe.$$.fragment),Bs=d(),dt=s("p"),dt.innerHTML=bo,Gs=d(),g(ae.$$.fragment),Fs=d(),g(ne.$$.fragment),Ot=d(),R=s("h2"),re=s("a"),jt=s("span"),g(ze.$$.fragment),zs=d(),ct=s("span"),ct.textContent=To,es=d(),x=s("div"),g(Ne.$$.fragment),Ns=d(),mt=s("p"),mt.innerHTML=vo,Ss=d(),I=s("div"),g(Se.$$.fragment),Rs=d(),pt=s("p"),pt.innerHTML=jo,Xs=d(),g(le.$$.fragment),Ys=d(),g(ie.$$.fragment),ts=d(),Jt=s("p"),this.h()},l(e){const n=Xo("svelte-1phssyn",document.head);i=o(n,"META",{name:!0,content:!0}),n.forEach(t),v=c(e),p=o(e,"P",{}),f(p).forEach(t),h=c(e),T=o(e,"H1",{class:!0});var Re=f(T);r=o(Re,"A",{id:!0,class:!0,href:!0});var Ut=f(r);j=o(Ut,"SPAN",{});var Ct=f(j);M(he.$$.fragment,Ct),Ct.forEach(t),Ut.forEach(t),fs=c(Re),Qe=o(Re,"SPAN",{"data-svelte-h":!0}),u(Qe)!=="svelte-sljeal"&&(Qe.textContent=Qs),Re.forEach(t),Et=c(e),W=o(e,"H2",{class:!0});var Xe=f(W);Y=o(Xe,"A",{id:!0,class:!0,href:!0});var Vt=f(Y);Mt=o(Vt,"SPAN",{});var It=f(Mt);M(fe.$$.fragment,It),It.forEach(t),Vt.forEach(t),us=c(Xe),He=o(Xe,"SPAN",{"data-svelte-h":!0}),u(He)!=="svelte-1jsw1pg"&&(He.textContent=Hs),Xe.forEach(t),At=c(e),ue=o(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-hyjvdr"&&(ue.innerHTML=Ls),Zt=c(e),ge=o(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-vfdo9a"&&(ge.textContent=Ds),xt=c(e),Me=o(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1rhhtl3"&&(Me.innerHTML=qs),kt=c(e),_e=o(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-axv494"&&(_e.textContent=Ks),Wt=c(e),ye=o(e,"UL",{"data-svelte-h":!0}),u(ye)!=="svelte-40nf5l"&&(ye.innerHTML=Os),$t=c(e),P=o(e,"IMG",{src:!0,alt:!0,width:!0}),Bt=c(e),we=o(e,"SMALL",{"data-svelte-h":!0}),u(we)!=="svelte-19gew7l"&&(we.innerHTML=to),Gt=c(e),be=o(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-xbyn5w"&&(be.innerHTML=so),Ft=c(e),$=o(e,"H2",{class:!0});var Ye=f($);Q=o(Ye,"A",{id:!0,class:!0,href:!0});var Jo=f(Q);_t=o(Jo,"SPAN",{});var Uo=f(_t);M(Te.$$.fragment,Uo),Uo.forEach(t),Jo.forEach(t),gs=c(Ye),Le=o(Ye,"SPAN",{"data-svelte-h":!0}),u(Le)!=="svelte-w4zzv6"&&(Le.textContent=oo),Ye.forEach(t),zt=c(e),ve=o(e,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-1k7bn0h"&&(ve.textContent=ao),Nt=c(e),je=o(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-yaiu72"&&(je.innerHTML=no),St=c(e),Je=o(e,"UL",{"data-svelte-h":!0}),u(Je)!=="svelte-ptzxk7"&&(Je.innerHTML=ro),Rt=c(e),B=o(e,"H2",{class:!0});var os=f(B);H=o(os,"A",{id:!0,class:!0,href:!0});var Co=f(H);yt=o(Co,"SPAN",{});var Vo=f(yt);M(Ue.$$.fragment,Vo),Vo.forEach(t),Co.forEach(t),Ms=c(os),De=o(os,"SPAN",{"data-svelte-h":!0}),u(De)!=="svelte-1bkmerv"&&(De.textContent=lo),os.forEach(t),Xt=c(e),U=o(e,"DIV",{class:!0});var de=f(U);M(Ce.$$.fragment,de),_s=c(de),qe=o(de,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-1yi39d5"&&(qe.innerHTML=io),ys=c(de),Ke=o(de,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-cfh5wl"&&(Ke.innerHTML=co),ws=c(de),M(L.$$.fragment,de),de.forEach(t),Yt=c(e),G=o(e,"H2",{class:!0});var as=f(G);D=o(as,"A",{id:!0,class:!0,href:!0});var Io=f(D);wt=o(Io,"SPAN",{});var Eo=f(wt);M(Ve.$$.fragment,Eo),Eo.forEach(t),Io.forEach(t),bs=c(as),Oe=o(as,"SPAN",{"data-svelte-h":!0}),u(Oe)!=="svelte-gk0knb"&&(Oe.textContent=mo),as.forEach(t),Pt=c(e),F=o(e,"DIV",{class:!0});var ns=f(F);M(Ie.$$.fragment,ns),Ts=c(ns),q=o(ns,"DIV",{class:!0});var rs=f(q);M(Ee.$$.fragment,rs),vs=c(rs),et=o(rs,"P",{"data-svelte-h":!0}),u(et)!=="svelte-khengj"&&(et.textContent=po),rs.forEach(t),ns.forEach(t),Qt=c(e),z=o(e,"H2",{class:!0});var ls=f(z);K=o(ls,"A",{id:!0,class:!0,href:!0});var Ao=f(K);bt=o(Ao,"SPAN",{});var Zo=f(bt);M(Ae.$$.fragment,Zo),Zo.forEach(t),Ao.forEach(t),js=c(ls),tt=o(ls,"SPAN",{"data-svelte-h":!0}),u(tt)!=="svelte-13s71s4"&&(tt.textContent=ho),ls.forEach(t),Ht=c(e),E=o(e,"DIV",{class:!0});var ht=f(E);M(Ze.$$.fragment,ht),Js=c(ht),st=o(ht,"P",{"data-svelte-h":!0}),u(st)!=="svelte-uyvre4"&&(st.textContent=fo),Us=c(ht),O=o(ht,"DIV",{class:!0});var is=f(O);M(xe.$$.fragment,is),Cs=c(is),ot=o(is,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-1x3yxsa"&&(ot.textContent=uo),is.forEach(t),ht.forEach(t),Lt=c(e),N=o(e,"H2",{class:!0});var ds=f(N);ee=o(ds,"A",{id:!0,class:!0,href:!0});var xo=f(ee);Tt=o(xo,"SPAN",{});var ko=f(Tt);M(ke.$$.fragment,ko),ko.forEach(t),xo.forEach(t),Vs=c(ds),at=o(ds,"SPAN",{"data-svelte-h":!0}),u(at)!=="svelte-ygu2ay"&&(at.textContent=go),ds.forEach(t),Dt=c(e),A=o(e,"DIV",{class:!0});var ft=f(A);M(We.$$.fragment,ft),Is=c(ft),nt=o(ft,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-1xmhq1d"&&(nt.innerHTML=Mo),Es=c(ft),C=o(ft,"DIV",{class:!0});var ce=f(C);M($e.$$.fragment,ce),As=c(ce),rt=o(ce,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-1bo67l9"&&(rt.innerHTML=_o),Zs=c(ce),M(te.$$.fragment,ce),xs=c(ce),M(se.$$.fragment,ce),ce.forEach(t),ft.forEach(t),qt=c(e),S=o(e,"H2",{class:!0});var cs=f(S);oe=o(cs,"A",{id:!0,class:!0,href:!0});var Wo=f(oe);vt=o(Wo,"SPAN",{});var $o=f(vt);M(Be.$$.fragment,$o),$o.forEach(t),Wo.forEach(t),ks=c(cs),lt=o(cs,"SPAN",{"data-svelte-h":!0}),u(lt)!=="svelte-1ki13mv"&&(lt.textContent=yo),cs.forEach(t),Kt=c(e),Z=o(e,"DIV",{class:!0});var ut=f(Z);M(Ge.$$.fragment,ut),Ws=c(ut),it=o(ut,"P",{"data-svelte-h":!0}),u(it)!=="svelte-1m9c5iu"&&(it.innerHTML=wo),$s=c(ut),V=o(ut,"DIV",{class:!0});var me=f(V);M(Fe.$$.fragment,me),Bs=c(me),dt=o(me,"P",{"data-svelte-h":!0}),u(dt)!=="svelte-1bpb6ot"&&(dt.innerHTML=bo),Gs=c(me),M(ae.$$.fragment,me),Fs=c(me),M(ne.$$.fragment,me),me.forEach(t),ut.forEach(t),Ot=c(e),R=o(e,"H2",{class:!0});var ms=f(R);re=o(ms,"A",{id:!0,class:!0,href:!0});var Bo=f(re);jt=o(Bo,"SPAN",{});var Go=f(jt);M(ze.$$.fragment,Go),Go.forEach(t),Bo.forEach(t),zs=c(ms),ct=o(ms,"SPAN",{"data-svelte-h":!0}),u(ct)!=="svelte-7rrpgn"&&(ct.textContent=To),ms.forEach(t),es=c(e),x=o(e,"DIV",{class:!0});var gt=f(x);M(Ne.$$.fragment,gt),Ns=c(gt),mt=o(gt,"P",{"data-svelte-h":!0}),u(mt)!=="svelte-9dfld7"&&(mt.innerHTML=vo),Ss=c(gt),I=o(gt,"DIV",{class:!0});var pe=f(I);M(Se.$$.fragment,pe),Rs=c(pe),pt=o(pe,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-1xcsfvx"&&(pt.innerHTML=jo),Xs=c(pe),M(le.$$.fragment,pe),Ys=c(pe),M(ie.$$.fragment,pe),pe.forEach(t),gt.forEach(t),ts=c(e),Jt=o(e,"P",{}),f(Jt).forEach(t),this.h()},h(){m(i,"name","hf:doc:metadata"),m(i,"content",JSON.stringify(Oo)),m(r,"id","videomae"),m(r,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(r,"href","#videomae"),m(T,"class","relative group"),m(Y,"id","overview"),m(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Y,"href","#overview"),m(W,"class","relative group"),zo(P.src,eo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/videomae_architecture.jpeg")||m(P,"src",eo),m(P,"alt","drawing"),m(P,"width","600"),m(Q,"id","resources"),m(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Q,"href","#resources"),m($,"class","relative group"),m(H,"id","transformers.VideoMAEConfig"),m(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(H,"href","#transformers.VideoMAEConfig"),m(B,"class","relative group"),m(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(D,"id","transformers.VideoMAEFeatureExtractor"),m(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(D,"href","#transformers.VideoMAEFeatureExtractor"),m(G,"class","relative group"),m(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(K,"id","transformers.VideoMAEImageProcessor"),m(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(K,"href","#transformers.VideoMAEImageProcessor"),m(z,"class","relative group"),m(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ee,"id","transformers.VideoMAEModel"),m(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ee,"href","#transformers.VideoMAEModel"),m(N,"class","relative group"),m(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(oe,"id","transformers.VideoMAEForPreTraining"),m(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(oe,"href","#transformers.VideoMAEForPreTraining"),m(S,"class","relative group"),m(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(re,"id","transformers.VideoMAEForVideoClassification"),m(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(re,"href","#transformers.VideoMAEForVideoClassification"),m(R,"class","relative group"),m(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){a(document.head,i),l(e,v,n),l(e,p,n),l(e,h,n),l(e,T,n),a(T,r),a(r,j),_(he,j,null),a(T,fs),a(T,Qe),l(e,Et,n),l(e,W,n),a(W,Y),a(Y,Mt),_(fe,Mt,null),a(W,us),a(W,He),l(e,At,n),l(e,ue,n),l(e,Zt,n),l(e,ge,n),l(e,xt,n),l(e,Me,n),l(e,kt,n),l(e,_e,n),l(e,Wt,n),l(e,ye,n),l(e,$t,n),l(e,P,n),l(e,Bt,n),l(e,we,n),l(e,Gt,n),l(e,be,n),l(e,Ft,n),l(e,$,n),a($,Q),a(Q,_t),_(Te,_t,null),a($,gs),a($,Le),l(e,zt,n),l(e,ve,n),l(e,Nt,n),l(e,je,n),l(e,St,n),l(e,Je,n),l(e,Rt,n),l(e,B,n),a(B,H),a(H,yt),_(Ue,yt,null),a(B,Ms),a(B,De),l(e,Xt,n),l(e,U,n),_(Ce,U,null),a(U,_s),a(U,qe),a(U,ys),a(U,Ke),a(U,ws),_(L,U,null),l(e,Yt,n),l(e,G,n),a(G,D),a(D,wt),_(Ve,wt,null),a(G,bs),a(G,Oe),l(e,Pt,n),l(e,F,n),_(Ie,F,null),a(F,Ts),a(F,q),_(Ee,q,null),a(q,vs),a(q,et),l(e,Qt,n),l(e,z,n),a(z,K),a(K,bt),_(Ae,bt,null),a(z,js),a(z,tt),l(e,Ht,n),l(e,E,n),_(Ze,E,null),a(E,Js),a(E,st),a(E,Us),a(E,O),_(xe,O,null),a(O,Cs),a(O,ot),l(e,Lt,n),l(e,N,n),a(N,ee),a(ee,Tt),_(ke,Tt,null),a(N,Vs),a(N,at),l(e,Dt,n),l(e,A,n),_(We,A,null),a(A,Is),a(A,nt),a(A,Es),a(A,C),_($e,C,null),a(C,As),a(C,rt),a(C,Zs),_(te,C,null),a(C,xs),_(se,C,null),l(e,qt,n),l(e,S,n),a(S,oe),a(oe,vt),_(Be,vt,null),a(S,ks),a(S,lt),l(e,Kt,n),l(e,Z,n),_(Ge,Z,null),a(Z,Ws),a(Z,it),a(Z,$s),a(Z,V),_(Fe,V,null),a(V,Bs),a(V,dt),a(V,Gs),_(ae,V,null),a(V,Fs),_(ne,V,null),l(e,Ot,n),l(e,R,n),a(R,re),a(re,jt),_(ze,jt,null),a(R,zs),a(R,ct),l(e,es,n),l(e,x,n),_(Ne,x,null),a(x,Ns),a(x,mt),a(x,Ss),a(x,I),_(Se,I,null),a(I,Rs),a(I,pt),a(I,Xs),_(le,I,null),a(I,Ys),_(ie,I,null),l(e,ts,n),l(e,Jt,n),ss=!0},p(e,[n]){const Re={};n&2&&(Re.$$scope={dirty:n,ctx:e}),L.$set(Re);const Ut={};n&2&&(Ut.$$scope={dirty:n,ctx:e}),te.$set(Ut);const Ct={};n&2&&(Ct.$$scope={dirty:n,ctx:e}),se.$set(Ct);const Xe={};n&2&&(Xe.$$scope={dirty:n,ctx:e}),ae.$set(Xe);const Vt={};n&2&&(Vt.$$scope={dirty:n,ctx:e}),ne.$set(Vt);const It={};n&2&&(It.$$scope={dirty:n,ctx:e}),le.$set(It);const Ye={};n&2&&(Ye.$$scope={dirty:n,ctx:e}),ie.$set(Ye)},i(e){ss||(y(he.$$.fragment,e),y(fe.$$.fragment,e),y(Te.$$.fragment,e),y(Ue.$$.fragment,e),y(Ce.$$.fragment,e),y(L.$$.fragment,e),y(Ve.$$.fragment,e),y(Ie.$$.fragment,e),y(Ee.$$.fragment,e),y(Ae.$$.fragment,e),y(Ze.$$.fragment,e),y(xe.$$.fragment,e),y(ke.$$.fragment,e),y(We.$$.fragment,e),y($e.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(Be.$$.fragment,e),y(Ge.$$.fragment,e),y(Fe.$$.fragment,e),y(ae.$$.fragment,e),y(ne.$$.fragment,e),y(ze.$$.fragment,e),y(Ne.$$.fragment,e),y(Se.$$.fragment,e),y(le.$$.fragment,e),y(ie.$$.fragment,e),ss=!0)},o(e){w(he.$$.fragment,e),w(fe.$$.fragment,e),w(Te.$$.fragment,e),w(Ue.$$.fragment,e),w(Ce.$$.fragment,e),w(L.$$.fragment,e),w(Ve.$$.fragment,e),w(Ie.$$.fragment,e),w(Ee.$$.fragment,e),w(Ae.$$.fragment,e),w(Ze.$$.fragment,e),w(xe.$$.fragment,e),w(ke.$$.fragment,e),w(We.$$.fragment,e),w($e.$$.fragment,e),w(te.$$.fragment,e),w(se.$$.fragment,e),w(Be.$$.fragment,e),w(Ge.$$.fragment,e),w(Fe.$$.fragment,e),w(ae.$$.fragment,e),w(ne.$$.fragment,e),w(ze.$$.fragment,e),w(Ne.$$.fragment,e),w(Se.$$.fragment,e),w(le.$$.fragment,e),w(ie.$$.fragment,e),ss=!1},d(e){e&&(t(v),t(p),t(h),t(T),t(Et),t(W),t(At),t(ue),t(Zt),t(ge),t(xt),t(Me),t(kt),t(_e),t(Wt),t(ye),t($t),t(P),t(Bt),t(we),t(Gt),t(be),t(Ft),t($),t(zt),t(ve),t(Nt),t(je),t(St),t(Je),t(Rt),t(B),t(Xt),t(U),t(Yt),t(G),t(Pt),t(F),t(Qt),t(z),t(Ht),t(E),t(Lt),t(N),t(Dt),t(A),t(qt),t(S),t(Kt),t(Z),t(Ot),t(R),t(es),t(x),t(ts),t(Jt)),t(i),b(he),b(fe),b(Te),b(Ue),b(Ce),b(L),b(Ve),b(Ie),b(Ee),b(Ae),b(Ze),b(xe),b(ke),b(We),b($e),b(te),b(se),b(Be),b(Ge),b(Fe),b(ae),b(ne),b(ze),b(Ne),b(Se),b(le),b(ie)}}}const Oo={local:"videomae",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.VideoMAEConfig",title:"VideoMAEConfig"},{local:"transformers.VideoMAEFeatureExtractor",title:"VideoMAEFeatureExtractor"},{local:"transformers.VideoMAEImageProcessor",title:"VideoMAEImageProcessor"},{local:"transformers.VideoMAEModel",title:"VideoMAEModel"},{local:"transformers.VideoMAEForPreTraining",title:"VideoMAEForPreTraining"},{local:"transformers.VideoMAEForVideoClassification",title:"VideoMAEForVideoClassification"}],title:"VideoMAE"};function ea(J){return No(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ia extends So{constructor(i){super(),Ro(this,i,ea,Ko,Fo,{})}}export{ia as component};
