import{s as Ye,o as Fe,n as ze}from"../chunks/scheduler.69131cc3.js";import{S as He,i as Ne,g as r,s as a,r as p,A as Re,h as c,f as s,c as n,j as Ae,u as d,x as f,k as Xe,y as Qe,a as l,v as h,d as m,t as y,w as M}from"../chunks/index.e1f30d73.js";import{T as We}from"../chunks/Tip.22e79575.js";import{C as S}from"../chunks/CodeBlock.30cef355.js";import{H as q}from"../chunks/Heading.0aab6758.js";function Se(V){let i,u=`Some of these are utilized with the <a href="/docs/accelerate/v0.26.1/en/package_reference/accelerator#accelerate.Accelerator.main_process_first">main_process_first()</a> context manager, which utilizes <a href="/docs/accelerate/v0.26.1/en/package_reference/accelerator#accelerate.Accelerator.wait_for_everyone">wait_for_everyone()</a> to
run a particular set of code on the main process beforehand before triggering and launching the other processes`;return{c(){i=r("p"),i.innerHTML=u},l(o){i=c(o,"P",{"data-svelte-h":!0}),f(i)!=="svelte-1dw96lg"&&(i.innerHTML=u)},m(o,w){l(o,i,w)},p:ze,d(o){o&&s(i)}}}function Ve(V){let i,u=`<code>load_dataset</code> will perform a lock under the hood to stop multiple downloads from happening at once, but if you are downloading something
not using this library you should use this method.`;return{c(){i=r("p"),i.innerHTML=u},l(o){i=c(o,"P",{"data-svelte-h":!0}),f(i)!=="svelte-909il1"&&(i.innerHTML=u)},m(o,w){l(o,i,w)},p:ze,d(o){o&&s(i)}}}function qe(V){let i,u,o,w,U,L,T,Te=`When you run your usual script, instructions are executed in order. Using 🤗 Accelerate to deploy your script on several
GPUs at the same time introduces a complication: while each process executes all instructions in order, some may be
faster than others.`,P,j,je=`You might need to wait for all processes to have reached a certain point before executing a given instruction. For
instance, you shouldn’t save a model before being sure every process is done with training, and you wouldn’t want to
continue training before all the model weights have been loaded in. To do this, just write the following line in your code:`,K,J,D,C,Je=`This instruction will block all the processes that arrive first until all the other processes have reached that
point (if you run your script on just one GPU or CPU, this won’t do anything).`,O,_,Ce="A few example cases of when to use this utility are listed below:",ee,g,te,b,se,I,_e="When downloading a dataset, you should download it first on the main process and then load the cached dataset afterward",le,$,ae,v,ne,k,be="Under the hood this is the same as calling:",ie,G,oe,Z,re,B,Ie=`When saving the <code>state_dict</code> of the model, since you would normally save one file on just the main process
you should specify that:`,ce,x,pe,A,de,X,ve=`When loading in the <code>state_dict</code> to a model, optimizer, or scheduler, you should wait
for all workers to have the weights loaded in before moving on to training`,he,W,me,z,ye,Y,ke=`Applying a <code>map()</code> operation on multiple workers, such as tokenizing should be done on the
main process first, and then propagated to each one.`,Me,F,fe,H,ue,N,Ge=`To have a check that works with a flag set by a particular process, the <code>set_trigger</code> and <code>check_trigger</code> API should be used. Useful examples
for doing so can include situations such as using early stopping and monitoring the loss (as each loss slightly differs on each process).`,we,R,Ze='Call <a href="/docs/accelerate/v0.26.1/en/package_reference/accelerator#accelerate.Accelerator.set_trigger">Accelerator.set_trigger()</a> when your condition has been met, and <a href="/docs/accelerate/v0.26.1/en/package_reference/accelerator#accelerate.Accelerator.check_trigger">Accelerator.check_trigger()</a> when checking if that condition has been met in any process:',ge,Q,$e,E,Ue;return U=new q({props:{title:"Deferring Executions",local:"deferring-executions",headingTag:"h1"}}),J=new S({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKQ==",highlighted:'accelerator.wait<span class="hljs-constructor">_for_everyone()</span>',wrap:!1}}),g=new We({props:{$$slots:{default:[Se]},$$scope:{ctx:V}}}),b=new q({props:{title:"Downloading a Dataset",local:"downloading-a-dataset",headingTag:"h2"}}),$=new We({props:{$$slots:{default:[Ve]},$$scope:{ctx:V}}}),v=new S({props:{code:"d2l0aCUyMGFjY2VsZXJhdG9yLm1haW5fcHJvY2Vzc19maXJzdCgpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZ2x1ZSUyMiUyQyUyMCUyMm1ycGMlMjIp",highlighted:`<span class="hljs-keyword">with</span> accelerator.main_process_first():
    datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)`,wrap:!1}}),G=new S({props:{code:"JTIzJTIwRmlyc3QlMjBkbyUyMHNvbWV0aGluZyUyMG9uJTIwdGhlJTIwbWFpbiUyMHByb2Nlc3MlMEFpZiUyMGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUzQSUwQSUyMCUyMCUyMCUyMGRhdGFzZXRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci53YWl0X2Zvcl9ldmVyeW9uZSgpJTBBJTBBJTIzJTIwQW5kJTIwdGhlbiUyMHNlbmQlMjBpdCUyMHRvJTIwdGhlJTIwcmVzdCUyMG9mJTIwdGhlbSUwQWlmJTIwbm90JTIwYWNjZWxlcmF0b3IuaXNfbWFpbl9wcm9jZXNzJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZ2x1ZSUyMiUyQyUyMCUyMm1ycGMlMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLndhaXRfZm9yX2V2ZXJ5b25lKCk=",highlighted:`<span class="hljs-comment"># First do something on the main process</span>
<span class="hljs-keyword">if</span> accelerator.is_main_process:
    datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
<span class="hljs-keyword">else</span>:
    accelerator.wait_for_everyone()

<span class="hljs-comment"># And then send it to the rest of them</span>
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> accelerator.is_main_process:
    datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
<span class="hljs-keyword">else</span>:
    accelerator.wait_for_everyone()`,wrap:!1}}),Z=new q({props:{title:"Saving the state_dict",local:"saving-the-statedict",headingTag:"h2"}}),x=new S({props:{code:"aWYlMjBhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEElMjAlMjAlMjAlMjB0b3JjaC5zYXZlKG1vZGVsLnN0YXRlX2RpY3QoKSUyQyUyMCUyMndlaWdodHMucHRoJTIyKQ==",highlighted:`<span class="hljs-keyword">if</span> accelerator.is_main_process:
    model = accelerator.unwrap_model(model)
    torch.save(model.state_dict(), <span class="hljs-string">&quot;weights.pth&quot;</span>)`,wrap:!1}}),A=new q({props:{title:"Loading in the state_dict",local:"loading-in-the-statedict",headingTag:"h2"}}),W=new S({props:{code:"d2l0aCUyMGFjY2VsZXJhdG9yLm1haW5fcHJvY2Vzc19maXJzdCgpJTNBJTBBJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjB0b3JjaC5sb2FkKCUyMndlaWdodHMucHRoJTIyKSUwQSUyMCUyMCUyMCUyMG1vZGVsLmxvYWRfc3RhdGVfZGljdChzdGF0ZSk=",highlighted:`<span class="hljs-keyword">with</span> accelerator.main_process_first():
    state = torch.load(<span class="hljs-string">&quot;weights.pth&quot;</span>)
    model.load_state_dict(state)`,wrap:!1}}),z=new q({props:{title:"Applying a multi-worker CPU operation",local:"applying-a-multi-worker-cpu-operation",headingTag:"h2"}}),F=new S({props:{code:"ZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZ2x1ZSUyMiUyQyUyMCUyMm1ycGMlMjIpJTBBJTBBd2l0aCUyMGFjY2VsZXJhdG9yLm1haW5fcHJvY2Vzc19maXJzdCgpJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldHMubWFwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuaXplX2Z1bmN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMmlkeCUyMiUyQyUyMCUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCk=",highlighted:`datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)

<span class="hljs-keyword">with</span> accelerator.main_process_first():
    tokenized_datasets = datasets.<span class="hljs-built_in">map</span>(
        tokenize_function,
        batched=<span class="hljs-literal">True</span>,
        remove_columns=[<span class="hljs-string">&quot;idx&quot;</span>, <span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>],
    )`,wrap:!1}}),H=new q({props:{title:"Applying checks such as Early Stopping",local:"applying-checks-such-as-early-stopping",headingTag:"h2"}}),Q=new S({props:{code:"Zm9yJTIwKHglMkN5KSUyMGluJTIwZGF0YV9sb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCh4KSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMobG9naXRzJTJDJTIweSklMEElMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWUlMjAlNjBzaG91bGRfZG9fZWFybHlfc3RvcHBpbmclNjAlMjBpcyUyMGElMjBjdXN0b20lMjBkZWZpbmVkJTIwZnVuY3Rpb24lMjB0aGF0JTIwcmV0dXJucyUyMGElMjBjb25kaXRpb25hbCUwQSUyMCUyMCUyMCUyMGlmJTIwc2hvdWxkX2RvX2Vhcmx5X3N0b3BwaW5nKGxvc3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3Iuc2V0X3RyaWdnZXIoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMExhdGVyJTIwaW4lMjB0aGUlMjB0cmFpbmluZyUyMHNjcmlwdCUyMHdoZW4lMjB3ZSUyMG5lZWQlMjB0byUyMGNoZWNrJTIwZm9yJTIwdGhlJTIwYnJlYWtwb2ludCUwQSUyMCUyMCUyMCUyMGlmJTIwYWNjZWxlcmF0b3IuY2hlY2tfdHJpZ2dlcigpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-keyword">for</span> (x,y) <span class="hljs-keyword">in</span> data_loader:
    logits = model(x)
    loss = loss_func(logits, y)
    <span class="hljs-comment"># Assume \`should_do_early_stopping\` is a custom defined function that returns a conditional</span>
    <span class="hljs-keyword">if</span> should_do_early_stopping(loss):
        accelerator.set_trigger()

    <span class="hljs-comment"># Later in the training script when we need to check for the breakpoint</span>
    <span class="hljs-keyword">if</span> accelerator.check_trigger():
        <span class="hljs-keyword">break</span>`,wrap:!1}}),{c(){i=r("meta"),u=a(),o=r("p"),w=a(),p(U.$$.fragment),L=a(),T=r("p"),T.textContent=Te,P=a(),j=r("p"),j.textContent=je,K=a(),p(J.$$.fragment),D=a(),C=r("p"),C.textContent=Je,O=a(),_=r("p"),_.textContent=Ce,ee=a(),p(g.$$.fragment),te=a(),p(b.$$.fragment),se=a(),I=r("p"),I.textContent=_e,le=a(),p($.$$.fragment),ae=a(),p(v.$$.fragment),ne=a(),k=r("p"),k.textContent=be,ie=a(),p(G.$$.fragment),oe=a(),p(Z.$$.fragment),re=a(),B=r("p"),B.innerHTML=Ie,ce=a(),p(x.$$.fragment),pe=a(),p(A.$$.fragment),de=a(),X=r("p"),X.innerHTML=ve,he=a(),p(W.$$.fragment),me=a(),p(z.$$.fragment),ye=a(),Y=r("p"),Y.innerHTML=ke,Me=a(),p(F.$$.fragment),fe=a(),p(H.$$.fragment),ue=a(),N=r("p"),N.innerHTML=Ge,we=a(),R=r("p"),R.innerHTML=Ze,ge=a(),p(Q.$$.fragment),$e=a(),E=r("p"),this.h()},l(e){const t=Re("svelte-u9bgzb",document.head);i=c(t,"META",{name:!0,content:!0}),t.forEach(s),u=n(e),o=c(e,"P",{}),Ae(o).forEach(s),w=n(e),d(U.$$.fragment,e),L=n(e),T=c(e,"P",{"data-svelte-h":!0}),f(T)!=="svelte-ddezg0"&&(T.textContent=Te),P=n(e),j=c(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-15mf0bm"&&(j.textContent=je),K=n(e),d(J.$$.fragment,e),D=n(e),C=c(e,"P",{"data-svelte-h":!0}),f(C)!=="svelte-19k5yf4"&&(C.textContent=Je),O=n(e),_=c(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-8u19qz"&&(_.textContent=Ce),ee=n(e),d(g.$$.fragment,e),te=n(e),d(b.$$.fragment,e),se=n(e),I=c(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-g4t7z"&&(I.textContent=_e),le=n(e),d($.$$.fragment,e),ae=n(e),d(v.$$.fragment,e),ne=n(e),k=c(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-mg8wl6"&&(k.textContent=be),ie=n(e),d(G.$$.fragment,e),oe=n(e),d(Z.$$.fragment,e),re=n(e),B=c(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-gpwub8"&&(B.innerHTML=Ie),ce=n(e),d(x.$$.fragment,e),pe=n(e),d(A.$$.fragment,e),de=n(e),X=c(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-yeso4z"&&(X.innerHTML=ve),he=n(e),d(W.$$.fragment,e),me=n(e),d(z.$$.fragment,e),ye=n(e),Y=c(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-n7gycq"&&(Y.innerHTML=ke),Me=n(e),d(F.$$.fragment,e),fe=n(e),d(H.$$.fragment,e),ue=n(e),N=c(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-j7zjkt"&&(N.innerHTML=Ge),we=n(e),R=c(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-1atxh3k"&&(R.innerHTML=Ze),ge=n(e),d(Q.$$.fragment,e),$e=n(e),E=c(e,"P",{}),Ae(E).forEach(s),this.h()},h(){Xe(i,"name","hf:doc:metadata"),Xe(i,"content",Ee)},m(e,t){Qe(document.head,i),l(e,u,t),l(e,o,t),l(e,w,t),h(U,e,t),l(e,L,t),l(e,T,t),l(e,P,t),l(e,j,t),l(e,K,t),h(J,e,t),l(e,D,t),l(e,C,t),l(e,O,t),l(e,_,t),l(e,ee,t),h(g,e,t),l(e,te,t),h(b,e,t),l(e,se,t),l(e,I,t),l(e,le,t),h($,e,t),l(e,ae,t),h(v,e,t),l(e,ne,t),l(e,k,t),l(e,ie,t),h(G,e,t),l(e,oe,t),h(Z,e,t),l(e,re,t),l(e,B,t),l(e,ce,t),h(x,e,t),l(e,pe,t),h(A,e,t),l(e,de,t),l(e,X,t),l(e,he,t),h(W,e,t),l(e,me,t),h(z,e,t),l(e,ye,t),l(e,Y,t),l(e,Me,t),h(F,e,t),l(e,fe,t),h(H,e,t),l(e,ue,t),l(e,N,t),l(e,we,t),l(e,R,t),l(e,ge,t),h(Q,e,t),l(e,$e,t),l(e,E,t),Ue=!0},p(e,[t]){const Be={};t&2&&(Be.$$scope={dirty:t,ctx:e}),g.$set(Be);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),$.$set(xe)},i(e){Ue||(m(U.$$.fragment,e),m(J.$$.fragment,e),m(g.$$.fragment,e),m(b.$$.fragment,e),m($.$$.fragment,e),m(v.$$.fragment,e),m(G.$$.fragment,e),m(Z.$$.fragment,e),m(x.$$.fragment,e),m(A.$$.fragment,e),m(W.$$.fragment,e),m(z.$$.fragment,e),m(F.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),Ue=!0)},o(e){y(U.$$.fragment,e),y(J.$$.fragment,e),y(g.$$.fragment,e),y(b.$$.fragment,e),y($.$$.fragment,e),y(v.$$.fragment,e),y(G.$$.fragment,e),y(Z.$$.fragment,e),y(x.$$.fragment,e),y(A.$$.fragment,e),y(W.$$.fragment,e),y(z.$$.fragment,e),y(F.$$.fragment,e),y(H.$$.fragment,e),y(Q.$$.fragment,e),Ue=!1},d(e){e&&(s(u),s(o),s(w),s(L),s(T),s(P),s(j),s(K),s(D),s(C),s(O),s(_),s(ee),s(te),s(se),s(I),s(le),s(ae),s(ne),s(k),s(ie),s(oe),s(re),s(B),s(ce),s(pe),s(de),s(X),s(he),s(me),s(ye),s(Y),s(Me),s(fe),s(ue),s(N),s(we),s(R),s(ge),s($e),s(E)),s(i),M(U,e),M(J,e),M(g,e),M(b,e),M($,e),M(v,e),M(G,e),M(Z,e),M(x,e),M(A,e),M(W,e),M(z,e),M(F,e),M(H,e),M(Q,e)}}}const Ee='{"title":"Deferring Executions","local":"deferring-executions","sections":[{"title":"Downloading a Dataset","local":"downloading-a-dataset","sections":[],"depth":2},{"title":"Saving the state_dict","local":"saving-the-statedict","sections":[],"depth":2},{"title":"Loading in the state_dict","local":"loading-in-the-statedict","sections":[],"depth":2},{"title":"Applying a multi-worker CPU operation","local":"applying-a-multi-worker-cpu-operation","sections":[],"depth":2},{"title":"Applying checks such as Early Stopping","local":"applying-checks-such-as-early-stopping","sections":[],"depth":2}],"depth":1}';function Le(V){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tt extends He{constructor(i){super(),Ne(this,i,Le,qe,Ye,{})}}export{tt as component};
