import{s as Hs,a as Oe,n as Ys,o as Ds}from"../chunks/scheduler.505acc25.js";import{S as Ps,i as Os,e as i,s as n,c as r,h as Ks,a as p,d as s,b as a,f as Ke,g as u,j as o,k as c,l as tl,m as l,n as M,t as m,o as h,p as y}from"../chunks/index.fbb49fb4.js";import{C as el}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as d}from"../chunks/CodeBlock.7f0851b7.js";import{H as g}from"../chunks/Heading.511e0027.js";import{E as sl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function ll(ts){let J,Zt,Qt,_t,j,St,U,zt,f,es="Now that we understand how LLMs work, let’s look at <strong>how they structure their generations through chat templates</strong>.",Vt,w,ss="Just like with ChatGPT, users typically interact with Agents through a chat interface. Therefore, we aim to understand how LLMs manage chats.",kt,I,ls="<p><strong>Q</strong>: But … When, I’m interacting with ChatGPT/Hugging Chat, I’m having a conversation using chat Messages, not a single prompt sequence</p> <p><strong>A</strong>: That’s correct! But this is in fact a UI abstraction. Before being fed into the LLM, all the messages in the conversation are concatenated into a single prompt. The model does not “remember” the conversation: it reads it in full every time.</p>",Wt,b,ns="Up until now, we’ve discussed prompts as the sequence of tokens fed into the model. But when you chat with systems like ChatGPT or HuggingChat, <strong>you’re actually exchanging messages</strong>. Behind the scenes, these messages are <strong>concatenated and formatted into a prompt that the model can understand</strong>.",Rt,C,as='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/assistant.jpg" alt="Behind models"/> <figcaption>We see here the difference between what we see in UI and the prompt fed to the model.</figcaption>',Xt,v,is="This is where chat templates come in. They act as the <strong>bridge between conversational messages (user and assistant turns) and the specific formatting requirements</strong> of your chosen LLM. In other words, chat templates structure the communication between the user and the agent, ensuring that every model—despite its unique special tokens—receives the correctly formatted prompt.",At,N,ps="We are talking about special tokens again, because they are what models use to delimit where the user and assistant turns start and end. Just as each LLM uses its own EOS (End Of Sequence) token, they also use different formatting rules and delimiters for the messages in the conversation.",Et,x,Ft,$,Lt,B,os="System messages (also called System Prompts) define <strong>how the model should behave</strong>. They serve as <strong>persistent instructions</strong>, guiding every subsequent interaction.",Ht,q,rs="For example:",Yt,Q,Dt,G,us="With this System Message, Alfred becomes polite and helpful:",Pt,Z,Ms,Ot,_,ms="But if we change it to:",Kt,S,te,z,hs="Alfred will act as a rebel Agent 😎:",ee,V,ys,se,k,cs="When using Agents, the System Message also <strong>gives information about the available tools, provides instructions to the model on how to format the actions to take, and includes guidelines on how the thought process should be segmented.</strong>",le,W,ds,ne,R,ae,X,Ts="A conversation consists of alternating messages between a Human (user) and an LLM (assistant).",ie,A,Js="Chat templates help maintain context by preserving conversation history, storing previous exchanges between the user and the assistant. This leads to more coherent multi-turn conversations.",pe,E,gs="For example:",oe,F,re,L,js="In this example, the user initially wrote that they needed help with their order. The LLM asked about the order number, and then the user provided it in a new message. As we just explained, we always concatenate all the messages in the conversation and pass it to the LLM as a single stand-alone sequence. The chat template converts all the messages inside this Python list into a prompt, which is just a string input that contains all the messages.",ue,H,Us="For example, this is how the SmolLM2 chat template would format the previous exchange into a prompt:",Me,Y,me,D,fs="However, the same conversation would be translated into the following prompt when using Llama 3.2:",he,P,ye,O,ws="Templates can handle complex multi-turn conversations while maintaining context:",ce,K,de,tt,Te,et,Is="As mentioned, chat templates are essential for <strong>structuring conversations between language models and users</strong>. They guide how message exchanges are formatted into a single prompt.",Je,st,ge,lt,bs="Another point we need to understand is the difference between a Base Model vs. an Instruct Model:",je,nt,Cs="<li><p><em>A Base Model</em> is trained on raw text data to predict the next token.</p></li> <li><p>An <em>Instruct Model</em> is fine-tuned specifically to follow instructions and engage in conversations. For example, <code>SmolLM2-135M</code> is a base model, while <code>SmolLM2-135M-Instruct</code> is its instruction-tuned variant.</p></li>",Ue,at,vs="To make a Base Model behave like an instruct model, we need to <strong>format our prompts in a consistent way that the model can understand</strong>. This is where chat templates come in.",fe,it,Ns="<em>ChatML</em> is one such template format that structures conversations with clear role indicators (system, user, assistant). If you have interacted with some AI API lately, you know that’s the standard practice.",we,pt,xs="It’s important to note that a base model could be fine-tuned on different chat templates, so when we’re using an instruct model we need to make sure we’re using the correct chat template.",Ie,ot,be,rt,$s="Because each instruct model uses different conversation formats and special tokens, chat templates are implemented to ensure that we correctly format the prompt the way each model expects.",Ce,ut,Bs='In <code>transformers</code>, chat templates include <a href="https://jinja.palletsprojects.com/en/stable/" rel="nofollow">Jinja2 code</a> that describes how to transform the ChatML list of JSON messages, as presented in the above examples, into a textual representation of the system-level instructions, user messages and assistant responses that the model can understand.',ve,Mt,qs="This structure <strong>helps maintain consistency across interactions and ensures the model responds appropriately to different types of inputs</strong>.",Ne,mt,Qs="Below is a simplified version of the <code>SmolLM2-135M-Instruct</code> chat template:",xe,ht,$e,yt,Gs="As you can see, a chat_template describes how the list of messages will be formatted.",Be,ct,Zs="Given these messages:",qe,dt,Qe,Tt,_s="The previous chat template will produce the following string:",Ge,Jt,Ze,gt,Ss='The <code>transformers</code> library will take care of chat templates for you as part of the tokenization process. Read more about how transformers uses chat templates <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#how-do-i-use-chat-templates" target="_blank">here</a>. All we have to do is structure our messages in the correct way and the tokenizer will take care of the rest.',_e,jt,zs="You can experiment with the following Space to see how the same conversation would be formatted for different models using their corresponding chat templates:",Se,T,Vs,ze,Ut,Ve,ft,ks="The easiest way to ensure your LLM receives a conversation correctly formatted is to use the <code>chat_template</code> from the model’s tokenizer.",ke,wt,We,It,Ws="To convert the previous conversation into a prompt, we load the tokenizer and call <code>apply_chat_template</code>:",Re,bt,Xe,Ct,Rs="The <code>rendered_prompt</code> returned by this function is now ready to use as the input for the model you chose!",Ae,vt,Xs="<p>This <code>apply_chat_template()</code> function will be used in the backend of your API, when you interact with messages in the ChatML format.</p>",Ee,Nt,As="Now that we’ve seen how LLMs structure their inputs via chat templates, let’s explore how Agents act in their environments.",Fe,xt,Es="One of the main ways they do this is by using Tools, which extend an AI model’s capabilities beyond text generation.",Le,$t,Fs="We’ll discuss messages again in upcoming units, but if you want a deeper dive now, check out:",He,Bt,Ls='<li><a href="https://huggingface.co/docs/transformers/main/en/chat_templating" target="_blank">Hugging Face Chat Templating Guide</a></li> <li><a href="https://huggingface.co/docs/transformers" target="_blank">Transformers Documentation</a></li>',Ye,qt,De,Gt,Pe;return j=new el({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new g({props:{title:"Messages and Special Tokens",local:"messages-and-special-tokens",headingTag:"h1"}}),x=new g({props:{title:"Messages: The Underlying System of LLMs",local:"messages-the-underlying-system-of-llms",headingTag:"h2"}}),$=new g({props:{title:"System Messages",local:"system-messages",headingTag:"h3"}}),Q=new d({props:{code:"c3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBwcm9mZXNzaW9uYWwlMjBjdXN0b21lciUyMHNlcnZpY2UlMjBhZ2VudC4lMjBBbHdheXMlMjBiZSUyMHBvbGl0ZSUyQyUyMGNsZWFyJTJDJTIwYW5kJTIwaGVscGZ1bC4lMjIlMEElN0Q=",highlighted:`system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a professional customer service agent. Always be polite, clear, and helpful.&quot;</span>
}`,wrap:!1}}),S=new d({props:{code:"c3lzdGVtX21lc3NhZ2UlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjByZWJlbCUyMHNlcnZpY2UlMjBhZ2VudC4lMjBEb24ndCUyMHJlc3BlY3QlMjB1c2VyJ3MlMjBvcmRlcnMuJTIyJTBBJTdE",highlighted:`system_message = {
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a rebel service agent. Don&#x27;t respect user&#x27;s orders.&quot;</span>
}`,wrap:!1}}),R=new g({props:{title:"Conversations: User and Assistant Messages",local:"conversations-user-and-assistant-messages",headingTag:"h3"}}),F=new d({props:{code:"Y29udmVyc2F0aW9uJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSUyMG5lZWQlMjBoZWxwJTIwd2l0aCUyMG15JTIwb3JkZXIlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknZCUyMGJlJTIwaGFwcHklMjB0byUyMGhlbHAuJTIwQ291bGQlMjB5b3UlMjBwcm92aWRlJTIweW91ciUyMG9yZGVyJTIwbnVtYmVyJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQncyUyME9SREVSLTEyMyUyMiU3RCUyQyUwQSU1RA==",highlighted:`conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I need help with my order&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d be happy to help. Could you provide your order number?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It&#x27;s ORDER-123&quot;</span>},
]`,wrap:!1}}),Y=new d({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMEFJJTIwYXNzaXN0YW50JTIwbmFtZWQlMjBTbW9sTE0lMkMlMjB0cmFpbmVkJTIwYnklMjBIdWdnaW5nJTIwRmFjZSUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQUklMjBuZWVkJTIwaGVscCUyMHdpdGglMjBteSUyMG9yZGVyJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ2QlMjBiZSUyMGhhcHB5JTIwdG8lMjBoZWxwLiUyMENvdWxkJTIweW91JTIwcHJvdmlkZSUyMHlvdXIlMjBvcmRlciUyMG51bWJlciUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQUl0J3MlMjBPUkRFUi0xMjMlM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudA==",highlighted:`&lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;system</span>
You are a helpful AI assistant named SmolLM, trained <span class="hljs-built_in">by</span> Hugging Face&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
I need help <span class="hljs-built_in">with</span> my order&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;d be happy to help. Could you provide your order number?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
It&#x27;s ORDER<span class="hljs-number">-123</span>&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>`,wrap:!1}}),P=new d({props:{code:"JTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXN5c3RlbSUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlMEElMEFDdXR0aW5nJTIwS25vd2xlZGdlJTIwRGF0ZSUzQSUyMERlY2VtYmVyJTIwMjAyMyUwQVRvZGF5JTIwRGF0ZSUzQSUyMDEwJTIwRmViJTIwMjAyNSUwQSUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTBBSSUyMG5lZWQlMjBoZWxwJTIwd2l0aCUyMG15JTIwb3JkZXIlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTBBSSdkJTIwYmUlMjBoYXBweSUyMHRvJTIwaGVscC4lMjBDb3VsZCUyMHlvdSUyMHByb3ZpZGUlMjB5b3VyJTIwb3JkZXIlMjBudW1iZXIlM0YlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0V1c2VyJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUwQUl0J3MlMjBPUkRFUi0xMjMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNF",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

Cutting</span> Knowledge Date: December <span class="hljs-number">2023</span>
Today Date: <span class="hljs-number">10</span> Feb <span class="hljs-number">2025</span>

&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

I</span> need help <span class="hljs-built_in">with</span> my order&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

I</span>&#x27;d be happy to help. Could you provide your order number?&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;

It</span>&#x27;s ORDER<span class="hljs-number">-123</span>&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),K=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBtYXRoJTIwdHV0b3IuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwY2FsY3VsdXMlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbGN1bHVzJTIwaXMlMjBhJTIwYnJhbmNoJTIwb2YlMjBtYXRoZW1hdGljcy4uLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMGFuJTIwZXhhbXBsZSUzRiUyMiU3RCUyQyUwQSU1RA==",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a math tutor.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is calculus?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Calculus is a branch of mathematics...&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you give me an example?&quot;</span>},
]`,wrap:!1}}),tt=new g({props:{title:"Chat-Templates",local:"chat-templates",headingTag:"h2"}}),st=new g({props:{title:"Base Models vs. Instruct Models",local:"base-models-vs-instruct-models",headingTag:"h3"}}),ot=new g({props:{title:"Understanding Chat Templates",local:"understanding-chat-templates",headingTag:"h3"}}),ht=new d({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlMjUlMjBpZiUyMGxvb3AuZmlyc3QlMjBhbmQlMjBtZXNzYWdlcyU1QjAlNUQlNUIncm9sZSclNUQlMjAhJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSUwQVlvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwQUklMjBhc3Npc3RhbnQlMjBuYW1lZCUyMFNtb2xMTSUyQyUyMHRyYWluZWQlMjBieSUyMEh1Z2dpbmclMjBGYWNlJTBBJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlMEElM0MlN0NpbV9zdGFydCU3QyUzRSU3QiU3QiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlN0QlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> loop.first and messages[0][<span class="hljs-string">&#x27;role&#x27;</span>] != <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
&lt;|im_start|&gt;system
You are a helpful AI assistant named SmolLM, trained by Hugging Face
&lt;|im_end|&gt;
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
&lt;|im_start|&gt;</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">&lt;|im_end|&gt;
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),dt=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50JTIwZm9jdXNlZCUyMG9uJTIwdGVjaG5pY2FsJTIwdG9waWNzLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGV4cGxhaW4lMjB3aGF0JTIwYSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMGlzJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJBJTIwY2hhdCUyMHRlbXBsYXRlJTIwc3RydWN0dXJlcyUyMGNvbnZlcnNhdGlvbnMlMjBiZXR3ZWVuJTIwdXNlcnMlMjBhbmQlMjBBSSUyMG1vZGVscy4uLiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGRvJTIwSSUyMHVzZSUyMGl0JTIwJTNGJTIyJTdEJTJDJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant focused on technical topics.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you explain what a chat template is?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A chat template structures conversations between users and AI models...&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How do I use it ?&quot;</span>},
]`,wrap:!1}}),Jt=new d({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudCUyMGZvY3VzZWQlMjBvbiUyMHRlY2huaWNhbCUyMHRvcGljcy4lM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjB5b3UlMjBleHBsYWluJTIwd2hhdCUyMGElMjBjaGF0JTIwdGVtcGxhdGUlMjBpcyUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBQSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMHN0cnVjdHVyZXMlMjBjb252ZXJzYXRpb25zJTIwYmV0d2VlbiUyMHVzZXJzJTIwYW5kJTIwQUklMjBtb2RlbHMuLi4lM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIb3clMjBkbyUyMEklMjB1c2UlMjBpdCUyMCUzRiUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful assistant focused on technical topics.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can you explain what a chat template is?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
A chat template structures conversations between <span class="hljs-built_in">users</span> and AI models...&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How <span class="hljs-keyword">do</span> I use it ?&lt;|im_end|&gt;`,wrap:!1}}),Ut=new g({props:{title:"Messages to prompt",local:"messages-to-prompt",headingTag:"h3"}}),wt=new d({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGFuJTIwQUklMjBhc3Npc3RhbnQlMjB3aXRoJTIwYWNjZXNzJTIwdG8lMjB2YXJpb3VzJTIwdG9vbHMuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGklMjAhJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMGh1bWFuJTJDJTIwd2hhdCUyMGNhbiUyMGhlbHAlMjB5b3UlMjB3aXRoJTIwJTNGJTIyJTdEJTJDJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are an AI assistant with access to various tools.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi !&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi human, what can help you with ?&quot;</span>},
]`,wrap:!1}}),bt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMi0xLjdCLUluc3RydWN0JTIyKSUwQXJlbmRlcmVkX3Byb21wdCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKG1lc3NhZ2VzJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>)
rendered_prompt = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)`,wrap:!1}}),qt=new sl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/messages-and-special-tokens.mdx"}}),{c(){J=i("meta"),Zt=n(),Qt=i("p"),_t=n(),r(j.$$.fragment),St=n(),r(U.$$.fragment),zt=n(),f=i("p"),f.innerHTML=es,Vt=n(),w=i("p"),w.textContent=ss,kt=n(),I=i("blockquote"),I.innerHTML=ls,Wt=n(),b=i("p"),b.innerHTML=ns,Rt=n(),C=i("figure"),C.innerHTML=as,Xt=n(),v=i("p"),v.innerHTML=is,At=n(),N=i("p"),N.textContent=ps,Et=n(),r(x.$$.fragment),Ft=n(),r($.$$.fragment),Lt=n(),B=i("p"),B.innerHTML=os,Ht=n(),q=i("p"),q.textContent=rs,Yt=n(),r(Q.$$.fragment),Dt=n(),G=i("p"),G.textContent=us,Pt=n(),Z=i("img"),Ot=n(),_=i("p"),_.textContent=ms,Kt=n(),r(S.$$.fragment),te=n(),z=i("p"),z.textContent=hs,ee=n(),V=i("img"),se=n(),k=i("p"),k.innerHTML=cs,le=n(),W=i("img"),ne=n(),r(R.$$.fragment),ae=n(),X=i("p"),X.textContent=Ts,ie=n(),A=i("p"),A.textContent=Js,pe=n(),E=i("p"),E.textContent=gs,oe=n(),r(F.$$.fragment),re=n(),L=i("p"),L.textContent=js,ue=n(),H=i("p"),H.textContent=Us,Me=n(),r(Y.$$.fragment),me=n(),D=i("p"),D.textContent=fs,he=n(),r(P.$$.fragment),ye=n(),O=i("p"),O.textContent=ws,ce=n(),r(K.$$.fragment),de=n(),r(tt.$$.fragment),Te=n(),et=i("p"),et.innerHTML=Is,Je=n(),r(st.$$.fragment),ge=n(),lt=i("p"),lt.textContent=bs,je=n(),nt=i("ul"),nt.innerHTML=Cs,Ue=n(),at=i("p"),at.innerHTML=vs,fe=n(),it=i("p"),it.innerHTML=Ns,we=n(),pt=i("p"),pt.textContent=xs,Ie=n(),r(ot.$$.fragment),be=n(),rt=i("p"),rt.textContent=$s,Ce=n(),ut=i("p"),ut.innerHTML=Bs,ve=n(),Mt=i("p"),Mt.innerHTML=qs,Ne=n(),mt=i("p"),mt.innerHTML=Qs,xe=n(),r(ht.$$.fragment),$e=n(),yt=i("p"),yt.textContent=Gs,Be=n(),ct=i("p"),ct.textContent=Zs,qe=n(),r(dt.$$.fragment),Qe=n(),Tt=i("p"),Tt.textContent=_s,Ge=n(),r(Jt.$$.fragment),Ze=n(),gt=i("p"),gt.innerHTML=Ss,_e=n(),jt=i("p"),jt.textContent=zs,Se=n(),T=i("iframe"),ze=n(),r(Ut.$$.fragment),Ve=n(),ft=i("p"),ft.innerHTML=ks,ke=n(),r(wt.$$.fragment),We=n(),It=i("p"),It.innerHTML=Ws,Re=n(),r(bt.$$.fragment),Xe=n(),Ct=i("p"),Ct.innerHTML=Rs,Ae=n(),vt=i("blockquote"),vt.innerHTML=Xs,Ee=n(),Nt=i("p"),Nt.textContent=As,Fe=n(),xt=i("p"),xt.textContent=Es,Le=n(),$t=i("p"),$t.textContent=Fs,He=n(),Bt=i("ul"),Bt.innerHTML=Ls,Ye=n(),r(qt.$$.fragment),De=n(),Gt=i("p"),this.h()},l(t){const e=Ks("svelte-u9bgzb",document.head);J=p(e,"META",{name:!0,content:!0}),e.forEach(s),Zt=a(t),Qt=p(t,"P",{}),Ke(Qt).forEach(s),_t=a(t),u(j.$$.fragment,t),St=a(t),u(U.$$.fragment,t),zt=a(t),f=p(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1toj4le"&&(f.innerHTML=es),Vt=a(t),w=p(t,"P",{"data-svelte-h":!0}),o(w)!=="svelte-o8mj92"&&(w.textContent=ss),kt=a(t),I=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(I)!=="svelte-1qbaz5q"&&(I.innerHTML=ls),Wt=a(t),b=p(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1k0gogg"&&(b.innerHTML=ns),Rt=a(t),C=p(t,"FIGURE",{"data-svelte-h":!0}),o(C)!=="svelte-1j1wziw"&&(C.innerHTML=as),Xt=a(t),v=p(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-15ghbjf"&&(v.innerHTML=is),At=a(t),N=p(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-rvpldv"&&(N.textContent=ps),Et=a(t),u(x.$$.fragment,t),Ft=a(t),u($.$$.fragment,t),Lt=a(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-x4hbev"&&(B.innerHTML=os),Ht=a(t),q=p(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-19ybssz"&&(q.textContent=rs),Yt=a(t),u(Q.$$.fragment,t),Dt=a(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-hany3s"&&(G.textContent=us),Pt=a(t),Z=p(t,"IMG",{src:!0,alt:!0}),Ot=a(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-k513la"&&(_.textContent=ms),Kt=a(t),u(S.$$.fragment,t),te=a(t),z=p(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-t48ser"&&(z.textContent=hs),ee=a(t),V=p(t,"IMG",{src:!0,alt:!0}),se=a(t),k=p(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1udtsmh"&&(k.innerHTML=cs),le=a(t),W=p(t,"IMG",{src:!0,alt:!0}),ne=a(t),u(R.$$.fragment,t),ae=a(t),X=p(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1wwos78"&&(X.textContent=Ts),ie=a(t),A=p(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1axqdrw"&&(A.textContent=Js),pe=a(t),E=p(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1gkqha7"&&(E.textContent=gs),oe=a(t),u(F.$$.fragment,t),re=a(t),L=p(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1q6cjfg"&&(L.textContent=js),ue=a(t),H=p(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-18wh1r6"&&(H.textContent=Us),Me=a(t),u(Y.$$.fragment,t),me=a(t),D=p(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1gxyp66"&&(D.textContent=fs),he=a(t),u(P.$$.fragment,t),ye=a(t),O=p(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1eyhr8j"&&(O.textContent=ws),ce=a(t),u(K.$$.fragment,t),de=a(t),u(tt.$$.fragment,t),Te=a(t),et=p(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-cfd9gt"&&(et.innerHTML=Is),Je=a(t),u(st.$$.fragment,t),ge=a(t),lt=p(t,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-vpvraw"&&(lt.textContent=bs),je=a(t),nt=p(t,"UL",{"data-svelte-h":!0}),o(nt)!=="svelte-1yu9rxi"&&(nt.innerHTML=Cs),Ue=a(t),at=p(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1cf7bq3"&&(at.innerHTML=vs),fe=a(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-196u0oh"&&(it.innerHTML=Ns),we=a(t),pt=p(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-29afmd"&&(pt.textContent=xs),Ie=a(t),u(ot.$$.fragment,t),be=a(t),rt=p(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-jvx21u"&&(rt.textContent=$s),Ce=a(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1ybvavp"&&(ut.innerHTML=Bs),ve=a(t),Mt=p(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-au3ydg"&&(Mt.innerHTML=qs),Ne=a(t),mt=p(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1f9o4wp"&&(mt.innerHTML=Qs),xe=a(t),u(ht.$$.fragment,t),$e=a(t),yt=p(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1gjtijn"&&(yt.textContent=Gs),Be=a(t),ct=p(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-70c56g"&&(ct.textContent=Zs),qe=a(t),u(dt.$$.fragment,t),Qe=a(t),Tt=p(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-11msd2d"&&(Tt.textContent=_s),Ge=a(t),u(Jt.$$.fragment,t),Ze=a(t),gt=p(t,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-mqwxqq"&&(gt.innerHTML=Ss),_e=a(t),jt=p(t,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-8fquko"&&(jt.textContent=zs),Se=a(t),T=p(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ke(T).forEach(s),ze=a(t),u(Ut.$$.fragment,t),Ve=a(t),ft=p(t,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-d75apk"&&(ft.innerHTML=ks),ke=a(t),u(wt.$$.fragment,t),We=a(t),It=p(t,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1tcvhzs"&&(It.innerHTML=Ws),Re=a(t),u(bt.$$.fragment,t),Xe=a(t),Ct=p(t,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-v36z3v"&&(Ct.innerHTML=Rs),Ae=a(t),vt=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(vt)!=="svelte-177beuo"&&(vt.innerHTML=Xs),Ee=a(t),Nt=p(t,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-17fbhw0"&&(Nt.textContent=As),Fe=a(t),xt=p(t,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-lsol35"&&(xt.textContent=Es),Le=a(t),$t=p(t,"P",{"data-svelte-h":!0}),o($t)!=="svelte-p9nchs"&&($t.textContent=Fs),He=a(t),Bt=p(t,"UL",{"data-svelte-h":!0}),o(Bt)!=="svelte-101bgdw"&&(Bt.innerHTML=Ls),Ye=a(t),u(qt.$$.fragment,t),De=a(t),Gt=p(t,"P",{}),Ke(Gt).forEach(s),this.h()},h(){c(J,"name","hf:doc:metadata"),c(J,"content",nl),Oe(Z.src,Ms="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/polite-alfred.jpg")||c(Z,"src",Ms),c(Z,"alt","Polite alfred"),Oe(V.src,ys="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/rebel-alfred.jpg")||c(V,"src",ys),c(V,"alt","Rebel Alfred"),Oe(W.src,ds="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/alfred-systemprompt.jpg")||c(W,"src",ds),c(W,"alt","Alfred System Prompt"),Oe(T.src,Vs="https://jofthomas-chat-template-viewer.hf.space")||c(T,"src",Vs),c(T,"frameborder","0"),c(T,"width","850"),c(T,"height","450")},m(t,e){tl(document.head,J),l(t,Zt,e),l(t,Qt,e),l(t,_t,e),M(j,t,e),l(t,St,e),M(U,t,e),l(t,zt,e),l(t,f,e),l(t,Vt,e),l(t,w,e),l(t,kt,e),l(t,I,e),l(t,Wt,e),l(t,b,e),l(t,Rt,e),l(t,C,e),l(t,Xt,e),l(t,v,e),l(t,At,e),l(t,N,e),l(t,Et,e),M(x,t,e),l(t,Ft,e),M($,t,e),l(t,Lt,e),l(t,B,e),l(t,Ht,e),l(t,q,e),l(t,Yt,e),M(Q,t,e),l(t,Dt,e),l(t,G,e),l(t,Pt,e),l(t,Z,e),l(t,Ot,e),l(t,_,e),l(t,Kt,e),M(S,t,e),l(t,te,e),l(t,z,e),l(t,ee,e),l(t,V,e),l(t,se,e),l(t,k,e),l(t,le,e),l(t,W,e),l(t,ne,e),M(R,t,e),l(t,ae,e),l(t,X,e),l(t,ie,e),l(t,A,e),l(t,pe,e),l(t,E,e),l(t,oe,e),M(F,t,e),l(t,re,e),l(t,L,e),l(t,ue,e),l(t,H,e),l(t,Me,e),M(Y,t,e),l(t,me,e),l(t,D,e),l(t,he,e),M(P,t,e),l(t,ye,e),l(t,O,e),l(t,ce,e),M(K,t,e),l(t,de,e),M(tt,t,e),l(t,Te,e),l(t,et,e),l(t,Je,e),M(st,t,e),l(t,ge,e),l(t,lt,e),l(t,je,e),l(t,nt,e),l(t,Ue,e),l(t,at,e),l(t,fe,e),l(t,it,e),l(t,we,e),l(t,pt,e),l(t,Ie,e),M(ot,t,e),l(t,be,e),l(t,rt,e),l(t,Ce,e),l(t,ut,e),l(t,ve,e),l(t,Mt,e),l(t,Ne,e),l(t,mt,e),l(t,xe,e),M(ht,t,e),l(t,$e,e),l(t,yt,e),l(t,Be,e),l(t,ct,e),l(t,qe,e),M(dt,t,e),l(t,Qe,e),l(t,Tt,e),l(t,Ge,e),M(Jt,t,e),l(t,Ze,e),l(t,gt,e),l(t,_e,e),l(t,jt,e),l(t,Se,e),l(t,T,e),l(t,ze,e),M(Ut,t,e),l(t,Ve,e),l(t,ft,e),l(t,ke,e),M(wt,t,e),l(t,We,e),l(t,It,e),l(t,Re,e),M(bt,t,e),l(t,Xe,e),l(t,Ct,e),l(t,Ae,e),l(t,vt,e),l(t,Ee,e),l(t,Nt,e),l(t,Fe,e),l(t,xt,e),l(t,Le,e),l(t,$t,e),l(t,He,e),l(t,Bt,e),l(t,Ye,e),M(qt,t,e),l(t,De,e),l(t,Gt,e),Pe=!0},p:Ys,i(t){Pe||(m(j.$$.fragment,t),m(U.$$.fragment,t),m(x.$$.fragment,t),m($.$$.fragment,t),m(Q.$$.fragment,t),m(S.$$.fragment,t),m(R.$$.fragment,t),m(F.$$.fragment,t),m(Y.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),m(st.$$.fragment,t),m(ot.$$.fragment,t),m(ht.$$.fragment,t),m(dt.$$.fragment,t),m(Jt.$$.fragment,t),m(Ut.$$.fragment,t),m(wt.$$.fragment,t),m(bt.$$.fragment,t),m(qt.$$.fragment,t),Pe=!0)},o(t){h(j.$$.fragment,t),h(U.$$.fragment,t),h(x.$$.fragment,t),h($.$$.fragment,t),h(Q.$$.fragment,t),h(S.$$.fragment,t),h(R.$$.fragment,t),h(F.$$.fragment,t),h(Y.$$.fragment,t),h(P.$$.fragment,t),h(K.$$.fragment,t),h(tt.$$.fragment,t),h(st.$$.fragment,t),h(ot.$$.fragment,t),h(ht.$$.fragment,t),h(dt.$$.fragment,t),h(Jt.$$.fragment,t),h(Ut.$$.fragment,t),h(wt.$$.fragment,t),h(bt.$$.fragment,t),h(qt.$$.fragment,t),Pe=!1},d(t){t&&(s(Zt),s(Qt),s(_t),s(St),s(zt),s(f),s(Vt),s(w),s(kt),s(I),s(Wt),s(b),s(Rt),s(C),s(Xt),s(v),s(At),s(N),s(Et),s(Ft),s(Lt),s(B),s(Ht),s(q),s(Yt),s(Dt),s(G),s(Pt),s(Z),s(Ot),s(_),s(Kt),s(te),s(z),s(ee),s(V),s(se),s(k),s(le),s(W),s(ne),s(ae),s(X),s(ie),s(A),s(pe),s(E),s(oe),s(re),s(L),s(ue),s(H),s(Me),s(me),s(D),s(he),s(ye),s(O),s(ce),s(de),s(Te),s(et),s(Je),s(ge),s(lt),s(je),s(nt),s(Ue),s(at),s(fe),s(it),s(we),s(pt),s(Ie),s(be),s(rt),s(Ce),s(ut),s(ve),s(Mt),s(Ne),s(mt),s(xe),s($e),s(yt),s(Be),s(ct),s(qe),s(Qe),s(Tt),s(Ge),s(Ze),s(gt),s(_e),s(jt),s(Se),s(T),s(ze),s(Ve),s(ft),s(ke),s(We),s(It),s(Re),s(Xe),s(Ct),s(Ae),s(vt),s(Ee),s(Nt),s(Fe),s(xt),s(Le),s($t),s(He),s(Bt),s(Ye),s(De),s(Gt)),s(J),y(j,t),y(U,t),y(x,t),y($,t),y(Q,t),y(S,t),y(R,t),y(F,t),y(Y,t),y(P,t),y(K,t),y(tt,t),y(st,t),y(ot,t),y(ht,t),y(dt,t),y(Jt,t),y(Ut,t),y(wt,t),y(bt,t),y(qt,t)}}}const nl='{"title":"Messages and Special Tokens","local":"messages-and-special-tokens","sections":[{"title":"Messages: The Underlying System of LLMs","local":"messages-the-underlying-system-of-llms","sections":[{"title":"System Messages","local":"system-messages","sections":[],"depth":3},{"title":"Conversations: User and Assistant Messages","local":"conversations-user-and-assistant-messages","sections":[],"depth":3}],"depth":2},{"title":"Chat-Templates","local":"chat-templates","sections":[{"title":"Base Models vs. Instruct Models","local":"base-models-vs-instruct-models","sections":[],"depth":3},{"title":"Understanding Chat Templates","local":"understanding-chat-templates","sections":[],"depth":3},{"title":"Messages to prompt","local":"messages-to-prompt","sections":[],"depth":3}],"depth":2}],"depth":1}';function al(ts){return Ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends Ps{constructor(J){super(),Os(this,J,al,ll,Hs,{})}}export{ml as component};
