import{s as Vs,n as Hs,o as zs}from"../chunks/scheduler.505acc25.js";import{S as qs,i as Ls,e as M,s as a,c as y,h as Ps,a as i,d as e,b as n,f as _s,g as o,j as p,k as Js,l as Ds,m as t,n as j,t as w,o as U,p as T}from"../chunks/index.fbb49fb4.js";import{C as Ks}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as m}from"../chunks/CodeBlock.7f0851b7.js";import{H as J}from"../chunks/Heading.511e0027.js";import{E as Os}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function le(ms){let c,ml,Tl,cl,h,rl,d,hl,u,cs="Alfred at your service. As Mr. Wayne’s trusted butler, I’ve taken the liberty of documenting how I assist Mr Wayne with his various documentary needs. While he’s out attending to his… nighttime activities, I ensure all his paperwork, training schedules, and nutritional plans are properly analyzed and organized.",dl,I,rs="Before leaving, he left a note with his week’s training program. I then took the responsibility to come up with a <strong>menu</strong> for tomorrow’s meals.",ul,C,hs="For future such events, let’s create a document analysis system using LangGraph to serve Mr. Wayne’s needs. This system can:",Il,b,ds="<li>Process images document</li> <li>Extract text using vision models (Vision Language Model)</li> <li>Perform calculations when needed (to demonstrate normal tools)</li> <li>Analyze content and provide concise summaries</li> <li>Execute specific instructions related to documents</li>",Cl,g,bl,A,us="The workflow we’ll build follows this structured schema:",gl,f,Is='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',Al,r,Cs='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/agent.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',fl,G,Gl,B,Bl,Z,bs="and imports :",Zl,W,Wl,k,kl,v,gs=`This state is a little more complex than the previous ones we have seen.
<code>AnyMessage</code> is a class from Langchain that defines messages, and <code>add_messages</code> is an operator that adds the latest message rather than overwriting it with the latest state.`,vl,$,As="This is a new concept in LangGraph, where you can add operators in your state to define the way they should interact together.",$l,E,El,x,xl,S,Sl,R,Rl,N,Nl,Y,Yl,F,fs="Allow me to explain the approach in this agent. The agent follows what’s known as the ReAct pattern (Reason-Act-Observe)",Fl,X,Gs="<li><strong>Reason</strong> about his documents and requests</li> <li><strong>Act</strong> by using appropriate tools</li> <li><strong>Observe</strong> the results</li> <li><strong>Repeat</strong> as necessary until I’ve fully addressed his needs</li>",Xl,Q,Bs="This is a simple implementation of an agent using LangGraph.",Ql,_,_l,V,Zs=`We define a <code>tools</code> node with our list of tools. The <code>assistant</code> node is just our model with bound tools.
We create a graph with <code>assistant</code> and <code>tools</code> nodes.`,Vl,H,Ws="We add a <code>tools_condition</code> edge, which routes to <code>End</code> or to <code>tools</code> based on whether the <code>assistant</code> calls a tool.",Hl,z,ks="Now, we add one new step:",zl,q,vs="We connect the <code>tools</code> node back to the <code>assistant</code>, forming a loop.",ql,L,$s="<li>After the <code>assistant</code> node executes, <code>tools_condition</code> checks if the model’s output is a tool call.</li> <li>If it is a tool call, the flow is directed to the <code>tools</code> node.</li> <li>The <code>tools</code> node connects back to <code>assistant</code>.</li> <li>This loop continues as long as the model decides to call tools.</li> <li>If the model response is not a tool call, the flow is directed to END, terminating the process.</li>",Ll,P,Es='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Pl,D,Dl,K,Kl,O,xs="Here is an example to show a simple use case of an agent using a tool in LangGraph.",Ol,ll,ls,sl,Ss="The conversation would proceed:",ss,el,es,tl,ts,al,Rs="When Master Wayne leaves his training and meal notes:",as,nl,ns,Ml,Ns="The interaction would proceed:",Ms,il,is,pl,ps,yl,Ys="Should you wish to create your own document analysis butler, here are key considerations:",ys,ol,Fs="<li><strong>Define clear tools</strong> for specific document-related tasks</li> <li><strong>Create a robust state tracker</strong> to maintain context between tool calls</li> <li><strong>Consider error handling</strong> for tool failures</li> <li><strong>Maintain contextual awareness</strong> of previous interactions (ensured by the operator <code>add_messages</code>)</li>",os,jl,Xs="With these principles, you too can provide exemplary document analysis service worthy of Wayne Manor.",js,wl,Qs="<em>I trust this explanation has been satisfactory. Now, if you’ll excuse me, Master Wayne’s cape requires pressing before tonight’s activities.</em>",ws,Ul,Us,Jl,Ts;return h=new Ks({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new J({props:{title:"Document Analysis Graph",local:"document-analysis-graph",headingTag:"h1"}}),g=new J({props:{title:"The Butler’s Workflow",local:"the-butlers-workflow",headingTag:"h2"}}),G=new J({props:{title:"Setting Up the environment",local:"setting-up-the-environment",headingTag:"h2"}}),B=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai langchain_core",wrap:!1}}),W=new m({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQWZyb20lMjBsYW5nY2hhaW5fY29yZS5tZXNzYWdlcyUyMGltcG9ydCUyMEFueU1lc3NhZ2UlMkMlMjBTeXN0ZW1NZXNzYWdlJTJDJTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaC5tZXNzYWdlJTIwaW1wb3J0JTIwYWRkX21lc3NhZ2VzJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaCUyMGltcG9ydCUyMFNUQVJUJTJDJTIwU3RhdGVHcmFwaCUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUyQyUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage, HumanMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode, tools_condition
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),k=new J({props:{title:"Defining Agent’s State",local:"defining-agents-state",headingTag:"h2"}}),E=new m({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBkb2N1bWVudCUyMHByb3ZpZGVkJTBBJTIwJTIwJTIwJTIwaW5wdXRfZmlsZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTIwJTIwJTIzJTIwQ29udGFpbnMlMjBmaWxlJTIwcGF0aCUyMChQREYlMkZQTkcpJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBBbm5vdGF0ZWQlNUJsaXN0JTVCQW55TWVzc2FnZSU1RCUyQyUyMGFkZF9tZXNzYWdlcyU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># The document provided</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]  <span class="hljs-comment"># Contains file path (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),x=new J({props:{title:"Preparing Tools",local:"preparing-tools",headingTag:"h2"}}),S=new m({props:{code:"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",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extract text from an image file using a multimodal model.
    
    Master Wayne often leaves notes with his training regimen or meal plans.
    This allows me to properly analyze the contents.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Read image and encode as base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Prepare the prompt including the base64 image data</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extract all the text from this image. &quot;</span>
                            <span class="hljs-string">&quot;Return only the extracted text, no explanations.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Call the vision-capable model</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Append extracted text</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># A butler should handle errors gracefully</span>
        error_msg = <span class="hljs-string">f&quot;Error extracting text: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Divide a and b - for Master Wayne&#x27;s occasional calculations.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Equip the butler with tools</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),R=new J({props:{title:"The nodes",local:"the-nodes",headingTag:"h2"}}),N=new m({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTeXN0ZW0lMjBtZXNzYWdlJTBBJTIwJTIwJTIwJTIwdGV4dHVhbF9kZXNjcmlwdGlvbl9vZl90b29sJTNEJTIyJTIyJTIyJTBBZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjBFeHRyYWN0JTIwdGV4dCUyMGZyb20lMjBhbiUyMGltYWdlJTIwZmlsZSUyMHVzaW5nJTIwYSUyMG11bHRpbW9kYWwlMjBtb2RlbC4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1nX3BhdGglM0ElMjBBJTIwbG9jYWwlMjBpbWFnZSUyMGZpbGUlMjBwYXRoJTIwKHN0cmluZ3MpLiUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBJTIwc2luZ2xlJTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHRoZSUyMGNvbmNhdGVuYXRlZCUyMHRleHQlMjBleHRyYWN0ZWQlMjBmcm9tJTIwZWFjaCUyMGltYWdlLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpZGUlMjBhJTIwYW5kJTIwYiUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGltYWdlJTNEc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwc3lzX21zZyUyMCUzRCUyMFN5c3RlbU1lc3NhZ2UoY29udGVudCUzRGYlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGJ1dGxlciUyMG5hbWVkJTIwQWxmcmVkJTIwdGhhdCUyMHNlcnZlcyUyME1yLiUyMFdheW5lJTIwYW5kJTIwQmF0bWFuLiUyMFlvdSUyMGNhbiUyMGFuYWx5c2UlMjBkb2N1bWVudHMlMjBhbmQlMjBydW4lMjBjb21wdXRhdGlvbnMlMjB3aXRoJTIwcHJvdmlkZWQlMjB0b29scyUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwWW91JTIwaGF2ZSUyMGFjY2VzcyUyMHRvJTIwc29tZSUyMG9wdGlvbmFsJTIwaW1hZ2VzLiUyMEN1cnJlbnRseSUyMHRoZSUyMGxvYWRlZCUyMGltYWdlJTIwaXMlM0ElMjAlN0JpbWFnZSU3RCUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QmxsbV93aXRoX3Rvb2xzLmludm9rZSglNUJzeXNfbXNnJTVEJTIwJTJCJTIwc3RhdGUlNUIlMjJtZXNzYWdlcyUyMiU1RCklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dF9maWxlJTIyJTNBJTIwc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment"># System message</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extract text from an image file using a multimodal model.

    Args:
        img_path: A local image file path (strings).

    Returns:
        A single string containing the concatenated text extracted from each image.
divide(a: int, b: int) -&gt; float:
    Divide a and b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;You are a helpful butler named Alfred that serves Mr. Wayne and Batman. You can analyse documents and run computations with provided tools:\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n You have access to some optional images. Currently the loaded image is: <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),Y=new J({props:{title:"The ReAct Pattern: How I Assist Mr. Wayne",local:"the-react-pattern-how-i-assist-mr-wayne",headingTag:"h2"}}),_=new m({props:{code:"JTIzJTIwVGhlJTIwZ3JhcGglMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChBZ2VudFN0YXRlKSUwQSUwQSUyMyUyMERlZmluZSUyMG5vZGVzJTNBJTIwdGhlc2UlMjBkbyUyMHRoZSUyMHdvcmslMEFidWlsZGVyLmFkZF9ub2RlKCUyMmFzc2lzdGFudCUyMiUyQyUyMGFzc2lzdGFudCklMEFidWlsZGVyLmFkZF9ub2RlKCUyMnRvb2xzJTIyJTJDJTIwVG9vbE5vZGUodG9vbHMpKSUwQSUwQSUyMyUyMERlZmluZSUyMGVkZ2VzJTNBJTIwdGhlc2UlMjBkZXRlcm1pbmUlMjBob3clMjB0aGUlMjBjb250cm9sJTIwZmxvdyUyMG1vdmVzJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMEElMjAlMjAlMjAlMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBJZiUyMHRoZSUyMGxhdGVzdCUyMG1lc3NhZ2UlMjByZXF1aXJlcyUyMGElMjB0b29sJTJDJTIwcm91dGUlMjB0byUyMHRvb2xzJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3RoZXJ3aXNlJTJDJTIwcHJvdmlkZSUyMGElMjBkaXJlY3QlMjByZXNwb25zZSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBTaG93JTIwdGhlJTIwYnV0bGVyJ3MlMjB0aG91Z2h0JTIwcHJvY2VzcyUwQWRpc3BsYXkoSW1hZ2UocmVhY3RfZ3JhcGguZ2V0X2dyYXBoKHhyYXklM0RUcnVlKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment"># The graph</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Define nodes: these do the work</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Define edges: these determine how the control flow moves</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># If the latest message requires a tool, route to tools</span>
    <span class="hljs-comment"># Otherwise, provide a direct response</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Show the butler&#x27;s thought process</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),D=new J({props:{title:"The Butler in Action",local:"the-butler-in-action",headingTag:"h2"}}),K=new J({props:{title:"Example 1: Simple Calculations",local:"example-1-simple-calculations",headingTag:"h3"}}),ll=new m({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlkZSUyMDY3OTAlMjBieSUyMDUlMjIpJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjByZWFjdF9ncmFwaC5pbnZva2UoJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBtZXNzYWdlcyUyQyUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjBOb25lJTdEKSUwQSUwQSUyMyUyMFNob3clMjB0aGUlMjBtZXNzYWdlcyUwQWZvciUyMG0lMjBpbiUyMG1lc3NhZ2VzJTVCJ21lc3NhZ2VzJyU1RCUzQSUwQSUyMCUyMCUyMCUyMG0ucHJldHR5X3ByaW50KCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divide 6790 by 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})

<span class="hljs-comment"># Show the messages</span>
<span class="hljs-keyword">for</span> m <span class="hljs-keyword">in</span> messages[<span class="hljs-string">&#x27;messages&#x27;</span>]:
    m.pretty_print()`,wrap:!1}}),el=new m({props:{code:"SHVtYW4lM0ElMjBEaXZpZGUlMjA2NzkwJTIwYnklMjA1JTBBJTBBQUklMjBUb29sJTIwQ2FsbCUzQSUyMGRpdmlkZShhJTNENjc5MCUyQyUyMGIlM0Q1KSUwQSUwQVRvb2wlMjBSZXNwb25zZSUzQSUyMDEzNTguMCUwQSUwQUFsZnJlZCUzQSUyMFRoZSUyMHJlc3VsdCUyMG9mJTIwZGl2aWRpbmclMjA2NzkwJTIwYnklMjA1JTIwaXMlMjAxMzU4LjAu",highlighted:`<span class="hljs-attribute">Human</span>: Divide <span class="hljs-number">6790</span> by <span class="hljs-number">5</span>

<span class="hljs-attribute">AI</span> Tool Call: divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">Tool</span> Response: <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span>: The result of dividing <span class="hljs-number">6790</span> by <span class="hljs-number">5</span> is <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),tl=new J({props:{title:"Example 2: Analyzing Master Wayne’s Training Documents",local:"example-2-analyzing-master-waynes-training-documents",headingTag:"h3"}}),nl=new m({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkFjY29yZGluZyUyMHRvJTIwdGhlJTIwbm90ZSUyMHByb3ZpZGVkJTIwYnklMjBNci4lMjBXYXluZSUyMGluJTIwdGhlJTIwcHJvdmlkZWQlMjBpbWFnZXMuJTIwV2hhdCdzJTIwdGhlJTIwbGlzdCUyMG9mJTIwaXRlbXMlMjBJJTIwc2hvdWxkJTIwYnV5JTIwZm9yJTIwdGhlJTIwZGlubmVyJTIwbWVudSUzRiUyMiklNUQlMEFtZXNzYWdlcyUyMCUzRCUyMHJlYWN0X2dyYXBoLmludm9rZSglN0IlMjJtZXNzYWdlcyUyMiUzQSUyMG1lc3NhZ2VzJTJDJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyMCUyMkJhdG1hbl90cmFpbmluZ19hbmRfbWVhbHMucG5nJTIyJTdEKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;According to the note provided by Mr. Wayne in the provided images. What&#x27;s the list of items I should buy for the dinner menu?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),il=new m({props:{code:"SHVtYW4lM0ElMjBBY2NvcmRpbmclMjB0byUyMHRoZSUyMG5vdGUlMjBwcm92aWRlZCUyMGJ5JTIwTXIuJTIwV2F5bmUlMjBpbiUyMHRoZSUyMHByb3ZpZGVkJTIwaW1hZ2VzLiUyMFdoYXQncyUyMHRoZSUyMGxpc3QlMjBvZiUyMGl0ZW1zJTIwSSUyMHNob3VsZCUyMGJ1eSUyMGZvciUyMHRoZSUyMGRpbm5lciUyMG1lbnUlM0YlMEElMEFBSSUyMFRvb2wlMjBDYWxsJTNBJTIwZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNEJTIyQmF0bWFuX3RyYWluaW5nX2FuZF9tZWFscy5wbmclMjIpJTBBJTBBVG9vbCUyMFJlc3BvbnNlJTNBJTIwJTVCRXh0cmFjdGVkJTIwdGV4dCUyMHdpdGglMjB0cmFpbmluZyUyMHNjaGVkdWxlJTIwYW5kJTIwbWVudSUyMGRldGFpbHMlNUQlMEElMEFBbGZyZWQlM0ElMjBGb3IlMjB0aGUlMjBkaW5uZXIlMjBtZW51JTJDJTIweW91JTIwc2hvdWxkJTIwYnV5JTIwdGhlJTIwZm9sbG93aW5nJTIwaXRlbXMlM0ElMEElMEExLiUyMEdyYXNzLWZlZCUyMGxvY2FsJTIwc2lybG9pbiUyMHN0ZWFrJTBBMi4lMjBPcmdhbmljJTIwc3BpbmFjaCUwQTMuJTIwUGlxdWlsbG8lMjBwZXBwZXJzJTBBNC4lMjBQb3RhdG9lcyUyMChmb3IlMjBvdmVuLWJha2VkJTIwZ29sZGVuJTIwaGVyYiUyMHBvdGF0byklMEE1LiUyMEZpc2glMjBvaWwlMjAoMiUyMGdyYW1zKSUwQSUwQUVuc3VyZSUyMHRoZSUyMHN0ZWFrJTIwaXMlMjBncmFzcy1mZWQlMjBhbmQlMjB0aGUlMjBzcGluYWNoJTIwYW5kJTIwcGVwcGVycyUyMGFyZSUyMG9yZ2FuaWMlMjBmb3IlMjB0aGUlMjBiZXN0JTIwcXVhbGl0eSUyMG1lYWwu",highlighted:`<span class="hljs-symbol">Human:</span> According <span class="hljs-keyword">to</span> the note provided <span class="hljs-keyword">by</span> Mr. Wayne <span class="hljs-keyword">in</span> the provided images. What<span class="hljs-comment">&#x27;s the list of items I should buy for the dinner menu?</span>

AI Tool <span class="hljs-keyword">Call</span>: extract_text(img_path=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)

Tool Response: [Extracted <span class="hljs-keyword">text</span> <span class="hljs-keyword">with</span> training schedule <span class="hljs-built_in">and</span> menu details]

<span class="hljs-symbol">Alfred:</span> <span class="hljs-keyword">For</span> the dinner menu, you should buy the following items:

<span class="hljs-number">1</span>. Grass-fed local sirloin steak
<span class="hljs-number">2</span>. Organic spinach
<span class="hljs-number">3</span>. Piquillo peppers
<span class="hljs-number">4</span>. Potatoes (<span class="hljs-keyword">for</span> oven-baked golden herb potato)
<span class="hljs-number">5</span>. Fish oil (<span class="hljs-number">2</span> grams)

Ensure the steak <span class="hljs-built_in">is</span> grass-fed <span class="hljs-built_in">and</span> the spinach <span class="hljs-built_in">and</span> peppers are organic <span class="hljs-keyword">for</span> the best quality meal.`,wrap:!1}}),pl=new J({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),Ul=new Os({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){c=M("meta"),ml=a(),Tl=M("p"),cl=a(),y(h.$$.fragment),rl=a(),y(d.$$.fragment),hl=a(),u=M("p"),u.textContent=cs,dl=a(),I=M("p"),I.innerHTML=rs,ul=a(),C=M("p"),C.textContent=hs,Il=a(),b=M("ol"),b.innerHTML=ds,Cl=a(),y(g.$$.fragment),bl=a(),A=M("p"),A.textContent=us,gl=a(),f=M("p"),f.innerHTML=Is,Al=a(),r=M("blockquote"),r.innerHTML=Cs,fl=a(),y(G.$$.fragment),Gl=a(),y(B.$$.fragment),Bl=a(),Z=M("p"),Z.textContent=bs,Zl=a(),y(W.$$.fragment),Wl=a(),y(k.$$.fragment),kl=a(),v=M("p"),v.innerHTML=gs,vl=a(),$=M("p"),$.textContent=As,$l=a(),y(E.$$.fragment),El=a(),y(x.$$.fragment),xl=a(),y(S.$$.fragment),Sl=a(),y(R.$$.fragment),Rl=a(),y(N.$$.fragment),Nl=a(),y(Y.$$.fragment),Yl=a(),F=M("p"),F.textContent=fs,Fl=a(),X=M("ol"),X.innerHTML=Gs,Xl=a(),Q=M("p"),Q.textContent=Bs,Ql=a(),y(_.$$.fragment),_l=a(),V=M("p"),V.innerHTML=Zs,Vl=a(),H=M("p"),H.innerHTML=Ws,Hl=a(),z=M("p"),z.textContent=ks,zl=a(),q=M("p"),q.innerHTML=vs,ql=a(),L=M("ul"),L.innerHTML=$s,Ll=a(),P=M("p"),P.innerHTML=Es,Pl=a(),y(D.$$.fragment),Dl=a(),y(K.$$.fragment),Kl=a(),O=M("p"),O.textContent=xs,Ol=a(),y(ll.$$.fragment),ls=a(),sl=M("p"),sl.textContent=Ss,ss=a(),y(el.$$.fragment),es=a(),y(tl.$$.fragment),ts=a(),al=M("p"),al.textContent=Rs,as=a(),y(nl.$$.fragment),ns=a(),Ml=M("p"),Ml.textContent=Ns,Ms=a(),y(il.$$.fragment),is=a(),y(pl.$$.fragment),ps=a(),yl=M("p"),yl.textContent=Ys,ys=a(),ol=M("ol"),ol.innerHTML=Fs,os=a(),jl=M("p"),jl.textContent=Xs,js=a(),wl=M("p"),wl.innerHTML=Qs,ws=a(),y(Ul.$$.fragment),Us=a(),Jl=M("p"),this.h()},l(l){const s=Ps("svelte-u9bgzb",document.head);c=i(s,"META",{name:!0,content:!0}),s.forEach(e),ml=n(l),Tl=i(l,"P",{}),_s(Tl).forEach(e),cl=n(l),o(h.$$.fragment,l),rl=n(l),o(d.$$.fragment,l),hl=n(l),u=i(l,"P",{"data-svelte-h":!0}),p(u)!=="svelte-11xka8s"&&(u.textContent=cs),dl=n(l),I=i(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-130n2j9"&&(I.innerHTML=rs),ul=n(l),C=i(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-fz9q9p"&&(C.textContent=hs),Il=n(l),b=i(l,"OL",{"data-svelte-h":!0}),p(b)!=="svelte-gyca7w"&&(b.innerHTML=ds),Cl=n(l),o(g.$$.fragment,l),bl=n(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-zxoaj3"&&(A.textContent=us),gl=n(l),f=i(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-g7cpwr"&&(f.innerHTML=Is),Al=n(l),r=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(r)!=="svelte-1uoqj7n"&&(r.innerHTML=Cs),fl=n(l),o(G.$$.fragment,l),Gl=n(l),o(B.$$.fragment,l),Bl=n(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1ey17wx"&&(Z.textContent=bs),Zl=n(l),o(W.$$.fragment,l),Wl=n(l),o(k.$$.fragment,l),kl=n(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-h15r15"&&(v.innerHTML=gs),vl=n(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-s7exkc"&&($.textContent=As),$l=n(l),o(E.$$.fragment,l),El=n(l),o(x.$$.fragment,l),xl=n(l),o(S.$$.fragment,l),Sl=n(l),o(R.$$.fragment,l),Rl=n(l),o(N.$$.fragment,l),Nl=n(l),o(Y.$$.fragment,l),Yl=n(l),F=i(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-18vru10"&&(F.textContent=fs),Fl=n(l),X=i(l,"OL",{"data-svelte-h":!0}),p(X)!=="svelte-1lieze1"&&(X.innerHTML=Gs),Xl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-139l5j8"&&(Q.textContent=Bs),Ql=n(l),o(_.$$.fragment,l),_l=n(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1d0auck"&&(V.innerHTML=Zs),Vl=n(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1svgz16"&&(H.innerHTML=Ws),Hl=n(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1f0m6x1"&&(z.textContent=ks),zl=n(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-echfi8"&&(q.innerHTML=vs),ql=n(l),L=i(l,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-bdsar0"&&(L.innerHTML=$s),Ll=n(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1nhlurw"&&(P.innerHTML=Es),Pl=n(l),o(D.$$.fragment,l),Dl=n(l),o(K.$$.fragment,l),Kl=n(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1rxi6tg"&&(O.textContent=xs),Ol=n(l),o(ll.$$.fragment,l),ls=n(l),sl=i(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-eegy09"&&(sl.textContent=Ss),ss=n(l),o(el.$$.fragment,l),es=n(l),o(tl.$$.fragment,l),ts=n(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-k6gec7"&&(al.textContent=Rs),as=n(l),o(nl.$$.fragment,l),ns=n(l),Ml=i(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-gpwkjm"&&(Ml.textContent=Ns),Ms=n(l),o(il.$$.fragment,l),is=n(l),o(pl.$$.fragment,l),ps=n(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-17u0oai"&&(yl.textContent=Ys),ys=n(l),ol=i(l,"OL",{"data-svelte-h":!0}),p(ol)!=="svelte-1caujcm"&&(ol.innerHTML=Fs),os=n(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-1tc3qgy"&&(jl.textContent=Xs),js=n(l),wl=i(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-1ik86s0"&&(wl.innerHTML=Qs),ws=n(l),o(Ul.$$.fragment,l),Us=n(l),Jl=i(l,"P",{}),_s(Jl).forEach(e),this.h()},h(){Js(c,"name","hf:doc:metadata"),Js(c,"content",se),Js(r,"class","tip")},m(l,s){Ds(document.head,c),t(l,ml,s),t(l,Tl,s),t(l,cl,s),j(h,l,s),t(l,rl,s),j(d,l,s),t(l,hl,s),t(l,u,s),t(l,dl,s),t(l,I,s),t(l,ul,s),t(l,C,s),t(l,Il,s),t(l,b,s),t(l,Cl,s),j(g,l,s),t(l,bl,s),t(l,A,s),t(l,gl,s),t(l,f,s),t(l,Al,s),t(l,r,s),t(l,fl,s),j(G,l,s),t(l,Gl,s),j(B,l,s),t(l,Bl,s),t(l,Z,s),t(l,Zl,s),j(W,l,s),t(l,Wl,s),j(k,l,s),t(l,kl,s),t(l,v,s),t(l,vl,s),t(l,$,s),t(l,$l,s),j(E,l,s),t(l,El,s),j(x,l,s),t(l,xl,s),j(S,l,s),t(l,Sl,s),j(R,l,s),t(l,Rl,s),j(N,l,s),t(l,Nl,s),j(Y,l,s),t(l,Yl,s),t(l,F,s),t(l,Fl,s),t(l,X,s),t(l,Xl,s),t(l,Q,s),t(l,Ql,s),j(_,l,s),t(l,_l,s),t(l,V,s),t(l,Vl,s),t(l,H,s),t(l,Hl,s),t(l,z,s),t(l,zl,s),t(l,q,s),t(l,ql,s),t(l,L,s),t(l,Ll,s),t(l,P,s),t(l,Pl,s),j(D,l,s),t(l,Dl,s),j(K,l,s),t(l,Kl,s),t(l,O,s),t(l,Ol,s),j(ll,l,s),t(l,ls,s),t(l,sl,s),t(l,ss,s),j(el,l,s),t(l,es,s),j(tl,l,s),t(l,ts,s),t(l,al,s),t(l,as,s),j(nl,l,s),t(l,ns,s),t(l,Ml,s),t(l,Ms,s),j(il,l,s),t(l,is,s),j(pl,l,s),t(l,ps,s),t(l,yl,s),t(l,ys,s),t(l,ol,s),t(l,os,s),t(l,jl,s),t(l,js,s),t(l,wl,s),t(l,ws,s),j(Ul,l,s),t(l,Us,s),t(l,Jl,s),Ts=!0},p:Hs,i(l){Ts||(w(h.$$.fragment,l),w(d.$$.fragment,l),w(g.$$.fragment,l),w(G.$$.fragment,l),w(B.$$.fragment,l),w(W.$$.fragment,l),w(k.$$.fragment,l),w(E.$$.fragment,l),w(x.$$.fragment,l),w(S.$$.fragment,l),w(R.$$.fragment,l),w(N.$$.fragment,l),w(Y.$$.fragment,l),w(_.$$.fragment,l),w(D.$$.fragment,l),w(K.$$.fragment,l),w(ll.$$.fragment,l),w(el.$$.fragment,l),w(tl.$$.fragment,l),w(nl.$$.fragment,l),w(il.$$.fragment,l),w(pl.$$.fragment,l),w(Ul.$$.fragment,l),Ts=!0)},o(l){U(h.$$.fragment,l),U(d.$$.fragment,l),U(g.$$.fragment,l),U(G.$$.fragment,l),U(B.$$.fragment,l),U(W.$$.fragment,l),U(k.$$.fragment,l),U(E.$$.fragment,l),U(x.$$.fragment,l),U(S.$$.fragment,l),U(R.$$.fragment,l),U(N.$$.fragment,l),U(Y.$$.fragment,l),U(_.$$.fragment,l),U(D.$$.fragment,l),U(K.$$.fragment,l),U(ll.$$.fragment,l),U(el.$$.fragment,l),U(tl.$$.fragment,l),U(nl.$$.fragment,l),U(il.$$.fragment,l),U(pl.$$.fragment,l),U(Ul.$$.fragment,l),Ts=!1},d(l){l&&(e(ml),e(Tl),e(cl),e(rl),e(hl),e(u),e(dl),e(I),e(ul),e(C),e(Il),e(b),e(Cl),e(bl),e(A),e(gl),e(f),e(Al),e(r),e(fl),e(Gl),e(Bl),e(Z),e(Zl),e(Wl),e(kl),e(v),e(vl),e($),e($l),e(El),e(xl),e(Sl),e(Rl),e(Nl),e(Yl),e(F),e(Fl),e(X),e(Xl),e(Q),e(Ql),e(_l),e(V),e(Vl),e(H),e(Hl),e(z),e(zl),e(q),e(ql),e(L),e(Ll),e(P),e(Pl),e(Dl),e(Kl),e(O),e(Ol),e(ls),e(sl),e(ss),e(es),e(ts),e(al),e(as),e(ns),e(Ml),e(Ms),e(is),e(ps),e(yl),e(ys),e(ol),e(os),e(jl),e(js),e(wl),e(ws),e(Us),e(Jl)),e(c),T(h,l),T(d,l),T(g,l),T(G,l),T(B,l),T(W,l),T(k,l),T(E,l),T(x,l),T(S,l),T(R,l),T(N,l),T(Y,l),T(_,l),T(D,l),T(K,l),T(ll,l),T(el,l),T(tl,l),T(nl,l),T(il,l),T(pl,l),T(Ul,l)}}}const se='{"title":"Document Analysis Graph","local":"document-analysis-graph","sections":[{"title":"The Butler’s Workflow","local":"the-butlers-workflow","sections":[],"depth":2},{"title":"Setting Up the environment","local":"setting-up-the-environment","sections":[],"depth":2},{"title":"Defining Agent’s State","local":"defining-agents-state","sections":[],"depth":2},{"title":"Preparing Tools","local":"preparing-tools","sections":[],"depth":2},{"title":"The nodes","local":"the-nodes","sections":[],"depth":2},{"title":"The ReAct Pattern: How I Assist Mr. Wayne","local":"the-react-pattern-how-i-assist-mr-wayne","sections":[],"depth":2},{"title":"The Butler in Action","local":"the-butler-in-action","sections":[{"title":"Example 1: Simple Calculations","local":"example-1-simple-calculations","sections":[],"depth":3},{"title":"Example 2: Analyzing Master Wayne’s Training Documents","local":"example-2-analyzing-master-waynes-training-documents","sections":[],"depth":3}],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[],"depth":2}],"depth":1}';function ee(ms){return zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends qs{constructor(c){super(),Ls(this,c,ee,le,Vs,{})}}export{ye as component};
