import{s as mt,a as rt,n as ht,o as ut}from"../chunks/scheduler.505acc25.js";import{S as It,i as dt,e as M,s as e,c as J,h as gt,a as p,d as t,b as n,f as Ut,g as y,j as i,k as bl,l as bt,m as a,n as o,t as j,o as T,p as c}from"../chunks/index.fbb49fb4.js";import{C as Ct}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as r}from"../chunks/CodeBlock.7f0851b7.js";import{H as w}from"../chunks/Heading.511e0027.js";import{E as ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function Bt(ks){let U,Bl,Cl,Wl,h,Zl,u,Gl,I,Ss="Now that we understand the building blocks, let’s put them into practice by building our first functional graph. We’ll implement Alfred’s email processing system, where he needs to:",El,d,Vs="<li>Read incoming emails</li> <li>Classify them as spam or legitimate</li> <li>Draft a preliminary response for legitimate emails</li> <li>Send information to Mr. Wayne when legitimate (printing only)</li>",ql,g,Ys="This example demonstrates how to structure a workflow with LangGraph that involves LLM-based decision-making. While this can’t be considered an Agent as no tool is involved, this section focuses more on learning the LangGraph framework than Agents.",Al,m,Fs='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/mail_sorting.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',Nl,b,Ql,C,_s="Here’s the workflow we’ll build:",kl,f,Xs,Sl,B,Vl,W,$s="First, let’s install the required packages:",Yl,Z,Fl,G,xs="Next, let’s import the necessary modules:",_l,E,Xl,q,$l,A,vs="Let’s define what information Alfred needs to track during the email processing workflow:",xl,N,vl,Q,Rs="<p>💡 <strong>Tip:</strong> Make your state comprehensive enough to track all the important information, but avoid bloating it with unnecessary details.</p>",Rl,k,zl,S,zs="Now, let’s create the processing functions that will form our nodes:",Hl,V,Ll,Y,Dl,F,Hs="We need a function to determine which path to take after classification:",Ol,_,Pl,X,Ls="<p>💡 <strong>Note:</strong> This routing function is called by LangGraph to determine which edge to follow after the classification node. The return value must match one of the keys in our conditional edges mapping.</p>",Kl,$,ls,x,Ds="Now we connect everything together:",ss,v,ts,R,Os="Notice how we use the special <code>END</code> node provided by LangGraph. This indicates terminal states where the workflow completes.",as,z,es,H,Ps="Let’s test our graph with a legitimate email and a spam email:",ns,L,Ms,D,ps,O,Ks="As Alfred fine-tunes the Mail Sorting Agent, he’s growing weary of debugging its runs. Agents, by nature, are unpredictable and difficult to inspect. But since he aims to build the ultimate Spam Detection Agent and deploy it in production, he needs robust traceability for future monitoring and analysis.",is,P,lt='To do this, Alfred can use an observability tool such as <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> to trace and monitor the agent.',Js,K,st="First, we pip install Langfuse:",ys,ll,os,sl,tt="Second, we pip install Langchain (LangChain is required because we use LangFuse):",js,tl,Ts,al,at='Next, we add the Langfuse API keys and host address as environment variables. You can get your Langfuse credentials by signing up for <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> or <a href="https://langfuse.com/self-hosting" rel="nofollow">self-host Langfuse</a>.',cs,el,ws,nl,et='Then, we configure the <a href="https://langfuse.com/docs/integrations/langchain/tracing#add-langfuse-to-your-langchain-application" rel="nofollow">Langfuse <code>callback_handler</code></a> and instrument the agent by adding the <code>langfuse_callback</code> to the invocation of the graph: <code>config={&quot;callbacks&quot;: [langfuse_handler]}</code>.',rs,Ml,Us,pl,nt="Alfred is now connected 🔌! The runs from LangGraph are being logged in Langfuse, giving him full visibility into the agent’s behavior. With this setup, he’s ready to revisit previous runs and refine his Mail Sorting Agent even further.",ms,il,Mt='<img src="https://langfuse.com/images/cookbook/huggingface-agent-course/langgraph-trace-legit.png" alt="Example trace in Langfuse"/>',hs,Jl,pt='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/f5d6d72e-20af-4357-b232-af44c3728a7b?timestamp=2025-03-17T10%3A13%3A28.413Z&amp;observation=6997ba69-043f-4f77-9445-700a033afba1" rel="nofollow">Public link to the trace with the legit email</a></em>',us,yl,Is,ol,it="LangGraph allows us to visualize our workflow to better understand and debug its structure:",ds,jl,gs,Tl,Jt,bs,cl,yt="This produces a visual representation showing how our nodes are connected and the conditional paths that can be taken.",Cs,wl,fs,rl,ot="We’ve created a complete email processing workflow that:",Bs,Ul,jt="<li>Takes an incoming email</li> <li>Uses an LLM to classify it as spam or legitimate</li> <li>Handles spam by discarding it</li> <li>For legitimate emails, drafts a response and notifies Mr. Hugg</li>",Ws,ml,Tt="This demonstrates the power of LangGraph to orchestrate complex workflows with LLMs while maintaining a clear, structured flow.",Zs,hl,Gs,ul,ct="<li><strong>State Management</strong>: We defined comprehensive state to track all aspects of email processing</li> <li><strong>Node Implementation</strong>: We created functional nodes that interact with an LLM</li> <li><strong>Conditional Routing</strong>: We implemented branching logic based on email classification</li> <li><strong>Terminal States</strong>: We used the END node to mark completion points in our workflow</li>",Es,Il,qs,dl,wt="In the next section, we’ll explore more advanced features of LangGraph, including handling human interaction in the workflow and implementing more complex branching logic based on multiple conditions.",As,gl,Ns,fl,Qs;return h=new Ct({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new w({props:{title:"Building Your First LangGraph",local:"building-your-first-langgraph",headingTag:"h1"}}),b=new w({props:{title:"Our Workflow",local:"our-workflow",headingTag:"h2"}}),B=new w({props:{title:"Setting Up Our Environment",local:"setting-up-our-environment",headingTag:"h2"}}),Z=new r({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWk=",highlighted:"%pip install langgraph langchain_openai",wrap:!1}}),E=new r({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwVHlwZWREaWN0JTJDJTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyMENoYXRPcGVuQUklMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUubWVzc2FnZXMlMjBpbXBvcnQlMjBIdW1hbk1lc3NhZ2U=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> HumanMessage`,wrap:!1}}),q=new w({props:{title:"Step 1: Define Our State",local:"step-1-define-our-state",headingTag:"h2"}}),N=new r({props:{code:"Y2xhc3MlMjBFbWFpbFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBlbWFpbCUyMGJlaW5nJTIwcHJvY2Vzc2VkJTBBJTIwJTIwJTIwJTIwZW1haWwlM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTIwJTIwJTIzJTIwQ29udGFpbnMlMjBzdWJqZWN0JTJDJTIwc2VuZGVyJTJDJTIwYm9keSUyQyUyMGV0Yy4lMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDYXRlZ29yeSUyMG9mJTIwdGhlJTIwZW1haWwlMjAoaW5xdWlyeSUyQyUyMGNvbXBsYWludCUyQyUyMGV0Yy4pJTBBJTIwJTIwJTIwJTIwZW1haWxfY2F0ZWdvcnklM0ElMjBPcHRpb25hbCU1QnN0ciU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlYXNvbiUyMHdoeSUyMHRoZSUyMGVtYWlsJTIwd2FzJTIwbWFya2VkJTIwYXMlMjBzcGFtJTBBJTIwJTIwJTIwJTIwc3BhbV9yZWFzb24lM0ElMjBPcHRpb25hbCU1QnN0ciU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFuYWx5c2lzJTIwYW5kJTIwZGVjaXNpb25zJTBBJTIwJTIwJTIwJTIwaXNfc3BhbSUzQSUyME9wdGlvbmFsJTVCYm9vbCU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlc3BvbnNlJTIwZ2VuZXJhdGlvbiUwQSUyMCUyMCUyMCUyMGVtYWlsX2RyYWZ0JTNBJTIwT3B0aW9uYWwlNUJzdHIlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQcm9jZXNzaW5nJTIwbWV0YWRhdGElMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzQSUyMExpc3QlNUJEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTVEJTIwJTIwJTIzJTIwVHJhY2slMjBjb252ZXJzYXRpb24lMjB3aXRoJTIwTExNJTIwZm9yJTIwYW5hbHlzaXM=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmailState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># The email being processed</span>
    email: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]  <span class="hljs-comment"># Contains subject, sender, body, etc.</span>

    <span class="hljs-comment"># Category of the email (inquiry, complaint, etc.)</span>
    email_category: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]

    <span class="hljs-comment"># Reason why the email was marked as spam</span>
    spam_reason: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]

    <span class="hljs-comment"># Analysis and decisions</span>
    is_spam: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>]
    
    <span class="hljs-comment"># Response generation</span>
    email_draft: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]
    
    <span class="hljs-comment"># Processing metadata</span>
    messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]  <span class="hljs-comment"># Track conversation with LLM for analysis</span>`,wrap:!1}}),k=new w({props:{title:"Step 2: Define Our Nodes",local:"step-2-define-our-nodes",headingTag:"h2"}}),V=new r({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMG91ciUyMExMTSUwQW1vZGVsJTIwJTNEJTIwQ2hhdE9wZW5BSSh0ZW1wZXJhdHVyZSUzRDApJTBBJTBBZGVmJTIwcmVhZF9lbWFpbChzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwcmVhZHMlMjBhbmQlMjBsb2dzJTIwdGhlJTIwaW5jb21pbmclMjBlbWFpbCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGVtYWlsJTIwJTNEJTIwc3RhdGUlNUIlMjJlbWFpbCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEhlcmUlMjB3ZSUyMG1pZ2h0JTIwZG8lMjBzb21lJTIwaW5pdGlhbCUyMHByZXByb2Nlc3NpbmclMEElMjAlMjAlMjAlMjBwcmludChmJTIyQWxmcmVkJTIwaXMlMjBwcm9jZXNzaW5nJTIwYW4lMjBlbWFpbCUyMGZyb20lMjAlN0JlbWFpbCU1QidzZW5kZXInJTVEJTdEJTIwd2l0aCUyMHN1YmplY3QlM0ElMjAlN0JlbWFpbCU1QidzdWJqZWN0JyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBObyUyMHN0YXRlJTIwY2hhbmdlcyUyMG5lZWRlZCUyMGhlcmUlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlN0QlMEElMEFkZWYlMjBjbGFzc2lmeV9lbWFpbChzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwdXNlcyUyMGFuJTIwTExNJTIwdG8lMjBkZXRlcm1pbmUlMjBpZiUyMHRoZSUyMGVtYWlsJTIwaXMlMjBzcGFtJTIwb3IlMjBsZWdpdGltYXRlJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwZW1haWwlMjAlM0QlMjBzdGF0ZSU1QiUyMmVtYWlsJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJlcGFyZSUyMG91ciUyMHByb21wdCUyMGZvciUyMHRoZSUyMExMTSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMGYlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBcyUyMEFsZnJlZCUyMHRoZSUyMGJ1dGxlciUyQyUyMGFuYWx5emUlMjB0aGlzJTIwZW1haWwlMjBhbmQlMjBkZXRlcm1pbmUlMjBpZiUyMGl0JTIwaXMlMjBzcGFtJTIwb3IlMjBsZWdpdGltYXRlLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMEVtYWlsJTNBJTBBJTIwJTIwJTIwJTIwRnJvbSUzQSUyMCU3QmVtYWlsJTVCJ3NlbmRlciclNUQlN0QlMEElMjAlMjAlMjAlMjBTdWJqZWN0JTNBJTIwJTdCZW1haWwlNUInc3ViamVjdCclNUQlN0QlMEElMjAlMjAlMjAlMjBCb2R5JTNBJTIwJTdCZW1haWwlNUInYm9keSclNUQlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBGaXJzdCUyQyUyMGRldGVybWluZSUyMGlmJTIwdGhpcyUyMGVtYWlsJTIwaXMlMjBzcGFtLiUyMElmJTIwaXQlMjBpcyUyMHNwYW0lMkMlMjBleHBsYWluJTIwd2h5LiUwQSUyMCUyMCUyMCUyMElmJTIwaXQlMjBpcyUyMGxlZ2l0aW1hdGUlMkMlMjBjYXRlZ29yaXplJTIwaXQlMjAoaW5xdWlyeSUyQyUyMGNvbXBsYWludCUyQyUyMHRoYW5rJTIweW91JTJDJTIwZXRjLikuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2FsbCUyMHRoZSUyMExMTSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwJTVCSHVtYW5NZXNzYWdlKGNvbnRlbnQlM0Rwcm9tcHQpJTVEJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBtb2RlbC5pbnZva2UobWVzc2FnZXMpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2ltcGxlJTIwbG9naWMlMjB0byUyMHBhcnNlJTIwdGhlJTIwcmVzcG9uc2UlMjAoaW4lMjBhJTIwcmVhbCUyMGFwcCUyQyUyMHlvdSdkJTIwd2FudCUyMG1vcmUlMjByb2J1c3QlMjBwYXJzaW5nKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3RleHQlMjAlM0QlMjByZXNwb25zZS5jb250ZW50Lmxvd2VyKCklMEElMjAlMjAlMjAlMjBpc19zcGFtJTIwJTNEJTIwJTIyc3BhbSUyMiUyMGluJTIwcmVzcG9uc2VfdGV4dCUyMGFuZCUyMCUyMm5vdCUyMHNwYW0lMjIlMjBub3QlMjBpbiUyMHJlc3BvbnNlX3RleHQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBFeHRyYWN0JTIwYSUyMHJlYXNvbiUyMGlmJTIwaXQncyUyMHNwYW0lMEElMjAlMjAlMjAlMjBzcGFtX3JlYXNvbiUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjBpZiUyMGlzX3NwYW0lMjBhbmQlMjAlMjJyZWFzb24lM0ElMjIlMjBpbiUyMHJlc3BvbnNlX3RleHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGFtX3JlYXNvbiUyMCUzRCUyMHJlc3BvbnNlX3RleHQuc3BsaXQoJTIycmVhc29uJTNBJTIyKSU1QjElNUQuc3RyaXAoKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMERldGVybWluZSUyMGNhdGVnb3J5JTIwaWYlMjBsZWdpdGltYXRlJTBBJTIwJTIwJTIwJTIwZW1haWxfY2F0ZWdvcnklMjAlM0QlMjBOb25lJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpc19zcGFtJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2F0ZWdvcmllcyUyMCUzRCUyMCU1QiUyMmlucXVpcnklMjIlMkMlMjAlMjJjb21wbGFpbnQlMjIlMkMlMjAlMjJ0aGFuayUyMHlvdSUyMiUyQyUyMCUyMnJlcXVlc3QlMjIlMkMlMjAlMjJpbmZvcm1hdGlvbiUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGNhdGVnb3J5JTIwaW4lMjBjYXRlZ29yaWVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBjYXRlZ29yeSUyMGluJTIwcmVzcG9uc2VfdGV4dCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVtYWlsX2NhdGVnb3J5JTIwJTNEJTIwY2F0ZWdvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFVwZGF0ZSUyMG1lc3NhZ2VzJTIwZm9yJTIwdHJhY2tpbmclMEElMjAlMjAlMjAlMjBuZXdfbWVzc2FnZXMlMjAlM0QlMjBzdGF0ZS5nZXQoJTIybWVzc2FnZXMlMjIlMkMlMjAlNUIlNUQpJTIwJTJCJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwcHJvbXB0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTdEJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJuJTIwc3RhdGUlMjB1cGRhdGVzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaXNfc3BhbSUyMiUzQSUyMGlzX3NwYW0lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGFtX3JlYXNvbiUyMiUzQSUyMHNwYW1fcmVhc29uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1haWxfY2F0ZWdvcnklMjIlM0ElMjBlbWFpbF9jYXRlZ29yeSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwbmV3X21lc3NhZ2VzJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBZGVmJTIwaGFuZGxlX3NwYW0oc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFsZnJlZCUyMGRpc2NhcmRzJTIwc3BhbSUyMGVtYWlsJTIwd2l0aCUyMGElMjBub3RlJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkFsZnJlZCUyMGhhcyUyMG1hcmtlZCUyMHRoZSUyMGVtYWlsJTIwYXMlMjBzcGFtLiUyMFJlYXNvbiUzQSUyMCU3QnN0YXRlJTVCJ3NwYW1fcmVhc29uJyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjJUaGUlMjBlbWFpbCUyMGhhcyUyMGJlZW4lMjBtb3ZlZCUyMHRvJTIwdGhlJTIwc3BhbSUyMGZvbGRlci4lMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwV2UncmUlMjBkb25lJTIwcHJvY2Vzc2luZyUyMHRoaXMlMjBlbWFpbCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiU3RCUwQSUwQWRlZiUyMGRyYWZ0X3Jlc3BvbnNlKHN0YXRlJTNBJTIwRW1haWxTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBbGZyZWQlMjBkcmFmdHMlMjBhJTIwcHJlbGltaW5hcnklMjByZXNwb25zZSUyMGZvciUyMGxlZ2l0aW1hdGUlMjBlbWFpbHMlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBlbWFpbCUyMCUzRCUyMHN0YXRlJTVCJTIyZW1haWwlMjIlNUQlMEElMjAlMjAlMjAlMjBjYXRlZ29yeSUyMCUzRCUyMHN0YXRlJTVCJTIyZW1haWxfY2F0ZWdvcnklMjIlNUQlMjBvciUyMCUyMmdlbmVyYWwlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQcmVwYXJlJTIwb3VyJTIwcHJvbXB0JTIwZm9yJTIwdGhlJTIwTExNJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwZiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFzJTIwQWxmcmVkJTIwdGhlJTIwYnV0bGVyJTJDJTIwZHJhZnQlMjBhJTIwcG9saXRlJTIwcHJlbGltaW5hcnklMjByZXNwb25zZSUyMHRvJTIwdGhpcyUyMGVtYWlsLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMEVtYWlsJTNBJTBBJTIwJTIwJTIwJTIwRnJvbSUzQSUyMCU3QmVtYWlsJTVCJ3NlbmRlciclNUQlN0QlMEElMjAlMjAlMjAlMjBTdWJqZWN0JTNBJTIwJTdCZW1haWwlNUInc3ViamVjdCclNUQlN0QlMEElMjAlMjAlMjAlMjBCb2R5JTNBJTIwJTdCZW1haWwlNUInYm9keSclNUQlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBUaGlzJTIwZW1haWwlMjBoYXMlMjBiZWVuJTIwY2F0ZWdvcml6ZWQlMjBhcyUzQSUyMCU3QmNhdGVnb3J5JTdEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwRHJhZnQlMjBhJTIwYnJpZWYlMkMlMjBwcm9mZXNzaW9uYWwlMjByZXNwb25zZSUyMHRoYXQlMjBNci4lMjBIdWdnJTIwY2FuJTIwcmV2aWV3JTIwYW5kJTIwcGVyc29uYWxpemUlMjBiZWZvcmUlMjBzZW5kaW5nLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMENhbGwlMjB0aGUlMjBMTE0lMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyMCUzRCUyMCU1Qkh1bWFuTWVzc2FnZShjb250ZW50JTNEcHJvbXB0KSU1RCUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwbW9kZWwuaW52b2tlKG1lc3NhZ2VzKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFVwZGF0ZSUyMG1lc3NhZ2VzJTIwZm9yJTIwdHJhY2tpbmclMEElMjAlMjAlMjAlMjBuZXdfbWVzc2FnZXMlMjAlM0QlMjBzdGF0ZS5nZXQoJTIybWVzc2FnZXMlMjIlMkMlMjAlNUIlNUQpJTIwJTJCJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwcHJvbXB0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTdEJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJuJTIwc3RhdGUlMjB1cGRhdGVzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1haWxfZHJhZnQlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjBuZXdfbWVzc2FnZXMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEFkZWYlMjBub3RpZnlfbXJfaHVnZyhzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwbm90aWZpZXMlMjBNci4lMjBIdWdnJTIwYWJvdXQlMjB0aGUlMjBlbWFpbCUyMGFuZCUyMHByZXNlbnRzJTIwdGhlJTIwZHJhZnQlMjByZXNwb25zZSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGVtYWlsJTIwJTNEJTIwc3RhdGUlNUIlMjJlbWFpbCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiU1Q24lMjIlMjAlMkIlMjAlMjIlM0QlMjIqNTApJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlNpciUyQyUyMHlvdSd2ZSUyMHJlY2VpdmVkJTIwYW4lMjBlbWFpbCUyMGZyb20lMjAlN0JlbWFpbCU1QidzZW5kZXInJTVEJTdELiUyMiklMEElMjAlMjAlMjAlMjBwcmludChmJTIyU3ViamVjdCUzQSUyMCU3QmVtYWlsJTVCJ3N1YmplY3QnJTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJDYXRlZ29yeSUzQSUyMCU3QnN0YXRlJTVCJ2VtYWlsX2NhdGVnb3J5JyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjIlNUNuSSd2ZSUyMHByZXBhcmVkJTIwYSUyMGRyYWZ0JTIwcmVzcG9uc2UlMjBmb3IlMjB5b3VyJTIwcmV2aWV3JTNBJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0lMjIqNTApJTBBJTIwJTIwJTIwJTIwcHJpbnQoc3RhdGUlNUIlMjJlbWFpbF9kcmFmdCUyMiU1RCklMEElMjAlMjAlMjAlMjBwcmludCglMjIlM0QlMjIqNTAlMjAlMkIlMjAlMjIlNUNuJTIyKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFdlJ3JlJTIwZG9uZSUyMHByb2Nlc3NpbmclMjB0aGlzJTIwZW1haWwlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlN0Q=",highlighted:`<span class="hljs-comment"># Initialize our LLM</span>
model = ChatOpenAI(temperature=<span class="hljs-number">0</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred reads and logs the incoming email&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Here we might do some initial preprocessing</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred is processing an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span> with subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    
    <span class="hljs-comment"># No state changes needed here</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred uses an LLM to determine if the email is spam or legitimate&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Prepare our prompt for the LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, analyze this email and determine if it is spam or legitimate.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    First, determine if this email is spam. If it is spam, explain why.
    If it is legitimate, categorize it (inquiry, complaint, thank you, etc.).
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Simple logic to parse the response (in a real app, you&#x27;d want more robust parsing)</span>
    response_text = response.content.lower()
    is_spam = <span class="hljs-string">&quot;spam&quot;</span> <span class="hljs-keyword">in</span> response_text <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;not spam&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> response_text
    
    <span class="hljs-comment"># Extract a reason if it&#x27;s spam</span>
    spam_reason = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> is_spam <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;reason:&quot;</span> <span class="hljs-keyword">in</span> response_text:
        spam_reason = response_text.split(<span class="hljs-string">&quot;reason:&quot;</span>)[<span class="hljs-number">1</span>].strip()
    
    <span class="hljs-comment"># Determine category if legitimate</span>
    email_category = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> is_spam:
        categories = [<span class="hljs-string">&quot;inquiry&quot;</span>, <span class="hljs-string">&quot;complaint&quot;</span>, <span class="hljs-string">&quot;thank you&quot;</span>, <span class="hljs-string">&quot;request&quot;</span>, <span class="hljs-string">&quot;information&quot;</span>]
        <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> categories:
            <span class="hljs-keyword">if</span> category <span class="hljs-keyword">in</span> response_text:
                email_category = category
                <span class="hljs-keyword">break</span>
    
    <span class="hljs-comment"># Update messages for tracking</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Return state updates</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;is_spam&quot;</span>: is_spam,
        <span class="hljs-string">&quot;spam_reason&quot;</span>: spam_reason,
        <span class="hljs-string">&quot;email_category&quot;</span>: email_category,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_spam</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred discards spam email with a note&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred has marked the email as spam. Reason: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;spam_reason&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The email has been moved to the spam folder.&quot;</span>)
    
    <span class="hljs-comment"># We&#x27;re done processing this email</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draft_response</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred drafts a preliminary response for legitimate emails&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    category = state[<span class="hljs-string">&quot;email_category&quot;</span>] <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;general&quot;</span>
    
    <span class="hljs-comment"># Prepare our prompt for the LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, draft a polite preliminary response to this email.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    This email has been categorized as: <span class="hljs-subst">{category}</span>
    
    Draft a brief, professional response that Mr. Hugg can review and personalize before sending.
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Update messages for tracking</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Return state updates</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;email_draft&quot;</span>: response.content,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">notify_mr_hugg</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred notifies Mr. Hugg about the email and presents the draft response&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Sir, you&#x27;ve received an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Category: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;email_category&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nI&#x27;ve prepared a draft response for your review:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;email_draft&quot;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)
    
    <span class="hljs-comment"># We&#x27;re done processing this email</span>
    <span class="hljs-keyword">return</span> {}`,wrap:!1}}),Y=new w({props:{title:"Step 3: Define Our Routing Logic",local:"step-3-define-our-routing-logic",headingTag:"h2"}}),_=new r({props:{code:"ZGVmJTIwcm91dGVfZW1haWwoc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJEZXRlcm1pbmUlMjB0aGUlMjBuZXh0JTIwc3RlcCUyMGJhc2VkJTIwb24lMjBzcGFtJTIwY2xhc3NpZmljYXRpb24lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpZiUyMHN0YXRlJTVCJTIyaXNfc3BhbSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMnNwYW0lMjIlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybGVnaXRpbWF0ZSUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">route_email</span>(<span class="hljs-params">state: EmailState</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Determine the next step based on spam classification&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> state[<span class="hljs-string">&quot;is_spam&quot;</span>]:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;spam&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;legitimate&quot;</span>`,wrap:!1}}),$=new w({props:{title:"Step 4: Create the StateGraph and Define Edges",local:"step-4-create-the-stategraph-and-define-edges",headingTag:"h2"}}),v=new r({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwZ3JhcGglMEFlbWFpbF9ncmFwaCUyMCUzRCUyMFN0YXRlR3JhcGgoRW1haWxTdGF0ZSklMEElMEElMjMlMjBBZGQlMjBub2RlcyUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMnJlYWRfZW1haWwlMjIlMkMlMjByZWFkX2VtYWlsKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTIwY2xhc3NpZnlfZW1haWwpJTBBZW1haWxfZ3JhcGguYWRkX25vZGUoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBoYW5kbGVfc3BhbSklMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMGRyYWZ0X3Jlc3BvbnNlKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwbm90aWZ5X21yX2h1Z2cpJTBBJTBBJTIzJTIwU3RhcnQlMjB0aGUlMjBlZGdlcyUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKFNUQVJUJTJDJTIwJTIycmVhZF9lbWFpbCUyMiklMEElMjMlMjBBZGQlMjBlZGdlcyUyMC0lMjBkZWZpbmluZyUyMHRoZSUyMGZsb3clMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJyZWFkX2VtYWlsJTIyJTJDJTIwJTIyY2xhc3NpZnlfZW1haWwlMjIpJTBBJTBBJTIzJTIwQWRkJTIwY29uZGl0aW9uYWwlMjBicmFuY2hpbmclMjBmcm9tJTIwY2xhc3NpZnlfZW1haWwlMEFlbWFpbF9ncmFwaC5hZGRfY29uZGl0aW9uYWxfZWRnZXMoJTBBJTIwJTIwJTIwJTIwJTIyY2xhc3NpZnlfZW1haWwlMjIlMkMlMEElMjAlMjAlMjAlMjByb3V0ZV9lbWFpbCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNwYW0lMjIlM0ElMjAlMjJoYW5kbGVfc3BhbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxlZ2l0aW1hdGUlMjIlM0ElMjAlMjJkcmFmdF9yZXNwb25zZSUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSklMEElMEElMjMlMjBBZGQlMjB0aGUlMjBmaW5hbCUyMGVkZ2VzJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBFTkQpJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIyZHJhZnRfcmVzcG9uc2UlMjIlMkMlMjAlMjJub3RpZnlfbXJfaHVnZyUyMiklMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJub3RpZnlfbXJfaHVnZyUyMiUyQyUyMEVORCklMEElMEElMjMlMjBDb21waWxlJTIwdGhlJTIwZ3JhcGglMEFjb21waWxlZF9ncmFwaCUyMCUzRCUyMGVtYWlsX2dyYXBoLmNvbXBpbGUoKQ==",highlighted:`<span class="hljs-comment"># Create the graph</span>
email_graph = StateGraph(EmailState)

<span class="hljs-comment"># Add nodes</span>
email_graph.add_node(<span class="hljs-string">&quot;read_email&quot;</span>, read_email)
email_graph.add_node(<span class="hljs-string">&quot;classify_email&quot;</span>, classify_email)
email_graph.add_node(<span class="hljs-string">&quot;handle_spam&quot;</span>, handle_spam)
email_graph.add_node(<span class="hljs-string">&quot;draft_response&quot;</span>, draft_response)
email_graph.add_node(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, notify_mr_hugg)

<span class="hljs-comment"># Start the edges</span>
email_graph.add_edge(START, <span class="hljs-string">&quot;read_email&quot;</span>)
<span class="hljs-comment"># Add edges - defining the flow</span>
email_graph.add_edge(<span class="hljs-string">&quot;read_email&quot;</span>, <span class="hljs-string">&quot;classify_email&quot;</span>)

<span class="hljs-comment"># Add conditional branching from classify_email</span>
email_graph.add_conditional_edges(
    <span class="hljs-string">&quot;classify_email&quot;</span>,
    route_email,
    {
        <span class="hljs-string">&quot;spam&quot;</span>: <span class="hljs-string">&quot;handle_spam&quot;</span>,
        <span class="hljs-string">&quot;legitimate&quot;</span>: <span class="hljs-string">&quot;draft_response&quot;</span>
    }
)

<span class="hljs-comment"># Add the final edges</span>
email_graph.add_edge(<span class="hljs-string">&quot;handle_spam&quot;</span>, END)
email_graph.add_edge(<span class="hljs-string">&quot;draft_response&quot;</span>, <span class="hljs-string">&quot;notify_mr_hugg&quot;</span>)
email_graph.add_edge(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, END)

<span class="hljs-comment"># Compile the graph</span>
compiled_graph = email_graph.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),z=new w({props:{title:"Step 5: Run the Application",local:"step-5-run-the-application",headingTag:"h2"}}),L=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Example legitimate email</span>
legitimate_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;john.smith@example.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;Question about your services&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;Dear Mr. Hugg, I was referred to you by a colleague and I&#x27;m interested in learning more about your consulting services. Could we schedule a call next week? Best regards, John Smith&quot;</span>
}

<span class="hljs-comment"># Example spam email</span>
spam_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;winner@lottery-intl.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;YOU HAVE WON $5,000,000!!!&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;CONGRATULATIONS! You have been selected as the winner of our international lottery! To claim your $5,000,000 prize, please send us your bank details and a processing fee of $100.&quot;</span>
}

<span class="hljs-comment"># Process the legitimate email</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing legitimate email...&quot;</span>)
legitimate_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: legitimate_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_draft&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})

<span class="hljs-comment"># Process the spam email</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing spam email...&quot;</span>)
spam_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: spam_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_draft&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})`,wrap:!1}}),D=new w({props:{title:"Step 6: Inspecting Our Mail Sorting Agent with Langfuse 📡",local:"step-6-inspecting-our-mail-sorting-agent-with-langfuse-",headingTag:"h2"}}),ll=new r({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwbGFuZ2Z1c2U=",highlighted:"%pip install -q langfuse",wrap:!1}}),tl=new r({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdjaGFpbg==",highlighted:"%pip install langchain",wrap:!1}}),el=new r({props:{code:"aW1wb3J0JTIwb3MlMEElMjAlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os
 
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),Ml=new r({props:{code:"ZnJvbSUyMGxhbmdmdXNlLmxhbmdjaGFpbiUyMGltcG9ydCUyMENhbGxiYWNrSGFuZGxlciUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBMYW5nZnVzZSUyMENhbGxiYWNrSGFuZGxlciUyMGZvciUyMExhbmdHcmFwaCUyRkxhbmdjaGFpbiUyMCh0cmFjaW5nKSUwQWxhbmdmdXNlX2hhbmRsZXIlMjAlM0QlMjBDYWxsYmFja0hhbmRsZXIoKSUwQSUwQSUyMyUyMFByb2Nlc3MlMjBsZWdpdGltYXRlJTIwZW1haWwlMEFsZWdpdGltYXRlX3Jlc3VsdCUyMCUzRCUyMGNvbXBpbGVkX2dyYXBoLmludm9rZSglMEElMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMmVtYWlsJTIyJTNBJTIwbGVnaXRpbWF0ZV9lbWFpbCUyQyUyMCUyMmlzX3NwYW0lMjIlM0ElMjBOb25lJTJDJTIwJTIyc3BhbV9yZWFzb24lMjIlM0ElMjBOb25lJTJDJTIwJTIyZW1haWxfY2F0ZWdvcnklMjIlM0ElMjBOb25lJTJDJTIwJTIyZHJhZnRfcmVzcG9uc2UlMjIlM0ElMjBOb25lJTJDJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjBjb25maWclM0QlN0IlMjJjYWxsYmFja3MlMjIlM0ElMjAlNUJsYW5nZnVzZV9oYW5kbGVyJTVEJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langfuse.langchain <span class="hljs-keyword">import</span> CallbackHandler

<span class="hljs-comment"># Initialize Langfuse CallbackHandler for LangGraph/Langchain (tracing)</span>
langfuse_handler = CallbackHandler()

<span class="hljs-comment"># Process legitimate email</span>
legitimate_result = compiled_graph.invoke(
    <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;email&quot;</span>: legitimate_email, <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;messages&quot;</span>: []},
    config={<span class="hljs-string">&quot;callbacks&quot;</span>: [langfuse_handler]}
)`,wrap:!1}}),yl=new w({props:{title:"Visualizing Our Graph",local:"visualizing-our-graph",headingTag:"h2"}}),jl=new r({props:{code:"Y29tcGlsZWRfZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygp",highlighted:"compiled_graph.get_graph().draw_mermaid_png()",wrap:!1}}),wl=new w({props:{title:"What We’ve Built",local:"what-weve-built",headingTag:"h2"}}),hl=new w({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),Il=new w({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),gl=new ft({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/first_graph.mdx"}}),{c(){U=M("meta"),Bl=e(),Cl=M("p"),Wl=e(),J(h.$$.fragment),Zl=e(),J(u.$$.fragment),Gl=e(),I=M("p"),I.textContent=Ss,El=e(),d=M("ol"),d.innerHTML=Vs,ql=e(),g=M("p"),g.textContent=Ys,Al=e(),m=M("blockquote"),m.innerHTML=Fs,Nl=e(),J(b.$$.fragment),Ql=e(),C=M("p"),C.textContent=_s,kl=e(),f=M("img"),Sl=e(),J(B.$$.fragment),Vl=e(),W=M("p"),W.textContent=$s,Yl=e(),J(Z.$$.fragment),Fl=e(),G=M("p"),G.textContent=xs,_l=e(),J(E.$$.fragment),Xl=e(),J(q.$$.fragment),$l=e(),A=M("p"),A.textContent=vs,xl=e(),J(N.$$.fragment),vl=e(),Q=M("blockquote"),Q.innerHTML=Rs,Rl=e(),J(k.$$.fragment),zl=e(),S=M("p"),S.textContent=zs,Hl=e(),J(V.$$.fragment),Ll=e(),J(Y.$$.fragment),Dl=e(),F=M("p"),F.textContent=Hs,Ol=e(),J(_.$$.fragment),Pl=e(),X=M("blockquote"),X.innerHTML=Ls,Kl=e(),J($.$$.fragment),ls=e(),x=M("p"),x.textContent=Ds,ss=e(),J(v.$$.fragment),ts=e(),R=M("p"),R.innerHTML=Os,as=e(),J(z.$$.fragment),es=e(),H=M("p"),H.textContent=Ps,ns=e(),J(L.$$.fragment),Ms=e(),J(D.$$.fragment),ps=e(),O=M("p"),O.textContent=Ks,is=e(),P=M("p"),P.innerHTML=lt,Js=e(),K=M("p"),K.textContent=st,ys=e(),J(ll.$$.fragment),os=e(),sl=M("p"),sl.textContent=tt,js=e(),J(tl.$$.fragment),Ts=e(),al=M("p"),al.innerHTML=at,cs=e(),J(el.$$.fragment),ws=e(),nl=M("p"),nl.innerHTML=et,rs=e(),J(Ml.$$.fragment),Us=e(),pl=M("p"),pl.textContent=nt,ms=e(),il=M("p"),il.innerHTML=Mt,hs=e(),Jl=M("p"),Jl.innerHTML=pt,us=e(),J(yl.$$.fragment),Is=e(),ol=M("p"),ol.textContent=it,ds=e(),J(jl.$$.fragment),gs=e(),Tl=M("img"),bs=e(),cl=M("p"),cl.textContent=yt,Cs=e(),J(wl.$$.fragment),fs=e(),rl=M("p"),rl.textContent=ot,Bs=e(),Ul=M("ol"),Ul.innerHTML=jt,Ws=e(),ml=M("p"),ml.textContent=Tt,Zs=e(),J(hl.$$.fragment),Gs=e(),ul=M("ul"),ul.innerHTML=ct,Es=e(),J(Il.$$.fragment),qs=e(),dl=M("p"),dl.textContent=wt,As=e(),J(gl.$$.fragment),Ns=e(),fl=M("p"),this.h()},l(l){const s=gt("svelte-u9bgzb",document.head);U=p(s,"META",{name:!0,content:!0}),s.forEach(t),Bl=n(l),Cl=p(l,"P",{}),Ut(Cl).forEach(t),Wl=n(l),y(h.$$.fragment,l),Zl=n(l),y(u.$$.fragment,l),Gl=n(l),I=p(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-vhd0jr"&&(I.textContent=Ss),El=n(l),d=p(l,"OL",{"data-svelte-h":!0}),i(d)!=="svelte-1v71265"&&(d.innerHTML=Vs),ql=n(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1qg9fnr"&&(g.textContent=Ys),Al=n(l),m=p(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(m)!=="svelte-1cfpqhk"&&(m.innerHTML=Fs),Nl=n(l),y(b.$$.fragment,l),Ql=n(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-9r2hfn"&&(C.textContent=_s),kl=n(l),f=p(l,"IMG",{src:!0,alt:!0}),Sl=n(l),y(B.$$.fragment,l),Vl=n(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1n92y5t"&&(W.textContent=$s),Yl=n(l),y(Z.$$.fragment,l),Fl=n(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-rnel3w"&&(G.textContent=xs),_l=n(l),y(E.$$.fragment,l),Xl=n(l),y(q.$$.fragment,l),$l=n(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-54271l"&&(A.textContent=vs),xl=n(l),y(N.$$.fragment,l),vl=n(l),Q=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Q)!=="svelte-10gtfo"&&(Q.innerHTML=Rs),Rl=n(l),y(k.$$.fragment,l),zl=n(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1d4gnq4"&&(S.textContent=zs),Hl=n(l),y(V.$$.fragment,l),Ll=n(l),y(Y.$$.fragment,l),Dl=n(l),F=p(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1n2afnf"&&(F.textContent=Hs),Ol=n(l),y(_.$$.fragment,l),Pl=n(l),X=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(X)!=="svelte-k4q46u"&&(X.innerHTML=Ls),Kl=n(l),y($.$$.fragment,l),ls=n(l),x=p(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1c3pli7"&&(x.textContent=Ds),ss=n(l),y(v.$$.fragment,l),ts=n(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-18k1jtw"&&(R.innerHTML=Os),as=n(l),y(z.$$.fragment,l),es=n(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1kryxnq"&&(H.textContent=Ps),ns=n(l),y(L.$$.fragment,l),Ms=n(l),y(D.$$.fragment,l),ps=n(l),O=p(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-xyrseq"&&(O.textContent=Ks),is=n(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-i70kr9"&&(P.innerHTML=lt),Js=n(l),K=p(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-fhqopd"&&(K.textContent=st),ys=n(l),y(ll.$$.fragment,l),os=n(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1ketwty"&&(sl.textContent=tt),js=n(l),y(tl.$$.fragment,l),Ts=n(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-1i2d6na"&&(al.innerHTML=at),cs=n(l),y(el.$$.fragment,l),ws=n(l),nl=p(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1bzsazf"&&(nl.innerHTML=et),rs=n(l),y(Ml.$$.fragment,l),Us=n(l),pl=p(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-blbazh"&&(pl.textContent=nt),ms=n(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-3rgcl6"&&(il.innerHTML=Mt),hs=n(l),Jl=p(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-1kmw2a1"&&(Jl.innerHTML=pt),us=n(l),y(yl.$$.fragment,l),Is=n(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1wkuxx2"&&(ol.textContent=it),ds=n(l),y(jl.$$.fragment,l),gs=n(l),Tl=p(l,"IMG",{src:!0,alt:!0}),bs=n(l),cl=p(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-hhguub"&&(cl.textContent=yt),Cs=n(l),y(wl.$$.fragment,l),fs=n(l),rl=p(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1vjenz"&&(rl.textContent=ot),Bs=n(l),Ul=p(l,"OL",{"data-svelte-h":!0}),i(Ul)!=="svelte-eyxtqr"&&(Ul.innerHTML=jt),Ws=n(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1evobzg"&&(ml.textContent=Tt),Zs=n(l),y(hl.$$.fragment,l),Gs=n(l),ul=p(l,"UL",{"data-svelte-h":!0}),i(ul)!=="svelte-w0bhrr"&&(ul.innerHTML=ct),Es=n(l),y(Il.$$.fragment,l),qs=n(l),dl=p(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-1kcwc84"&&(dl.textContent=wt),As=n(l),y(gl.$$.fragment,l),Ns=n(l),fl=p(l,"P",{}),Ut(fl).forEach(t),this.h()},h(){bl(U,"name","hf:doc:metadata"),bl(U,"content",Wt),bl(m,"class","tip"),rt(f.src,Xs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/first_graph.png")||bl(f,"src",Xs),bl(f,"alt","First LangGraph"),rt(Tl.src,Jt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/mail_flow.png")||bl(Tl,"src",Jt),bl(Tl,"alt","Mail LangGraph")},m(l,s){bt(document.head,U),a(l,Bl,s),a(l,Cl,s),a(l,Wl,s),o(h,l,s),a(l,Zl,s),o(u,l,s),a(l,Gl,s),a(l,I,s),a(l,El,s),a(l,d,s),a(l,ql,s),a(l,g,s),a(l,Al,s),a(l,m,s),a(l,Nl,s),o(b,l,s),a(l,Ql,s),a(l,C,s),a(l,kl,s),a(l,f,s),a(l,Sl,s),o(B,l,s),a(l,Vl,s),a(l,W,s),a(l,Yl,s),o(Z,l,s),a(l,Fl,s),a(l,G,s),a(l,_l,s),o(E,l,s),a(l,Xl,s),o(q,l,s),a(l,$l,s),a(l,A,s),a(l,xl,s),o(N,l,s),a(l,vl,s),a(l,Q,s),a(l,Rl,s),o(k,l,s),a(l,zl,s),a(l,S,s),a(l,Hl,s),o(V,l,s),a(l,Ll,s),o(Y,l,s),a(l,Dl,s),a(l,F,s),a(l,Ol,s),o(_,l,s),a(l,Pl,s),a(l,X,s),a(l,Kl,s),o($,l,s),a(l,ls,s),a(l,x,s),a(l,ss,s),o(v,l,s),a(l,ts,s),a(l,R,s),a(l,as,s),o(z,l,s),a(l,es,s),a(l,H,s),a(l,ns,s),o(L,l,s),a(l,Ms,s),o(D,l,s),a(l,ps,s),a(l,O,s),a(l,is,s),a(l,P,s),a(l,Js,s),a(l,K,s),a(l,ys,s),o(ll,l,s),a(l,os,s),a(l,sl,s),a(l,js,s),o(tl,l,s),a(l,Ts,s),a(l,al,s),a(l,cs,s),o(el,l,s),a(l,ws,s),a(l,nl,s),a(l,rs,s),o(Ml,l,s),a(l,Us,s),a(l,pl,s),a(l,ms,s),a(l,il,s),a(l,hs,s),a(l,Jl,s),a(l,us,s),o(yl,l,s),a(l,Is,s),a(l,ol,s),a(l,ds,s),o(jl,l,s),a(l,gs,s),a(l,Tl,s),a(l,bs,s),a(l,cl,s),a(l,Cs,s),o(wl,l,s),a(l,fs,s),a(l,rl,s),a(l,Bs,s),a(l,Ul,s),a(l,Ws,s),a(l,ml,s),a(l,Zs,s),o(hl,l,s),a(l,Gs,s),a(l,ul,s),a(l,Es,s),o(Il,l,s),a(l,qs,s),a(l,dl,s),a(l,As,s),o(gl,l,s),a(l,Ns,s),a(l,fl,s),Qs=!0},p:ht,i(l){Qs||(j(h.$$.fragment,l),j(u.$$.fragment,l),j(b.$$.fragment,l),j(B.$$.fragment,l),j(Z.$$.fragment,l),j(E.$$.fragment,l),j(q.$$.fragment,l),j(N.$$.fragment,l),j(k.$$.fragment,l),j(V.$$.fragment,l),j(Y.$$.fragment,l),j(_.$$.fragment,l),j($.$$.fragment,l),j(v.$$.fragment,l),j(z.$$.fragment,l),j(L.$$.fragment,l),j(D.$$.fragment,l),j(ll.$$.fragment,l),j(tl.$$.fragment,l),j(el.$$.fragment,l),j(Ml.$$.fragment,l),j(yl.$$.fragment,l),j(jl.$$.fragment,l),j(wl.$$.fragment,l),j(hl.$$.fragment,l),j(Il.$$.fragment,l),j(gl.$$.fragment,l),Qs=!0)},o(l){T(h.$$.fragment,l),T(u.$$.fragment,l),T(b.$$.fragment,l),T(B.$$.fragment,l),T(Z.$$.fragment,l),T(E.$$.fragment,l),T(q.$$.fragment,l),T(N.$$.fragment,l),T(k.$$.fragment,l),T(V.$$.fragment,l),T(Y.$$.fragment,l),T(_.$$.fragment,l),T($.$$.fragment,l),T(v.$$.fragment,l),T(z.$$.fragment,l),T(L.$$.fragment,l),T(D.$$.fragment,l),T(ll.$$.fragment,l),T(tl.$$.fragment,l),T(el.$$.fragment,l),T(Ml.$$.fragment,l),T(yl.$$.fragment,l),T(jl.$$.fragment,l),T(wl.$$.fragment,l),T(hl.$$.fragment,l),T(Il.$$.fragment,l),T(gl.$$.fragment,l),Qs=!1},d(l){l&&(t(Bl),t(Cl),t(Wl),t(Zl),t(Gl),t(I),t(El),t(d),t(ql),t(g),t(Al),t(m),t(Nl),t(Ql),t(C),t(kl),t(f),t(Sl),t(Vl),t(W),t(Yl),t(Fl),t(G),t(_l),t(Xl),t($l),t(A),t(xl),t(vl),t(Q),t(Rl),t(zl),t(S),t(Hl),t(Ll),t(Dl),t(F),t(Ol),t(Pl),t(X),t(Kl),t(ls),t(x),t(ss),t(ts),t(R),t(as),t(es),t(H),t(ns),t(Ms),t(ps),t(O),t(is),t(P),t(Js),t(K),t(ys),t(os),t(sl),t(js),t(Ts),t(al),t(cs),t(ws),t(nl),t(rs),t(Us),t(pl),t(ms),t(il),t(hs),t(Jl),t(us),t(Is),t(ol),t(ds),t(gs),t(Tl),t(bs),t(cl),t(Cs),t(fs),t(rl),t(Bs),t(Ul),t(Ws),t(ml),t(Zs),t(Gs),t(ul),t(Es),t(qs),t(dl),t(As),t(Ns),t(fl)),t(U),c(h,l),c(u,l),c(b,l),c(B,l),c(Z,l),c(E,l),c(q,l),c(N,l),c(k,l),c(V,l),c(Y,l),c(_,l),c($,l),c(v,l),c(z,l),c(L,l),c(D,l),c(ll,l),c(tl,l),c(el,l),c(Ml,l),c(yl,l),c(jl,l),c(wl,l),c(hl,l),c(Il,l),c(gl,l)}}}const Wt='{"title":"Building Your First LangGraph","local":"building-your-first-langgraph","sections":[{"title":"Our Workflow","local":"our-workflow","sections":[],"depth":2},{"title":"Setting Up Our Environment","local":"setting-up-our-environment","sections":[],"depth":2},{"title":"Step 1: Define Our State","local":"step-1-define-our-state","sections":[],"depth":2},{"title":"Step 2: Define Our Nodes","local":"step-2-define-our-nodes","sections":[],"depth":2},{"title":"Step 3: Define Our Routing Logic","local":"step-3-define-our-routing-logic","sections":[],"depth":2},{"title":"Step 4: Create the StateGraph and Define Edges","local":"step-4-create-the-stategraph-and-define-edges","sections":[],"depth":2},{"title":"Step 5: Run the Application","local":"step-5-run-the-application","sections":[],"depth":2},{"title":"Step 6: Inspecting Our Mail Sorting Agent with Langfuse 📡","local":"step-6-inspecting-our-mail-sorting-agent-with-langfuse-","sections":[],"depth":2},{"title":"Visualizing Our Graph","local":"visualizing-our-graph","sections":[],"depth":2},{"title":"What We’ve Built","local":"what-weve-built","sections":[],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function Zt(ks){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends It{constructor(U){super(),dt(this,U,Zt,Bt,mt,{})}}export{kt as component};
