import{s as Qt,a as _t,n as Nt,o as St}from"../chunks/scheduler.505acc25.js";import{S as Rt,i as Yt,e as i,s as a,c as r,h as Ht,a as o,d as l,b as n,f as it,g as p,j as M,k as J,l as Et,m as s,n as y,t as c,o as w,p as h}from"../chunks/index.fbb49fb4.js";import{C as $t}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as d}from"../chunks/CodeBlock.7f0851b7.js";import{C as zt}from"../chunks/CourseFloatingBanner.742f9db5.js";import{H as nt}from"../chunks/Heading.511e0027.js";import{E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function qt(ot){let u,ye,re,ce,b,we,I,he,g,me,U,Mt=`<p>The examples in this section require access to a powerful VLM model. We tested them using the GPT-4o API.<br/>
However, <a href="./why_use_smolagents">Why use smolagents</a> discusses alternative solutions supported by smolagents and Hugging Face. If you’d like to explore other options, be sure to check that section.</p>`,Je,f,rt="Empowering agents with visual capabilities is crucial for solving tasks that go beyond text processing. Many real-world challenges, such as web browsing or document understanding, require analyzing rich visual content. Fortunately, <code>smolagents</code> provides built-in support for vision-language models (VLMs), enabling agents to process and interpret images effectively.",ue,C,pt="In this example, imagine Alfred, the butler at Wayne Manor, is tasked with verifying the identities of the guests attending the party. As you can imagine, Alfred may not be familiar with everyone arriving. To help him, we can use an agent that verifies their identity by searching for visual information about their appearance using a VLM. This will allow Alfred to make informed decisions about who can enter. Let’s build this example!",de,B,Ue,T,yt='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',Te,v,ct="In this approach, images are passed to the agent at the start and stored as <code>task_images</code> alongside the task prompt. The agent then processes these images throughout its execution.",je,G,wt="Consider the case where Alfred wants to verify the identities of the superheroes attending the party. He already has a dataset of images from previous parties with the names of the guests. Given a new visitor’s image, the agent can compare it with the existing dataset and make a decision about letting them in.",be,Z,ht="In this case, a guest is trying to enter, and Alfred suspects that this visitor might be The Joker impersonating Wonder Woman. Alfred needs to verify their identity to prevent anyone unwanted from entering.",Ie,W,mt="Let’s build the example. First, the images are loaded. In this case, we use images from Wikipedia to keep the example minimal, but imagine the possible use-case!",ge,k,fe,V,Jt="Now that we have the images, the agent will tell us whether one guest is actually a superhero (Wonder Woman) or a villain (The Joker).",Ce,A,Be,x,ut="In the case of my run, the output is the following, although it could vary in your case, as we’ve already discussed:",ve,X,Ge,Q,dt="In this case, the output reveals that the person is impersonating someone else, so we can prevent The Joker from entering the party!",Ze,_,We,j,Ut='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_web_browser.py" target="_blank">this Python file</a></p>',ke,N,Tt="The previous approach is valuable and has many potential use cases. However, in situations where the guest is not in the database, we need to explore other ways of identifying them. One possible solution is to dynamically retrieve images and information from external sources, such as browsing the web for details.",Ve,S,jt="In this approach, images are dynamically added to the agent’s memory during execution. As we know, agents in <code>smolagents</code> are based on the <code>MultiStepAgent</code> class, which is an abstraction of the ReAct framework. This class operates in a structured cycle where various variables and knowledge are logged at different stages:",Ae,R,bt="<li><strong>SystemPromptStep:</strong> Stores the system prompt.</li> <li><strong>TaskStep:</strong> Logs the user query and any provided input.</li> <li><strong>ActionStep:</strong> Captures logs from the agent’s actions and results.</li>",xe,Y,It="This structured approach allows agents to incorporate visual information dynamically and respond adaptively to evolving tasks. Below is the diagram we’ve already seen, illustrating the dynamic workflow process and how different steps integrate within the agent lifecycle. When browsing, the agent can take screenshots and save them as <code>observation_images</code> in the <code>ActionStep</code>.",Xe,H,gt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/smolagents-can-see/diagram_adding_vlms_smolagents.png" alt="Dynamic image retrieval"/>',Qe,E,ft="Now that we understand the need, let’s build our complete example. In this case, Alfred wants full control over the guest verification process, so browsing for details becomes a viable solution. To complete this example, we need a new set of tools for the agent. Additionally, we’ll use Selenium and Helium, which are browser automation tools. This will allow us to build an agent that explores the web, searching for details about a potential guest and retrieving verification information. Let’s install the tools needed:",_e,$,Ne,z,Ct="We’ll need a set of agent tools specifically designed for browsing, such as <code>search_item_ctrl_f</code>, <code>go_back</code>, and <code>close_popups</code>. These tools allow the agent to act like a person navigating the web.",Se,F,Re,q,Bt="We also need functionality for saving screenshots, as this will be an essential part of what our VLM agent uses to complete the task. This functionality captures the screenshot and saves it in <code>step_log.observations_images = [image.copy()]</code>, allowing the agent to store and process the images dynamically as it navigates.",Ye,L,He,P,vt="This function is passed to the agent as <code>step_callback</code>, as it’s triggered at the end of each step during the agent’s execution. This allows the agent to dynamically capture and store screenshots throughout its process.",Ee,D,Gt="Now, we can generate our vision agent for browsing the web, providing it with the tools we created, along with the <code>DuckDuckGoSearchTool</code> to explore the web. This tool will help the agent retrieve necessary information for verifying guests’ identities based on visual cues.",$e,K,ze,O,Zt="With that, Alfred is ready to check the guests’ identities and make informed decisions about whether to let them into the party:",Fe,ee,qe,te,Wt="You can see that we include <code>helium_instructions</code> as part of the task. This special prompt is aimed to control the navigation of the agent, ensuring that it follows the correct steps while browsing the web.",Le,le,kt="Let’s see how this works in the video below:",Pe,m,Vt,De,se,At="This is the final output:",Ke,ae,Oe,ne,xt="With all of that, we’ve successfully created our identity verifier for the party! Alfred now has the necessary tools to ensure only the right guests make it through the door. Everything is set to have a good time at Wayne Manor!",et,ie,tt,oe,Xt='<li><a href="https://huggingface.co/blog/smolagents-can-see" rel="nofollow">We just gave sight to smolagents</a> - Blog describing the vision agent functionality.</li> <li><a href="https://huggingface.co/docs/smolagents/examples/web_browser" rel="nofollow">Web Browser Automation with Agents 🤖🌐</a> - Example for Web browsing using a vision agent.</li> <li><a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">Web Browser Vision Agent Example</a> - Example for Web browsing using a vision agent.</li>',lt,Me,st,pe,at;return b=new zt({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),I=new $t({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new nt({props:{title:"Vision Agents with smolagents",local:"vision-agents-with-smolagents",headingTag:"h1"}}),B=new nt({props:{title:"Providing Images at the Start of the Agent’s Execution",local:"providing-images-at-the-start-of-the-agents-execution",headingTag:"h2"}}),k=new d({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBJTBBaW1hZ2VfdXJscyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGZSUyRmU4JTJGVGhlX0pva2VyX2F0X1dheF9NdXNldW1fUGx1cy5qcGclMjIlMkMlMjAlMjMlMjBKb2tlciUyMGltYWdlJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cGxvYWQud2lraW1lZGlhLm9yZyUyRndpa2lwZWRpYSUyRmVuJTJGOSUyRjk4JTJGSm9rZXJfJTI1MjhEQ19Db21pY3NfY2hhcmFjdGVyJTI1MjkuanBnJTIyJTIwJTIzJTIwSm9rZXIlMjBpbWFnZSUwQSU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMHVybCUyMGluJTIwaW1hZ2VfdXJscyUzQSUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyLUFnZW50JTIyJTNBJTIwJTIyTW96aWxsYSUyRjUuMCUyMChXaW5kb3dzJTIwTlQlMjAxMC4wJTNCJTIwV2luNjQlM0IlMjB4NjQpJTIwQXBwbGVXZWJLaXQlMkY1MzcuMzYlMjAoS0hUTUwlMkMlMjBsaWtlJTIwR2Vja28pJTIwQ2hyb21lJTJGMTE0LjAuMC4wJTIwU2FmYXJpJTJGNTM3LjM2JTIyJTIwJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsJTJDaGVhZGVycyUzRGhlYWRlcnMpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUyMCUyMCUyMCUyMGltYWdlcy5hcHBlbmQoaW1hZ2Up",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

image_urls = [
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/e/e8/The_Joker_at_Wax_Museum_Plus.jpg&quot;</span>, <span class="hljs-comment"># Joker image</span>
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/en/9/98/Joker_%28DC_Comics_character%29.jpg&quot;</span> <span class="hljs-comment"># Joker image</span>
]

images = []
<span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> image_urls:
    headers = {
        <span class="hljs-string">&quot;User-Agent&quot;</span>: <span class="hljs-string">&quot;Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36&quot;</span> 
    }
    response = requests.get(url,headers=headers)
    image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
    images.append(image)`,wrap:!1}}),A=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwobW9kZWxfaWQlM0QlMjJncHQtNG8lMjIpJTBBJTBBJTIzJTIwSW5zdGFudGlhdGUlMjB0aGUlMjBhZ2VudCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMiUwQSklMEElMEFyZXNwb25zZSUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBEZXNjcmliZSUyMHRoZSUyMGNvc3R1bWUlMjBhbmQlMjBtYWtldXAlMjB0aGF0JTIwdGhlJTIwY29taWMlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZXNlJTIwcGhvdG9zJTIwaXMlMjB3ZWFyaW5nJTIwYW5kJTIwcmV0dXJuJTIwdGhlJTIwZGVzY3JpcHRpb24uJTBBJTIwJTIwJTIwJTIwVGVsbCUyMG1lJTIwaWYlMjB0aGUlMjBndWVzdCUyMGlzJTIwVGhlJTIwSm9rZXIlMjBvciUyMFdvbmRlciUyMFdvbWFuLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlcyUzRGltYWdlcyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel

model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-comment"># Instantiate the agent</span>
agent = CodeAgent(
    tools=[],
    model=model,
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

response = agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Describe the costume and makeup that the comic character in these photos is wearing and return the description.
    Tell me if the guest is The Joker or Wonder Woman.
    &quot;&quot;&quot;</span>,
    images=images
)`,wrap:!1}}),X=new d({props:{code:"JTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ0Nvc3R1bWUlMjBhbmQlMjBNYWtldXAlMjAtJTIwRmlyc3QlMjBJbWFnZSclM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ1B1cnBsZSUyMGNvYXQlMjBhbmQlMjBhJTIwcHVycGxlJTIwc2lsay1saWtlJTIwY3JhdmF0JTIwb3IlMjB0aWUlMjBvdmVyJTIwYSUyMG11c3RhcmQteWVsbG93JTIwc2hpcnQuJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdXaGl0ZSUyMGZhY2UlMjBwYWludCUyMHdpdGglMjBleGFnZ2VyYXRlZCUyMGZlYXR1cmVzJTJDJTIwZGFyayUyMGV5ZWJyb3dzJTJDJTIwYmx1ZSUyMGV5ZSUyMG1ha2V1cCUyQyUyMHJlZCUyMGxpcHMlMjBmb3JtaW5nJTIwYSUyMHdpZGUlMjBzbWlsZS4nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdDb3N0dW1lJTIwYW5kJTIwTWFrZXVwJTIwLSUyMFNlY29uZCUyMEltYWdlJyUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnRGFyayUyMHN1aXQlMjB3aXRoJTIwYSUyMGZsb3dlciUyMG9uJTIwdGhlJTIwbGFwZWwlMkMlMjBob2xkaW5nJTIwYSUyMHBsYXlpbmclMjBjYXJkLiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnUGFsZSUyMHNraW4lMkMlMjBncmVlbiUyMGhhaXIlMkMlMjB2ZXJ5JTIwcmVkJTIwbGlwcyUyMHdpdGglMjBhbiUyMGV4YWdnZXJhdGVkJTIwZ3Jpbi4nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdDaGFyYWN0ZXIlMjBJZGVudGl0eSclM0ElMjAnVGhpcyUyMGNoYXJhY3RlciUyMHJlc2VtYmxlcyUyMGtub3duJTIwZGVwaWN0aW9ucyUyMG9mJTIwVGhlJTIwSm9rZXIlMjBmcm9tJTIwY29taWMlMjBib29rJTIwbWVkaWEuJyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`    {
        <span class="hljs-string">&#x27;Costume and Makeup - First Image&#x27;</span>: (
            <span class="hljs-string">&#x27;Purple coat and a purple silk-like cravat or tie over a mustard-yellow shirt.&#x27;</span>,
            <span class="hljs-string">&#x27;White face paint with exaggerated features, dark eyebrows, blue eye makeup, red lips forming a wide smile.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Costume and Makeup - Second Image&#x27;</span>: (
            <span class="hljs-string">&#x27;Dark suit with a flower on the lapel, holding a playing card.&#x27;</span>,
            <span class="hljs-string">&#x27;Pale skin, green hair, very red lips with an exaggerated grin.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Character Identity&#x27;</span>: <span class="hljs-string">&#x27;This character resembles known depictions of The Joker from comic book media.&#x27;</span>
    }`,wrap:!1}}),_=new nt({props:{title:"Providing Images with Dynamic Retrieval",local:"providing-images-with-dynamic-retrieval",headingTag:"h2"}}),$=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJhbGwlNUQlMjIlMjBoZWxpdW0lMjBzZWxlbml1bSUyMHB5dGhvbi1kb3RlbnY=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[all]&quot;</span> helium selenium python-dotenv',wrap:!1}}),F=new d({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">search_item_ctrl_f</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span>, nth_result: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Searches for text on the current page via Ctrl + F and jumps to the nth occurrence.
    Args:
        text: The text to search for
        nth_result: Which occurrence to jump to (default: 1)
    &quot;&quot;&quot;</span>
    elements = driver.find_elements(By.XPATH, <span class="hljs-string">f&quot;//*[contains(text(), &#x27;<span class="hljs-subst">{text}</span>&#x27;)]&quot;</span>)
    <span class="hljs-keyword">if</span> nth_result &gt; <span class="hljs-built_in">len</span>(elements):
        <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">f&quot;Match n°<span class="hljs-subst">{nth_result}</span> not found (only <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches found)&quot;</span>)
    result = <span class="hljs-string">f&quot;Found <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches for &#x27;<span class="hljs-subst">{text}</span>&#x27;.&quot;</span>
    elem = elements[nth_result - <span class="hljs-number">1</span>]
    driver.execute_script(<span class="hljs-string">&quot;arguments[0].scrollIntoView(true);&quot;</span>, elem)
    result += <span class="hljs-string">f&quot;Focused on element <span class="hljs-subst">{nth_result}</span> of <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span>&quot;</span>
    <span class="hljs-keyword">return</span> result


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">go_back</span>() -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Goes back to previous page.&quot;&quot;&quot;</span>
    driver.back()


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">close_popups</span>() -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Closes any visible modal or pop-up on the page. Use this to dismiss pop-up windows! This does not work on cookie consent banners.
    &quot;&quot;&quot;</span>
    webdriver.ActionChains(driver).send_keys(Keys.ESCAPE).perform()`,wrap:!1}}),L=new d({props:{code:"ZGVmJTIwc2F2ZV9zY3JlZW5zaG90KHN0ZXBfbG9nJTNBJTIwQWN0aW9uU3RlcCUyQyUyMGFnZW50JTNBJTIwQ29kZUFnZW50KSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2xlZXAoMS4wKSUyMCUyMCUyMyUyMExldCUyMEphdmFTY3JpcHQlMjBhbmltYXRpb25zJTIwaGFwcGVuJTIwYmVmb3JlJTIwdGFraW5nJTIwdGhlJTIwc2NyZWVuc2hvdCUwQSUyMCUyMCUyMCUyMGRyaXZlciUyMCUzRCUyMGhlbGl1bS5nZXRfZHJpdmVyKCklMEElMjAlMjAlMjAlMjBjdXJyZW50X3N0ZXAlMjAlM0QlMjBzdGVwX2xvZy5zdGVwX251bWJlciUwQSUyMCUyMCUyMCUyMGlmJTIwZHJpdmVyJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwc3RlcF9sb2dzJTIwaW4lMjBhZ2VudC5sb2dzJTNBJTIwJTIwJTIzJTIwUmVtb3ZlJTIwcHJldmlvdXMlMjBzY3JlZW5zaG90cyUyMGZyb20lMjBsb2dzJTIwZm9yJTIwbGVhbiUyMHByb2Nlc3NpbmclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2Uoc3RlcF9sb2clMkMlMjBBY3Rpb25TdGVwKSUyMGFuZCUyMHN0ZXBfbG9nLnN0ZXBfbnVtYmVyJTIwJTNDJTNEJTIwY3VycmVudF9zdGVwJTIwLSUyMDIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVwX2xvZ3Mub2JzZXJ2YXRpb25zX2ltYWdlcyUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbmdfYnl0ZXMlMjAlM0QlMjBkcml2ZXIuZ2V0X3NjcmVlbnNob3RfYXNfcG5nKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhwbmdfYnl0ZXMpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJDYXB0dXJlZCUyMGElMjBicm93c2VyJTIwc2NyZWVuc2hvdCUzQSUyMCU3QmltYWdlLnNpemUlN0QlMjBwaXhlbHMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlcF9sb2cub2JzZXJ2YXRpb25zX2ltYWdlcyUyMCUzRCUyMCU1QmltYWdlLmNvcHkoKSU1RCUyMCUyMCUyMyUyMENyZWF0ZSUyMGElMjBjb3B5JTIwdG8lMjBlbnN1cmUlMjBpdCUyMHBlcnNpc3RzJTJDJTIwaW1wb3J0YW50ISUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVwZGF0ZSUyMG9ic2VydmF0aW9ucyUyMHdpdGglMjBjdXJyZW50JTIwVVJMJTBBJTIwJTIwJTIwJTIwdXJsX2luZm8lMjAlM0QlMjBmJTIyQ3VycmVudCUyMHVybCUzQSUyMCU3QmRyaXZlci5jdXJyZW50X3VybCU3RCUyMiUwQSUyMCUyMCUyMCUyMHN0ZXBfbG9nLm9ic2VydmF0aW9ucyUyMCUzRCUyMHVybF9pbmZvJTIwaWYlMjBzdGVwX2xvZ3Mub2JzZXJ2YXRpb25zJTIwaXMlMjBOb25lJTIwZWxzZSUyMHN0ZXBfbG9nLm9ic2VydmF0aW9ucyUyMCUyQiUyMCUyMiU1Q24lMjIlMjAlMkIlMjB1cmxfaW5mbyUwQSUyMCUyMCUyMCUyMHJldHVybg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">save_screenshot</span>(<span class="hljs-params">step_log: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Let JavaScript animations happen before taking the screenshot</span>
    driver = helium.get_driver()
    current_step = step_log.step_number
    <span class="hljs-keyword">if</span> driver <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">for</span> step_logs <span class="hljs-keyword">in</span> agent.logs:  <span class="hljs-comment"># Remove previous screenshots from logs for lean processing</span>
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(step_log, ActionStep) <span class="hljs-keyword">and</span> step_log.step_number &lt;= current_step - <span class="hljs-number">2</span>:
                step_logs.observations_images = <span class="hljs-literal">None</span>
        png_bytes = driver.get_screenshot_as_png()
        image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Captured a browser screenshot: <span class="hljs-subst">{image.size}</span> pixels&quot;</span>)
        step_log.observations_images = [image.copy()]  <span class="hljs-comment"># Create a copy to ensure it persists, important!</span>

    <span class="hljs-comment"># Update observations with current URL</span>
    url_info = <span class="hljs-string">f&quot;Current url: <span class="hljs-subst">{driver.current_url}</span>&quot;</span>
    step_log.observations = url_info <span class="hljs-keyword">if</span> step_logs.observations <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> step_log.observations + <span class="hljs-string">&quot;\\n&quot;</span> + url_info
    <span class="hljs-keyword">return</span>`,wrap:!1}}),K=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlTZXJ2ZXJNb2RlbChtb2RlbF9pZCUzRCUyMmdwdC00byUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjBnb19iYWNrJTJDJTIwY2xvc2VfcG9wdXBzJTJDJTIwc2VhcmNoX2l0ZW1fY3RybF9mJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIyaGVsaXVtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RlcF9jYWxsYmFja3MlM0QlNUJzYXZlX3NjcmVlbnNob3QlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel, DuckDuckGoSearchTool
model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

agent = CodeAgent(
    tools=[DuckDuckGoSearchTool(), go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[save_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)`,wrap:!1}}),ee=new d({props:{code:"YWdlbnQucnVuKCUyMiUyMiUyMiUwQUklMjBhbSUyMEFsZnJlZCUyQyUyMHRoZSUyMGJ1dGxlciUyMG9mJTIwV2F5bmUlMjBNYW5vciUyQyUyMHJlc3BvbnNpYmxlJTIwZm9yJTIwdmVyaWZ5aW5nJTIwdGhlJTIwaWRlbnRpdHklMjBvZiUyMGd1ZXN0cyUyMGF0JTIwcGFydHkuJTIwQSUyMHN1cGVyaGVybyUyMGhhcyUyMGFycml2ZWQlMjBhdCUyMHRoZSUyMGVudHJhbmNlJTIwY2xhaW1pbmclMjB0byUyMGJlJTIwV29uZGVyJTIwV29tYW4lMkMlMjBidXQlMjBJJTIwbmVlZCUyMHRvJTIwY29uZmlybSUyMGlmJTIwc2hlJTIwaXMlMjB3aG8lMjBzaGUlMjBzYXlzJTIwc2hlJTIwaXMuJTBBJTBBUGxlYXNlJTIwc2VhcmNoJTIwZm9yJTIwaW1hZ2VzJTIwb2YlMjBXb25kZXIlMjBXb21hbiUyMGFuZCUyMGdlbmVyYXRlJTIwYSUyMGRldGFpbGVkJTIwdmlzdWFsJTIwZGVzY3JpcHRpb24lMjBiYXNlZCUyMG9uJTIwdGhvc2UlMjBpbWFnZXMuJTIwQWRkaXRpb25hbGx5JTJDJTIwbmF2aWdhdGUlMjB0byUyMFdpa2lwZWRpYSUyMHRvJTIwZ2F0aGVyJTIwa2V5JTIwZGV0YWlscyUyMGFib3V0JTIwaGVyJTIwYXBwZWFyYW5jZS4lMjBXaXRoJTIwdGhpcyUyMGluZm9ybWF0aW9uJTJDJTIwSSUyMGNhbiUyMGRldGVybWluZSUyMHdoZXRoZXIlMjB0byUyMGdyYW50JTIwaGVyJTIwYWNjZXNzJTIwdG8lMjB0aGUlMjBldmVudC4lMEElMjIlMjIlMjIlMjAlMkIlMjBoZWxpdW1faW5zdHJ1Y3Rpb25zKQ==",highlighted:`agent.run(<span class="hljs-string">&quot;&quot;&quot;
I am Alfred, the butler of Wayne Manor, responsible for verifying the identity of guests at party. A superhero has arrived at the entrance claiming to be Wonder Woman, but I need to confirm if she is who she says she is.

Please search for images of Wonder Woman and generate a detailed visual description based on those images. Additionally, navigate to Wikipedia to gather key details about her appearance. With this information, I can determine whether to grant her access to the event.
&quot;&quot;&quot;</span> + helium_instructions)`,wrap:!1}}),ae=new d({props:{code:"RmluYWwlMjBhbnN3ZXIlM0ElMjBXb25kZXIlMjBXb21hbiUyMGlzJTIwdHlwaWNhbGx5JTIwZGVwaWN0ZWQlMjB3ZWFyaW5nJTIwYSUyMHJlZCUyMGFuZCUyMGdvbGQlMjBidXN0aWVyJTJDJTIwYmx1ZSUyMHNob3J0cyUyMG9yJTIwc2tpcnQlMjB3aXRoJTIwd2hpdGUlMjBzdGFycyUyQyUyMGElMjBnb2xkZW4lMjB0aWFyYSUyQyUyMHNpbHZlciUyMGJyYWNlbGV0cyUyQyUyMGFuZCUyMGElMjBnb2xkZW4lMjBMYXNzbyUyMG9mJTIwVHJ1dGguJTIwU2hlJTIwaXMlMjBQcmluY2VzcyUyMERpYW5hJTIwb2YlMjBUaGVteXNjaXJhJTJDJTIwa25vd24lMjBhcyUyMERpYW5hJTIwUHJpbmNlJTIwaW4lMjB0aGUlMjB3b3JsZCUyMG9mJTIwbWVuLg==",highlighted:'Final answer: Wonder Woman <span class="hljs-keyword">is</span> typically depicted wearing a red <span class="hljs-keyword">and</span> gold bustier, blue shorts <span class="hljs-keyword">or</span> skirt <span class="hljs-keyword">with</span> white stars, a golden tiara, silver bracelets, <span class="hljs-keyword">and</span> a golden Lasso of Truth. She <span class="hljs-keyword">is</span> Princess Diana of Themyscira, known <span class="hljs-keyword">as</span> Diana Prince <span class="hljs-keyword">in</span> the world of men.',wrap:!1}}),ie=new nt({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),Me=new Ft({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/vision_agents.mdx"}}),{c(){u=i("meta"),ye=a(),re=i("p"),ce=a(),r(b.$$.fragment),we=a(),r(I.$$.fragment),he=a(),r(g.$$.fragment),me=a(),U=i("blockquote"),U.innerHTML=Mt,Je=a(),f=i("p"),f.innerHTML=rt,ue=a(),C=i("p"),C.textContent=pt,de=a(),r(B.$$.fragment),Ue=a(),T=i("blockquote"),T.innerHTML=yt,Te=a(),v=i("p"),v.innerHTML=ct,je=a(),G=i("p"),G.textContent=wt,be=a(),Z=i("p"),Z.textContent=ht,Ie=a(),W=i("p"),W.textContent=mt,ge=a(),r(k.$$.fragment),fe=a(),V=i("p"),V.textContent=Jt,Ce=a(),r(A.$$.fragment),Be=a(),x=i("p"),x.textContent=ut,ve=a(),r(X.$$.fragment),Ge=a(),Q=i("p"),Q.textContent=dt,Ze=a(),r(_.$$.fragment),We=a(),j=i("blockquote"),j.innerHTML=Ut,ke=a(),N=i("p"),N.textContent=Tt,Ve=a(),S=i("p"),S.innerHTML=jt,Ae=a(),R=i("ol"),R.innerHTML=bt,xe=a(),Y=i("p"),Y.innerHTML=It,Xe=a(),H=i("p"),H.innerHTML=gt,Qe=a(),E=i("p"),E.textContent=ft,_e=a(),r($.$$.fragment),Ne=a(),z=i("p"),z.innerHTML=Ct,Se=a(),r(F.$$.fragment),Re=a(),q=i("p"),q.innerHTML=Bt,Ye=a(),r(L.$$.fragment),He=a(),P=i("p"),P.innerHTML=vt,Ee=a(),D=i("p"),D.innerHTML=Gt,$e=a(),r(K.$$.fragment),ze=a(),O=i("p"),O.textContent=Zt,Fe=a(),r(ee.$$.fragment),qe=a(),te=i("p"),te.innerHTML=Wt,Le=a(),le=i("p"),le.textContent=kt,Pe=a(),m=i("iframe"),De=a(),se=i("p"),se.textContent=At,Ke=a(),r(ae.$$.fragment),Oe=a(),ne=i("p"),ne.textContent=xt,et=a(),r(ie.$$.fragment),tt=a(),oe=i("ul"),oe.innerHTML=Xt,lt=a(),r(Me.$$.fragment),st=a(),pe=i("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),ye=n(e),re=o(e,"P",{}),it(re).forEach(l),ce=n(e),p(b.$$.fragment,e),we=n(e),p(I.$$.fragment,e),he=n(e),p(g.$$.fragment,e),me=n(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(U)!=="svelte-1yatm6d"&&(U.innerHTML=Mt),Je=n(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1g52ok1"&&(f.innerHTML=rt),ue=n(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-myhrzo"&&(C.textContent=pt),de=n(e),p(B.$$.fragment,e),Ue=n(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-zoou4c"&&(T.innerHTML=yt),Te=n(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-cav1cd"&&(v.innerHTML=ct),je=n(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-dz13nx"&&(G.textContent=wt),be=n(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1gdr077"&&(Z.textContent=ht),Ie=n(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1b86gbf"&&(W.textContent=mt),ge=n(e),p(k.$$.fragment,e),fe=n(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1biumjp"&&(V.textContent=Jt),Ce=n(e),p(A.$$.fragment,e),Be=n(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-8ztzdn"&&(x.textContent=ut),ve=n(e),p(X.$$.fragment,e),Ge=n(e),Q=o(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1btcjd5"&&(Q.textContent=dt),Ze=n(e),p(_.$$.fragment,e),We=n(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(j)!=="svelte-fblc4c"&&(j.innerHTML=Ut),ke=n(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-snegxf"&&(N.textContent=Tt),Ve=n(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-cbqleh"&&(S.innerHTML=jt),Ae=n(e),R=o(e,"OL",{"data-svelte-h":!0}),M(R)!=="svelte-sp2fa7"&&(R.innerHTML=bt),xe=n(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1xu745q"&&(Y.innerHTML=It),Xe=n(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1ds9sjb"&&(H.innerHTML=gt),Qe=n(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-k9it6v"&&(E.textContent=ft),_e=n(e),p($.$$.fragment,e),Ne=n(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-18m9rfq"&&(z.innerHTML=Ct),Se=n(e),p(F.$$.fragment,e),Re=n(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-gyap3u"&&(q.innerHTML=Bt),Ye=n(e),p(L.$$.fragment,e),He=n(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-13yatx1"&&(P.innerHTML=vt),Ee=n(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1im8u68"&&(D.innerHTML=Gt),$e=n(e),p(K.$$.fragment,e),ze=n(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1w3h7ql"&&(O.textContent=Zt),Fe=n(e),p(ee.$$.fragment,e),qe=n(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-17wb0kz"&&(te.innerHTML=Wt),Le=n(e),le=o(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-cyg54y"&&(le.textContent=kt),Pe=n(e),m=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),it(m).forEach(l),De=n(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1487vwm"&&(se.textContent=At),Ke=n(e),p(ae.$$.fragment,e),Oe=n(e),ne=o(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1chr9du"&&(ne.textContent=xt),et=n(e),p(ie.$$.fragment,e),tt=n(e),oe=o(e,"UL",{"data-svelte-h":!0}),M(oe)!=="svelte-17l37zv"&&(oe.innerHTML=Xt),lt=n(e),p(Me.$$.fragment,e),st=n(e),pe=o(e,"P",{}),it(pe).forEach(l),this.h()},h(){J(u,"name","hf:doc:metadata"),J(u,"content",Lt),J(U,"class","warning"),J(T,"class","tip"),J(j,"class","tip"),J(m,"width","560"),J(m,"height","315"),_t(m.src,Vt="https://www.youtube.com/embed/rObJel7-OLc?si=TnNwQ8rqXqun_pqE")||J(m,"src",Vt),J(m,"title","YouTube video player"),J(m,"frameborder","0"),J(m,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),J(m,"referrerpolicy","strict-origin-when-cross-origin"),m.allowFullscreen=""},m(e,t){Et(document.head,u),s(e,ye,t),s(e,re,t),s(e,ce,t),y(b,e,t),s(e,we,t),y(I,e,t),s(e,he,t),y(g,e,t),s(e,me,t),s(e,U,t),s(e,Je,t),s(e,f,t),s(e,ue,t),s(e,C,t),s(e,de,t),y(B,e,t),s(e,Ue,t),s(e,T,t),s(e,Te,t),s(e,v,t),s(e,je,t),s(e,G,t),s(e,be,t),s(e,Z,t),s(e,Ie,t),s(e,W,t),s(e,ge,t),y(k,e,t),s(e,fe,t),s(e,V,t),s(e,Ce,t),y(A,e,t),s(e,Be,t),s(e,x,t),s(e,ve,t),y(X,e,t),s(e,Ge,t),s(e,Q,t),s(e,Ze,t),y(_,e,t),s(e,We,t),s(e,j,t),s(e,ke,t),s(e,N,t),s(e,Ve,t),s(e,S,t),s(e,Ae,t),s(e,R,t),s(e,xe,t),s(e,Y,t),s(e,Xe,t),s(e,H,t),s(e,Qe,t),s(e,E,t),s(e,_e,t),y($,e,t),s(e,Ne,t),s(e,z,t),s(e,Se,t),y(F,e,t),s(e,Re,t),s(e,q,t),s(e,Ye,t),y(L,e,t),s(e,He,t),s(e,P,t),s(e,Ee,t),s(e,D,t),s(e,$e,t),y(K,e,t),s(e,ze,t),s(e,O,t),s(e,Fe,t),y(ee,e,t),s(e,qe,t),s(e,te,t),s(e,Le,t),s(e,le,t),s(e,Pe,t),s(e,m,t),s(e,De,t),s(e,se,t),s(e,Ke,t),y(ae,e,t),s(e,Oe,t),s(e,ne,t),s(e,et,t),y(ie,e,t),s(e,tt,t),s(e,oe,t),s(e,lt,t),y(Me,e,t),s(e,st,t),s(e,pe,t),at=!0},p:Nt,i(e){at||(c(b.$$.fragment,e),c(I.$$.fragment,e),c(g.$$.fragment,e),c(B.$$.fragment,e),c(k.$$.fragment,e),c(A.$$.fragment,e),c(X.$$.fragment,e),c(_.$$.fragment,e),c($.$$.fragment,e),c(F.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(Me.$$.fragment,e),at=!0)},o(e){w(b.$$.fragment,e),w(I.$$.fragment,e),w(g.$$.fragment,e),w(B.$$.fragment,e),w(k.$$.fragment,e),w(A.$$.fragment,e),w(X.$$.fragment,e),w(_.$$.fragment,e),w($.$$.fragment,e),w(F.$$.fragment,e),w(L.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(ae.$$.fragment,e),w(ie.$$.fragment,e),w(Me.$$.fragment,e),at=!1},d(e){e&&(l(ye),l(re),l(ce),l(we),l(he),l(me),l(U),l(Je),l(f),l(ue),l(C),l(de),l(Ue),l(T),l(Te),l(v),l(je),l(G),l(be),l(Z),l(Ie),l(W),l(ge),l(fe),l(V),l(Ce),l(Be),l(x),l(ve),l(Ge),l(Q),l(Ze),l(We),l(j),l(ke),l(N),l(Ve),l(S),l(Ae),l(R),l(xe),l(Y),l(Xe),l(H),l(Qe),l(E),l(_e),l(Ne),l(z),l(Se),l(Re),l(q),l(Ye),l(He),l(P),l(Ee),l(D),l($e),l(ze),l(O),l(Fe),l(qe),l(te),l(Le),l(le),l(Pe),l(m),l(De),l(se),l(Ke),l(Oe),l(ne),l(et),l(tt),l(oe),l(lt),l(st),l(pe)),l(u),h(b,e),h(I,e),h(g,e),h(B,e),h(k,e),h(A,e),h(X,e),h(_,e),h($,e),h(F,e),h(L,e),h(K,e),h(ee,e),h(ae,e),h(ie,e),h(Me,e)}}}const Lt='{"title":"Vision Agents with smolagents","local":"vision-agents-with-smolagents","sections":[{"title":"Providing Images at the Start of the Agent’s Execution","local":"providing-images-at-the-start-of-the-agents-execution","sections":[],"depth":2},{"title":"Providing Images with Dynamic Retrieval","local":"providing-images-with-dynamic-retrieval","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Pt(ot){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class al extends Rt{constructor(u){super(),Yt(this,u,Pt,qt,Qt,{})}}export{al as component};
