# Small Quiz (ungraded) [[quiz2]]

It's time to test your understanding of the *Code Agents*, *Tool Calling Agents*, and *Tools* sections. This quiz is optional and not graded.

---

### Q1: What is the key difference between creating a tool with the `@tool` decorator versus creating a subclass of `Tool` in smolagents?

Which statement best describes the distinction between these two approaches for defining tools?

<Question
choices={[
  {
    text: "Using the <code>@tool</code> decorator is mandatory for retrieval-based tools, while subclasses of <code>Tool</code> are only for text-generation tasks",
    explain: "Both approaches can be used for any type of tool, including retrieval-based or text-generation tools.",
  },
  {
    text: "The <code>@tool</code> decorator is recommended for simple function-based tools, while subclasses of <code>Tool</code> offer more flexibility for complex functionality or custom metadata",
    explain: "This is correct. The decorator approach is simpler, but subclassing allows more customized behavior.",
    correct: true
  },
  {
    text: "<code>@tool</code> can only be used in multi-agent systems, while creating a <code>Tool</code> subclass is for single-agent scenarios",
    explain: "All agents (single or multi) can use either approach to define tools; there is no such restriction.",
  },
  {
    text: "Decorating a function with <code>@tool</code> replaces the need for a docstring, whereas subclasses must not include docstrings",
    explain: "Both methods benefit from clear docstrings. The decorator doesn't replace them, and a subclass can still have docstrings.",
  }
]}
/>

---

### Q2: How does a CodeAgent handle multi-step tasks using the ReAct (Reason + Act) approach?

Which statement correctly describes how the CodeAgent executes a series of steps to solve a task?

<Question
choices={[
  {
    text: "It passes each step to a different agent in a multi-agent system, then combines results",
    explain: "Although multi-agent systems can distribute tasks, CodeAgent itself can handle multiple steps on its own using ReAct.",
  },
  {
    text: "It stores every action in JSON for easy parsing before executing them all at once",
    explain: "This behavior matches ToolCallingAgent's JSON-based approach, not CodeAgent.",
  },
  {
    text: "It cycles through writing internal thoughts, generating Python code, executing the code, and logging the results until it arrives at a final answer",
    explain: "Correct. This describes the ReAct pattern that CodeAgent uses, including iterative reasoning and code execution.",
    correct: true
  },
  {
    text: "It relies on a vision module to validate code output before continuing to the next step",
    explain: "Vision capabilities are supported in smolagents, but they're not a default requirement for CodeAgent or the ReAct approach.",
  }
]}
/>

---

### Q3: Which of the following is a primary advantage of sharing a tool on the Hugging Face Hub?

Select the best reason why a developer might upload and share their custom tool.

<Question
choices={[
  {
    text: "It automatically integrates the tool with a MultiStepAgent for retrieval-augmented generation",
    explain: "Sharing a tool doesn't automatically set up retrieval or multi-step logic. It's just making the tool available.",
  },
  {
    text: "It allows others to discover, reuse, and integrate your tool in their smolagents without extra setup",
    explain: "Yes. Sharing on the Hub makes tools accessible for anyone (including yourself) to download and reuse quickly.",
    correct: true
  },
  {
    text: "It ensures that only CodeAgents can invoke the tool while ToolCallingAgents cannot",
    explain: "Both CodeAgents and ToolCallingAgents can invoke shared tools. There's no restriction by agent type.",
  },
  {
    text: "It converts your tool into a fully vision-capable function for image processing",
    explain: "Tool sharing doesn't alter the tool's functionality or add vision capabilities automatically.",
  }
]}
/>

---

### Q4: ToolCallingAgent differs from CodeAgent in how it executes actions. Which statement is correct?

Choose the option that accurately describes how ToolCallingAgent works.

<Question
choices={[
  {
    text: "ToolCallingAgent is only compatible with a multi-agent system, while CodeAgent can run alone",
    explain: "Either agent can be used alone or as part of a multi-agent system.",
  },
  {
    text: "ToolCallingAgent delegates all reasoning to a separate retrieval agent, then returns a final answer",
    explain: "ToolCallingAgent still uses a main LLM for reasoning; it doesn't rely solely on retrieval agents.",
  },
  {
    text: "ToolCallingAgent outputs JSON instructions specifying tool calls and arguments, which get parsed and executed",
    explain: "This is correct. ToolCallingAgent uses the JSON approach to define tool calls.",
    correct: true
  },
  {
    text: "ToolCallingAgent is only meant for single-step tasks and automatically stops after calling one tool",
    explain: "ToolCallingAgent can perform multiple steps if needed, just like CodeAgent.",
  }
]}
/>

---

### Q5: What is included in the smolagents default toolbox, and why might you use it?

Which statement best captures the purpose and contents of the default toolbox in smolagents?

<Question
choices={[
  {
    text: "It provides a set of commonly-used tools such as DuckDuckGo search, PythonInterpreterTool, and a final answer tool for quick prototyping",
    explain: "Correct. The default toolbox contains these ready-made tools for easy integration when building agents.",
    correct: true
  },
  {
    text: "It only supports vision-based tasks like image classification or OCR by default",
    explain: "Although smolagents can integrate vision-based features, the default toolbox isn't exclusively vision-oriented.",
  },
  {
    text: "It is intended solely for multi-agent systems and is incompatible with a single CodeAgent",
    explain: "The default toolbox can be used by any agent type, single or multi-agent setups alike.",
  },
  {
    text: "It adds advanced retrieval-based functionality for large-scale question answering from a vector store",
    explain: "While you can build retrieval tools, the default toolbox does not automatically provide advanced RAG features.",
  }
]}
/>

---

Congratulations on completing this quiz! 🎉 If any questions gave you trouble, revisit the *Code Agents*, *Tool Calling Agents*, or *Tools* sections to strengthen your understanding. If you aced it, you're well on your way to building robust smolagents applications!


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/quiz2.mdx" />