# Introduction to Use Case for Agentic RAG

![Agentic RAG banner](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit3/agentic-rag/thumbnail.jpg)

In this unit, we will help Alfred, our friendly agent who is hosting the gala, by using Agentic RAG to create a tool that can be used to answer questions about the guests at the gala. 

> [!TIP]
> This is a 'real-world' use case for Agentic RAG, that you could use in your own projects or workplaces. If you want to get more out of this project, why not try it out on your own use case and share in Discord?


You can choose any of the frameworks discussed in the course for this use case. We provide code samples for each in separate tabs.

## A Gala to Remember

Now, it's time to get our hands dirty with an actual use case. Let's set the stage!

**You decided to host the most extravagant and opulent party of the century.** This means lavish feasts, enchanting dancers, renowned DJs, exquisite drinks, a breathtaking fireworks display, and much more.

Alfred, your friendly neighbourhood agent, is getting ready to watch over all of your needs for this party, and **Alfred is going to manage everything himself**. To do so, he needs to have access to all of the information about the party, including the menu, the guests, the schedule, weather forecasts, and much more!

Not only that, but he also needs to make sure that the party is going to be a success, so **he needs to be able to answer any questions about the party during the party**, whilst handling unexpected situations that may arise.

He can't do this alone, so we need to make sure that Alfred has access to all of the information and tools he needs.

First, let's give him a list of hard requirements for the gala.

## The Gala Requirements

A properly educated person in the age of the **Renaissance** needs to have three main traits.
He or she needed to be profound in the **knowledge of sports, culture, and science**. So, we need to make sure we can impress our guests with our knowledge and provide them with a truly unforgettable gala.
However, to avoid any conflicts, there are some **topics, like politics and religion, that are to be avoided at a gala.** It needs to be a fun party without conflicts related to beliefs and ideals.

According to etiquette, **a good host should be aware of guests' backgrounds**, including their interests and endeavours. A good host also gossips and shares stories about the guests with one another.

Lastly, we need to make sure that we've got **some general knowledge about the weather** to ensure we can continuously find a real-time update to ensure perfect timing to launch the fireworks and end the gala with a bang! 🎆

As you can see, Alfred needs a lot of information to host the gala.
Luckily, we can help and prepare Alfred by giving him some **Retrieval Augmented Generation (RAG) training!**

Let's start by creating the tools that Alfred needs to be able to host the gala!


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/unit3/agentic-rag/introduction.mdx" />