# And now? What topics I should learn?

Agentic AI is a rapidly evolving field, and understanding foundational protocols is essential for building intelligent, autonomous systems. 

Two important standards you should get familiar with are:

- The **Model Context Protocol (MCP)**  
- The **Agent-to-Agent Protocol (A2A)**

## 🔌 Model Context Protocol (MCP)

The **Model Context Protocol (MCP)** by Anthropic is an open standard that enables AI models to securely and seamlessly **connect with external tools, data sources, and applications**, making agents more capable and autonomous.

Think of MCP as a **universal adapter**, like a USB-C port, that allows AI models to plug into various digital environments **without needing custom integration for each one**.

MCP is quickly gaining traction across the industry, with major companies like OpenAI and Google beginning to adopt it. 

📚 Learn more:
- [Anthropic's official announcement and documentation](https://www.anthropic.com/news/model-context-protocol)
- [MCP on Wikipedia](https://en.wikipedia.org/wiki/Model_Context_Protocol)
- [Blog on MCP](https://huggingface.co/blog/Kseniase/mcp)

## 🤝 Agent-to-Agent (A2A) Protocol

Google has developed the **Agent-to-Agent (A2A) protocol** as a complementary counterpart to Anthropic's Model Context Protocol (MCP).

While MCP connects agents to external tools, **A2A connects agents to each other**, paving the way for cooperative, multi-agent systems that can work together to solve complex problems.

📚 Dive deeper into A2A:  
- [Google’s A2A announcement](https://developers.googleblog.com/en/a2a-a-new-era-of-agent-interoperability/)


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/unit4/additional-readings.mdx" />