import{s as Al,n as Yl,o as Xl}from"../chunks/scheduler.505acc25.js";import{S as Nl,i as Ql,e as o,s as n,c as r,h as _l,a as i,d as a,b as t,f as Sl,g as c,j as M,k as ce,l as Rl,m as s,n as p,t as y,o as d,p as u}from"../chunks/index.fbb49fb4.js";import{C as zl}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as U}from"../chunks/CodeBlock.2ead06c8.js";import{C as Fl}from"../chunks/CourseFloatingBanner.742f9db5.js";import{H as tl}from"../chunks/Heading.511e0027.js";import{E as ql}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function $l(ol){let m,pe,Me,ye,w,de,I,ue,C,me,J,il=`<p>Los ejemplos en esta sección requieren acceso a un modelo VLM potente. Los probamos usando la API de GPT-4o.<br/>
Sin embargo, <a href="./why_use_smolagents">Por qué usar smolagents</a> discute soluciones alternativas soportadas por smolagents y Hugging Face. Si deseas explorar otras opciones, asegúrate de revisar esa sección.</p>`,Ue,h,Ml="Dotar a los agentes con capacidades visuales es crucial para resolver tareas que van más allá del procesamiento de texto. Muchos desafíos del mundo real, como la navegación web o la comprensión de documentos, requieren analizar contenido visual complejo. Afortunadamente, <code>smolagents</code> proporciona soporte integrado para modelos de visión-lenguaje (VLMs), permitiendo a los agentes procesar e interpretar imágenes de manera efectiva.",Je,g,rl="En este ejemplo, imagina que Alfred, el mayordomo de la Mansión Wayne, tiene la tarea de verificar las identidades de los invitados que asisten a la fiesta. Como puedes imaginar, Alfred puede no estar familiarizado con todos los que llegan. Para ayudarlo, podemos usar un agente que verifique su identidad buscando información visual sobre su apariencia usando un VLM. Esto permitirá a Alfred tomar decisiones informadas sobre quién puede entrar. ¡Vamos a construir este ejemplo!",je,B,Te,j,cl='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_agents.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',be,v,pl="En este enfoque, las imágenes se pasan al agente al inicio y se almacenan como <code>task_images</code> junto con el prompt de la tarea. El agente luego procesa estas imágenes durante su ejecución.",we,f,yl="Considera el caso donde Alfred quiere verificar las identidades de los superhéroes que asisten a la fiesta. Ya tiene un conjunto de datos de imágenes de fiestas anteriores con los nombres de los invitados. Dada la imagen de un nuevo visitante, el agente puede compararla con el conjunto de datos existente y tomar una decisión sobre dejarlos entrar.",Ie,G,dl="En este caso, un invitado está tratando de entrar, y Alfred sospecha que este visitante podría ser El Joker haciéndose pasar por Wonder Woman. Alfred necesita verificar su identidad para evitar que entren personas no deseadas.",Ce,Z,ul="Vamos a construir el ejemplo. Primero, se cargan las imágenes. En este caso, usamos imágenes de Wikipedia para mantener el ejemplo mínimo, ¡pero imagina el posible caso de uso!",he,W,ge,V,ml="Ahora que tenemos las imágenes, el agente nos dirá si un invitado es realmente un superhéroe (Wonder Woman) o un villano (El Joker).",Be,E,ve,k,Ul="En el caso de mi ejecución, la salida es la siguiente, aunque podría variar en tu caso, como ya hemos discutido:",fe,x,Ge,S,Jl="En este caso, la salida revela que la persona se está haciendo pasar por alguien más, ¡así que podemos evitar que El Joker entre a la fiesta!",Ze,A,We,T,jl='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_web_browser.py" target="_blank">este archivo Python</a></p>',Ve,Y,Tl="El enfoque anterior es valioso y tiene muchos casos de uso potenciales. Sin embargo, en situaciones donde el invitado no está en la base de datos, necesitamos explorar otras formas de identificarlos. Una posible solución es recuperar dinámicamente imágenes e información de fuentes externas, como navegar por la web para obtener detalles.",Ee,X,bl="En este enfoque, las imágenes se agregan dinámicamente a la memoria del agente durante la ejecución. Como sabemos, los agentes en <code>smolagents</code> están basados en la clase <code>MultiStepAgent</code>, que es una abstracción del framework ReAct. Esta clase opera en un ciclo estructurado donde varias variables y conocimientos se registran en diferentes etapas:",ke,N,wl="<li><strong>SystemPromptStep:</strong> Almacena el prompt del sistema.</li> <li><strong>TaskStep:</strong> Registra la consulta del usuario y cualquier entrada proporcionada.</li> <li><strong>ActionStep:</strong> Captura registros de las acciones del agente y los resultados.</li>",xe,Q,Il="Este enfoque estructurado permite a los agentes incorporar información visual de manera dinámica y responder de forma adaptativa a tareas en evolución. A continuación se muestra el diagrama que ya hemos visto, ilustrando el proceso de flujo de trabajo dinámico y cómo diferentes pasos se integran dentro del ciclo de vida del agente. Al navegar, el agente puede tomar capturas de pantalla y guardarlas como <code>observation_images</code> en el <code>ActionStep</code>.",Se,_,Cl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/smolagents-can-see/diagram_adding_vlms_smolagents.png" alt="Recuperación dinámica de imágenes"/>',Ae,R,hl="Ahora que entendemos la necesidad, vamos a construir nuestro ejemplo completo. En este caso, Alfred quiere control total sobre el proceso de verificación de invitados, por lo que buscar detalles se convierte en una solución viable. Para completar este ejemplo, necesitamos un nuevo conjunto de herramientas para el agente. Además, usaremos Selenium y Helium, que son herramientas de automatización de navegador. Esto nos permitirá construir un agente que explore la web, buscando detalles sobre un posible invitado y recuperando información de verificación. Vamos a instalar las herramientas necesarias:",Ye,z,Xe,F,gl="Necesitaremos un conjunto de herramientas de agente específicamente diseñadas para navegar, como <code>search_item_ctrl_f</code>, <code>go_back</code>, y <code>close_popups</code>. Estas herramientas permiten al agente actuar como una persona navegando por la web.",Ne,q,Qe,$,Bl="También necesitamos funcionalidad para guardar capturas de pantalla, ya que esta será una parte esencial de lo que nuestro agente VLM usa para completar la tarea. Esta funcionalidad captura la pantalla y la guarda en <code>step_log.observations_images = [image.copy()]</code>, permitiendo al agente almacenar y procesar las imágenes dinámicamente mientras navega.",_e,H,Re,L,vl="Esta función se pasa al agente como <code>step_callback</code>, ya que se activa al final de cada paso durante la ejecución del agente. Esto permite al agente capturar y almacenar dinámicamente capturas de pantalla a lo largo de su proceso.",ze,P,fl="Ahora, podemos generar nuestro agente de visión para navegar por la web, proporcionándole las herramientas que creamos, junto con el <code>DuckDuckGoSearchTool</code> para explorar la web. Esta herramienta ayudará al agente a recuperar la información necesaria para verificar las identidades de los invitados basándose en señales visuales.",Fe,D,qe,K,Gl="Con eso, Alfred está listo para verificar las identidades de los invitados y tomar decisiones informadas sobre si dejarlos entrar a la fiesta:",$e,O,He,ee,Zl="Puedes ver que incluimos <code>helium_instructions</code> como parte de la tarea. Este prompt especial está destinado a controlar la navegación del agente, asegurando que siga los pasos correctos mientras navega por la web.",Le,le,Wl="Veamos cómo funciona esto en el video a continuación:",Pe,b,Vl='<source src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/VisionBrowserAgent.mp4" type="video/mp4"/>',De,ae,El="Esta es la salida final:",Ke,se,Oe,ne,kl="¡Con todo eso, hemos creado exitosamente nuestro verificador de identidad para la fiesta! Alfred ahora tiene las herramientas necesarias para asegurar que solo los invitados correctos pasen por la puerta. ¡Todo está listo para pasarlo bien en la Mansión Wayne!",el,te,ll,oe,xl='<li><a href="https://huggingface.co/blog/smolagents-can-see" rel="nofollow">Acabamos de dar vista a smolagents</a> - Blog que describe la funcionalidad del agente de visión.</li> <li><a href="https://huggingface.co/docs/smolagents/examples/web_browser" rel="nofollow">Automatización de Navegador Web con Agentes 🤖🌐</a> - Ejemplo de navegación web usando un agente de visión.</li> <li><a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">Ejemplo de Agente de Visión para Navegador Web</a> - Ejemplo de navegación web usando un agente de visión.</li>',al,ie,sl,re,nl;return w=new Fl({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_agents.ipynb"}]}}),I=new zl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new tl({props:{title:"Agentes de Visión con smolagents",local:"agentes-de-visión-con-smolagents",headingTag:"h1"}}),B=new tl({props:{title:"Proporcionando Imágenes al Inicio de la Ejecución del Agente",local:"proporcionando-imágenes-al-inicio-de-la-ejecución-del-agente",headingTag:"h2"}}),W=new U({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBJTBBaW1hZ2VfdXJscyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGZSUyRmU4JTJGVGhlX0pva2VyX2F0X1dheF9NdXNldW1fUGx1cy5qcGclMjIlMkMlMjAlMjMlMjBJbWFnZW4lMjBkZWwlMjBKb2tlciUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZlbiUyRjklMkY5OCUyRkpva2VyXyUyNTI4RENfQ29taWNzX2NoYXJhY3RlciUyNTI5LmpwZyUyMiUyMCUyMyUyMEltYWdlbiUyMGRlbCUyMEpva2VyJTBBJTVEJTBBJTBBaW1hZ2VzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwdXJsJTIwaW4lMjBpbWFnZV91cmxzJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltYWdlKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

image_urls = [
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/e/e8/The_Joker_at_Wax_Museum_Plus.jpg&quot;</span>, <span class="hljs-comment"># Imagen del Joker</span>
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/en/9/98/Joker_%28DC_Comics_character%29.jpg&quot;</span> <span class="hljs-comment"># Imagen del Joker</span>
]

images = []
<span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> image_urls:
    response = requests.get(url)
    image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
    images.append(image)`,wrap:!1}}),E=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwobW9kZWxfaWQlM0QlMjJncHQtNG8lMjIpJTBBJTBBJTIzJTIwSW5zdGFuY2lhciUyMGVsJTIwYWdlbnRlJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QyJTBBKSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMERlc2NyaWJlJTIwZWwlMjBkaXNmcmF6JTIweSUyMG1hcXVpbGxhamUlMjBxdWUlMjBlc3QlQzMlQTElMjB1c2FuZG8lMjBlbCUyMHBlcnNvbmFqZSUyMGRlJTIwYyVDMyVCM21pYyUyMGVuJTIwZXN0YXMlMjBmb3RvcyUyMHklMjBkZXZ1ZWx2ZSUyMGxhJTIwZGVzY3JpcGNpJUMzJUIzbi4lMEElMjAlMjAlMjAlMjBEaW1lJTIwc2klMjBlbCUyMGludml0YWRvJTIwZXMlMjBFbCUyMEpva2VyJTIwbyUyMFdvbmRlciUyMFdvbWFuLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlcyUzRGltYWdlcyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel

model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-comment"># Instanciar el agente</span>
agent = CodeAgent(
    tools=[],
    model=model,
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

response = agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Describe el disfraz y maquillaje que está usando el personaje de cómic en estas fotos y devuelve la descripción.
    Dime si el invitado es El Joker o Wonder Woman.
    &quot;&quot;&quot;</span>,
    images=images
)`,wrap:!1}}),x=new U({props:{code:"JTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ0Rpc2ZyYXolMjB5JTIwTWFxdWlsbGFqZSUyMC0lMjBQcmltZXJhJTIwSW1hZ2VuJyUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnQWJyaWdvJTIwcCVDMyVCQXJwdXJhJTIweSUyMHVuYSUyMGNvcmJhdGElMjBvJTIwcGElQzMlQjF1ZWxvJTIwZGUlMjBzZWRhJTIwcCVDMyVCQXJwdXJhJTIwc29icmUlMjB1bmElMjBjYW1pc2ElMjBhbWFyaWxsbyUyMG1vc3RhemEuJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdQaW50dXJhJTIwZmFjaWFsJTIwYmxhbmNhJTIwY29uJTIwcmFzZ29zJTIwZXhhZ2VyYWRvcyUyQyUyMGNlamFzJTIwb3NjdXJhcyUyQyUyMG1hcXVpbGxhamUlMjBhenVsJTIwZW4lMjBsb3MlMjBvam9zJTJDJTIwbGFiaW9zJTIwcm9qb3MlMjBmb3JtYW5kbyUyMHVuYSUyMGFtcGxpYSUyMHNvbnJpc2EuJyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnRGlzZnJheiUyMHklMjBNYXF1aWxsYWplJTIwLSUyMFNlZ3VuZGElMjBJbWFnZW4nJTNBJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdUcmFqZSUyMG9zY3VybyUyMGNvbiUyMHVuYSUyMGZsb3IlMjBlbiUyMGxhJTIwc29sYXBhJTJDJTIwc29zdGVuaWVuZG8lMjB1bmElMjBjYXJ0YSUyMGRlJTIwanVlZ28uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdQaWVsJTIwcCVDMyVBMWxpZGElMkMlMjBjYWJlbGxvJTIwdmVyZGUlMkMlMjBsYWJpb3MlMjBtdXklMjByb2pvcyUyMGNvbiUyMHVuYSUyMHNvbnJpc2ElMjBleGFnZXJhZGEuJyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnSWRlbnRpZGFkJTIwZGVsJTIwUGVyc29uYWplJyUzQSUyMCdFc3RlJTIwcGVyc29uYWplJTIwc2UlMjBhc2VtZWphJTIwYSUyMHJlcHJlc2VudGFjaW9uZXMlMjBjb25vY2lkYXMlMjBkZSUyMEVsJTIwSm9rZXIlMjBkZSUyMGxvcyUyMG1lZGlvcyUyMGRlJTIwYyVDMyVCM21pY3MuJyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`    {
        <span class="hljs-string">&#x27;Disfraz y Maquillaje - Primera Imagen&#x27;</span>: (
            <span class="hljs-string">&#x27;Abrigo púrpura y una corbata o pañuelo de seda púrpura sobre una camisa amarillo mostaza.&#x27;</span>,
            <span class="hljs-string">&#x27;Pintura facial blanca con rasgos exagerados, cejas oscuras, maquillaje azul en los ojos, labios rojos formando una amplia sonrisa.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Disfraz y Maquillaje - Segunda Imagen&#x27;</span>: (
            <span class="hljs-string">&#x27;Traje oscuro con una flor en la solapa, sosteniendo una carta de juego.&#x27;</span>,
            <span class="hljs-string">&#x27;Piel pálida, cabello verde, labios muy rojos con una sonrisa exagerada.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Identidad del Personaje&#x27;</span>: <span class="hljs-string">&#x27;Este personaje se asemeja a representaciones conocidas de El Joker de los medios de cómics.&#x27;</span>
    }`,wrap:!1}}),A=new tl({props:{title:"Proporcionando Imágenes con Recuperación Dinámica",local:"proporcionando-imágenes-con-recuperación-dinámica",headingTag:"h2"}}),z=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJhbGwlNUQlMjIlMjBoZWxpdW0lMjBzZWxlbml1bSUyMHB5dGhvbi1kb3RlbnY=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[all]&quot;</span> helium selenium python-dotenv',wrap:!1}}),q=new U({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">search_item_ctrl_f</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span>, nth_result: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Busca texto en la página actual a través de Ctrl + F y salta a la n-ésima ocurrencia.
    Args:
        text: El texto a buscar
        nth_result: A qué ocurrencia saltar (por defecto: 1)
    &quot;&quot;&quot;</span>
    elements = driver.find_elements(By.XPATH, <span class="hljs-string">f&quot;//*[contains(text(), &#x27;<span class="hljs-subst">{text}</span>&#x27;)]&quot;</span>)
    <span class="hljs-keyword">if</span> nth_result &gt; <span class="hljs-built_in">len</span>(elements):
        <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">f&quot;Coincidencia n°<span class="hljs-subst">{nth_result}</span> no encontrada (solo se encontraron <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> coincidencias)&quot;</span>)
    result = <span class="hljs-string">f&quot;Se encontraron <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> coincidencias para &#x27;<span class="hljs-subst">{text}</span>&#x27;.&quot;</span>
    elem = elements[nth_result - <span class="hljs-number">1</span>]
    driver.execute_script(<span class="hljs-string">&quot;arguments[0].scrollIntoView(true);&quot;</span>, elem)
    result += <span class="hljs-string">f&quot;Enfocado en el elemento <span class="hljs-subst">{nth_result}</span> de <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span>&quot;</span>
    <span class="hljs-keyword">return</span> result


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">go_back</span>() -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Regresa a la página anterior.&quot;&quot;&quot;</span>
    driver.back()


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">close_popups</span>() -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Cierra cualquier modal o pop-up visible en la página. ¡Usa esto para descartar ventanas emergentes! Esto no funciona en banners de consentimiento de cookies.
    &quot;&quot;&quot;</span>
    webdriver.ActionChains(driver).send_keys(Keys.ESCAPE).perform()`,wrap:!1}}),H=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">save_screenshot</span>(<span class="hljs-params">step_log: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Permitir que ocurran animaciones JavaScript antes de tomar la captura de pantalla</span>
    driver = helium.get_driver()
    current_step = step_log.step_number
    <span class="hljs-keyword">if</span> driver <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">for</span> step_logs <span class="hljs-keyword">in</span> agent.logs:  <span class="hljs-comment"># Eliminar capturas de pantalla anteriores de los registros para un procesamiento eficiente</span>
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(step_log, ActionStep) <span class="hljs-keyword">and</span> step_log.step_number &lt;= current_step - <span class="hljs-number">2</span>:
                step_logs.observations_images = <span class="hljs-literal">None</span>
        png_bytes = driver.get_screenshot_as_png()
        image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Se capturó una captura de pantalla del navegador: <span class="hljs-subst">{image.size}</span> píxeles&quot;</span>)
        step_log.observations_images = [image.copy()]  <span class="hljs-comment"># Crear una copia para asegurar que persista, ¡importante!</span>

    <span class="hljs-comment"># Actualizar observaciones con la URL actual</span>
    url_info = <span class="hljs-string">f&quot;URL actual: <span class="hljs-subst">{driver.current_url}</span>&quot;</span>
    step_log.observations = url_info <span class="hljs-keyword">if</span> step_logs.observations <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> step_log.observations + <span class="hljs-string">&quot;\\n&quot;</span> + url_info
    <span class="hljs-keyword">return</span>`,wrap:!1}}),D=new U({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlTZXJ2ZXJNb2RlbChtb2RlbF9pZCUzRCUyMmdwdC00byUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjBnb19iYWNrJTJDJTIwY2xvc2VfcG9wdXBzJTJDJTIwc2VhcmNoX2l0ZW1fY3RybF9mJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIyaGVsaXVtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RlcF9jYWxsYmFja3MlM0QlNUJzYXZlX3NjcmVlbnNob3QlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel, DuckDuckGoSearchTool
model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

agent = CodeAgent(
    tools=[DuckDuckGoSearchTool(), go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[save_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)`,wrap:!1}}),O=new U({props:{code:"YWdlbnQucnVuKCUyMiUyMiUyMiUwQVNveSUyMEFsZnJlZCUyQyUyMGVsJTIwbWF5b3Jkb21vJTIwZGUlMjBsYSUyME1hbnNpJUMzJUIzbiUyMFdheW5lJTJDJTIwcmVzcG9uc2FibGUlMjBkZSUyMHZlcmlmaWNhciUyMGxhJTIwaWRlbnRpZGFkJTIwZGUlMjBsb3MlMjBpbnZpdGFkb3MlMjBlbiUyMGxhJTIwZmllc3RhLiUyMFVuYSUyMHN1cGVyaGVybyVDMyVBRG5hJTIwaGElMjBsbGVnYWRvJTIwYSUyMGxhJTIwZW50cmFkYSUyMGFmaXJtYW5kbyUyMHNlciUyMFdvbmRlciUyMFdvbWFuJTJDJTIwcGVybyUyMG5lY2VzaXRvJTIwY29uZmlybWFyJTIwc2klMjBlbGxhJTIwZXMlMjBxdWllbiUyMGRpY2UlMjBzZXIuJTBBJTBBUG9yJTIwZmF2b3IlMkMlMjBidXNjYSUyMGltJUMzJUExZ2VuZXMlMjBkZSUyMFdvbmRlciUyMFdvbWFuJTIweSUyMGdlbmVyYSUyMHVuYSUyMGRlc2NyaXBjaSVDMyVCM24lMjB2aXN1YWwlMjBkZXRhbGxhZGElMjBiYXNhZGElMjBlbiUyMGVzYXMlMjBpbSVDMyVBMWdlbmVzLiUyMEFkZW0lQzMlQTFzJTJDJTIwbmF2ZWdhJTIwYSUyMFdpa2lwZWRpYSUyMHBhcmElMjByZWNvcGlsYXIlMjBkZXRhbGxlcyUyMGNsYXZlJTIwc29icmUlMjBzdSUyMGFwYXJpZW5jaWEuJTIwQ29uJTIwZXN0YSUyMGluZm9ybWFjaSVDMyVCM24lMkMlMjBwdWVkbyUyMGRldGVybWluYXIlMjBzaSUyMGNvbmNlZGVybGUlMjBhY2Nlc28lMjBhbCUyMGV2ZW50by4lMEElMjIlMjIlMjIlMjAlMkIlMjBoZWxpdW1faW5zdHJ1Y3Rpb25zKQ==",highlighted:`agent.run(<span class="hljs-string">&quot;&quot;&quot;
Soy Alfred, el mayordomo de la Mansión Wayne, responsable de verificar la identidad de los invitados en la fiesta. Una superheroína ha llegado a la entrada afirmando ser Wonder Woman, pero necesito confirmar si ella es quien dice ser.

Por favor, busca imágenes de Wonder Woman y genera una descripción visual detallada basada en esas imágenes. Además, navega a Wikipedia para recopilar detalles clave sobre su apariencia. Con esta información, puedo determinar si concederle acceso al evento.
&quot;&quot;&quot;</span> + helium_instructions)`,wrap:!1}}),se=new U({props:{code:"UmVzcHVlc3RhJTIwZmluYWwlM0ElMjBXb25kZXIlMjBXb21hbiUyMG5vcm1hbG1lbnRlJTIwc2UlMjByZXByZXNlbnRhJTIwdmlzdGllbmRvJTIwdW4lMjBjb3JzJUMzJUE5JTIwcm9qbyUyMHklMjBkb3JhZG8lMkMlMjBzaG9ydHMlMjBvJTIwZmFsZGElMjBhenVsJTIwY29uJTIwZXN0cmVsbGFzJTIwYmxhbmNhcyUyQyUyMHVuYSUyMHRpYXJhJTIwZG9yYWRhJTJDJTIwYnJhemFsZXRlcyUyMHBsYXRlYWRvcyUyMHklMjB1biUyMExhem8lMjBkZSUyMGxhJTIwVmVyZGFkJTIwZG9yYWRvLiUyMEVzJTIwbGElMjBQcmluY2VzYSUyMERpYW5hJTIwZGUlMjBUaGVteXNjaXJhJTJDJTIwY29ub2NpZGElMjBjb21vJTIwRGlhbmElMjBQcmluY2UlMjBlbiUyMGVsJTIwbXVuZG8lMjBkZSUyMGxvcyUyMGhvbWJyZXMu",highlighted:"Respuesta final: Wonder Woman normalmente se representa vistiendo un corsé rojo y dorado, shorts o falda azul con estrellas blancas, una tiara dorada, brazaletes plateados y un Lazo de la Verdad dorado. Es la Princesa Diana de Themyscira, conocida como Diana Prince en el mundo de los hombres.",wrap:!1}}),te=new tl({props:{title:"Lecturas Adicionales",local:"lecturas-adicionales",headingTag:"h2"}}),ie=new ql({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/smolagents/vision_agents.mdx"}}),{c(){m=o("meta"),pe=n(),Me=o("p"),ye=n(),r(w.$$.fragment),de=n(),r(I.$$.fragment),ue=n(),r(C.$$.fragment),me=n(),J=o("blockquote"),J.innerHTML=il,Ue=n(),h=o("p"),h.innerHTML=Ml,Je=n(),g=o("p"),g.textContent=rl,je=n(),r(B.$$.fragment),Te=n(),j=o("blockquote"),j.innerHTML=cl,be=n(),v=o("p"),v.innerHTML=pl,we=n(),f=o("p"),f.textContent=yl,Ie=n(),G=o("p"),G.textContent=dl,Ce=n(),Z=o("p"),Z.textContent=ul,he=n(),r(W.$$.fragment),ge=n(),V=o("p"),V.textContent=ml,Be=n(),r(E.$$.fragment),ve=n(),k=o("p"),k.textContent=Ul,fe=n(),r(x.$$.fragment),Ge=n(),S=o("p"),S.textContent=Jl,Ze=n(),r(A.$$.fragment),We=n(),T=o("blockquote"),T.innerHTML=jl,Ve=n(),Y=o("p"),Y.textContent=Tl,Ee=n(),X=o("p"),X.innerHTML=bl,ke=n(),N=o("ol"),N.innerHTML=wl,xe=n(),Q=o("p"),Q.innerHTML=Il,Se=n(),_=o("p"),_.innerHTML=Cl,Ae=n(),R=o("p"),R.textContent=hl,Ye=n(),r(z.$$.fragment),Xe=n(),F=o("p"),F.innerHTML=gl,Ne=n(),r(q.$$.fragment),Qe=n(),$=o("p"),$.innerHTML=Bl,_e=n(),r(H.$$.fragment),Re=n(),L=o("p"),L.innerHTML=vl,ze=n(),P=o("p"),P.innerHTML=fl,Fe=n(),r(D.$$.fragment),qe=n(),K=o("p"),K.textContent=Gl,$e=n(),r(O.$$.fragment),He=n(),ee=o("p"),ee.innerHTML=Zl,Le=n(),le=o("p"),le.textContent=Wl,Pe=n(),b=o("video"),b.innerHTML=Vl,De=n(),ae=o("p"),ae.textContent=El,Ke=n(),r(se.$$.fragment),Oe=n(),ne=o("p"),ne.textContent=kl,el=n(),r(te.$$.fragment),ll=n(),oe=o("ul"),oe.innerHTML=xl,al=n(),r(ie.$$.fragment),sl=n(),re=o("p"),this.h()},l(e){const l=_l("svelte-u9bgzb",document.head);m=i(l,"META",{name:!0,content:!0}),l.forEach(a),pe=t(e),Me=i(e,"P",{}),Sl(Me).forEach(a),ye=t(e),c(w.$$.fragment,e),de=t(e),c(I.$$.fragment,e),ue=t(e),c(C.$$.fragment,e),me=t(e),J=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(J)!=="svelte-1197xof"&&(J.innerHTML=il),Ue=t(e),h=i(e,"P",{"data-svelte-h":!0}),M(h)!=="svelte-1of9nh2"&&(h.innerHTML=Ml),Je=t(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1hv48uz"&&(g.textContent=rl),je=t(e),c(B.$$.fragment,e),Te=t(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(j)!=="svelte-13et7ln"&&(j.innerHTML=cl),be=t(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-l6h46j"&&(v.innerHTML=pl),we=t(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-12pdwd8"&&(f.textContent=yl),Ie=t(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-geoidc"&&(G.textContent=dl),Ce=t(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1cbbmow"&&(Z.textContent=ul),he=t(e),c(W.$$.fragment,e),ge=t(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-12cconk"&&(V.textContent=ml),Be=t(e),c(E.$$.fragment,e),ve=t(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-oqabtu"&&(k.textContent=Ul),fe=t(e),c(x.$$.fragment,e),Ge=t(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-19740tr"&&(S.textContent=Jl),Ze=t(e),c(A.$$.fragment,e),We=t(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-170z1ri"&&(T.innerHTML=jl),Ve=t(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-989u72"&&(Y.textContent=Tl),Ee=t(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-t1gkqp"&&(X.innerHTML=bl),ke=t(e),N=i(e,"OL",{"data-svelte-h":!0}),M(N)!=="svelte-1hdg056"&&(N.innerHTML=wl),xe=t(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1c57x7r"&&(Q.innerHTML=Il),Se=t(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-baleux"&&(_.innerHTML=Cl),Ae=t(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-449c1x"&&(R.textContent=hl),Ye=t(e),c(z.$$.fragment,e),Xe=t(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-pa4ocu"&&(F.innerHTML=gl),Ne=t(e),c(q.$$.fragment,e),Qe=t(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1p4qjff"&&($.innerHTML=Bl),_e=t(e),c(H.$$.fragment,e),Re=t(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1ghvarn"&&(L.innerHTML=vl),ze=t(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-jb2pc5"&&(P.innerHTML=fl),Fe=t(e),c(D.$$.fragment,e),qe=t(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-erejhx"&&(K.textContent=Gl),$e=t(e),c(O.$$.fragment,e),He=t(e),ee=i(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1lah6oz"&&(ee.innerHTML=Zl),Le=t(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-1e004qb"&&(le.textContent=Wl),Pe=t(e),b=i(e,"VIDEO",{"data-svelte-h":!0}),M(b)!=="svelte-1xo1net"&&(b.innerHTML=Vl),De=t(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1jhw7gi"&&(ae.textContent=El),Ke=t(e),c(se.$$.fragment,e),Oe=t(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1kolgno"&&(ne.textContent=kl),el=t(e),c(te.$$.fragment,e),ll=t(e),oe=i(e,"UL",{"data-svelte-h":!0}),M(oe)!=="svelte-1san4rw"&&(oe.innerHTML=xl),al=t(e),c(ie.$$.fragment,e),sl=t(e),re=i(e,"P",{}),Sl(re).forEach(a),this.h()},h(){ce(m,"name","hf:doc:metadata"),ce(m,"content",Hl),ce(J,"class","warning"),ce(j,"class","tip"),ce(T,"class","tip"),b.controls=""},m(e,l){Rl(document.head,m),s(e,pe,l),s(e,Me,l),s(e,ye,l),p(w,e,l),s(e,de,l),p(I,e,l),s(e,ue,l),p(C,e,l),s(e,me,l),s(e,J,l),s(e,Ue,l),s(e,h,l),s(e,Je,l),s(e,g,l),s(e,je,l),p(B,e,l),s(e,Te,l),s(e,j,l),s(e,be,l),s(e,v,l),s(e,we,l),s(e,f,l),s(e,Ie,l),s(e,G,l),s(e,Ce,l),s(e,Z,l),s(e,he,l),p(W,e,l),s(e,ge,l),s(e,V,l),s(e,Be,l),p(E,e,l),s(e,ve,l),s(e,k,l),s(e,fe,l),p(x,e,l),s(e,Ge,l),s(e,S,l),s(e,Ze,l),p(A,e,l),s(e,We,l),s(e,T,l),s(e,Ve,l),s(e,Y,l),s(e,Ee,l),s(e,X,l),s(e,ke,l),s(e,N,l),s(e,xe,l),s(e,Q,l),s(e,Se,l),s(e,_,l),s(e,Ae,l),s(e,R,l),s(e,Ye,l),p(z,e,l),s(e,Xe,l),s(e,F,l),s(e,Ne,l),p(q,e,l),s(e,Qe,l),s(e,$,l),s(e,_e,l),p(H,e,l),s(e,Re,l),s(e,L,l),s(e,ze,l),s(e,P,l),s(e,Fe,l),p(D,e,l),s(e,qe,l),s(e,K,l),s(e,$e,l),p(O,e,l),s(e,He,l),s(e,ee,l),s(e,Le,l),s(e,le,l),s(e,Pe,l),s(e,b,l),s(e,De,l),s(e,ae,l),s(e,Ke,l),p(se,e,l),s(e,Oe,l),s(e,ne,l),s(e,el,l),p(te,e,l),s(e,ll,l),s(e,oe,l),s(e,al,l),p(ie,e,l),s(e,sl,l),s(e,re,l),nl=!0},p:Yl,i(e){nl||(y(w.$$.fragment,e),y(I.$$.fragment,e),y(C.$$.fragment,e),y(B.$$.fragment,e),y(W.$$.fragment,e),y(E.$$.fragment,e),y(x.$$.fragment,e),y(A.$$.fragment,e),y(z.$$.fragment,e),y(q.$$.fragment,e),y(H.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(se.$$.fragment,e),y(te.$$.fragment,e),y(ie.$$.fragment,e),nl=!0)},o(e){d(w.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(W.$$.fragment,e),d(E.$$.fragment,e),d(x.$$.fragment,e),d(A.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(H.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(se.$$.fragment,e),d(te.$$.fragment,e),d(ie.$$.fragment,e),nl=!1},d(e){e&&(a(pe),a(Me),a(ye),a(de),a(ue),a(me),a(J),a(Ue),a(h),a(Je),a(g),a(je),a(Te),a(j),a(be),a(v),a(we),a(f),a(Ie),a(G),a(Ce),a(Z),a(he),a(ge),a(V),a(Be),a(ve),a(k),a(fe),a(Ge),a(S),a(Ze),a(We),a(T),a(Ve),a(Y),a(Ee),a(X),a(ke),a(N),a(xe),a(Q),a(Se),a(_),a(Ae),a(R),a(Ye),a(Xe),a(F),a(Ne),a(Qe),a($),a(_e),a(Re),a(L),a(ze),a(P),a(Fe),a(qe),a(K),a($e),a(He),a(ee),a(Le),a(le),a(Pe),a(b),a(De),a(ae),a(Ke),a(Oe),a(ne),a(el),a(ll),a(oe),a(al),a(sl),a(re)),a(m),u(w,e),u(I,e),u(C,e),u(B,e),u(W,e),u(E,e),u(x,e),u(A,e),u(z,e),u(q,e),u(H,e),u(D,e),u(O,e),u(se,e),u(te,e),u(ie,e)}}}const Hl='{"title":"Agentes de Visión con smolagents","local":"agentes-de-visión-con-smolagents","sections":[{"title":"Proporcionando Imágenes al Inicio de la Ejecución del Agente","local":"proporcionando-imágenes-al-inicio-de-la-ejecución-del-agente","sections":[],"depth":2},{"title":"Proporcionando Imágenes con Recuperación Dinámica","local":"proporcionando-imágenes-con-recuperación-dinámica","sections":[],"depth":2},{"title":"Lecturas Adicionales","local":"lecturas-adicionales","sections":[],"depth":2}],"depth":1}';function Ll(ol){return Xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends Nl{constructor(m){super(),Ql(this,m,Ll,$l,Al,{})}}export{sa as component};
