# Bienvenido/a al curso de 🤗  Agentes IA [[introduction]]

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/thumbnail.jpg" alt="AI Agents Course thumbnail" width="100%"/>
<figcaption>The background of the image was generated using <a href="https://scenario.com/">Scenario.com</a>
</figcaption>
</figure>


Bienvenido/a al tema mas emocionante en la IA en la actualidad: **Agents**!

Este curso gratuito te llevará a un viaje, **desde principiante hasta experto**, en comprender, usar y construir agentes IA.

Esta primera unidad te ayudará a comenzar:

- Descubre el **programa del curso**.
- **Elige el camino** que vas a tomar (ya sea el camino de autoaudición o el proceso de certificación).
- **Obtén más información sobre el proceso de certificación y las fechas de entrega**.
- Conoce a los miembros del equipo detras del curso.
- Crea tu cuenta de **Hugging Face**.
- **Registrate al servidor de Discord**, y conocenos a nosotros y a tus compañeross.

Empecemos!

## Que esperar de este curso? [[expect]]

En este curso, aprenderás:

- 📖 Estudia los agentes de IA con **teoría, diseño y práctica**.
- 🧑‍💻 Aprende a **usar bibliotecas de agentes IA establecidas** como [smolagents](https://huggingface.co/docs/smolagents/en/index), [LangChain](https://www.langchain.com/) y [LlamaIndex](https://www.llamaindex.ai/).
- 💾 **Comparte tus agentes** en el Hugging Face Hub y explora agentes creados por la comunidad.
- 🏆 Participa en **retos** donde **evaluáras a tus agentes contra agentes de otros estudiantes**.
- 🎓 **Obtén un certificado** al completar las asignaciones.

Y mucho mas!

Al final de este curso entenderás **como funcionan los agentes y como construir tus propios agentes usando las librerías y herramientas mas recientes**.

No olvides **<a href="https://bit.ly/hf-learn-agents">registrarte a este curso!</a>** 

(Respetamos tu privacidad. Recopilamos tu dirección de correo electrónico para poder **enviarte los enlaces cuando se publique cada unidad y darte información sobre los desafíos y actualizaciones**).

## ¿Cómo es el curso? [[course-look-like]]

El curso está compuesto por:

- *Unidades fundamentales*: donde aprenderás los **conceptos de Agentes en teoría**.
- *Prácticas*: donde aprenderás **a usar bibliotecas de Agentes IA establecidas** para entrenar tus agentes en entornos únicos. Estas secciones prácticas serán en **Hugging Face Spaces** con un entorno preconfigurado.
- *Prácticas de casos de uso*: donde aplicarás los conceptos que has aprendido para resolver un problema que elijas.
- *Desafío*: pondrás a tu agente a competir contra otros agentes en un desafío. Tambien habra una [tabla de clasificación](https://huggingface.co/spaces/huggingface-projects/AI-Agents-Leaderboard) (aún no disponible) para que compares el rendimiento de los agentes.

Este **curso es un proyecto latente, que evoluciona con tus comentarios y contribuciones!** No dudes en [abrir issues y PRs en GitHub](https://github.com/huggingface/agents-course), y participar en discusiones en nuestro servidor de Discord.

Después de haber completado el curso, también puedes enviar tus comentarios [👉 usando este formulario](https://docs.google.com/forms/d/e/1FAIpQLSe9VaONn0eglax0uTwi29rIn4tM7H2sYmmybmG5jJNlE5v0xA/viewform?usp=dialog)

## ¿Cuál es el programa? [[syllabus]]

Aquí está el **programa general del curso**. Una lista más detallada de temas se publicará con cada unidad.

| Capítulo | Tema | Descripción |
| :---- | :---- | :---- |
| 0 | Introducción | Te prepara con las herramientas y plataformas que utilizarás. |
| 1 | Fundamentos de Agentes | Explica Herramientas, Pensamientos, Acciones, Observaciones y sus formatos. Explica LLMs, mensajes, tokens especiales y plantillas de chat. Muestra un caso de uso simple usando funciones de Python como herramientas. |
| 1.5 | Bonus: Fine-tuning de un LLM para llamadas a funciones | Usemos LoRa y hagamos fine-tuning de un modelo para realizar llamadas a funciones dentro de un notebook. |
| 2 | Frameworks | Comprende como se implementan los fundamentos en bibliotecas populares: smolagents, LangGraph, LLamaIndex |
| 3 | Casos de Uso | Construyamos algunos casos de uso reales (abierto a PRs 🤗 de personas con experiencia creando Agentes) |
| 4 | Asignación Final | Construye un agente para un benchmark seleccionado y demuestra tu comprensión de los Agentes en la tabla de clasificación de estudiantes 🚀 |

*También estamos planeando lanzar algunas unidades adicionales, ¡mantente al tanto!*

## ¿Cuáles son los requisitos previos?

Para poder seguir este curso deberías tener:

- Conocimientos básicos de Python
- Conocimientos básicos de LLMs (tenemos una sección en la Unidad 1 para recapitular qué son)


## ¿Qué herramientas necesito? [[tools]]

Solo necesitas 2 cosas:

- *Una computadora* con conexión a internet.
- Una *Cuenta de Hugging Face*: para subir y cargar modelos, agentes y crear Spaces. Si aun no tienes una cuenta, puedes crear una **[aquí](https://hf.co/join)** (es gratis).
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/tools.jpg" alt="Herramientas necesarias para el curso" width="100%"/>

## El Proceso de Certificación [[certification-process]]

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/three-paths.jpg" alt="Dos caminos" width="100%"/>

Puedes elegir seguir este curso *en modo auditoría*, o hacer las actividades y *obtener uno de los dos certificados que emitiremos*. 

Si auditas el curso, puedes participar en todos los desafíos y hacer asignaciones si quieres, y **no necesitas notificarnos**.

El proceso de certificación es **completamente gratuito**:

- *Para obtener una certificación de fundamentos*: necesitas completar la Unidad 1 del curso. Esto está destinado a estudiantes que quieren ponerse al día con las últimas tendencias en Agentes. 
- *Para obtener un certificado de finalización*: necesitas completar la Unidad 1, una de las asignaciones de casos de uso que propondremos durante el curso, y el desafío final.

Hay una fecha límite para el proceso de certificación: todas las asignaciones deben terminarse antes del **1 de mayo de 2025**.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/deadline.jpg" alt="Fecha límite" width="100%"/>

## ¿Cuál es el ritmo recomendado? [[recommended-pace]]

Cada capítulo de este curso está diseñado **para completarse en 1 semana, con aproximadamente 3-4 horas de trabajo por semana**.

Como hay una fecha límite, te proporcionamos un ritmo recomendado:

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/recommended-pace.jpg" alt="Ritmo recomendado" width="100%"/>

## ¿Cómo aprovechar al máximo el curso? [[advice]]

Para aprovechar al máximo el curso, tenemos algunos consejos:

1. <a href="https://discord.gg/UrrTSsSyjb">Únete a grupos de estudio en Discord</a>: estudiar en grupos siempre es más fácil. Para hacerlo, necesitas unirte a nuestro servidor de Discord y verificar tu cuenta de Hugging Face.
2. **Haz los cuestionarios y asignaciones**: la mejor manera de aprender es a través de la práctica y la autoevaluación.
3. **Define un horario para mantenerte sincronizado**: puedes usar nuestro horario de ritmo recomendado a continuación o crear el tuyo.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/advice.jpg" alt="Consejos del curso" width="100%"/>

## Quiénes somos [[who-are-we]]

Sobre los autores:

### Joffrey Thomas

Joffrey es un ingeniero de aprendizaje automático en Hugging Face y ha construido e implementado Agentes IA en producción. Joffrey será tu instructor principal para este curso.

- [Sigue a Joffrey en Hugging Face](https://huggingface.co/Jofthomas)
- [Sigue a Joffrey en X](https://x.com/Jthmas404)
- [Sigue a Joffrey en Linkedin](https://www.linkedin.com/in/joffrey-thomas/)

### Ben Burtenshaw

Ben es un ingeniero de aprendizaje automático en Hugging Face y ha impartido múltiples cursos en varias plataformas. El objetivo de Ben es hacer que el curso sea accesible para todos.

- [Sigue a Ben en Hugging Face](https://huggingface.co/burtenshaw)
- [Sigue a Ben en X](https://x.com/ben_burtenshaw)
- [Sigue a Ben en Linkedin](https://www.linkedin.com/in/ben-burtenshaw/)

### Thomas Simonini

Thomas es un ingeniero de aprendizaje automático en Hugging Face e impartió los exitosos cursos de <a href="https://huggingface.co/learn/deep-rl-course/unit0/introduction">Deep RL</a> y <a href="https://huggingface.co/learn/ml-games-course/en/unit0/introduction">ML para juegos</a>. Thomas es un gran fan de los Agentes y está emocionado de ver lo que la comunidad construirá.

- [Sigue a Thomas en Hugging Face](https://huggingface.co/ThomasSimonini)
- [Sigue a Thomas en X](https://x.com/ThomasSimonini)
- [Sigue a Thomas en Linkedin](https://www.linkedin.com/in/simoninithomas/)

## Agradecimientos  

Nos gustaría extender nuestro agradecimiento a las siguientes personas por sus invaluables contribuciones a este curso:  

- **[Pedro Cuenca](https://huggingface.co/pcuenq)** – Por su orientación y experiencia en la revisión de los materiales.
- **[Aymeric Roucher](https://huggingface.co/m-ric)** – Por sus increíbles espacios de demostración (decodificación y agente final) así como su ayuda en las partes de smolagents. 
- **[Joshua Lochner](https://huggingface.co/Xenova)** – Por su increíble espacio de demostración sobre tokenización.
- **[Quentin Gallouédec](https://huggingface.co/qgallouedec)** – Por su ayuda en el contenido del curso.
- **[David Berenstein](https://huggingface.co/davidberenstein1957)** – Por su ayuda en el contenido del curso y moderación.
- **[XiaXiao (ShawnSiao)](https://huggingface.co/SSSSSSSiao)** – Traductor al chino para el curso.
- **[Jiaming Huang](https://huggingface.co/nordicsushi)** – Traductor al chino para el curso.

## Encontré un error, o quiero mejorar el curso [[contribute]]

Las contribuciones son **bienvenidas** 🤗

- Si *encontraste un error 🐛 en un notebook*, por favor <a href="https://github.com/huggingface/agents-course/issues">abre un issue</a> y **describe el problema**.
- Si *quieres mejorar el curso*, puedes <a href="https://github.com/huggingface/agents-course/pulls">abrir un Pull Request.</a>
- Si *quieres agregar una sección completa o una nueva unidad*, lo mejor es <a href="https://github.com/huggingface/agents-course/issues">abrir un issue</a> y **describir qué contenido quieres agregar antes de comenzar a escribirlo para que podamos guiarte**.

## Todavía tengo preguntas [[questions]]

Por favor, haz tu pregunta en nuestro <a href="https://discord.gg/UrrTSsSyjb">servidor de discord #ai-agents-discussions.</a>


Ahora que tienes toda la información, ¡vamos a bordo! ⛵ 

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/time-to-onboard.jpg" alt="Hora de incorporarse" width="100%"/>


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/es/unit0/introduction.mdx" />