import{s as me,a as Qt,n as de,o as ye}from"../chunks/scheduler.505acc25.js";import{S as ce,i as he,e as i,s as n,c as o,h as Ue,a as p,d as s,b as a,f as Me,g as u,j as r,k as h,l as ge,m as l,n as M,t as m,o as d,p as y}from"../chunks/index.b1175496.js";import{C as fe,H as tt}from"../chunks/Heading.988e52fa.js";import{C as O}from"../chunks/CodeBlock.ed64aebc.js";import{E as Te}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function Je(At){let c,lt,et,nt,g,at,f,it,T,Ft="Pour créer des applications avec LangGraph, vous devez comprendre ses composants principaux. Explorons les blocs fondamentaux qui constituent une application LangGraph.",pt,U,Nt,rt,J,zt="Une application dans LangGraph commence à partir d’un <strong>point d’entrée</strong>, et selon l’exécution, le flux peut aller vers une fonction ou une autre jusqu’à ce qu’il atteigne la FIN.",ot,j,Xt,ut,w,Mt,$,Wt="L’<strong>état</strong> est le concept central dans LangGraph. Il représente toutes les informations qui circulent à travers votre application.",mt,G,dt,C,Yt="L’état est <strong>défini par l’utilisateur</strong>, donc les champs doivent être soigneusement conçus pour contenir toutes les données nécessaires au processus de prise de décision !",yt,I,Kt="<p>💡 <strong>Astuce :</strong> Réfléchissez soigneusement aux informations que votre application doit suivre entre les étapes.</p>",ct,b,ht,_,Pt="Les <strong>nœuds</strong> sont des fonctions Python. Chaque nœud :",Ut,v,Dt="<li>Prend l’état en entrée</li> <li>Effectue une opération</li> <li>Retourne des mises à jour de l’état</li>",gt,k,ft,B,Ot="Par exemple, les nœuds peuvent contenir :",Tt,Z,te="<li><strong>Appels de LLM</strong> : Générer du texte ou prendre des décisions</li> <li><strong>Appels d’outils</strong> : Interagir avec des systèmes externes</li> <li><strong>Logique conditionnelle</strong> : Déterminer les prochaines étapes</li> <li><strong>Intervention humaine</strong> : Obtenir des contributions des utilisateurs</li>",Jt,x,ee="<p>💡 <strong>Info :</strong> Certains nœuds nécessaires pour l’ensemble du <em>workflow</em> comme <em>START</em> et <em>END</em> existent directement dans <em>LangGraph</em>.</p>",jt,L,wt,S,se="Les <strong>arêtes</strong> connectent les nœuds et définissent les chemins possibles à travers votre graphe :",$t,E,Gt,V,le="Les arêtes peuvent être :",Ct,q,ne="<li><strong>Directes</strong> : Toujours aller du nœud A au nœud B</li> <li><strong>Conditionnelles</strong> : Choisir le prochain nœud basé sur l’état actuel</li>",It,H,bt,R,ae="Le <strong>StateGraph</strong> est le conteneur qui détient l’ensemble du <em>workflow</em> de votre agent :",_t,Q,vt,A,ie="Qui peut ensuite être visualisé !",kt,F,Bt,N,pe,Zt,z,re="Mais plus important encore, l’invocation :",xt,X,Lt,W,oe="ressort :",St,Y,Et,K,Vt,P,ue="Dans la prochaine section, nous mettrons ces concepts en pratique en construisant notre premier graphe. Ce graphe permet à Alfred de prendre vos emails, les classifier, et rédiger une réponse préliminaire s’ils sont authentiques.",qt,D,Ht,st,Rt;return g=new fe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new tt({props:{title:"Les composants de base de LangGraph",local:"les-composants-de-base-de-langgraph",headingTag:"h1"}}),w=new tt({props:{title:"1. État",local:"1-état",headingTag:"h2"}}),G=new O({props:{code:"ZnJvbSUyMHR5cGluZ19leHRlbnNpb25zJTIwaW1wb3J0JTIwVHlwZWREaWN0JTBBJTBBY2xhc3MlMjBTdGF0ZShUeXBlZERpY3QpJTNBJTBBJTIwJTIwJTIwJTIwZ3JhcGhfc3RhdGUlM0ElMjBzdHI=",highlighted:`<span class="hljs-keyword">from</span> typing_extensions <span class="hljs-keyword">import</span> TypedDict

<span class="hljs-keyword">class</span> <span class="hljs-title class_">State</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    graph_state: <span class="hljs-built_in">str</span>`,wrap:!1}}),b=new tt({props:{title:"2. Nœuds",local:"2-nœuds",headingTag:"h2"}}),k=new O({props:{code:"ZGVmJTIwbm9kZV8xKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAxLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwSSUyMGFtJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8yKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAyLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwaGFwcHkhJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8zKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAzLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwc2FkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_1</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 1---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; I am&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_2</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 2---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; happy!&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_3</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 3---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; sad!&quot;</span>}`,wrap:!1}}),L=new tt({props:{title:"3. Arêtes",local:"3-arêtes",headingTag:"h2"}}),E=new O({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpdGVyYWwlMEElMEFkZWYlMjBkZWNpZGVfbW9vZChzdGF0ZSklMjAtJTNFJTIwTGl0ZXJhbCU1QiUyMm5vZGVfMiUyMiUyQyUyMCUyMm5vZGVfMyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFNvdXZlbnQlMkMlMjBub3VzJTIwdXRpbGlzZXJvbnMlMjBsJyVDMyVBOXRhdCUyMHBvdXIlMjBkJUMzJUE5Y2lkZXIlMjBkdSUyMHByb2NoYWluJTIwbiVDNSU5M3VkJTIwJUMzJUEwJTIwdmlzaXRlciUwQSUyMCUyMCUyMCUyMHVzZXJfaW5wdXQlMjAlM0QlMjBzdGF0ZSU1QidncmFwaF9zdGF0ZSclNUQlMjAlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBJY2klMkMlMjBmYWlzb25zJTIwanVzdGUlMjB1bmUlMjByJUMzJUE5cGFydGl0aW9uJTIwNTAlMkY1MCUyMGVudHJlJTIwbGVzJTIwbiVDNSU5M3VkcyUyMDIlMkMlMjAzJTBBJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZG9tKCklMjAlM0MlMjAwLjUlM0ElMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjA1MCUyNSUyMGR1JTIwdGVtcHMlMkMlMjBub3VzJTIwcmV0b3Vybm9ucyUyME5vZGUlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybm9kZV8yJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwNTAlMjUlMjBkdSUyMHRlbXBzJTJDJTIwbm91cyUyMHJldG91cm5vbnMlMjBOb2RlJTIwMyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMm5vZGVfMyUyMg==",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Literal</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decide_mood</span>(<span class="hljs-params">state</span>) -&gt; <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;node_2&quot;</span>, <span class="hljs-string">&quot;node_3&quot;</span>]:
    
    <span class="hljs-comment"># Souvent, nous utiliserons l&#x27;état pour décider du prochain nœud à visiter</span>
    user_input = state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] 
    
    <span class="hljs-comment"># Ici, faisons juste une répartition 50/50 entre les nœuds 2, 3</span>
    <span class="hljs-keyword">if</span> random.random() &lt; <span class="hljs-number">0.5</span>:

        <span class="hljs-comment"># 50% du temps, nous retournons Node 2</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_2&quot;</span>
    
    <span class="hljs-comment"># 50% du temps, nous retournons Node 3</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_3&quot;</span>`,wrap:!1}}),H=new tt({props:{title:"4. StateGraph",local:"4-stategraph",headingTag:"h2"}}),Q=new O({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEltYWdlJTJDJTIwZGlzcGxheSUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEElMEElMjMlMjBDb25zdHJ1aXJlJTIwbGUlMjBncmFwaGUlMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChTdGF0ZSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMSUyMiUyQyUyMG5vZGVfMSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMiUyMiUyQyUyMG5vZGVfMiklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMyUyMiUyQyUyMG5vZGVfMyklMEElMEElMjMlMjBMb2dpcXVlJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMm5vZGVfMSUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMjJub2RlXzElMjIlMkMlMjBkZWNpZGVfbW9vZCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMiUyMiUyQyUyMEVORCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMyUyMiUyQyUyMEVORCklMEElMEElMjMlMjBBam91dGVyJTBBZ3JhcGglMjAlM0QlMjBidWlsZGVyLmNvbXBpbGUoKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END

<span class="hljs-comment"># Construire le graphe</span>
builder = StateGraph(State)
builder.add_node(<span class="hljs-string">&quot;node_1&quot;</span>, node_1)
builder.add_node(<span class="hljs-string">&quot;node_2&quot;</span>, node_2)
builder.add_node(<span class="hljs-string">&quot;node_3&quot;</span>, node_3)

<span class="hljs-comment"># Logique</span>
builder.add_edge(START, <span class="hljs-string">&quot;node_1&quot;</span>)
builder.add_conditional_edges(<span class="hljs-string">&quot;node_1&quot;</span>, decide_mood)
builder.add_edge(<span class="hljs-string">&quot;node_2&quot;</span>, END)
builder.add_edge(<span class="hljs-string">&quot;node_3&quot;</span>, END)

<span class="hljs-comment"># Ajouter</span>
graph = builder.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),F=new O({props:{code:"JTIzJTIwVmlzdWFsaXNlciUwQWRpc3BsYXkoSW1hZ2UoZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygpKSk=",highlighted:`<span class="hljs-comment"># Visualiser</span>
display(Image(graph.get_graph().draw_mermaid_png()))`,wrap:!1}}),X=new O({props:{code:"Z3JhcGguaW52b2tlKCU3QiUyMmdyYXBoX3N0YXRlJTIyJTIwJTNBJTIwJTIySGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjIlN0Qp",highlighted:'graph.invoke({<span class="hljs-string">&quot;graph_state&quot;</span> : <span class="hljs-string">&quot;Hi, this is Lance.&quot;</span>})',wrap:!1}}),Y=new O({props:{code:"LS0tTm9kZSUyMDEtLS0lMEEtLS1Ob2RlJTIwMy0tLSUwQSU3QidncmFwaF9zdGF0ZSclM0ElMjAnSGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjBJJTIwYW0lMjBzYWQhJyU3RA==",highlighted:`---<span class="hljs-keyword">Node</span> <span class="hljs-title">1---</span>
---<span class="hljs-keyword">Node</span> <span class="hljs-title">3---</span>
{&#x27;graph_state&#x27;: &#x27;Hi, this is Lance. I am sad!&#x27;}`,wrap:!1}}),K=new tt({props:{title:"Et maintenant ?",local:"et-maintenant-",headingTag:"h2"}}),D=new Te({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/langgraph/building_blocks.mdx"}}),{c(){c=i("meta"),lt=n(),et=i("p"),nt=n(),o(g.$$.fragment),at=n(),o(f.$$.fragment),it=n(),T=i("p"),T.textContent=Ft,pt=n(),U=i("img"),rt=n(),J=i("p"),J.innerHTML=zt,ot=n(),j=i("img"),ut=n(),o(w.$$.fragment),Mt=n(),$=i("p"),$.innerHTML=Wt,mt=n(),o(G.$$.fragment),dt=n(),C=i("p"),C.innerHTML=Yt,yt=n(),I=i("blockquote"),I.innerHTML=Kt,ct=n(),o(b.$$.fragment),ht=n(),_=i("p"),_.innerHTML=Pt,Ut=n(),v=i("ul"),v.innerHTML=Dt,gt=n(),o(k.$$.fragment),ft=n(),B=i("p"),B.textContent=Ot,Tt=n(),Z=i("ul"),Z.innerHTML=te,Jt=n(),x=i("blockquote"),x.innerHTML=ee,jt=n(),o(L.$$.fragment),wt=n(),S=i("p"),S.innerHTML=se,$t=n(),o(E.$$.fragment),Gt=n(),V=i("p"),V.textContent=le,Ct=n(),q=i("ul"),q.innerHTML=ne,It=n(),o(H.$$.fragment),bt=n(),R=i("p"),R.innerHTML=ae,_t=n(),o(Q.$$.fragment),vt=n(),A=i("p"),A.textContent=ie,kt=n(),o(F.$$.fragment),Bt=n(),N=i("img"),Zt=n(),z=i("p"),z.textContent=re,xt=n(),o(X.$$.fragment),Lt=n(),W=i("p"),W.textContent=oe,St=n(),o(Y.$$.fragment),Et=n(),o(K.$$.fragment),Vt=n(),P=i("p"),P.textContent=ue,qt=n(),o(D.$$.fragment),Ht=n(),st=i("p"),this.h()},l(t){const e=Ue("svelte-u9bgzb",document.head);c=p(e,"META",{name:!0,content:!0}),e.forEach(s),lt=a(t),et=p(t,"P",{}),Me(et).forEach(s),nt=a(t),u(g.$$.fragment,t),at=a(t),u(f.$$.fragment,t),it=a(t),T=p(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18x2c8u"&&(T.textContent=Ft),pt=a(t),U=p(t,"IMG",{src:!0,alt:!0,width:!0}),rt=a(t),J=p(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-zhtr0u"&&(J.innerHTML=zt),ot=a(t),j=p(t,"IMG",{src:!0,alt:!0}),ut=a(t),u(w.$$.fragment,t),Mt=a(t),$=p(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1bnapx2"&&($.innerHTML=Wt),mt=a(t),u(G.$$.fragment,t),dt=a(t),C=p(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1wufid7"&&(C.innerHTML=Yt),yt=a(t),I=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(I)!=="svelte-awafok"&&(I.innerHTML=Kt),ct=a(t),u(b.$$.fragment,t),ht=a(t),_=p(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-pinv1k"&&(_.innerHTML=Pt),Ut=a(t),v=p(t,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-1f7e4tg"&&(v.innerHTML=Dt),gt=a(t),u(k.$$.fragment,t),ft=a(t),B=p(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-idcot5"&&(B.textContent=Ot),Tt=a(t),Z=p(t,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-15s4yix"&&(Z.innerHTML=te),Jt=a(t),x=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(x)!=="svelte-1is4zni"&&(x.innerHTML=ee),jt=a(t),u(L.$$.fragment,t),wt=a(t),S=p(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-rsvnlm"&&(S.innerHTML=se),$t=a(t),u(E.$$.fragment,t),Gt=a(t),V=p(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-e31ekt"&&(V.textContent=le),Ct=a(t),q=p(t,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-8qlrxe"&&(q.innerHTML=ne),It=a(t),u(H.$$.fragment,t),bt=a(t),R=p(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-u4ohlg"&&(R.innerHTML=ae),_t=a(t),u(Q.$$.fragment,t),vt=a(t),A=p(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1gx08rj"&&(A.textContent=ie),kt=a(t),u(F.$$.fragment,t),Bt=a(t),N=p(t,"IMG",{src:!0,alt:!0}),Zt=a(t),z=p(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1wsm38p"&&(z.textContent=re),xt=a(t),u(X.$$.fragment,t),Lt=a(t),W=p(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1sclt0g"&&(W.textContent=oe),St=a(t),u(Y.$$.fragment,t),Et=a(t),u(K.$$.fragment,t),Vt=a(t),P=p(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-z0kfq8"&&(P.textContent=ue),qt=a(t),u(D.$$.fragment,t),Ht=a(t),st=p(t,"P",{}),Me(st).forEach(s),this.h()},h(){h(c,"name","hf:doc:metadata"),h(c,"content",je),Qt(U.src,Nt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Building_blocks.png")||h(U,"src",Nt),h(U,"alt","Building Blocks"),h(U,"width","70%"),Qt(j.src,Xt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/application.png")||h(j,"src",Xt),h(j,"alt","Application"),Qt(N.src,pe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/basic_graph.jpeg")||h(N,"src",pe),h(N,"alt","Graph Visualization")},m(t,e){ge(document.head,c),l(t,lt,e),l(t,et,e),l(t,nt,e),M(g,t,e),l(t,at,e),M(f,t,e),l(t,it,e),l(t,T,e),l(t,pt,e),l(t,U,e),l(t,rt,e),l(t,J,e),l(t,ot,e),l(t,j,e),l(t,ut,e),M(w,t,e),l(t,Mt,e),l(t,$,e),l(t,mt,e),M(G,t,e),l(t,dt,e),l(t,C,e),l(t,yt,e),l(t,I,e),l(t,ct,e),M(b,t,e),l(t,ht,e),l(t,_,e),l(t,Ut,e),l(t,v,e),l(t,gt,e),M(k,t,e),l(t,ft,e),l(t,B,e),l(t,Tt,e),l(t,Z,e),l(t,Jt,e),l(t,x,e),l(t,jt,e),M(L,t,e),l(t,wt,e),l(t,S,e),l(t,$t,e),M(E,t,e),l(t,Gt,e),l(t,V,e),l(t,Ct,e),l(t,q,e),l(t,It,e),M(H,t,e),l(t,bt,e),l(t,R,e),l(t,_t,e),M(Q,t,e),l(t,vt,e),l(t,A,e),l(t,kt,e),M(F,t,e),l(t,Bt,e),l(t,N,e),l(t,Zt,e),l(t,z,e),l(t,xt,e),M(X,t,e),l(t,Lt,e),l(t,W,e),l(t,St,e),M(Y,t,e),l(t,Et,e),M(K,t,e),l(t,Vt,e),l(t,P,e),l(t,qt,e),M(D,t,e),l(t,Ht,e),l(t,st,e),Rt=!0},p:de,i(t){Rt||(m(g.$$.fragment,t),m(f.$$.fragment,t),m(w.$$.fragment,t),m(G.$$.fragment,t),m(b.$$.fragment,t),m(k.$$.fragment,t),m(L.$$.fragment,t),m(E.$$.fragment,t),m(H.$$.fragment,t),m(Q.$$.fragment,t),m(F.$$.fragment,t),m(X.$$.fragment,t),m(Y.$$.fragment,t),m(K.$$.fragment,t),m(D.$$.fragment,t),Rt=!0)},o(t){d(g.$$.fragment,t),d(f.$$.fragment,t),d(w.$$.fragment,t),d(G.$$.fragment,t),d(b.$$.fragment,t),d(k.$$.fragment,t),d(L.$$.fragment,t),d(E.$$.fragment,t),d(H.$$.fragment,t),d(Q.$$.fragment,t),d(F.$$.fragment,t),d(X.$$.fragment,t),d(Y.$$.fragment,t),d(K.$$.fragment,t),d(D.$$.fragment,t),Rt=!1},d(t){t&&(s(lt),s(et),s(nt),s(at),s(it),s(T),s(pt),s(U),s(rt),s(J),s(ot),s(j),s(ut),s(Mt),s($),s(mt),s(dt),s(C),s(yt),s(I),s(ct),s(ht),s(_),s(Ut),s(v),s(gt),s(ft),s(B),s(Tt),s(Z),s(Jt),s(x),s(jt),s(wt),s(S),s($t),s(Gt),s(V),s(Ct),s(q),s(It),s(bt),s(R),s(_t),s(vt),s(A),s(kt),s(Bt),s(N),s(Zt),s(z),s(xt),s(Lt),s(W),s(St),s(Et),s(Vt),s(P),s(qt),s(Ht),s(st)),s(c),y(g,t),y(f,t),y(w,t),y(G,t),y(b,t),y(k,t),y(L,t),y(E,t),y(H,t),y(Q,t),y(F,t),y(X,t),y(Y,t),y(K,t),y(D,t)}}}const je='{"title":"Les composants de base de LangGraph","local":"les-composants-de-base-de-langgraph","sections":[{"title":"1. État","local":"1-état","sections":[],"depth":2},{"title":"2. Nœuds","local":"2-nœuds","sections":[],"depth":2},{"title":"3. Arêtes","local":"3-arêtes","sections":[],"depth":2},{"title":"4. StateGraph","local":"4-stategraph","sections":[],"depth":2},{"title":"Et maintenant ?","local":"et-maintenant-","sections":[],"depth":2}],"depth":1}';function we(At){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends ce{constructor(c){super(),he(this,c,we,Je,me,{})}}export{_e as component};
