import{s as el,n as ll,o as tl}from"../chunks/scheduler.505acc25.js";import{S as nl,i as al,e as o,s as n,c as r,q as Te,h as ol,a as p,d as l,b as a,f as Ue,g as u,j as i,r as fe,k as Ts,l as ds,m as t,n as c,t as M,o as w,p as d}from"../chunks/index.b1175496.js";import{C as pl,H as U}from"../chunks/Heading.988e52fa.js";import{C as f}from"../chunks/CodeBlock.ed64aebc.js";import{E as il}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function rl(be){let y,Us,js,fs,b,bs,h,hs,I,he="Un <em>workflow</em> dans LlamaIndex fournit un moyen structuré d’organiser votre code en étapes séquentielles et gérables.",Is,v,Ie=`Un tel <em>workflow</em> est créé en définissant des <code>Steps</code> qui sont déclenchés par des <code>Events</code>, et qui émettent eux-mêmes des <code>Events</code> pour déclencher d’autres étapes.
Jetons un coup d’œil à Alfred montrant un <em>workflow</em> LlamaIndex pour une tâche de RAG.`,vs,k,ve='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflow Schematic"/>',ks,C,ke="<strong>Les <em>workflows</em> offrent plusieurs avantages clés :</strong>",Cs,B,Ce="<li>Organisation claire du code en étapes discrètes</li> <li>Architecture événementielle pour un flux de contrôle flexible</li> <li>Communication <em>type-safe</em> entre les étapes</li> <li>Gestion d’état intégrée</li> <li>Support pour des interactions d’agents simples et complexes</li>",Bs,g,Be="Comme vous l’avez peut-être deviné, <strong>les <em>workflows</em> trouvent un excellent équilibre entre l’autonomie des agents tout en maintenant le contrôle sur le <em>workflow</em> global.</strong>",gs,G,ge="Alors, apprenons à créer un <em>workflow</em> nous-mêmes !",Gs,Z,Zs,j,Ge='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/llama-index/workflows.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',Vs,V,xs,m,ms,Ze="Installer le package <i>Workflow</i>",ye,x,Ve="section sur le LlamaHub",je,ys,xe="Workflow",Je,E,Es,_,Ee=`Nous pouvons créer un <em>workflow</em> en une seule étape en définissant une classe qui hérite de <code>Workflow</code> et en décorant vos fonctions avec <code>@step</code>.
Nous devrons également ajouter <code>StartEvent</code> et <code>StopEvent</code>, qui sont des événements spéciaux utilisés pour indiquer le début et la fin du <em>workflow</em>.`,_s,W,Ws,q,_e="Comme vous pouvez le voir, nous pouvons maintenant exécuter le <em>workflow</em> en appelant <code>w.run()</code>.",qs,$,$s,Q,We=`Pour connecter plusieurs étapes, nous <strong>créons des événements personnalisés qui transportent des données entre les étapes.</strong>
Pour ce faire, nous devons ajouter un <code>Event</code> qui est passé entre les étapes et transfère la sortie de la première étape vers la deuxième étape.`,Qs,A,As,H,qe="L’indication de type est importante ici, car elle garantit que le <em>workflow</em> est exécuté correctement. Compliquons un peu les choses !",Hs,S,Ss,X,$e="L’indication de type est la partie la plus puissante des <em>workflows</em> car elle nous permet de créer des branches, des boucles et des jointures pour faciliter des <em>workflows</em> plus complexes.",Xs,z,Qe=`Montrons un exemple de <strong>création d’une boucle</strong> en utilisant l’opérateur union <code>|</code>.
Dans l’exemple ci-dessous, nous voyons que le <code>LoopEvent</code> est pris en entrée pour l’étape et peut également être retourné en sortie.`,zs,R,Rs,N,Ns,L,Ae="Nous pouvons également dessiner des <em>workflows</em>. Utilisons la fonction <code>draw_all_possible_flows</code> pour dessiner le <em>workflow</em>. Cela stocke le <em>workflow</em> dans un fichier HTML.",Ls,F,Fs,Y,He='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="workflow drawing"/>',Ys,P,Se="Il y a une dernière astuce cool que nous couvrirons dans le cours, qui est la capacité d’ajouter de l’état au <em>workflow</em>.",Ps,D,Ds,K,Xe=`La gestion d’état est utile quand vous voulez garder une trace de l’état du <em>workflow</em>, pour que chaque étape ait accès au même état.
Nous pouvons faire cela en utilisant l’indication de type <code>Context</code> au-dessus d’un paramètre dans la fonction d’étape.`,Ks,O,Os,ss,ze="Parfait ! Maintenant vous savez comment créer des <em>workflows</em> de base dans LlamaIndex !",se,J,Re='<p>Il y a quelques nuances plus complexes aux <i>workflows</i>, que vous pouvez apprendre dans <a href="https://docs.llamaindex.ai/en/stable/understanding/workflows/">la documentation LlamaIndex</a>.</p>',ee,es,Ne="Cependant, il y a une autre façon de créer des <em>workflows</em>, qui repose sur la classe <code>AgentWorkflow</code>. Jetons un coup d’œil à comment nous pouvons utiliser cela pour créer un <em>workflow</em> multi-agents.",le,ls,te,ts,Le=`Au lieu de la création manuelle de <em>workflows</em>, nous pouvons utiliser la <strong>classe <code>AgentWorkflow</code> pour créer un <em>workflow</em> multi-agents</strong>.
L’<code>AgentWorkflow</code> utilise des <em>Workflow Agents</em> pour vous permettre de créer un système d’un ou plusieurs agents qui peuvent collaborer et se passer des tâches entre eux basées sur leurs capacités spécialisées.
Cela permet de construire des systèmes d’agents complexes où différents agents gèrent différents aspects d’une tâche.
Au lieu d’importer des classes de <code>llama_index.core.agent</code>, nous importerons les classes d’agents de <code>llama_index.core.agent.workflow</code>.
Un agent doit être désigné comme l’agent racine dans le constructeur <code>AgentWorkflow</code>.
Quand un message utilisateur arrive, il est d’abord routé vers l’agent racine.`,ne,ns,Fe="Chaque agent peut ensuite :",ae,as,Ye="<li>Gérer la demande directement en utilisant leurs outils</li> <li>Passer le relais à un autre agent mieux adapté à la tâche</li> <li>Retourner une réponse à l’utilisateur</li>",oe,os,Pe="Voyons comment créer un <em>workflow</em> multi-agents.",pe,ps,ie,is,De=`Les outils d’agents peuvent également modifier l’état du <em>workflow</em> que nous avons mentionné plus tôt. Avant de commencer le <em>workflow</em>, nous pouvons fournir un dictionnaire d’état initial qui sera disponible pour tous les agents.
L’état est stocké dans la clé d’état du contexte du <em>workflow</em>. Il sera injecté dans le <em>state_prompt</em> qui augmente chaque nouveau message utilisateur.`,re,rs,Ke="Injectons un compteur pour compter les appels de fonctions en modifiant l’exemple précédent :",ue,us,ce,cs,Oe="Félicitations ! Vous avez maintenant passer en revue les bases des agents dans LlamaIndex ! 🎉",Me,Ms,sl="Continuons avec un dernier quiz pour solidifier vos connaissances ! 🚀",we,ws,de,Js,me;return b=new pl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new U({props:{title:"Créer des workflows agentiques dans LlamaIndex",local:"créer-des-workflows-agentiques-dans-llamaindex",headingTag:"h1"}}),Z=new U({props:{title:"Créer des Workflows",local:"créer-des-workflows",headingTag:"h2"}}),V=new U({props:{title:"Création de Workflow de base",local:"création-de-workflow-de-base",headingTag:"h3"}}),E=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),W=new f({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),$=new U({props:{title:"Connecter plusieurs étapes",local:"connecter-plusieurs-étapes",headingTag:"h3"}}),A=new f({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyYWl0ZW1lbnQlMjBkZXMlMjBkb25uJUMzJUE5ZXMlMjBpbml0aWFsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBQcm9jZXNzaW5nRXZlbnQoaW50ZXJtZWRpYXRlX3Jlc3VsdCUzRCUyMlN0ZXAlMjAxJTIwY29tcGxldGUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVdGlsaXNlciUyMGxlJTIwciVDMyVBOXN1bHRhdCUyMGludGVybSVDMyVBOWRpYWlyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Traitement des données initiales</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Utiliser le résultat intermédiaire</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),S=new U({props:{title:"Boucles et branches",local:"boucles-et-branches",headingTag:"h3"}}),R=new f({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVdGlsaXNlciUyMGxlJTIwciVDMyVBOXN1bHRhdCUyMGludGVybSVDMyVBOWRpYWlyZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent | LoopEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Utiliser le résultat intermédiaire</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),N=new U({props:{title:"Dessiner des Workflows",local:"dessiner-des-workflows",headingTag:"h3"}}),F=new f({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwdGVsJTIwcXVlJTIwZCVDMyVBOWZpbmklMjBkYW5zJTIwbGElMjBzZWN0aW9uJTIwcHIlQzMlQTljJUMzJUE5ZGVudGV0ZWwlMjBxdWUlMjBkJUMzJUE5ZmluaSUyMGRhbnMlMjBsYSUyMHNlY3Rpb24lMjBwciVDMyVBOWMlQzMlQTlkZW50ZSUwQWRyYXdfYWxsX3Bvc3NpYmxlX2Zsb3dzKHclMkMlMjAlMjJmbG93Lmh0bWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># tel que défini dans la section précédentetel que défini dans la section précédente</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),D=new U({props:{title:"Gestion d’état",local:"gestion-détat",headingTag:"h3"}}),O=new f({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzdG9ja2VyJTIwbGElMjByZXF1JUMzJUFBdGUlMjBkYW5zJTIwbGUlMjBjb250ZXh0ZSUwQSUyMCUyMCUyMCUyMGF3YWl0JTIwY3R4LnN0b3JlLnNldCglMjJxdWVyeSUyMiUyQyUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBmYWlyZSUyMHF1ZWxxdWUlMjBjaG9zZSUyMGF2ZWMlMjBsZSUyMGNvbnRleHRlJTIwZXQlMjBsJ2V2ZW50JTBBJTIwJTIwJTIwJTIwdmFsJTIwJTNEJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwciVDMyVBOWN1cCVDMyVBOXJlciUyMGxhJTIwcmVxdSVDMyVBQXRlJTIwZGFucyUyMGxlJTIwY29udGV4dGUlMEElMjAlMjAlMjAlMjBxdWVyeSUyMCUzRCUyMGF3YWl0JTIwY3R4LnN0b3JlLmdldCglMjJxdWVyeSUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBTdG9wRXZlbnQocmVzdWx0JTNEdmFsKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># stocker la requête dans le contexte</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># faire quelque chose avec le contexte et l&#x27;event</span>
    val = ...

    <span class="hljs-comment"># récupérer la requête dans le contexte</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=val)`,wrap:!1}}),ls=new U({props:{title:"Automatiser les workflows avec des Multi-Agent Workflows",local:"automatiser-les-workflows-avec-des-multi-agent-workflows",headingTag:"h2"}}),ps=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Définir quelques outils</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Additionner deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplier deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># nous pouvons passer des fonctions directement sans FunctionTool -- les fn/docstring sont analysés pour le nom/description</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Créer le workflow</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Exécuter le système</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),us=new f({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Définir quelques outils</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Additionner deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># mettre à jour notre comptage</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplier deux nombres.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># mettre à jour notre comptage</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># exécuter le workflow avec le contexte</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># sortir et inspecter l&#x27;état</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),ws=new il({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/llama-index/workflows.mdx"}}),{c(){y=o("meta"),Us=n(),js=o("p"),fs=n(),r(b.$$.fragment),bs=n(),r(h.$$.fragment),hs=n(),I=o("p"),I.innerHTML=he,Is=n(),v=o("p"),v.innerHTML=Ie,vs=n(),k=o("p"),k.innerHTML=ve,ks=n(),C=o("p"),C.innerHTML=ke,Cs=n(),B=o("ul"),B.innerHTML=Ce,Bs=n(),g=o("p"),g.innerHTML=Be,gs=n(),G=o("p"),G.innerHTML=ge,Gs=n(),r(Z.$$.fragment),Zs=n(),j=o("blockquote"),j.innerHTML=Ge,Vs=n(),r(V.$$.fragment),xs=n(),m=o("details"),ms=o("summary"),ms.innerHTML=Ze,ye=Te(`
Comme introduit dans la `),x=o("a"),x.textContent=Ve,je=Te(", nous pouvons installer le package "),ys=o("code"),ys.textContent=xe,Je=Te(` avec la commande suivante :

	`),r(E.$$.fragment),Es=n(),_=o("p"),_.innerHTML=Ee,_s=n(),r(W.$$.fragment),Ws=n(),q=o("p"),q.innerHTML=_e,qs=n(),r($.$$.fragment),$s=n(),Q=o("p"),Q.innerHTML=We,Qs=n(),r(A.$$.fragment),As=n(),H=o("p"),H.innerHTML=qe,Hs=n(),r(S.$$.fragment),Ss=n(),X=o("p"),X.innerHTML=$e,Xs=n(),z=o("p"),z.innerHTML=Qe,zs=n(),r(R.$$.fragment),Rs=n(),r(N.$$.fragment),Ns=n(),L=o("p"),L.innerHTML=Ae,Ls=n(),r(F.$$.fragment),Fs=n(),Y=o("p"),Y.innerHTML=He,Ys=n(),P=o("p"),P.innerHTML=Se,Ps=n(),r(D.$$.fragment),Ds=n(),K=o("p"),K.innerHTML=Xe,Ks=n(),r(O.$$.fragment),Os=n(),ss=o("p"),ss.innerHTML=ze,se=n(),J=o("blockquote"),J.innerHTML=Re,ee=n(),es=o("p"),es.innerHTML=Ne,le=n(),r(ls.$$.fragment),te=n(),ts=o("p"),ts.innerHTML=Le,ne=n(),ns=o("p"),ns.textContent=Fe,ae=n(),as=o("ul"),as.innerHTML=Ye,oe=n(),os=o("p"),os.innerHTML=Pe,pe=n(),r(ps.$$.fragment),ie=n(),is=o("p"),is.innerHTML=De,re=n(),rs=o("p"),rs.textContent=Ke,ue=n(),r(us.$$.fragment),ce=n(),cs=o("p"),cs.textContent=Oe,Me=n(),Ms=o("p"),Ms.textContent=sl,we=n(),r(ws.$$.fragment),de=n(),Js=o("p"),this.h()},l(s){const e=ol("svelte-u9bgzb",document.head);y=p(e,"META",{name:!0,content:!0}),e.forEach(l),Us=a(s),js=p(s,"P",{}),Ue(js).forEach(l),fs=a(s),u(b.$$.fragment,s),bs=a(s),u(h.$$.fragment,s),hs=a(s),I=p(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-5cgz8d"&&(I.innerHTML=he),Is=a(s),v=p(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-cbvicn"&&(v.innerHTML=Ie),vs=a(s),k=p(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-whmuha"&&(k.innerHTML=ve),ks=a(s),C=p(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-klkse7"&&(C.innerHTML=ke),Cs=a(s),B=p(s,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-1xmwb5a"&&(B.innerHTML=Ce),Bs=a(s),g=p(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1w1c494"&&(g.innerHTML=Be),gs=a(s),G=p(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1b9bk90"&&(G.innerHTML=ge),Gs=a(s),u(Z.$$.fragment,s),Zs=a(s),j=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(j)!=="svelte-oi3xbb"&&(j.innerHTML=Ge),Vs=a(s),u(V.$$.fragment,s),xs=a(s),m=p(s,"DETAILS",{});var T=Ue(m);ms=p(T,"SUMMARY",{"data-svelte-h":!0}),i(ms)!=="svelte-19cqk5h"&&(ms.innerHTML=Ze),ye=fe(T,`
Comme introduit dans la `),x=p(T,"A",{href:!0,"data-svelte-h":!0}),i(x)!=="svelte-1pl43ly"&&(x.textContent=Ve),je=fe(T,", nous pouvons installer le package "),ys=p(T,"CODE",{"data-svelte-h":!0}),i(ys)!=="svelte-sosek1"&&(ys.textContent=xe),Je=fe(T,` avec la commande suivante :

	`),u(E.$$.fragment,T),T.forEach(l),Es=a(s),_=p(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1sl0sod"&&(_.innerHTML=Ee),_s=a(s),u(W.$$.fragment,s),Ws=a(s),q=p(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-931ze4"&&(q.innerHTML=_e),qs=a(s),u($.$$.fragment,s),$s=a(s),Q=p(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-12kywcz"&&(Q.innerHTML=We),Qs=a(s),u(A.$$.fragment,s),As=a(s),H=p(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-qgro0z"&&(H.innerHTML=qe),Hs=a(s),u(S.$$.fragment,s),Ss=a(s),X=p(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-szxamf"&&(X.innerHTML=$e),Xs=a(s),z=p(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1lfwgtw"&&(z.innerHTML=Qe),zs=a(s),u(R.$$.fragment,s),Rs=a(s),u(N.$$.fragment,s),Ns=a(s),L=p(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1ovmdvg"&&(L.innerHTML=Ae),Ls=a(s),u(F.$$.fragment,s),Fs=a(s),Y=p(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1j5vf43"&&(Y.innerHTML=He),Ys=a(s),P=p(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1j9ku4g"&&(P.innerHTML=Se),Ps=a(s),u(D.$$.fragment,s),Ds=a(s),K=p(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1e7y3ck"&&(K.innerHTML=Xe),Ks=a(s),u(O.$$.fragment,s),Os=a(s),ss=p(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-dlbiw8"&&(ss.innerHTML=ze),se=a(s),J=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(J)!=="svelte-7hggce"&&(J.innerHTML=Re),ee=a(s),es=p(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-qiy9vi"&&(es.innerHTML=Ne),le=a(s),u(ls.$$.fragment,s),te=a(s),ts=p(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-lpmh0e"&&(ts.innerHTML=Le),ne=a(s),ns=p(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-gkja97"&&(ns.textContent=Fe),ae=a(s),as=p(s,"UL",{"data-svelte-h":!0}),i(as)!=="svelte-10bnzp4"&&(as.innerHTML=Ye),oe=a(s),os=p(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-j3rou5"&&(os.innerHTML=Pe),pe=a(s),u(ps.$$.fragment,s),ie=a(s),is=p(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-181xssw"&&(is.innerHTML=De),re=a(s),rs=p(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-bbhsjt"&&(rs.textContent=Ke),ue=a(s),u(us.$$.fragment,s),ce=a(s),cs=p(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-101kzby"&&(cs.textContent=Oe),Me=a(s),Ms=p(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-rfxun4"&&(Ms.textContent=sl),we=a(s),u(ws.$$.fragment,s),de=a(s),Js=p(s,"P",{}),Ue(Js).forEach(l),this.h()},h(){Ts(y,"name","hf:doc:metadata"),Ts(y,"content",ul),Ts(j,"class","tip"),Ts(x,"href","./llama-hub"),Ts(J,"class","tip")},m(s,e){ds(document.head,y),t(s,Us,e),t(s,js,e),t(s,fs,e),c(b,s,e),t(s,bs,e),c(h,s,e),t(s,hs,e),t(s,I,e),t(s,Is,e),t(s,v,e),t(s,vs,e),t(s,k,e),t(s,ks,e),t(s,C,e),t(s,Cs,e),t(s,B,e),t(s,Bs,e),t(s,g,e),t(s,gs,e),t(s,G,e),t(s,Gs,e),c(Z,s,e),t(s,Zs,e),t(s,j,e),t(s,Vs,e),c(V,s,e),t(s,xs,e),t(s,m,e),ds(m,ms),ds(m,ye),ds(m,x),ds(m,je),ds(m,ys),ds(m,Je),c(E,m,null),t(s,Es,e),t(s,_,e),t(s,_s,e),c(W,s,e),t(s,Ws,e),t(s,q,e),t(s,qs,e),c($,s,e),t(s,$s,e),t(s,Q,e),t(s,Qs,e),c(A,s,e),t(s,As,e),t(s,H,e),t(s,Hs,e),c(S,s,e),t(s,Ss,e),t(s,X,e),t(s,Xs,e),t(s,z,e),t(s,zs,e),c(R,s,e),t(s,Rs,e),c(N,s,e),t(s,Ns,e),t(s,L,e),t(s,Ls,e),c(F,s,e),t(s,Fs,e),t(s,Y,e),t(s,Ys,e),t(s,P,e),t(s,Ps,e),c(D,s,e),t(s,Ds,e),t(s,K,e),t(s,Ks,e),c(O,s,e),t(s,Os,e),t(s,ss,e),t(s,se,e),t(s,J,e),t(s,ee,e),t(s,es,e),t(s,le,e),c(ls,s,e),t(s,te,e),t(s,ts,e),t(s,ne,e),t(s,ns,e),t(s,ae,e),t(s,as,e),t(s,oe,e),t(s,os,e),t(s,pe,e),c(ps,s,e),t(s,ie,e),t(s,is,e),t(s,re,e),t(s,rs,e),t(s,ue,e),c(us,s,e),t(s,ce,e),t(s,cs,e),t(s,Me,e),t(s,Ms,e),t(s,we,e),c(ws,s,e),t(s,de,e),t(s,Js,e),me=!0},p:ll,i(s){me||(M(b.$$.fragment,s),M(h.$$.fragment,s),M(Z.$$.fragment,s),M(V.$$.fragment,s),M(E.$$.fragment,s),M(W.$$.fragment,s),M($.$$.fragment,s),M(A.$$.fragment,s),M(S.$$.fragment,s),M(R.$$.fragment,s),M(N.$$.fragment,s),M(F.$$.fragment,s),M(D.$$.fragment,s),M(O.$$.fragment,s),M(ls.$$.fragment,s),M(ps.$$.fragment,s),M(us.$$.fragment,s),M(ws.$$.fragment,s),me=!0)},o(s){w(b.$$.fragment,s),w(h.$$.fragment,s),w(Z.$$.fragment,s),w(V.$$.fragment,s),w(E.$$.fragment,s),w(W.$$.fragment,s),w($.$$.fragment,s),w(A.$$.fragment,s),w(S.$$.fragment,s),w(R.$$.fragment,s),w(N.$$.fragment,s),w(F.$$.fragment,s),w(D.$$.fragment,s),w(O.$$.fragment,s),w(ls.$$.fragment,s),w(ps.$$.fragment,s),w(us.$$.fragment,s),w(ws.$$.fragment,s),me=!1},d(s){s&&(l(Us),l(js),l(fs),l(bs),l(hs),l(I),l(Is),l(v),l(vs),l(k),l(ks),l(C),l(Cs),l(B),l(Bs),l(g),l(gs),l(G),l(Gs),l(Zs),l(j),l(Vs),l(xs),l(m),l(Es),l(_),l(_s),l(Ws),l(q),l(qs),l($s),l(Q),l(Qs),l(As),l(H),l(Hs),l(Ss),l(X),l(Xs),l(z),l(zs),l(Rs),l(Ns),l(L),l(Ls),l(Fs),l(Y),l(Ys),l(P),l(Ps),l(Ds),l(K),l(Ks),l(Os),l(ss),l(se),l(J),l(ee),l(es),l(le),l(te),l(ts),l(ne),l(ns),l(ae),l(as),l(oe),l(os),l(pe),l(ie),l(is),l(re),l(rs),l(ue),l(ce),l(cs),l(Me),l(Ms),l(we),l(de),l(Js)),l(y),d(b,s),d(h,s),d(Z,s),d(V,s),d(E),d(W,s),d($,s),d(A,s),d(S,s),d(R,s),d(N,s),d(F,s),d(D,s),d(O,s),d(ls,s),d(ps,s),d(us,s),d(ws,s)}}}const ul='{"title":"Créer des workflows agentiques dans LlamaIndex","local":"créer-des-workflows-agentiques-dans-llamaindex","sections":[{"title":"Créer des Workflows","local":"créer-des-workflows","sections":[{"title":"Création de Workflow de base","local":"création-de-workflow-de-base","sections":[],"depth":3},{"title":"Connecter plusieurs étapes","local":"connecter-plusieurs-étapes","sections":[],"depth":3},{"title":"Boucles et branches","local":"boucles-et-branches","sections":[],"depth":3},{"title":"Dessiner des Workflows","local":"dessiner-des-workflows","sections":[],"depth":3},{"title":"Gestion d’état","local":"gestion-détat","sections":[],"depth":3}],"depth":2},{"title":"Automatiser les workflows avec des Multi-Agent Workflows","local":"automatiser-les-workflows-avec-des-multi-agent-workflows","sections":[],"depth":2}],"depth":1}';function cl(be){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends nl{constructor(y){super(),al(this,y,cl,rl,el,{})}}export{jl as component};
