import{s as ll,n as sl,o as tl}from"../chunks/scheduler.505acc25.js";import{S as nl,i as al,e as i,s as n,c as o,h as il,a as r,d as s,b as a,f as Oe,g as u,j as M,k as Ve,l as rl,m as t,n as c,t as p,o as y,p as d}from"../chunks/index.b1175496.js";import{C as Ml,H as D}from"../chunks/Heading.988e52fa.js";import{C as el}from"../chunks/CodeBlock.ed64aebc.js";import{C as ol}from"../chunks/CourseFloatingBanner.79ef6243.js";import{E as ul}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function cl(ve){let J,Y,L,P,m,K,j,O,T,ee,U,Qe='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/retrieval_agents.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',le,I,qe="Les systèmes de RAG (<em>Retrieval Augmented Generation</em>) combinent les capacités de récupération de données et de modèles de génération pour fournir des réponses contextuelles. Par exemple, la requête d’un utilisateur est transmise à un moteur de recherche puis les résultats récupérés sont fournis au LLM avec la requête. Le modèle génère ensuite une réponse basée sur la requête et les informations récupérées.",se,w,Ae="Le RAG agentique (<em>Agentic RAG</em>) étend les systèmes de RAG traditionnels en <strong>combinant des agents autonomes avec une récupération dynamique des connaissances</strong>.",te,h,xe="Alors que les systèmes de RAG traditionnels utilisent un LLM pour répondre aux requêtes basées sur des données récupérées, le RAG agentique <strong>permet un contrôle intelligent des processus de récupération et de génération</strong>, améliorant l’efficacité et la précision.",ne,b,Xe="Les systèmes de RAG traditionnels font face à des limitations clés, telles que <strong>s’appuyer sur une seule étape de récupération</strong> et se concentrer sur la similarité sémantique directe avec la requête de l’utilisateur, ce qui peut négliger des informations pertinentes.",ae,C,ze="Le RAG agentique résout ces problèmes en permettant à l’agent de formuler de manière autonome des requêtes, de critiquer les résultats récupérés et de mener plusieurs étapes de récupération pour une sortie plus adaptée et complète.",ie,G,re,f,Ee="Construisons un agent simple qui peut rechercher sur le web en utilisant DuckDuckGo. Cet agent récupérera des informations et synthétisera des réponses pour répondre aux requêtes. Avec le RAG agentique, l’agent d’Alfred peut :",Me,B,Re="<li>Rechercher des dernières tendances en matière de fêtes de super-héros</li> <li>Affiner les résultats pour inclure des éléments luxueux</li> <li>Synthétiser les informations en un plan complet</li>",oe,Z,We="Voici comment l’agent d’Alfred peut y parvenir :",ue,g,ce,V,ke="L’agent suit ce processus :",pe,v,Ne="<li><strong>Analyse la requête :</strong> identifie les éléments clés de la requête - organisation de fêtes de luxe sur le thème des super-héros, en mettant l’accent sur la décoration, les divertissements et la restauration.</li> <li><strong>Effectue la récupération :</strong> exploite DuckDuckGo pour rechercher les informations les plus pertinentes et à jour, en s’assurant qu’elles correspondent aux préférences d’Alfred pour un événement luxueux.</li> <li><strong>Synthétise l’information :</strong> après avoir rassemblé les résultats, l’agent les traite en un plan cohérent et actionnable pour Alfred, couvrant tous les aspects de la fête.</li> <li><strong>Stocke pour référence future :</strong> stocke les informations récupérées pour un accès facile lors de la planification d’événements futurs, optimisant l’efficacité des tâches ultérieures.</li>",ye,Q,de,q,Se="Pour des tâches spécialisées, une base de connaissances personnalisée peut être inestimable. Créons un outil qui interroge une base de données vectorielle de documentation technique ou de connaissances spécialisées. En utilisant la recherche sémantique, l’agent peut trouver les informations les plus pertinentes pour les besoins d’Alfred.",Je,A,He="Une base de données vectorielle stocke des représentations numériques (<em>embeddings</em>) de texte ou d’autres données, créées par des modèles d’apprentissage automatique. Elle permet la recherche sémantique en identifiant des significations similaires dans un espace de haute dimension.",Ue,x,_e="Cette approche combine des connaissances prédéfinies avec une recherche sémantique pour fournir des solutions contextuelles pour la planification d’événements. Avec un accès à des connaissances spécialisées, Alfred peut perfectionner chaque détail de la fête.",me,X,$e="Dans cet exemple, nous allons créer un outil qui récupère des idées de planification de fête à partir d’une base de connaissances personnalisée. Nous utiliserons un modèle BM25 pour rechercher dans la base de connaissances et retourner les meilleurs résultats, et <code>RecursiveCharacterTextSplitter</code> pour diviser les documents en morceaux plus petits pour une recherche plus efficace.",je,z,Te,E,Le="Cet agent amélioré peut :",Ie,R,Fe="<li>D’abord vérifier la documentation pour des informations pertinentes</li> <li>Combiner les informations de la base de connaissances</li> <li>Maintenir le contexte de conversation en mémoire</li>",we,W,he,k,De="Lors de la construction de systèmes de RAG agentiques, l’agent peut employer des stratégies sophistiquées comme :",be,N,Ye='<li><strong>La reformulation de requête :</strong> Au lieu d’utiliser la requête brute de l’utilisateur, l’agent peut élaborer des termes de recherche optimisés qui correspondent mieux aux documents cibles</li> <li><strong>La décomposition de requête :</strong> Au lieu d’utiliser directement la requête de l’utilisateur, si elle contient plusieurs éléments d’information à interroger, elle peut être décomposée en plusieurs requêtes</li> <li><strong>L’expansion de requête :</strong> Similaire à la reformulation de requête mais effectuée plusieurs fois pour formuler la requête de plusieurs façons et les interroger toutes</li> <li><strong>Le reclassement :</strong> Utiliser des <a href="https://huggingface.co/models?pipeline_tag=text-ranking&amp;sort=trending" rel="nofollow"><em>Cross-Encoders</em></a> pour attribuer des scores de pertinence sémantique plus complets entre les documents récupérés et la requête</li> <li><strong>La récupération multi-étapes :</strong> L’agent peut effectuer plusieurs recherches, en utilisant les résultats initiaux pour informer les requêtes suivantes</li> <li><strong>L’intégration de sources :</strong> Les informations peuvent être combinées à partir de plusieurs sources comme la recherche web et la documentation locale</li> <li><strong>La validation des résultats :</strong> Le contenu récupéré peut être analysé pour sa pertinence et son exactitude avant d’être inclus dans les réponses</li>',Ce,S,Pe="Les systèmes de RAG agentiques efficaces nécessitent une considération attentive de plusieurs aspects clés. L’agent <strong>devrait sélectionner entre les outils disponibles en fonction du type de requête et du contexte</strong>. Les systèmes de mémoire aident à maintenir l’historique de conversation et évitent les récupérations répétitives. Avoir des stratégies de secours garantit que le système peut toujours fournir de la valeur même lorsque les méthodes de récupération principales échouent. De plus, l’implémentation d’étapes de validation aide à assurer l’exactitude et la pertinence des informations récupérées.",Ge,H,fe,_,Ke='<li><a href="https://huggingface.co/learn/cookbook/agent_rag" rel="nofollow">Agentic RAG : boostez votre RAG avec la reformulation de requête et l’auto-requête ! 🚀</a> - Recette pour développer un système de RAG agentique en utilisant <code>smolagents</code>.</li>',Be,$,Ze,F,ge;return m=new ol({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/retrieval_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),j=new Ml({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new D({props:{title:"Construction de systèmes de RAG agentiques",local:"construction-de-systèmes-de-rag-agentiques",headingTag:"h1"}}),G=new D({props:{title:"Récupération de base avec DuckDuckGo",local:"récupération-de-base-avec-duckduckgo",headingTag:"h2"}}),g=new el({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGlzZXIlMjBsJ291dGlsJTIwZGUlMjByZWNoZXJjaGUlMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEElMEElMjMlMjBJbml0aWFsaXNlciUyMGxlJTIwbW9kJUMzJUE4bGUlMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSklMEElMEElMjMlMjBFeGVtcGxlJTIwZCd1dGlsaXNhdGlvbiUwQXJlc3BvbnNlJTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMlNlYXJjaCUyMGZvciUyMGx1eHVyeSUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGlkZWFzJTJDJTIwaW5jbHVkaW5nJTIwZGVjb3JhdGlvbnMlMkMlMjBlbnRlcnRhaW5tZW50JTJDJTIwYW5kJTIwY2F0ZXJpbmcuJTIyJTBBKSUwQXByaW50KHJlc3BvbnNlKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel

<span class="hljs-comment"># Initialiser l&#x27;outil de recherche</span>
search_tool = DuckDuckGoSearchTool()

<span class="hljs-comment"># Initialiser le modèle</span>
model = InferenceClientModel()

agent = CodeAgent(
    model=model,
    tools=[search_tool],
)

<span class="hljs-comment"># Exemple d&#x27;utilisation</span>
response = agent.run(
    <span class="hljs-string">&quot;Search for luxury superhero-themed party ideas, including decorations, entertainment, and catering.&quot;</span>
)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),Q=new D({props:{title:"Outil de base de connaissances personnalisé",local:"outil-de-base-de-connaissances-personnalisé",headingTag:"h2"}}),z=new el({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PartyPlanningRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;party_planning_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Utilise la recherche sémantique pour trouver des idées pertinentes pour l&#x27;organisation de la fête d&#x27;Alfred au Manoir Wayne sur le thème des super-héros.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;La requête à effectuer. Celle-ci doit être liée à l&#x27;organisation de fêtes ou à des thèmes de super-héros.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">5</span>  <span class="hljs-comment"># Récupérer les 5 meilleurs documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Votre requête doit être une chaîne de caractères&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nIdées récupérées :\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Idée <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Simuler une base de connaissances sur la planification de la fête</span>
party_ideas = [
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Un bal masqué sur le thème des super-héros avec un décor luxueux, notamment des accents dorés et des rideaux de velours.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de fête 1&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Engagez un DJ professionnel qui peut jouer de la musique sur le thème des super-héros comme Batman et Wonder Woman.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de divertissement&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Pour la restauration, servez des plats portant le nom de super-héros, comme &#x27;Le smoothie vert de Hulk&#x27; et &#x27;Le steak de puissance d&#x27;Iron Man&#x27;&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de traiteur&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Décorez le lieu avec des logos de super-héros emblématiques et des projections de Gotham et d&#x27;autres villes de super-héros.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de décoration&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Expériences interactives avec la VR où les invités peuvent participer à des simulations de super-héros ou à des jeux à thème.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Idées de divertissement&quot;</span>}
]

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> party_ideas
]

<span class="hljs-comment"># Découper les documents en morceaux plus petits pour une recherche plus efficace</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-comment"># Créer l&#x27;outil de récupération</span>
party_planning_retriever = PartyPlanningRetrieverTool(docs_processed)

<span class="hljs-comment"># Initialiser l&#x27;agent</span>
agent = CodeAgent(tools=[party_planning_retriever], model=InferenceClientModel())

<span class="hljs-comment"># Exemple d&#x27;utilisation</span>
response = agent.run(
    <span class="hljs-string">&quot;Trouver des idées pour une fête de luxe sur le thème des super-héros, y compris des options de divertissement, de restauration et de décoration.&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),W=new D({props:{title:"Capacités de récupération améliorées",local:"capacités-de-récupération-améliorées",headingTag:"h2"}}),H=new D({props:{title:"Ressources",local:"ressources",headingTag:"h2"}}),$=new ul({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/smolagents/retrieval_agents.mdx"}}),{c(){J=i("meta"),Y=n(),L=i("p"),P=n(),o(m.$$.fragment),K=n(),o(j.$$.fragment),O=n(),o(T.$$.fragment),ee=n(),U=i("blockquote"),U.innerHTML=Qe,le=n(),I=i("p"),I.innerHTML=qe,se=n(),w=i("p"),w.innerHTML=Ae,te=n(),h=i("p"),h.innerHTML=xe,ne=n(),b=i("p"),b.innerHTML=Xe,ae=n(),C=i("p"),C.textContent=ze,ie=n(),o(G.$$.fragment),re=n(),f=i("p"),f.textContent=Ee,Me=n(),B=i("ul"),B.innerHTML=Re,oe=n(),Z=i("p"),Z.textContent=We,ue=n(),o(g.$$.fragment),ce=n(),V=i("p"),V.textContent=ke,pe=n(),v=i("ol"),v.innerHTML=Ne,ye=n(),o(Q.$$.fragment),de=n(),q=i("p"),q.textContent=Se,Je=n(),A=i("p"),A.innerHTML=He,Ue=n(),x=i("p"),x.textContent=_e,me=n(),X=i("p"),X.innerHTML=$e,je=n(),o(z.$$.fragment),Te=n(),E=i("p"),E.textContent=Le,Ie=n(),R=i("ol"),R.innerHTML=Fe,we=n(),o(W.$$.fragment),he=n(),k=i("p"),k.textContent=De,be=n(),N=i("ol"),N.innerHTML=Ye,Ce=n(),S=i("p"),S.innerHTML=Pe,Ge=n(),o(H.$$.fragment),fe=n(),_=i("ul"),_.innerHTML=Ke,Be=n(),o($.$$.fragment),Ze=n(),F=i("p"),this.h()},l(e){const l=il("svelte-u9bgzb",document.head);J=r(l,"META",{name:!0,content:!0}),l.forEach(s),Y=a(e),L=r(e,"P",{}),Oe(L).forEach(s),P=a(e),u(m.$$.fragment,e),K=a(e),u(j.$$.fragment,e),O=a(e),u(T.$$.fragment,e),ee=a(e),U=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(U)!=="svelte-1cr93ez"&&(U.innerHTML=Qe),le=a(e),I=r(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1q55u1h"&&(I.innerHTML=qe),se=a(e),w=r(e,"P",{"data-svelte-h":!0}),M(w)!=="svelte-171s4ef"&&(w.innerHTML=Ae),te=a(e),h=r(e,"P",{"data-svelte-h":!0}),M(h)!=="svelte-174din4"&&(h.innerHTML=xe),ne=a(e),b=r(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-kpdqca"&&(b.innerHTML=Xe),ae=a(e),C=r(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1idy7jv"&&(C.textContent=ze),ie=a(e),u(G.$$.fragment,e),re=a(e),f=r(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1ehg1a0"&&(f.textContent=Ee),Me=a(e),B=r(e,"UL",{"data-svelte-h":!0}),M(B)!=="svelte-13jxt5y"&&(B.innerHTML=Re),oe=a(e),Z=r(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1xfi7ss"&&(Z.textContent=We),ue=a(e),u(g.$$.fragment,e),ce=a(e),V=r(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-12hlf7k"&&(V.textContent=ke),pe=a(e),v=r(e,"OL",{"data-svelte-h":!0}),M(v)!=="svelte-1n78adl"&&(v.innerHTML=Ne),ye=a(e),u(Q.$$.fragment,e),de=a(e),q=r(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1al822e"&&(q.textContent=Se),Je=a(e),A=r(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-e3o4wg"&&(A.innerHTML=He),Ue=a(e),x=r(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-19hmuww"&&(x.textContent=_e),me=a(e),X=r(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-cgpquh"&&(X.innerHTML=$e),je=a(e),u(z.$$.fragment,e),Te=a(e),E=r(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-ahpiz3"&&(E.textContent=Le),Ie=a(e),R=r(e,"OL",{"data-svelte-h":!0}),M(R)!=="svelte-5ii5zg"&&(R.innerHTML=Fe),we=a(e),u(W.$$.fragment,e),he=a(e),k=r(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-11bml2y"&&(k.textContent=De),be=a(e),N=r(e,"OL",{"data-svelte-h":!0}),M(N)!=="svelte-1bdyrer"&&(N.innerHTML=Ye),Ce=a(e),S=r(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-g1x8ux"&&(S.innerHTML=Pe),Ge=a(e),u(H.$$.fragment,e),fe=a(e),_=r(e,"UL",{"data-svelte-h":!0}),M(_)!=="svelte-ufdv41"&&(_.innerHTML=Ke),Be=a(e),u($.$$.fragment,e),Ze=a(e),F=r(e,"P",{}),Oe(F).forEach(s),this.h()},h(){Ve(J,"name","hf:doc:metadata"),Ve(J,"content",pl),Ve(U,"class","tip")},m(e,l){rl(document.head,J),t(e,Y,l),t(e,L,l),t(e,P,l),c(m,e,l),t(e,K,l),c(j,e,l),t(e,O,l),c(T,e,l),t(e,ee,l),t(e,U,l),t(e,le,l),t(e,I,l),t(e,se,l),t(e,w,l),t(e,te,l),t(e,h,l),t(e,ne,l),t(e,b,l),t(e,ae,l),t(e,C,l),t(e,ie,l),c(G,e,l),t(e,re,l),t(e,f,l),t(e,Me,l),t(e,B,l),t(e,oe,l),t(e,Z,l),t(e,ue,l),c(g,e,l),t(e,ce,l),t(e,V,l),t(e,pe,l),t(e,v,l),t(e,ye,l),c(Q,e,l),t(e,de,l),t(e,q,l),t(e,Je,l),t(e,A,l),t(e,Ue,l),t(e,x,l),t(e,me,l),t(e,X,l),t(e,je,l),c(z,e,l),t(e,Te,l),t(e,E,l),t(e,Ie,l),t(e,R,l),t(e,we,l),c(W,e,l),t(e,he,l),t(e,k,l),t(e,be,l),t(e,N,l),t(e,Ce,l),t(e,S,l),t(e,Ge,l),c(H,e,l),t(e,fe,l),t(e,_,l),t(e,Be,l),c($,e,l),t(e,Ze,l),t(e,F,l),ge=!0},p:sl,i(e){ge||(p(m.$$.fragment,e),p(j.$$.fragment,e),p(T.$$.fragment,e),p(G.$$.fragment,e),p(g.$$.fragment,e),p(Q.$$.fragment,e),p(z.$$.fragment,e),p(W.$$.fragment,e),p(H.$$.fragment,e),p($.$$.fragment,e),ge=!0)},o(e){y(m.$$.fragment,e),y(j.$$.fragment,e),y(T.$$.fragment,e),y(G.$$.fragment,e),y(g.$$.fragment,e),y(Q.$$.fragment,e),y(z.$$.fragment,e),y(W.$$.fragment,e),y(H.$$.fragment,e),y($.$$.fragment,e),ge=!1},d(e){e&&(s(Y),s(L),s(P),s(K),s(O),s(ee),s(U),s(le),s(I),s(se),s(w),s(te),s(h),s(ne),s(b),s(ae),s(C),s(ie),s(re),s(f),s(Me),s(B),s(oe),s(Z),s(ue),s(ce),s(V),s(pe),s(v),s(ye),s(de),s(q),s(Je),s(A),s(Ue),s(x),s(me),s(X),s(je),s(Te),s(E),s(Ie),s(R),s(we),s(he),s(k),s(be),s(N),s(Ce),s(S),s(Ge),s(fe),s(_),s(Be),s(Ze),s(F)),s(J),d(m,e),d(j,e),d(T,e),d(G,e),d(g,e),d(Q,e),d(z,e),d(W,e),d(H,e),d($,e)}}}const pl='{"title":"Construction de systèmes de RAG agentiques","local":"construction-de-systèmes-de-rag-agentiques","sections":[{"title":"Récupération de base avec DuckDuckGo","local":"récupération-de-base-avec-duckduckgo","sections":[],"depth":2},{"title":"Outil de base de connaissances personnalisé","local":"outil-de-base-de-connaissances-personnalisé","sections":[],"depth":2},{"title":"Capacités de récupération améliorées","local":"capacités-de-récupération-améliorées","sections":[],"depth":2},{"title":"Ressources","local":"ressources","sections":[],"depth":2}],"depth":1}';function yl(ve){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends nl{constructor(J){super(),al(this,J,yl,cl,ll,{})}}export{Il as component};
