# Bienvenue dans le cours 🤗 [[introduction]]

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/thumbnail.jpg" alt="Vignette du cours AI Agents" width="100%"/>
<figcaption>L'arrière-plan de l'image a été généré à l'aide de <a href="https://scenario.com/">Scenario.com</a>
</figcaption>
</figure>


Bienvenue dans le sujet le plus passionnant de l'IA aujourd'hui : les **Agents** !

Ce cours gratuit vous guidera, du **niveau débutant à expert**, pour comprendre, utiliser et construire des agents.

Cette première unité va vous aider à démarrer :

- Découvrez le **programme du cours**.
- **Choisissez le parcours** que vous souhaitez suivre (soit en autoformation, soit en suivant le processus de certification).
- **Obtenez plus d'informations sur le processus de certification**.
- Faites connaissance avec l'équipe derrière le cours.
- Créez votre **compte Hugging Face**.
- **Inscrivez-vous à notre serveur Discord** pour rencontrez vos camarades ainsi que nous.

Commençons !

## Que pouvez-vous attendre de ce cours ? [[expect]]

Dans ce cours, vous allez :

- 📖 Étudier les agents en IA par la **théorie, la conception et la pratique**.
- 🧑‍💻 Apprendre à **utiliser des bibliothèques établies** telles que [smolagents](https://huggingface.co/docs/smolagents/en/index), [LlamaIndex](https://www.llamaindex.ai/), et [LangGraph](https://langchain-ai.github.io/langgraph/).
- 💾 **Partager vos agents** sur le Hub d'Hugging Face et explorer les agents créés par la communauté.
- 🏆 Participer à des défis où vous **évaluerez vos agents face à ceux des autres étudiants**.
- 🎓 **Obtenir un certificat de réussite** en complétant les exercices.

Et bien plus encore !

À la fin de ce cours, vous comprendrez **comment fonctionnent les agents et comment construire les votres en utilisant les dernières bibliothèques et outils**.

N'oubliez pas de **<a href="https://bit.ly/hf-learn-agents">vous inscrire au cours !</a>**

(Nous respectons votre vie privée. Nous collectons votre adresse email afin de pouvoir **vous envoyer les liens dès que chaque unité est publiée et vous fournir des informations sur les challenges et les mises à jour**.)

## À quoi ressemble le cours ? [[course-look-like]]

Le cours structuré en :

- *Unités fondamentales* : où vous apprenez les **concepts théoriques des agents**.
- *Sessions pratiques* : où vous apprendrez **à utiliser des bibliothèques d'agents existantes** pour entraîner vos agents dans des environnements uniques. Ces sessions pratiques se feront dans des **Spaces** avec un environnement préconfiguré.
- *Exercices basés sur des cas d'utilisation* : où vous appliquerez les concepts appris pour résoudre un problème réel de votre choix.
- *Défis* : vous mettrez votre agent en compétition face à d'autres dans le cadre d'un *challenge*. Le tout sera suivi dans [un classement](https://huggingface.co/spaces/agents-course/Students_leaderboard) pour comparer les performances.

Ce **cours est un projet vivant, évoluant avec vos retours et contributions !** N'hésitez pas à [ouvrir des *issues* et des PR sur GitHub](https://github.com/huggingface/agents-course) et à participer aux discussions sur notre serveur Discord.

Après avoir suivi le cours, vous pouvez également nous envoyer vos retours [👉 via ce formulaire](https://docs.google.com/forms/d/e/1FAIpQLSe9VaONn0eglax0uTwi29rIn4tM7H2sYmmybmG5jJNlE5v0xA/viewform?usp=dialog).

## Quel est le programme ? [[syllabus]]

Voici le **programme général du cours**. Une liste plus détaillée des sujets sera publiée avec chaque unité.

| Chapitre | Sujet | Description |
| :---- | :---- | :---- |
| 0 | Intégration | Vous familiariser avec les outils et plateformes que vous utiliserez. |
| 1 | Fondamentaux | Expliquer les outils, le raisonnement, les actions, les observations et leurs formats. Aborder les LLM, les messages, les *tokens* spéciaux et les patrons de chat. Présenter un cas d'usage simple en utilisant des fonctions Python comme outils. |
| 2 | *Frameworks* | Comprendre comment les fondamentaux sont implémentés dans des bibliothèques populaires : smolagents, LangGraph et LlamaIndex |
| 3 | Cas d'utilisation | Construire quelques cas d'utilisation réels |
| 4 | Projet final | Construire un agent pour un *benchmark* sélectionné afin de démontrer votre compréhension des agents à travers le classement étudiant 🚀 |

En plus du programme principal, il y a 3 unités bonus :
- *Unité Bonus 1* : Finetuner un LLM pour l'appel de fonctions
- *Unité Bonus 2* : Observabilité et évaluation des agents
- *Unité Bonus 3* : Les agents dans les jeux vidéos via Pokemon

Par exemple, dans l'Unité Bonus 3, vous apprendrez à construire votre agent pour jouer aux combats Pokemon 🥊.

## Quels sont les prérequis ?

Pour pouvoir suivre ce cours, vous devez avoir :

- Une connaissance de base de Python
- Une connaissance de base des LLM (nous avons une section de rappel dans l'Unité 1)


## De quels outils ai-je besoin ? [[tools]]

Vous n'avez besoin que de 2 choses :

- Un *ordinateur* avec une connexion internet.
- Un *compte Hugging Face* pour pousser et charger des modèles, des agents, et créer des *Spaces*. Si vous n'avez pas encore de compte, vous pouvez en créer un **[ici](https://hf.co/join)** (c'est gratuit).

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/tools.jpg" alt="Outils nécessaires pour le cours" width="100%"/>

## Le processus de certification [[certification-process]]

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/three-paths.jpg" alt="Deux voies" width="100%"/>

Vous pouvez choisir de suivre ce cours en *mode auditeur libre* ou de réaliser les activités et *obtenir l'un des deux certificats que nous délivrerons*.

Si vous suivez le cours en auditeur libre, vous pouvez participer à tous les défis et faire les exercices si vous le souhaitez sans avoir **besoin de nous en informer**.

Le processus de certification est **entièrement gratuit** :

- *Pour obtenir une certification des fondamentaux* : vous devez compléter l'Unité 1 du cours. Cela est destiné aux étudiants qui souhaitent se tenir à jour avec les dernières tendances en matière d'agents.
- *Pour obtenir un certificat de réussite* : vous devez compléter l'Unité 1, l'un des exercices de cas d'utilisation que nous proposerons pendant le cours, ainsi que le défi final.

Il n'y a **pas de date limite** pour le processus de certification.

## Quel est le rythme recommandé ? [[recommended-pace]]

Chaque chapitre de ce cours est conçu **pour être complété en 1 semaine, avec environ 3 à 4 heures de travail par semaine**.

Nous vous proposons un rythme recommandé :

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/recommended-pace.jpg" alt="Rythme recommandé" width="100%"/>

## Comment tirer le meilleur parti du cours ? [[advice]]

Pour tirer le meilleur parti du cours, nous vous donnons quelques conseils :

1. <a href="https://discord.gg/UrrTSsSyjb">Rejoignez des groupes d'étude sur Discord</a> : étudier en groupe est toujours plus facile. Pour cela, vous devez rejoindre notre serveur Discord et vérifier votre compte Hugging Face.
2. **Faites les quiz et les exercices** : la meilleure façon d'apprendre est par la pratique et l'auto-évaluation.
3. **Définissez un planning pour rester en phase** : vous pouvez utiliser notre planning de rythme recommandé ci-dessous ou créer le vôtre.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/advice.jpg" alt="Conseils pour le cours" width="100%"/>

## Qui sommes-nous ? [[who-are-we]]

Ce cours est maintenu par [Ben Burtenshaw](https://huggingface.co/burtenshaw) et [Sergio Paniego](https://huggingface.co/sergiopaniego). Si vous avez des questions, contactez-nous sur le Hub !

## Remerciements

Nous tenons à exprimer notre gratitude aux personnes suivantes pour leurs contributions inestimables à ce cours :

- **[Joffrey Thomas](https://huggingface.co/Jofthomas)** - Pour la rédaction et le développement du cours.
- **[Thomas Simonini](https://huggingface.co/ThomasSimonini)** - Pour la rédaction et le développement du cours.
- **[Pedro Cuenca](https://huggingface.co/pcuenq)** - Pour avoir guidé le cours et fourni des *feedbacks*.
- **[Aymeric Roucher](https://huggingface.co/m-ric)** - Pour ses incroyables *Spaces* de démonstration (décodage et agent final) ainsi que son aide sur les parties sur smolagents.
- **[Joshua Lochner](https://huggingface.co/Xenova)** - Pour son incroyable *Space* de démonstration sur la tokenisation.
- **[Quentin Gallouédec](https://huggingface.co/qgallouedec)** - Pour son aide sur le contenu du cours.
- **[David Berenstein](https://huggingface.co/davidberenstein1957)** - Pour son aide sur le contenu du cours et la modération.
- **[XiaXiao (ShawnSiao)](https://huggingface.co/SSSSSSSiao)** - Traducteur de la version chinoise du cours.
- **[Jiaming Huang](https://huggingface.co/nordicsushi)** - Traducteur de la version chinoise du cours.
- **[Kim Noel](https://github.com/knoel99)** - Traducteur de la version française du cours.
- **[Loïck Bourdois](https://huggingface.co/lbourdois)** - Traducteur de la version française du cours via le [CATIE](https://www.catie.fr/).


## J'ai trouvé un bug, ou je souhaite améliorer le cours [[contribute]]

Les contributions sont **les bienvenues** 🤗

- Si vous *avez trouvé un bug 🐛 dans un notebook*, veuillez <a href="https://github.com/huggingface/agents-course/issues">ouvrir une *issue*</a> et **décrire le problème**.
- Si vous *souhaitez améliorer le cours*, vous pouvez <a href="https://github.com/huggingface/agents-course/pulls">ouvrir une *Pull Request*</a>.
- Si vous *voulez ajouter une section complète ou une nouvelle unité*, le mieux est d'ouvrir <a href="https://github.com/huggingface/agents-course/issues">une *issue*</a> et **décrire le contenu que vous souhaitez ajouter avant de commencer à l'écrire afin que nous puissions vous guider**.

## J'ai encore des questions [[questions]]

Veuillez poser vos questions sur notre <a href="https://discord.gg/UrrTSsSyjb">serveur Discord dans la section #agents-course-questions</a>.

Maintenant que vous avez toutes les informations, embarquons ⛵

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/time-to-onboard.jpg" alt="Il est temps de démarrer" width="100%"/>


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/fr/unit0/introduction.mdx" />