# 소개[[introduction]]

![Bonus Unit 1 Thumbnail](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit1/thumbnail.jpg)

첫 번째 **Bonus Unit**에 오신 것을 환영합니다. 여기에서 **함수 호출을 위한 대형 언어 모델(LLM)을 미세 조정하는 방법**을 배우게 됩니다.

대형 언어 모델(LLM)에서 함수 호출은 *필수 학습* 기술이 되어 가고 있습니다. 

여기서 핵심은 Unit 1에서 했던 것처럼 프롬프트 기반 접근 방식에만 의존하는 대신, 함수 호출을 통해 **학습 과정에서 직접 행동을 수행하고 관찰된 정보를 해석하도록** 모델을 훈련시켜 AI의 견고성을 높인다는 점입니다.

> **Bonus Unit을 언제 진행해야 하나요?**
>
> 이 섹션은 **선택 사항**이며 Unit 1보다 **심화된 내용**을 다루므로, 지금 바로 진행하거나 이 과정을 통해 지식이 더 쌓인 후에 다시 살펴보셔도 좋습니다.  
>  
> 하지만 걱정하지 마세요. 이 Bonus Unit은 필요한 모든 정보를 담고 있어, 미세 조정의 내부 작동 방식을 아직 배우지 않으셨더라도 함수 호출을 위한 핵심 개념을 하나하나 안내해 드립니다.

Bonus Unit을 가장 효과적으로 따라가려면:

1. 아직 Transformers로 대형 언어 모델(LLM)을 미세 조정하는 방법을 모른다면 [여기](https://huggingface.co/learn/nlp-course/chapter3/1?fw=pt)를 확인하세요. 

2. `SFTTrainer`를 사용하여 모델을 미세 조정하는 방법을 알고 싶다면 [공식 문서](https://huggingface.co/learn/nlp-course/en/chapter11/1)를 참조하세요. 

---

## 학습 내용[[what-you’ll-learn]]

1. **함수 호출**  
   최신 LLM이 대화를 구조화하여 **도구**를 호출할 수 있게 하는 방법을 배웁니다.

2. **LoRA (저차원 적응)**  
   계산 및 저장 오버헤드를 줄여주는 **경량화되고 효율적인** 미세 조정 방법입니다. LoRA는 대형 모델을 *더 빠르고 저렴하게 훈련하고, 쉽게 배포할 수 있게 합니다.*

3. 함수 호출 모델에서의 **사고 → 행동 → 관찰 사이클**  
   간단하지만 강력한 접근 방식으로, 모델이 언제(그리고 어떻게) 함수를 호출할지 결정하고, 중간 단계를 추적하며, 외부 도구나 API로부터 받은 결과를 해석하는 과정을 구조화합니다.

4. **새로운 특수 토큰**  
   모델이 다음 항목들을 구별할 수 있도록 특수한 마커를 도입합니다.
   - 내부 “사고 과정” 추론  
   - 함수 호출 요청  
   - 외부 도구로부터 돌아오는 응답

---

Bonus Unit을 마치면 다음을 할 수 있습니다.

- **도구** 관련 API의 내부 작동 방식을 **이해**합니다.  
- LoRA 기법을 사용하여 모델을 **미세 조정**합니다.  
- 사고 → 행동 → 관찰 사이클을 **구현**하고 **수정**하여 견고하고 유지보수 가능한 함수 호출 워크플로를 만듭니다.  
- 모델의 내부 추론과 외부 행동을 원활하게 구분할 수 있도록 **특수 토큰을 설계 및 활용**합니다.

그리고 **함수를 호출하기 위해 직접 모델을 미세 조정**하게 됩니다. 🔥

이제 **함수 호출**에 대해 본격적으로 살펴보겠습니다!


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ko/bonus-unit1/introduction.mdx" />