# 测验：评估 AI 智能体

让我们评估一下你对本附加单元中所涵盖的智能体追踪和评估概念的理解。

本次测验为可选，不计分。

### Q1: AI 智能体中的可观测性主要指的是什么？
哪个陈述准确地描述了 AI 智能体可观测性的目的？

<Question
choices={[
  {
    text: "它涉及通过日志、指标和跨度（spans）追踪内部操作，以理解智能体行为。",
    explain: "正确！可观测性意味着使用日志、指标和跨度来揭示智能体的内部运作。",
    correct: true
  },
  {
    text: "它仅仅专注于降低运行智能体的财务成本。",
    explain: "可观测性涵盖成本，但不限于此。"
  },
  {
    text: "它仅指智能体的外部外观和用户界面。",
    explain: "可观测性关注的是内部流程，而不是用户界面。"
  },
  {
    text: "它只关心编码风格和代码美学。",
    explain: "在此背景下，代码风格与可观测性无关。"
  }
]}
/>

### Q2: 以下哪项不是智能体可观测性中常见的监控指标？
选择通常不属于可观测性范畴的指标。

<Question
choices={[
  {
    text: "延迟",
    explain: "延迟通常被追踪以评估智能体的响应能力。"
  },
  {
    text: "每次智能体运行的成本",
    explain: "监控成本是可观测性的一个关键方面。"
  },
  {
    text: "用户反馈和评分",
    explain: "用户反馈对于评估智能体性能至关重要。"
  },
  {
    text: "智能体的代码行数",
    explain: "代码行数不是典型的可观测性指标。",
    correct: true
  }
]}
/>

### Q3: 什么最能描述 AI 智能体的离线评估？
确定正确离线评估本质的陈述。

<Question
choices={[
  {
    text: "在实时环境中使用真实用户交互来评估智能体。",
    explain: "这描述的是在线评估而非离线评估。"
  },
  {
    text: "使用包含已知基准（ground truth）的精选数据集来评估智能体性能。",
    explain: "正确！离线评估使用测试数据集来衡量相对于已知答案的性能。",
    correct: true
  },
  {
    text: "实时监控智能体的内部日志。",
    explain: "这更多地与可观测性相关，而非评估。"
  },
  {
    text: "在没有任何评估指标的情况下运行智能体。",
    explain: "这种方法无法提供有意义的见解。"
  }
]}
/>

### Q4: 智能体的在线评估提供了什么优势？
选择最能反映在线评估好处的陈述。

<Question
choices={[
  {
    text: "它使用预定义的数据集提供受控的测试场景。",
    explain: "受控测试是离线评估的好处，而非在线评估。"
  },
  {
    text: "它捕获实时的用户交互和真实世界的性能数据。",
    explain: "正确！在线评估通过在实时环境中监控智能体来提供见解。",
    correct: true
  },
  {
    text: "它消除了任何离线测试和基准测试的需要。",
    explain: "离线和在线评估都很重要且互为补充。"
  },
  {
    text: "它仅仅专注于降低智能体的计算成本。",
    explain: "成本监控是可观测性的一部分，并非在线评估的主要优势。"
  }
]}
/>

### Q5: OpenTelemetry 在 AI 智能体可观测性和评估中扮演什么角色？
哪个陈述最能描述 OpenTelemetry 在监控 AI 智能体中的作用？

<Question
choices={[
  {
    text: "它提供了一个标准化的框架来检测代码，从而能够收集用于可观测性的追踪、指标和日志。",
    explain: "正确！OpenTelemetry 标准化了遥测数据的检测，这对于监控和诊断智能体行为至关重要。",
    correct: true
  },
  {
    text: "它通过自动修复代码问题来替代手动调试。",
    explain: "错误。OpenTelemetry 用于收集遥测数据，而不是调试代码问题。"
  },
  {
    text: "它主要用作存储历史日志的数据库，不具备实时能力。",
    explain: "错误。OpenTelemetry 专注于实时遥测数据收集并将数据导出到分析工具。"
  },
  {
    text: "它通过自动调整模型参数来优化 AI 智能体的计算性能。",
    explain: "错误。OpenTelemetry 关注的是可观测性而非性能调优。"
  }
]}
/>

恭喜你完成本次测验！🎉 如果你答错了任何问题，可以考虑复习本附加单元的内容以加深理解。如果你做得很好，那么你已经准备好探索智能体可观测性和评估方面更高级的主题了！

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/bonus_unit2/quiz.mdx" />