# AI 智能体可观测性与评估

## 🔎 什么是可观测性？

可观测性是指通过查看日志、指标和追踪等外部信号来理解你的 AI 智能体内部正在发生什么。对于 AI 智能体而言，这意味着追踪行为、工具使用情况、模型调用和响应，以便调试和改进智能体性能。

![Observability dashboard](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png)

## 🔭 为何智能体可观测性如此重要

没有可观测性，AI 智能体就是“黑匣子”。可观测性工具使智能体变得透明，让你能够：

- 理解成本与准确性的权衡
- 测量延迟
- 检测有害语言和提示注入
- 监测用户反馈

换句话说，它使你的演示智能体为生产环境做好准备！

## 🔨 可观测性工具

常见的 AI 智能体可观测性工具包括像 [Langfuse](https://langfuse.com) 和 [Arize](https://www.arize.com) 这样的平台。这些工具有助于收集详细的追踪信息，并提供仪表板来实时监测指标，从而轻松检测问题并优化性能。

可观测性工具的功能和能力差异很大。有些工具是开源的，受益于庞大的社区，这些社区塑造了它们的路线图并提供了广泛的集成。此外，某些工具专注于 LLMOps 的特定方面——例如可观测性、评估或提示管理——而另一些工具则旨在覆盖整个 LLMOps 工作流程。我们鼓励你探索不同选项的文档，以选择一个适合你的解决方案。

许多智能体框架，例如 [smolagents](https://huggingface.co/docs/smolagents/v1.12.0/en/index)，使用 [OpenTelemetry](https://opentelemetry.io/docs/) 标准向可观测性工具公开元数据。除此之外，可观测性工具还会构建自定义的检测（instrumentations），以便在快速发展的 LLM 世界中提供更大的灵活性。你应该查阅你正在使用的工具的文档，以了解其支持的功能。

## 🔬追踪与跨度（Traces and Spans）

可观测性工具通常将智能体运行表示为追踪（traces）和跨度（spans）。

- **追踪（Traces）** 代表一个从开始到结束的完整智能体任务（例如处理用户查询）。
- **跨度（Spans）** 是追踪内的单个步骤（例如调用语言模型或检索数据）。

![Example of a smolagent trace in Langfuse](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png)

## 📊 需要监控的关键指标（Key Metrics to Monitor）

以下是可观测性工具监控的一些最常见的指标：

**延迟：** 智能体响应有多快？漫长的等待时间会对用户体验产生负面影响。你应该通过追踪智能体运行来测量任务和单个步骤的延迟。例如，一个所有模型调用需要 20 秒的智能体可以通过使用更快的模型或并行运行模型调用来加速。

**成本：** 每次智能体运行的费用是多少？AI 智能体依赖于按 token 计费的 LLM 调用或外部 API。频繁的工具使用或多个提示会迅速增加成本。例如，如果一个智能体为了边际的质量提升而调用 LLM 五次，你必须评估成本是否合理，或者是否可以减少调用次数或使用更便宜的模型。实时监控也有助于识别意外的峰值（例如，导致过度 API 循环的 bug）。

**请求错误：** 智能体失败了多少次请求？这可能包括 API 错误或工具调用失败。为了使你的智能体在生产环境中对这些情况更具鲁棒性，你可以设置回退（fallbacks）或重试。例如，如果 LLM 提供商 A宕机，你可以切换到 LLM 提供商 B 作为备用。

**用户反馈：** 实施直接的用户评估可以提供有价值的见解。这可以包括明确的评分（👍赞/👎踩，⭐1-5 星）或文本评论。持续的负面反馈应该引起你的警惕，因为这表明智能体没有按预期工作。

**隐式用户反馈：** 即使用户没有明确评分，他们的行为也能提供间接反馈。这可能包括立即改述问题、重复查询或点击重试按钮。例如，如果你看到用户反复问同一个问题，这表明智能体没有按预期工作。

**准确性：** 智能体产生正确或期望输出的频率如何？准确性的定义各不相同（例如，解决问题的正确性、信息检索的准确性、用户满意度）。第一步是为你的智能体定义成功的标准。你可以通过自动化检查、评估分数或任务完成标签来追踪准确性。例如，将追踪标记为“成功”或“失败”。

**自动化评估指标：** 你也可以设置自动化评估。例如，你可以使用一个 LLM 来对智能体的输出进行评分，例如判断它是否有用、准确与否。还有一些开源库可以帮助你对智能体的不同方面进行评分。例如，用于 RAG 智能体的 [RAGAS](https://docs.ragas.io/) 或用于检测有害语言或提示注入的 [LLM Guard](https://llm-guard.com/)。

在实践中，结合使用这些指标可以最好地覆盖 AI 智能体的健康状况。在本章的[示例 notebook](https://huggingface.co/learn/agents-course/en/bonus-unit2/monitoring-and-evaluating-agents-notebook) 中，我们将向你展示这些指标在实际示例中的样子，但首先，我们将了解典型的评估工作流程是怎样的。

## 👍 评估 AI 智能体

可观测性为我们提供了指标，但评估是分析这些数据（并执行测试）的过程，以确定 AI 智能体的表现如何以及如何改进它。换句话说，一旦你有了那些追踪和指标，你如何使用它们来评判智能体并做出决策？

定期评估很重要，因为 AI 智能体通常是非确定性的，并且会演变（通过更新或模型行为漂移）——没有评估，你就不知道你的“智能体”是否真的做得很好，或者是否出现了退化。

AI 智能体的评估有两类：**在线评估**和**离线评估**。两者都有价值，并且相辅相成。我们通常从离线评估开始，因为这是部署任何智能体之前的最低必要步骤。

### 🥷 离线评估（Offline Evaluation）

![Dataset items in Langfuse](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png)

这涉及在受控环境中评估智能体，通常使用测试数据集，而不是实时用户查询。你使用精心策划的数据集，在这些数据集中你知道预期的输出或正确的行为是什么，然后让你的智能体在这些数据集上运行。

例如，如果你构建了一个数学应用题智能体，你可能会有一个包含 100 个已知答案问题的[测试数据集](https://huggingface.co/datasets/gsm8k)。离线评估通常在开发期间进行（并且可以作为 CI/CD 管道的一部分），以检查改进或防止性能退化。其好处在于它是**可重复的，并且由于你有基准答案（ground truth），你可以获得清晰的准确性指标**。你也可以模拟用户查询，并根据理想答案衡量智能体的响应，或使用上面描述的自动化指标。

离线评估的关键挑战是确保你的测试数据集全面且保持相关性——智能体可能在固定的测试集上表现良好，但在生产环境中遇到截然不同的查询。因此，你应该用新的边缘案例和反映真实世界场景的示例来更新测试集。混合使用小型“冒烟测试”用例和大型评估集是很有用的：小型集用于快速检查，大型集用于更广泛的性能指标。

### 🔄 在线评估（Online Evaluation）

这是指在实时的、真实世界的环境中评估智能体，即在生产环境中的实际使用期间。在线评估涉及监控智能体在真实用户交互中的性能，并持续分析结果。

例如，你可能会追踪实时流量中的成功率、用户满意度分数或其他指标。在线评估的优势在于它**能捕捉到你在实验室环境中可能预料不到的情况**——你可以观察模型随时间的漂移（如果智能体的有效性随着输入模式的变化而下降），并捕捉到测试数据中没有的意外查询或情况。它提供了智能体在实际应用中行为的真实写照。

在线评估通常涉及收集隐式和显式用户反馈（如前所述），并可能运行影子测试或 A/B 测试（其中新版本的智能体与旧版本并行运行以进行比较）。挑战在于为实时交互获取可靠的标签或分数可能很棘手——你可能需要依赖用户反馈或下游指标（例如用户是否点击了结果）。

### 🤝 两者结合

在实践中，成功的 AI 智能体评估融合了**在线**和**离线**方法。你可能会定期运行离线基准测试，以量化评分你的智能体在定义任务上的表现，并持续监控实时使用情况，以捕捉基准测试遗漏的问题。例如，离线测试可以发现代码生成智能体在一组已知问题上的成功率是否在提高，而在线监控可能会提醒你用户开始提出智能体难以处理的新类别问题。结合两者可以提供更稳健的全局视图。

事实上，许多团队采用一个循环：_离线评估 → 部署新智能体版本 → 监控在线指标并收集新的失败示例 → 将这些示例添加到离线测试集 → 迭代_。通过这种方式，评估是持续且不断改进的。

## 🧑‍💻 让我们看看这在实践中是如何运作的

在下一节中，我们将看到如何使用可观测性工具来监测和评估我们的智能体的示例。

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/bonus_unit2/what-is-agent-observability-and-evaluation.mdx" />