# 智能体简介 (Introduction to Agents)
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/thumbnail.jpg" alt="Thumbnail"/>

欢迎来到第一单元，在这里**你将在 AI 智能体 (AI Agents) 的基础知识中建立坚实的基础**，包括：

* **理解智能体 (Understanding Agents)**
   * 什么是智能体，它是如何工作的？
   * 智能体如何使用推理 (Reasoning) 和规划 (Planning) 做出决策？

* **大型语言模型 (LLMs) 在智能体中的角色**
   * LLMs 如何作为智能体的"大脑"
   * LLMs 如何通过消息系统 (Message System) 构建对话

* **工具和行动 (Tools and Actions)**
   * 智能体如何使用外部工具与环境交互
   * 如何为你的智能体构建和集成工具

* **智能体工作流程 (Agent Workflow):**
   * *思考 (Think)* → *行动 (Act)* → *观察 (Observe)*

探索这些主题后，**你将使用 `smolagents` 构建你的第一个智能体**！

你的智能体名为 Alfred，将处理一个简单的任务，并展示如何在实践中应用这些概念。

你甚至会学习如何**在 Hugging Face Spaces 上发布你的智能体**，这样你就可以与朋友和同事分享它。

最后，在本单元结束时，你将参加一个测验。通过它，你将**获得你的第一个课程认证**：🎓 智能体基础证书 (Certificate of Fundamentals of Agents)。

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/certificate-example.jpg" alt="Certificate Example"/>

这个单元是你的**重要起点**，在进入更高级的主题之前，为理解智能体打下基础。

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-no-check.jpg" alt="Unit 1 planning"/>

这是一个大单元，所以**请慢慢来**，不要犹豫随时回来复习这些章节。

准备好了吗？让我们开始吧！🚀

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit1/introduction.mdx" />