import{s as Ae,n as Ge,o as He}from"../chunks/scheduler.7da89386.js";import{S as We,i as Qe,g as p,s as a,r as o,A as Xe,h as i,f as l,c as n,j as _e,u as r,x as h,k as Ze,y as Re,a as t,v as c,d as w,t as M,w as m}from"../chunks/index.20910acc.js";import{C as u}from"../chunks/CodeBlock.143bd81e.js";import{H as Te,E as Ye}from"../chunks/getInferenceSnippets.fc2ce523.js";function Ne(Je){let y,F,N,S,d,V,T,fe='The evaluator is designed to work with <code>transformer</code> pipelines out-of-the-box. However, in many cases you might have a model or pipeline that’s not part of the <code>transformer</code> ecosystem. You can still use <code>evaluator</code> to easily compute metrics for them. In this guide we show how to do this for a Scikit-Learn <a href="https://scikit-learn.org/stable/modules/generated/sklearn.pipeline.Pipeline.html#sklearn.pipeline.Pipeline" rel="nofollow">pipeline</a> and a Spacy <a href="https://spacy.io" rel="nofollow">pipeline</a>. Let’s start with the Scikit-Learn case.',q,J,E,f,je='First we need to train a model. We’ll train a simple text classifier on the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">IMDb dataset</a>, so let’s start by downloading the dataset:',L,j,P,b,be="Then we can build a simple TF-IDF preprocessor and Naive Bayes classifier wrapped in a <code>Pipeline</code>:",K,U,D,I,Ue="Following the convention in the <code>TextClassificationPipeline</code> of <code>transformers</code> our pipeline should be callable and return a list of dictionaries. In addition we use the <code>task</code> attribute to check if the pipeline is compatible with the <code>evaluator</code>. We can write a small wrapper class for that purpose:",O,$,ee,x,Ie="We can now pass this <code>pipeline</code> to the <code>evaluator</code>:",se,C,le,k,$e="Implementing that simple wrapper is all that’s needed to use any model from any framework with the <code>evaluator</code>. In the <code>__call__</code> you can implement all logic necessary for efficient forward passes through your model.",te,B,ae,g,xe="We’ll use the <code>polarity</code> feature of the <code>spacytextblob</code> project to get a simple sentiment analyzer. First you’ll need to install the project and download the resources:",ne,v,pe,_,Ce="Then we can simply load the <code>nlp</code> pipeline and add the <code>spacytextblob</code> pipeline:",ie,Z,oe,A,ke="This snippet shows how we can use the <code>polarity</code> feature added with <code>spacytextblob</code> to get the sentiment of a text:",re,G,ce,H,Be="Now we can wrap it in a simple wrapper class like in the Scikit-Learn example before. It just has to return a list of dictionaries with the predicted lables. If the polarity is larger than 0 we’ll predict positive sentiment and negative otherwise:",we,W,Me,Q,ge="That class is compatible with the <code>evaluator</code> and we can use the same instance from the previous examlpe along with the IMDb test set:",me,X,he,R,ve="This will take a little longer than the Scikit-Learn example but after roughly 10-15min you will have the evaluation results!",ye,Y,ue,z,de;return d=new Te({props:{title:"Using the evaluator with custom pipelines",local:"using-the-evaluator-with-custom-pipelines",headingTag:"h1"}}),J=new Te({props:{title:"Scikit-Learn",local:"scikit-learn",headingTag:"h2"}}),j=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>)`,wrap:!1}}),U=new u({props:{code:"ZnJvbSUyMHNrbGVhcm4ucGlwZWxpbmUlMjBpbXBvcnQlMjBQaXBlbGluZSUwQWZyb20lMjBza2xlYXJuLm5haXZlX2JheWVzJTIwaW1wb3J0JTIwTXVsdGlub21pYWxOQiUwQWZyb20lMjBza2xlYXJuLmZlYXR1cmVfZXh0cmFjdGlvbi50ZXh0JTIwaW1wb3J0JTIwVGZpZGZUcmFuc2Zvcm1lciUwQWZyb20lMjBza2xlYXJuLmZlYXR1cmVfZXh0cmFjdGlvbi50ZXh0JTIwaW1wb3J0JTIwQ291bnRWZWN0b3JpemVyJTBBJTBBdGV4dF9jbGYlMjAlM0QlMjBQaXBlbGluZSglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ3ZlY3QnJTJDJTIwQ291bnRWZWN0b3JpemVyKCkpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCd0ZmlkZiclMkMlMjBUZmlkZlRyYW5zZm9ybWVyKCkpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCdjbGYnJTJDJTIwTXVsdGlub21pYWxOQigpKSUyQyUwQSU1RCklMEElMEF0ZXh0X2NsZi5maXQoZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QiUyMnRleHQlMjIlNUQlMkMlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTVCJTIybGFiZWwlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> sklearn.pipeline <span class="hljs-keyword">import</span> Pipeline
<span class="hljs-keyword">from</span> sklearn.naive_bayes <span class="hljs-keyword">import</span> MultinomialNB
<span class="hljs-keyword">from</span> sklearn.feature_extraction.text <span class="hljs-keyword">import</span> TfidfTransformer
<span class="hljs-keyword">from</span> sklearn.feature_extraction.text <span class="hljs-keyword">import</span> CountVectorizer

text_clf = Pipeline([
        (<span class="hljs-string">&#x27;vect&#x27;</span>, CountVectorizer()),
        (<span class="hljs-string">&#x27;tfidf&#x27;</span>, TfidfTransformer()),
        (<span class="hljs-string">&#x27;clf&#x27;</span>, MultinomialNB()),
])

text_clf.fit(ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-string">&quot;text&quot;</span>], ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),$=new u({props:{code:"Y2xhc3MlMjBTY2lraXRFdmFsUGlwZWxpbmUlM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwcGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5waXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi50YXNrJTIwJTNEJTIwJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBpbnB1dF90ZXh0cyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QiU3QiUyMmxhYmVsJTIyJTNBJTIwcCU3RCUyMGZvciUyMHAlMjBpbiUyMHNlbGYucGlwZWxpbmUucHJlZGljdChpbnB1dF90ZXh0cyklNUQlMEElMEFwaXBlJTIwJTNEJTIwU2Npa2l0RXZhbFBpcGVsaW5lKHRleHRfY2xmKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ScikitEvalPipeline</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, pipeline</span>):
        self.pipeline = pipeline
        self.task = <span class="hljs-string">&quot;text-classification&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, input_texts, **kwargs</span>):
        <span class="hljs-keyword">return</span> [{<span class="hljs-string">&quot;label&quot;</span>: p} <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> self.pipeline.predict(input_texts)]

pipe = ScikitEvalPipeline(text_clf)`,wrap:!1}}),C=new u({props:{code:"JTBBJTBBJTdCJ2FjY3VyYWN5JyUzQSUyMDAuODI5NTYlN0Q=",highlighted:`<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> evaluator

task_evaluator = evaluator(<span class="hljs-string">&quot;text-classification&quot;</span>)
task_evaluator.compute(pipe, ds[<span class="hljs-string">&quot;test&quot;</span>], <span class="hljs-string">&quot;accuracy&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.82956</span>}`,wrap:!1}}),B=new Te({props:{title:"Spacy",local:"spacy",headingTag:"h2"}}),v=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNwYWN5dGV4dGJsb2IlMEFweXRob24lMjAtbSUyMHRleHRibG9iLmRvd25sb2FkX2NvcnBvcmElMEFweXRob24lMjAtbSUyMHNwYWN5JTIwZG93bmxvYWQlMjBlbl9jb3JlX3dlYl9zbQ==",highlighted:`pip install spacytextblob
python -m textblob.download_corpora
python -m spacy download en_core_web_sm`,wrap:!1}}),Z=new u({props:{code:"aW1wb3J0JTIwc3BhY3klMEElMEFubHAlMjAlM0QlMjBzcGFjeS5sb2FkKCdlbl9jb3JlX3dlYl9zbScpJTBBbmxwLmFkZF9waXBlKCdzcGFjeXRleHRibG9iJyk=",highlighted:`<span class="hljs-keyword">import</span> spacy

nlp = spacy.load(<span class="hljs-string">&#x27;en_core_web_sm&#x27;</span>)
nlp.add_pipe(<span class="hljs-string">&#x27;spacytextblob&#x27;</span>)`,wrap:!1}}),G=new u({props:{code:"dGV4dHMlMjAlM0QlMjAlNUIlMjJUaGlzJTIwbW92aWUlMjBpcyUyMGhvcnJpYmxlJTIyJTJDJTIwJTIyVGhpcyUyMG1vdmllJTIwaXMlMjBhd2Vzb21lJTIyJTVEJTBBcmVzdWx0cyUyMCUzRCUyMG5scC5waXBlKHRleHRzKSUwQSUwQWZvciUyMHR4dCUyQyUyMHJlcyUyMGluJTIwemlwKHRleHRzJTJDJTIwcmVzdWx0cyklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCdGV4dCU3RCUyMCU3QyUyMFBvbGFyaXR5JTNBJTIwJTdCcmVzLl8uYmxvYi5wb2xhcml0eSU3RCUyMik=",highlighted:`texts = [<span class="hljs-string">&quot;This movie is horrible&quot;</span>, <span class="hljs-string">&quot;This movie is awesome&quot;</span>]
results = nlp.pipe(texts)

<span class="hljs-keyword">for</span> txt, res <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(texts, results):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{text}</span> | Polarity: <span class="hljs-subst">{res._.blob.polarity}</span>&quot;</span>)`,wrap:!1}}),W=new u({props:{code:"Y2xhc3MlMjBTcGFjeUV2YWxQaXBlbGluZSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBubHApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5ubHAlMjAlM0QlMjBubHAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnRhc2slMjAlM0QlMjAlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGlucHV0X3RleHRzJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCU1QiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHAlMjBpbiUyMHNlbGYubmxwLnBpcGUoaW5wdXRfdGV4dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBwLl8uYmxvYi5wb2xhcml0eSUzRSUzRDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHRzLmFwcGVuZCglN0IlMjJsYWJlbCUyMiUzQSUyMDElN0QpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VsdHMuYXBwZW5kKCU3QiUyMmxhYmVsJTIyJTNBJTIwMCU3RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHRzJTBBJTBBcGlwZSUyMCUzRCUyMFNwYWN5RXZhbFBpcGVsaW5lKG5scCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SpacyEvalPipeline</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, nlp</span>):
        self.nlp = nlp
        self.task = <span class="hljs-string">&quot;text-classification&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, input_texts, **kwargs</span>):
        results =[]
        <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> self.nlp.pipe(input_texts):
            <span class="hljs-keyword">if</span> p._.blob.polarity&gt;=<span class="hljs-number">0</span>:
                results.append({<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-number">1</span>})
            <span class="hljs-keyword">else</span>:
                results.append({<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-number">0</span>})
        <span class="hljs-keyword">return</span> results

pipe = SpacyEvalPipeline(nlp)`,wrap:!1}}),X=new u({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjkxNCU3RA==",highlighted:`<span class="hljs-built_in">eval</span>.compute(pipe, ds[<span class="hljs-string">&quot;test&quot;</span>], <span class="hljs-string">&quot;accuracy&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.6914</span>}`,wrap:!1}}),Y=new Ye({props:{source:"https://github.com/huggingface/evaluate/blob/main/docs/source/custom_evaluator.mdx"}}),{c(){y=p("meta"),F=a(),N=p("p"),S=a(),o(d.$$.fragment),V=a(),T=p("p"),T.innerHTML=fe,q=a(),o(J.$$.fragment),E=a(),f=p("p"),f.innerHTML=je,L=a(),o(j.$$.fragment),P=a(),b=p("p"),b.innerHTML=be,K=a(),o(U.$$.fragment),D=a(),I=p("p"),I.innerHTML=Ue,O=a(),o($.$$.fragment),ee=a(),x=p("p"),x.innerHTML=Ie,se=a(),o(C.$$.fragment),le=a(),k=p("p"),k.innerHTML=$e,te=a(),o(B.$$.fragment),ae=a(),g=p("p"),g.innerHTML=xe,ne=a(),o(v.$$.fragment),pe=a(),_=p("p"),_.innerHTML=Ce,ie=a(),o(Z.$$.fragment),oe=a(),A=p("p"),A.innerHTML=ke,re=a(),o(G.$$.fragment),ce=a(),H=p("p"),H.textContent=Be,we=a(),o(W.$$.fragment),Me=a(),Q=p("p"),Q.innerHTML=ge,me=a(),o(X.$$.fragment),he=a(),R=p("p"),R.textContent=ve,ye=a(),o(Y.$$.fragment),ue=a(),z=p("p"),this.h()},l(e){const s=Xe("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(l),F=n(e),N=i(e,"P",{}),_e(N).forEach(l),S=n(e),r(d.$$.fragment,e),V=n(e),T=i(e,"P",{"data-svelte-h":!0}),h(T)!=="svelte-186h53x"&&(T.innerHTML=fe),q=n(e),r(J.$$.fragment,e),E=n(e),f=i(e,"P",{"data-svelte-h":!0}),h(f)!=="svelte-1lrcj9x"&&(f.innerHTML=je),L=n(e),r(j.$$.fragment,e),P=n(e),b=i(e,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1ufqsq"&&(b.innerHTML=be),K=n(e),r(U.$$.fragment,e),D=n(e),I=i(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-dxo869"&&(I.innerHTML=Ue),O=n(e),r($.$$.fragment,e),ee=n(e),x=i(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-13cidte"&&(x.innerHTML=Ie),se=n(e),r(C.$$.fragment,e),le=n(e),k=i(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-hq9iw6"&&(k.innerHTML=$e),te=n(e),r(B.$$.fragment,e),ae=n(e),g=i(e,"P",{"data-svelte-h":!0}),h(g)!=="svelte-7vu00g"&&(g.innerHTML=xe),ne=n(e),r(v.$$.fragment,e),pe=n(e),_=i(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-xlpb51"&&(_.innerHTML=Ce),ie=n(e),r(Z.$$.fragment,e),oe=n(e),A=i(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1k5k8id"&&(A.innerHTML=ke),re=n(e),r(G.$$.fragment,e),ce=n(e),H=i(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-y497q6"&&(H.textContent=Be),we=n(e),r(W.$$.fragment,e),Me=n(e),Q=i(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-148sz56"&&(Q.innerHTML=ge),me=n(e),r(X.$$.fragment,e),he=n(e),R=i(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-86ij1b"&&(R.textContent=ve),ye=n(e),r(Y.$$.fragment,e),ue=n(e),z=i(e,"P",{}),_e(z).forEach(l),this.h()},h(){Ze(y,"name","hf:doc:metadata"),Ze(y,"content",ze)},m(e,s){Re(document.head,y),t(e,F,s),t(e,N,s),t(e,S,s),c(d,e,s),t(e,V,s),t(e,T,s),t(e,q,s),c(J,e,s),t(e,E,s),t(e,f,s),t(e,L,s),c(j,e,s),t(e,P,s),t(e,b,s),t(e,K,s),c(U,e,s),t(e,D,s),t(e,I,s),t(e,O,s),c($,e,s),t(e,ee,s),t(e,x,s),t(e,se,s),c(C,e,s),t(e,le,s),t(e,k,s),t(e,te,s),c(B,e,s),t(e,ae,s),t(e,g,s),t(e,ne,s),c(v,e,s),t(e,pe,s),t(e,_,s),t(e,ie,s),c(Z,e,s),t(e,oe,s),t(e,A,s),t(e,re,s),c(G,e,s),t(e,ce,s),t(e,H,s),t(e,we,s),c(W,e,s),t(e,Me,s),t(e,Q,s),t(e,me,s),c(X,e,s),t(e,he,s),t(e,R,s),t(e,ye,s),c(Y,e,s),t(e,ue,s),t(e,z,s),de=!0},p:Ge,i(e){de||(w(d.$$.fragment,e),w(J.$$.fragment,e),w(j.$$.fragment,e),w(U.$$.fragment,e),w($.$$.fragment,e),w(C.$$.fragment,e),w(B.$$.fragment,e),w(v.$$.fragment,e),w(Z.$$.fragment,e),w(G.$$.fragment,e),w(W.$$.fragment,e),w(X.$$.fragment,e),w(Y.$$.fragment,e),de=!0)},o(e){M(d.$$.fragment,e),M(J.$$.fragment,e),M(j.$$.fragment,e),M(U.$$.fragment,e),M($.$$.fragment,e),M(C.$$.fragment,e),M(B.$$.fragment,e),M(v.$$.fragment,e),M(Z.$$.fragment,e),M(G.$$.fragment,e),M(W.$$.fragment,e),M(X.$$.fragment,e),M(Y.$$.fragment,e),de=!1},d(e){e&&(l(F),l(N),l(S),l(V),l(T),l(q),l(E),l(f),l(L),l(P),l(b),l(K),l(D),l(I),l(O),l(ee),l(x),l(se),l(le),l(k),l(te),l(ae),l(g),l(ne),l(pe),l(_),l(ie),l(oe),l(A),l(re),l(ce),l(H),l(we),l(Me),l(Q),l(me),l(he),l(R),l(ye),l(ue),l(z)),l(y),m(d,e),m(J,e),m(j,e),m(U,e),m($,e),m(C,e),m(B,e),m(v,e),m(Z,e),m(G,e),m(W,e),m(X,e),m(Y,e)}}}const ze='{"title":"Using the evaluator with custom pipelines","local":"using-the-evaluator-with-custom-pipelines","sections":[{"title":"Scikit-Learn","local":"scikit-learn","sections":[],"depth":2},{"title":"Spacy","local":"spacy","sections":[],"depth":2}],"depth":1}';function Fe(Je){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends We{constructor(y){super(),Qe(this,y,Fe,Ne,Ae,{})}}export{Le as component};
