import{s as Ns,n as Cs,o as Vs}from"../chunks/scheduler.6062bdaf.js";import{S as Qs,i as Ls,g as p,s as l,r as c,A as As,h as i,f as e,c as n,j as q,u as m,x as o,k as zs,y as r,a,v as h,d as g,t as d,w as y}from"../chunks/index.4bca734e.js";import{C as Q}from"../chunks/CodeBlock.fa01571c.js";import{H as bs,E as Ps}from"../chunks/EditOnGithub.74ab2baa.js";function Ds(Gs){let u,P,L,D,M,K,J,_s='In addition to the <a href="/docs/huggingface_hub/v0.23.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>, the <code>huggingface_hub</code> library provides <a href="/docs/huggingface_hub/v0.23.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>, a pythonic <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-compatible</a> file interface to the Hugging Face Hub. The <a href="/docs/huggingface_hub/v0.23.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> builds of top of the <a href="/docs/huggingface_hub/v0.23.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> and offers typical filesystem style operations like <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, and <code>put_file</code>.',O,w,ss,j,ts,T,Rs="The optional <code>revision</code> argument can be passed to run an operation from a specific commit such as a branch, tag name, or a commit hash.",es,b,vs="Unlike Python’s built-in <code>open</code>, <code>fsspec</code>’s <code>open</code> defaults to binary mode, <code>&quot;rb&quot;</code>. This means you must explicitly set mode as <code>&quot;r&quot;</code> for reading and <code>&quot;w&quot;</code> for writing in text mode. Appending to a file (modes <code>&quot;a&quot;</code> and <code>&quot;ab&quot;</code>) is not supported yet.",as,U,ls,Z,Xs='The <a href="/docs/huggingface_hub/v0.23.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> can be used with any library that integrates <code>fsspec</code>, provided the URL follows the scheme:',ns,k,ps,I,$s="The <code>repo_type_prefix</code> is <code>datasets/</code> for datasets, <code>spaces/</code> for spaces, and models don’t need a prefix in the URL.",is,G,Bs='Some interesting integrations where <a href="/docs/huggingface_hub/v0.23.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> simplifies interacting with the Hub are listed below:',os,z,_,N,Ss='Reading/writing a <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame from/to a Hub repository:',Us,R,cs,v,Fs='The same workflow can also be used for <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> and <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrames.',ms,f,X,C,Ws='Querying (remote) Hub files with <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',Zs,$,ks,B,V,Hs='Using the Hub as an array store with <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',Is,S,rs,F,hs,W,Ys='In many cases, you must be logged in with a Hugging Face account to interact with the Hub. Refer to the <a href="../quick-start#authentication">Authentication</a> section of the documentation to learn more about authentication methods on the Hub.',gs,H,Es='It is also possible to login programmatically by passing your <code>token</code> as an argument to <a href="/docs/huggingface_hub/v0.23.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>:',ds,Y,ys,E,xs="If you login this way, be careful not to accidentally leak the token when sharing your source code!",us,x,fs,A,Ms;return M=new bs({props:{title:"Interact with the Hub through the Filesystem API",local:"interact-with-the-hub-through-the-filesystem-api",headingTag:"h1"}}),w=new bs({props:{title:"Usage",local:"usage",headingTag:"h2"}}),j=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBMaXN0JTIwYWxsJTIwZmlsZXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMExpc3QlMjBhbGwlMjAlMjIuY3N2JTIyJTIwZmlsZXMlMjBpbiUyMGElMjByZXBvJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiouY3N2JTIyKSUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwZmlsZSUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdHJhaW4uY3N2JTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhJTIwJTNEJTIwZi5yZWFkbGluZXMoKSUwQSUwQSUyMyUyMFJlYWQlMjB0aGUlMjBjb250ZW50JTIwb2YlMjBhJTIwcmVtb3RlJTIwZmlsZSUyMGFzJTIwYSUyMHN0cmluZyUwQXRyYWluX2RhdGElMjAlM0QlMjBmcy5yZWFkX3RleHQoJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjByZXZpc2lvbiUzRCUyMmRldiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGElMjByZW1vdGUlMjBmaWxlJTBBd2l0aCUyMGZzLm9wZW4oJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ2YWxpZGF0aW9uLmNzdiUyMiUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJ0ZXh0JTJDbGFiZWwlMjIpJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJGYW50YXN0aWMlMjBtb3ZpZSElMkNnb29kJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all files in a directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all &quot;.csv&quot; files in a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read the content of a remote file as a string</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),U=new bs({props:{title:"Integrations",local:"integrations",headingTag:"h2"}}),k=new Q({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;',wrap:!1}}),R=new Q({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUyMGludG8lMjBhJTIwZGF0YWZyYW1lJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0cmFpbi5jc3YlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwZGF0YWZyYW1lJTIwdG8lMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote CSV file into a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a dataframe to a remote CSV file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),$=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBRdWVyeSUyMGElMjByZW1vdGUlMjBmaWxlJTIwYW5kJTIwZ2V0JTIwdGhlJTIwcmVzdWx0JTIwYmFjayUyMGFzJTIwYSUyMGRhdGFmcmFtZSUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Query a remote file and get the result back as a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),S=new Q({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGFuJTIwYXJyYXklMjB0byUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnclMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZm9vJTIwJTNEJTIwcm9vdC5jcmVhdGVfZ3JvdXAoJTIyZW1iZWRkaW5ncyUyMiklMEElMjAlMjAlMjBmb29iYXIlMjAlM0QlMjBmb28uemVyb3MoJ2V4cGVyaW1lbnRfMCclMkMlMjBzaGFwZSUzRCg1MDAwMCUyQyUyMDEwMDApJTJDJTIwY2h1bmtzJTNEKDEwMDAwJTJDJTIwMTAwMCklMkMlMjBkdHlwZSUzRCdmNCcpJTBBJTIwJTIwJTIwZm9vYmFyJTVCJTNBJTVEJTIwJTNEJTIwZW1iZWRkaW5ncyUwQSUwQSUyMyUyMFJlYWQlMjBhbiUyMGFycmF5JTIwZnJvbSUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write an array to a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read an array from a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),F=new bs({props:{title:"Authentication",local:"authentication",headingTag:"h2"}}),Y=new Q({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),x=new Ps({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/hf_file_system.md"}}),{c(){u=p("meta"),P=l(),L=p("p"),D=l(),c(M.$$.fragment),K=l(),J=p("p"),J.innerHTML=_s,O=l(),c(w.$$.fragment),ss=l(),c(j.$$.fragment),ts=l(),T=p("p"),T.innerHTML=Rs,es=l(),b=p("p"),b.innerHTML=vs,as=l(),c(U.$$.fragment),ls=l(),Z=p("p"),Z.innerHTML=Xs,ns=l(),c(k.$$.fragment),ps=l(),I=p("p"),I.innerHTML=$s,is=l(),G=p("p"),G.innerHTML=Bs,os=l(),z=p("ul"),_=p("li"),N=p("p"),N.innerHTML=Ss,Us=l(),c(R.$$.fragment),cs=l(),v=p("p"),v.innerHTML=Fs,ms=l(),f=p("ul"),X=p("li"),C=p("p"),C.innerHTML=Ws,Zs=l(),c($.$$.fragment),ks=l(),B=p("li"),V=p("p"),V.innerHTML=Hs,Is=l(),c(S.$$.fragment),rs=l(),c(F.$$.fragment),hs=l(),W=p("p"),W.innerHTML=Ys,gs=l(),H=p("p"),H.innerHTML=Es,ds=l(),c(Y.$$.fragment),ys=l(),E=p("p"),E.textContent=xs,us=l(),c(x.$$.fragment),fs=l(),A=p("p"),this.h()},l(s){const t=As("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(e),P=n(s),L=i(s,"P",{}),q(L).forEach(e),D=n(s),m(M.$$.fragment,s),K=n(s),J=i(s,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1t6znzg"&&(J.innerHTML=_s),O=n(s),m(w.$$.fragment,s),ss=n(s),m(j.$$.fragment,s),ts=n(s),T=i(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-fkc5g9"&&(T.innerHTML=Rs),es=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-2xrojz"&&(b.innerHTML=vs),as=n(s),m(U.$$.fragment,s),ls=n(s),Z=i(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1aorpb"&&(Z.innerHTML=Xs),ns=n(s),m(k.$$.fragment,s),ps=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1x0g0bv"&&(I.innerHTML=$s),is=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1f4o4hf"&&(G.innerHTML=Bs),os=n(s),z=i(s,"UL",{});var qs=q(z);_=i(qs,"LI",{});var Js=q(_);N=i(Js,"P",{"data-svelte-h":!0}),o(N)!=="svelte-8bmxp4"&&(N.innerHTML=Ss),Us=n(Js),m(R.$$.fragment,Js),Js.forEach(e),qs.forEach(e),cs=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-evo4u9"&&(v.innerHTML=Fs),ms=n(s),f=i(s,"UL",{});var ws=q(f);X=i(ws,"LI",{});var js=q(X);C=i(js,"P",{"data-svelte-h":!0}),o(C)!=="svelte-14x5nlf"&&(C.innerHTML=Ws),Zs=n(js),m($.$$.fragment,js),js.forEach(e),ks=n(ws),B=i(ws,"LI",{});var Ts=q(B);V=i(Ts,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1abwu1e"&&(V.innerHTML=Hs),Is=n(Ts),m(S.$$.fragment,Ts),Ts.forEach(e),ws.forEach(e),rs=n(s),m(F.$$.fragment,s),hs=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-kwqcxw"&&(W.innerHTML=Ys),gs=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-aachfb"&&(H.innerHTML=Es),ds=n(s),m(Y.$$.fragment,s),ys=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-y88ov3"&&(E.textContent=xs),us=n(s),m(x.$$.fragment,s),fs=n(s),A=i(s,"P",{}),q(A).forEach(e),this.h()},h(){zs(u,"name","hf:doc:metadata"),zs(u,"content",Ks)},m(s,t){r(document.head,u),a(s,P,t),a(s,L,t),a(s,D,t),h(M,s,t),a(s,K,t),a(s,J,t),a(s,O,t),h(w,s,t),a(s,ss,t),h(j,s,t),a(s,ts,t),a(s,T,t),a(s,es,t),a(s,b,t),a(s,as,t),h(U,s,t),a(s,ls,t),a(s,Z,t),a(s,ns,t),h(k,s,t),a(s,ps,t),a(s,I,t),a(s,is,t),a(s,G,t),a(s,os,t),a(s,z,t),r(z,_),r(_,N),r(_,Us),h(R,_,null),a(s,cs,t),a(s,v,t),a(s,ms,t),a(s,f,t),r(f,X),r(X,C),r(X,Zs),h($,X,null),r(f,ks),r(f,B),r(B,V),r(B,Is),h(S,B,null),a(s,rs,t),h(F,s,t),a(s,hs,t),a(s,W,t),a(s,gs,t),a(s,H,t),a(s,ds,t),h(Y,s,t),a(s,ys,t),a(s,E,t),a(s,us,t),h(x,s,t),a(s,fs,t),a(s,A,t),Ms=!0},p:Cs,i(s){Ms||(g(M.$$.fragment,s),g(w.$$.fragment,s),g(j.$$.fragment,s),g(U.$$.fragment,s),g(k.$$.fragment,s),g(R.$$.fragment,s),g($.$$.fragment,s),g(S.$$.fragment,s),g(F.$$.fragment,s),g(Y.$$.fragment,s),g(x.$$.fragment,s),Ms=!0)},o(s){d(M.$$.fragment,s),d(w.$$.fragment,s),d(j.$$.fragment,s),d(U.$$.fragment,s),d(k.$$.fragment,s),d(R.$$.fragment,s),d($.$$.fragment,s),d(S.$$.fragment,s),d(F.$$.fragment,s),d(Y.$$.fragment,s),d(x.$$.fragment,s),Ms=!1},d(s){s&&(e(P),e(L),e(D),e(K),e(J),e(O),e(ss),e(ts),e(T),e(es),e(b),e(as),e(ls),e(Z),e(ns),e(ps),e(I),e(is),e(G),e(os),e(z),e(cs),e(v),e(ms),e(f),e(rs),e(hs),e(W),e(gs),e(H),e(ds),e(ys),e(E),e(us),e(fs),e(A)),e(u),y(M,s),y(w,s),y(j,s),y(U,s),y(k,s),y(R),y($),y(S),y(F,s),y(Y,s),y(x,s)}}}const Ks='{"title":"Interact with the Hub through the Filesystem API","local":"interact-with-the-hub-through-the-filesystem-api","sections":[{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Integrations","local":"integrations","sections":[],"depth":2},{"title":"Authentication","local":"authentication","sections":[],"depth":2}],"depth":1}';function Os(Gs){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lt extends Qs{constructor(u){super(),Ls(this,u,Os,Ds,Ns,{})}}export{lt as component};
