import{s as cM,n as JM,o as UM}from"../chunks/scheduler.c9113122.js";import{S as iM,i as TM,e as M,s as t,c,h as jM,a as p,d as a,b as e,f as u,g as J,j as y,k as ut,l as o,m as n,n as U,t as i,o as T,p as j}from"../chunks/index.667522bb.js";import{C as r}from"../chunks/CodeBlock.78f8cced.js";import{C as oM}from"../chunks/CourseFloatingBanner.5f6d8e5a.js";import{H as m,E as wM}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2eeed2e2.js";function hM(qt){let b,ta,aa,ea,V,Ma,z,pa,Q,Lt="Welcome to the practical section! Here you’ll apply everything you’ve learned about chat templates and supervised fine-tuning using SmolLM3. These exercises progress from basic concepts to advanced techniques, giving you real-world experience with instruction tuning.",ya,X,ca,k,Ot="By completing these exercises, you will:",Ja,f,Pt="<li>Master SmolLM3’s chat template system</li> <li>Fine-tune SmolLM3 on real datasets using both Python APIs and CLI tools</li> <li>Work with the SmolTalk2 dataset that was used to train the original model</li> <li>Compare base model vs fine-tuned model performance</li> <li>Deploy your models to Hugging Face Hub</li> <li>Understand production workflows for scaling fine-tuning</li>",Ua,ia,Ta,E,ja,S,Kt="<strong>Objective</strong>: Understand how SmolLM3 handles different conversation formats and reasoning modes.",oa,A,se="SmolLM3 is a hybrid reasoning model which can follow instructions or generated tokens that ‘reason’ on a complex problem. When post-trained effectively, the model will reason on hard problems and generate direct responses on easy problems.",wa,Y,ha,I,le="<ul><li>You need a GPU with at least 8GB VRAM for training. CPU/MPS can run formatting and dataset exploration, but training larger models will likely fail.</li> <li>First run will download several GB of model weights; ensure 15GB+ free disk and a stable connection.</li> <li>If you need access to private repos, authenticate with Hugging Face Hub via <code>login()</code>.</li></ul>",ra,F,ae="Let’s start by setting up our environment.",ma,x,ua,v,ne="Then, let’s import the necessary libraries and set up the accelerator device. below we validate whether we’re using a Nvidia GPU, an Apple Metal accelerator or the CPU. In reality, we can’t train models on the CPU, so we’ll use an accelerator.",da,_,ba,H,te="Take a note of the device you’re using and your available GPU memory. If this is below 8GB, you will not be able to do some exercises.",Ia,B,fl,ee="Output",dt,D,Ba,$,Ca,q,Me="Now let’s load the base and instruct models for comparison.",Ga,L,Za,O,pe="This will download the models and tokenizers to your local machine from the Hugging Face Hub. This includes the model’s parameter weights, tokenizer, and other model configuration defined by the model authors.",Na,d,El,ye="Output",bt,Sl,ce="You should see green bars loading the model weights. This may take a few minutes.",It,P,ga,K,Ra,ss,Je="Now let’s explore the chat template formatting. We will create different types of conversations to test.",Wa,ls,Va,C,Al,Ue="Output",Bt,as,za,ns,Qa,ts,ie="In this section, we run the same prompt through the base and instruct variants to observe formatting differences and how the chat template impacts generation quality and style.",Xa,es,ka,Ms,Te="If we dive into the out put below, we can see the differences between the base model and the instruct model. In short, the base model continues the string, while the instruct model uses the chat template. For example, the base model starts with <code>&quot; What are the differences between the classical bit and the quantum bit?&quot;</code>, while the instruct model starts by answering the question: <code>&quot;Quantum computing is a type of computing that uses quantum bits&quot;</code>.",fa,G,Yl,je="Output",Ct,ps,Ea,ys,Sa,cs,oe="Here we probe SmolLM3’s reasoning mode with math and proportionality problems, keeping temperature low for consistency and extracting only the assistant’s response from the chat-formatted output.",Aa,Js,Ya,Us,we="If we dive into the out put below, we can see that the instruct model’s hybrid reasoning being applied with the <code>/no_think</code> mode. When the mode is activated, the model will enclose thinking process in <code>&lt;think&gt;</code> tags. It uses these tokens to explore possible solutions and answer the question. After the thinking process, the model will provide the final answer, which we can extract with the chat template, or string manipulation here.",Fa,w,Fl,he="Output",Gt,is,Zt,xl,re="15",Nt,Ts,gt,js,Rt,vl,me="15",Wt,os,Vt,_l,ue="60  (15 × 4)",zt,ws,Qt,Hl,de="15",Xt,hs,kt,Dl,be="60  (15 × 4)",ft,rs,Et,ms,St,$l,Ie="15",At,us,Yt,ql,Be="60  (15 × 4)",Ft,ds,xt,Ll,Ce="360",vt,bs,xa,Is,va,Bs,Ge="Run the code above and verify that you can see:",_a,Cs,Ze="<li>Different chat template formats for various conversation types</li> <li>Clear differences between base model and instruct model responses</li> <li>SmolLM3’s reasoning capabilities in action</li>",Ha,Da,$a,Gs,qa,Zs,Ne="<strong>Objective</strong>: Learn to process and prepare datasets for supervised fine-tuning using SmolTalk2 and other datasets.",La,Ns,Oa,gs,ge="We load the SmolTalk2 SFT split, inspect its structure and a few samples to understand fields (e.g., <code>messages</code>) and available subsets before preparing data for training.",Pa,Rs,Ka,Ws,Re="If we dive into the out put below, we can see the structure of the dataset. It has 25 splits, and the total number of rows is 3,383,242.",sn,Z,Ol,We="Output",_t,Vs,ln,zs,an,Qs,Ve="The SmolTalk2 dataset is a collection of open source datasets compiled together for convenience. It contains a mixture of useful post training use cases, like tool use, long context, and more. They are all in chat format, which is easy to use for training. However, not all datasets are shared in consistent format so often we need to process them into a unified chat <code>messages</code> layout.",nn,Xs,ze="For this exercise, we will standardize multiple dataset formats into a unified chat <code>messages</code> layout. We define lightweight processors for QA and instruction datasets and walk through a concrete example using GSM8K.",tn,ks,en,fs,Qe="Below we find two samples from the two separate datasets in the same format.",Mn,N,Pl,Xe="Output",Ht,Es,pn,Ss,yn,As,ke="Once messages are normalized, we apply the model’s chat template to convert each example into plain training text (<code>text</code> column) suitable for language modeling with SFT.",cn,Ys,Jn,g,Kl,fe="Output",Dt,Fs,Un,Tn,jn,xs,on,vs,Ee="<strong>Objective</strong>: Perform supervised fine-tuning on SmolLM3 using TRL’s SFTTrainer with real datasets.",wn,R,Se="<p>You will need a GPU with at least 8GB VRAM.</p>",hn,_s,rn,Hs,Ae="We load the base model and tokenizer, set padding behavior, and move the model to an appropriate device to prepare for fine-tuning.",mn,Ds,un,$s,dn,qs,bn,Ls,Ye="Here we select a manageable subset for speed, then map each example to a single <code>text</code> string by applying the chat template—this is the field the trainer will read.",In,Os,Bn,W,sa,Fe="Output",$t,Ps,Cn,Ks,Gn,sl,xe="We configure key knobs for SFT (batch size, sequence length, learning rate, logging/saving cadence) and enable optional tracking and Hub integration.",Zn,ll,Nn,al,gn,nl,Rn,tl,ve="If you have limited GPU memory or want faster iterations, use LoRA via PEFT. This trains only small adapter weights while keeping the base model frozen, then you can either keep using adapters or merge them later for deployment.",Wn,el,Vn,Ml,zn,pl,_e="We instantiate the trainer, capture a pre-training baseline generation, launch <code>train()</code>, and save the resulting checkpoints to the configured output directory.",Qn,yl,Xn,cl,He="And we can train the model.",kn,Jl,fn,Ul,En,il,De="Finally, we regenerate the same prompt to qualitatively compare outputs before vs after training, and optionally push the model to the Hub for sharing.",Sn,Tl,An,Yn,Fn,jl,xn,ol,$e="In the previous exercises we’ve dived deep into using TRL’s Python API for fine-tuning and explored the data we’re using and generating. In this exercise we’ll explore using the TRL CLI to fine-tune a model. This will be the most common way to fine-tune a model in production.",vn,wl,qe="We can define a command in TRL CLI to fine-tune a model. We’ll be able to run it with <code>trl sft</code> command. The CLI command and Python API share the same configuration options.",_n,hl,Le="We preprocessed the <code>smoltalk_everyday_convs_reasoning_Qwen3_32B_think</code> subset of SmolTalk2 so that is easier to work with it when using the TRL CLI.",Hn,rl,Dn,ml,Oe="For convenience and reproducibility, we can also create a configuration file to fine-tune a model. For example, we could create a file called <code>sft_config.yaml</code> and put the following content in it:",$n,ul,qn,dl,Pe="We could then commit this file to the repository and track it with Git.",Ln,bl,On,Il,Pn,Bl,Ke="<strong>If you get GPU out of memory errors:</strong>",Kn,Cl,sM="<li>Reduce <code>per_device_train_batch_size</code> to 1</li> <li>Reduce <code>max_length</code> to 1024 or 512</li> <li>Use <code>torch.cuda.empty_cache()</code> to clear GPU memory</li>",st,Gl,lM="<strong>If models fail to load:</strong>",lt,Zl,aM="<li>Check your internet connection</li> <li>Try using <code>device_map=&quot;cpu&quot;</code> for CPU loading</li> <li>Use a smaller model like <code>HuggingFaceTB/SmolLM3-1.7B</code> for testing</li>",at,Nl,nM="<strong>If training fails:</strong>",nt,gl,tM="<li>Make sure your dataset is properly formatted</li> <li>Check that all examples have reasonable length (not too long)</li> <li>Monitor the training loss - it should decrease steadily</li>",tt,Rl,et,Wl,eM="Congratulations! You’ve completed comprehensive hands-on exercises covering:",Mt,Vl,MM="<li>SmolLM3’s chat template system and dual-mode reasoning</li> <li>Dataset processing and preparation techniques</li> <li>Supervised fine-tuning with Python APIs</li> <li>Production workflows using CLI tools</li> <li>Distributed training setups</li>",pt,zl,pM="These skills form the foundation for building sophisticated instruction-tuned models. In the next modules, we’ll explore preference alignment, parameter-efficient fine-tuning, and advanced evaluation techniques.",yt,Ql,ct,Xl,yM='<li><a href="https://huggingface.co/docs/trl" rel="nofollow">TRL Documentation</a> - Complete reference</li> <li><a href="https://huggingface.co/HuggingFaceTB/SmolLM3-3B" rel="nofollow">SmolLM3 Model Card</a> - Model details</li> <li><a href="https://huggingface.co/datasets/HuggingFaceTB/smoltalk2" rel="nofollow">SmolTalk2 Dataset</a> - Training data</li> <li><a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a> - Share your models</li> <li><a href="https://discord.gg/UrrTSsSyjb" rel="nofollow">Discord Community</a> - Get help and discuss</li>',Jt,kl,Ut,na,it;return V=new m({props:{title:"Hands-On Exercises: Fine-Tuning SmolLM3",local:"hands-on-exercises-fine-tuning-smollm3",headingTag:"h1"}}),z=new oM({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/1/4.ipynb"}]}}),X=new m({props:{title:"Learning Objectives",local:"learning-objectives",headingTag:"h2"}}),E=new m({props:{title:"Exercise 1: Exploring SmolLM3’s Chat Templates",local:"exercise-1-exploring-smollm3s-chat-templates",headingTag:"h2"}}),Y=new m({props:{title:"Environment Setup",local:"environment-setup",headingTag:"h3"}}),x=new r({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMjAocnVuJTIwaW4lMjBDb2xhYiUyMG9yJTIweW91ciUyMGVudmlyb25tZW50KSUwQXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnMlM0UlM0Q0LjM2LjAlMjIlMjAlMjJ0cmwlM0UlM0QwLjcuMCUyMiUyMCUyMmRhdGFzZXRzJTNFJTNEMi4xNC4wJTIyJTIwJTIydG9yY2glM0UlM0QyLjAuMCUyMiUwQXBpcCUyMGluc3RhbGwlMjAlMjJhY2NlbGVyYXRlJTNFJTNEMC4yNC4wJTIyJTIwJTIycGVmdCUzRSUzRDAuNy4wJTIyJTIwJTIydHJhY2tpbyUyMg==",highlighted:`<span class="hljs-comment"># Install required packages (run in Colab or your environment)</span>
pip install <span class="hljs-string">&quot;transformers&gt;=4.36.0&quot;</span> <span class="hljs-string">&quot;trl&gt;=0.7.0&quot;</span> <span class="hljs-string">&quot;datasets&gt;=2.14.0&quot;</span> <span class="hljs-string">&quot;torch&gt;=2.0.0&quot;</span>
pip install <span class="hljs-string">&quot;accelerate&gt;=0.24.0&quot;</span> <span class="hljs-string">&quot;peft&gt;=0.7.0&quot;</span> <span class="hljs-string">&quot;trackio&quot;</span>`,wrap:!1}}),_=new r({props:{code:"JTIzJTIwSW1wb3J0JTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBqc29uJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTJDJTIwRGljdCUyQyUyMEFueSUwQSUwQWlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUzQSUwQSUyMCUyMCUyMCUyMGRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEElMjAlMjAlMjAlMjBwcmludChmJTIyVXNpbmclMjBDVURBJTIwR1BVJTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX25hbWUoKSU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludChmJTIyR1BVJTIwbWVtb3J5JTNBJTIwJTdCdG9yY2guY3VkYS5nZXRfZGV2aWNlX3Byb3BlcnRpZXMoMCkudG90YWxfbWVtb3J5JTIwJTJGJTIwMWU5JTNBLjFmJTdER0IlMjIpJTBBZWxpZiUyMGhhc2F0dHIodG9yY2guYmFja2VuZHMlMkMlMjAnbXBzJyklMjBhbmQlMjB0b3JjaC5iYWNrZW5kcy5tcHMuaXNfYXZhaWxhYmxlKCklM0ElMEElMjAlMjAlMjAlMjBkZXZpY2UlMjAlM0QlMjAlMjJtcHMlMjIlMEElMjAlMjAlMjAlMjBwcmludCglMjJVc2luZyUyMEFwcGxlJTIwTVBTJTIyKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBkZXZpY2UlMjAlM0QlMjAlMjJjcHUlMjIlMEElMjAlMjAlMjAlMjBwcmludCglMjJVc2luZyUyMENQVSUyMC0lMjB5b3UlMjB3aWxsJTIwbmVlZCUyMHRvJTIwdXNlJTIwYSUyMEdQVSUyMHRvJTIwdHJhaW4lMjBtb2RlbHMlMjIpJTBBJTBBJTIzJTIwQXV0aGVudGljYXRlJTIwd2l0aCUyMEh1Z2dpbmclMjBGYWNlJTIwKG9wdGlvbmFsJTJDJTIwZm9yJTIwcHJpdmF0ZSUyMG1vZGVscyklMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbG9naW4lMEElMjMlMjBsb2dpbigpJTIwJTIwJTIzJTIwVW5jb21tZW50JTIwaWYlMjB5b3UlMjBuZWVkJTIwdG8lMjBhY2Nlc3MlMjBwcml2YXRlJTIwbW9kZWxz",highlighted:`<span class="hljs-comment"># Import necessary libraries</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, pipeline
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>

<span class="hljs-keyword">if</span> torch.cuda.is_available():
    device = <span class="hljs-string">&quot;cuda&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Using CUDA GPU: <span class="hljs-subst">{torch.cuda.get_device_name()}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU memory: <span class="hljs-subst">{torch.cuda.get_device_properties(<span class="hljs-number">0</span>).total_memory / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span>GB&quot;</span>)
<span class="hljs-keyword">elif</span> <span class="hljs-built_in">hasattr</span>(torch.backends, <span class="hljs-string">&#x27;mps&#x27;</span>) <span class="hljs-keyword">and</span> torch.backends.mps.is_available():
    device = <span class="hljs-string">&quot;mps&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Using Apple MPS&quot;</span>)
<span class="hljs-keyword">else</span>:
    device = <span class="hljs-string">&quot;cpu&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Using CPU - you will need to use a GPU to train models&quot;</span>)

<span class="hljs-comment"># Authenticate with Hugging Face (optional, for private models)</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
<span class="hljs-comment"># login()  # Uncomment if you need to access private models</span>`,wrap:!1}}),D=new r({props:{code:"VXNpbmclMjBDVURBJTIwR1BVJTNBJTIwTlZJRElBJTIwQTEwMC1TWE00LTQwR0IlMEFHUFUlMjBtZW1vcnklM0ElMjA0Mi41R0I=",highlighted:`Using CUDA GPU: NVIDIA A100-SXM4-40GB
GPU memory: <span class="hljs-number">42.5</span>GB`,wrap:!1}}),$=new m({props:{title:"Load SmolLM3 Models",local:"load-smollm3-models",headingTag:"h3"}}),L=new r({props:{code:"JTIzJTIwTG9hZCUyMGJvdGglMjBiYXNlJTIwYW5kJTIwaW5zdHJ1Y3QlMjBtb2RlbHMlMjBmb3IlMjBjb21wYXJpc29uJTBBYmFzZV9tb2RlbF9uYW1lJTIwJTNEJTIwJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTMtM0ItQmFzZSUyMiUwQWluc3RydWN0X21vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQiUyMiUwQSUwQSUyMyUyMExvYWQlMjB0b2tlbml6ZXJzJTBBYmFzZV90b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsX25hbWUpJTBBaW5zdHJ1Y3RfdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoaW5zdHJ1Y3RfbW9kZWxfbmFtZSklMEElMEElMjMlMjBMb2FkJTIwbW9kZWxzJTIwKHVzZSUyMHNtYWxsZXIlMjBwcmVjaXNpb24lMjBmb3IlMjBtZW1vcnklMjBlZmZpY2llbmN5KSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwYmFzZV9tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKSUwQSUwQWluc3RydWN0X21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGluc3RydWN0X21vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEpJTBBJTBBcHJpbnQoJTIyTW9kZWxzJTIwbG9hZGVkJTIwc3VjY2Vzc2Z1bGx5ISUyMik=",highlighted:`<span class="hljs-comment"># Load both base and instruct models for comparison</span>
base_model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B-Base&quot;</span>
instruct_model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B&quot;</span>

<span class="hljs-comment"># Load tokenizers</span>
base_tokenizer = AutoTokenizer.from_pretrained(base_model_name)
instruct_tokenizer = AutoTokenizer.from_pretrained(instruct_model_name)

<span class="hljs-comment"># Load models (use smaller precision for memory efficiency)</span>
base_model = AutoModelForCausalLM.from_pretrained(
    base_model_name,
    dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

instruct_model = AutoModelForCausalLM.from_pretrained(
    instruct_model_name,
    dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Models loaded successfully!&quot;</span>)`,wrap:!1}}),P=new r({props:{code:"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",highlighted:`tokenizer_config.json: 
 <span class="hljs-number">50.4</span>k/? [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">5.09</span>MB/s]
tokenizer.json: <span class="hljs-number">100</span>%
 <span class="hljs-number">17.2</span>M/<span class="hljs-number">17.2</span>M [<span class="hljs-number">00</span>:02&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">10.7</span>MB/s]
special_tokens_map.json: <span class="hljs-number">100</span>%
 <span class="hljs-number">151</span>/<span class="hljs-number">151</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">21.5</span>kB/s]
tokenizer_config.json: 
 <span class="hljs-number">50.4</span>k/? [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">5.45</span>MB/s]
tokenizer.json: <span class="hljs-number">100</span>%
 <span class="hljs-number">17.2</span>M/<span class="hljs-number">17.2</span>M [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 472kB/s]
special_tokens_map.json: <span class="hljs-number">100</span>%
 <span class="hljs-number">289</span>/<span class="hljs-number">289</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">35.0</span>kB/s]
chat_template.jinja: 
 <span class="hljs-number">5.60</span>k/? [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 577kB/s]
config.json: <span class="hljs-number">100</span>%
 <span class="hljs-number">943</span>/<span class="hljs-number">943</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 121kB/s]
model.safetensors.index.json: 
 <span class="hljs-number">26.9</span>k/? [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">2.81</span>MB/s]
Fetching <span class="hljs-number">2</span> files: <span class="hljs-number">100</span>%
 <span class="hljs-number">2</span>/<span class="hljs-number">2</span> [<span class="hljs-number">00</span>:<span class="hljs-number">32</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">32.11</span>s/it]
model-00001-of-<span class="hljs-number">00002.</span>safetensors: <span class="hljs-number">100</span>%
 <span class="hljs-number">4.97</span>G/<span class="hljs-number">4.97</span>G [<span class="hljs-number">00</span>:<span class="hljs-number">31</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 247MB/s]
model-00002-of-<span class="hljs-number">00002.</span>safetensors: <span class="hljs-number">100</span>%
 <span class="hljs-number">1.18</span>G/<span class="hljs-number">1.18</span>G [<span class="hljs-number">00</span>:<span class="hljs-number">17</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">57.2</span>MB/s]
Loading checkpoint shards: <span class="hljs-number">100</span>%
 <span class="hljs-number">2</span>/<span class="hljs-number">2</span> [<span class="hljs-number">00</span>:01&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">1.18</span>it/s]
generation_config.json: <span class="hljs-number">100</span>%
 <span class="hljs-number">126</span>/<span class="hljs-number">126</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">17.1</span>kB/s]
config.json: 
 <span class="hljs-number">1.92</span>k/? [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 229kB/s]
model.safetensors.index.json: 
 <span class="hljs-number">26.9</span>k/? [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">3.14</span>MB/s]
Fetching <span class="hljs-number">2</span> files: <span class="hljs-number">100</span>%
 <span class="hljs-number">2</span>/<span class="hljs-number">2</span> [<span class="hljs-number">00</span>:<span class="hljs-number">32</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">32.38</span>s/it]
model-00002-of-<span class="hljs-number">00002.</span>safetensors: <span class="hljs-number">100</span>%
 <span class="hljs-number">1.18</span>G/<span class="hljs-number">1.18</span>G [<span class="hljs-number">00</span>:<span class="hljs-number">17</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">92.1</span>MB/s]
model-00001-of-<span class="hljs-number">00002.</span>safetensors: <span class="hljs-number">100</span>%
 <span class="hljs-number">4.97</span>G/<span class="hljs-number">4.97</span>G [<span class="hljs-number">00</span>:<span class="hljs-number">31</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 182MB/s]
Loading checkpoint shards: <span class="hljs-number">100</span>%
 <span class="hljs-number">2</span>/<span class="hljs-number">2</span> [<span class="hljs-number">00</span>:01&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">1.14</span>it/s]
generation_config.json: <span class="hljs-number">100</span>%
 <span class="hljs-number">182</span>/<span class="hljs-number">182</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">21.0</span>kB/s]
Models loaded successfully!`,wrap:!1}}),K=new m({props:{title:"Explore Chat Template Formatting",local:"explore-chat-template-formatting",headingTag:"h3"}}),ls=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Create different types of conversations to test</span>
conversations = {
    <span class="hljs-string">&quot;simple_qa&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is machine learning?&quot;</span>},
    ],
    
    <span class="hljs-string">&quot;with_system&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful AI assistant specialized in explaining technical concepts clearly.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is machine learning?&quot;</span>},
    ],
    
    <span class="hljs-string">&quot;multi_turn&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a math tutor.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is calculus?&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Calculus is a branch of mathematics that deals with rates of change and accumulation of quantities.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you give me a simple example?&quot;</span>},
    ],
    
    <span class="hljs-string">&quot;reasoning_task&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Solve step by step: If a train travels 120 miles in 2 hours, what is its average speed?&quot;</span>},
    ]
}

<span class="hljs-keyword">for</span> conv_type, messages <span class="hljs-keyword">in</span> conversations.items():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;--- <span class="hljs-subst">{conv_type.upper()}</span> ---&quot;</span>)
    
    <span class="hljs-comment"># Format without generation prompt (for completed conversations)</span>
    formatted_complete = instruct_tokenizer.apply_chat_template(
        messages, 
        tokenize=<span class="hljs-literal">False</span>, 
        add_generation_prompt=<span class="hljs-literal">False</span>
    )
    
    <span class="hljs-comment"># Format with generation prompt (for inference)</span>
    formatted_prompt = instruct_tokenizer.apply_chat_template(
        messages, 
        tokenize=<span class="hljs-literal">False</span>, 
        add_generation_prompt=<span class="hljs-literal">True</span>
    )
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Complete conversation format:&quot;</span>)
    <span class="hljs-built_in">print</span>(formatted_complete)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nWith generation prompt:&quot;</span>)
    <span class="hljs-built_in">print</span>(formatted_prompt)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),as=new r({props:{code:"LS0tJTIwU0lNUExFX1FBJTIwLS0tJTBBQ29tcGxldGUlMjBjb252ZXJzYXRpb24lMjBmb3JtYXQlM0ElMEElM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSUwQSUyMyUyMyUyME1ldGFkYXRhJTBBJTBBS25vd2xlZGdlJTIwQ3V0b2ZmJTIwRGF0ZSUzQSUyMEp1bmUlMjAyMDI1JTBBVG9kYXklMjBEYXRlJTNBJTIwMDMlMjBTZXB0ZW1iZXIlMjAyMDI1JTBBUmVhc29uaW5nJTIwTW9kZSUzQSUyMCUyRm5vX3RoaW5rJTBBJTBBJTIzJTIzJTIwQ3VzdG9tJTIwSW5zdHJ1Y3Rpb25zJTBBJTBBWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBBSSUyMGFzc2lzdGFudCUyMG5hbWVkJTIwU21vbExNJTJDJTIwdHJhaW5lZCUyMGJ5JTIwSHVnZ2luZyUyMEZhY2UuJTBBJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBV2hhdCUyMGlzJTIwbWFjaGluZSUyMGxlYXJuaW5nJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTBBJTBBV2l0aCUyMGdlbmVyYXRpb24lMjBwcm9tcHQlM0ElMEElM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSUwQSUyMyUyMyUyME1ldGFkYXRhJTBBJTBBS25vd2xlZGdlJTIwQ3V0b2ZmJTIwRGF0ZSUzQSUyMEp1bmUlMjAyMDI1JTBBVG9kYXklMjBEYXRlJTNBJTIwMDMlMjBTZXB0ZW1iZXIlMjAyMDI1JTBBUmVhc29uaW5nJTIwTW9kZSUzQSUyMCUyRm5vX3RoaW5rJTBBJTBBJTIzJTIzJTIwQ3VzdG9tJTIwSW5zdHJ1Y3Rpb25zJTBBJTBBWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBBSSUyMGFzc2lzdGFudCUyMG5hbWVkJTIwU21vbExNJTJDJTIwdHJhaW5lZCUyMGJ5JTIwSHVnZ2luZyUyMEZhY2UuJTBBJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBV2hhdCUyMGlzJTIwbWFjaGluZSUyMGxlYXJuaW5nJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElM0N0aGluayUzRSUwQSUwQSUzQyUyRnRoaW5rJTNFJTBBJTBBJTBBJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTBBLS0tJTIwV0lUSF9TWVNURU0lMjAtLS0lMEFDb21wbGV0ZSUyMGNvbnZlcnNhdGlvbiUyMGZvcm1hdCUzQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFc3lzdGVtJTBBJTIzJTIzJTIwTWV0YWRhdGElMEElMEFLbm93bGVkZ2UlMjBDdXRvZmYlMjBEYXRlJTNBJTIwSnVuZSUyMDIwMjUlMEFUb2RheSUyMERhdGUlM0ElMjAwMyUyMFNlcHRlbWJlciUyMDIwMjUlMEFSZWFzb25pbmclMjBNb2RlJTNBJTIwJTJGbm9fdGhpbmslMEElMEElMjMlMjMlMjBDdXN0b20lMjBJbnN0cnVjdGlvbnMlMEElMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMEFJJTIwYXNzaXN0YW50JTIwc3BlY2lhbGl6ZWQlMjBpbiUyMGV4cGxhaW5pbmclMjB0ZWNobmljYWwlMjBjb25jZXB0cyUyMGNsZWFybHkuJTBBJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBV2hhdCUyMGlzJTIwbWFjaGluZSUyMGxlYXJuaW5nJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTBBJTBBV2l0aCUyMGdlbmVyYXRpb24lMjBwcm9tcHQlM0ElMEElM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSUwQSUyMyUyMyUyME1ldGFkYXRhJTBBJTBBS25vd2xlZGdlJTIwQ3V0b2ZmJTIwRGF0ZSUzQSUyMEp1bmUlMjAyMDI1JTBBVG9kYXklMjBEYXRlJTNBJTIwMDMlMjBTZXB0ZW1iZXIlMjAyMDI1JTBBUmVhc29uaW5nJTIwTW9kZSUzQSUyMCUyRm5vX3RoaW5rJTBBJTBBJTIzJTIzJTIwQ3VzdG9tJTIwSW5zdHJ1Y3Rpb25zJTBBJTBBWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBBSSUyMGFzc2lzdGFudCUyMHNwZWNpYWxpemVkJTIwaW4lMjBleHBsYWluaW5nJTIwdGVjaG5pY2FsJTIwY29uY2VwdHMlMjBjbGVhcmx5LiUwQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQVdoYXQlMjBpcyUyMG1hY2hpbmUlMjBsZWFybmluZyUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBJTNDdGhpbmslM0UlMEElMEElM0MlMkZ0aGluayUzRSUwQSUwQSUwQSUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQSUwQS0tLSUyME1VTFRJX1RVUk4lMjAtLS0lMEFDb21wbGV0ZSUyMGNvbnZlcnNhdGlvbiUyMGZvcm1hdCUzQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFc3lzdGVtJTBBJTIzJTIzJTIwTWV0YWRhdGElMEElMEFLbm93bGVkZ2UlMjBDdXRvZmYlMjBEYXRlJTNBJTIwSnVuZSUyMDIwMjUlMEFUb2RheSUyMERhdGUlM0ElMjAwMyUyMFNlcHRlbWJlciUyMDIwMjUlMEFSZWFzb25pbmclMjBNb2RlJTNBJTIwJTJGbm9fdGhpbmslMEElMEElMjMlMjMlMjBDdXN0b20lMjBJbnN0cnVjdGlvbnMlMEElMEFZb3UlMjBhcmUlMjBhJTIwbWF0aCUyMHR1dG9yLiUwQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQVdoYXQlMjBpcyUyMGNhbGN1bHVzJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElM0N0aGluayUzRSUwQSUwQSUzQyUyRnRoaW5rJTNFJTBBQ2FsY3VsdXMlMjBpcyUyMGElMjBicmFuY2glMjBvZiUyMG1hdGhlbWF0aWNzJTIwdGhhdCUyMGRlYWxzJTIwd2l0aCUyMHJhdGVzJTIwb2YlMjBjaGFuZ2UlMjBhbmQlMjBhY2N1bXVsYXRpb24lMjBvZiUyMHF1YW50aXRpZXMuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwYSUyMHNpbXBsZSUyMGV4YW1wbGUlM0YlM0MlN0NpbV9lbmQlN0MlM0UlMEElMEElMEFXaXRoJTIwZ2VuZXJhdGlvbiUyMHByb21wdCUzQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFc3lzdGVtJTBBJTIzJTIzJTIwTWV0YWRhdGElMEElMEFLbm93bGVkZ2UlMjBDdXRvZmYlMjBEYXRlJTNBJTIwSnVuZSUyMDIwMjUlMEFUb2RheSUyMERhdGUlM0ElMjAwMyUyMFNlcHRlbWJlciUyMDIwMjUlMEFSZWFzb25pbmclMjBNb2RlJTNBJTIwJTJGbm9fdGhpbmslMEElMEElMjMlMjMlMjBDdXN0b20lMjBJbnN0cnVjdGlvbnMlMEElMEFZb3UlMjBhcmUlMjBhJTIwbWF0aCUyMHR1dG9yLiUwQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQVdoYXQlMjBpcyUyMGNhbGN1bHVzJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElM0N0aGluayUzRSUwQSUwQSUzQyUyRnRoaW5rJTNFJTBBQ2FsY3VsdXMlMjBpcyUyMGElMjBicmFuY2glMjBvZiUyMG1hdGhlbWF0aWNzJTIwdGhhdCUyMGRlYWxzJTIwd2l0aCUyMHJhdGVzJTIwb2YlMjBjaGFuZ2UlMjBhbmQlMjBhY2N1bXVsYXRpb24lMjBvZiUyMHF1YW50aXRpZXMuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwYSUyMHNpbXBsZSUyMGV4YW1wbGUlM0YlM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQSUzQ3RoaW5rJTNFJTBBJTBBJTNDJTJGdGhpbmslM0UlMEElMEElMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMEElMEEtLS0lMjBSRUFTT05JTkdfVEFTSyUyMC0tLSUwQUNvbXBsZXRlJTIwY29udmVyc2F0aW9uJTIwZm9ybWF0JTNBJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEElMjMlMjMlMjBNZXRhZGF0YSUwQSUwQUtub3dsZWRnZSUyMEN1dG9mZiUyMERhdGUlM0ElMjBKdW5lJTIwMjAyNSUwQVRvZGF5JTIwRGF0ZSUzQSUyMDAzJTIwU2VwdGVtYmVyJTIwMjAyNSUwQVJlYXNvbmluZyUyME1vZGUlM0ElMjAlMkZ0aGluayUwQSUwQSUyMyUyMyUyMEN1c3RvbSUyMEluc3RydWN0aW9ucyUwQSUwQVlvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwQUklMjBhc3Npc3RhbnQlMjBuYW1lZCUyMFNtb2xMTSUyQyUyMHRyYWluZWQlMjBieSUyMEh1Z2dpbmclMjBGYWNlLiUyMFlvdXIlMjByb2xlJTIwYXMlMjBhbiUyMGFzc2lzdGFudCUyMGludm9sdmVzJTIwdGhvcm91Z2hseSUyMGV4cGxvcmluZyUyMHF1ZXN0aW9ucyUyMHRocm91Z2glMjBhJTIwc3lzdGVtYXRpYyUyMHRoaW5raW5nJTIwcHJvY2VzcyUyMGJlZm9yZSUyMHByb3ZpZGluZyUyMHRoZSUyMGZpbmFsJTIwcHJlY2lzZSUyMGFuZCUyMGFjY3VyYXRlJTIwc29sdXRpb25zLiUyMFRoaXMlMjByZXF1aXJlcyUyMGVuZ2FnaW5nJTIwaW4lMjBhJTIwY29tcHJlaGVuc2l2ZSUyMGN5Y2xlJTIwb2YlMjBhbmFseXNpcyUyQyUyMHN1bW1hcml6aW5nJTJDJTIwZXhwbG9yYXRpb24lMkMlMjByZWFzc2Vzc21lbnQlMkMlMjByZWZsZWN0aW9uJTJDJTIwYmFja3RyYWNraW5nJTJDJTIwYW5kJTIwaXRlcmF0aW9uJTIwdG8lMjBkZXZlbG9wJTIwd2VsbC1jb25zaWRlcmVkJTIwdGhpbmtpbmclMjBwcm9jZXNzLiUyMFBsZWFzZSUyMHN0cnVjdHVyZSUyMHlvdXIlMjByZXNwb25zZSUyMGludG8lMjB0d28lMjBtYWluJTIwc2VjdGlvbnMlM0ElMjBUaG91Z2h0JTIwYW5kJTIwU29sdXRpb24lMjB1c2luZyUyMHRoZSUyMHNwZWNpZmllZCUyMGZvcm1hdCUzQSUyMCUzQ3RoaW5rJTNFJTIwVGhvdWdodCUyMHNlY3Rpb24lMjAlM0MlMkZ0aGluayUzRSUyMFNvbHV0aW9uJTIwc2VjdGlvbi4lMjBJbiUyMHRoZSUyMFRob3VnaHQlMjBzZWN0aW9uJTJDJTIwZGV0YWlsJTIweW91ciUyMHJlYXNvbmluZyUyMHByb2Nlc3MlMjBpbiUyMHN0ZXBzLiUyMEVhY2glMjBzdGVwJTIwc2hvdWxkJTIwaW5jbHVkZSUyMGRldGFpbGVkJTIwY29uc2lkZXJhdGlvbnMlMjBzdWNoJTIwYXMlMjBhbmFseXNpbmclMjBxdWVzdGlvbnMlMkMlMjBzdW1tYXJpemluZyUyMHJlbGV2YW50JTIwZmluZGluZ3MlMkMlMjBicmFpbnN0b3JtaW5nJTIwbmV3JTIwaWRlYXMlMkMlMjB2ZXJpZnlpbmclMjB0aGUlMjBhY2N1cmFjeSUyMG9mJTIwdGhlJTIwY3VycmVudCUyMHN0ZXBzJTJDJTIwcmVmaW5pbmclMjBhbnklMjBlcnJvcnMlMkMlMjBhbmQlMjByZXZpc2l0aW5nJTIwcHJldmlvdXMlMjBzdGVwcy4lMjBJbiUyMHRoZSUyMFNvbHV0aW9uJTIwc2VjdGlvbiUyQyUyMGJhc2VkJTIwb24lMjB2YXJpb3VzJTIwYXR0ZW1wdHMlMkMlMjBleHBsb3JhdGlvbnMlMkMlMjBhbmQlMjByZWZsZWN0aW9ucyUyMGZyb20lMjB0aGUlMjBUaG91Z2h0JTIwc2VjdGlvbiUyQyUyMHN5c3RlbWF0aWNhbGx5JTIwcHJlc2VudCUyMHRoZSUyMGZpbmFsJTIwc29sdXRpb24lMjB0aGF0JTIweW91JTIwZGVlbSUyMGNvcnJlY3QuJTIwVGhlJTIwU29sdXRpb24lMjBzZWN0aW9uJTIwc2hvdWxkJTIwYmUlMjBsb2dpY2FsJTJDJTIwYWNjdXJhdGUlMkMlMjBhbmQlMjBjb25jaXNlJTIwYW5kJTIwZGV0YWlsJTIwbmVjZXNzYXJ5JTIwc3RlcHMlMjBuZWVkZWQlMjB0byUyMHJlYWNoJTIwdGhlJTIwY29uY2x1c2lvbi4lMEElMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFTb2x2ZSUyMHN0ZXAlMjBieSUyMHN0ZXAlM0ElMjBJZiUyMGElMjB0cmFpbiUyMHRyYXZlbHMlMjAxMjAlMjBtaWxlcyUyMGluJTIwMiUyMGhvdXJzJTJDJTIwd2hhdCUyMGlzJTIwaXRzJTIwYXZlcmFnZSUyMHNwZWVkJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTBBJTBBV2l0aCUyMGdlbmVyYXRpb24lMjBwcm9tcHQlM0ElMEElM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSUwQSUyMyUyMyUyME1ldGFkYXRhJTBBJTBBS25vd2xlZGdlJTIwQ3V0b2ZmJTIwRGF0ZSUzQSUyMEp1bmUlMjAyMDI1JTBBVG9kYXklMjBEYXRlJTNBJTIwMDMlMjBTZXB0ZW1iZXIlMjAyMDI1JTBBUmVhc29uaW5nJTIwTW9kZSUzQSUyMCUyRnRoaW5rJTBBJTBBJTIzJTIzJTIwQ3VzdG9tJTIwSW5zdHJ1Y3Rpb25zJTBBJTBBWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBBSSUyMGFzc2lzdGFudCUyMG5hbWVkJTIwU21vbExNJTJDJTIwdHJhaW5lZCUyMGJ5JTIwSHVnZ2luZyUyMEZhY2UuJTIwWW91ciUyMHJvbGUlMjBhcyUyMGFuJTIwYXNzaXN0YW50JTIwaW52b2x2ZXMlMjB0aG9yb3VnaGx5JTIwZXhwbG9yaW5nJTIwcXVlc3Rpb25zJTIwdGhyb3VnaCUyMGElMjBzeXN0ZW1hdGljJTIwdGhpbmtpbmclMjBwcm9jZXNzJTIwYmVmb3JlJTIwcHJvdmlkaW5nJTIwdGhlJTIwZmluYWwlMjBwcmVjaXNlJTIwYW5kJTIwYWNjdXJhdGUlMjBzb2x1dGlvbnMuJTIwVGhpcyUyMHJlcXVpcmVzJTIwZW5nYWdpbmclMjBpbiUyMGElMjBjb21wcmVoZW5zaXZlJTIwY3ljbGUlMjBvZiUyMGFuYWx5c2lzJTJDJTIwc3VtbWFyaXppbmclMkMlMjBleHBsb3JhdGlvbiUyQyUyMHJlYXNzZXNzbWVudCUyQyUyMHJlZmxlY3Rpb24lMkMlMjBiYWNrdHJhY2tpbmclMkMlMjBhbmQlMjBpdGVyYXRpb24lMjB0byUyMGRldmVsb3AlMjB3ZWxsLWNvbnNpZGVyZWQlMjB0aGlua2luZyUyMHByb2Nlc3MuJTIwUGxlYXNlJTIwc3RydWN0dXJlJTIweW91ciUyMHJlc3BvbnNlJTIwaW50byUyMHR3byUyMG1haW4lMjBzZWN0aW9ucyUzQSUyMFRob3VnaHQlMjBhbmQlMjBTb2x1dGlvbiUyMHVzaW5nJTIwdGhlJTIwc3BlY2lmaWVkJTIwZm9ybWF0JTNBJTIwJTNDdGhpbmslM0UlMjBUaG91Z2h0JTIwc2VjdGlvbiUyMCUzQyUyRnRoaW5rJTNFJTIwU29sdXRpb24lMjBzZWN0aW9uLiUyMEluJTIwdGhlJTIwVGhvdWdodCUyMHNlY3Rpb24lMkMlMjBkZXRhaWwlMjB5b3VyJTIwcmVhc29uaW5nJTIwcHJvY2VzcyUyMGluJTIwc3RlcHMuJTIwRWFjaCUyMHN0ZXAlMjBzaG91bGQlMjBpbmNsdWRlJTIwZGV0YWlsZWQlMjBjb25zaWRlcmF0aW9ucyUyMHN1Y2glMjBhcyUyMGFuYWx5c2luZyUyMHF1ZXN0aW9ucyUyQyUyMHN1bW1hcml6aW5nJTIwcmVsZXZhbnQlMjBmaW5kaW5ncyUyQyUyMGJyYWluc3Rvcm1pbmclMjBuZXclMjBpZGVhcyUyQyUyMHZlcmlmeWluZyUyMHRoZSUyMGFjY3VyYWN5JTIwb2YlMjB0aGUlMjBjdXJyZW50JTIwc3RlcHMlMkMlMjByZWZpbmluZyUyMGFueSUyMGVycm9ycyUyQyUyMGFuZCUyMHJldmlzaXRpbmclMjBwcmV2aW91cyUyMHN0ZXBzLiUyMEluJTIwdGhlJTIwU29sdXRpb24lMjBzZWN0aW9uJTJDJTIwYmFzZWQlMjBvbiUyMHZhcmlvdXMlMjBhdHRlbXB0cyUyQyUyMGV4cGxvcmF0aW9ucyUyQyUyMGFuZCUyMHJlZmxlY3Rpb25zJTIwZnJvbSUyMHRoZSUyMFRob3VnaHQlMjBzZWN0aW9uJTJDJTIwc3lzdGVtYXRpY2FsbHklMjBwcmVzZW50JTIwdGhlJTIwZmluYWwlMjBzb2x1dGlvbiUyMHRoYXQlMjB5b3UlMjBkZWVtJTIwY29ycmVjdC4lMjBUaGUlMjBTb2x1dGlvbiUyMHNlY3Rpb24lMjBzaG91bGQlMjBiZSUyMGxvZ2ljYWwlMkMlMjBhY2N1cmF0ZSUyQyUyMGFuZCUyMGNvbmNpc2UlMjBhbmQlMjBkZXRhaWwlMjBuZWNlc3NhcnklMjBzdGVwcyUyMG5lZWRlZCUyMHRvJTIwcmVhY2glMjB0aGUlMjBjb25jbHVzaW9uLiUwQSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUwQVNvbHZlJTIwc3RlcCUyMGJ5JTIwc3RlcCUzQSUyMElmJTIwYSUyMHRyYWluJTIwdHJhdmVscyUyMDEyMCUyMG1pbGVzJTIwaW4lMjAyJTIwaG91cnMlMkMlMjB3aGF0JTIwaXMlMjBpdHMlMjBhdmVyYWdlJTIwc3BlZWQlM0YlM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQSUwQSUwQSUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRA==",highlighted:`--- SIMPLE_QA ---
Complete conversation <span class="hljs-built_in">format</span>:
&lt;|im_start|&gt;system
<span class="hljs-comment">## Metadata</span>

Knowledge Cutoff Date: June <span class="hljs-number">2025</span>
Today Date: 03 September <span class="hljs-number">2025</span>
Reasoning Mode: /no_think

<span class="hljs-comment">## Custom Instructions</span>

You are a helpful AI assistant named SmolLM, trained by Hugging Face.

&lt;|im_start|&gt;user
What <span class="hljs-keyword">is</span> machine learning?&lt;|im_end|&gt;


With generation prompt:
&lt;|im_start|&gt;system
<span class="hljs-comment">## Metadata</span>

Knowledge Cutoff Date: June <span class="hljs-number">2025</span>
Today Date: 03 September <span class="hljs-number">2025</span>
Reasoning Mode: /no_think

<span class="hljs-comment">## Custom Instructions</span>

You are a helpful AI assistant named SmolLM, trained by Hugging Face.

&lt;|im_start|&gt;user
What <span class="hljs-keyword">is</span> machine learning?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&lt;think&gt;

&lt;/think&gt;


==================================================

--- WITH_SYSTEM ---
Complete conversation <span class="hljs-built_in">format</span>:
&lt;|im_start|&gt;system
<span class="hljs-comment">## Metadata</span>

Knowledge Cutoff Date: June <span class="hljs-number">2025</span>
Today Date: 03 September <span class="hljs-number">2025</span>
Reasoning Mode: /no_think

<span class="hljs-comment">## Custom Instructions</span>

You are a helpful AI assistant specialized <span class="hljs-keyword">in</span> explaining technical concepts clearly.

&lt;|im_start|&gt;user
What <span class="hljs-keyword">is</span> machine learning?&lt;|im_end|&gt;


With generation prompt:
&lt;|im_start|&gt;system
<span class="hljs-comment">## Metadata</span>

Knowledge Cutoff Date: June <span class="hljs-number">2025</span>
Today Date: 03 September <span class="hljs-number">2025</span>
Reasoning Mode: /no_think

<span class="hljs-comment">## Custom Instructions</span>

You are a helpful AI assistant specialized <span class="hljs-keyword">in</span> explaining technical concepts clearly.

&lt;|im_start|&gt;user
What <span class="hljs-keyword">is</span> machine learning?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&lt;think&gt;

&lt;/think&gt;


==================================================

--- MULTI_TURN ---
Complete conversation <span class="hljs-built_in">format</span>:
&lt;|im_start|&gt;system
<span class="hljs-comment">## Metadata</span>

Knowledge Cutoff Date: June <span class="hljs-number">2025</span>
Today Date: 03 September <span class="hljs-number">2025</span>
Reasoning Mode: /no_think

<span class="hljs-comment">## Custom Instructions</span>

You are a math tutor.

&lt;|im_start|&gt;user
What <span class="hljs-keyword">is</span> calculus?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&lt;think&gt;

&lt;/think&gt;
Calculus <span class="hljs-keyword">is</span> a branch of mathematics that deals <span class="hljs-keyword">with</span> rates of change <span class="hljs-keyword">and</span> accumulation of quantities.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can you give me a simple example?&lt;|im_end|&gt;


With generation prompt:
&lt;|im_start|&gt;system
<span class="hljs-comment">## Metadata</span>

Knowledge Cutoff Date: June <span class="hljs-number">2025</span>
Today Date: 03 September <span class="hljs-number">2025</span>
Reasoning Mode: /no_think

<span class="hljs-comment">## Custom Instructions</span>

You are a math tutor.

&lt;|im_start|&gt;user
What <span class="hljs-keyword">is</span> calculus?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&lt;think&gt;

&lt;/think&gt;
Calculus <span class="hljs-keyword">is</span> a branch of mathematics that deals <span class="hljs-keyword">with</span> rates of change <span class="hljs-keyword">and</span> accumulation of quantities.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can you give me a simple example?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&lt;think&gt;

&lt;/think&gt;


==================================================

--- REASONING_TASK ---
Complete conversation <span class="hljs-built_in">format</span>:
&lt;|im_start|&gt;system
<span class="hljs-comment">## Metadata</span>

Knowledge Cutoff Date: June <span class="hljs-number">2025</span>
Today Date: 03 September <span class="hljs-number">2025</span>
Reasoning Mode: /think

<span class="hljs-comment">## Custom Instructions</span>

You are a helpful AI assistant named SmolLM, trained by Hugging Face. Your role <span class="hljs-keyword">as</span> an assistant involves thoroughly exploring questions through a systematic thinking process before providing the final precise <span class="hljs-keyword">and</span> accurate solutions. This requires engaging <span class="hljs-keyword">in</span> a comprehensive cycle of analysis, summarizing, exploration, reassessment, reflection, backtracking, <span class="hljs-keyword">and</span> iteration to develop well-considered thinking process. Please structure your response into two main sections: Thought <span class="hljs-keyword">and</span> Solution using the specified <span class="hljs-built_in">format</span>: &lt;think&gt; Thought section &lt;/think&gt; Solution section. In the Thought section, detail your reasoning process <span class="hljs-keyword">in</span> steps. Each step should include detailed considerations such <span class="hljs-keyword">as</span> analysing questions, summarizing relevant findings, brainstorming new ideas, verifying the accuracy of the current steps, refining <span class="hljs-built_in">any</span> errors, <span class="hljs-keyword">and</span> revisiting previous steps. In the Solution section, based on various attempts, explorations, <span class="hljs-keyword">and</span> reflections <span class="hljs-keyword">from</span> the Thought section, systematically present the final solution that you deem correct. The Solution section should be logical, accurate, <span class="hljs-keyword">and</span> concise <span class="hljs-keyword">and</span> detail necessary steps needed to reach the conclusion.

&lt;|im_start|&gt;user
Solve step by step: If a train travels <span class="hljs-number">120</span> miles <span class="hljs-keyword">in</span> <span class="hljs-number">2</span> hours, what <span class="hljs-keyword">is</span> its average speed?&lt;|im_end|&gt;


With generation prompt:
&lt;|im_start|&gt;system
<span class="hljs-comment">## Metadata</span>

Knowledge Cutoff Date: June <span class="hljs-number">2025</span>
Today Date: 03 September <span class="hljs-number">2025</span>
Reasoning Mode: /think

<span class="hljs-comment">## Custom Instructions</span>

You are a helpful AI assistant named SmolLM, trained by Hugging Face. Your role <span class="hljs-keyword">as</span> an assistant involves thoroughly exploring questions through a systematic thinking process before providing the final precise <span class="hljs-keyword">and</span> accurate solutions. This requires engaging <span class="hljs-keyword">in</span> a comprehensive cycle of analysis, summarizing, exploration, reassessment, reflection, backtracking, <span class="hljs-keyword">and</span> iteration to develop well-considered thinking process. Please structure your response into two main sections: Thought <span class="hljs-keyword">and</span> Solution using the specified <span class="hljs-built_in">format</span>: &lt;think&gt; Thought section &lt;/think&gt; Solution section. In the Thought section, detail your reasoning process <span class="hljs-keyword">in</span> steps. Each step should include detailed considerations such <span class="hljs-keyword">as</span> analysing questions, summarizing relevant findings, brainstorming new ideas, verifying the accuracy of the current steps, refining <span class="hljs-built_in">any</span> errors, <span class="hljs-keyword">and</span> revisiting previous steps. In the Solution section, based on various attempts, explorations, <span class="hljs-keyword">and</span> reflections <span class="hljs-keyword">from</span> the Thought section, systematically present the final solution that you deem correct. The Solution section should be logical, accurate, <span class="hljs-keyword">and</span> concise <span class="hljs-keyword">and</span> detail necessary steps needed to reach the conclusion.

&lt;|im_start|&gt;user
Solve step by step: If a train travels <span class="hljs-number">120</span> miles <span class="hljs-keyword">in</span> <span class="hljs-number">2</span> hours, what <span class="hljs-keyword">is</span> its average speed?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant


==================================================`,wrap:!1}}),ns=new m({props:{title:"Compare Base vs Instruct Model Responses",local:"compare-base-vs-instruct-model-responses",headingTag:"h3"}}),es=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Test the same prompt on both models</span>
test_prompt = <span class="hljs-string">&quot;Explain quantum computing in simple terms.&quot;</span>

<span class="hljs-comment"># Prepare the prompt for base model (no chat template)</span>
base_inputs = base_tokenizer(test_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Prepare the prompt for instruct model (with chat template)</span>
instruct_messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: test_prompt}]
instruct_formatted = instruct_tokenizer.apply_chat_template(
    instruct_messages, 
    tokenize=<span class="hljs-literal">False</span>, 
    add_generation_prompt=<span class="hljs-literal">True</span>
)
instruct_inputs = instruct_tokenizer(instruct_formatted, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate responses</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== Model comparison ===\\n&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🤖 BASE MODEL RESPONSE:&quot;</span>)
<span class="hljs-keyword">with</span> torch.no_grad():
    base_outputs = base_model.generate(
        **base_inputs,
        max_new_tokens=<span class="hljs-number">150</span>,
        temperature=<span class="hljs-number">0.7</span>,
        do_sample=<span class="hljs-literal">True</span>,
        pad_token_id=base_tokenizer.eos_token_id
    )
    base_response = base_tokenizer.decode(base_outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
    <span class="hljs-built_in">print</span>(base_response[<span class="hljs-built_in">len</span>(test_prompt):])  <span class="hljs-comment"># Show only the generated part</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Instruct model response:&quot;</span>)
<span class="hljs-keyword">with</span> torch.no_grad():
    instruct_outputs = instruct_model.generate(
        **instruct_inputs,
        max_new_tokens=<span class="hljs-number">150</span>,
        temperature=<span class="hljs-number">0.7</span>,
        do_sample=<span class="hljs-literal">True</span>,
        pad_token_id=instruct_tokenizer.eos_token_id
    )
    instruct_response = instruct_tokenizer.decode(instruct_outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
    <span class="hljs-comment"># Extract only the assistant&#x27;s response</span>
    assistant_start = instruct_response.find(<span class="hljs-string">&quot;&lt;|im_start|&gt;assistant\\n&quot;</span>) + <span class="hljs-built_in">len</span>(<span class="hljs-string">&quot;&lt;|im_start|&gt;assistant\\n&quot;</span>)
    assistant_response = instruct_response[assistant_start:].split(<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-built_in">print</span>(assistant_response)`,wrap:!1}}),ps=new r({props:{code:"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",highlighted:`=== Model comparison ===

🤖 BASE MODEL RESPONSE:
 Why <span class="hljs-keyword">is</span> it thought to be superior to our current technology? How <span class="hljs-keyword">is</span> it superior? What <span class="hljs-keyword">is</span> it<span class="hljs-string">&#x27;s limit?
Quantum computing is based on the fact that in quantum mechanics, a particle can be in multiple states at the same time. This is called superposition. But a single particle can not be in multiple locations at the same time. That is called entanglement. So, how can you have a particle in multiple locations at the same time? Quantum mechanics says that if you measure the location of a particle, it will randomly jump to a particular location. So, if you have 1000 particles, you can have each particle in 1000 different locations at the same time.
This is very useful for solving problems. For example

==================================================
Instruct model response:
nowledge Cutoff Date: June 2025
Today Date: 03 September 2025
Reasoning Mode: /no_think

## Custom Instructions

You are a helpful AI assistant named SmolLM, trained by Hugging Face.

user
Explain quantum computing in simple terms.
assistant
&lt;think&gt;

&lt;/think&gt;
Quantum computing is a type of computing that uses quantum bits, or qubits, to perform calculations. In traditional computers, we use bits, which can be either 0 or 1. But in quantum computing, we use qubits that can exist in multiple states at once, like both 0 and 1 simultaneously.

Think of it like flipping a coin. A regular coin can land on either heads or tails, but a quantum coin can land on both heads and tails at the same time. This property is called superposition.

Another unique aspect of quantum computing is entanglement. Imagine two coins that are linked together. If one coin lands on heads, the other coin will always land on tails, no matter how far apart they are</span>`,wrap:!1}}),ys=new m({props:{title:"Test Dual-Mode Reasoning",local:"test-dual-mode-reasoning",headingTag:"h3"}}),Js=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Test SmolLM3&#x27;s reasoning capabilities</span>
reasoning_prompts = [
    <span class="hljs-string">&quot;What is 15 × 24? Show your work.&quot;</span>,
    <span class="hljs-string">&quot;A recipe calls for 2 cups of flour for 12 cookies. How much flour is needed for 30 cookies?&quot;</span>,
    <span class="hljs-string">&quot;If I have $50 and spend $18.75 on lunch and $12.30 on a book, how much money do I have left?&quot;</span>
]

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== TESTING REASONING CAPABILITIES ===\\n&quot;</span>)

<span class="hljs-keyword">for</span> i, prompt <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(reasoning_prompts, <span class="hljs-number">1</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Problem <span class="hljs-subst">{i}</span>: <span class="hljs-subst">{prompt}</span>&quot;</span>)
    
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
    formatted_prompt = instruct_tokenizer.apply_chat_template(
        messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>
    )
    inputs = instruct_tokenizer(formatted_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
    
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = instruct_model.generate(
            **inputs,
            max_new_tokens=<span class="hljs-number">200</span>,
            temperature=<span class="hljs-number">0.3</span>,  <span class="hljs-comment"># Lower temperature for more consistent reasoning</span>
            do_sample=<span class="hljs-literal">True</span>,
            pad_token_id=instruct_tokenizer.eos_token_id
        )
        response = instruct_tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
        assistant_start = response.find(<span class="hljs-string">&quot;&lt;|im_start|&gt;assistant\\n&quot;</span>) + <span class="hljs-built_in">len</span>(<span class="hljs-string">&quot;&lt;|im_start|&gt;assistant\\n&quot;</span>)
        assistant_response = response[assistant_start:].split(<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>)[<span class="hljs-number">0</span>]
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{assistant_response}</span>&quot;</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;-&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),is=new r({props:{code:"JTBBJTNEJTNEJTNEJTIwVEVTVElORyUyMFJFQVNPTklORyUyMENBUEFCSUxJVElFUyUyMCUzRCUzRCUzRCUwQSUwQVRoaW5raW5nJTIwcHJvbXB0JTNBJTIwJTJGbm9fdGhpbmslMEFQcm9ibGVtJTIwMSUzQSUyMFdoYXQlMjBpcyUyMDE1JTIwJUMzJTk3JTIwMjQlM0YlMjBTaG93JTIweW91ciUyMHdvcmsuJTBBQW5zd2VyJTNBJTIwbm93bGVkZ2UlMjBDdXRvZmYlMjBEYXRlJTNBJTIwSnVuZSUyMDIwMjUlMEFUb2RheSUyMERhdGUlM0ElMjAwMyUyMFNlcHRlbWJlciUyMDIwMjUlMEFSZWFzb25pbmclMjBNb2RlJTNBJTIwJTJGbm9fdGhpbmslMEElMEElMjMlMjMlMjBDdXN0b20lMjBJbnN0cnVjdGlvbnMlMEElMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMEFJJTIwYXNzaXN0YW50JTIwbmFtZWQlMjBTbW9sTE0lMkMlMjB0cmFpbmVkJTIwYnklMjBIdWdnaW5nJTIwRmFjZS4lMEElMEF1c2VyJTBBV2hhdCUyMGlzJTIwMTUlMjAlQzMlOTclMjAyNCUzRiUyMFNob3clMjB5b3VyJTIwd29yay4lMEFhc3Npc3RhbnQlMEElM0N0aGluayUzRSUwQSUwQSUzQyUyRnRoaW5rJTNFJTBBVG8lMjBmaW5kJTIwdGhlJTIwcHJvZHVjdCUyMG9mJTIwMTUlMjBhbmQlMjAyNCUyQyUyMHdlJTIwY2FuJTIwdXNlJTIwdGhlJTIwc3RhbmRhcmQlMjBtdWx0aXBsaWNhdGlvbiUyMGFsZ29yaXRobS4lMjBIZXJlJ3MlMjBob3clMjB3ZSUyMGNhbiUyMGRvJTIwaXQlMjBzdGVwJTIwYnklMjBzdGVwJTNBJTBB",highlighted:`
=== TESTING REASONING CAPABILITIES ===

Thinking prompt: /no_think
Problem <span class="hljs-number">1</span>: What <span class="hljs-keyword">is</span> <span class="hljs-number">15</span> × <span class="hljs-number">24</span>? Show your work.
Answer: nowledge Cutoff Date: June <span class="hljs-number">2025</span>
Today Date: 03 September <span class="hljs-number">2025</span>
Reasoning Mode: /no_think

<span class="hljs-comment">## Custom Instructions</span>

You are a helpful AI assistant named SmolLM, trained by Hugging Face.

user
What <span class="hljs-keyword">is</span> <span class="hljs-number">15</span> × <span class="hljs-number">24</span>? Show your work.
assistant
&lt;think&gt;

&lt;/think&gt;
To find the product of <span class="hljs-number">15</span> <span class="hljs-keyword">and</span> <span class="hljs-number">24</span>, we can use the standard multiplication algorithm. Here<span class="hljs-string">&#x27;s how we can do it step by step:
</span>`,wrap:!1}}),Ts=new m({props:{title:"× 24",local:"-24",headingTag:"h2"}}),js=new r({props:{code:"JTBBRmlyc3QlMkMlMjB3ZSUyMG11bHRpcGx5JTIwMTUlMjBieSUyMDQlMjAodGhlJTIwdW5pdHMlMjBkaWdpdCUyMG9mJTIwMjQpJTNBJTBB",highlighted:`
<span class="hljs-attribute">First</span>, we multiply <span class="hljs-number">15</span> by <span class="hljs-number">4</span> (the units digit of <span class="hljs-number">24</span>):
`,wrap:!1}}),os=new m({props:{title:"× 24",local:"-24",headingTag:"h2"}}),ws=new r({props:{code:"JTBBTmV4dCUyQyUyMHdlJTIwbXVsdGlwbHklMjAxNSUyMGJ5JTIwMjAlMjAodGhlJTIwdGVucyUyMGRpZ2l0JTIwb2YlMjAyNCUyQyUyMHNoaWZ0ZWQlMjBvbmUlMjBwbGFjZSUyMHRvJTIwdGhlJTIwbGVmdCklM0ElMEE=",highlighted:`
Next, we <span class="hljs-built_in">multiply</span> <span class="hljs-number">15</span> <span class="hljs-keyword">by</span> <span class="hljs-number">20</span> (<span class="hljs-keyword">the</span> tens digit <span class="hljs-keyword">of</span> <span class="hljs-number">24</span>, shifted <span class="hljs-literal">one</span> place <span class="hljs-built_in">to</span> <span class="hljs-keyword">the</span> left):
`,wrap:!1}}),hs=new m({props:{title:"× 24",local:"-24",headingTag:"h2"}}),rs=new m({props:{title:"300 (15 × 20)",local:"300-15--20",headingTag:"h2"}}),ms=new r({props:{code:"JTBBTm93JTJDJTIwd2UlMjBhZGQlMjB0aGUlMjB0d28lMjBwYXJ0aWFsJTIwcHJvZHVjdHMlM0ElMEE=",highlighted:`
Now, we <span class="hljs-built_in">add</span> <span class="hljs-keyword">the</span> <span class="hljs-literal">two</span> partial products:
`,wrap:!1}}),us=new m({props:{title:"× 24",local:"-24",headingTag:"h2"}}),ds=new m({props:{title:"300 (15 × 20)",local:"300-15--20",headingTag:"h2"}}),bs=new r({props:{code:"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",highlighted:`
So, <span class="hljs-number">15</span> × <span class="hljs-number">24</span> = <span class="hljs-number">360</span>.

--------------------------------------------------

Problem <span class="hljs-number">2</span>: A recipe calls <span class="hljs-keyword">for</span> <span class="hljs-number">2</span> cups <span class="hljs-keyword">of</span> flour <span class="hljs-keyword">for</span> <span class="hljs-number">12</span> cookies. How much flour <span class="hljs-built_in">is</span> needed <span class="hljs-keyword">for</span> <span class="hljs-number">30</span> cookies?
<span class="hljs-symbol">Answer:</span> nowledge Cutoff <span class="hljs-type">Date</span>: June <span class="hljs-number">2025</span>
Today <span class="hljs-type">Date</span>: <span class="hljs-number">03</span> September <span class="hljs-number">2025</span>
Reasoning Mode: /no_think

## <span class="hljs-keyword">Custom</span> Instructions

You are a helpful AI assistant named SmolLM, trained <span class="hljs-keyword">by</span> Hugging Face.

user
A recipe calls <span class="hljs-keyword">for</span> <span class="hljs-number">2</span> cups <span class="hljs-keyword">of</span> flour <span class="hljs-keyword">for</span> <span class="hljs-number">12</span> cookies. How much flour <span class="hljs-built_in">is</span> needed <span class="hljs-keyword">for</span> <span class="hljs-number">30</span> cookies?
assistant
&lt;think&gt;

&lt;/think&gt;
<span class="hljs-keyword">To</span> solve this problem, we need <span class="hljs-keyword">to</span> determine the amount <span class="hljs-keyword">of</span> flour needed per cookie <span class="hljs-built_in">and</span> <span class="hljs-keyword">then</span> multiply that <span class="hljs-keyword">by</span> the number <span class="hljs-keyword">of</span> cookies we want <span class="hljs-keyword">to</span> make.

First, <span class="hljs-keyword">let</span><span class="hljs-comment">&#x27;s find out how much flour is needed per cookie. The recipe calls for 2 cups of flour for 12 cookies. To find the amount of flour per cookie, we divide the total amount of flour by the number of cookies:</span>

<span class="hljs-number">2</span> cups / <span class="hljs-number">12</span> cookies = <span class="hljs-number">1</span>/<span class="hljs-number">6</span> cup per cookie

Now that we know how much flour <span class="hljs-built_in">is</span> needed per cookie, we can multiply that <span class="hljs-keyword">by</span> the number <span class="hljs-keyword">of</span> cookies we want <span class="hljs-keyword">to</span> make (<span class="hljs-number">30</span>):

<span class="hljs-number">1</span>/<span class="hljs-number">6</span> cup per cookie * <span class="hljs-number">30</span> cookies = <span class="hljs-number">5</span> cups

So, <span class="hljs-keyword">to</span> make <span class="hljs-number">30</span> cookies, you would need <span class="hljs-number">5</span> cups <span class="hljs-keyword">of</span> flour.

--------------------------------------------------

Problem <span class="hljs-number">3</span>: <span class="hljs-keyword">If</span> I have $<span class="hljs-number">50</span> <span class="hljs-built_in">and</span> spend $<span class="hljs-number">18.75</span> <span class="hljs-keyword">on</span> lunch <span class="hljs-built_in">and</span> $<span class="hljs-number">12.30</span> <span class="hljs-keyword">on</span> a book, how much money <span class="hljs-keyword">do</span> I have left?
<span class="hljs-symbol">Answer:</span> nowledge Cutoff <span class="hljs-type">Date</span>: June <span class="hljs-number">2025</span>
Today <span class="hljs-type">Date</span>: <span class="hljs-number">03</span> September <span class="hljs-number">2025</span>
Reasoning Mode: /no_think

## <span class="hljs-keyword">Custom</span> Instructions

You are a helpful AI assistant named SmolLM, trained <span class="hljs-keyword">by</span> Hugging Face.

user
<span class="hljs-keyword">If</span> I have $<span class="hljs-number">50</span> <span class="hljs-built_in">and</span> spend $<span class="hljs-number">18.75</span> <span class="hljs-keyword">on</span> lunch <span class="hljs-built_in">and</span> $<span class="hljs-number">12.30</span> <span class="hljs-keyword">on</span> a book, how much money <span class="hljs-keyword">do</span> I have left?
assistant
&lt;think&gt;

&lt;/think&gt;
<span class="hljs-keyword">To</span> find out how much money you have left, you need <span class="hljs-keyword">to</span> subtract the total amount spent <span class="hljs-keyword">from</span> your initial amount.

First, calculate the total amount spent <span class="hljs-keyword">on</span> lunch <span class="hljs-built_in">and</span> the book:
$<span class="hljs-number">18.75</span> (lunch) + $<span class="hljs-number">12.30</span> (book) = $<span class="hljs-number">31.05</span>

Now, subtract the total amount spent <span class="hljs-keyword">from</span> your initial amount:
$<span class="hljs-number">50</span> (initial amount) - $<span class="hljs-number">31.05</span> (total spent) = $<span class="hljs-number">18.95</span>

So, you have $<span class="hljs-number">18.95</span> left.

--------------------------------------------------

Thinking prompt: /think
Problem <span class="hljs-number">1</span>: What <span class="hljs-built_in">is</span> <span class="hljs-number">15</span> × <span class="hljs-number">24</span>? Show your work.
<span class="hljs-symbol">Answer:</span> nowledge Cutoff <span class="hljs-type">Date</span>: June <span class="hljs-number">2025</span>
Today <span class="hljs-type">Date</span>: <span class="hljs-number">03</span> September <span class="hljs-number">2025</span>
Reasoning Mode: /think

## <span class="hljs-keyword">Custom</span> Instructions

You are a helpful AI assistant named SmolLM, trained <span class="hljs-keyword">by</span> Hugging Face. Your role <span class="hljs-keyword">as</span> an assistant involves thoroughly exploring questions through a systematic thinking process before providing the final precise <span class="hljs-built_in">and</span> accurate solutions. This requires engaging <span class="hljs-keyword">in</span> a comprehensive cycle <span class="hljs-keyword">of</span> analysis, summarizing, exploration, reassessment, reflection, backtracking, <span class="hljs-built_in">and</span> iteration <span class="hljs-keyword">to</span> develop well-considered thinking process. Please <span class="hljs-keyword">structure</span> your response <span class="hljs-keyword">into</span> two main sections: Thought <span class="hljs-built_in">and</span> Solution <span class="hljs-keyword">using</span> the specified format: &lt;think&gt; Thought section &lt;/think&gt; Solution section. <span class="hljs-keyword">In</span> the Thought section, detail your reasoning process <span class="hljs-keyword">in</span> steps. <span class="hljs-keyword">Each</span> <span class="hljs-keyword">step</span> should include detailed considerations such <span class="hljs-keyword">as</span> analysing questions, summarizing relevant findings, brainstorming <span class="hljs-built_in">new</span> ideas, verifying the accuracy <span class="hljs-keyword">of</span> the current steps, refining any errors, <span class="hljs-built_in">and</span> revisiting previous steps. <span class="hljs-keyword">In</span> the Solution section, based <span class="hljs-keyword">on</span> various attempts, explorations, <span class="hljs-built_in">and</span> reflections <span class="hljs-keyword">from</span> the Thought section, systematically present the final solution that you deem correct. The Solution section should be logical, accurate, <span class="hljs-built_in">and</span> concise <span class="hljs-built_in">and</span> detail necessary steps needed <span class="hljs-keyword">to</span> reach the conclusion.

user
What <span class="hljs-built_in">is</span> <span class="hljs-number">15</span> × <span class="hljs-number">24</span>? Show your work.
assistant
&lt;think&gt;
Okay, <span class="hljs-keyword">let</span><span class="hljs-comment">&#x27;s see. I need to calculate 15 multiplied by 24. Hmm, how do I do that? I remember there are a few methods. Maybe the standard multiplication algorithm? Or maybe breaking it down into smaller parts. Let me try both ways to make sure I get the right answer.</span>

First, the standard way. <span class="hljs-keyword">Let</span> <span class="hljs-keyword">me</span> write it out <span class="hljs-built_in">like</span> I<span class="hljs-comment">&#x27;m doing long multiplication. So, 15 times 24. I can think of 24 as 20 + 4. So maybe I can break it down into 15 times 20 plus 15 times 4. That might be easier.</span>

Starting <span class="hljs-keyword">with</span> <span class="hljs-number">15</span> times <span class="hljs-number">20</span>. Well, <span class="hljs-number">15</span> times <span class="hljs-number">2</span> <span class="hljs-built_in">is</span> <span class="hljs-number">30</span>, so adding a zero at the <span class="hljs-keyword">end</span> makes it <span class="hljs-number">300</span>. So <span class="hljs-number">15</span> × <span class="hljs-number">20</span> = <span class="hljs-number">300</span>. Got that part.

Now, <span class="hljs-number">15</span> times <span class="hljs-number">4</span>. <span class="hljs-keyword">Let</span> <span class="hljs-keyword">me</span> calculate that. <span class="hljs-number">15</span> times <span class="hljs-number">4</span> <span class="hljs-built_in">is</span> <span class="hljs-number">60</span>. Right? Because <span class="hljs-number">10</span>

--------------------------------------------------

Problem <span class="hljs-number">2</span>: A recipe calls <span class="hljs-keyword">for</span> <span class="hljs-number">2</span> cups <span class="hljs-keyword">of</span> flour <span class="hljs-keyword">for</span> <span class="hljs-number">12</span> cookies. How much flour <span class="hljs-built_in">is</span> needed <span class="hljs-keyword">for</span> <span class="hljs-number">30</span> cookies?
<span class="hljs-symbol">Answer:</span> nowledge Cutoff <span class="hljs-type">Date</span>: June <span class="hljs-number">2025</span>
Today <span class="hljs-type">Date</span>: <span class="hljs-number">03</span> September <span class="hljs-number">2025</span>
Reasoning Mode: /think

## <span class="hljs-keyword">Custom</span> Instructions

You are a helpful AI assistant named SmolLM, trained <span class="hljs-keyword">by</span> Hugging Face. Your role <span class="hljs-keyword">as</span> an assistant involves thoroughly exploring questions through a systematic thinking process before providing the final precise <span class="hljs-built_in">and</span> accurate solutions. This requires engaging <span class="hljs-keyword">in</span> a comprehensive cycle <span class="hljs-keyword">of</span> analysis, summarizing, exploration, reassessment, reflection, backtracking, <span class="hljs-built_in">and</span> iteration <span class="hljs-keyword">to</span> develop well-considered thinking process. Please <span class="hljs-keyword">structure</span> your response <span class="hljs-keyword">into</span> two main sections: Thought <span class="hljs-built_in">and</span> Solution <span class="hljs-keyword">using</span> the specified format: &lt;think&gt; Thought section &lt;/think&gt; Solution section. <span class="hljs-keyword">In</span> the Thought section, detail your reasoning process <span class="hljs-keyword">in</span> steps. <span class="hljs-keyword">Each</span> <span class="hljs-keyword">step</span> should include detailed considerations such <span class="hljs-keyword">as</span> analysing questions, summarizing relevant findings, brainstorming <span class="hljs-built_in">new</span> ideas, verifying the accuracy <span class="hljs-keyword">of</span> the current steps, refining any errors, <span class="hljs-built_in">and</span> revisiting previous steps. <span class="hljs-keyword">In</span> the Solution section, based <span class="hljs-keyword">on</span> various attempts, explorations, <span class="hljs-built_in">and</span> reflections <span class="hljs-keyword">from</span> the Thought section, systematically present the final solution that you deem correct. The Solution section should be logical, accurate, <span class="hljs-built_in">and</span> concise <span class="hljs-built_in">and</span> detail necessary steps needed <span class="hljs-keyword">to</span> reach the conclusion.

user
A recipe calls <span class="hljs-keyword">for</span> <span class="hljs-number">2</span> cups <span class="hljs-keyword">of</span> flour <span class="hljs-keyword">for</span> <span class="hljs-number">12</span> cookies. How much flour <span class="hljs-built_in">is</span> needed <span class="hljs-keyword">for</span> <span class="hljs-number">30</span> cookies?
assistant
&lt;think&gt;
Okay, so I need <span class="hljs-keyword">to</span> figure out how much flour <span class="hljs-built_in">is</span> needed <span class="hljs-keyword">for</span> <span class="hljs-number">30</span> cookies <span class="hljs-keyword">if</span> the recipe calls <span class="hljs-keyword">for</span> <span class="hljs-number">2</span> cups <span class="hljs-keyword">of</span> flour <span class="hljs-keyword">for</span> <span class="hljs-number">12</span> cookies. Hmm, <span class="hljs-keyword">let</span><span class="hljs-comment">&#x27;s see. I think this is a proportion problem. If 12 cookies require 2 cups, then I need to find out how much flour is needed for 30 cookies. </span>

First, maybe I should determine how much flour <span class="hljs-built_in">is</span> needed per cookie. <span class="hljs-keyword">If</span> <span class="hljs-number">12</span> cookies <span class="hljs-keyword">take</span> <span class="hljs-number">2</span> cups, <span class="hljs-keyword">then</span> per cookie it would be <span class="hljs-number">2</span> divided <span class="hljs-keyword">by</span> <span class="hljs-number">12</span>. <span class="hljs-keyword">Let</span> <span class="hljs-keyword">me</span> write that down: <span class="hljs-number">2</span> cups / <span class="hljs-number">12</span> cookies. That simplifies <span class="hljs-keyword">to</span> <span class="hljs-number">1</span>/<span class="hljs-number">6</span> cup per cookie. Wait, <span class="hljs-number">2</span> divided <span class="hljs-keyword">by</span> <span class="hljs-number">12</span> <span class="hljs-built_in">is</span> <span class="hljs-number">1</span>/<span class="hljs-number">6</span>? <span class="hljs-keyword">Let</span> <span class="hljs-keyword">me</span> check that again. <span class="hljs-number">2</span> divided <span class="hljs-keyword">by</span> <span class="hljs-number">12</span> <span class="hljs-built_in">is</span> indeed <span class="hljs-number">1</span>/<span class="hljs-number">6</span>. Yeah, because <span class="hljs-number">12</span> divided <span class="hljs-keyword">by</span> <span class="hljs-number">6</span> <span class="hljs-built_in">is</span> <span class="hljs-number">2</span>, so <span class="hljs-number">2</span> divided <span class="hljs-keyword">by</span> <span class="hljs-number">12</span> <span class="hljs-built_in">is</span> <span class="hljs-number">1</span>/<span class="hljs-number">6</span>. So <span class="hljs-keyword">each</span> cookie needs 

--------------------------------------------------

Problem <span class="hljs-number">3</span>: <span class="hljs-keyword">If</span> I have $<span class="hljs-number">50</span> <span class="hljs-built_in">and</span> spend $<span class="hljs-number">18.75</span> <span class="hljs-keyword">on</span> lunch <span class="hljs-built_in">and</span> $<span class="hljs-number">12.30</span> <span class="hljs-keyword">on</span> a book, how much money <span class="hljs-keyword">do</span> I have left?
<span class="hljs-symbol">Answer:</span> nowledge Cutoff <span class="hljs-type">Date</span>: June <span class="hljs-number">2025</span>
Today <span class="hljs-type">Date</span>: <span class="hljs-number">03</span> September <span class="hljs-number">2025</span>
Reasoning Mode: /think

## <span class="hljs-keyword">Custom</span> Instructions

You are a helpful AI assistant named SmolLM, trained <span class="hljs-keyword">by</span> Hugging Face. Your role <span class="hljs-keyword">as</span> an assistant involves thoroughly exploring questions through a systematic thinking process before providing the final precise <span class="hljs-built_in">and</span> accurate solutions. This requires engaging <span class="hljs-keyword">in</span> a comprehensive cycle <span class="hljs-keyword">of</span> analysis, summarizing, exploration, reassessment, reflection, backtracking, <span class="hljs-built_in">and</span> iteration <span class="hljs-keyword">to</span> develop well-considered thinking process. Please <span class="hljs-keyword">structure</span> your response <span class="hljs-keyword">into</span> two main sections: Thought <span class="hljs-built_in">and</span> Solution <span class="hljs-keyword">using</span> the specified format: &lt;think&gt; Thought section &lt;/think&gt; Solution section. <span class="hljs-keyword">In</span> the Thought section, detail your reasoning process <span class="hljs-keyword">in</span> steps. <span class="hljs-keyword">Each</span> <span class="hljs-keyword">step</span> should include detailed considerations such <span class="hljs-keyword">as</span> analysing questions, summarizing relevant findings, brainstorming <span class="hljs-built_in">new</span> ideas, verifying the accuracy <span class="hljs-keyword">of</span> the current steps, refining any errors, <span class="hljs-built_in">and</span> revisiting previous steps. <span class="hljs-keyword">In</span> the Solution section, based <span class="hljs-keyword">on</span> various attempts, explorations, <span class="hljs-built_in">and</span> reflections <span class="hljs-keyword">from</span> the Thought section, systematically present the final solution that you deem correct. The Solution section should be logical, accurate, <span class="hljs-built_in">and</span> concise <span class="hljs-built_in">and</span> detail necessary steps needed <span class="hljs-keyword">to</span> reach the conclusion.

user
<span class="hljs-keyword">If</span> I have $<span class="hljs-number">50</span> <span class="hljs-built_in">and</span> spend $<span class="hljs-number">18.75</span> <span class="hljs-keyword">on</span> lunch <span class="hljs-built_in">and</span> $<span class="hljs-number">12.30</span> <span class="hljs-keyword">on</span> a book, how much money <span class="hljs-keyword">do</span> I have left?
assistant
&lt;think&gt;
Okay, <span class="hljs-keyword">let</span><span class="hljs-comment">&#x27;s see. The problem is about calculating how much money is left after spending on lunch and a book. I need to start with the initial amount of $50 and then subtract the amounts spent on lunch and the book.</span>

First, I should add up the total amount spent. The lunch cost $<span class="hljs-number">18.75</span> <span class="hljs-built_in">and</span> the book cost $<span class="hljs-number">12.30</span>. <span class="hljs-keyword">To</span> add these two amounts together, I need <span class="hljs-keyword">to</span> make sure they are <span class="hljs-keyword">in</span> the same units, which they already are since both are <span class="hljs-keyword">in</span> dollars. So, adding $<span class="hljs-number">18.75</span> <span class="hljs-built_in">and</span> $<span class="hljs-number">12.30</span>. <span class="hljs-keyword">Let</span> <span class="hljs-keyword">me</span> <span class="hljs-keyword">do</span> that <span class="hljs-keyword">step</span> <span class="hljs-keyword">by</span> <span class="hljs-keyword">step</span>.

Starting <span class="hljs-keyword">with</span> the dollars: <span class="hljs-number">18</span> dollars plus <span class="hljs-number">12</span> dollars <span class="hljs-built_in">is</span> <span class="hljs-number">30</span> dollars. <span class="hljs-keyword">Then</span> the cents: <span class="hljs-number">75</span> cents plus <span class="hljs-number">30</span> cents <span class="hljs-built_in">is</span> <span class="hljs-number">105</span> cents. Now, <span class="hljs-number">105</span> cents <span class="hljs-built_in">is</span> equal <span class="hljs-keyword">to</span> $<span class="hljs-number">1.05</span> because <span class="hljs-number">100</span> cents make a dollar, so <span class="hljs-number">105</span> cents <span class="hljs-built_in">is</span> <span class="hljs-number">1</span> dollar <span class="hljs-built_in">and</span> <span class="hljs-number">5</span> cents. Therefore, adding the dollars <span class="hljs-built_in">and</span> cents together

--------------------------------------------------
`,wrap:!1}}),Is=new m({props:{title:"Validation",local:"validation",headingTag:"h3"}}),Gs=new m({props:{title:"Exercise 2: Dataset Processing for SFT",local:"exercise-2-dataset-processing-for-sft",headingTag:"h2"}}),Ns=new m({props:{title:"Explore the SmolTalk2 Dataset",local:"explore-the-smoltalk2-dataset",headingTag:"h3"}}),Rs=new r({props:{code:"JTIzJTIwTG9hZCUyMGFuZCUyMGV4cGxvcmUlMjB0aGUlMjBTbW9sVGFsazIlMjBkYXRhc2V0JTBBcHJpbnQoJTIyJTNEJTNEJTNEJTIwRVhQTE9SSU5HJTIwU01PTFRBTEsyJTIwREFUQVNFVCUyMCUzRCUzRCUzRCU1Q24lMjIpJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMFNGVCUyMHN1YnNldCUwQWRhdGFzZXRfZGljdCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZVRCJTJGc21vbHRhbGsyJTIyJTJDJTIwJTIyU0ZUJTIyKSUwQXByaW50KGYlMjJUb3RhbCUyMHNwbGl0cyUzQSUyMCU3QmxlbihkYXRhc2V0X2RpY3QpJTdEJTIyKSUwQXByaW50KGYlMjJBdmFpbGFibGUlMjBzcGxpdHMlM0ElMjAlN0JsaXN0KGRhdGFzZXRfZGljdC5rZXlzKCkpJTdEJTIyKSUwQXByaW50KGYlMjJOdW1iZXIlMjBvZiUyMHRvdGFsJTIwcm93cyUzQSUyMCU3QnN1bSglNUJkYXRhc2V0X2RpY3QlNUJkJTVELm51bV9yb3dzJTIwZm9yJTIwZCUyMGluJTIwZGF0YXNldF9kaWN0JTVEKSU3RCUyMiklMEFwcmludChmJTIyRGF0YXNldCUyMHN0cnVjdHVyZSUzQSUyMCU3QmRhdGFzZXRfZGljdCU3RCUyMik=",highlighted:`<span class="hljs-comment"># Load and explore the SmolTalk2 dataset</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== EXPLORING SMOLTALK2 DATASET ===\\n&quot;</span>)

<span class="hljs-comment"># Load the SFT subset</span>
dataset_dict = load_dataset(<span class="hljs-string">&quot;HuggingFaceTB/smoltalk2&quot;</span>, <span class="hljs-string">&quot;SFT&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total splits: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset_dict)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Available splits: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(dataset_dict.keys())}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Number of total rows: <span class="hljs-subst">{<span class="hljs-built_in">sum</span>([dataset_dict[d].num_rows <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset_dict])}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Dataset structure: <span class="hljs-subst">{dataset_dict}</span>&quot;</span>)`,wrap:!1}}),Vs=new r({props:{code:"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",highlighted:`=== EXPLORING SMOLTALK2 DATASET ===

Resolving data files: <span class="hljs-number">100</span>%
 <span class="hljs-number">124</span>/<span class="hljs-number">124</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">9963.48</span>it/s]
Resolving data files: <span class="hljs-number">100</span>%
 <span class="hljs-number">113</span>/<span class="hljs-number">113</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">57.54</span>it/s]
Resolving data files: <span class="hljs-number">100</span>%
 <span class="hljs-number">113</span>/<span class="hljs-number">113</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">114.07</span>it/s]
Loading dataset shards: <span class="hljs-number">100</span>%
 <span class="hljs-number">105</span>/<span class="hljs-number">105</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">2570.62</span>it/s]
Total splits: <span class="hljs-number">25</span>
Available splits: [<span class="hljs-string">&#x27;LongAlign_64k_Qwen3_32B_yarn_131k_think&#x27;</span>, <span class="hljs-string">&#x27;OpenThoughts3_1.2M_think&#x27;</span>, <span class="hljs-string">&#x27;aya_dataset_Qwen3_32B_think&#x27;</span>, <span class="hljs-string">&#x27;multi_turn_reasoning_if_think&#x27;</span>, <span class="hljs-string">&#x27;s1k_1.1_think&#x27;</span>, <span class="hljs-string">&#x27;smolagents_toolcalling_traces_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_everyday_convs_reasoning_Qwen3_32B_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_multilingual8_Qwen3_32B_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_systemchats_Qwen3_32B_think&#x27;</span>, <span class="hljs-string">&#x27;table_gpt_Qwen3_32B_think&#x27;</span>, <span class="hljs-string">&#x27;LongAlign_64k_context_lang_annotated_lang_6_no_think&#x27;</span>, <span class="hljs-string">&#x27;Mixture_of_Thoughts_science_no_think&#x27;</span>, <span class="hljs-string">&#x27;OpenHermes_2.5_no_think&#x27;</span>, <span class="hljs-string">&#x27;OpenThoughts3_1.2M_no_think_no_think&#x27;</span>, <span class="hljs-string">&#x27;hermes_function_calling_v1_no_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_multilingual_8languages_lang_5_no_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_smollm3_everyday_conversations_no_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_smollm3_explore_instruct_rewriting_no_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_smollm3_smol_magpie_ultra_no_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_smollm3_smol_rewrite_no_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_smollm3_smol_summarize_no_think&#x27;</span>, <span class="hljs-string">&#x27;smoltalk_smollm3_systemchats_30k_no_think&#x27;</span>, <span class="hljs-string">&#x27;table_gpt_no_think&#x27;</span>, <span class="hljs-string">&#x27;tulu_3_sft_personas_instruction_following_no_think&#x27;</span>, <span class="hljs-string">&#x27;xlam_traces_no_think&#x27;</span>]
Number of total rows: <span class="hljs-number">3383242</span>
Dataset structure: DatasetDict({
    LongAlign_64k_Qwen3_32B_yarn_131k_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">7526</span>
    })
    OpenThoughts3_1<span class="hljs-number">.2</span>M_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">1133524</span>
    })
    aya_dataset_Qwen3_32B_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">15222</span>
    })
    multi_turn_reasoning_if_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">28217</span>
    })
    s1k_1<span class="hljs-number">.1</span>_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">835</span>
    })
    smolagents_toolcalling_traces_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">9079</span>
    })
    smoltalk_everyday_convs_reasoning_Qwen3_32B_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">2057</span>
    })
    smoltalk_multilingual8_Qwen3_32B_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">244736</span>
    })
    smoltalk_systemchats_Qwen3_32B_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">27436</span>
    })
    table_gpt_Qwen3_32B_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">13201</span>
    })
    LongAlign_64k_context_lang_annotated_lang_6_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">6249</span>
    })
    Mixture_of_Thoughts_science_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">86110</span>
    })
    OpenHermes_2<span class="hljs-number">.5</span>_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">384900</span>
    })
    OpenThoughts3_1<span class="hljs-number">.2</span>M_no_think_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">435193</span>
    })
    hermes_function_calling_v1_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">8961</span>
    })
    smoltalk_multilingual_8languages_lang_5_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">254047</span>
    })
    smoltalk_smollm3_everyday_conversations_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">2260</span>
    })
    smoltalk_smollm3_explore_instruct_rewriting_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">30391</span>
    })
    smoltalk_smollm3_smol_magpie_ultra_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">406843</span>
    })
    smoltalk_smollm3_smol_rewrite_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">53262</span>
    })
    smoltalk_smollm3_smol_summarize_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">96061</span>
    })
    smoltalk_smollm3_systemchats_30k_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">33997</span>
    })
    table_gpt_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">13203</span>
    })
    tulu_3_sft_personas_instruction_following_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">29970</span>
    })
    xlam_traces_no_think: Dataset({
        features: [<span class="hljs-string">&#x27;messages&#x27;</span>, <span class="hljs-string">&#x27;chat_template_kwargs&#x27;</span>, <span class="hljs-string">&#x27;source&#x27;</span>],
        num_rows: <span class="hljs-number">59962</span>
    })
})`,wrap:!1}}),zs=new m({props:{title:"Process Different Dataset Types",local:"process-different-dataset-types",headingTag:"h3"}}),ks=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Function to process different dataset formats</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_qa_dataset</span>(<span class="hljs-params">examples, question_col, answer_col</span>):
    <span class="hljs-string">&quot;&quot;&quot;Process Q&amp;A datasets into chat format&quot;&quot;&quot;</span>
    processed = []
    
    <span class="hljs-keyword">for</span> question, answer <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[question_col], examples[answer_col]):
        messages = [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: question},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: answer}
        ]
        processed.append(messages)
    
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;messages&quot;</span>: processed}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_instruction_dataset</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-string">&quot;&quot;&quot;Process instruction-following datasets&quot;&quot;&quot;</span>
    processed = []
    
    <span class="hljs-keyword">for</span> instruction, response <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;instruction&quot;</span>], examples[<span class="hljs-string">&quot;response&quot;</span>]):
        messages = [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: instruction},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response}
        ]
        processed.append(messages)
    
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;messages&quot;</span>: processed}

<span class="hljs-comment"># Example: Process GSM8K math dataset</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== PROCESSING GSM8K DATASET ===\\n&quot;</span>)

gsm8k = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&quot;main&quot;</span>, split=<span class="hljs-string">&quot;train[:100]&quot;</span>)  <span class="hljs-comment"># Small subset for demo</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Original GSM8K example: <span class="hljs-subst">{gsm8k[<span class="hljs-number">0</span>]}</span>&quot;</span>)

<span class="hljs-comment"># Convert to chat format</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_gsm8k</span>(<span class="hljs-params">examples</span>):
    processed = []
    <span class="hljs-keyword">for</span> question, answer <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;question&quot;</span>], examples[<span class="hljs-string">&quot;answer&quot;</span>]):
        messages = [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a math tutor. Solve problems step by step.&quot;</span>},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: question},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: answer}
        ]
        processed.append(messages)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;messages&quot;</span>: processed}

gsm8k_processed = gsm8k.<span class="hljs-built_in">map</span>(process_gsm8k, batched=<span class="hljs-literal">True</span>, remove_columns=gsm8k.column_names)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Processed example: <span class="hljs-subst">{gsm8k_processed[<span class="hljs-number">0</span>]}</span>&quot;</span>)`,wrap:!1}}),Es=new r({props:{code:"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",highlighted:`=== PROCESSING GSM8K DATASET ===

README.md: 
 <span class="hljs-number">7.94</span>k/? [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 572kB/s]
main/train-<span class="hljs-number">00000</span>-of-<span class="hljs-number">00001.</span>parquet: <span class="hljs-number">100</span>%
 <span class="hljs-number">2.31</span>M/<span class="hljs-number">2.31</span>M [<span class="hljs-number">00</span>:01&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">42.6</span>kB/s]
main/test-<span class="hljs-number">00000</span>-of-<span class="hljs-number">00001.</span>parquet: <span class="hljs-number">100</span>%
 419k/419k [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 813kB/s]
Generating train split: <span class="hljs-number">100</span>%
 <span class="hljs-number">7473</span>/<span class="hljs-number">7473</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">321312.49</span> examples/s]
Generating test split: <span class="hljs-number">100</span>%
 <span class="hljs-number">1319</span>/<span class="hljs-number">1319</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">97120.71</span> examples/s]
Original GSM8K example: {<span class="hljs-string">&#x27;question&#x27;</span>: <span class="hljs-string">&#x27;Natalia sold clips to 48 of her friends in April, and then she sold half as many clips in May. How many clips did Natalia sell altogether in April and May?&#x27;</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Natalia sold 48/2 = &lt;&lt;48/2=24&gt;&gt;24 clips in May.\\nNatalia sold 48+24 = &lt;&lt;48+24=72&gt;&gt;72 clips altogether in April and May.\\n#### 72&#x27;</span>}
Map: <span class="hljs-number">100</span>%
 <span class="hljs-number">100</span>/<span class="hljs-number">100</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">4792.50</span> examples/s]
Processed example: {<span class="hljs-string">&#x27;messages&#x27;</span>: [{<span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;You are a math tutor. Solve problems step by step.&#x27;</span>, <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;system&#x27;</span>}, {<span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Natalia sold clips to 48 of her friends in April, and then she sold half as many clips in May. How many clips did Natalia sell altogether in April and May?&#x27;</span>, <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>}, {<span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Natalia sold 48/2 = &lt;&lt;48/2=24&gt;&gt;24 clips in May.\\nNatalia sold 48+24 = &lt;&lt;48+24=72&gt;&gt;72 clips altogether in April and May.\\n#### 72&#x27;</span>, <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>}]}`,wrap:!1}}),Ss=new m({props:{title:"Apply Chat Templates to Datasets",local:"apply-chat-templates-to-datasets",headingTag:"h3"}}),Ys=new r({props:{code:"JTIzJTIwRnVuY3Rpb24lMjB0byUyMGFwcGx5JTIwY2hhdCUyMHRlbXBsYXRlcyUyMHRvJTIwcHJvY2Vzc2VkJTIwZGF0YXNldHMlMEFkZWYlMjBhcHBseV9jaGF0X3RlbXBsYXRlX3RvX2RhdGFzZXQoZGF0YXNldCUyQyUyMHRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBcHBseSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMHRvJTIwZGF0YXNldCUyMGZvciUyMHRyYWluaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9ybWF0X21lc3NhZ2VzKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcm1hdHRlZF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMG1lc3NhZ2VzJTIwaW4lMjBleGFtcGxlcyU1QiUyMm1lc3NhZ2VzJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQXBwbHklMjBjaGF0JTIwdGVtcGxhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3JtYXR0ZWRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlJTIwJTIwJTIzJTIwV2UlMjB3YW50JTIwdGhlJTIwY29tcGxldGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3RleHRzLmFwcGVuZChmb3JtYXR0ZWRfdGV4dCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ0ZXh0JTIyJTNBJTIwZm9ybWF0dGVkX3RleHRzJTdEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGF0YXNldC5tYXAoZm9ybWF0X21lc3NhZ2VzJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBJTBBJTIzJTIwQXBwbHklMjB0byUyMG91ciUyMHByb2Nlc3NlZCUyMEdTTThLJTIwZGF0YXNldCUwQWdzbThrX2Zvcm1hdHRlZCUyMCUzRCUyMGFwcGx5X2NoYXRfdGVtcGxhdGVfdG9fZGF0YXNldChnc204a19wcm9jZXNzZWQlMkMlMjBpbnN0cnVjdF90b2tlbml6ZXIpJTBBcHJpbnQoJTIyJTNEJTNEJTNEJTIwRk9STUFUVEVEJTIwVFJBSU5JTkclMjBEQVRBJTIwJTNEJTNEJTNEJTIyKSUwQXByaW50KGdzbThrX2Zvcm1hdHRlZCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVEKQ==",highlighted:`<span class="hljs-comment"># Function to apply chat templates to processed datasets</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_chat_template_to_dataset</span>(<span class="hljs-params">dataset, tokenizer</span>):
    <span class="hljs-string">&quot;&quot;&quot;Apply chat template to dataset for training&quot;&quot;&quot;</span>
    
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">format_messages</span>(<span class="hljs-params">examples</span>):
        formatted_texts = []
        
        <span class="hljs-keyword">for</span> messages <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;messages&quot;</span>]:
            <span class="hljs-comment"># Apply chat template</span>
            formatted_text = tokenizer.apply_chat_template(
                messages,
                tokenize=<span class="hljs-literal">False</span>,
                add_generation_prompt=<span class="hljs-literal">False</span>  <span class="hljs-comment"># We want the complete conversation</span>
            )
            formatted_texts.append(formatted_text)
        
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: formatted_texts}
    
    <span class="hljs-keyword">return</span> dataset.<span class="hljs-built_in">map</span>(format_messages, batched=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Apply to our processed GSM8K dataset</span>
gsm8k_formatted = apply_chat_template_to_dataset(gsm8k_processed, instruct_tokenizer)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== FORMATTED TRAINING DATA ===&quot;</span>)
<span class="hljs-built_in">print</span>(gsm8k_formatted[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>])`,wrap:!1}}),Fs=new r({props:{code:"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",highlighted:`=== PROCESSING GSM8K DATASET ===

README.md: 
 <span class="hljs-number">7.94</span>k/? [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 572kB/s]
main/train-<span class="hljs-number">00000</span>-of-<span class="hljs-number">00001.</span>parquet: <span class="hljs-number">100</span>%
 <span class="hljs-number">2.31</span>M/<span class="hljs-number">2.31</span>M [<span class="hljs-number">00</span>:01&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">42.6</span>kB/s]
main/test-<span class="hljs-number">00000</span>-of-<span class="hljs-number">00001.</span>parquet: <span class="hljs-number">100</span>%
 419k/419k [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, 813kB/s]
Generating train split: <span class="hljs-number">100</span>%
 <span class="hljs-number">7473</span>/<span class="hljs-number">7473</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">321312.49</span> examples/s]
Generating test split: <span class="hljs-number">100</span>%
 <span class="hljs-number">1319</span>/<span class="hljs-number">1319</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">97120.71</span> examples/s]
Original GSM8K example: {<span class="hljs-string">&#x27;question&#x27;</span>: <span class="hljs-string">&#x27;Natalia sold clips to 48 of her friends in April, and then she sold half as many clips in May. How many clips did Natalia sell altogether in April and May?&#x27;</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Natalia sold 48/2 = &lt;&lt;48/2=24&gt;&gt;24 clips in May.\\nNatalia sold 48+24 = &lt;&lt;48+24=72&gt;&gt;72 clips altogether in April and May.\\n#### 72&#x27;</span>}
Map: <span class="hljs-number">100</span>%
 <span class="hljs-number">100</span>/<span class="hljs-number">100</span> [<span class="hljs-number">00</span>:<span class="hljs-number">00</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">4792.50</span> examples/s]
Processed example: {<span class="hljs-string">&#x27;messages&#x27;</span>: [{<span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;You are a math tutor. Solve problems step by step.&#x27;</span>, <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;system&#x27;</span>}, {<span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Natalia sold clips to 48 of her friends in April, and then she sold half as many clips in May. How many clips did Natalia sell altogether in April and May?&#x27;</span>, <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>}, {<span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Natalia sold 48/2 = &lt;&lt;48/2=24&gt;&gt;24 clips in May.\\nNatalia sold 48+24 = &lt;&lt;48+24=72&gt;&gt;72 clips altogether in April and May.\\n#### 72&#x27;</span>, <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>}]}`,wrap:!1}}),xs=new m({props:{title:"Exercise 3: Fine-Tuning SmolLM3 with SFTTrainer",local:"exercise-3-fine-tuning-smollm3-with-sfttrainer",headingTag:"h2"}}),_s=new m({props:{title:"Step 1: Setup and Model Loading",local:"step-1-setup-and-model-loading",headingTag:"h3"}}),Ds=new r({props:{code:"JTIzJTIwSW1wb3J0JTIwcmVxdWlyZWQlMjBsaWJyYXJpZXMlMjBmb3IlMjBmaW5lLXR1bmluZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwU0ZUQ29uZmlnJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwd2FuZGIlMjAlMjAlMjMlMjBPcHRpb25hbCUzQSUyMGZvciUyMGV4cGVyaW1lbnQlMjB0cmFja2luZyUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBXZWlnaHRzJTIwJTI2JTIwQmlhc2VzJTIwKG9wdGlvbmFsKSUwQSUyMyUyMHdhbmRiLmluaXQocHJvamVjdCUzRCUyMnNtb2xsbTMtZmluZXR1bmluZyUyMiklMEElMEElMjMlMjBMb2FkJTIwU21vbExNMyUyMGJhc2UlMjBtb2RlbCUyMGZvciUyMGZpbmUtdHVuaW5nJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0zLTNCLUJhc2UlMjIlMEFuZXdfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMlNtb2xMTTMtQ3VzdG9tLVNGVCUyMiUwQSUwQXByaW50KGYlMjJMb2FkaW5nJTIwJTdCbW9kZWxfbmFtZSU3RC4uLiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBdG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBTZXQlMjBwYWRkaW5nJTIwdG9rZW4lMEF0b2tlbml6ZXIucGFkZGluZ19zaWRlJTIwJTNEJTIwJTIycmlnaHQlMjIlMjAlMjAlMjMlMjBQYWRkaW5nJTIwb24lMjB0aGUlMjByaWdodCUyMGZvciUyMGdlbmVyYXRpb24lMEElMEFwcmludChmJTIyTW9kZWwlMjBsb2FkZWQhJTIwUGFyYW1ldGVycyUzQSUyMCU3Qm1vZGVsLm51bV9wYXJhbWV0ZXJzKCklM0ElMkMlN0QlMjIp",highlighted:`<span class="hljs-comment"># Import required libraries for fine-tuning</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig, DataCollatorForCompletionOnlyLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> wandb  <span class="hljs-comment"># Optional: for experiment tracking</span>

<span class="hljs-comment"># Initialize Weights &amp; Biases (optional)</span>
<span class="hljs-comment"># wandb.init(project=&quot;smollm3-finetuning&quot;)</span>

<span class="hljs-comment"># Load SmolLM3 base model for fine-tuning</span>
model_name = <span class="hljs-string">&quot;HuggingFaceTB/SmolLM3-3B-Base&quot;</span>
new_model_name = <span class="hljs-string">&quot;SmolLM3-Custom-SFT&quot;</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Loading <span class="hljs-subst">{model_name}</span>...&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(
    model_name,
    dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

tokenizer = AutoTokenizer.from_pretrained(model_name)
tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Set padding token</span>
tokenizer.padding_side = <span class="hljs-string">&quot;right&quot;</span>  <span class="hljs-comment"># Padding on the right for generation</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model loaded! Parameters: <span class="hljs-subst">{model.num_parameters():,}</span>&quot;</span>)`,wrap:!1}}),$s=new r({props:{code:"TG9hZGluZyUyMEh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0zLTNCLUJhc2UuLi4lMEFNb2RlbCUyMGxvYWRlZCElMjBQYXJhbWV0ZXJzJTNBJTIwMyUyQzA3NSUyQzA5OCUyQzYyNA==",highlighted:`Loading HuggingFaceTB/SmolLM3-3B-Base...
Model loaded! Parameters: <span class="hljs-number">3</span>,075,098,<span class="hljs-number">624</span>`,wrap:!1}}),qs=new m({props:{title:"Dataset Preparation",local:"dataset-preparation",headingTag:"h3"}}),Os=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Load and prepare training dataset</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== PREPARING DATASET ===\\n&quot;</span>)

<span class="hljs-comment"># Option 1: Use SmolTalk2 (recommended for beginners)</span>
dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceTB/smoltalk2&quot;</span>, <span class="hljs-string">&quot;SFT&quot;</span>)
train_dataset = dataset[<span class="hljs-string">&quot;smoltalk_everyday_convs_reasoning_Qwen3_32B_think&quot;</span>].select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))  <span class="hljs-comment"># Use subset for faster training</span>

<span class="hljs-comment"># Option 2: Use your own processed dataset from Exercise 2</span>
<span class="hljs-comment"># train_dataset = gsm8k_formatted.select(range(500))</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Training examples: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(train_dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Example: <span class="hljs-subst">{train_dataset[<span class="hljs-number">0</span>]}</span>&quot;</span>)

<span class="hljs-comment"># Prepare the dataset for SFT</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_chat_template</span>(<span class="hljs-params">example</span>):
    <span class="hljs-string">&quot;&quot;&quot;Format the messages using the chat template&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;messages&quot;</span> <span class="hljs-keyword">in</span> example:
        <span class="hljs-comment"># SmolTalk2 format</span>
        messages = example[<span class="hljs-string">&quot;messages&quot;</span>]
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Custom format - adapt as needed</span>
        messages = [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: example[<span class="hljs-string">&quot;instruction&quot;</span>]},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: example[<span class="hljs-string">&quot;response&quot;</span>]}
        ]
    
    <span class="hljs-comment"># Apply chat template</span>
    text = instruct_tokenizer.apply_chat_template(
        messages, 
        tokenize=<span class="hljs-literal">False</span>,
        add_generation_prompt=<span class="hljs-literal">False</span>
    )
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: text}

<span class="hljs-comment"># Apply formatting</span>
formatted_dataset = train_dataset.<span class="hljs-built_in">map</span>(format_chat_template)
formatted_dataset = formatted_dataset.remove_columns(
    [col <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> formatted_dataset.column_names <span class="hljs-keyword">if</span> col != <span class="hljs-string">&quot;text&quot;</span>]
)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Formatted example: <span class="hljs-subst">{formatted_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;text&#x27;</span>][:<span class="hljs-number">200</span>]}</span>...&quot;</span>)`,wrap:!1}}),Ps=new r({props:{code:"JTNEJTNEJTNEJTIwUFJFUEFSSU5HJTIwREFUQVNFVCUyMCUzRCUzRCUzRCUwQVRyYWluaW5nJTIwZXhhbXBsZXMlM0ElMjAxMDAwJTBBRXhhbXBsZSUzQSUyMCU3QidtZXNzYWdlcyclM0ElMjAlNUIlN0InY29udGVudCclM0ElMjAnU29sdmUlMjB0aGUlMjBwcm9ibGVtJTIwc3RlcCUyMGJ5JTIwc3RlcC4nJTJDJTIwJ3JvbGUnJTNBJTIwJ3N5c3RlbSclN0QlMkMlMjAlN0InY29udGVudCclM0ElMjAnTmF0YWxpYSUyMHNvbGQlMjBjbGlwcyUyMHRvJTIwNDglMjBvZiUyMGhlciUyMGZyaWVuZHMlMjBpbiUyMEFwcmlsJTJDJTIwYW5kJTIwdGhlbiUyMHNoZSUyMHNvbGQlMjBoYWxmJTIwYXMlMjBtYW55JTIwY2xpcHMlMjBpbiUyME1heS4lMjBIb3clMjBtYW55JTIwY2xpcHMlMjBkaWQlMjBOYXRhbGlhJTIwc2VsbCUyMGFsdG9nZXRoZXIlMjBpbiUyMEFwcmlsJTIwYW5kJTIwTWF5JTNGJyUyQyUyMCdyb2xlJyUzQSUyMCd1c2VyJyU3RCU1RCU3RCUwQUZvcm1hdHRlZCUyMGV4YW1wbGUlM0ElMjBZb3UlMjBhcmUlMjBhJTIwbWF0aCUyMHR1dG9yLiUyMFNvbHZlJTIwcHJvYmxlbXMlMjBzdGVwJTIwYnklMjBzdGVwLiUyME5hdGFsaWElMjBzb2xkJTIwY2xpcHMlMjB0byUyMDQ4JTIwb2YlMjBoZXIlMjBmcmllbmRzJTIwaW4lMjBBcHJpbCUyQyUyMGFuZCUyMHRoZW4lMjBzaGUlMjBzb2xkJTIwaGFsZiUyMGFzJTIwbWFueSUyMGNsaXBzJTIwaW4lMjBNYXkuJTIwSG93JTIwbWFueSUyMGNsaXBzJTIwZGlkJTIwTmF0YWxpYSUyMHNlbGwlMjBhbHRvZ2V0aGVyJTIwaW4lMjBBcHJpbCUyMGFuZCUyME1heSUzRi4uLg==",highlighted:`=== PREPARING DATASET ===
Training examples: <span class="hljs-number">1000</span>
Example: {<span class="hljs-string">&#x27;messages&#x27;</span>: [{<span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Solve the problem step by step.&#x27;</span>, <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;system&#x27;</span>}, {<span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Natalia sold clips to 48 of her friends in April, and then she sold half as many clips in May. How many clips did Natalia sell altogether in April and May?&#x27;</span>, <span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>}]}
Formatted example: You are a math tutor. Solve problems step by step. Natalia sold clips to <span class="hljs-number">48</span> of her friends <span class="hljs-keyword">in</span> April, <span class="hljs-keyword">and</span> then she sold half <span class="hljs-keyword">as</span> many clips <span class="hljs-keyword">in</span> May. How many clips did Natalia sell altogether <span class="hljs-keyword">in</span> April <span class="hljs-keyword">and</span> May?...`,wrap:!1}}),Ks=new m({props:{title:"Training Configuration",local:"training-configuration",headingTag:"h3"}}),ll=new r({props:{code:"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",highlighted:`<span class="hljs-comment"># Configure training parameters</span>
training_config = SFTConfig(
    <span class="hljs-comment"># Model and data</span>
    output_dir=<span class="hljs-string">f&quot;./<span class="hljs-subst">{new_model_name}</span>&quot;</span>,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_length=<span class="hljs-number">2048</span>,
    
    <span class="hljs-comment"># Training hyperparameters</span>
    per_device_train_batch_size=<span class="hljs-number">2</span>,  <span class="hljs-comment"># Adjust based on your GPU memory</span>
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    learning_rate=<span class="hljs-number">5e-5</span>,
    num_train_epochs=<span class="hljs-number">1</span>,  <span class="hljs-comment"># Start with 1 epoch</span>
    max_steps=<span class="hljs-number">500</span>,  <span class="hljs-comment"># Limit steps for demo</span>
    
    <span class="hljs-comment"># Optimization</span>
    warmup_steps=<span class="hljs-number">50</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
    optim=<span class="hljs-string">&quot;adamw_torch&quot;</span>,
    
    <span class="hljs-comment"># Logging and saving</span>
    logging_steps=<span class="hljs-number">10</span>,
    save_steps=<span class="hljs-number">100</span>,
    eval_steps=<span class="hljs-number">100</span>,
    save_total_limit=<span class="hljs-number">2</span>,
    
    <span class="hljs-comment"># Memory optimization</span>
    dataloader_num_workers=<span class="hljs-number">0</span>,
    group_by_length=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Group similar length sequences</span>
    
    <span class="hljs-comment"># Hugging Face Hub integration</span>
    push_to_hub=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># Set to True to upload to Hub</span>
    hub_model_id=<span class="hljs-string">f&quot;your-username/<span class="hljs-subst">{new_model_name}</span>&quot;</span>,
    
    <span class="hljs-comment"># Experiment tracking</span>
    report_to=[<span class="hljs-string">&quot;trackio&quot;</span>],  <span class="hljs-comment"># Use trackio for experiment tracking</span>
    run_name=<span class="hljs-string">f&quot;<span class="hljs-subst">{new_model_name}</span>-training&quot;</span>,
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Training configuration set!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Effective batch size: <span class="hljs-subst">{training_config.per_device_train_batch_size * training_config.gradient_accumulation_steps}</span>&quot;</span>)`,wrap:!1}}),al=new r({props:{code:"VHJhaW5pbmclMjBjb25maWd1cmF0aW9uJTIwc2V0ISUwQUVmZmVjdGl2ZSUyMGJhdGNoJTIwc2l6ZSUzQSUyMDQ=",highlighted:`Training configuration <span class="hljs-built_in">set</span>!
Effective batch size: <span class="hljs-number">4</span>`,wrap:!1}}),nl=new m({props:{title:"Optional: Train with LoRA/PEFT (memory-efficient)",local:"optional-train-with-lorapeft-memory-efficient",headingTag:"h3"}}),el=new r({props:{code:"JTIzJTIwTG9SQSUyMGNvbmZpZ3VyYXRpb24lMjB3aXRoJTIwUEVGVCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwTG9yYUNvbmZpZyUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEElMjMlMjBDcmVhdGUlMjBTRlRUcmFpbmVyJTIwd2l0aCUyMExvUkElMjBlbmFibGVkJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFsb3JhX3RyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZm9ybWF0dGVkX2RhdGFzZXQlMkMlMjAlMjAlMjMlMjBkYXRhc2V0JTIwd2l0aCUyMGElMjAlMjJ0ZXh0JTIyJTIwZmllbGQlMjBvciUyMG1lc3NhZ2VzJTIwJTJCJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTIwaW4lMjBjb25maWclMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0RwZWZ0X2NvbmZpZyUyQyUyMCUyMCUyMyUyMCUzQyUzQyUyMGVuYWJsZSUyMExvUkElMEEpJTBBJTBBcHJpbnQoJTIyU3RhcnRpbmclMjBMb1JBJTIwdHJhaW5pbmclRTIlODAlQTYlMjIpJTBBbG9yYV90cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># LoRA configuration with PEFT</span>
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># Create SFTTrainer with LoRA enabled</span>
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

lora_trainer = SFTTrainer(
    model=model,
    train_dataset=formatted_dataset,  <span class="hljs-comment"># dataset with a &quot;text&quot; field or messages + dataset_text_field in config</span>
    args=training_config,
    peft_config=peft_config,  <span class="hljs-comment"># &lt;&lt; enable LoRA</span>
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Starting LoRA training…&quot;</span>)
lora_trainer.train()`,wrap:!1}}),Ml=new m({props:{title:"Step 4: Initialize SFTTrainer and Train",local:"step-4-initialize-sfttrainer-and-train",headingTag:"h3"}}),yl=new r({props:{code:"JTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rmb3JtYXR0ZWRfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0Rjb25maWclMkMlMEEp",highlighted:`
trainer = SFTTrainer(
    model=model,
    train_dataset=formatted_dataset,
    args=config,
)`,wrap:!1}}),Jl=new r({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),Ul=new m({props:{title:"Test the Fine-Tuned Model",local:"test-the-fine-tuned-model",headingTag:"h3"}}),Tl=new r({props:{code:"JTIzJTIwVGVzdCUyMHRoZSUyMGZpbmUtdHVuZWQlMjBtb2RlbCUwQXByaW50KCUyMiUzRCUzRCUzRCUyMEFGVEVSJTIwVFJBSU5JTkclMjAlM0QlM0QlM0QlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBwcmludChyZXNwb25zZSU1Qmxlbihmb3JtYXR0ZWRfcHJvbXB0KSUzQSU1RCklMEElMEElMjMlMjBPcHRpb25hbCUzQSUyMFB1c2glMjB0byUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBaWYlMjB0cmFpbmluZ19jb25maWcucHVzaF90b19odWIlM0ElMEElMjAlMjAlMjAlMjB0cmFpbmVyLnB1c2hfdG9faHViKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbW1pdF9tZXNzYWdlJTNEJTIyRmluZS10dW5lZCUyMFNtb2xMTTMlMjB3aXRoJTIwY3VzdG9tJTIwZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhZ3MlM0QlNUIlMjJzbW9sLWNvdXJzZSUyMiUyQyUyMCUyMnNmdCUyMiUyQyUyMCUyMmluc3RydWN0aW9uLXR1bmluZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyTW9kZWwlMjBwdXNoZWQlMjB0byUyMEh1YiUzQSUyMCU3QnRyYWluaW5nX2NvbmZpZy5odWJfbW9kZWxfaWQlN0QlMjIp",highlighted:`<span class="hljs-comment"># Test the fine-tuned model</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=== AFTER TRAINING ===&quot;</span>)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model.generate(
        **inputs,
        max_new_tokens=<span class="hljs-number">100</span>,
        temperature=<span class="hljs-number">0.7</span>,
        do_sample=<span class="hljs-literal">True</span>,
        pad_token_id=tokenizer.eos_token_id
    )
    response = tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
    <span class="hljs-built_in">print</span>(response[<span class="hljs-built_in">len</span>(formatted_prompt):])

<span class="hljs-comment"># Optional: Push to Hugging Face Hub</span>
<span class="hljs-keyword">if</span> training_config.push_to_hub:
    trainer.push_to_hub(
        commit_message=<span class="hljs-string">&quot;Fine-tuned SmolLM3 with custom dataset&quot;</span>,
        tags=[<span class="hljs-string">&quot;smol-course&quot;</span>, <span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;instruction-tuning&quot;</span>]
    )
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model pushed to Hub: <span class="hljs-subst">{training_config.hub_model_id}</span>&quot;</span>)`,wrap:!1}}),jl=new m({props:{title:"Exercise 4: Production Workflow with TRL CLI",local:"exercise-4-production-workflow-with-trl-cli",headingTag:"h2"}}),rl=new r({props:{code:"JTIzJTIwRmluZS10dW5lJTIwU21vbExNMyUyMHVzaW5nJTIwVFJMJTIwQ0xJJTBBdHJsJTIwc2Z0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBIdWdnaW5nRmFjZVRCJTJGU21vbExNMy0zQi1CYXNlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjBIdWdnaW5nRmFjZVRCJTJGc21vbHRhbGsyX2V2ZXJ5ZGF5X2NvbnZzX3RoaW5rJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwLiUyRnNtb2xsbTMtc2Z0LWNsaSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW51bV90cmFpbl9lcG9jaHMlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfbGVuZ3RoJTIwMjA0OCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbG9nZ2luZ19zdGVwcyUyMDEwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zYXZlX3N0ZXBzJTIwNTAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS13YXJtdXBfc3RlcHMlMjAxMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWJmMTYlMjBUcnVlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1YiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taHViX21vZGVsX2lkJTIweW91ci11c2VybmFtZSUyRnNtb2xsbTMtc2Z0LWNsaQ==",highlighted:`<span class="hljs-comment"># Fine-tune SmolLM3 using TRL CLI</span>
trl sft \\
    --model_name_or_path HuggingFaceTB/SmolLM3-3B-Base \\
    --dataset_name HuggingFaceTB/smoltalk2_everyday_convs_think \\
    --output_dir ./smollm3-sft-cli \\
    --per_device_train_batch_size 4 \\
    --gradient_accumulation_steps 2 \\
    --learning_rate 5e-5 \\
    --num_train_epochs 1 \\
    --max_length 2048 \\
    --logging_steps 10 \\
    --save_steps 500 \\
    --warmup_steps 100 \\
    --bf16 True \\
    --push_to_hub \\
    --hub_model_id your-username/smollm3-sft-cli`,wrap:!1}}),ul=new r({props:{code:"JTIzJTIwTW9kZWwlMjBhbmQlMjBkYXRhc2V0JTBBbW9kZWxfbmFtZV9vcl9wYXRoJTNBJTIwSHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTMtM0ItQmFzZSUwQWRhdGFzZXRfbmFtZSUzQSUyMEh1Z2dpbmdGYWNlVEIlMkZzbW9sdGFsazJfZXZlcnlkYXlfY29udnNfdGhpbmslMEFvdXRwdXRfZGlyJTNBJTIwLiUyRnNtb2xsbTMtYWR2YW5jZWQtc2Z0JTBBJTBBJTIzJTIwVHJhaW5pbmclMjBoeXBlcnBhcmFtZXRlcnMlMEFwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0ElMjAyJTBBZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwNCUwQWxlYXJuaW5nX3JhdGUlM0ElMjAzZS01JTBBbnVtX3RyYWluX2Vwb2NocyUzQSUyMDIlMEFtYXhfbGVuZ3RoJTNBJTIwNDA5NiUwQSUwQSUyMyUyME9wdGltaXphdGlvbiUwQXdhcm11cF9zdGVwcyUzQSUyMDIwMCUwQXdlaWdodF9kZWNheSUzQSUyMDAuMDElMEFvcHRpbSUzQSUyMGFkYW13X3RvcmNoJTBBbHJfc2NoZWR1bGVyX3R5cGUlM0ElMjBjb3NpbmUlMEElMEElMjMlMjBNZW1vcnklMjBhbmQlMjBwZXJmb3JtYW5jZSUwQWJmMTYlM0ElMjB0cnVlJTBBZGF0YWxvYWRlcl9udW1fd29ya2VycyUzQSUyMDQlMEFncm91cF9ieV9sZW5ndGglM0ElMjB0cnVlJTBBcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNBJTIwZmFsc2UlMEElMEElMjMlMjBMb2dnaW5nJTIwYW5kJTIwZXZhbHVhdGlvbiUwQWxvZ2dpbmdfc3RlcHMlM0ElMjAyNSUwQWV2YWxfc3RlcHMlM0ElMjAyNTAlMEFzYXZlX3N0ZXBzJTNBJTIwNTAwJTBBZXZhbF9zdHJhdGVneSUzQSUyMHN0ZXBzJTBBbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzQSUyMHRydWUlMEFtZXRyaWNfZm9yX2Jlc3RfbW9kZWwlM0ElMjBldmFsX2xvc3MlMEElMEElMjMlMjBIdWIlMjBpbnRlZ3JhdGlvbiUwQXB1c2hfdG9faHViJTNBJTIwdHJ1ZSUwQWh1Yl9tb2RlbF9pZCUzQSUyMHlvdXItdXNlcm5hbWUlMkZzbW9sbG0zLWFkdmFuY2VkJTBBaHViX3N0cmF0ZWd5JTNBJTIwZXZlcnlfc2F2ZQ==",highlighted:`<span class="hljs-comment"># Model and dataset</span>
<span class="hljs-attr">model_name_or_path:</span> <span class="hljs-string">HuggingFaceTB/SmolLM3-3B-Base</span>
<span class="hljs-attr">dataset_name:</span> <span class="hljs-string">HuggingFaceTB/smoltalk2_everyday_convs_think</span>
<span class="hljs-attr">output_dir:</span> <span class="hljs-string">./smollm3-advanced-sft</span>

<span class="hljs-comment"># Training hyperparameters</span>
<span class="hljs-attr">per_device_train_batch_size:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">gradient_accumulation_steps:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">learning_rate:</span> <span class="hljs-number">3e-5</span>
<span class="hljs-attr">num_train_epochs:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">max_length:</span> <span class="hljs-number">4096</span>

<span class="hljs-comment"># Optimization</span>
<span class="hljs-attr">warmup_steps:</span> <span class="hljs-number">200</span>
<span class="hljs-attr">weight_decay:</span> <span class="hljs-number">0.01</span>
<span class="hljs-attr">optim:</span> <span class="hljs-string">adamw_torch</span>
<span class="hljs-attr">lr_scheduler_type:</span> <span class="hljs-string">cosine</span>

<span class="hljs-comment"># Memory and performance</span>
<span class="hljs-attr">bf16:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">dataloader_num_workers:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">group_by_length:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">remove_unused_columns:</span> <span class="hljs-literal">false</span>

<span class="hljs-comment"># Logging and evaluation</span>
<span class="hljs-attr">logging_steps:</span> <span class="hljs-number">25</span>
<span class="hljs-attr">eval_steps:</span> <span class="hljs-number">250</span>
<span class="hljs-attr">save_steps:</span> <span class="hljs-number">500</span>
<span class="hljs-attr">eval_strategy:</span> <span class="hljs-string">steps</span>
<span class="hljs-attr">load_best_model_at_end:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">metric_for_best_model:</span> <span class="hljs-string">eval_loss</span>

<span class="hljs-comment"># Hub integration</span>
<span class="hljs-attr">push_to_hub:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">hub_model_id:</span> <span class="hljs-string">your-username/smollm3-advanced</span>
<span class="hljs-attr">hub_strategy:</span> <span class="hljs-string">every_save</span>`,wrap:!1}}),bl=new r({props:{code:"JTIzJTIwUnVuJTIwdHJhaW5pbmclMjB3aXRoJTIwY29uZmlnJTIwZmlsZSUwQXRybCUyMHNmdCUyMC0tY29uZmlnJTIwc2Z0X2NvbmZpZy55YW1s",highlighted:`<span class="hljs-comment"># Run training with config file</span>
trl sft --config sft_config.yaml`,wrap:!1}}),Il=new m({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h3"}}),Rl=new m({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Ql=new m({props:{title:"Resources for Further Learning",local:"resources-for-further-learning",headingTag:"h2"}}),kl=new wM({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/4.md"}}),{c(){b=M("meta"),ta=t(),aa=M("p"),ea=t(),c(V.$$.fragment),Ma=t(),c(z.$$.fragment),pa=t(),Q=M("p"),Q.textContent=Lt,ya=t(),c(X.$$.fragment),ca=t(),k=M("p"),k.textContent=Ot,Ja=t(),f=M("ul"),f.innerHTML=Pt,Ua=t(),ia=M("hr"),Ta=t(),c(E.$$.fragment),ja=t(),S=M("p"),S.innerHTML=Kt,oa=t(),A=M("p"),A.textContent=se,wa=t(),c(Y.$$.fragment),ha=t(),I=M("blockquote"),I.innerHTML=le,ra=t(),F=M("p"),F.textContent=ae,ma=t(),c(x.$$.fragment),ua=t(),v=M("p"),v.textContent=ne,da=t(),c(_.$$.fragment),ba=t(),H=M("p"),H.textContent=te,Ia=t(),B=M("details"),fl=M("summary"),fl.textContent=ee,dt=t(),c(D.$$.fragment),Ba=t(),c($.$$.fragment),Ca=t(),q=M("p"),q.textContent=Me,Ga=t(),c(L.$$.fragment),Za=t(),O=M("p"),O.textContent=pe,Na=t(),d=M("details"),El=M("summary"),El.textContent=ye,bt=t(),Sl=M("p"),Sl.textContent=ce,It=t(),c(P.$$.fragment),ga=t(),c(K.$$.fragment),Ra=t(),ss=M("p"),ss.textContent=Je,Wa=t(),c(ls.$$.fragment),Va=t(),C=M("details"),Al=M("summary"),Al.textContent=Ue,Bt=t(),c(as.$$.fragment),za=t(),c(ns.$$.fragment),Qa=t(),ts=M("p"),ts.textContent=ie,Xa=t(),c(es.$$.fragment),ka=t(),Ms=M("p"),Ms.innerHTML=Te,fa=t(),G=M("details"),Yl=M("summary"),Yl.textContent=je,Ct=t(),c(ps.$$.fragment),Ea=t(),c(ys.$$.fragment),Sa=t(),cs=M("p"),cs.textContent=oe,Aa=t(),c(Js.$$.fragment),Ya=t(),Us=M("p"),Us.innerHTML=we,Fa=t(),w=M("details"),Fl=M("summary"),Fl.textContent=he,Gt=t(),c(is.$$.fragment),Zt=t(),xl=M("p"),xl.textContent=re,Nt=t(),c(Ts.$$.fragment),gt=t(),c(js.$$.fragment),Rt=t(),vl=M("p"),vl.textContent=me,Wt=t(),c(os.$$.fragment),Vt=t(),_l=M("p"),_l.textContent=ue,zt=t(),c(ws.$$.fragment),Qt=t(),Hl=M("p"),Hl.textContent=de,Xt=t(),c(hs.$$.fragment),kt=t(),Dl=M("p"),Dl.textContent=be,ft=t(),c(rs.$$.fragment),Et=t(),c(ms.$$.fragment),St=t(),$l=M("p"),$l.textContent=Ie,At=t(),c(us.$$.fragment),Yt=t(),ql=M("p"),ql.textContent=Be,Ft=t(),c(ds.$$.fragment),xt=t(),Ll=M("p"),Ll.textContent=Ce,vt=t(),c(bs.$$.fragment),xa=t(),c(Is.$$.fragment),va=t(),Bs=M("p"),Bs.textContent=Ge,_a=t(),Cs=M("ol"),Cs.innerHTML=Ze,Ha=t(),Da=M("hr"),$a=t(),c(Gs.$$.fragment),qa=t(),Zs=M("p"),Zs.innerHTML=Ne,La=t(),c(Ns.$$.fragment),Oa=t(),gs=M("p"),gs.innerHTML=ge,Pa=t(),c(Rs.$$.fragment),Ka=t(),Ws=M("p"),Ws.textContent=Re,sn=t(),Z=M("details"),Ol=M("summary"),Ol.textContent=We,_t=t(),c(Vs.$$.fragment),ln=t(),c(zs.$$.fragment),an=t(),Qs=M("p"),Qs.innerHTML=Ve,nn=t(),Xs=M("p"),Xs.innerHTML=ze,tn=t(),c(ks.$$.fragment),en=t(),fs=M("p"),fs.textContent=Qe,Mn=t(),N=M("details"),Pl=M("summary"),Pl.textContent=Xe,Ht=t(),c(Es.$$.fragment),pn=t(),c(Ss.$$.fragment),yn=t(),As=M("p"),As.innerHTML=ke,cn=t(),c(Ys.$$.fragment),Jn=t(),g=M("details"),Kl=M("summary"),Kl.textContent=fe,Dt=t(),c(Fs.$$.fragment),Un=t(),Tn=M("hr"),jn=t(),c(xs.$$.fragment),on=t(),vs=M("p"),vs.innerHTML=Ee,wn=t(),R=M("blockquote"),R.innerHTML=Se,hn=t(),c(_s.$$.fragment),rn=t(),Hs=M("p"),Hs.textContent=Ae,mn=t(),c(Ds.$$.fragment),un=t(),c($s.$$.fragment),dn=t(),c(qs.$$.fragment),bn=t(),Ls=M("p"),Ls.innerHTML=Ye,In=t(),c(Os.$$.fragment),Bn=t(),W=M("details"),sa=M("summary"),sa.textContent=Fe,$t=t(),c(Ps.$$.fragment),Cn=t(),c(Ks.$$.fragment),Gn=t(),sl=M("p"),sl.textContent=xe,Zn=t(),c(ll.$$.fragment),Nn=t(),c(al.$$.fragment),gn=t(),c(nl.$$.fragment),Rn=t(),tl=M("p"),tl.textContent=ve,Wn=t(),c(el.$$.fragment),Vn=t(),c(Ml.$$.fragment),zn=t(),pl=M("p"),pl.innerHTML=_e,Qn=t(),c(yl.$$.fragment),Xn=t(),cl=M("p"),cl.textContent=He,kn=t(),c(Jl.$$.fragment),fn=t(),c(Ul.$$.fragment),En=t(),il=M("p"),il.textContent=De,Sn=t(),c(Tl.$$.fragment),An=t(),Yn=M("hr"),Fn=t(),c(jl.$$.fragment),xn=t(),ol=M("p"),ol.textContent=$e,vn=t(),wl=M("p"),wl.innerHTML=qe,_n=t(),hl=M("p"),hl.innerHTML=Le,Hn=t(),c(rl.$$.fragment),Dn=t(),ml=M("p"),ml.innerHTML=Oe,$n=t(),c(ul.$$.fragment),qn=t(),dl=M("p"),dl.textContent=Pe,Ln=t(),c(bl.$$.fragment),On=t(),c(Il.$$.fragment),Pn=t(),Bl=M("p"),Bl.innerHTML=Ke,Kn=t(),Cl=M("ul"),Cl.innerHTML=sM,st=t(),Gl=M("p"),Gl.innerHTML=lM,lt=t(),Zl=M("ul"),Zl.innerHTML=aM,at=t(),Nl=M("p"),Nl.innerHTML=nM,nt=t(),gl=M("ul"),gl.innerHTML=tM,tt=t(),c(Rl.$$.fragment),et=t(),Wl=M("p"),Wl.textContent=eM,Mt=t(),Vl=M("ul"),Vl.innerHTML=MM,pt=t(),zl=M("p"),zl.textContent=pM,yt=t(),c(Ql.$$.fragment),ct=t(),Xl=M("ul"),Xl.innerHTML=yM,Jt=t(),c(kl.$$.fragment),Ut=t(),na=M("p"),this.h()},l(s){const l=jM("svelte-u9bgzb",document.head);b=p(l,"META",{name:!0,content:!0}),l.forEach(a),ta=e(s),aa=p(s,"P",{}),u(aa).forEach(a),ea=e(s),J(V.$$.fragment,s),Ma=e(s),J(z.$$.fragment,s),pa=e(s),Q=p(s,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-ijibp7"&&(Q.textContent=Lt),ya=e(s),J(X.$$.fragment,s),ca=e(s),k=p(s,"P",{"data-svelte-h":!0}),y(k)!=="svelte-clpuj8"&&(k.textContent=Ot),Ja=e(s),f=p(s,"UL",{"data-svelte-h":!0}),y(f)!=="svelte-1acbghj"&&(f.innerHTML=Pt),Ua=e(s),ia=p(s,"HR",{}),Ta=e(s),J(E.$$.fragment,s),ja=e(s),S=p(s,"P",{"data-svelte-h":!0}),y(S)!=="svelte-dxmy11"&&(S.innerHTML=Kt),oa=e(s),A=p(s,"P",{"data-svelte-h":!0}),y(A)!=="svelte-1dbaxjh"&&(A.textContent=se),wa=e(s),J(Y.$$.fragment,s),ha=e(s),I=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(I)!=="svelte-2reic0"&&(I.innerHTML=le),ra=e(s),F=p(s,"P",{"data-svelte-h":!0}),y(F)!=="svelte-1028exi"&&(F.textContent=ae),ma=e(s),J(x.$$.fragment,s),ua=e(s),v=p(s,"P",{"data-svelte-h":!0}),y(v)!=="svelte-a4hioj"&&(v.textContent=ne),da=e(s),J(_.$$.fragment,s),ba=e(s),H=p(s,"P",{"data-svelte-h":!0}),y(H)!=="svelte-86bti8"&&(H.textContent=te),Ia=e(s),B=p(s,"DETAILS",{});var Tt=u(B);fl=p(Tt,"SUMMARY",{"data-svelte-h":!0}),y(fl)!=="svelte-nfzy3j"&&(fl.textContent=ee),dt=e(Tt),J(D.$$.fragment,Tt),Tt.forEach(a),Ba=e(s),J($.$$.fragment,s),Ca=e(s),q=p(s,"P",{"data-svelte-h":!0}),y(q)!=="svelte-15ten42"&&(q.textContent=Me),Ga=e(s),J(L.$$.fragment,s),Za=e(s),O=p(s,"P",{"data-svelte-h":!0}),y(O)!=="svelte-1jws4q2"&&(O.textContent=pe),Na=e(s),d=p(s,"DETAILS",{});var la=u(d);El=p(la,"SUMMARY",{"data-svelte-h":!0}),y(El)!=="svelte-nfzy3j"&&(El.textContent=ye),bt=e(la),Sl=p(la,"P",{"data-svelte-h":!0}),y(Sl)!=="svelte-oi205b"&&(Sl.textContent=ce),It=e(la),J(P.$$.fragment,la),la.forEach(a),ga=e(s),J(K.$$.fragment,s),Ra=e(s),ss=p(s,"P",{"data-svelte-h":!0}),y(ss)!=="svelte-rdqye6"&&(ss.textContent=Je),Wa=e(s),J(ls.$$.fragment,s),Va=e(s),C=p(s,"DETAILS",{});var jt=u(C);Al=p(jt,"SUMMARY",{"data-svelte-h":!0}),y(Al)!=="svelte-nfzy3j"&&(Al.textContent=Ue),Bt=e(jt),J(as.$$.fragment,jt),jt.forEach(a),za=e(s),J(ns.$$.fragment,s),Qa=e(s),ts=p(s,"P",{"data-svelte-h":!0}),y(ts)!=="svelte-jrpxvi"&&(ts.textContent=ie),Xa=e(s),J(es.$$.fragment,s),ka=e(s),Ms=p(s,"P",{"data-svelte-h":!0}),y(Ms)!=="svelte-ua5y9z"&&(Ms.innerHTML=Te),fa=e(s),G=p(s,"DETAILS",{});var ot=u(G);Yl=p(ot,"SUMMARY",{"data-svelte-h":!0}),y(Yl)!=="svelte-nfzy3j"&&(Yl.textContent=je),Ct=e(ot),J(ps.$$.fragment,ot),ot.forEach(a),Ea=e(s),J(ys.$$.fragment,s),Sa=e(s),cs=p(s,"P",{"data-svelte-h":!0}),y(cs)!=="svelte-gnsa79"&&(cs.textContent=oe),Aa=e(s),J(Js.$$.fragment,s),Ya=e(s),Us=p(s,"P",{"data-svelte-h":!0}),y(Us)!=="svelte-1q49hws"&&(Us.innerHTML=we),Fa=e(s),w=p(s,"DETAILS",{});var h=u(w);Fl=p(h,"SUMMARY",{"data-svelte-h":!0}),y(Fl)!=="svelte-nfzy3j"&&(Fl.textContent=he),Gt=e(h),J(is.$$.fragment,h),Zt=e(h),xl=p(h,"P",{"data-svelte-h":!0}),y(xl)!=="svelte-10q2pse"&&(xl.textContent=re),Nt=e(h),J(Ts.$$.fragment,h),gt=e(h),J(js.$$.fragment,h),Rt=e(h),vl=p(h,"P",{"data-svelte-h":!0}),y(vl)!=="svelte-10q2pse"&&(vl.textContent=me),Wt=e(h),J(os.$$.fragment,h),Vt=e(h),_l=p(h,"P",{"data-svelte-h":!0}),y(_l)!=="svelte-ucyupk"&&(_l.textContent=ue),zt=e(h),J(ws.$$.fragment,h),Qt=e(h),Hl=p(h,"P",{"data-svelte-h":!0}),y(Hl)!=="svelte-10q2pse"&&(Hl.textContent=de),Xt=e(h),J(hs.$$.fragment,h),kt=e(h),Dl=p(h,"P",{"data-svelte-h":!0}),y(Dl)!=="svelte-ucyupk"&&(Dl.textContent=be),ft=e(h),J(rs.$$.fragment,h),Et=e(h),J(ms.$$.fragment,h),St=e(h),$l=p(h,"P",{"data-svelte-h":!0}),y($l)!=="svelte-10q2pse"&&($l.textContent=Ie),At=e(h),J(us.$$.fragment,h),Yt=e(h),ql=p(h,"P",{"data-svelte-h":!0}),y(ql)!=="svelte-ucyupk"&&(ql.textContent=Be),Ft=e(h),J(ds.$$.fragment,h),xt=e(h),Ll=p(h,"P",{"data-svelte-h":!0}),y(Ll)!=="svelte-wdrrdx"&&(Ll.textContent=Ce),vt=e(h),J(bs.$$.fragment,h),h.forEach(a),xa=e(s),J(Is.$$.fragment,s),va=e(s),Bs=p(s,"P",{"data-svelte-h":!0}),y(Bs)!=="svelte-1pp1ptr"&&(Bs.textContent=Ge),_a=e(s),Cs=p(s,"OL",{"data-svelte-h":!0}),y(Cs)!=="svelte-3se8bh"&&(Cs.innerHTML=Ze),Ha=e(s),Da=p(s,"HR",{}),$a=e(s),J(Gs.$$.fragment,s),qa=e(s),Zs=p(s,"P",{"data-svelte-h":!0}),y(Zs)!=="svelte-xrwvs3"&&(Zs.innerHTML=Ne),La=e(s),J(Ns.$$.fragment,s),Oa=e(s),gs=p(s,"P",{"data-svelte-h":!0}),y(gs)!=="svelte-1fmma7y"&&(gs.innerHTML=ge),Pa=e(s),J(Rs.$$.fragment,s),Ka=e(s),Ws=p(s,"P",{"data-svelte-h":!0}),y(Ws)!=="svelte-k5zewq"&&(Ws.textContent=Re),sn=e(s),Z=p(s,"DETAILS",{});var wt=u(Z);Ol=p(wt,"SUMMARY",{"data-svelte-h":!0}),y(Ol)!=="svelte-nfzy3j"&&(Ol.textContent=We),_t=e(wt),J(Vs.$$.fragment,wt),wt.forEach(a),ln=e(s),J(zs.$$.fragment,s),an=e(s),Qs=p(s,"P",{"data-svelte-h":!0}),y(Qs)!=="svelte-16yl14j"&&(Qs.innerHTML=Ve),nn=e(s),Xs=p(s,"P",{"data-svelte-h":!0}),y(Xs)!=="svelte-1t3luqc"&&(Xs.innerHTML=ze),tn=e(s),J(ks.$$.fragment,s),en=e(s),fs=p(s,"P",{"data-svelte-h":!0}),y(fs)!=="svelte-1ykucrl"&&(fs.textContent=Qe),Mn=e(s),N=p(s,"DETAILS",{});var ht=u(N);Pl=p(ht,"SUMMARY",{"data-svelte-h":!0}),y(Pl)!=="svelte-nfzy3j"&&(Pl.textContent=Xe),Ht=e(ht),J(Es.$$.fragment,ht),ht.forEach(a),pn=e(s),J(Ss.$$.fragment,s),yn=e(s),As=p(s,"P",{"data-svelte-h":!0}),y(As)!=="svelte-yzds0r"&&(As.innerHTML=ke),cn=e(s),J(Ys.$$.fragment,s),Jn=e(s),g=p(s,"DETAILS",{});var rt=u(g);Kl=p(rt,"SUMMARY",{"data-svelte-h":!0}),y(Kl)!=="svelte-nfzy3j"&&(Kl.textContent=fe),Dt=e(rt),J(Fs.$$.fragment,rt),rt.forEach(a),Un=e(s),Tn=p(s,"HR",{}),jn=e(s),J(xs.$$.fragment,s),on=e(s),vs=p(s,"P",{"data-svelte-h":!0}),y(vs)!=="svelte-fc6ch8"&&(vs.innerHTML=Ee),wn=e(s),R=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(R)!=="svelte-18st3h"&&(R.innerHTML=Se),hn=e(s),J(_s.$$.fragment,s),rn=e(s),Hs=p(s,"P",{"data-svelte-h":!0}),y(Hs)!=="svelte-h663ao"&&(Hs.textContent=Ae),mn=e(s),J(Ds.$$.fragment,s),un=e(s),J($s.$$.fragment,s),dn=e(s),J(qs.$$.fragment,s),bn=e(s),Ls=p(s,"P",{"data-svelte-h":!0}),y(Ls)!=="svelte-198u8by"&&(Ls.innerHTML=Ye),In=e(s),J(Os.$$.fragment,s),Bn=e(s),W=p(s,"DETAILS",{});var mt=u(W);sa=p(mt,"SUMMARY",{"data-svelte-h":!0}),y(sa)!=="svelte-nfzy3j"&&(sa.textContent=Fe),$t=e(mt),J(Ps.$$.fragment,mt),mt.forEach(a),Cn=e(s),J(Ks.$$.fragment,s),Gn=e(s),sl=p(s,"P",{"data-svelte-h":!0}),y(sl)!=="svelte-1yzvmex"&&(sl.textContent=xe),Zn=e(s),J(ll.$$.fragment,s),Nn=e(s),J(al.$$.fragment,s),gn=e(s),J(nl.$$.fragment,s),Rn=e(s),tl=p(s,"P",{"data-svelte-h":!0}),y(tl)!=="svelte-1v2wu0d"&&(tl.textContent=ve),Wn=e(s),J(el.$$.fragment,s),Vn=e(s),J(Ml.$$.fragment,s),zn=e(s),pl=p(s,"P",{"data-svelte-h":!0}),y(pl)!=="svelte-1jnbdu"&&(pl.innerHTML=_e),Qn=e(s),J(yl.$$.fragment,s),Xn=e(s),cl=p(s,"P",{"data-svelte-h":!0}),y(cl)!=="svelte-1f4m4i1"&&(cl.textContent=He),kn=e(s),J(Jl.$$.fragment,s),fn=e(s),J(Ul.$$.fragment,s),En=e(s),il=p(s,"P",{"data-svelte-h":!0}),y(il)!=="svelte-1oztd6w"&&(il.textContent=De),Sn=e(s),J(Tl.$$.fragment,s),An=e(s),Yn=p(s,"HR",{}),Fn=e(s),J(jl.$$.fragment,s),xn=e(s),ol=p(s,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-1ff0l14"&&(ol.textContent=$e),vn=e(s),wl=p(s,"P",{"data-svelte-h":!0}),y(wl)!=="svelte-534u83"&&(wl.innerHTML=qe),_n=e(s),hl=p(s,"P",{"data-svelte-h":!0}),y(hl)!=="svelte-ttcupp"&&(hl.innerHTML=Le),Hn=e(s),J(rl.$$.fragment,s),Dn=e(s),ml=p(s,"P",{"data-svelte-h":!0}),y(ml)!=="svelte-wx6ng4"&&(ml.innerHTML=Oe),$n=e(s),J(ul.$$.fragment,s),qn=e(s),dl=p(s,"P",{"data-svelte-h":!0}),y(dl)!=="svelte-wxnssy"&&(dl.textContent=Pe),Ln=e(s),J(bl.$$.fragment,s),On=e(s),J(Il.$$.fragment,s),Pn=e(s),Bl=p(s,"P",{"data-svelte-h":!0}),y(Bl)!=="svelte-g1ebke"&&(Bl.innerHTML=Ke),Kn=e(s),Cl=p(s,"UL",{"data-svelte-h":!0}),y(Cl)!=="svelte-n9dtym"&&(Cl.innerHTML=sM),st=e(s),Gl=p(s,"P",{"data-svelte-h":!0}),y(Gl)!=="svelte-i24yvd"&&(Gl.innerHTML=lM),lt=e(s),Zl=p(s,"UL",{"data-svelte-h":!0}),y(Zl)!=="svelte-2gfald"&&(Zl.innerHTML=aM),at=e(s),Nl=p(s,"P",{"data-svelte-h":!0}),y(Nl)!=="svelte-1f9jjgt"&&(Nl.innerHTML=nM),nt=e(s),gl=p(s,"UL",{"data-svelte-h":!0}),y(gl)!=="svelte-61eei3"&&(gl.innerHTML=tM),tt=e(s),J(Rl.$$.fragment,s),et=e(s),Wl=p(s,"P",{"data-svelte-h":!0}),y(Wl)!=="svelte-23hw16"&&(Wl.textContent=eM),Mt=e(s),Vl=p(s,"UL",{"data-svelte-h":!0}),y(Vl)!=="svelte-1bfikhu"&&(Vl.innerHTML=MM),pt=e(s),zl=p(s,"P",{"data-svelte-h":!0}),y(zl)!=="svelte-vwadk8"&&(zl.textContent=pM),yt=e(s),J(Ql.$$.fragment,s),ct=e(s),Xl=p(s,"UL",{"data-svelte-h":!0}),y(Xl)!=="svelte-1iv5b6w"&&(Xl.innerHTML=yM),Jt=e(s),J(kl.$$.fragment,s),Ut=e(s),na=p(s,"P",{}),u(na).forEach(a),this.h()},h(){ut(b,"name","hf:doc:metadata"),ut(b,"content",rM),ut(I,"class","warning"),ut(R,"class","warning")},m(s,l){o(document.head,b),n(s,ta,l),n(s,aa,l),n(s,ea,l),U(V,s,l),n(s,Ma,l),U(z,s,l),n(s,pa,l),n(s,Q,l),n(s,ya,l),U(X,s,l),n(s,ca,l),n(s,k,l),n(s,Ja,l),n(s,f,l),n(s,Ua,l),n(s,ia,l),n(s,Ta,l),U(E,s,l),n(s,ja,l),n(s,S,l),n(s,oa,l),n(s,A,l),n(s,wa,l),U(Y,s,l),n(s,ha,l),n(s,I,l),n(s,ra,l),n(s,F,l),n(s,ma,l),U(x,s,l),n(s,ua,l),n(s,v,l),n(s,da,l),U(_,s,l),n(s,ba,l),n(s,H,l),n(s,Ia,l),n(s,B,l),o(B,fl),o(B,dt),U(D,B,null),n(s,Ba,l),U($,s,l),n(s,Ca,l),n(s,q,l),n(s,Ga,l),U(L,s,l),n(s,Za,l),n(s,O,l),n(s,Na,l),n(s,d,l),o(d,El),o(d,bt),o(d,Sl),o(d,It),U(P,d,null),n(s,ga,l),U(K,s,l),n(s,Ra,l),n(s,ss,l),n(s,Wa,l),U(ls,s,l),n(s,Va,l),n(s,C,l),o(C,Al),o(C,Bt),U(as,C,null),n(s,za,l),U(ns,s,l),n(s,Qa,l),n(s,ts,l),n(s,Xa,l),U(es,s,l),n(s,ka,l),n(s,Ms,l),n(s,fa,l),n(s,G,l),o(G,Yl),o(G,Ct),U(ps,G,null),n(s,Ea,l),U(ys,s,l),n(s,Sa,l),n(s,cs,l),n(s,Aa,l),U(Js,s,l),n(s,Ya,l),n(s,Us,l),n(s,Fa,l),n(s,w,l),o(w,Fl),o(w,Gt),U(is,w,null),o(w,Zt),o(w,xl),o(w,Nt),U(Ts,w,null),o(w,gt),U(js,w,null),o(w,Rt),o(w,vl),o(w,Wt),U(os,w,null),o(w,Vt),o(w,_l),o(w,zt),U(ws,w,null),o(w,Qt),o(w,Hl),o(w,Xt),U(hs,w,null),o(w,kt),o(w,Dl),o(w,ft),U(rs,w,null),o(w,Et),U(ms,w,null),o(w,St),o(w,$l),o(w,At),U(us,w,null),o(w,Yt),o(w,ql),o(w,Ft),U(ds,w,null),o(w,xt),o(w,Ll),o(w,vt),U(bs,w,null),n(s,xa,l),U(Is,s,l),n(s,va,l),n(s,Bs,l),n(s,_a,l),n(s,Cs,l),n(s,Ha,l),n(s,Da,l),n(s,$a,l),U(Gs,s,l),n(s,qa,l),n(s,Zs,l),n(s,La,l),U(Ns,s,l),n(s,Oa,l),n(s,gs,l),n(s,Pa,l),U(Rs,s,l),n(s,Ka,l),n(s,Ws,l),n(s,sn,l),n(s,Z,l),o(Z,Ol),o(Z,_t),U(Vs,Z,null),n(s,ln,l),U(zs,s,l),n(s,an,l),n(s,Qs,l),n(s,nn,l),n(s,Xs,l),n(s,tn,l),U(ks,s,l),n(s,en,l),n(s,fs,l),n(s,Mn,l),n(s,N,l),o(N,Pl),o(N,Ht),U(Es,N,null),n(s,pn,l),U(Ss,s,l),n(s,yn,l),n(s,As,l),n(s,cn,l),U(Ys,s,l),n(s,Jn,l),n(s,g,l),o(g,Kl),o(g,Dt),U(Fs,g,null),n(s,Un,l),n(s,Tn,l),n(s,jn,l),U(xs,s,l),n(s,on,l),n(s,vs,l),n(s,wn,l),n(s,R,l),n(s,hn,l),U(_s,s,l),n(s,rn,l),n(s,Hs,l),n(s,mn,l),U(Ds,s,l),n(s,un,l),U($s,s,l),n(s,dn,l),U(qs,s,l),n(s,bn,l),n(s,Ls,l),n(s,In,l),U(Os,s,l),n(s,Bn,l),n(s,W,l),o(W,sa),o(W,$t),U(Ps,W,null),n(s,Cn,l),U(Ks,s,l),n(s,Gn,l),n(s,sl,l),n(s,Zn,l),U(ll,s,l),n(s,Nn,l),U(al,s,l),n(s,gn,l),U(nl,s,l),n(s,Rn,l),n(s,tl,l),n(s,Wn,l),U(el,s,l),n(s,Vn,l),U(Ml,s,l),n(s,zn,l),n(s,pl,l),n(s,Qn,l),U(yl,s,l),n(s,Xn,l),n(s,cl,l),n(s,kn,l),U(Jl,s,l),n(s,fn,l),U(Ul,s,l),n(s,En,l),n(s,il,l),n(s,Sn,l),U(Tl,s,l),n(s,An,l),n(s,Yn,l),n(s,Fn,l),U(jl,s,l),n(s,xn,l),n(s,ol,l),n(s,vn,l),n(s,wl,l),n(s,_n,l),n(s,hl,l),n(s,Hn,l),U(rl,s,l),n(s,Dn,l),n(s,ml,l),n(s,$n,l),U(ul,s,l),n(s,qn,l),n(s,dl,l),n(s,Ln,l),U(bl,s,l),n(s,On,l),U(Il,s,l),n(s,Pn,l),n(s,Bl,l),n(s,Kn,l),n(s,Cl,l),n(s,st,l),n(s,Gl,l),n(s,lt,l),n(s,Zl,l),n(s,at,l),n(s,Nl,l),n(s,nt,l),n(s,gl,l),n(s,tt,l),U(Rl,s,l),n(s,et,l),n(s,Wl,l),n(s,Mt,l),n(s,Vl,l),n(s,pt,l),n(s,zl,l),n(s,yt,l),U(Ql,s,l),n(s,ct,l),n(s,Xl,l),n(s,Jt,l),U(kl,s,l),n(s,Ut,l),n(s,na,l),it=!0},p:JM,i(s){it||(i(V.$$.fragment,s),i(z.$$.fragment,s),i(X.$$.fragment,s),i(E.$$.fragment,s),i(Y.$$.fragment,s),i(x.$$.fragment,s),i(_.$$.fragment,s),i(D.$$.fragment,s),i($.$$.fragment,s),i(L.$$.fragment,s),i(P.$$.fragment,s),i(K.$$.fragment,s),i(ls.$$.fragment,s),i(as.$$.fragment,s),i(ns.$$.fragment,s),i(es.$$.fragment,s),i(ps.$$.fragment,s),i(ys.$$.fragment,s),i(Js.$$.fragment,s),i(is.$$.fragment,s),i(Ts.$$.fragment,s),i(js.$$.fragment,s),i(os.$$.fragment,s),i(ws.$$.fragment,s),i(hs.$$.fragment,s),i(rs.$$.fragment,s),i(ms.$$.fragment,s),i(us.$$.fragment,s),i(ds.$$.fragment,s),i(bs.$$.fragment,s),i(Is.$$.fragment,s),i(Gs.$$.fragment,s),i(Ns.$$.fragment,s),i(Rs.$$.fragment,s),i(Vs.$$.fragment,s),i(zs.$$.fragment,s),i(ks.$$.fragment,s),i(Es.$$.fragment,s),i(Ss.$$.fragment,s),i(Ys.$$.fragment,s),i(Fs.$$.fragment,s),i(xs.$$.fragment,s),i(_s.$$.fragment,s),i(Ds.$$.fragment,s),i($s.$$.fragment,s),i(qs.$$.fragment,s),i(Os.$$.fragment,s),i(Ps.$$.fragment,s),i(Ks.$$.fragment,s),i(ll.$$.fragment,s),i(al.$$.fragment,s),i(nl.$$.fragment,s),i(el.$$.fragment,s),i(Ml.$$.fragment,s),i(yl.$$.fragment,s),i(Jl.$$.fragment,s),i(Ul.$$.fragment,s),i(Tl.$$.fragment,s),i(jl.$$.fragment,s),i(rl.$$.fragment,s),i(ul.$$.fragment,s),i(bl.$$.fragment,s),i(Il.$$.fragment,s),i(Rl.$$.fragment,s),i(Ql.$$.fragment,s),i(kl.$$.fragment,s),it=!0)},o(s){T(V.$$.fragment,s),T(z.$$.fragment,s),T(X.$$.fragment,s),T(E.$$.fragment,s),T(Y.$$.fragment,s),T(x.$$.fragment,s),T(_.$$.fragment,s),T(D.$$.fragment,s),T($.$$.fragment,s),T(L.$$.fragment,s),T(P.$$.fragment,s),T(K.$$.fragment,s),T(ls.$$.fragment,s),T(as.$$.fragment,s),T(ns.$$.fragment,s),T(es.$$.fragment,s),T(ps.$$.fragment,s),T(ys.$$.fragment,s),T(Js.$$.fragment,s),T(is.$$.fragment,s),T(Ts.$$.fragment,s),T(js.$$.fragment,s),T(os.$$.fragment,s),T(ws.$$.fragment,s),T(hs.$$.fragment,s),T(rs.$$.fragment,s),T(ms.$$.fragment,s),T(us.$$.fragment,s),T(ds.$$.fragment,s),T(bs.$$.fragment,s),T(Is.$$.fragment,s),T(Gs.$$.fragment,s),T(Ns.$$.fragment,s),T(Rs.$$.fragment,s),T(Vs.$$.fragment,s),T(zs.$$.fragment,s),T(ks.$$.fragment,s),T(Es.$$.fragment,s),T(Ss.$$.fragment,s),T(Ys.$$.fragment,s),T(Fs.$$.fragment,s),T(xs.$$.fragment,s),T(_s.$$.fragment,s),T(Ds.$$.fragment,s),T($s.$$.fragment,s),T(qs.$$.fragment,s),T(Os.$$.fragment,s),T(Ps.$$.fragment,s),T(Ks.$$.fragment,s),T(ll.$$.fragment,s),T(al.$$.fragment,s),T(nl.$$.fragment,s),T(el.$$.fragment,s),T(Ml.$$.fragment,s),T(yl.$$.fragment,s),T(Jl.$$.fragment,s),T(Ul.$$.fragment,s),T(Tl.$$.fragment,s),T(jl.$$.fragment,s),T(rl.$$.fragment,s),T(ul.$$.fragment,s),T(bl.$$.fragment,s),T(Il.$$.fragment,s),T(Rl.$$.fragment,s),T(Ql.$$.fragment,s),T(kl.$$.fragment,s),it=!1},d(s){s&&(a(ta),a(aa),a(ea),a(Ma),a(pa),a(Q),a(ya),a(ca),a(k),a(Ja),a(f),a(Ua),a(ia),a(Ta),a(ja),a(S),a(oa),a(A),a(wa),a(ha),a(I),a(ra),a(F),a(ma),a(ua),a(v),a(da),a(ba),a(H),a(Ia),a(B),a(Ba),a(Ca),a(q),a(Ga),a(Za),a(O),a(Na),a(d),a(ga),a(Ra),a(ss),a(Wa),a(Va),a(C),a(za),a(Qa),a(ts),a(Xa),a(ka),a(Ms),a(fa),a(G),a(Ea),a(Sa),a(cs),a(Aa),a(Ya),a(Us),a(Fa),a(w),a(xa),a(va),a(Bs),a(_a),a(Cs),a(Ha),a(Da),a($a),a(qa),a(Zs),a(La),a(Oa),a(gs),a(Pa),a(Ka),a(Ws),a(sn),a(Z),a(ln),a(an),a(Qs),a(nn),a(Xs),a(tn),a(en),a(fs),a(Mn),a(N),a(pn),a(yn),a(As),a(cn),a(Jn),a(g),a(Un),a(Tn),a(jn),a(on),a(vs),a(wn),a(R),a(hn),a(rn),a(Hs),a(mn),a(un),a(dn),a(bn),a(Ls),a(In),a(Bn),a(W),a(Cn),a(Gn),a(sl),a(Zn),a(Nn),a(gn),a(Rn),a(tl),a(Wn),a(Vn),a(zn),a(pl),a(Qn),a(Xn),a(cl),a(kn),a(fn),a(En),a(il),a(Sn),a(An),a(Yn),a(Fn),a(xn),a(ol),a(vn),a(wl),a(_n),a(hl),a(Hn),a(Dn),a(ml),a($n),a(qn),a(dl),a(Ln),a(On),a(Pn),a(Bl),a(Kn),a(Cl),a(st),a(Gl),a(lt),a(Zl),a(at),a(Nl),a(nt),a(gl),a(tt),a(et),a(Wl),a(Mt),a(Vl),a(pt),a(zl),a(yt),a(ct),a(Xl),a(Jt),a(Ut),a(na)),a(b),j(V,s),j(z,s),j(X,s),j(E,s),j(Y,s),j(x,s),j(_,s),j(D),j($,s),j(L,s),j(P),j(K,s),j(ls,s),j(as),j(ns,s),j(es,s),j(ps),j(ys,s),j(Js,s),j(is),j(Ts),j(js),j(os),j(ws),j(hs),j(rs),j(ms),j(us),j(ds),j(bs),j(Is,s),j(Gs,s),j(Ns,s),j(Rs,s),j(Vs),j(zs,s),j(ks,s),j(Es),j(Ss,s),j(Ys,s),j(Fs),j(xs,s),j(_s,s),j(Ds,s),j($s,s),j(qs,s),j(Os,s),j(Ps),j(Ks,s),j(ll,s),j(al,s),j(nl,s),j(el,s),j(Ml,s),j(yl,s),j(Jl,s),j(Ul,s),j(Tl,s),j(jl,s),j(rl,s),j(ul,s),j(bl,s),j(Il,s),j(Rl,s),j(Ql,s),j(kl,s)}}}const rM='{"title":"Hands-On Exercises: Fine-Tuning SmolLM3","local":"hands-on-exercises-fine-tuning-smollm3","sections":[{"title":"Learning Objectives","local":"learning-objectives","sections":[],"depth":2},{"title":"Exercise 1: Exploring SmolLM3’s Chat Templates","local":"exercise-1-exploring-smollm3s-chat-templates","sections":[{"title":"Environment Setup","local":"environment-setup","sections":[],"depth":3},{"title":"Load SmolLM3 Models","local":"load-smollm3-models","sections":[],"depth":3},{"title":"Explore Chat Template Formatting","local":"explore-chat-template-formatting","sections":[],"depth":3},{"title":"Compare Base vs Instruct Model Responses","local":"compare-base-vs-instruct-model-responses","sections":[],"depth":3},{"title":"Test Dual-Mode Reasoning","local":"test-dual-mode-reasoning","sections":[],"depth":3}],"depth":2},{"title":"× 24","local":"-24","sections":[],"depth":2},{"title":"× 24","local":"-24","sections":[],"depth":2},{"title":"× 24","local":"-24","sections":[],"depth":2},{"title":"300 (15 × 20)","local":"300-15--20","sections":[],"depth":2},{"title":"× 24","local":"-24","sections":[],"depth":2},{"title":"300 (15 × 20)","local":"300-15--20","sections":[{"title":"Validation","local":"validation","sections":[],"depth":3}],"depth":2},{"title":"Exercise 2: Dataset Processing for SFT","local":"exercise-2-dataset-processing-for-sft","sections":[{"title":"Explore the SmolTalk2 Dataset","local":"explore-the-smoltalk2-dataset","sections":[],"depth":3},{"title":"Process Different Dataset Types","local":"process-different-dataset-types","sections":[],"depth":3},{"title":"Apply Chat Templates to Datasets","local":"apply-chat-templates-to-datasets","sections":[],"depth":3}],"depth":2},{"title":"Exercise 3: Fine-Tuning SmolLM3 with SFTTrainer","local":"exercise-3-fine-tuning-smollm3-with-sfttrainer","sections":[{"title":"Step 1: Setup and Model Loading","local":"step-1-setup-and-model-loading","sections":[],"depth":3},{"title":"Dataset Preparation","local":"dataset-preparation","sections":[],"depth":3},{"title":"Training Configuration","local":"training-configuration","sections":[],"depth":3},{"title":"Optional: Train with LoRA/PEFT (memory-efficient)","local":"optional-train-with-lorapeft-memory-efficient","sections":[],"depth":3},{"title":"Step 4: Initialize SFTTrainer and Train","local":"step-4-initialize-sfttrainer-and-train","sections":[],"depth":3},{"title":"Test the Fine-Tuned Model","local":"test-the-fine-tuned-model","sections":[],"depth":3}],"depth":2},{"title":"Exercise 4: Production Workflow with TRL CLI","local":"exercise-4-production-workflow-with-trl-cli","sections":[{"title":"Troubleshooting","local":"troubleshooting","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"Resources for Further Learning","local":"resources-for-further-learning","sections":[],"depth":2}],"depth":1}';function mM(qt){return UM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class CM extends iM{constructor(b){super(),TM(this,b,mM,hM,cM,{})}}export{CM as component};
