# Bienvenido al 🤗 smol-course

![Fine-Tuning Course thumbnail](https://github.com/huggingface/smol-course/blob/main/banner.png?raw=true)

¡Bienvenido al curso completo (y el más pequeño) sobre **el Fine-tuning de Modelos de Lenguaje**!

Este curso gratuito te llevará por una aventura, desde principiante hasta experto, en la comprensión, implementación y optimización de técnicas de fine-tuning para modelos extensos de lenguaje

Esta primera unidad te ayudará a incorporarte:

- Descubre el **programa del curso**.
- **Obtén más información sobre el proceso de certificación y el calendario**.
- Conoce al equipo que está detrás del curso.
- Crea tu **cuenta**.
- **Regístrate en nuestro servidor de Discord** y conoce a tus compañeros de clase y a nosotros.

¡Empecemos!

> [!TIP]
> ¡Este curso es pequeño pero intenso! Está dirigido a desarrolladores de software e ingenieros que desean acelerar el perfeccionamiento de sus habilidades en fine-tuning de modelos de lenguaje grande (LLM). Si no es tu caso, echa un vistazo al [Curso LLM](https://huggingface.co/learn/llm-course/).

## ¿Qué puedes esperar de este curso?

En este curso, podrás:

- 📖 Estudiar el ajuste por instrucciones, fine-tuning supervisado, y la alineación de preferencias en la teoría y en la práctica.
- 🧑‍💻 Aprender a usar frameworks y herramientas como TRL y Transformers.
- 💾 Compartir tus proyectos y explorar aplicaciones de fine-tuning creadas por la comunidad.
- 🏆 Participar en retos en los que evaluarás tus modelos ajustados frente a los de otros estudiantes.
- 🎓 Conseguir un certificado de finalización al completar las tareas.

Al terminar este curso, comprenderás **cómo ajustar los modelos de lenguaje de manera eficaz y crear aplicaciones de IA especializadas utilizando las últimas técnicas de fine-tuning**.

¡No olvides [**inscribirte al curso!**](https://huggingface.co/smol-course)

## ¿Cómo es el curso?

El curso se compone de:

- _Unidades fundamentales_: donde aprenderás **conceptos teóricos** sobre el fine-tuning.

* _Prácticas_: donde aprenderás **a utilizar frameworks de fine-tuning establecidos** para adaptar tus modelos. Estas secciones prácticas contarán con entornos preconfigurados.
* _Tareas de casos prácticos_: donde aplicarás los conceptos que has aprendido para resolver un problema del mundo real que tú mismo elegirás.
* _Colaboraciones_: colaboramos con los socios de Hugging Face para ofrecerte las últimas implementaciones y herramientas de fine-tuning.

Este **curso es un proyecto vivo, que evoluciona con tus comentarios y contribuciones.** No dudes en abrir issues y Pull Requests en GitHub, y participa en los debates en nuestro servidor de Discord.

## Cual es el plan de estudio?

Aquí está el **plan de estudio general del curso**. Se publicará una lista más detallada de temas con cada unidad.

| #   | Tema                       | Descripción                                                                      | Fecha de publicación |
| --- | -------------------------- | -------------------------------------------------------------------------------- | -------------------- |
| 1   | Ajuste por Instrucciones   | Fine-tuning supervisado, plantillas de chat, seguimiento de instrucciones        | ✅                   |
| 2   | Evaluación                 | Puntos de referencia y evaluación de dominios personalizados                     | Septiembre           |
| 3   | Alineación de Preferencias | Alineación de modelos con las preferencias humanas mediante algoritmos como DPO. | Octubre              |
| 4   | Aprendizaje por Refuerzo   | Optimización de modelos basados en políticas de refuerzo.                        | Octubre              |
| 5   | Modelos de Lenguaje Visual | Adaptación y uso de modelos multimodales                                         | Noviembre            |
| 6   | Datos Sintéticos           | Generación de conjuntos de datos sintéticos para dominios personalizados         | Noviembre            |
| 7   | Ceremonia de Premiación    | Presentación de proyectos y celebración                                          | Diciembre            |

## ¿Cuáles son los requisitos previos?

Para poder seguir este curso, debes tener:

- Conocimientos básicos sobre los conceptos de IA y LLM.
- Familiaridad con la programación en Python y los fundamentos del machine learning.
- Experiencia con PyTorch o frameworks de aprendizaje profundo similares.
- Conocimientos básicos sobre la arquitectura de los transformadores.

Si no cumples ninguno de estos requisitos, no te preocupes. Echa un vistazo al [Curso LLM](https://huggingface.co/learn/llm-course/) para empezar.

> [!TIP]
> Los cursos anteriores no son requisitos previos en sí mismos, por lo que si comprendes los conceptos de modelos extensos de lenguaje y transformadores, ¡puedes comenzar el curso ahora mismo!

## ¿Qué herramientas necesito?

Solo necesitas dos cosas:

- _Un ordenador_ con conexión a Internet y, preferiblemente, acceso a un GPU ([Hugging Face Pro](https://huggingface.co/pro) funciona muy bien).
- Una _cuenta_: para acceder a los recursos del curso y crear proyectos. Si aún no tienes una cuenta, puedes crear una [aquí](https://huggingface.co/join) (es gratis).

## El proceso de certificación

Puedes elegir entre seguir este curso _de oyente_ o realizar las actividades y _obtener uno de los dos certificados que emitimos_. Si eliges completar de oyente el curso, puedes participar en todos los retos y realizar las tareas si lo deseas, y **no es necesario que nos lo notifiques**.

El proceso de certificación es **totalmente gratuito**:

- _Para obtener una certificación de fundamentos_: debes completar la Unidad 1 del curso. Está dirigida a estudiantes que desean comprender los conceptos básicos del ajuste de instrucciones sin crear aplicaciones avanzadas.
- _Para obtener un certificado de completación_: debes completar todas las unidades del curso y enviar un proyecto final. Está dirigida a estudiantes que desean demostrar su dominio de las técnicas de fine-tuning.

## ¿Cuál es el ritmo recomendado?

Cada capítulo de este curso está diseñado **para completarse en una semana, con aproximadamente 3-4 horas de trabajo semanales**.

Dado que hay una fecha límite, te proporcionamos un ritmo recomendado:

![Miniatura del curso de ajuste fino](https://github.com/huggingface/smol-course/blob/rerelease-chapter-1/schedule.png?raw=true)

## ¿Cómo aprovechar al máximo al curso?

Para aprovechar al máximo al curso, te ofrecemos algunos consejos:

1. [Únete a grupos de estudio en Discord](https://discord.gg/UrrTSsSyjb): Estudiar en grupo siempre es más fácil. Para ello, debes unirte a nuestro servidor de Discord y verificar tu cuenta.
2. **Realiza los cuestionarios y las tareas**: La mejor manera de aprender es mediante la práctica y la autoevaluación.
3. **Establece un horario para mantenerte al día**: Puedes utilizar nuestro calendario recomendado a continuación o crear el tuyo propio.

![Consejos para el curso](https://huggingface.co/datasets/mcp-course/images/resolve/main/unit0/3.png)

## Quiénes somos

Acerca de los autores:

### Ben Burtenshaw

Ben es ingeniero de Machine Learning en Hugging Face y se dedica a crear aplicaciones de modelos extensos de lenguaje, con enfoques de post-entrenamiento y agenciales. [Sigue a Ben en el Hub](https://huggingface.co/burtenshaw) para ver sus últimos proyectos.

## Agradecimientos

Nos gustaría expresar nuestro agradecimiento a las siguientes personas y socios por sus valiosas contribuciones y su apoyo:

- [Hugging Face Transformers](https://huggingface.co/docs/transformers)
- [TRL (Transformer Reinforcement Learning)](https://huggingface.co/docs/trl)
- [PEFT (Parameter-Efficient Fine-Tuning)](https://huggingface.co/docs/peft)

## He encontrado un error o quiero mejorar el curso

Las contribuciones son **bienvenidas** 🤗

- Si _has encontrado un error 🐛 en un notebook_, por favor [abre un issue](https://github.com/huggingface/smol-course/issues/new) y **describe el issue**.
- Si _quieres mejorar el curso_, puedes [abrir un Pull Request](https://github.com/huggingface/smol-course/pulls) .
- Si _quieres añadir una sección completa o una nueva unidad_, lo mejor es [abrir un ticket](https://github.com/huggingface/smol-course/issues/new) y **describir qué contenido quieres añadir antes de empezar a escribirlo para que podamos orientarte**.

## Todavía tengo preguntas

Por favor, haz tu pregunta en nuestro servidor de Discord #fine-tuning-course-questions.

Ahora que tienes toda la información, ¡vamos a ponernos en marcha! ⛵


<EditOnGithub source="https://github.com/huggingface/smol-course/blob/main/units/es/unit0/1.md" />