import{s as Ml,o as dl,n as Be}from"../chunks/scheduler.8c3d61f6.js";import{S as ul,i as fl,g as p,s as n,r as M,A as yl,h as o,f as l,c as a,j as rl,u as d,x as r,k as cl,y as hl,a as s,v as u,d as f,t as y,w as h}from"../chunks/index.da70eac4.js";import{T as Ze}from"../chunks/Tip.1d9b8c37.js";import{C as j}from"../chunks/CodeBlock.00a903b3.js";import{H as Z,E as wl}from"../chunks/EditOnGithub.1e64e623.js";function Jl(U){let i,J='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-15lbm2y"&&(i.innerHTML=J)},m(m,c){s(m,i,c)},p:Be,d(m){m&&l(i)}}}function Tl(U){let i,J='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1yyrc0t"&&(i.innerHTML=J)},m(m,c){s(m,i,c)},p:Be,d(m){m&&l(i)}}}function Ul(U){let i,J='When using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',m,c,b='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){i=p("p"),i.innerHTML=J,m=n(),c=p("p"),c.innerHTML=b},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-pysjic"&&(i.innerHTML=J),m=a(w),c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1zrt6x"&&(c.innerHTML=b)},m(w,T){s(w,i,T),s(w,m,T),s(w,c,T)},p:Be,d(w){w&&(l(i),l(m),l(c))}}}function bl(U){let i,J="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){i=p("p"),i.textContent=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1guxtqy"&&(i.textContent=J)},m(m,c){s(m,i,c)},p:Be,d(m){m&&l(i)}}}function jl(U){let i,J='In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more information.',m,c,b='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){i=p("p"),i.innerHTML=J,m=n(),c=p("p"),c.innerHTML=b},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-bljvwk"&&(i.innerHTML=J),m=a(w),c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1rrcfel"&&(c.innerHTML=b)},m(w,T){s(w,i,T),s(w,m,T),s(w,c,T)},p:Be,d(w){w&&(l(i),l(m),l(c))}}}function Zl(U){let i,J="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){i=p("p"),i.innerHTML=J},l(m){i=o(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-17vr965"&&(i.innerHTML=J)},m(m,c){s(m,i,c)},p:Be,d(m){m&&l(i)}}}function Bl(U){let i,J,m,c,b,w,T,It="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",Ce,B,Ie,v,_t="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",_e,W,Gt="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",Ge,V,ve,$,vt='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',We,k,Wt='To use sliced VAE, call <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.StableUnCLIPPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',Ve,R,$e,X,Vt="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",ke,Y,Re,S,$t='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',Xe,E,kt='To use tiled VAE processing, call <a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',Ye,N,Se,Q,Rt="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",Ee,x,Ne,H,Xt="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",Qe,z,Yt='To perform CPU offloading, call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',xe,F,He,A,St="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",ze,g,Fe,C,Ae,q,qe,I,Le,L,Et='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',Pe,P,Nt="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",De,D,Qt=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,Ke,K,xt='Enable model offloading by calling <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',Oe,O,et,_,tt,ee,lt,te,Ht="PyTorch supports <code>torch.float8_e4m3fn</code> and <code>torch.float8_e5m2</code> as weight storage dtypes, but they can’t be used for computation in many different tensor operations due to unimplemented kernel support. However, you can use these dtypes to store model weights in fp8 precision and upcast them on-the-fly when the layers are used in the forward pass. This is known as layerwise weight-casting.",st,le,zt="Typically, inference on most models is done with <code>torch.float16</code> or <code>torch.bfloat16</code> weight/computation precision. Layerwise weight-casting cuts down the memory footprint of the model weights by approximately half.",nt,se,at,ne,Ft="In the above example, layerwise casting is enabled on the transformer component of the pipeline. By default, certain layers are skipped from the FP8 weight casting because it can lead to significant degradation of generation quality. The normalization and modulation related weight parameters are also skipped by default.",it,ae,At='However, you gain more control and flexibility by directly utilizing the <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_layerwise_casting">apply_layerwise_casting()</a> function instead of <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_layerwise_casting">enable_layerwise_casting()</a>.',pt,ie,ot,pe,qt="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",mt,oe,Lt="For example, to set the pipeline’s UNet to use the channels-last format:",rt,me,ct,re,Mt,ce,Pt="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",dt,Me,Dt="To trace a UNet:",ut,de,ft,ue,Kt="Replace the <code>unet</code> attribute of the pipeline with the traced model:",yt,fe,ht,ye,wt,he,Ot='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',Jt,G,Tt,we,el="To use Flash Attention, install the following:",Ut,Je,tl='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',bt,Te,ll='Then call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',jt,Ue,Zt,be,sl='The iteration speed when using <code>xformers</code> should match the iteration speed of PyTorch 2.0 as described <a href="torch2.0">here</a>.',Bt,je,gt,ge,Ct;return b=new Z({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),B=new Ze({props:{$$slots:{default:[Jl]},$$scope:{ctx:U}}}),V=new Z({props:{title:"Sliced VAE",local:"sliced-vae",headingTag:"h2"}}),R=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUyM3BpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyMColMjAzMikuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>
images = pipe([prompt] * <span class="hljs-number">32</span>).images`,wrap:!1}}),Y=new Z({props:{title:"Tiled VAE",local:"tiled-vae",headingTag:"h2"}}),N=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBiZWF1dGlmdWwlMjBsYW5kc2NhcGUlMjBwaG90b2dyYXBoJTIyJTBBcGlwZS5lbmFibGVfdmFlX3RpbGluZygpJTBBJTIzcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglNUJwcm9tcHQlNUQlMkMlMjB3aWR0aCUzRDM4NDAlMkMlMjBoZWlnaHQlM0QyMjI0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),x=new Z({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),F=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX3NlcXVlbnRpYWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),g=new Ze({props:{$$slots:{default:[Tl]},$$scope:{ctx:U}}}),C=new Ze({props:{warning:!0,$$slots:{default:[Ul]},$$scope:{ctx:U}}}),q=new Z({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),I=new Ze({props:{$$slots:{default:[bl]},$$scope:{ctx:U}}}),O=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_=new Ze({props:{warning:!0,$$slots:{default:[jl]},$$scope:{ctx:U}}}),ee=new Z({props:{title:"FP8 layerwise weight-casting",local:"fp8-layerwise-weight-casting",headingTag:"h2"}}),se=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline, CogVideoXTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>

<span class="hljs-comment"># Load the model in bfloat16 and enable layerwise casting</span>
transformer = CogVideoXTransformer3DModel.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16)
transformer.enable_layerwise_casting(storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16)

<span class="hljs-comment"># Load the pipeline</span>
pipe = CogVideoXPipeline.from_pretrained(model_id, transformer=transformer, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),ie=new Z({props:{title:"Channels-last memory format",local:"channels-last-memory-format",headingTag:"h2"}}),me=new j({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),re=new Z({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),de=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),fe=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLlRlbnNvciUwQSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjB1c2UlMjBqaXR0ZWQlMjB1bmV0JTBBdW5ldF90cmFjZWQlMjAlM0QlMjB0b3JjaC5qaXQubG9hZCglMjJ1bmV0X3RyYWNlZC5wdCUyMiklMEElMEElMEElMjMlMjBkZWwlMjBwaXBlLnVuZXQlMEFjbGFzcyUyMFRyYWNlZFVOZXQodG9yY2gubm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbl9jaGFubmVscyUyMCUzRCUyMHBpcGUudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRldmljZSUyMCUzRCUyMHBpcGUudW5ldC5kZXZpY2UlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHVuZXRfdHJhY2VkKGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFVOZXQyRENvbmRpdGlvbk91dHB1dChzYW1wbGUlM0RzYW1wbGUpJTBBJTBBJTBBcGlwZS51bmV0JTIwJTNEJTIwVHJhY2VkVU5ldCgpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDElMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.Tensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ye=new Z({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),G=new Ze({props:{$$slots:{default:[Zl]},$$scope:{ctx:U}}}),Ue=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwc2FtcGxlJTIwJTNEJTIwcGlwZSglMjJhJTIwc21hbGwlMjBjYXQlMjIpJTBBJTBBJTIzJTIwb3B0aW9uYWwlM0ElMjBZb3UlMjBjYW4lMjBkaXNhYmxlJTIwaXQlMjB2aWElMEElMjMlMjBwaXBlLmRpc2FibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),je=new wl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/memory.md"}}),{c(){i=p("meta"),J=n(),m=p("p"),c=n(),M(b.$$.fragment),w=n(),T=p("p"),T.textContent=It,Ce=n(),M(B.$$.fragment),Ie=n(),v=p("p"),v.textContent=_t,_e=n(),W=p("table"),W.innerHTML=Gt,Ge=n(),M(V.$$.fragment),ve=n(),$=p("p"),$.innerHTML=vt,We=n(),k=p("p"),k.innerHTML=Wt,Ve=n(),M(R.$$.fragment),$e=n(),X=p("p"),X.textContent=Vt,ke=n(),M(Y.$$.fragment),Re=n(),S=p("p"),S.innerHTML=$t,Xe=n(),E=p("p"),E.innerHTML=kt,Ye=n(),M(N.$$.fragment),Se=n(),Q=p("p"),Q.textContent=Rt,Ee=n(),M(x.$$.fragment),Ne=n(),H=p("p"),H.textContent=Xt,Qe=n(),z=p("p"),z.innerHTML=Yt,xe=n(),M(F.$$.fragment),He=n(),A=p("p"),A.innerHTML=St,ze=n(),M(g.$$.fragment),Fe=n(),M(C.$$.fragment),Ae=n(),M(q.$$.fragment),qe=n(),M(I.$$.fragment),Le=n(),L=p("p"),L.innerHTML=Et,Pe=n(),P=p("p"),P.innerHTML=Nt,De=n(),D=p("p"),D.textContent=Qt,Ke=n(),K=p("p"),K.innerHTML=xt,Oe=n(),M(O.$$.fragment),et=n(),M(_.$$.fragment),tt=n(),M(ee.$$.fragment),lt=n(),te=p("p"),te.innerHTML=Ht,st=n(),le=p("p"),le.innerHTML=zt,nt=n(),M(se.$$.fragment),at=n(),ne=p("p"),ne.textContent=Ft,it=n(),ae=p("p"),ae.innerHTML=At,pt=n(),M(ie.$$.fragment),ot=n(),pe=p("p"),pe.textContent=qt,mt=n(),oe=p("p"),oe.textContent=Lt,rt=n(),M(me.$$.fragment),ct=n(),M(re.$$.fragment),Mt=n(),ce=p("p"),ce.innerHTML=Pt,dt=n(),Me=p("p"),Me.textContent=Dt,ut=n(),M(de.$$.fragment),ft=n(),ue=p("p"),ue.innerHTML=Kt,yt=n(),M(fe.$$.fragment),ht=n(),M(ye.$$.fragment),wt=n(),he=p("p"),he.innerHTML=Ot,Jt=n(),M(G.$$.fragment),Tt=n(),we=p("p"),we.textContent=el,Ut=n(),Je=p("ul"),Je.innerHTML=tl,bt=n(),Te=p("p"),Te.innerHTML=ll,jt=n(),M(Ue.$$.fragment),Zt=n(),be=p("p"),be.innerHTML=sl,Bt=n(),M(je.$$.fragment),gt=n(),ge=p("p"),this.h()},l(e){const t=yl("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(l),J=a(e),m=o(e,"P",{}),rl(m).forEach(l),c=a(e),d(b.$$.fragment,e),w=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18ag1qn"&&(T.textContent=It),Ce=a(e),d(B.$$.fragment,e),Ie=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1nfsyhf"&&(v.textContent=_t),_e=a(e),W=o(e,"TABLE",{"data-svelte-h":!0}),r(W)!=="svelte-qiiy0g"&&(W.innerHTML=Gt),Ge=a(e),d(V.$$.fragment,e),ve=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-g37v30"&&($.innerHTML=vt),We=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1rxblqd"&&(k.innerHTML=Wt),Ve=a(e),d(R.$$.fragment,e),$e=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-fte8mn"&&(X.textContent=Vt),ke=a(e),d(Y.$$.fragment,e),Re=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1g0rx31"&&(S.innerHTML=$t),Xe=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1yciusa"&&(E.innerHTML=kt),Ye=a(e),d(N.$$.fragment,e),Se=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-nyzaca"&&(Q.textContent=Rt),Ee=a(e),d(x.$$.fragment,e),Ne=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-435lli"&&(H.textContent=Xt),Qe=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-z49dor"&&(z.innerHTML=Yt),xe=a(e),d(F.$$.fragment,e),He=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-153k8wf"&&(A.innerHTML=St),ze=a(e),d(g.$$.fragment,e),Fe=a(e),d(C.$$.fragment,e),Ae=a(e),d(q.$$.fragment,e),qe=a(e),d(I.$$.fragment,e),Le=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1w0xgx8"&&(L.innerHTML=Et),Pe=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-nislc4"&&(P.innerHTML=Nt),De=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-11gjm3"&&(D.textContent=Qt),Ke=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-op610o"&&(K.innerHTML=xt),Oe=a(e),d(O.$$.fragment,e),et=a(e),d(_.$$.fragment,e),tt=a(e),d(ee.$$.fragment,e),lt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-lwtukj"&&(te.innerHTML=Ht),st=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-r2gdi7"&&(le.innerHTML=zt),nt=a(e),d(se.$$.fragment,e),at=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-lgt48u"&&(ne.textContent=Ft),it=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1fq2kcg"&&(ae.innerHTML=At),pt=a(e),d(ie.$$.fragment,e),ot=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-sky5la"&&(pe.textContent=qt),mt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-mhdc10"&&(oe.textContent=Lt),rt=a(e),d(me.$$.fragment,e),ct=a(e),d(re.$$.fragment,e),Mt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1hj6sqj"&&(ce.innerHTML=Pt),dt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1ca1ko1"&&(Me.textContent=Dt),ut=a(e),d(de.$$.fragment,e),ft=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-mpebhd"&&(ue.innerHTML=Kt),yt=a(e),d(fe.$$.fragment,e),ht=a(e),d(ye.$$.fragment,e),wt=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1tu2ji2"&&(he.innerHTML=Ot),Jt=a(e),d(G.$$.fragment,e),Tt=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-rpfoyf"&&(we.textContent=el),Ut=a(e),Je=o(e,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-1q6gndt"&&(Je.innerHTML=tl),bt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-141yc6t"&&(Te.innerHTML=ll),jt=a(e),d(Ue.$$.fragment,e),Zt=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1nf2kxh"&&(be.innerHTML=sl),Bt=a(e),d(je.$$.fragment,e),gt=a(e),ge=o(e,"P",{}),rl(ge).forEach(l),this.h()},h(){cl(i,"name","hf:doc:metadata"),cl(i,"content",gl)},m(e,t){hl(document.head,i),s(e,J,t),s(e,m,t),s(e,c,t),u(b,e,t),s(e,w,t),s(e,T,t),s(e,Ce,t),u(B,e,t),s(e,Ie,t),s(e,v,t),s(e,_e,t),s(e,W,t),s(e,Ge,t),u(V,e,t),s(e,ve,t),s(e,$,t),s(e,We,t),s(e,k,t),s(e,Ve,t),u(R,e,t),s(e,$e,t),s(e,X,t),s(e,ke,t),u(Y,e,t),s(e,Re,t),s(e,S,t),s(e,Xe,t),s(e,E,t),s(e,Ye,t),u(N,e,t),s(e,Se,t),s(e,Q,t),s(e,Ee,t),u(x,e,t),s(e,Ne,t),s(e,H,t),s(e,Qe,t),s(e,z,t),s(e,xe,t),u(F,e,t),s(e,He,t),s(e,A,t),s(e,ze,t),u(g,e,t),s(e,Fe,t),u(C,e,t),s(e,Ae,t),u(q,e,t),s(e,qe,t),u(I,e,t),s(e,Le,t),s(e,L,t),s(e,Pe,t),s(e,P,t),s(e,De,t),s(e,D,t),s(e,Ke,t),s(e,K,t),s(e,Oe,t),u(O,e,t),s(e,et,t),u(_,e,t),s(e,tt,t),u(ee,e,t),s(e,lt,t),s(e,te,t),s(e,st,t),s(e,le,t),s(e,nt,t),u(se,e,t),s(e,at,t),s(e,ne,t),s(e,it,t),s(e,ae,t),s(e,pt,t),u(ie,e,t),s(e,ot,t),s(e,pe,t),s(e,mt,t),s(e,oe,t),s(e,rt,t),u(me,e,t),s(e,ct,t),u(re,e,t),s(e,Mt,t),s(e,ce,t),s(e,dt,t),s(e,Me,t),s(e,ut,t),u(de,e,t),s(e,ft,t),s(e,ue,t),s(e,yt,t),u(fe,e,t),s(e,ht,t),u(ye,e,t),s(e,wt,t),s(e,he,t),s(e,Jt,t),u(G,e,t),s(e,Tt,t),s(e,we,t),s(e,Ut,t),s(e,Je,t),s(e,bt,t),s(e,Te,t),s(e,jt,t),u(Ue,e,t),s(e,Zt,t),s(e,be,t),s(e,Bt,t),u(je,e,t),s(e,gt,t),s(e,ge,t),Ct=!0},p(e,[t]){const nl={};t&2&&(nl.$$scope={dirty:t,ctx:e}),B.$set(nl);const al={};t&2&&(al.$$scope={dirty:t,ctx:e}),g.$set(al);const il={};t&2&&(il.$$scope={dirty:t,ctx:e}),C.$set(il);const pl={};t&2&&(pl.$$scope={dirty:t,ctx:e}),I.$set(pl);const ol={};t&2&&(ol.$$scope={dirty:t,ctx:e}),_.$set(ol);const ml={};t&2&&(ml.$$scope={dirty:t,ctx:e}),G.$set(ml)},i(e){Ct||(f(b.$$.fragment,e),f(B.$$.fragment,e),f(V.$$.fragment,e),f(R.$$.fragment,e),f(Y.$$.fragment,e),f(N.$$.fragment,e),f(x.$$.fragment,e),f(F.$$.fragment,e),f(g.$$.fragment,e),f(C.$$.fragment,e),f(q.$$.fragment,e),f(I.$$.fragment,e),f(O.$$.fragment,e),f(_.$$.fragment,e),f(ee.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(me.$$.fragment,e),f(re.$$.fragment,e),f(de.$$.fragment,e),f(fe.$$.fragment,e),f(ye.$$.fragment,e),f(G.$$.fragment,e),f(Ue.$$.fragment,e),f(je.$$.fragment,e),Ct=!0)},o(e){y(b.$$.fragment,e),y(B.$$.fragment,e),y(V.$$.fragment,e),y(R.$$.fragment,e),y(Y.$$.fragment,e),y(N.$$.fragment,e),y(x.$$.fragment,e),y(F.$$.fragment,e),y(g.$$.fragment,e),y(C.$$.fragment,e),y(q.$$.fragment,e),y(I.$$.fragment,e),y(O.$$.fragment,e),y(_.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(me.$$.fragment,e),y(re.$$.fragment,e),y(de.$$.fragment,e),y(fe.$$.fragment,e),y(ye.$$.fragment,e),y(G.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),Ct=!1},d(e){e&&(l(J),l(m),l(c),l(w),l(T),l(Ce),l(Ie),l(v),l(_e),l(W),l(Ge),l(ve),l($),l(We),l(k),l(Ve),l($e),l(X),l(ke),l(Re),l(S),l(Xe),l(E),l(Ye),l(Se),l(Q),l(Ee),l(Ne),l(H),l(Qe),l(z),l(xe),l(He),l(A),l(ze),l(Fe),l(Ae),l(qe),l(Le),l(L),l(Pe),l(P),l(De),l(D),l(Ke),l(K),l(Oe),l(et),l(tt),l(lt),l(te),l(st),l(le),l(nt),l(at),l(ne),l(it),l(ae),l(pt),l(ot),l(pe),l(mt),l(oe),l(rt),l(ct),l(Mt),l(ce),l(dt),l(Me),l(ut),l(ft),l(ue),l(yt),l(ht),l(wt),l(he),l(Jt),l(Tt),l(we),l(Ut),l(Je),l(bt),l(Te),l(jt),l(Zt),l(be),l(Bt),l(gt),l(ge)),l(i),h(b,e),h(B,e),h(V,e),h(R,e),h(Y,e),h(N,e),h(x,e),h(F,e),h(g,e),h(C,e),h(q,e),h(I,e),h(O,e),h(_,e),h(ee,e),h(se,e),h(ie,e),h(me,e),h(re,e),h(de,e),h(fe,e),h(ye,e),h(G,e),h(Ue,e),h(je,e)}}}const gl='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Sliced VAE","local":"sliced-vae","sections":[],"depth":2},{"title":"Tiled VAE","local":"tiled-vae","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"FP8 layerwise weight-casting","local":"fp8-layerwise-weight-casting","sections":[],"depth":2},{"title":"Channels-last memory format","local":"channels-last-memory-format","sections":[],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function Cl(U){return dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vl extends ul{constructor(i){super(),fl(this,i,Cl,Bl,Ml,{})}}export{Vl as component};
